#!/usr/bin/env -S nvim -l

-- Validate vimdoc files on $VIMRUNTIME/doc, and test generating HTML docs.
-- Checks for duplicate/missing tags, parse errors, and invalid links/urls/spellings.
-- See also `make lintdoc`.
--
-- Usage:
--   $ nvim -l scripts/lintdoc.lua
--   $ make lintdoc

print('Running lintdoc ...')

-- gen_help_html.lua requires helptags to be generated in $VIMRUNTIME/doc.
-- :helptags also checks for duplicate tags.
-- 🤢 Load netrw so its tags are generated by :helptags.
vim.cmd [[ packadd netrw ]]
vim.cmd [[ helptags ALL ]]

require('src.gen.gen_help_html').run_validate(nil, _G.arg[1] ~= nil)
require('src.gen.gen_help_html').test_gen()

print('lintdoc PASSED.')
