/* A Bison parser, made by GNU Bison 3.8.2.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015, 2018-2021 Free Software Foundation,
   Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <https://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* DO NOT RELY ON FEATURES THAT ARE NOT DOCUMENTED in the manual,
   especially those whose name start with YY_ or yy_.  They are
   private implementation details that can be changed or removed.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output, and Bison version.  */
#define YYBISON 30802

/* Bison version string.  */
#define YYBISON_VERSION "3.8.2"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1




/* First part of user prologue.  */
#line 24 "parse.y"

#include "got_compat.h"

#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/queue.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <sys/un.h>

#include <net/if.h>
#include <netinet/in.h>

#include <arpa/inet.h>

#include <ctype.h>
#include <err.h>
#include <errno.h>
#include <event.h>
#include <ifaddrs.h>
#include <limits.h>
#include <netdb.h>
#include <stdarg.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <syslog.h>
#include <unistd.h>

#include "got_reference.h"
#include "got_object.h"
#include "got_path.h"
#include "got_error.h"

#include "media.h"
#include "gotwebd.h"
#include "log.h"

TAILQ_HEAD(files, file)		 files = TAILQ_HEAD_INITIALIZER(files);
static struct file {
	TAILQ_ENTRY(file)	 entry;
	FILE			*stream;
	char			*name;
	size_t			 ungetpos;
	size_t			 ungetsize;
	unsigned char		*ungetbuf;
	int			 eof_reached;
	int			 lineno;
	int			 errors;
} *file, *topfile;
struct file	*pushfile(const char *, int);
static int	 popfile(void);
int		 check_file_secrecy(int, const char *);
int		 yyparse(void);
int		 yylex(void);
int		 yyerror(const char *, ...)
    __attribute__((__format__ (printf, 1, 2)))
    __attribute__((__nonnull__ (1)));
int		 kw_cmp(const void *, const void *);
int		 lookup(char *);
int		 igetc(void);
int		 lgetc(int);
void		 lungetc(int);
int		 findeol(void);

TAILQ_HEAD(symhead, sym)	 symhead = TAILQ_HEAD_INITIALIZER(symhead);
struct sym {
	TAILQ_ENTRY(sym)	 entry;
	int			 used;
	int			 persist;
	char			*nam;
	char			*val;
};

int	 symset(const char *, const char *, int);
char	*symget(const char *);

static int		 errors;

static struct gotwebd		*gotwebd;
static struct server		*new_srv;
static struct server		*conf_new_server(const char *);
int				 getservice(const char *);
int				 n;
struct media_type		 media;

int		 get_addrs(const char *, const char *);
struct address *get_unix_addr(const char *);
int		 addr_dup_check(struct addresslist *, struct address *);
void		 add_addr(struct address *);

static struct website	*new_website;
static struct website	*conf_new_website(struct server *, const char *);

static struct gotwebd_repo	*new_repo;
static struct gotwebd_repo	*conf_new_repo(struct server *, const char *);
static void			 conf_new_access_rule(
				    struct gotwebd_access_rule_list *,
				    enum gotwebd_access, char *);


typedef struct {
	union {
		long long	 number;
		char		*string;
	} v;
	int lineno;
} YYSTYPE;

static int
mediatype_ok(const char *s)
{
	size_t i;

	for (i = 0; s[i] != '\0'; ++i) {
		if (!isalnum((unsigned char)s[i]) &&
		    s[i] != '-' && s[i] != '+' && s[i] != '.' &&
		    s[i] != '/')
			return (-1);
	}
	return (0);
}


#line 196 "parse.c"

# ifndef YY_CAST
#  ifdef __cplusplus
#   define YY_CAST(Type, Val) static_cast<Type> (Val)
#   define YY_REINTERPRET_CAST(Type, Val) reinterpret_cast<Type> (Val)
#  else
#   define YY_CAST(Type, Val) ((Type) (Val))
#   define YY_REINTERPRET_CAST(Type, Val) ((Type) (Val))
#  endif
# endif
# ifndef YY_NULLPTR
#  if defined __cplusplus
#   if 201103L <= __cplusplus
#    define YY_NULLPTR nullptr
#   else
#    define YY_NULLPTR 0
#   endif
#  else
#   define YY_NULLPTR ((void*)0)
#  endif
# endif


/* Debug traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif
#if YYDEBUG
extern int yydebug;
#endif

/* Token kinds.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
  enum yytokentype
  {
    YYEMPTY = -2,
    YYEOF = 0,                     /* "end of file"  */
    YYerror = 256,                 /* error  */
    YYUNDEF = 257,                 /* "invalid token"  */
    LISTEN = 258,                  /* LISTEN  */
    GOTWEBD_LOGIN = 259,           /* GOTWEBD_LOGIN  */
    WWW = 260,                     /* WWW  */
    SITE_NAME = 261,               /* SITE_NAME  */
    SITE_OWNER = 262,              /* SITE_OWNER  */
    SITE_LINK = 263,               /* SITE_LINK  */
    LOGO = 264,                    /* LOGO  */
    LOGO_URL = 265,                /* LOGO_URL  */
    SHOW_REPO_OWNER = 266,         /* SHOW_REPO_OWNER  */
    SHOW_REPO_AGE = 267,           /* SHOW_REPO_AGE  */
    SHOW_REPO_DESCRIPTION = 268,   /* SHOW_REPO_DESCRIPTION  */
    CLONE_URL = 269,               /* CLONE_URL  */
    MAX_REPOS_DISPLAY = 270,       /* MAX_REPOS_DISPLAY  */
    REPOS_PATH = 271,              /* REPOS_PATH  */
    MAX_COMMITS_DISPLAY = 272,     /* MAX_COMMITS_DISPLAY  */
    ON = 273,                      /* ON  */
    ERROR = 274,                   /* ERROR  */
    SHOW_SITE_OWNER = 275,         /* SHOW_SITE_OWNER  */
    SHOW_REPO_CLONEURL = 276,      /* SHOW_REPO_CLONEURL  */
    PORT = 277,                    /* PORT  */
    PREFORK = 278,                 /* PREFORK  */
    RESPECT_EXPORTOK = 279,        /* RESPECT_EXPORTOK  */
    SERVER = 280,                  /* SERVER  */
    CHROOT = 281,                  /* CHROOT  */
    CUSTOM_CSS = 282,              /* CUSTOM_CSS  */
    SOCKET = 283,                  /* SOCKET  */
    HINT = 284,                    /* HINT  */
    HTDOCS = 285,                  /* HTDOCS  */
    GOTWEB_URL_ROOT = 286,         /* GOTWEB_URL_ROOT  */
    SUMMARY_COMMITS_DISPLAY = 287, /* SUMMARY_COMMITS_DISPLAY  */
    SUMMARY_TAGS_DISPLAY = 288,    /* SUMMARY_TAGS_DISPLAY  */
    USER = 289,                    /* USER  */
    AUTHENTICATION = 290,          /* AUTHENTICATION  */
    ENABLE = 291,                  /* ENABLE  */
    DISABLE = 292,                 /* DISABLE  */
    INSECURE = 293,                /* INSECURE  */
    REPOSITORY = 294,              /* REPOSITORY  */
    REPOSITORIES = 295,            /* REPOSITORIES  */
    PERMIT = 296,                  /* PERMIT  */
    DENY = 297,                    /* DENY  */
    HIDE = 298,                    /* HIDE  */
    WEBSITE = 299,                 /* WEBSITE  */
    PATH = 300,                    /* PATH  */
    BRANCH = 301,                  /* BRANCH  */
    REPOS_URL_PATH = 302,          /* REPOS_URL_PATH  */
    DESCRIPTION = 303,             /* DESCRIPTION  */
    TYPES = 304,                   /* TYPES  */
    INCLUDE = 305,                 /* INCLUDE  */
    GOTWEBD_CONTROL = 306,         /* GOTWEBD_CONTROL  */
    SSH_HOSTKEY_ECDSA = 307,       /* SSH_HOSTKEY_ECDSA  */
    SSH_HOSTKEY_ED25519 = 308,     /* SSH_HOSTKEY_ED25519  */
    SSH_HOSTKEY_RSA = 309,         /* SSH_HOSTKEY_RSA  */
    STRING = 310,                  /* STRING  */
    NUMBER = 311                   /* NUMBER  */
  };
  typedef enum yytokentype yytoken_kind_t;
#endif
/* Token kinds.  */
#define YYEMPTY -2
#define YYEOF 0
#define YYerror 256
#define YYUNDEF 257
#define LISTEN 258
#define GOTWEBD_LOGIN 259
#define WWW 260
#define SITE_NAME 261
#define SITE_OWNER 262
#define SITE_LINK 263
#define LOGO 264
#define LOGO_URL 265
#define SHOW_REPO_OWNER 266
#define SHOW_REPO_AGE 267
#define SHOW_REPO_DESCRIPTION 268
#define CLONE_URL 269
#define MAX_REPOS_DISPLAY 270
#define REPOS_PATH 271
#define MAX_COMMITS_DISPLAY 272
#define ON 273
#define ERROR 274
#define SHOW_SITE_OWNER 275
#define SHOW_REPO_CLONEURL 276
#define PORT 277
#define PREFORK 278
#define RESPECT_EXPORTOK 279
#define SERVER 280
#define CHROOT 281
#define CUSTOM_CSS 282
#define SOCKET 283
#define HINT 284
#define HTDOCS 285
#define GOTWEB_URL_ROOT 286
#define SUMMARY_COMMITS_DISPLAY 287
#define SUMMARY_TAGS_DISPLAY 288
#define USER 289
#define AUTHENTICATION 290
#define ENABLE 291
#define DISABLE 292
#define INSECURE 293
#define REPOSITORY 294
#define REPOSITORIES 295
#define PERMIT 296
#define DENY 297
#define HIDE 298
#define WEBSITE 299
#define PATH 300
#define BRANCH 301
#define REPOS_URL_PATH 302
#define DESCRIPTION 303
#define TYPES 304
#define INCLUDE 305
#define GOTWEBD_CONTROL 306
#define SSH_HOSTKEY_ECDSA 307
#define SSH_HOSTKEY_ED25519 308
#define SSH_HOSTKEY_RSA 309
#define STRING 310
#define NUMBER 311

/* Value type.  */


extern YYSTYPE yylval;


int yyparse (void);



/* Symbol kind.  */
enum yysymbol_kind_t
{
  YYSYMBOL_YYEMPTY = -2,
  YYSYMBOL_YYEOF = 0,                      /* "end of file"  */
  YYSYMBOL_YYerror = 1,                    /* error  */
  YYSYMBOL_YYUNDEF = 2,                    /* "invalid token"  */
  YYSYMBOL_LISTEN = 3,                     /* LISTEN  */
  YYSYMBOL_GOTWEBD_LOGIN = 4,              /* GOTWEBD_LOGIN  */
  YYSYMBOL_WWW = 5,                        /* WWW  */
  YYSYMBOL_SITE_NAME = 6,                  /* SITE_NAME  */
  YYSYMBOL_SITE_OWNER = 7,                 /* SITE_OWNER  */
  YYSYMBOL_SITE_LINK = 8,                  /* SITE_LINK  */
  YYSYMBOL_LOGO = 9,                       /* LOGO  */
  YYSYMBOL_LOGO_URL = 10,                  /* LOGO_URL  */
  YYSYMBOL_SHOW_REPO_OWNER = 11,           /* SHOW_REPO_OWNER  */
  YYSYMBOL_SHOW_REPO_AGE = 12,             /* SHOW_REPO_AGE  */
  YYSYMBOL_SHOW_REPO_DESCRIPTION = 13,     /* SHOW_REPO_DESCRIPTION  */
  YYSYMBOL_CLONE_URL = 14,                 /* CLONE_URL  */
  YYSYMBOL_MAX_REPOS_DISPLAY = 15,         /* MAX_REPOS_DISPLAY  */
  YYSYMBOL_REPOS_PATH = 16,                /* REPOS_PATH  */
  YYSYMBOL_MAX_COMMITS_DISPLAY = 17,       /* MAX_COMMITS_DISPLAY  */
  YYSYMBOL_ON = 18,                        /* ON  */
  YYSYMBOL_ERROR = 19,                     /* ERROR  */
  YYSYMBOL_SHOW_SITE_OWNER = 20,           /* SHOW_SITE_OWNER  */
  YYSYMBOL_SHOW_REPO_CLONEURL = 21,        /* SHOW_REPO_CLONEURL  */
  YYSYMBOL_PORT = 22,                      /* PORT  */
  YYSYMBOL_PREFORK = 23,                   /* PREFORK  */
  YYSYMBOL_RESPECT_EXPORTOK = 24,          /* RESPECT_EXPORTOK  */
  YYSYMBOL_SERVER = 25,                    /* SERVER  */
  YYSYMBOL_CHROOT = 26,                    /* CHROOT  */
  YYSYMBOL_CUSTOM_CSS = 27,                /* CUSTOM_CSS  */
  YYSYMBOL_SOCKET = 28,                    /* SOCKET  */
  YYSYMBOL_HINT = 29,                      /* HINT  */
  YYSYMBOL_HTDOCS = 30,                    /* HTDOCS  */
  YYSYMBOL_GOTWEB_URL_ROOT = 31,           /* GOTWEB_URL_ROOT  */
  YYSYMBOL_SUMMARY_COMMITS_DISPLAY = 32,   /* SUMMARY_COMMITS_DISPLAY  */
  YYSYMBOL_SUMMARY_TAGS_DISPLAY = 33,      /* SUMMARY_TAGS_DISPLAY  */
  YYSYMBOL_USER = 34,                      /* USER  */
  YYSYMBOL_AUTHENTICATION = 35,            /* AUTHENTICATION  */
  YYSYMBOL_ENABLE = 36,                    /* ENABLE  */
  YYSYMBOL_DISABLE = 37,                   /* DISABLE  */
  YYSYMBOL_INSECURE = 38,                  /* INSECURE  */
  YYSYMBOL_REPOSITORY = 39,                /* REPOSITORY  */
  YYSYMBOL_REPOSITORIES = 40,              /* REPOSITORIES  */
  YYSYMBOL_PERMIT = 41,                    /* PERMIT  */
  YYSYMBOL_DENY = 42,                      /* DENY  */
  YYSYMBOL_HIDE = 43,                      /* HIDE  */
  YYSYMBOL_WEBSITE = 44,                   /* WEBSITE  */
  YYSYMBOL_PATH = 45,                      /* PATH  */
  YYSYMBOL_BRANCH = 46,                    /* BRANCH  */
  YYSYMBOL_REPOS_URL_PATH = 47,            /* REPOS_URL_PATH  */
  YYSYMBOL_DESCRIPTION = 48,               /* DESCRIPTION  */
  YYSYMBOL_TYPES = 49,                     /* TYPES  */
  YYSYMBOL_INCLUDE = 50,                   /* INCLUDE  */
  YYSYMBOL_GOTWEBD_CONTROL = 51,           /* GOTWEBD_CONTROL  */
  YYSYMBOL_SSH_HOSTKEY_ECDSA = 52,         /* SSH_HOSTKEY_ECDSA  */
  YYSYMBOL_SSH_HOSTKEY_ED25519 = 53,       /* SSH_HOSTKEY_ED25519  */
  YYSYMBOL_SSH_HOSTKEY_RSA = 54,           /* SSH_HOSTKEY_RSA  */
  YYSYMBOL_STRING = 55,                    /* STRING  */
  YYSYMBOL_NUMBER = 56,                    /* NUMBER  */
  YYSYMBOL_57_n_ = 57,                     /* '\n'  */
  YYSYMBOL_58_ = 58,                       /* '='  */
  YYSYMBOL_59_ = 59,                       /* '*'  */
  YYSYMBOL_60_ = 60,                       /* '{'  */
  YYSYMBOL_61_ = 61,                       /* '}'  */
  YYSYMBOL_62_ = 62,                       /* '/'  */
  YYSYMBOL_63_ = 63,                       /* ';'  */
  YYSYMBOL_YYACCEPT = 64,                  /* $accept  */
  YYSYMBOL_grammar = 65,                   /* grammar  */
  YYSYMBOL_include = 66,                   /* include  */
  YYSYMBOL_varset = 67,                    /* varset  */
  YYSYMBOL_numberstring = 68,              /* numberstring  */
  YYSYMBOL_boolean = 69,                   /* boolean  */
  YYSYMBOL_listen_addr = 70,               /* listen_addr  */
  YYSYMBOL_main = 71,                      /* main  */
  YYSYMBOL_server = 72,                    /* server  */
  YYSYMBOL_73_1 = 73,                      /* $@1  */
  YYSYMBOL_serveropts1 = 74,               /* serveropts1  */
  YYSYMBOL_serveropts2 = 75,               /* serveropts2  */
  YYSYMBOL_websiteopts2 = 76,              /* websiteopts2  */
  YYSYMBOL_websiteopts1 = 77,              /* websiteopts1  */
  YYSYMBOL_website = 78,                   /* website  */
  YYSYMBOL_79_2 = 79,                      /* $@2  */
  YYSYMBOL_repository = 80,                /* repository  */
  YYSYMBOL_81_3 = 81,                      /* $@3  */
  YYSYMBOL_repoopts2 = 82,                 /* repoopts2  */
  YYSYMBOL_repoopts1 = 83,                 /* repoopts1  */
  YYSYMBOL_types = 84,                     /* types  */
  YYSYMBOL_mediaopts_l = 85,               /* mediaopts_l  */
  YYSYMBOL_mediaoptsl = 86,                /* mediaoptsl  */
  YYSYMBOL_mediastring = 87,               /* mediastring  */
  YYSYMBOL_medianames_l = 88,              /* medianames_l  */
  YYSYMBOL_medianamesl = 89,               /* medianamesl  */
  YYSYMBOL_nl = 90,                        /* nl  */
  YYSYMBOL_optsemicolon = 91,              /* optsemicolon  */
  YYSYMBOL_optnl = 92                      /* optnl  */
};
typedef enum yysymbol_kind_t yysymbol_kind_t;




#ifdef short
# undef short
#endif

/* On compilers that do not define __PTRDIFF_MAX__ etc., make sure
   <limits.h> and (if available) <stdint.h> are included
   so that the code can choose integer types of a good width.  */

#ifndef __PTRDIFF_MAX__
# include <limits.h> /* INFRINGES ON USER NAME SPACE */
# if defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stdint.h> /* INFRINGES ON USER NAME SPACE */
#  define YY_STDINT_H
# endif
#endif

/* Narrow types that promote to a signed type and that can represent a
   signed or unsigned integer of at least N bits.  In tables they can
   save space and decrease cache pressure.  Promoting to a signed type
   helps avoid bugs in integer arithmetic.  */

#ifdef __INT_LEAST8_MAX__
typedef __INT_LEAST8_TYPE__ yytype_int8;
#elif defined YY_STDINT_H
typedef int_least8_t yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef __INT_LEAST16_MAX__
typedef __INT_LEAST16_TYPE__ yytype_int16;
#elif defined YY_STDINT_H
typedef int_least16_t yytype_int16;
#else
typedef short yytype_int16;
#endif

/* Work around bug in HP-UX 11.23, which defines these macros
   incorrectly for preprocessor constants.  This workaround can likely
   be removed in 2023, as HPE has promised support for HP-UX 11.23
   (aka HP-UX 11i v2) only through the end of 2022; see Table 2 of
   <https://h20195.www2.hpe.com/V2/getpdf.aspx/4AA4-7673ENW.pdf>.  */
#ifdef __hpux
# undef UINT_LEAST8_MAX
# undef UINT_LEAST16_MAX
# define UINT_LEAST8_MAX 255
# define UINT_LEAST16_MAX 65535
#endif

#if defined __UINT_LEAST8_MAX__ && __UINT_LEAST8_MAX__ <= __INT_MAX__
typedef __UINT_LEAST8_TYPE__ yytype_uint8;
#elif (!defined __UINT_LEAST8_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST8_MAX <= INT_MAX)
typedef uint_least8_t yytype_uint8;
#elif !defined __UINT_LEAST8_MAX__ && UCHAR_MAX <= INT_MAX
typedef unsigned char yytype_uint8;
#else
typedef short yytype_uint8;
#endif

#if defined __UINT_LEAST16_MAX__ && __UINT_LEAST16_MAX__ <= __INT_MAX__
typedef __UINT_LEAST16_TYPE__ yytype_uint16;
#elif (!defined __UINT_LEAST16_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST16_MAX <= INT_MAX)
typedef uint_least16_t yytype_uint16;
#elif !defined __UINT_LEAST16_MAX__ && USHRT_MAX <= INT_MAX
typedef unsigned short yytype_uint16;
#else
typedef int yytype_uint16;
#endif

#ifndef YYPTRDIFF_T
# if defined __PTRDIFF_TYPE__ && defined __PTRDIFF_MAX__
#  define YYPTRDIFF_T __PTRDIFF_TYPE__
#  define YYPTRDIFF_MAXIMUM __PTRDIFF_MAX__
# elif defined PTRDIFF_MAX
#  ifndef ptrdiff_t
#   include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  endif
#  define YYPTRDIFF_T ptrdiff_t
#  define YYPTRDIFF_MAXIMUM PTRDIFF_MAX
# else
#  define YYPTRDIFF_T long
#  define YYPTRDIFF_MAXIMUM LONG_MAX
# endif
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned
# endif
#endif

#define YYSIZE_MAXIMUM                                  \
  YY_CAST (YYPTRDIFF_T,                                 \
           (YYPTRDIFF_MAXIMUM < YY_CAST (YYSIZE_T, -1)  \
            ? YYPTRDIFF_MAXIMUM                         \
            : YY_CAST (YYSIZE_T, -1)))

#define YYSIZEOF(X) YY_CAST (YYPTRDIFF_T, sizeof (X))


/* Stored state numbers (used for stacks). */
typedef yytype_uint8 yy_state_t;

/* State numbers in computations.  */
typedef int yy_state_fast_t;

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif


#ifndef YY_ATTRIBUTE_PURE
# if defined __GNUC__ && 2 < __GNUC__ + (96 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_PURE __attribute__ ((__pure__))
# else
#  define YY_ATTRIBUTE_PURE
# endif
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# if defined __GNUC__ && 2 < __GNUC__ + (7 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_UNUSED __attribute__ ((__unused__))
# else
#  define YY_ATTRIBUTE_UNUSED
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YY_USE(E) ((void) (E))
#else
# define YY_USE(E) /* empty */
#endif

/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
#if defined __GNUC__ && ! defined __ICC && 406 <= __GNUC__ * 100 + __GNUC_MINOR__
# if __GNUC__ * 100 + __GNUC_MINOR__ < 407
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")
# else
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")              \
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# endif
# define YY_IGNORE_MAYBE_UNINITIALIZED_END      \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif

#if defined __cplusplus && defined __GNUC__ && ! defined __ICC && 6 <= __GNUC__
# define YY_IGNORE_USELESS_CAST_BEGIN                          \
    _Pragma ("GCC diagnostic push")                            \
    _Pragma ("GCC diagnostic ignored \"-Wuseless-cast\"")
# define YY_IGNORE_USELESS_CAST_END            \
    _Pragma ("GCC diagnostic pop")
#endif
#ifndef YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_END
#endif


#define YY_ASSERT(E) ((void) (0 && (E)))

#if !defined yyoverflow

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* !defined yyoverflow */

#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yy_state_t yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (YYSIZEOF (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (YYSIZEOF (yy_state_t) + YYSIZEOF (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYPTRDIFF_T yynewbytes;                                         \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * YYSIZEOF (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / YYSIZEOF (*yyptr);                        \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, YY_CAST (YYSIZE_T, (Count)) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYPTRDIFF_T yyi;                      \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  2
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   258

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  64
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  29
/* YYNRULES -- Number of rules.  */
#define YYNRULES  118
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  235

/* YYMAXUTOK -- Last valid token kind.  */
#define YYMAXUTOK   311


/* YYTRANSLATE(TOKEN-NUM) -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, with out-of-bounds checking.  */
#define YYTRANSLATE(YYX)                                \
  (0 <= (YYX) && (YYX) <= YYMAXUTOK                     \
   ? YY_CAST (yysymbol_kind_t, yytranslate[YYX])        \
   : YYSYMBOL_YYUNDEF)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex.  */
static const yytype_int8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
      57,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,    59,     2,     2,     2,     2,    62,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,    63,
       2,    58,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,    60,     2,    61,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56
};

#if YYDEBUG
/* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_int16 yyrline[] =
{
       0,   168,   168,   169,   170,   171,   172,   173,   174,   177,
     192,   210,   211,   220,   234,   235,   244,   245,   248,   256,
     279,   287,   303,   315,   321,   327,   335,   343,   351,   355,
     359,   373,   385,   405,   422,   453,   483,   497,   519,   541,
     565,   580,   580,   598,   608,   618,   628,   638,   647,   657,
     667,   670,   673,   676,   679,   682,   685,   688,   700,   720,
     728,   736,   744,   752,   761,   770,   779,   783,   787,   804,
     834,   864,   886,   908,   930,   931,   934,   935,   938,   939,
     941,   953,   973,   985,   994,  1003,  1012,  1016,  1022,  1022,
    1029,  1029,  1048,  1049,  1052,  1061,  1070,  1079,  1083,  1087,
    1090,  1101,  1112,  1134,  1156,  1180,  1183,  1184,  1187,  1188,
    1191,  1215,  1216,  1219,  1242,  1245,  1246,  1249,  1250
};
#endif

/** Accessing symbol of state STATE.  */
#define YY_ACCESSING_SYMBOL(State) YY_CAST (yysymbol_kind_t, yystos[State])

#if YYDEBUG || 0
/* The user-facing name of the symbol whose (internal) number is
   YYSYMBOL.  No bounds checking.  */
static const char *yysymbol_name (yysymbol_kind_t yysymbol) YY_ATTRIBUTE_UNUSED;

/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "\"end of file\"", "error", "\"invalid token\"", "LISTEN",
  "GOTWEBD_LOGIN", "WWW", "SITE_NAME", "SITE_OWNER", "SITE_LINK", "LOGO",
  "LOGO_URL", "SHOW_REPO_OWNER", "SHOW_REPO_AGE", "SHOW_REPO_DESCRIPTION",
  "CLONE_URL", "MAX_REPOS_DISPLAY", "REPOS_PATH", "MAX_COMMITS_DISPLAY",
  "ON", "ERROR", "SHOW_SITE_OWNER", "SHOW_REPO_CLONEURL", "PORT",
  "PREFORK", "RESPECT_EXPORTOK", "SERVER", "CHROOT", "CUSTOM_CSS",
  "SOCKET", "HINT", "HTDOCS", "GOTWEB_URL_ROOT", "SUMMARY_COMMITS_DISPLAY",
  "SUMMARY_TAGS_DISPLAY", "USER", "AUTHENTICATION", "ENABLE", "DISABLE",
  "INSECURE", "REPOSITORY", "REPOSITORIES", "PERMIT", "DENY", "HIDE",
  "WEBSITE", "PATH", "BRANCH", "REPOS_URL_PATH", "DESCRIPTION", "TYPES",
  "INCLUDE", "GOTWEBD_CONTROL", "SSH_HOSTKEY_ECDSA", "SSH_HOSTKEY_ED25519",
  "SSH_HOSTKEY_RSA", "STRING", "NUMBER", "'\\n'", "'='", "'*'", "'{'",
  "'}'", "'/'", "';'", "$accept", "grammar", "include", "varset",
  "numberstring", "boolean", "listen_addr", "main", "server", "$@1",
  "serveropts1", "serveropts2", "websiteopts2", "websiteopts1", "website",
  "$@2", "repository", "$@3", "repoopts2", "repoopts1", "types",
  "mediaopts_l", "mediaoptsl", "mediastring", "medianames_l",
  "medianamesl", "nl", "optsemicolon", "optnl", YY_NULLPTR
};

static const char *
yysymbol_name (yysymbol_kind_t yysymbol)
{
  return yytname[yysymbol];
}
#endif

#define YYPACT_NINF (-97)

#define yypact_value_is_default(Yyn) \
  ((Yyn) == YYPACT_NINF)

#define YYTABLE_NINF (-42)

#define yytable_value_is_error(Yyn) \
  0

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
static const yytype_int16 yypact[] =
{
     -97,   147,   -97,   -52,    -2,    47,    -5,   -23,   -19,     1,
       7,    28,    29,    53,    57,   -16,   -16,    38,    10,    66,
      40,    45,    52,    54,   -97,    62,    65,    70,    71,   -97,
     -25,    55,    15,    56,   -97,    63,   -97,   -97,   -97,   -97,
      91,   -97,   -97,   -97,   -97,   -97,   -97,    73,    76,   -97,
     -97,   -97,    79,   -97,   -97,   -97,   -97,    80,   -97,   -97,
     114,   -97,    81,    83,   -97,    82,   -97,    73,   -41,   -97,
     -97,   -97,    26,   -97,   -97,    73,   -97,    84,    78,   -97,
      16,    87,   -16,   -97,   -97,   199,   -97,    90,   -97,    87,
      73,   -97,   -97,     4,   -97,   120,   100,   102,   105,   106,
     109,   -10,   -10,   -10,   110,   112,   113,   -10,   -10,   -10,
     116,   121,   124,   126,   129,   111,   130,   125,   -16,   -16,
     128,   135,   136,   137,   138,   140,    73,    11,   -97,   -97,
     -97,   -97,   -97,   -97,   -97,   -97,    35,   -97,   -97,   -97,
     -97,   -97,   -97,   -97,   -97,   -97,   -97,   -97,   -97,   -97,
     -97,   -97,   -97,   -97,   -97,   -97,   -97,   -97,   -97,   159,
     -97,   -97,   -97,   -97,   -10,   -97,   -97,   -97,   -97,   -97,
     -97,   -97,    87,   157,   162,   -97,   158,   -97,   161,   -97,
     -97,   -97,    73,    73,    72,   117,   167,   189,   190,   -16,
     -16,   188,   173,   178,   179,   182,    37,    73,   204,   209,
     192,   -16,   -16,   193,   194,    60,    73,   -97,   207,   -97,
     -97,   -97,   -10,   -97,   -97,   -97,   -97,   -97,    87,   -97,
     212,   -97,   -97,   -97,   -97,   -97,   -97,   -97,    87,   -97,
     -97,   -97,   -97,   -97,   -97
};

/* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
   Performed when YYTABLE does not specify something else to do.  Zero
   means the default is an error.  */
static const yytype_int8 yydefact[] =
{
       2,     0,     1,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     3,     0,     0,     0,     0,     8,
       0,     0,     0,     0,    18,    40,    19,    33,    34,    23,
      26,    25,    11,    12,    28,    29,    35,   118,     0,    37,
      38,    39,     0,     4,     5,     6,     7,     0,    17,    16,
       0,    30,     0,     0,    24,     0,    27,   118,     0,    36,
      10,    22,     0,    32,    31,   118,   117,     0,     0,   109,
       0,     0,     0,    20,    21,     0,     9,     0,   105,     0,
     118,   107,   113,   116,   112,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   118,     0,    75,    74,
     110,   106,   114,   115,   111,   108,     0,    44,    45,    46,
      47,    48,    14,    13,    15,    51,    52,    53,    59,    43,
      60,    50,    54,    55,    49,    68,    69,    61,    62,    64,
      63,    90,    66,    67,     0,    88,    70,    71,    72,    73,
      77,    42,     0,     0,     0,    65,     0,    56,     0,    76,
      58,    57,   118,   118,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   118,     0,     0,
       0,     0,     0,     0,     0,     0,   118,   101,    95,    94,
      97,    98,     0,   100,   102,   103,   104,    91,     0,    93,
      84,    83,    80,    86,    87,    81,    82,    89,     0,    79,
      96,    99,    92,    85,    78
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
     -97,   -97,   -97,   -97,   -15,   -96,   -97,   -97,   -97,   -97,
     127,   -97,   -97,    50,   -97,   -97,   -97,   -97,   -97,    61,
     -97,   -97,   176,   -97,   -97,   165,   -85,   -97,   -65
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_uint8 yydefgoto[] =
{
       0,     1,    79,    25,    92,   145,    60,    26,    27,    65,
     126,   127,   205,   206,   128,   178,   129,   176,   196,   197,
      28,    80,    81,    82,    93,    94,    91,   135,    68
};

/* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule whose
   number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int16 yytable[] =
{
      44,    45,    76,    57,   131,    29,   146,   147,   142,    77,
      85,   151,   152,   153,    78,    95,    30,    96,    97,    98,
      99,   100,   101,   102,   103,   132,   104,   105,   106,    33,
      58,   107,   108,    34,    59,   109,    35,    62,   110,    42,
      43,   111,   112,   113,   114,   143,   144,   115,   116,    63,
     117,   186,   118,   119,   120,   121,    36,   173,   122,    42,
      43,   170,    37,   123,   124,   125,    77,   133,   177,   174,
      47,    78,   171,   187,   188,    31,    32,    88,   189,   190,
     191,    83,    84,    38,    39,   192,   186,   179,    40,   193,
     194,   195,    41,    46,    48,    49,   198,   199,   217,   200,
      50,   201,   202,   162,   163,   203,   204,    51,   187,   188,
      61,    64,    52,   189,   190,   191,   231,   184,   185,    53,
     192,   227,    54,   -41,   193,   194,   195,    55,    56,    66,
      67,    69,   219,   232,    70,    71,    72,    73,    74,    86,
      87,   229,    75,   234,    90,   130,   159,     2,     3,   136,
       4,     5,     6,   198,   199,   137,   200,   138,   201,   202,
     139,   140,   203,   204,   141,   160,   148,   149,   164,   150,
       7,   154,     8,     9,   210,   211,   155,    10,    11,   156,
     161,    12,   157,    13,    14,   158,   223,   224,    15,    16,
     165,   166,   167,   168,    17,   169,    18,   175,    19,    20,
      21,    22,    23,    95,    24,    96,    97,    98,    99,   100,
     101,   102,   103,   180,   104,   105,   106,   181,   182,   107,
     108,   183,   207,   109,   208,   209,   110,   212,   213,   111,
     112,   113,   114,   214,   215,   115,   116,   216,   117,   220,
     118,   119,   120,   121,   221,   230,   122,   222,   225,   226,
     233,   123,   124,   125,   172,   228,    89,   218,   134
};

static const yytype_uint8 yycheck[] =
{
      15,    16,    67,    28,    89,    57,   102,   103,    18,    50,
      75,   107,   108,   109,    55,     4,    18,     6,     7,     8,
       9,    10,    11,    12,    13,    90,    15,    16,    17,    34,
      55,    20,    21,    56,    59,    24,    55,    22,    27,    55,
      56,    30,    31,    32,    33,    55,    56,    36,    37,    34,
      39,    14,    41,    42,    43,    44,    55,    22,    47,    55,
      56,   126,    55,    52,    53,    54,    50,    63,   164,    34,
      60,    55,    61,    36,    37,    28,    29,    61,    41,    42,
      43,    55,    56,    55,    55,    48,    14,   172,    35,    52,
      53,    54,    35,    55,    28,    55,    36,    37,    61,    39,
      55,    41,    42,   118,   119,    45,    46,    55,    36,    37,
      55,    55,    58,    41,    42,    43,   212,   182,   183,    57,
      48,    61,    57,    60,    52,    53,    54,    57,    57,    38,
      57,    55,   197,   218,    55,    55,    22,    56,    55,    55,
      62,   206,    60,   228,    57,    55,    35,     0,     1,    29,
       3,     4,     5,    36,    37,    55,    39,    55,    41,    42,
      55,    55,    45,    46,    55,    35,    56,    55,    40,    56,
      23,    55,    25,    26,   189,   190,    55,    30,    31,    55,
      55,    34,    56,    36,    37,    56,   201,   202,    41,    42,
      55,    55,    55,    55,    47,    55,    49,    38,    51,    52,
      53,    54,    55,     4,    57,     6,     7,     8,     9,    10,
      11,    12,    13,    56,    15,    16,    17,    55,    60,    20,
      21,    60,    55,    24,    35,    35,    27,    39,    55,    30,
      31,    32,    33,    55,    55,    36,    37,    55,    39,    35,
      41,    42,    43,    44,    35,    38,    47,    55,    55,    55,
      38,    52,    53,    54,   127,   205,    80,   196,    93
};

/* YYSTOS[STATE-NUM] -- The symbol kind of the accessing symbol of
   state STATE-NUM.  */
static const yytype_int8 yystos[] =
{
       0,    65,     0,     1,     3,     4,     5,    23,    25,    26,
      30,    31,    34,    36,    37,    41,    42,    47,    49,    51,
      52,    53,    54,    55,    57,    67,    71,    72,    84,    57,
      18,    28,    29,    34,    56,    55,    55,    55,    55,    55,
      35,    35,    55,    56,    68,    68,    55,    60,    28,    55,
      55,    55,    58,    57,    57,    57,    57,    28,    55,    59,
      70,    55,    22,    34,    55,    73,    38,    57,    92,    55,
      55,    55,    22,    56,    55,    60,    92,    50,    55,    66,
      85,    86,    87,    55,    56,    92,    55,    62,    61,    86,
      57,    90,    68,    88,    89,     4,     6,     7,     8,     9,
      10,    11,    12,    13,    15,    16,    17,    20,    21,    24,
      27,    30,    31,    32,    33,    36,    37,    39,    41,    42,
      43,    44,    47,    52,    53,    54,    74,    75,    78,    80,
      55,    90,    92,    63,    89,    91,    29,    55,    55,    55,
      55,    55,    18,    55,    56,    69,    69,    69,    56,    55,
      56,    69,    69,    69,    55,    55,    55,    56,    56,    35,
      35,    55,    68,    68,    40,    55,    55,    55,    55,    55,
      92,    61,    74,    22,    34,    38,    81,    69,    79,    90,
      56,    55,    60,    60,    92,    92,    14,    36,    37,    41,
      42,    43,    48,    52,    53,    54,    82,    83,    36,    37,
      39,    41,    42,    45,    46,    76,    77,    55,    35,    35,
      68,    68,    39,    55,    55,    55,    55,    61,    83,    92,
      35,    35,    55,    68,    68,    55,    55,    61,    77,    92,
      38,    69,    90,    38,    90
};

/* YYR1[RULE-NUM] -- Symbol kind of the left-hand side of rule RULE-NUM.  */
static const yytype_int8 yyr1[] =
{
       0,    64,    65,    65,    65,    65,    65,    65,    65,    66,
      67,    68,    68,    69,    69,    69,    70,    70,    71,    71,
      71,    71,    71,    71,    71,    71,    71,    71,    71,    71,
      71,    71,    71,    71,    71,    71,    71,    71,    71,    71,
      72,    73,    72,    74,    74,    74,    74,    74,    74,    74,
      74,    74,    74,    74,    74,    74,    74,    74,    74,    74,
      74,    74,    74,    74,    74,    74,    74,    74,    74,    74,
      74,    74,    74,    74,    74,    74,    75,    75,    76,    76,
      77,    77,    77,    77,    77,    77,    77,    77,    79,    78,
      81,    80,    82,    82,    83,    83,    83,    83,    83,    83,
      83,    83,    83,    83,    83,    84,    85,    85,    86,    86,
      87,    88,    88,    89,    90,    91,    91,    92,    92
};

/* YYR2[RULE-NUM] -- Number of symbols on the right-hand side of rule RULE-NUM.  */
static const yytype_int8 yyr2[] =
{
       0,     2,     0,     2,     3,     3,     3,     3,     3,     2,
       3,     1,     1,     1,     1,     1,     1,     1,     2,     2,
       5,     5,     4,     2,     3,     2,     2,     3,     2,     2,
       3,     4,     4,     2,     2,     2,     3,     2,     2,     2,
       2,     0,     7,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     3,     4,     4,     2,
       2,     2,     2,     2,     2,     3,     2,     2,     2,     2,
       2,     2,     2,     2,     1,     1,     3,     2,     3,     2,
       2,     2,     2,     2,     2,     3,     2,     2,     0,     7,
       0,     7,     3,     2,     2,     2,     3,     2,     2,     3,
       2,     2,     2,     2,     2,     5,     3,     2,     3,     1,
       3,     2,     1,     1,     2,     1,     0,     2,     0
};


enum { YYENOMEM = -2 };

#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = YYEMPTY)

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab
#define YYNOMEM         goto yyexhaustedlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                    \
  do                                                              \
    if (yychar == YYEMPTY)                                        \
      {                                                           \
        yychar = (Token);                                         \
        yylval = (Value);                                         \
        YYPOPSTACK (yylen);                                       \
        yystate = *yyssp;                                         \
        goto yybackup;                                            \
      }                                                           \
    else                                                          \
      {                                                           \
        yyerror (YY_("syntax error: cannot back up")); \
        YYERROR;                                                  \
      }                                                           \
  while (0)

/* Backward compatibility with an undocumented macro.
   Use YYerror or YYUNDEF. */
#define YYERRCODE YYUNDEF


/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)




# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)                    \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Kind, Value); \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*-----------------------------------.
| Print this symbol's value on YYO.  |
`-----------------------------------*/

static void
yy_symbol_value_print (FILE *yyo,
                       yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep)
{
  FILE *yyoutput = yyo;
  YY_USE (yyoutput);
  if (!yyvaluep)
    return;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/*---------------------------.
| Print this symbol on YYO.  |
`---------------------------*/

static void
yy_symbol_print (FILE *yyo,
                 yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep)
{
  YYFPRINTF (yyo, "%s %s (",
             yykind < YYNTOKENS ? "token" : "nterm", yysymbol_name (yykind));

  yy_symbol_value_print (yyo, yykind, yyvaluep);
  YYFPRINTF (yyo, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yy_state_t *yybottom, yy_state_t *yytop)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)                            \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top));                           \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yy_state_t *yyssp, YYSTYPE *yyvsp,
                 int yyrule)
{
  int yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %d):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       YY_ACCESSING_SYMBOL (+yyssp[yyi + 1 - yynrhs]),
                       &yyvsp[(yyi + 1) - (yynrhs)]);
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)          \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, Rule); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args) ((void) 0)
# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif






/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg,
            yysymbol_kind_t yykind, YYSTYPE *yyvaluep)
{
  YY_USE (yyvaluep);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yykind, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/* Lookahead token kind.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;
/* Number of syntax errors so far.  */
int yynerrs;




/*----------.
| yyparse.  |
`----------*/

int
yyparse (void)
{
    yy_state_fast_t yystate = 0;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus = 0;

    /* Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* Their size.  */
    YYPTRDIFF_T yystacksize = YYINITDEPTH;

    /* The state stack: array, bottom, top.  */
    yy_state_t yyssa[YYINITDEPTH];
    yy_state_t *yyss = yyssa;
    yy_state_t *yyssp = yyss;

    /* The semantic value stack: array, bottom, top.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs = yyvsa;
    YYSTYPE *yyvsp = yyvs;

  int yyn;
  /* The return value of yyparse.  */
  int yyresult;
  /* Lookahead symbol kind.  */
  yysymbol_kind_t yytoken = YYSYMBOL_YYEMPTY;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;



#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yychar = YYEMPTY; /* Cause a token to be read.  */

  goto yysetstate;


/*------------------------------------------------------------.
| yynewstate -- push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;


/*--------------------------------------------------------------------.
| yysetstate -- set current state (the top of the stack) to yystate.  |
`--------------------------------------------------------------------*/
yysetstate:
  YYDPRINTF ((stderr, "Entering state %d\n", yystate));
  YY_ASSERT (0 <= yystate && yystate < YYNSTATES);
  YY_IGNORE_USELESS_CAST_BEGIN
  *yyssp = YY_CAST (yy_state_t, yystate);
  YY_IGNORE_USELESS_CAST_END
  YY_STACK_PRINT (yyss, yyssp);

  if (yyss + yystacksize - 1 <= yyssp)
#if !defined yyoverflow && !defined YYSTACK_RELOCATE
    YYNOMEM;
#else
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYPTRDIFF_T yysize = yyssp - yyss + 1;

# if defined yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        yy_state_t *yyss1 = yyss;
        YYSTYPE *yyvs1 = yyvs;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * YYSIZEOF (*yyssp),
                    &yyvs1, yysize * YYSIZEOF (*yyvsp),
                    &yystacksize);
        yyss = yyss1;
        yyvs = yyvs1;
      }
# else /* defined YYSTACK_RELOCATE */
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        YYNOMEM;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yy_state_t *yyss1 = yyss;
        union yyalloc *yyptr =
          YY_CAST (union yyalloc *,
                   YYSTACK_ALLOC (YY_CAST (YYSIZE_T, YYSTACK_BYTES (yystacksize))));
        if (! yyptr)
          YYNOMEM;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
#  undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;

      YY_IGNORE_USELESS_CAST_BEGIN
      YYDPRINTF ((stderr, "Stack size increased to %ld\n",
                  YY_CAST (long, yystacksize)));
      YY_IGNORE_USELESS_CAST_END

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }
#endif /* !defined yyoverflow && !defined YYSTACK_RELOCATE */


  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;


/*-----------.
| yybackup.  |
`-----------*/
yybackup:
  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either empty, or end-of-input, or a valid lookahead.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token\n"));
      yychar = yylex ();
    }

  if (yychar <= YYEOF)
    {
      yychar = YYEOF;
      yytoken = YYSYMBOL_YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else if (yychar == YYerror)
    {
      /* The scanner already issued an error message, process directly
         to error recovery.  But do not keep the error token as
         lookahead, it is too special and may lead us to an endless
         loop in error recovery. */
      yychar = YYUNDEF;
      yytoken = YYSYMBOL_YYerror;
      goto yyerrlab1;
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);
  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  /* Discard the shifted token.  */
  yychar = YYEMPTY;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
  case 8: /* grammar: grammar error '\n'  */
#line 174 "parse.y"
                                                { file->errors++; }
#line 1583 "parse.c"
    break;

  case 9: /* include: INCLUDE STRING  */
#line 177 "parse.y"
                                                {
			struct file	*nfile;

			if ((nfile = pushfile((yyvsp[0].v.string), 0)) == NULL) {
				yyerror("failed to include file %s", (yyvsp[0].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			}
			free((yyvsp[0].v.string));

			file = nfile;
			lungetc('\n');
		}
#line 1601 "parse.c"
    break;

  case 10: /* varset: STRING '=' STRING  */
#line 192 "parse.y"
                                        {
			char *s = (yyvsp[-2].v.string);
			while (*s++) {
				if (isspace((unsigned char)*s)) {
					yyerror("macro name cannot contain "
					    "whitespace");
					free((yyvsp[-2].v.string));
					free((yyvsp[0].v.string));
					YYERROR;
				}
			}
			if (symset((yyvsp[-2].v.string), (yyvsp[0].v.string), 0) == -1)
				fatal("cannot store variable");
			free((yyvsp[-2].v.string));
			free((yyvsp[0].v.string));
		}
#line 1622 "parse.c"
    break;

  case 12: /* numberstring: NUMBER  */
#line 211 "parse.y"
                         {
			if (asprintf(&(yyval.v.string), "%lld", (long long)(yyvsp[0].v.number)) == -1) {
				yyerror("asprintf: %s", strerror(errno));
				YYERROR;
			}
		}
#line 1633 "parse.c"
    break;

  case 13: /* boolean: STRING  */
#line 220 "parse.y"
                         {
			if (strcasecmp((yyvsp[0].v.string), "1") == 0 ||
			    strcasecmp((yyvsp[0].v.string), "on") == 0)
				(yyval.v.number) = 1;
			else if (strcasecmp((yyvsp[0].v.string), "0") == 0 ||
			    strcasecmp((yyvsp[0].v.string), "off") == 0)
				(yyval.v.number) = 0;
			else {
				yyerror("invalid boolean value '%s'", (yyvsp[0].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			}
			free((yyvsp[0].v.string));
		}
#line 1652 "parse.c"
    break;

  case 14: /* boolean: ON  */
#line 234 "parse.y"
                     { (yyval.v.number) = 1; }
#line 1658 "parse.c"
    break;

  case 15: /* boolean: NUMBER  */
#line 235 "parse.y"
                         {
			if ((yyvsp[0].v.number) != 0 && (yyvsp[0].v.number) != 1) {
				yyerror("invalid boolean value '%lld'", (yyvsp[0].v.number));
				YYERROR;
			}
			(yyval.v.number) = (yyvsp[0].v.number);
		}
#line 1670 "parse.c"
    break;

  case 16: /* listen_addr: '*'  */
#line 244 "parse.y"
                      { (yyval.v.string) = NULL; }
#line 1676 "parse.c"
    break;

  case 18: /* main: PREFORK NUMBER  */
#line 248 "parse.y"
                                 {
			if ((yyvsp[0].v.number) <= 0 || (yyvsp[0].v.number) > PROC_MAX_INSTANCES) {
				yyerror("prefork is %s: %lld",
				    (yyvsp[0].v.number) <= 0 ? "too small" : "too large", (yyvsp[0].v.number));
				YYERROR;
			}
			gotwebd->prefork = (yyvsp[0].v.number);
		}
#line 1689 "parse.c"
    break;

  case 19: /* main: CHROOT STRING  */
#line 256 "parse.y"
                                {
			if (*(yyvsp[0].v.string) == '\0') {
				yyerror("chroot path can't be an empty"
				    " string");
				free((yyvsp[0].v.string));
				YYERROR;
			}

			n = strlcpy(gotwebd->httpd_chroot, (yyvsp[0].v.string),
			    sizeof(gotwebd->httpd_chroot));
			if (n >= sizeof(gotwebd->httpd_chroot)) {
				yyerror("chroot path too long: %s", (yyvsp[0].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			}
			if (gotwebd->httpd_chroot[0] != '/') {
				yyerror("chroot path must be an absolute path: "
				    "bad path %s", gotwebd->httpd_chroot);
				free((yyvsp[0].v.string));
				YYERROR;
			}
			free((yyvsp[0].v.string));
		}
#line 1717 "parse.c"
    break;

  case 20: /* main: LISTEN ON listen_addr PORT STRING  */
#line 279 "parse.y"
                                                    {
			if (get_addrs((yyvsp[-2].v.string), (yyvsp[0].v.string)) == -1) {
				yyerror("could not get addrs");
				YYERROR;
			}
			free((yyvsp[-2].v.string));
			free((yyvsp[0].v.string));
		}
#line 1730 "parse.c"
    break;

  case 21: /* main: LISTEN ON listen_addr PORT NUMBER  */
#line 287 "parse.y"
                                                    {
			char portno[32];
			int n;

			n = snprintf(portno, sizeof(portno), "%lld",
			    (long long)(yyvsp[0].v.number));
			if (n < 0 || (size_t)n >= sizeof(portno))
				fatalx("port number too long: %lld",
				    (long long)(yyvsp[0].v.number));

			if (get_addrs((yyvsp[-2].v.string), portno) == -1) {
				yyerror("could not get addrs");
				YYERROR;
			}
			free((yyvsp[-2].v.string));
		}
#line 1751 "parse.c"
    break;

  case 22: /* main: LISTEN ON SOCKET STRING  */
#line 303 "parse.y"
                                          {
			struct address *h;

			h = get_unix_addr((yyvsp[0].v.string));
			if (h == NULL) {
				yyerror("can't listen on %s", (yyvsp[0].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			}
			add_addr(h);
			free((yyvsp[0].v.string));
		}
#line 1768 "parse.c"
    break;

  case 23: /* main: USER STRING  */
#line 315 "parse.y"
                              {
			if (gotwebd->user != NULL)
				yyerror("user already specified");
			free(gotwebd->user);
			gotwebd->user = (yyvsp[0].v.string);
		}
#line 1779 "parse.c"
    break;

  case 24: /* main: WWW USER STRING  */
#line 321 "parse.y"
                                  {
			if (gotwebd->www_user != NULL)
				yyerror("www user already specified");
			free(gotwebd->www_user);
			gotwebd->www_user = (yyvsp[0].v.string);
		}
#line 1790 "parse.c"
    break;

  case 25: /* main: DISABLE AUTHENTICATION  */
#line 327 "parse.y"
                                         {
			if (gotwebd->auth_config != 0) {
				yyerror("ambiguous global authentication "
				    "setting");
				YYERROR;
			}
			gotwebd->auth_config = GOTWEBD_AUTH_DISABLED;
		}
#line 1803 "parse.c"
    break;

  case 26: /* main: ENABLE AUTHENTICATION  */
#line 335 "parse.y"
                                        {
			if (gotwebd->auth_config != 0) {
				yyerror("ambiguous global authentication "
				    "setting");
				YYERROR;
			}
			gotwebd->auth_config = GOTWEBD_AUTH_SECURE;
		}
#line 1816 "parse.c"
    break;

  case 27: /* main: ENABLE AUTHENTICATION INSECURE  */
#line 343 "parse.y"
                                                 {
			if (gotwebd->auth_config != 0) {
				yyerror("ambiguous global authentication "
				    "setting");
				YYERROR;
			}
			gotwebd->auth_config = GOTWEBD_AUTH_INSECURE;
		}
#line 1829 "parse.c"
    break;

  case 28: /* main: PERMIT numberstring  */
#line 351 "parse.y"
                                      {
			conf_new_access_rule(&gotwebd->access_rules,
			    GOTWEBD_ACCESS_PERMITTED, (yyvsp[0].v.string));
		}
#line 1838 "parse.c"
    break;

  case 29: /* main: DENY numberstring  */
#line 355 "parse.y"
                                    {
			conf_new_access_rule(&gotwebd->access_rules,
			    GOTWEBD_ACCESS_DENIED, (yyvsp[0].v.string));
		}
#line 1847 "parse.c"
    break;

  case 30: /* main: GOTWEBD_LOGIN SOCKET STRING  */
#line 359 "parse.y"
                                              {
			struct address *h;
			h = get_unix_addr((yyvsp[0].v.string));
			if (h == NULL) {
				yyerror("can't listen on %s", (yyvsp[0].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			}
			if (gotwebd->login_sock != NULL)
				free(gotwebd->login_sock);
			gotwebd->login_sock = sockets_conf_new_socket(-1, h);
			free(h);
			free((yyvsp[0].v.string));
		}
#line 1866 "parse.c"
    break;

  case 31: /* main: GOTWEBD_LOGIN HINT USER STRING  */
#line 373 "parse.y"
                                                 {
			n = strlcpy(gotwebd->login_hint_user, (yyvsp[0].v.string),
			    sizeof(gotwebd->login_hint_user));
			if (n >= sizeof(gotwebd->login_hint_user)) {
				yyerror("login hint user name too long, "
				    "exceeds %zd bytes",
				    sizeof(gotwebd->login_hint_user) - 1);
				free((yyvsp[0].v.string));
				YYERROR;
			}
			free((yyvsp[0].v.string));
		}
#line 1883 "parse.c"
    break;

  case 32: /* main: GOTWEBD_LOGIN HINT PORT NUMBER  */
#line 385 "parse.y"
                                                 {
			int n;

			if ((yyvsp[0].v.number) < 1 || (yyvsp[0].v.number) > USHRT_MAX) {
				fatalx("port number invalid: %lld",
				    (long long)(yyvsp[0].v.number));
			}

			n = snprintf(gotwebd->login_hint_port,
			    sizeof(gotwebd->login_hint_port), "%lld",
			    (long long)(yyvsp[0].v.number));
			if (n < 0) {
				fatal("snprintf: port number %lld:",
				    (long long)(yyvsp[0].v.number));
			}
			if ((size_t)n >= sizeof(gotwebd->login_hint_port)) {
				fatalx("port number too long: %lld",
				    (long long)(yyvsp[0].v.number));
			}
		}
#line 1908 "parse.c"
    break;

  case 33: /* main: HTDOCS STRING  */
#line 405 "parse.y"
                                {
			if (*(yyvsp[0].v.string) == '\0') {
				yyerror("htdocs path can't be an empty"
				    " string");
				free((yyvsp[0].v.string));
				YYERROR;
			}

			n = strlcpy(gotwebd->htdocs_path, (yyvsp[0].v.string),
			    sizeof(gotwebd->htdocs_path));
			if (n >= sizeof(gotwebd->htdocs_path)) {
				yyerror("htdocs path too long: %s", (yyvsp[0].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			}
			free((yyvsp[0].v.string));
		}
#line 1930 "parse.c"
    break;

  case 34: /* main: GOTWEB_URL_ROOT STRING  */
#line 422 "parse.y"
                                         {
			if (*(yyvsp[0].v.string) == '\0') {
				yyerror("gotweb_url_root can't be an empty"
				    " string");
				free((yyvsp[0].v.string));
				YYERROR;
			}

			if (!got_path_is_root_dir((yyvsp[0].v.string)))
				got_path_strip_trailing_slashes((yyvsp[0].v.string));

			n = strlcpy(gotwebd->gotweb_url_root, (yyvsp[0].v.string),
			    sizeof(gotwebd->gotweb_url_root));
			if (n >= sizeof(gotwebd->gotweb_url_root)) {
				yyerror("gotweb_url_root too long, exceeds "
				    "%zd bytes: %s",
				    sizeof(gotwebd->gotweb_url_root), (yyvsp[0].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			}

			if (gotwebd->gotweb_url_root[0] != '/') {
				yyerror("gotweb_url_root must be an absolute "
				    "path: bad path %s", (yyvsp[0].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			}


			free((yyvsp[0].v.string));
		}
#line 1966 "parse.c"
    break;

  case 35: /* main: REPOS_URL_PATH STRING  */
#line 453 "parse.y"
                                        {
			if (*(yyvsp[0].v.string) == '\0') {
				yyerror("repos_url_path can't be an empty"
				    " string");
				free((yyvsp[0].v.string));
				YYERROR;
			}

			if (!got_path_is_root_dir((yyvsp[0].v.string)))
				got_path_strip_trailing_slashes((yyvsp[0].v.string));

			n = strlcpy(gotwebd->repos_url_path, (yyvsp[0].v.string),
			    sizeof(gotwebd->repos_url_path));
			if (n >= sizeof(gotwebd->repos_url_path)) {
				yyerror("repos_url_path too long, exceeds "
				    "%zd bytes: %s",
				    sizeof(gotwebd->repos_url_path), (yyvsp[0].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			}

			if (gotwebd->repos_url_path[0] != '/') {
				yyerror("repos_url_path must be an absolute "
				    "path: bad path %s", (yyvsp[0].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			}

			free((yyvsp[0].v.string));
		}
#line 2001 "parse.c"
    break;

  case 36: /* main: GOTWEBD_CONTROL SOCKET STRING  */
#line 483 "parse.y"
                                                {
			struct address *h;
			h = get_unix_addr((yyvsp[0].v.string));
			if (h == NULL) {
				yyerror("can't listen on %s", (yyvsp[0].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			}
			if (gotwebd->control_sock != NULL)
				free(gotwebd->control_sock);
			gotwebd->control_sock = sockets_conf_new_socket(-1, h);
			free(h);
			free((yyvsp[0].v.string));
		}
#line 2020 "parse.c"
    break;

  case 37: /* main: SSH_HOSTKEY_ECDSA STRING  */
#line 497 "parse.y"
                                           {
			int i = GOTWEBD_SSHFP_ECDSA;

			if (*(yyvsp[0].v.string) == '\0') {
				yyerror("ssh host key fingerprint cannot be "
				    "an empty string");
				free((yyvsp[0].v.string));
				YYERROR;
			}

			if (strlcpy(gotwebd->sshfp[i], (yyvsp[0].v.string),
			    sizeof(gotwebd->sshfp[i])) >=
			    sizeof(gotwebd->sshfp[i])) {
				yyerror("ssh host key fingerprint too long, "
				    "exceeds " "%zd bytes: %s",
				    sizeof(gotwebd->sshfp[i]), (yyvsp[0].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			}

			free((yyvsp[0].v.string));
		}
#line 2047 "parse.c"
    break;

  case 38: /* main: SSH_HOSTKEY_ED25519 STRING  */
#line 519 "parse.y"
                                             {
			int i = GOTWEBD_SSHFP_ED25519;

			if (*(yyvsp[0].v.string) == '\0') {
				yyerror("ssh host key fingerprint cannot be "
				    "an empty string");
				free((yyvsp[0].v.string));
				YYERROR;
			}

			if (strlcpy(gotwebd->sshfp[i], (yyvsp[0].v.string),
			    sizeof(gotwebd->sshfp[i])) >=
			    sizeof(gotwebd->sshfp[i])) {
				yyerror("ssh host key fingerprint too long, "
				    "exceeds " "%zd bytes: %s",
				    sizeof(gotwebd->sshfp[i]), (yyvsp[0].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			}

			free((yyvsp[0].v.string));
		}
#line 2074 "parse.c"
    break;

  case 39: /* main: SSH_HOSTKEY_RSA STRING  */
#line 541 "parse.y"
                                         {
			int i = GOTWEBD_SSHFP_RSA;

			if (*(yyvsp[0].v.string) == '\0') {
				yyerror("ssh host key fingerprint cannot be "
				    "an empty string");
				free((yyvsp[0].v.string));
				YYERROR;
			}

			if (strlcpy(gotwebd->sshfp[i], (yyvsp[0].v.string),
			    sizeof(gotwebd->sshfp[i])) >=
			    sizeof(gotwebd->sshfp[i])) {
				yyerror("ssh host key fingerprint too long, "
				    "exceeds " "%zd bytes: %s",
				    sizeof(gotwebd->sshfp[i]), (yyvsp[0].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			}

			free((yyvsp[0].v.string));
		}
#line 2101 "parse.c"
    break;

  case 40: /* server: SERVER STRING  */
#line 565 "parse.y"
                                {
			struct server *srv;

			TAILQ_FOREACH(srv, &gotwebd->servers, entry) {
				if (strcmp(srv->name, (yyvsp[0].v.string)) == 0) {
					yyerror("server name exists '%s'", (yyvsp[0].v.string));
					free((yyvsp[0].v.string));
					YYERROR;
				}
			}

			new_srv = conf_new_server((yyvsp[0].v.string));
			log_debug("adding server %s", (yyvsp[0].v.string));
			free((yyvsp[0].v.string));
		}
#line 2121 "parse.c"
    break;

  case 41: /* $@1: %empty  */
#line 580 "parse.y"
                                {
			struct server *srv;

			TAILQ_FOREACH(srv, &gotwebd->servers, entry) {
				if (strcmp(srv->name, (yyvsp[0].v.string)) == 0) {
					yyerror("server name exists '%s'", (yyvsp[0].v.string));
					free((yyvsp[0].v.string));
					YYERROR;
				}
			}

			new_srv = conf_new_server((yyvsp[0].v.string));
			log_debug("adding server %s", (yyvsp[0].v.string));
			free((yyvsp[0].v.string));
		}
#line 2141 "parse.c"
    break;

  case 42: /* server: SERVER STRING $@1 '{' optnl serveropts2 '}'  */
#line 594 "parse.y"
                                            {
		}
#line 2148 "parse.c"
    break;

  case 43: /* serveropts1: REPOS_PATH STRING  */
#line 598 "parse.y"
                                    {
			n = strlcpy(new_srv->repos_path, (yyvsp[0].v.string),
			    sizeof(new_srv->repos_path));
			if (n >= sizeof(new_srv->repos_path)) {
				yyerror("%s: repos_path truncated", __func__);
				free((yyvsp[0].v.string));
				YYERROR;
			}
			free((yyvsp[0].v.string));
		}
#line 2163 "parse.c"
    break;

  case 44: /* serveropts1: SITE_NAME STRING  */
#line 608 "parse.y"
                                   {
			n = strlcpy(new_srv->site_name, (yyvsp[0].v.string),
			    sizeof(new_srv->site_name));
			if (n >= sizeof(new_srv->site_name)) {
				yyerror("%s: site_name truncated", __func__);
				free((yyvsp[0].v.string));
				YYERROR;
			}
			free((yyvsp[0].v.string));
		}
#line 2178 "parse.c"
    break;

  case 45: /* serveropts1: SITE_OWNER STRING  */
#line 618 "parse.y"
                                    {
			n = strlcpy(new_srv->site_owner, (yyvsp[0].v.string),
			    sizeof(new_srv->site_owner));
			if (n >= sizeof(new_srv->site_owner)) {
				yyerror("%s: site_owner truncated", __func__);
				free((yyvsp[0].v.string));
				YYERROR;
			}
			free((yyvsp[0].v.string));
		}
#line 2193 "parse.c"
    break;

  case 46: /* serveropts1: SITE_LINK STRING  */
#line 628 "parse.y"
                                   {
			n = strlcpy(new_srv->site_link, (yyvsp[0].v.string),
			    sizeof(new_srv->site_link));
			if (n >= sizeof(new_srv->site_link)) {
				yyerror("%s: site_link truncated", __func__);
				free((yyvsp[0].v.string));
				YYERROR;
			}
			free((yyvsp[0].v.string));
		}
#line 2208 "parse.c"
    break;

  case 47: /* serveropts1: LOGO STRING  */
#line 638 "parse.y"
                              {
			n = strlcpy(new_srv->logo, (yyvsp[0].v.string), sizeof(new_srv->logo));
			if (n >= sizeof(new_srv->logo)) {
				yyerror("%s: logo truncated", __func__);
				free((yyvsp[0].v.string));
				YYERROR;
			}
			free((yyvsp[0].v.string));
		}
#line 2222 "parse.c"
    break;

  case 48: /* serveropts1: LOGO_URL STRING  */
#line 647 "parse.y"
                                  {
			n = strlcpy(new_srv->logo_url, (yyvsp[0].v.string),
			    sizeof(new_srv->logo_url));
			if (n >= sizeof(new_srv->logo_url)) {
				yyerror("%s: logo_url truncated", __func__);
				free((yyvsp[0].v.string));
				YYERROR;
			}
			free((yyvsp[0].v.string));
		}
#line 2237 "parse.c"
    break;

  case 49: /* serveropts1: CUSTOM_CSS STRING  */
#line 657 "parse.y"
                                    {
			n = strlcpy(new_srv->custom_css, (yyvsp[0].v.string),
			    sizeof(new_srv->custom_css));
			if (n >= sizeof(new_srv->custom_css)) {
				yyerror("%s: custom_css truncated", __func__);
				free((yyvsp[0].v.string));
				YYERROR;
			}
			free((yyvsp[0].v.string));
		}
#line 2252 "parse.c"
    break;

  case 50: /* serveropts1: SHOW_SITE_OWNER boolean  */
#line 667 "parse.y"
                                          {
			new_srv->show_site_owner = (yyvsp[0].v.number);
		}
#line 2260 "parse.c"
    break;

  case 51: /* serveropts1: SHOW_REPO_OWNER boolean  */
#line 670 "parse.y"
                                          {
			new_srv->show_repo_owner = (yyvsp[0].v.number);
		}
#line 2268 "parse.c"
    break;

  case 52: /* serveropts1: SHOW_REPO_AGE boolean  */
#line 673 "parse.y"
                                        {
			new_srv->show_repo_age = (yyvsp[0].v.number);
		}
#line 2276 "parse.c"
    break;

  case 53: /* serveropts1: SHOW_REPO_DESCRIPTION boolean  */
#line 676 "parse.y"
                                                {
			new_srv->show_repo_description = (yyvsp[0].v.number);
		}
#line 2284 "parse.c"
    break;

  case 54: /* serveropts1: SHOW_REPO_CLONEURL boolean  */
#line 679 "parse.y"
                                             {
			new_srv->show_repo_cloneurl = (yyvsp[0].v.number);
		}
#line 2292 "parse.c"
    break;

  case 55: /* serveropts1: RESPECT_EXPORTOK boolean  */
#line 682 "parse.y"
                                           {
			new_srv->respect_exportok = (yyvsp[0].v.number);
		}
#line 2300 "parse.c"
    break;

  case 56: /* serveropts1: HIDE REPOSITORIES boolean  */
#line 685 "parse.y"
                                            {
			new_srv->hide_repositories = (yyvsp[0].v.number);
		}
#line 2308 "parse.c"
    break;

  case 57: /* serveropts1: GOTWEBD_LOGIN HINT USER STRING  */
#line 688 "parse.y"
                                                 {
			n = strlcpy(new_srv->login_hint_user, (yyvsp[0].v.string),
			    sizeof(new_srv->login_hint_user));
			if (n >= sizeof(new_srv->login_hint_user)) {
				yyerror("login hint user name too long, "
				    "exceeds %zd bytes",
				    sizeof(new_srv->login_hint_user) - 1);
				free((yyvsp[0].v.string));
				YYERROR;
			}
			free((yyvsp[0].v.string));
		}
#line 2325 "parse.c"
    break;

  case 58: /* serveropts1: GOTWEBD_LOGIN HINT PORT NUMBER  */
#line 700 "parse.y"
                                                 {
			int n;

			if ((yyvsp[0].v.number) < 1 || (yyvsp[0].v.number) > USHRT_MAX) {
				fatalx("port number invalid: %lld",
				    (long long)(yyvsp[0].v.number));
			}

			n = snprintf(new_srv->login_hint_port,
			    sizeof(new_srv->login_hint_port), "%lld",
			    (long long)(yyvsp[0].v.number));
			if (n < 0) {
				fatal("snprintf: port number %lld:",
				    (long long)(yyvsp[0].v.number));
			}
			if ((size_t)n >= sizeof(new_srv->login_hint_port)) {
				fatalx("port number too long: %lld",
				    (long long)(yyvsp[0].v.number));
			}
		}
#line 2350 "parse.c"
    break;

  case 59: /* serveropts1: MAX_REPOS_DISPLAY NUMBER  */
#line 720 "parse.y"
                                           {
			if ((yyvsp[0].v.number) < 0) {
				yyerror("max_repos_display is too small: %lld",
				    (yyvsp[0].v.number));
				YYERROR;
			}
			new_srv->max_repos_display = (yyvsp[0].v.number);
		}
#line 2363 "parse.c"
    break;

  case 60: /* serveropts1: MAX_COMMITS_DISPLAY NUMBER  */
#line 728 "parse.y"
                                             {
			if ((yyvsp[0].v.number) <= 1) {
				yyerror("max_commits_display is too small:"
				    " %lld", (yyvsp[0].v.number));
				YYERROR;
			}
			new_srv->max_commits_display = (yyvsp[0].v.number);
		}
#line 2376 "parse.c"
    break;

  case 61: /* serveropts1: SUMMARY_COMMITS_DISPLAY NUMBER  */
#line 736 "parse.y"
                                                 {
			if ((yyvsp[0].v.number) < 1) {
				yyerror("summary_commits_display is too small:"
				    " %lld", (yyvsp[0].v.number));
				YYERROR;
			}
			new_srv->summary_commits_display = (yyvsp[0].v.number);
		}
#line 2389 "parse.c"
    break;

  case 62: /* serveropts1: SUMMARY_TAGS_DISPLAY NUMBER  */
#line 744 "parse.y"
                                              {
			if ((yyvsp[0].v.number) < 1) {
				yyerror("summary_tags_display is too small:"
				    " %lld", (yyvsp[0].v.number));
				YYERROR;
			}
			new_srv->summary_tags_display = (yyvsp[0].v.number);
		}
#line 2402 "parse.c"
    break;

  case 63: /* serveropts1: DISABLE AUTHENTICATION  */
#line 752 "parse.y"
                                         {
			if (new_srv->auth_config != 0) {
				yyerror("ambiguous authentication "
				    "setting for server %s",
				    new_srv->name);
				YYERROR;
			}
			new_srv->auth_config = GOTWEBD_AUTH_DISABLED;
		}
#line 2416 "parse.c"
    break;

  case 64: /* serveropts1: ENABLE AUTHENTICATION  */
#line 761 "parse.y"
                                        {
			if (new_srv->auth_config != 0) {
				yyerror("ambiguous authentication "
				    "setting for server %s",
				    new_srv->name);
				YYERROR;
			}
			new_srv->auth_config = GOTWEBD_AUTH_SECURE;
		}
#line 2430 "parse.c"
    break;

  case 65: /* serveropts1: ENABLE AUTHENTICATION INSECURE  */
#line 770 "parse.y"
                                                 {
			if (new_srv->auth_config != 0) {
				yyerror("ambiguous authentication "
				    "setting for server %s",
				    new_srv->name);
				YYERROR;
			}
			new_srv->auth_config = GOTWEBD_AUTH_INSECURE;
		}
#line 2444 "parse.c"
    break;

  case 66: /* serveropts1: PERMIT numberstring  */
#line 779 "parse.y"
                                      {
			conf_new_access_rule(&new_srv->access_rules,
			    GOTWEBD_ACCESS_PERMITTED, (yyvsp[0].v.string));
		}
#line 2453 "parse.c"
    break;

  case 67: /* serveropts1: DENY numberstring  */
#line 783 "parse.y"
                                    {
			conf_new_access_rule(&new_srv->access_rules,
			    GOTWEBD_ACCESS_DENIED, (yyvsp[0].v.string));
		}
#line 2462 "parse.c"
    break;

  case 68: /* serveropts1: HTDOCS STRING  */
#line 787 "parse.y"
                                {
			if (*(yyvsp[0].v.string) == '\0') {
				yyerror("htdocs path can't be an empty"
				    " string");
				free((yyvsp[0].v.string));
				YYERROR;
			}

			n = strlcpy(new_srv->htdocs_path, (yyvsp[0].v.string),
			    sizeof(new_srv->htdocs_path));
			if (n >= sizeof(new_srv->htdocs_path)) {
				yyerror("htdocs path too long: %s", (yyvsp[0].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			}
			free((yyvsp[0].v.string));
		}
#line 2484 "parse.c"
    break;

  case 69: /* serveropts1: GOTWEB_URL_ROOT STRING  */
#line 804 "parse.y"
                                         {
			if (*(yyvsp[0].v.string) == '\0') {
				yyerror("gotweb_url_root can't be an empty"
				    " string");
				free((yyvsp[0].v.string));
				YYERROR;
			}

			if (!got_path_is_root_dir((yyvsp[0].v.string)))
				got_path_strip_trailing_slashes((yyvsp[0].v.string));

			n = strlcpy(new_srv->gotweb_url_root, (yyvsp[0].v.string),
			    sizeof(new_srv->gotweb_url_root));
			if (n >= sizeof(new_srv->gotweb_url_root)) {
				yyerror("gotweb_url_root too long, exceeds "
				    "%zd bytes: %s",
				    sizeof(new_srv->gotweb_url_root), (yyvsp[0].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			}

			if (new_srv->gotweb_url_root[0] != '/') {
				yyerror("gotweb_url_root must be an absolute "
				    "path: bad path %s", (yyvsp[0].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			}

			free((yyvsp[0].v.string));
		}
#line 2519 "parse.c"
    break;

  case 70: /* serveropts1: REPOS_URL_PATH STRING  */
#line 834 "parse.y"
                                        {
			if (*(yyvsp[0].v.string) == '\0') {
				yyerror("repos_url_path can't be an empty"
				    " string");
				free((yyvsp[0].v.string));
				YYERROR;
			}

			if (!got_path_is_root_dir((yyvsp[0].v.string)))
				got_path_strip_trailing_slashes((yyvsp[0].v.string));

			n = strlcpy(new_srv->repos_url_path, (yyvsp[0].v.string),
			    sizeof(new_srv->repos_url_path));
			if (n >= sizeof(new_srv->repos_url_path)) {
				yyerror("repos_url_path too long, exceeds "
				    "%zd bytes: %s",
				    sizeof(new_srv->repos_url_path), (yyvsp[0].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			}

			if (new_srv->repos_url_path[0] != '/') {
				yyerror("repos_url_path must be an absolute "
				    "path: bad path %s", (yyvsp[0].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			}

			free((yyvsp[0].v.string));
		}
#line 2554 "parse.c"
    break;

  case 71: /* serveropts1: SSH_HOSTKEY_ECDSA STRING  */
#line 864 "parse.y"
                                           {
			int i = GOTWEBD_SSHFP_ECDSA;

			if (*(yyvsp[0].v.string) == '\0') {
				yyerror("ssh host key fingerprint cannot be "
				    "an empty string");
				free((yyvsp[0].v.string));
				YYERROR;
			}

			if (strlcpy(new_srv->sshfp[i], (yyvsp[0].v.string),
			    sizeof(new_srv->sshfp[i])) >=
			    sizeof(new_srv->sshfp[i])) {
				yyerror("ssh host key fingerprint too long, "
				    "exceeds " "%zd bytes: %s",
				    sizeof(new_srv->sshfp[i]), (yyvsp[0].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			}

			free((yyvsp[0].v.string));
		}
#line 2581 "parse.c"
    break;

  case 72: /* serveropts1: SSH_HOSTKEY_ED25519 STRING  */
#line 886 "parse.y"
                                             {
			int i = GOTWEBD_SSHFP_ED25519;

			if (*(yyvsp[0].v.string) == '\0') {
				yyerror("ssh host key fingerprint cannot be "
				    "an empty string");
				free((yyvsp[0].v.string));
				YYERROR;
			}

			if (strlcpy(new_srv->sshfp[i], (yyvsp[0].v.string),
			    sizeof(new_srv->sshfp[i])) >=
			    sizeof(new_srv->sshfp[i])) {
				yyerror("ssh host key fingerprint too long, "
				    "exceeds " "%zd bytes: %s",
				    sizeof(new_srv->sshfp[i]), (yyvsp[0].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			}

			free((yyvsp[0].v.string));
		}
#line 2608 "parse.c"
    break;

  case 73: /* serveropts1: SSH_HOSTKEY_RSA STRING  */
#line 908 "parse.y"
                                         {
			int i = GOTWEBD_SSHFP_RSA;

			if (*(yyvsp[0].v.string) == '\0') {
				yyerror("ssh host key fingerprint cannot be "
				    "an empty string");
				free((yyvsp[0].v.string));
				YYERROR;
			}

			if (strlcpy(new_srv->sshfp[i], (yyvsp[0].v.string),
			    sizeof(new_srv->sshfp[i])) >=
			    sizeof(new_srv->sshfp[i])) {
				yyerror("ssh host key fingerprint too long, "
				    "exceeds " "%zd bytes: %s",
				    sizeof(new_srv->sshfp[i]), (yyvsp[0].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			}

			free((yyvsp[0].v.string));
		}
#line 2635 "parse.c"
    break;

  case 80: /* websiteopts1: REPOSITORY STRING  */
#line 941 "parse.y"
                                    {
			n = strlcpy(new_website->repo_name, (yyvsp[0].v.string),
			    sizeof(new_website->repo_name));
			if (n >= sizeof(new_website->repo_name)) {
				yyerror("website repository name too long, "
				    "exceeds %zd bytes",
				    sizeof(new_website->repo_name) - 1);
				free((yyvsp[0].v.string));
				YYERROR;
			}
			free((yyvsp[0].v.string));
		}
#line 2652 "parse.c"
    break;

  case 81: /* websiteopts1: PATH STRING  */
#line 953 "parse.y"
                              {
			n = strlcpy(new_website->path, (yyvsp[0].v.string),
			    sizeof(new_website->path));
			if (n >= sizeof(new_website->path)) {
				yyerror("website in-repository path too long, "
				    "exceeds %zd bytes",
				    sizeof(new_website->path) - 1);
				free((yyvsp[0].v.string));
				YYERROR;
			}

			if (new_website->path[0] != '/') {
				yyerror("a website path must be an absolute "
				    "path: bad path %s", (yyvsp[0].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			}

			free((yyvsp[0].v.string));
		}
#line 2677 "parse.c"
    break;

  case 82: /* websiteopts1: BRANCH STRING  */
#line 973 "parse.y"
                                {
			n = strlcpy(new_website->branch_name, (yyvsp[0].v.string),
			    sizeof(new_website->branch_name));
			if (n >= sizeof(new_website->branch_name)) {
				yyerror("website branch name too long, "
				    "exceeds %zd bytes",
				    sizeof(new_website->branch_name) - 1);
				free((yyvsp[0].v.string));
				YYERROR;
			}
			free((yyvsp[0].v.string));
		}
#line 2694 "parse.c"
    break;

  case 83: /* websiteopts1: DISABLE AUTHENTICATION  */
#line 985 "parse.y"
                                         {
			if (new_website->auth_config != 0) {
				yyerror("ambiguous authentication "
				    "setting for website %s",
				    new_website->path);
				YYERROR;
			}
			new_website->auth_config = GOTWEBD_AUTH_DISABLED;
		}
#line 2708 "parse.c"
    break;

  case 84: /* websiteopts1: ENABLE AUTHENTICATION  */
#line 994 "parse.y"
                                        {
			if (new_website->auth_config != 0) {
				yyerror("ambiguous authentication "
				    "setting for website %s",
				    new_website->path);
				YYERROR;
			}
			new_website->auth_config = GOTWEBD_AUTH_SECURE;
		}
#line 2722 "parse.c"
    break;

  case 85: /* websiteopts1: ENABLE AUTHENTICATION INSECURE  */
#line 1003 "parse.y"
                                                 {
			if (new_website->auth_config != 0) {
				yyerror("ambiguous authentication "
				    "setting for website %s",
				    new_website->path);
				YYERROR;
			}
			new_website->auth_config = GOTWEBD_AUTH_INSECURE;
		}
#line 2736 "parse.c"
    break;

  case 86: /* websiteopts1: PERMIT numberstring  */
#line 1012 "parse.y"
                                      {
			conf_new_access_rule(&new_website->access_rules,
			    GOTWEBD_ACCESS_PERMITTED, (yyvsp[0].v.string));
		}
#line 2745 "parse.c"
    break;

  case 87: /* websiteopts1: DENY numberstring  */
#line 1016 "parse.y"
                                    {
			conf_new_access_rule(&new_website->access_rules,
			    GOTWEBD_ACCESS_DENIED, (yyvsp[0].v.string));
		}
#line 2754 "parse.c"
    break;

  case 88: /* $@2: %empty  */
#line 1022 "parse.y"
                                 {
			new_website = conf_new_website(new_srv, (yyvsp[0].v.string));
			free((yyvsp[0].v.string));
		}
#line 2763 "parse.c"
    break;

  case 89: /* website: WEBSITE STRING $@2 '{' optnl websiteopts2 '}'  */
#line 1025 "parse.y"
                                             {
		}
#line 2770 "parse.c"
    break;

  case 90: /* $@3: %empty  */
#line 1029 "parse.y"
                                    {
			struct gotwebd_repo *repo;

			TAILQ_FOREACH(repo, &new_srv->repos, entry) {
				if (strcmp(repo->name, (yyvsp[0].v.string)) == 0) {
					yyerror("duplicate repository "
					    "'%s' in server '%s'", (yyvsp[0].v.string),
					    new_srv->name);
					free((yyvsp[0].v.string));
					YYERROR;
				}
			}

			new_repo = conf_new_repo(new_srv, (yyvsp[0].v.string));
			free((yyvsp[0].v.string));
		}
#line 2791 "parse.c"
    break;

  case 91: /* repository: REPOSITORY STRING $@3 '{' optnl repoopts2 '}'  */
#line 1044 "parse.y"
                                          {
		}
#line 2798 "parse.c"
    break;

  case 94: /* repoopts1: DISABLE AUTHENTICATION  */
#line 1052 "parse.y"
                                         {
			if (new_repo->auth_config != 0) {
				yyerror("ambiguous authentication "
				    "setting for repository %s",
				    new_repo->name);
				YYERROR;
			}
			new_repo->auth_config = GOTWEBD_AUTH_DISABLED;
		}
#line 2812 "parse.c"
    break;

  case 95: /* repoopts1: ENABLE AUTHENTICATION  */
#line 1061 "parse.y"
                                        {
			if (new_repo->auth_config != 0) {
				yyerror("ambiguous authentication "
				    "setting for repository %s",
				    new_repo->name);
				YYERROR;
			}
			new_repo->auth_config = GOTWEBD_AUTH_SECURE;
		}
#line 2826 "parse.c"
    break;

  case 96: /* repoopts1: ENABLE AUTHENTICATION INSECURE  */
#line 1070 "parse.y"
                                                 {
			if (new_repo->auth_config != 0) {
				yyerror("ambiguous authentication "
				    "setting for repository %s",
				    new_repo->name);
				YYERROR;
			}
			new_repo->auth_config = GOTWEBD_AUTH_INSECURE;
		}
#line 2840 "parse.c"
    break;

  case 97: /* repoopts1: PERMIT numberstring  */
#line 1079 "parse.y"
                                      {
			conf_new_access_rule(&new_repo->access_rules,
			    GOTWEBD_ACCESS_PERMITTED, (yyvsp[0].v.string));
		}
#line 2849 "parse.c"
    break;

  case 98: /* repoopts1: DENY numberstring  */
#line 1083 "parse.y"
                                    {
			conf_new_access_rule(&new_repo->access_rules,
			    GOTWEBD_ACCESS_DENIED, (yyvsp[0].v.string));
		}
#line 2858 "parse.c"
    break;

  case 99: /* repoopts1: HIDE REPOSITORY boolean  */
#line 1087 "parse.y"
                                          {
			new_repo->hidden = (yyvsp[0].v.number);
		}
#line 2866 "parse.c"
    break;

  case 100: /* repoopts1: DESCRIPTION STRING  */
#line 1090 "parse.y"
                                     {
			n = strlcpy(new_repo->description, (yyvsp[0].v.string),
			    sizeof(new_repo->description));
			if (n >= sizeof(new_repo->description)) {
				yyerror("repository description too long, "
				    "exceeds %zd bytes",
				    sizeof(new_repo->description) - 1);
				free((yyvsp[0].v.string));
				YYERROR;
			}
		}
#line 2882 "parse.c"
    break;

  case 101: /* repoopts1: CLONE_URL STRING  */
#line 1101 "parse.y"
                                   {
			n = strlcpy(new_repo->clone_url, (yyvsp[0].v.string),
			    sizeof(new_repo->clone_url));
			if (n >= sizeof(new_repo->clone_url)) {
				yyerror("repository clone URL too long, "
				    "exceeds %zd bytes",
				    sizeof(new_repo->clone_url) - 1);
				free((yyvsp[0].v.string));
				YYERROR;
			}
		}
#line 2898 "parse.c"
    break;

  case 102: /* repoopts1: SSH_HOSTKEY_ECDSA STRING  */
#line 1112 "parse.y"
                                           {
			int i = GOTWEBD_SSHFP_ECDSA;

			if (*(yyvsp[0].v.string) == '\0') {
				yyerror("ssh host key fingerprint cannot be "
				    "an empty string");
				free((yyvsp[0].v.string));
				YYERROR;
			}

			if (strlcpy(new_repo->clone_url_hostkey[i], (yyvsp[0].v.string),
			    sizeof(new_repo->clone_url_hostkey[i])) >=
			    sizeof(new_repo->clone_url_hostkey[i])) {
				yyerror("ssh host key fingerprint too long, "
				    "exceeds " "%zd bytes: %s",
				    sizeof(new_repo->clone_url_hostkey[i]), (yyvsp[0].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			}

			free((yyvsp[0].v.string));
		}
#line 2925 "parse.c"
    break;

  case 103: /* repoopts1: SSH_HOSTKEY_ED25519 STRING  */
#line 1134 "parse.y"
                                             {
			int i = GOTWEBD_SSHFP_ED25519;

			if (*(yyvsp[0].v.string) == '\0') {
				yyerror("ssh host key fingerprint cannot be "
				    "an empty string");
				free((yyvsp[0].v.string));
				YYERROR;
			}

			if (strlcpy(new_repo->clone_url_hostkey[i], (yyvsp[0].v.string),
			    sizeof(new_repo->clone_url_hostkey[i])) >=
			    sizeof(new_repo->clone_url_hostkey[i])) {
				yyerror("ssh host key fingerprint too long, "
				    "exceeds " "%zd bytes: %s",
				    sizeof(new_repo->clone_url_hostkey[i]), (yyvsp[0].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			}

			free((yyvsp[0].v.string));
		}
#line 2952 "parse.c"
    break;

  case 104: /* repoopts1: SSH_HOSTKEY_RSA STRING  */
#line 1156 "parse.y"
                                         {
			int i = GOTWEBD_SSHFP_RSA;

			if (*(yyvsp[0].v.string) == '\0') {
				yyerror("ssh host key fingerprint cannot be "
				    "an empty string");
				free((yyvsp[0].v.string));
				YYERROR;
			}

			if (strlcpy(new_repo->clone_url_hostkey[i], (yyvsp[0].v.string),
			    sizeof(new_repo->clone_url_hostkey[i])) >=
			    sizeof(new_repo->clone_url_hostkey[i])) {
				yyerror("ssh host key fingerprint too long, "
				    "exceeds " "%zd bytes: %s",
				    sizeof(new_repo->clone_url_hostkey[i]), (yyvsp[0].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			}

			free((yyvsp[0].v.string));
		}
#line 2979 "parse.c"
    break;

  case 110: /* mediastring: STRING '/' STRING  */
#line 1191 "parse.y"
                                        {
			if (mediatype_ok((yyvsp[-2].v.string)) == -1 || mediatype_ok((yyvsp[0].v.string)) == -1) {
				yyerror("malformed media type: %s/%s", (yyvsp[-2].v.string), (yyvsp[0].v.string));
				free((yyvsp[-2].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			}

			if (strlcpy(media.media_type, (yyvsp[-2].v.string),
			    sizeof(media.media_type)) >=
			    sizeof(media.media_type) ||
			    strlcpy(media.media_subtype, (yyvsp[0].v.string),
			    sizeof(media.media_subtype)) >=
			    sizeof(media.media_subtype)) {
				yyerror("media type too long");
				free((yyvsp[-2].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			}
			free((yyvsp[-2].v.string));
			free((yyvsp[0].v.string));
		}
#line 3006 "parse.c"
    break;

  case 113: /* medianamesl: numberstring  */
#line 1219 "parse.y"
                                                        {
			if (mediatype_ok((yyvsp[0].v.string)) == -1) {
				yyerror("malformed media name");
				free((yyvsp[0].v.string));
				YYERROR;
			}

			if (strlcpy(media.media_name, (yyvsp[0].v.string),
			    sizeof(media.media_name)) >=
			    sizeof(media.media_name)) {
				yyerror("media name too long");
				free((yyvsp[0].v.string));
				YYERROR;
			}
			free((yyvsp[0].v.string));

			if (media_add(&gotwebd->mediatypes, &media) == NULL) {
				yyerror("failed to add media type");
				YYERROR;
			}
		}
#line 3032 "parse.c"
    break;


#line 3036 "parse.c"

      default: break;
    }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", YY_CAST (yysymbol_kind_t, yyr1[yyn]), &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;

  *++yyvsp = yyval;

  /* Now 'shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */
  {
    const int yylhs = yyr1[yyn] - YYNTOKENS;
    const int yyi = yypgoto[yylhs] + *yyssp;
    yystate = (0 <= yyi && yyi <= YYLAST && yycheck[yyi] == *yyssp
               ? yytable[yyi]
               : yydefgoto[yylhs]);
  }

  goto yynewstate;


/*--------------------------------------.
| yyerrlab -- here on detecting error.  |
`--------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == YYEMPTY ? YYSYMBOL_YYEMPTY : YYTRANSLATE (yychar);
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
      yyerror (YY_("syntax error"));
    }

  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
         error, discard it.  */

      if (yychar <= YYEOF)
        {
          /* Return failure if at end of input.  */
          if (yychar == YYEOF)
            YYABORT;
        }
      else
        {
          yydestruct ("Error: discarding",
                      yytoken, &yylval);
          yychar = YYEMPTY;
        }
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:
  /* Pacify compilers when the user code never invokes YYERROR and the
     label yyerrorlab therefore never appears in user code.  */
  if (0)
    YYERROR;
  ++yynerrs;

  /* Do not reclaim the symbols of the rule whose action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;      /* Each real token shifted decrements this.  */

  /* Pop stack until we find a state that shifts the error token.  */
  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
        {
          yyn += YYSYMBOL_YYerror;
          if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYSYMBOL_YYerror)
            {
              yyn = yytable[yyn];
              if (0 < yyn)
                break;
            }
        }

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
        YYABORT;


      yydestruct ("Error: popping",
                  YY_ACCESSING_SYMBOL (yystate), yyvsp);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END


  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", YY_ACCESSING_SYMBOL (yyn), yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturnlab;


/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturnlab;


/*-----------------------------------------------------------.
| yyexhaustedlab -- YYNOMEM (memory exhaustion) comes here.  |
`-----------------------------------------------------------*/
yyexhaustedlab:
  yyerror (YY_("memory exhausted"));
  yyresult = 2;
  goto yyreturnlab;


/*----------------------------------------------------------.
| yyreturnlab -- parsing is finished, clean up and return.  |
`----------------------------------------------------------*/
yyreturnlab:
  if (yychar != YYEMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval);
    }
  /* Do not reclaim the symbols of the rule whose action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
                  YY_ACCESSING_SYMBOL (+*yyssp), yyvsp);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif

  return yyresult;
}

#line 1253 "parse.y"


struct keywords {
	const char	*k_name;
	int		 k_val;
};

int
yyerror(const char *fmt, ...)
{
	va_list ap;
	char *msg;

	file->errors++;
	va_start(ap, fmt);
	if (vasprintf(&msg, fmt, ap) == -1)
		fatalx("yyerror vasprintf");
	va_end(ap);
	logit(LOG_CRIT, "%s:%d: %s", file->name, yylval.lineno, msg);
	free(msg);
	return (0);
}

int
kw_cmp(const void *k, const void *e)
{
	return (strcmp(k, ((const struct keywords *)e)->k_name));
}

int
lookup(char *s)
{
	/* This has to be sorted always. */
	static const struct keywords keywords[] = {
		{ "authentication",		AUTHENTICATION },
		{ "branch",			BRANCH },
		{ "chroot",			CHROOT },
		{ "clone_url",			CLONE_URL },
		{ "control",			GOTWEBD_CONTROL },
		{ "custom_css",			CUSTOM_CSS },
		{ "deny",			DENY },
		{ "description",		DESCRIPTION },
		{ "disable",			DISABLE },
		{ "enable",			ENABLE },
		{ "gotweb_url_root",		GOTWEB_URL_ROOT },
		{ "hide",			HIDE },
		{ "hint",			HINT },
		{ "htdocs",			HTDOCS },
		{ "include",			INCLUDE },
		{ "insecure",			INSECURE },
		{ "listen",			LISTEN },
		{ "login",			GOTWEBD_LOGIN },
		{ "logo",			LOGO },
		{ "logo_url",			LOGO_URL },
		{ "max_commits_display",	MAX_COMMITS_DISPLAY },
		{ "max_repos_display",		MAX_REPOS_DISPLAY },
		{ "on",				ON },
		{ "path",			PATH },
		{ "permit",			PERMIT },
		{ "port",			PORT },
		{ "prefork",			PREFORK },
		{ "repos_path",			REPOS_PATH },
		{ "repos_url_path",		REPOS_URL_PATH },
		{ "repositories",		REPOSITORIES },
		{ "repository",			REPOSITORY },
		{ "respect_exportok",		RESPECT_EXPORTOK },
		{ "server",			SERVER },
		{ "show_repo_age",		SHOW_REPO_AGE },
		{ "show_repo_cloneurl",		SHOW_REPO_CLONEURL },
		{ "show_repo_description",	SHOW_REPO_DESCRIPTION },
		{ "show_repo_owner",		SHOW_REPO_OWNER },
		{ "show_site_owner",		SHOW_SITE_OWNER },
		{ "site_link",			SITE_LINK },
		{ "site_name",			SITE_NAME },
		{ "site_owner",			SITE_OWNER },
		{ "socket",			SOCKET },
		{ "ssh_hostkey_ecdsa",		SSH_HOSTKEY_ECDSA},
		{ "ssh_hostkey_ed25519",	SSH_HOSTKEY_ED25519},
		{ "ssh_hostkey_rsa",		SSH_HOSTKEY_RSA},
		{ "summary_commits_display",	SUMMARY_COMMITS_DISPLAY },
		{ "summary_tags_display",	SUMMARY_TAGS_DISPLAY },
		{ "types",			TYPES },
		{ "user",			USER },
		{ "website",			WEBSITE },
		{ "www",			WWW },
	};
	const struct keywords *p;

	p = bsearch(s, keywords, sizeof(keywords)/sizeof(keywords[0]),
	    sizeof(keywords[0]), kw_cmp);

	if (p)
		return (p->k_val);
	else
		return (STRING);
}

#define START_EXPAND	1
#define DONE_EXPAND	2

static int	expanding;

int
igetc(void)
{
	int	c;

	while (1) {
		if (file->ungetpos > 0)
			c = file->ungetbuf[--file->ungetpos];
		else
			c = getc(file->stream);

		if (c == START_EXPAND)
			expanding = 1;
		else if (c == DONE_EXPAND)
			expanding = 0;
		else
			break;
	}
	return c;
}

int
lgetc(int quotec)
{
	int c, next;

	if (quotec) {
		if ((c = igetc()) == EOF) {
			yyerror("reached end of file while parsing "
			    "quoted string");
			if (file == topfile || popfile() == EOF)
				return EOF;
			return quotec;
		}
		return c;
	}

	while ((c = igetc()) == '\\') {
		next = igetc();
		if (next != '\n') {
			c = next;
			break;
		}
		yylval.lineno = file->lineno;
		file->lineno++;
	}

	if (c == EOF) {
		/*
		 * Fake EOL when hit EOF for the first time. This gets line
		 * count right if last line in included file is syntactically
		 * invalid and has no newline.
		 */
		if (file->eof_reached == 0) {
			file->eof_reached = 1;
			return '\n';
		}
		while (c == EOF) {
			if (file == topfile || popfile() == EOF)
				return EOF;
			c = igetc();
		}
	}
	return (c);
}

void
lungetc(int c)
{
	if (c == EOF)
		return;
	if (file->ungetpos >= file->ungetsize) {
		void *p = reallocarray(file->ungetbuf, file->ungetsize, 2);
		if (p == NULL)
			fatal("reallocarray");
		file->ungetbuf = p;
		file->ungetsize *= 2;
	}
	file->ungetbuf[file->ungetpos++] = c;
}

int
findeol(void)
{
	int c;

	/* Skip to either EOF or the first real EOL. */
	while (1) {
		c = lgetc(0);
		if (c == '\n') {
			file->lineno++;
			break;
		}
		if (c == EOF)
			break;
	}
	return (ERROR);
}

int
yylex(void)
{
	unsigned char buf[8096];
	unsigned char *p, *val;
	int quotec, next, c;
	int token;

 top:
	p = buf;
	c = lgetc(0);
	while (c == ' ' || c == '\t')
		c = lgetc(0); /* nothing */

	yylval.lineno = file->lineno;
	if (c == '#') {
		c = lgetc(0);
		while (c != '\n' && c != EOF)
			c = lgetc(0); /* nothing */
	}
	if (c == '$' && !expanding) {
		while (1) {
			c = lgetc(0);
			if (c == EOF)
				return (0);

			if (p + 1 >= buf + sizeof(buf) - 1) {
				yyerror("string too long");
				return (findeol());
			}
			if (isalnum(c) || c == '_') {
				*p++ = c;
				continue;
			}
			*p = '\0';
			lungetc(c);
			break;
		}
		val = symget(buf);
		if (val == NULL) {
			yyerror("macro '%s' not defined", buf);
			return (findeol());
		}
		p = val + strlen(val) - 1;
		lungetc(DONE_EXPAND);
		while (p >= val) {
			lungetc((unsigned char)*p);
			p--;
		}
		lungetc(START_EXPAND);
		goto top;
	}

	switch (c) {
	case '\'':
	case '"':
		quotec = c;
		while (1) {
			c = lgetc(quotec);
			if (c == EOF)
				return (0);
			if (c == '\n') {
				file->lineno++;
				continue;
			} else if (c == '\\') {
				next = lgetc(quotec);
				if (next == EOF)
					return (0);
				if (next == quotec || c == ' ' || c == '\t')
					c = next;
				else if (next == '\n') {
					file->lineno++;
					continue;
				} else
					lungetc(next);
			} else if (c == quotec) {
				*p = '\0';
				break;
			} else if (c == '\0') {
				yyerror("syntax error");
				return (findeol());
			}
			if (p + 1 >= buf + sizeof(buf) - 1) {
				yyerror("string too long");
				return (findeol());
			}
			*p++ = c;
		}
		yylval.v.string = strdup(buf);
		if (yylval.v.string == NULL)
			err(1, "yylex: strdup");
		return (STRING);
	}

#define allowed_to_end_number(x) \
	(isspace(x) || x == ')' || x ==',' || x == '/' || x == '}' || x == '=')

	if (c == '-' || isdigit(c)) {
		do {
			*p++ = c;
			if ((unsigned)(p-buf) >= sizeof(buf)) {
				yyerror("string too long");
				return (findeol());
			}
			c = lgetc(0);
		} while (c != EOF && isdigit(c));
		lungetc(c);
		if (p == buf + 1 && buf[0] == '-')
			goto nodigits;
		if (c == EOF || allowed_to_end_number(c)) {
			const char *errstr = NULL;

			*p = '\0';
			yylval.v.number = strtonum(buf, LLONG_MIN,
			    LLONG_MAX, &errstr);
			if (errstr) {
				yyerror("\"%s\" invalid number: %s",
				    buf, errstr);
				return (findeol());
			}
			return (NUMBER);
		} else {
nodigits:
			while (p > buf + 1)
				lungetc(*--p);
			c = *--p;
			if (c == '-')
				return (c);
		}
	}

#define allowed_in_string(x) \
	(isalnum(x) || (ispunct(x) && x != '(' && x != ')' && \
	x != '{' && x != '}' && \
	x != '!' && x != '=' && x != '#' && \
	x != ',' && x != '/'))

	if (isalnum(c) || c == ':' || c == '_') {
		do {
			*p++ = c;
			if ((unsigned)(p-buf) >= sizeof(buf)) {
				yyerror("string too long");
				return (findeol());
			}
			c = lgetc(0);
		} while (c != EOF && (allowed_in_string(c)));
		lungetc(c);
		*p = '\0';
		token = lookup(buf);
		if (token == STRING) {
			yylval.v.string = strdup(buf);
			if (yylval.v.string == NULL)
				err(1, "yylex: strdup");
		}
		return (token);
	}
	if (c == '\n') {
		yylval.lineno = file->lineno;
		file->lineno++;
	}
	if (c == EOF)
		return (0);
	return (c);
}

int
check_file_secrecy(int fd, const char *fname)
{
	struct stat st;

	if (fstat(fd, &st)) {
		log_warn("cannot stat %s", fname);
		return (-1);
	}
	if (st.st_uid != 0 && st.st_uid != getuid()) {
		log_warnx("%s: owner not root or current user", fname);
		return (-1);
	}
	if (st.st_mode & (S_IWGRP | S_IXGRP | S_IRWXO)) {
		log_warnx("%s: group writable or world read/writable", fname);
		return (-1);
	}
	return (0);
}

struct file *
pushfile(const char *name, int secret)
{
	struct file *nfile;

	nfile = calloc(1, sizeof(struct file));
	if (nfile == NULL) {
		log_warn("calloc");
		return (NULL);
	}
	nfile->name = strdup(name);
	if (nfile->name == NULL) {
		log_warn("strdup");
		free(nfile);
		return (NULL);
	}
	nfile->stream = fopen(nfile->name, "r");
	if (nfile->stream == NULL) {
		/* no warning, we don't require a conf file */
		if (topfile != NULL)
			log_warn("can't open %s", nfile->name);
		free(nfile->name);
		free(nfile);
		return (NULL);
	} else if (secret &&
	    check_file_secrecy(fileno(nfile->stream), nfile->name)) {
		fclose(nfile->stream);
		free(nfile->name);
		free(nfile);
		return (NULL);
	}
	nfile->lineno = TAILQ_EMPTY(&files) ? 1 : 0;
	nfile->ungetsize = 16;
	nfile->ungetbuf = calloc(1, nfile->ungetsize);
	if (nfile->ungetbuf == NULL) {
		log_warn("calloc");
		fclose(nfile->stream);
		free(nfile->name);
		free(nfile);
		return (NULL);
	}
	TAILQ_INSERT_TAIL(&files, nfile, entry);
	return (nfile);
}

static int
popfile(void)
{
	struct file	*prev;

	if ((prev = TAILQ_PREV(file, files, entry)) != NULL)
		prev->errors += file->errors;

	TAILQ_REMOVE(&files, file, entry);
	fclose(file->stream);
	free(file->name);
	free(file->ungetbuf);
	free(file);
	file = prev;
	return file ? 0 : EOF;
}

static void
add_default_server(void)
{
	new_srv = conf_new_server(D_SITENAME);
	log_debug("%s: adding default server %s", __func__, D_SITENAME);
}

int
parse_config(const char *filename, struct gotwebd *env)
{
	struct sym *sym, *next;
	struct server *srv;
	struct gotwebd_repo *repo;
	size_t i;

	if (config_init(env) == -1)
		fatalx("failed to initialize configuration");

	gotwebd = env;

	file = pushfile(filename, 0);
	if (file != NULL) {
		/* we don't require a config file */
		topfile = file;
		yyparse();
		errors = file->errors;
		while (popfile() != EOF)
			;
	}

	if (errors)
		return -1;

	/* Free macros and check which have not been used. */
	TAILQ_FOREACH_SAFE(sym, &symhead, entry, next) {
		if ((gotwebd->gotwebd_verbose > 1) && !sym->used)
			fprintf(stderr, "warning: macro '%s' not used\n",
			    sym->nam);
		if (!sym->persist) {
			free(sym->nam);
			free(sym->val);
			TAILQ_REMOVE(&symhead, sym, entry);
			free(sym);
		}
	}

	/* just add default server if no config specified */
	if (TAILQ_EMPTY(&gotwebd->servers))
		add_default_server();

	/* load default mimes */
	if (RB_EMPTY(&gotwebd->mediatypes)) {
		struct media_type defaults[] = {
			{
				.media_name = "css",
				.media_type = "text",
				.media_subtype = "css",
			},
			{
				.media_name = "gif",
				.media_type = "image",
				.media_subtype = "gif",
			},
			{
				.media_name = "html",
				.media_type = "text",
				.media_subtype = "html",
			},
			{
				.media_name = "ico",
				.media_type = "image",
				.media_subtype = "x-icon",
			},
			{
				.media_name = "png",
				.media_type = "image",
				.media_subtype = "png",
			},
			{
				.media_name = "jpeg",
				.media_type = "image",
				.media_subtype = "jpeg",
			},
			{
				.media_name = "jpg",
				.media_type = "image",
				.media_subtype = "jpeg",
			},
			{
				.media_name = "js",
				.media_type = "application",
				.media_subtype = "javascript",
			},
			{
				.media_name = "svg",
				.media_type = "image",
				.media_subtype = "svg+xml",
			},
			{
				.media_name = "txt",
				.media_type = "text",
				.media_subtype = "plain",
			},
			{
				.media_name = "webmanifest",
				.media_type = "application",
				.media_subtype = "manifest+json",
			},
			{
				.media_name = "xml",
				.media_type = "text",
				.media_subtype = "xml",
			},
		};
		size_t i;

		for (i = 0; i < nitems(defaults); ++i) {
			if (media_add(&gotwebd->mediatypes, &defaults[i]) == NULL) {
				fprintf(stderr, "failed to load default"
				    " MIME types\n");
				return -1;
			}
		}
	}

	/* add the implicit listen on socket */
	if (TAILQ_EMPTY(&gotwebd->addresses)) {
		char path[_POSIX_PATH_MAX];
		struct address *h;

		if (strlcpy(path, gotwebd->httpd_chroot, sizeof(path))
		    >= sizeof(path)) {
			fprintf(stderr, "chroot path too long: %s",
			    gotwebd->httpd_chroot);
			return -1;
		}
		if (strlcat(path, D_UNIX_SOCKET, sizeof(path))
		    >= sizeof(path)) {
			fprintf(stderr, "chroot path too long: %s",
			    gotwebd->httpd_chroot);
			return -1;
		}
		h = get_unix_addr(path);
		if (h == NULL) {
			fprintf(stderr, "can't listen on %s", path);
			return -1;
		} else
			add_addr(h);
	}


	/* setup our listening sockets */
	sockets_parse_sockets(env);

	/* Add implicit login socket */
	if (gotwebd->login_sock == NULL) {
		struct address *h;
		h = get_unix_addr(GOTWEBD_LOGIN_SOCKET);
		if (h == NULL) {
			fprintf(stderr, "cannot listen on %s",
			    GOTWEBD_LOGIN_SOCKET);
			return (-1);
		}
		gotwebd->login_sock = sockets_conf_new_socket(-1, h);
		free(h);
	}

	/* Add implicit control socket */
	if (gotwebd->control_sock == NULL) {
		struct address *h;
		h = get_unix_addr(GOTWEBD_CONTROL_SOCKET);
		if (h == NULL) {
			fprintf(stderr, "cannot listen on %s",
			    GOTWEBD_CONTROL_SOCKET);
			return (-1);
		}
		gotwebd->control_sock = sockets_conf_new_socket(-1, h);
		free(h);
	}

	/*
	 * Disable authentication if not explicitly configured.
	 * Authentication requires access rules to be configured, and we want
	 * gotwebd to work out of the box if no configuration file exists.
	 */
	switch (env->auth_config) {
	case GOTWEBD_AUTH_SECURE:
	case GOTWEBD_AUTH_INSECURE:
	case GOTWEBD_AUTH_DISABLED:
		break;
	default:
		env->auth_config = GOTWEBD_AUTH_DISABLED;
		break;
	}

	/* Inherit implicit configuration from parent scope. */
	TAILQ_FOREACH(srv, &env->servers, entry) {
		for (i = 0; i < GOTWEBD_NUM_SSHFP; i++) {
			if (srv->sshfp[i][0] == '\0' &&
			    env->sshfp[i][0] != '\0' &&
			    strlcpy(srv->sshfp[i], env->sshfp[i],
			    sizeof(srv->sshfp[i])) >= sizeof(srv->sshfp[i])) {
				fprintf(stderr, "ssh host key fingerprint too "
				    "long, exceeds %zd bytes: %s",
				    sizeof(srv->sshfp[i]), env->sshfp[i]);
				return -1;
			}
		}

		if (srv->auth_config == 0)
			srv->auth_config = env->auth_config;
		TAILQ_FOREACH(repo, &srv->repos, entry) {
			if (repo->auth_config == 0)
				repo->auth_config = srv->auth_config;
			if (repo->hidden == -1)
				repo->hidden = srv->hide_repositories;

			for (i = 0; i < GOTWEBD_NUM_SSHFP; i++) {
				if (repo->clone_url_hostkey[i][0] == '\0' &&
				    srv->sshfp[i][0] != '\0' &&
				    strlcpy(repo->clone_url_hostkey[i],
				    srv->sshfp[i],
				    sizeof(repo->clone_url_hostkey[i])) >=
				    sizeof(repo->clone_url_hostkey[i])) {
					fprintf(stderr, "ssh host key "
					    "fingerprint too long, exceeds "
					    "%zd bytes: %s",
					    sizeof(repo->clone_url_hostkey[i]),
					    srv->sshfp[i]);
					return -1;
				}
			}
		}

		if (srv->login_hint_user[0] == '\0') {
			if (strlcpy(srv->login_hint_user, env->login_hint_user,
			    sizeof(srv->login_hint_user)) >=
			    sizeof(srv->login_hint_user)) {
				fprintf(stderr, "login hint user name too "
				    "long, exceeds %zd bytes",
				    sizeof(srv->login_hint_user) - 1);
				return -1;
			}
		}

		if (srv->login_hint_port[0] == '\0') {
			if (strlcpy(srv->login_hint_port, env->login_hint_port,
			    sizeof(srv->login_hint_port)) >=
			    sizeof(srv->login_hint_port)) {
				fprintf(stderr, "login hint port number too "
				    "long, exceeds %zd bytes",
				    sizeof(srv->login_hint_port) - 1);
				return -1;
			}
		}

		if (srv->gotweb_url_root[0] == '\0') {
			if (strlcpy(srv->gotweb_url_root,
			    env->gotweb_url_root,
			    sizeof(srv->gotweb_url_root)) >=
			    sizeof(srv->gotweb_url_root)) {
				fprintf(stderr, "gotweb_url_root too long, "
				    "exceeds %zd bytes",
				    sizeof(srv->gotweb_url_root) - 1);
				return -1;
			}
		}

		if (srv->repos_url_path[0] == '\0') {
			if (strlcpy(srv->repos_url_path,
			    env->repos_url_path,
			    sizeof(srv->repos_url_path)) >=
			    sizeof(srv->repos_url_path)) {
				fprintf(stderr, "repos_url_path too long, "
				    "exceeds %zd bytes",
				    sizeof(srv->repos_url_path) - 1);
				return -1;
			}
		}
	}

	TAILQ_FOREACH(srv, &env->servers, entry) {
		const char *gotweb_url_root = srv->gotweb_url_root;
		const char *repos_url_path = srv->repos_url_path;
		struct got_pathlist_entry *pe;
		int ret;

		while (gotweb_url_root[0] == '/')
			gotweb_url_root++;

		while (repos_url_path[0] == '/')
			repos_url_path++;

		if (gotweb_url_root[0] == '\0' && repos_url_path[0] == '\0') {
			srv->full_repos_url_path[0] = '/';
			srv->full_repos_url_path[1] = '\0';
		} else {
			ret = snprintf(srv->full_repos_url_path,
			    sizeof(srv->full_repos_url_path),
			    "/%s%s%s", gotweb_url_root,
			    gotweb_url_root[0] ? "/" : "",
			    repos_url_path);
			if (ret == -1)
				fatal("snprintf");
			if ((size_t)ret >= sizeof(srv->full_repos_url_path)) {
				fprintf(stderr, "gotweb_url_root and "
				"repos_url_path too long, exceed %zd bytes",
				    sizeof(srv->full_repos_url_path) - 1);
				return -1;
			}
		}

		if (!got_path_is_root_dir(srv->full_repos_url_path)) {
			got_path_strip_trailing_slashes(
			    srv->full_repos_url_path);
		}

		RB_FOREACH(pe, got_pathlist_head, &srv->websites) {
			const char *url_path = pe->path;
			struct website *site = pe->data;

			if (site->auth_config == 0)
				site->auth_config = srv->auth_config;

			if (site->repo_name[0] == '\0') {
				fprintf(stderr, "no repository defined for "
				    "website %s' on server %s", url_path,
				    srv->name);
				return -1;
			}
		}
	}

	return (0);
}

struct server *
conf_new_server(const char *name)
{
	struct server *srv = NULL;

	srv = calloc(1, sizeof(*srv));
	if (srv == NULL)
		fatalx("%s: calloc", __func__);

	n = strlcpy(srv->name, name, sizeof(srv->name));
	if (n >= sizeof(srv->name))
		fatalx("%s: strlcpy", __func__);
	n = strlcpy(srv->repos_path, gotwebd->httpd_chroot,
	    sizeof(srv->repos_path));
	if (n >= sizeof(srv->repos_path))
		fatalx("%s: strlcpy", __func__);
	n = strlcat(srv->repos_path, D_GOTPATH,
	    sizeof(srv->repos_path));
	if (n >= sizeof(srv->repos_path))
		fatalx("%s: strlcat", __func__);
	n = strlcpy(srv->htdocs_path, D_HTDOCS_PATH,
	    sizeof(srv->htdocs_path));
	if (n >= sizeof(srv->htdocs_path))
		fatalx("%s: strlcpy", __func__);
	n = strlcpy(srv->site_name, D_SITENAME,
	    sizeof(srv->site_name));
	if (n >= sizeof(srv->site_name))
		fatalx("%s: strlcpy", __func__);
	n = strlcpy(srv->site_owner, D_SITEOWNER,
	    sizeof(srv->site_owner));
	if (n >= sizeof(srv->site_owner))
		fatalx("%s: strlcpy", __func__);
	n = strlcpy(srv->site_link, D_SITELINK,
	    sizeof(srv->site_link));
	if (n >= sizeof(srv->site_link))
		fatalx("%s: strlcpy", __func__);
	n = strlcpy(srv->logo, D_GOTLOGO,
	    sizeof(srv->logo));
	if (n >= sizeof(srv->logo))
		fatalx("%s: strlcpy", __func__);
	n = strlcpy(srv->logo_url, D_GOTURL, sizeof(srv->logo_url));
	if (n >= sizeof(srv->logo_url))
		fatalx("%s: strlcpy", __func__);
	n = strlcpy(srv->custom_css, D_GOTWEBCSS, sizeof(srv->custom_css));
	if (n >= sizeof(srv->custom_css))
		fatalx("%s: strlcpy", __func__);

	srv->show_site_owner = D_SHOWSOWNER;
	srv->show_repo_owner = D_SHOWROWNER;
	srv->show_repo_age = D_SHOWAGE;
	srv->show_repo_description = D_SHOWDESC;
	srv->show_repo_cloneurl = D_SHOWURL;
	srv->respect_exportok = D_RESPECTEXPORTOK;
	srv->hide_repositories = D_HIDE_REPOSITORIES;

	srv->max_repos_display = D_MAXREPODISP;
	srv->max_commits_display = D_MAXCOMMITDISP;
	srv->summary_commits_display = D_MAXSLCOMMDISP;
	srv->summary_tags_display = D_MAXSLTAGDISP;

	STAILQ_INIT(&srv->access_rules);
	TAILQ_INIT(&srv->repos);
	RB_INIT(&srv->websites);

	TAILQ_INSERT_TAIL(&gotwebd->servers, srv, entry);

	return srv;
};

int
symset(const char *nam, const char *val, int persist)
{
	struct sym *sym;

	TAILQ_FOREACH(sym, &symhead, entry) {
		if (strcmp(nam, sym->nam) == 0)
			break;
	}

	if (sym != NULL) {
		if (sym->persist == 1)
			return (0);
		else {
			free(sym->nam);
			free(sym->val);
			TAILQ_REMOVE(&symhead, sym, entry);
			free(sym);
		}
	}
	sym = calloc(1, sizeof(*sym));
	if (sym == NULL)
		return (-1);

	sym->nam = strdup(nam);
	if (sym->nam == NULL) {
		free(sym);
		return (-1);
	}
	sym->val = strdup(val);
	if (sym->val == NULL) {
		free(sym->nam);
		free(sym);
		return (-1);
	}
	sym->used = 0;
	sym->persist = persist;
	TAILQ_INSERT_TAIL(&symhead, sym, entry);
	return (0);
}

int
cmdline_symset(char *s)
{
	char *sym, *val;
	int ret;

	val = strrchr(s, '=');
	if (val == NULL)
		return (-1);

	sym = strndup(s, val - s);
	if (sym == NULL)
		fatal("%s: strndup", __func__);

	ret = symset(sym, val + 1, 1);
	free(sym);

	return (ret);
}

char *
symget(const char *nam)
{
	struct sym *sym;

	TAILQ_FOREACH(sym, &symhead, entry) {
		if (strcmp(nam, sym->nam) == 0) {
			sym->used = 1;
			return (sym->val);
		}
	}
	return (NULL);
}

int
get_addrs(const char *hostname, const char *servname)
{
	struct addrinfo hints, *res0, *res;
	int error;
	struct sockaddr_in *sin;
	struct sockaddr_in6 *sin6;
	struct address *h;

	memset(&hints, 0, sizeof(hints));
	hints.ai_family = AF_UNSPEC;
	hints.ai_socktype = SOCK_STREAM;
	hints.ai_flags = AI_PASSIVE | AI_ADDRCONFIG;
	error = getaddrinfo(hostname, servname, &hints, &res0);
	if (error) {
		log_warnx("%s: could not parse \"%s:%s\": %s", __func__,
		    hostname, servname, gai_strerror(error));
		return (-1);
	}

	for (res = res0; res; res = res->ai_next) {
		if ((h = calloc(1, sizeof(*h))) == NULL)
			fatal(__func__);

		if (hostname == NULL) {
			strlcpy(h->ifname, "*", sizeof(h->ifname));
		} else {
			if (strlcpy(h->ifname, hostname, sizeof(h->ifname)) >=
			    sizeof(h->ifname)) {
				log_warnx("%s: address truncated: %s",
				    __func__, hostname);
				freeaddrinfo(res0);
				free(h);
				return (-1);
			}
		}

		h->ai_family = res->ai_family;
		h->ai_socktype = res->ai_socktype;
		h->ai_protocol = res->ai_protocol;
		memcpy(&h->ss, res->ai_addr, res->ai_addrlen);
		h->slen = res->ai_addrlen;

		switch (res->ai_family) {
		case AF_INET:
			sin = (struct sockaddr_in *)res->ai_addr;
			h->port = ntohs(sin->sin_port);
			break;
		case AF_INET6:
			sin6 = (struct sockaddr_in6 *)res->ai_addr;
			h->port = ntohs(sin6->sin6_port);
			break;
		default:
			fatalx("unknown address family %d", res->ai_family);
		}

		add_addr(h);
	}
	freeaddrinfo(res0);
	return (0);
}

struct address *
get_unix_addr(const char *path)
{
	struct address *h;
	struct sockaddr_un *sun;

	if ((h = calloc(1, sizeof(*h))) == NULL)
		fatal("%s: calloc", __func__);

	h->ai_family = AF_UNIX;
	h->ai_socktype = SOCK_STREAM;
	h->ai_protocol = PF_UNSPEC;
	h->slen = sizeof(*sun);

	sun = (struct sockaddr_un *)&h->ss;
	sun->sun_family = AF_UNIX;
	if (strlcpy(sun->sun_path, path, sizeof(sun->sun_path)) >=
	    sizeof(sun->sun_path)) {
		log_warnx("socket path too long: %s", sun->sun_path);
		return NULL;
	}

	return h;
}

int
addr_dup_check(struct addresslist *al, struct address *h)
{
	struct address *a;

	TAILQ_FOREACH(a, al, entry) {
		if (a->ai_family != h->ai_family ||
		    a->ai_socktype != h->ai_socktype ||
		    a->ai_protocol != h->ai_protocol ||
		    a->slen != h->slen ||
		    memcmp(&a->ss, &h->ss, a->slen) != 0)
			continue;
		return -1;
	}

	return 0;
}

void
add_addr(struct address *h)
{
	if (addr_dup_check(&gotwebd->addresses, h) == 0) {
		TAILQ_INSERT_TAIL(&gotwebd->addresses, h, entry);
		return;
	}

	free(h);
}

static struct website *
conf_new_website(struct server *server, const char *url_path)
{
	const struct got_error *error;
	struct website *site;
	struct got_pathlist_entry *new;

	if (url_path[0] == '\0') {
		fatalx("syntax error: empty URL path found in %s",
		    file->name);
	}

	if (strchr(url_path, '\n') != NULL)
		fatalx("URL path must not contain linefeeds: %s", url_path);
	
	site = calloc(1, sizeof(*site));
	if (site == NULL)
		fatal("calloc");

	STAILQ_INIT(&site->access_rules);

	if (!got_path_is_absolute(url_path)) {
		int ret;

		ret = snprintf(site->url_path, sizeof(site->url_path),
		    "/%s", url_path);
		if (ret == -1)
			fatal("snprintf");
		if ((size_t)ret >= sizeof(site->url_path)) {
			fatalx("URL path too long (exceeds %zd bytes): %s",
			    sizeof(site->url_path) - 1, url_path);
		}
	} else {
		if (strlcpy(site->url_path, url_path,
		    sizeof(site->url_path)) >=
		    sizeof(site->url_path)) {
			fatalx("URL path too long (exceeds %zd bytes): %s",
			    sizeof(site->url_path) - 1, url_path);
		}
	}

	error = got_pathlist_insert(&new, &server->websites,
	    site->url_path, site);
	if (error)
		fatalx("%s: %s", __func__, error->msg);
	if (new == NULL) {
		fatalx("duplicate web site '%s' in server '%s'",
		    url_path, server->name);
	}

	return site;
}

struct gotwebd_repo *
gotwebd_new_repo(const char *name)
{
	struct gotwebd_repo *repo;

	repo = calloc(1, sizeof(*repo));
	if (repo == NULL)
		return NULL;

	STAILQ_INIT(&repo->access_rules);

	if (strlcpy(repo->name, name, sizeof(repo->name)) >=
	    sizeof(repo->name)) {
		free(repo);
		errno = ENOSPC;
		return NULL;
	}

	return repo;
}

static struct gotwebd_repo *
conf_new_repo(struct server *server, const char *name)
{
	struct gotwebd_repo *repo;

	if (name[0] == '\0') {
		fatalx("syntax error: empty repository name found in %s",
		    file->name);
	}

	if (strchr(name, '/') != NULL)
		fatalx("repository names must not contain slashes: %s", name);

	if (strchr(name, '\n') != NULL)
		fatalx("repository names must not contain linefeeds: %s", name);

	repo = gotwebd_new_repo(name);
	if (repo == NULL)
		fatal("gotwebd_new_repo");

	repo->hidden = -1;
	TAILQ_INSERT_TAIL(&server->repos, repo, entry);

	return repo;
};

static void
conf_new_access_rule(struct gotwebd_access_rule_list *rules,
    enum gotwebd_access access, char *identifier)
{
	struct gotwebd_access_rule *rule;

	rule = calloc(1, sizeof(*rule));
	if (rule == NULL)
		fatal("calloc");

	rule->access = access;
	if (strlcpy(rule->identifier, identifier,
	    sizeof(rule->identifier)) >= sizeof(rule->identifier))
		fatalx("identifier too long (max %zu bytes): %s",
		    sizeof(rule->identifier) - 1, identifier);

	STAILQ_INSERT_TAIL(rules, rule, entry);
}
