---
title: "Gopls release v0.21.0 (forthcoming)"
---

## Configuration changes

- The new `newGoFileHeader` option allows toggling automatic insertion of the copyright comment
  and package declaration in a newly created Go file.

## Web-based features
## Editing features
## Analysis features

### `reflecttypefor` analyzer

<!-- golang/go#60088 -->

The new `reflecttypefor` modernizer simplifies calls to
`reflect.TypeOf` to use `reflect.TypeFor` when the runtime type is
known at compile time. For example, `reflect.TypeOf(uint32(0))`
becomes `reflect.TypeFor[uint32]()`.

### `newexpr` analyzer

<!-- golang/go#45624 -->

The `newexpr` modernizer finds declarations of and calls to functions
of this form:
```go
func varOf(x int) *int { return &x }

use(varOf(123))
```
so that they are transformed to:
```go
//go:fix inline
func varOf(x int) *int { return new(x) }

use(new(123))
```
(Such wrapper functions are widely used in serialization packages,
for instance the proto.{Int64,String,Bool} helpers used with
protobufs.)

### `iterators` analyzer

<!-- golang/go#75693 -->

The `iterators` modernizer replaces loops of this form,

      for i := 0; i < x.Len(); i++ {
          use(x.At(i))
      }

or their "range x.Len()" equivalent, by

      for elem := range x.All() {
          use(x.At(i)
      }

for various types in the standard library that now offer an
iterator-based API.

## Code transformation features

<!-- golang/go#42301 -->
The Rename operation now treats [Doc Links](https://tip.golang.org/doc/comment#doclinks)
like identifiers, so you can initiate a renaming from a Doc Link.

<!--

### $feature

https://go.dev/issue#xxxxx

-->
