## Breaking Changes

None

## v7.1.xxxx

### Features

* `fanout`: new builtin (EXPERIMENTAL)
* REPL: default prompt modernized
* ANSI titlebar: Windows support added ([PR](https://github.com/lmorg/murex/pull/931))
* autocomplete: add support for substring matches ([discussion](https://github.com/lmorg/murex/discussions/934))
* autocomplete: remove `stat` syscall from recursive directory lookups to improve performance
* `foreach`: parallel support added (EXPERIMENTAL) ([discussion](https://github.com/lmorg/murex/discussions/933))
* macro vars: history support added (history stored in cache.db)
* integrations: `basti` autocomplete
* integrations: Charm Bracelet's `freeze`
* tooling: Makefile added for simplified development on POSIX systems
* `runtime --about`: `GOMAXPROCS` field added
* xml: improved interop between CSV and XML
* core: data types can now register what their layout type is. Allowing for `format` to better deduce how to reformat the data. eg next few refinements below
* csv: support for JSON and YAML maps
* yaml: convert tables to maps
* json: convert tables to maps
* `select`: support for maps
* `config`: new option: **syntax-completion-enabled**
* `config`: new option: **history-write-enabled**
* md: new datatype, markdown (EXPERIMENTAL)
* murex: new flag added: `-ignore-whatsnew`
* core: hint text added for `cd -` ([PR](https://github.com/lmorg/murex/pull/951))
* core: errors reformatted to make them slightly easier to read
* `test`: default test report now uses the full width of the terminal, plus other minor readability improvements
* docgen: new functions added
* docgen: support for metadata
* Update dependencies

### Bug Fixes

* `datetime`: stdout datatype set to `str`
* `fid-kill`: autocomplete fix ([issue](https://github.com/lmorg/murex/issues/949))
* exec: don't error on wait if PID is already closed ([issue](https://github.com/lmorg/murex/issues/946))
* spellcheck: fixed bug causing users to be re-prompted when `aspell` isn't installed
* REPL: fixed regression bug causing hint text not to display application hints
* `murex-package`: working directory preserved when installing packages
* readline: panic fixed in command line preview
* cache.db: fixed potential race condition when checking if cache.db is enabled
* REPL: fixed potential race condition when instantiating `readline`
* tests: `env` test skips on Windows, uses full path on POSIX
* tests: skip tilde parser test if username contains non-var chars (eg `@`)
* readline: null check when using tab grid
* readline: improved SGR detection
* readline: fixed wider character rendering bug when using tab grid
* readline: fixed potential race condition with read/write access to unicode slices
* readline: fixed potential race condition with terminal width caching
* readline: fixed potential race condition with asynchronous updates to tab completion
* readline: fixed potential race condition with hint text height reporting
* readline: fixed potential race condition with tab completion height reporting
* readline: fixed potential race condition with previews
* readline: fixed potential race condition with hint text cache

## Special Thanks

Thank yous for this release goes to [TheBearodactyl](https://github.com/TheBearodactyl), [JeffMelton](https://github.com/JeffMelton), [Th0rgal](https://github.com/Th0rgal), [lokalius](https://github.com/lokalius), [tiymat](https://github.com/tiymat) for your code, testing and feedback.

Also thank you to everyone in the [discussions group](https://github.com/lmorg/murex/discussions) and all who raise bug reports.

You rock!
