package docs

// This file was autogenerated by `docgen`
// Do NOT manually edit it. Any changes will be overwritten

func init() {
	Summary = map[string]string{

		"key-code":              "Returns character sequences for any key pressed (ie sent from the terminal)",
		"addheading":            "Adds headings to a table",
		"prefix":                "Prefix a string to every item in a list",
		"suffix":                "Prefix a string to every item in a list",
		"alias":                 "Create an alias for a command",
		"alter":                 "Change a value within a structured data-type and pass that change along the pipeline without altering the original source input",
		"append":                "Add data to the end of an array",
		"mjoin":                 "Joins a list or array into a single string",
		"prepend":               "Add data to the start of an array",
		"mtac":                  "Reverse the order of an array",
		"msort":                 "Sorts an array - data type agnostic",
		"bg":                    "Run processes in the background",
		"cpuarch":               "Output the hosts CPU architecture",
		"cpucount":              "Output the number of CPU cores available on your host",
		"catch":                 "Handles the exception code raised by `try` or `trypipe`",
		"cd":                    "Change (working) directory",
		"list.case":             "Changes the character case of a string or all elements in an array",
		"bexists":               "Check which builtins exist",
		"history":               "Outputs murex's command history",
		"count":                 "Count items in a map, list or array",
		"2darray":               "Create a 2D JSON array from multiple input sources",
		"ja":                    "A sophisticated yet simply way to build a JSON array",
		"map":                   "Creates a map from two data sources",
		"pipe":                  "Manage Murex named pipes",
		"ta":                    "A sophisticated yet simple way to build an array of a user defined data-type",
		"a":                     "A sophisticated yet simple way to stream an array or list (mkarray)",
		"tmp":                   "Create a temporary file and write to it",
		"datetime":              "A date and/or time conversion tool (like `printf` but for date and time values)",
		"debug":                 "Debugging information",
		"export":                "Define an environmental variable and set it's value",
		"args":                  "Command line flag parser for Murex shell scripting",
		"global":                "Define a global variable and set it's value",
		"openagent":             "Creates a handler function for `open`",
		"method":                "Define a methods supported data-types",
		"cast":                  "Alters the data-type of the previous function without altering its output",
		"set":                   "Define a variable (typically local) and set it's value",
		"unsafe":                "Execute a block of code, always returning a zero exit number",
		"type":                  "Command type (function, builtin, alias, etc)",
		"fid-list":              "Lists all running functions within the current Murex session",
		"getfile":               "Makes a standard HTTP request and return the contents as Murex-aware data type for passing along Murex pipelines.",
		"err":                   "Print a line to the stderr",
		"esccli":                "Escapes an array so output is valid shell code",
		"eschtml":               "Encode or decodes text for HTML",
		"escurl":                "Encode or decodes text for the URL",
		"exec":                  "Runs an executable",
		"fexec":                 "Execute a command or function, bypassing the usual order of precedence.",
		"exitnum":               "Output the exit number of the previous process",
		"return":                "Exits current function scope",
		"exit":                  "Exit murex",
		"break":                 "Terminate execution of a block within your processes scope",
		"expr":                  "Expressions: mathematical, string comparisons, logical operators",
		"false":                 "Returns a `false` value",
		"f":                     "Lists or filters file system objects (eg files)",
		"rx":                    "Regexp pattern matching for file system objects (eg `.*\\\\.txt`)",
		"formap":                "Iterate through a map or other collection of data",
		"foreach":               "Iterate through an array",
		"for":                   "A more familiar iteration loop to existing developers",
		"fg":                    "Sends a background process into the foreground",
		"runmode":               "Alter the scheduler's behaviour at higher scoping level",
		"rand":                  "Random field generator",
		"get-type":              "Returns the data-type of a variable or pipe",
		"pt":                    "Pipe telemetry. Writes data-types and bytes written",
		"g":                     "Glob pattern matching for file system objects (eg `*.txt`)",
		"get":                   "Makes a standard HTTP request and returns the result as a JSON object",
		"post":                  "HTTP POST request with a JSON-parsable return",
		"if":                    "Conditional statement to execute different blocks of code depending on the result of the condition",
		"source":                "Import Murex code from another file or code block",
		"is-null":               "Checks if a variable is null or undefined",
		"fid-killall":           "Terminate all running Murex functions in current session",
		"fid-kill":              "Terminate a running Murex function",
		"left":                  "Left substring every item in a list",
		"struct-keys":           "Outputs all the keys in a structure as a file path",
		"which":                 "Locate command origin",
		"lockfile":              "Create and manage lock files",
		"and":                   "Returns `true` or `false` depending on whether multiple conditions are met",
		"or":                    "Returns `true` or `false` depending on whether one code-block out of multiple ones supplied is successful or unsuccessful.",
		"while":                 "Loop until condition false",
		"man-summary":           "Outputs a man page summary of a command",
		"event":                 "Event driven programming for shell scripts",
		"murex-package":         "Murex's package manager",
		"version":               "Get Murex version",
		"murex-docs":            "Displays the man pages for Murex builtins",
		"continue":              "Terminate process of a block within a caller function",
		"not-func":              "Reads the stdin and exit number from previous process and not's it's condition",
		"devnull":               "null function. Similar to /dev/null",
		"open":                  "Open a file with a preferred handler",
		"os":                    "Output the auto-detected OS name",
		"out":                   "Print a string to the stdout with a trailing new line character",
		"tout":                  "Print a string to the stdout and set it's data-type",
		"man-get-flags":         "Parses man page files for command line flags",
		"murex-parser":          "Runs the Murex parser against a block of code",
		"trypipe":               "Checks for non-zero exits of each function in a pipeline",
		"pretty":                "Prettifies data documents to make it human readable",
		"private":               "Define a private function block",
		"time":                  "Returns the execution run time of a command or block",
		"function":              "Define a function block",
		"escape":                "Escape or unescape input",
		"murex-update-exe-list": "Forces Murex to rescan $PATH looking for executables",
		"read":                  "`read` a line of input from the user and store as a variable",
		"format":                "Reformat one data-type into another data-type",
		"regexp":                "Regexp tools for arrays / lists of strings",
		"open-image":            "Renders bitmap image data on your terminal",
		"right":                 "Right substring every item in a list",
		"round":                 "Round a number by a user defined precision",
		"signal":                "Sends a signal RPC",
		"fanout":                "Copies stdin and sends it to multiple pipelines, collating their output",
		"summary":               "Defines a summary help text for a command",
		"config":                "Query or define Murex runtime settings",
		"runtime":               "Returns runtime information on the internal state of Murex",
		"test":                  "Murex's test framework - define tests, run tests and debug shell scripts",
		"trypipeerr":            "Checks state of each function in a pipeline and exits block on error",
		"tryerr":                "Handles errors inside a block of code",
		"match":                 "Match an exact value in an array",
		"jsplit":                "Splits stdin into a JSON array based on a regex parameter",
		"switch":                "Blocks of cascading conditionals",
		"autocomplete":          "Set definitions for tab-completion in the command line",
		"tabulate":              "Table transformation tools",
		"true":                  "Returns a `true` value",
		"try":                   "Handles non-zero exits inside a block of code",

		"select": "Inlining SQL into shell pipelines",
		"bz2":    "Decompress a bz2 file",
		"base64": "Encode or decode a base64 string",
		"gz":     "Compress or decompress a gzip file",
		"qr":     "Creates a QR code from stdin",
		"sleep":  "Suspends the shell for a number of seconds",

		"commands/key-code":               "Returns character sequences for any key pressed (ie sent from the terminal)",
		"commands/addheading":             "Adds headings to a table",
		"commands/prefix":                 "Prefix a string to every item in a list",
		"commands/suffix":                 "Prefix a string to every item in a list",
		"commands/alias":                  "Create an alias for a command",
		"commands/alter":                  "Change a value within a structured data-type and pass that change along the pipeline without altering the original source input",
		"commands/append":                 "Add data to the end of an array",
		"commands/mjoin":                  "Joins a list or array into a single string",
		"commands/prepend":                "Add data to the start of an array",
		"commands/mtac":                   "Reverse the order of an array",
		"commands/msort":                  "Sorts an array - data type agnostic",
		"commands/bg":                     "Run processes in the background",
		"commands/cpuarch":                "Output the hosts CPU architecture",
		"commands/cpucount":               "Output the number of CPU cores available on your host",
		"commands/catch":                  "Handles the exception code raised by `try` or `trypipe`",
		"commands/cd":                     "Change (working) directory",
		"commands/list.case":              "Changes the character case of a string or all elements in an array",
		"commands/bexists":                "Check which builtins exist",
		"commands/history":                "Outputs murex's command history",
		"commands/count":                  "Count items in a map, list or array",
		"commands/2darray":                "Create a 2D JSON array from multiple input sources",
		"commands/ja":                     "A sophisticated yet simply way to build a JSON array",
		"commands/map":                    "Creates a map from two data sources",
		"commands/pipe":                   "Manage Murex named pipes",
		"commands/ta":                     "A sophisticated yet simple way to build an array of a user defined data-type",
		"commands/a":                      "A sophisticated yet simple way to stream an array or list (mkarray)",
		"commands/tmp":                    "Create a temporary file and write to it",
		"commands/datetime":               "A date and/or time conversion tool (like `printf` but for date and time values)",
		"commands/debug":                  "Debugging information",
		"commands/export":                 "Define an environmental variable and set it's value",
		"commands/args":                   "Command line flag parser for Murex shell scripting",
		"commands/global":                 "Define a global variable and set it's value",
		"commands/openagent":              "Creates a handler function for `open`",
		"commands/method":                 "Define a methods supported data-types",
		"commands/cast":                   "Alters the data-type of the previous function without altering its output",
		"commands/set":                    "Define a variable (typically local) and set it's value",
		"commands/unsafe":                 "Execute a block of code, always returning a zero exit number",
		"commands/type":                   "Command type (function, builtin, alias, etc)",
		"commands/fid-list":               "Lists all running functions within the current Murex session",
		"commands/getfile":                "Makes a standard HTTP request and return the contents as Murex-aware data type for passing along Murex pipelines.",
		"commands/err":                    "Print a line to the stderr",
		"commands/esccli":                 "Escapes an array so output is valid shell code",
		"commands/eschtml":                "Encode or decodes text for HTML",
		"commands/escurl":                 "Encode or decodes text for the URL",
		"commands/exec":                   "Runs an executable",
		"commands/fexec":                  "Execute a command or function, bypassing the usual order of precedence.",
		"commands/exitnum":                "Output the exit number of the previous process",
		"commands/return":                 "Exits current function scope",
		"commands/exit":                   "Exit murex",
		"commands/break":                  "Terminate execution of a block within your processes scope",
		"commands/expr":                   "Expressions: mathematical, string comparisons, logical operators",
		"commands/false":                  "Returns a `false` value",
		"commands/f":                      "Lists or filters file system objects (eg files)",
		"commands/rx":                     "Regexp pattern matching for file system objects (eg `.*\\\\.txt`)",
		"commands/formap":                 "Iterate through a map or other collection of data",
		"commands/foreach":                "Iterate through an array",
		"commands/for":                    "A more familiar iteration loop to existing developers",
		"commands/fg":                     "Sends a background process into the foreground",
		"commands/runmode":                "Alter the scheduler's behaviour at higher scoping level",
		"commands/rand":                   "Random field generator",
		"commands/get-type":               "Returns the data-type of a variable or pipe",
		"commands/pt":                     "Pipe telemetry. Writes data-types and bytes written",
		"commands/g":                      "Glob pattern matching for file system objects (eg `*.txt`)",
		"commands/get":                    "Makes a standard HTTP request and returns the result as a JSON object",
		"commands/post":                   "HTTP POST request with a JSON-parsable return",
		"commands/if":                     "Conditional statement to execute different blocks of code depending on the result of the condition",
		"commands/source":                 "Import Murex code from another file or code block",
		"commands/is-null":                "Checks if a variable is null or undefined",
		"commands/fid-killall":            "Terminate all running Murex functions in current session",
		"commands/fid-kill":               "Terminate a running Murex function",
		"commands/left":                   "Left substring every item in a list",
		"commands/struct-keys":            "Outputs all the keys in a structure as a file path",
		"commands/which":                  "Locate command origin",
		"commands/lockfile":               "Create and manage lock files",
		"commands/and":                    "Returns `true` or `false` depending on whether multiple conditions are met",
		"commands/or":                     "Returns `true` or `false` depending on whether one code-block out of multiple ones supplied is successful or unsuccessful.",
		"commands/while":                  "Loop until condition false",
		"commands/man-summary":            "Outputs a man page summary of a command",
		"commands/event":                  "Event driven programming for shell scripts",
		"commands/murex-package":          "Murex's package manager",
		"commands/version":                "Get Murex version",
		"commands/murex-docs":             "Displays the man pages for Murex builtins",
		"commands/continue":               "Terminate process of a block within a caller function",
		"commands/not-func":               "Reads the stdin and exit number from previous process and not's it's condition",
		"commands/devnull":                "null function. Similar to /dev/null",
		"commands/open":                   "Open a file with a preferred handler",
		"commands/os":                     "Output the auto-detected OS name",
		"commands/out":                    "Print a string to the stdout with a trailing new line character",
		"commands/tout":                   "Print a string to the stdout and set it's data-type",
		"commands/man-get-flags":          "Parses man page files for command line flags",
		"commands/murex-parser":           "Runs the Murex parser against a block of code",
		"commands/trypipe":                "Checks for non-zero exits of each function in a pipeline",
		"commands/pretty":                 "Prettifies data documents to make it human readable",
		"commands/private":                "Define a private function block",
		"commands/time":                   "Returns the execution run time of a command or block",
		"commands/function":               "Define a function block",
		"commands/escape":                 "Escape or unescape input",
		"commands/murex-update-exe-list":  "Forces Murex to rescan $PATH looking for executables",
		"commands/read":                   "`read` a line of input from the user and store as a variable",
		"commands/format":                 "Reformat one data-type into another data-type",
		"commands/regexp":                 "Regexp tools for arrays / lists of strings",
		"commands/open-image":             "Renders bitmap image data on your terminal",
		"commands/right":                  "Right substring every item in a list",
		"commands/round":                  "Round a number by a user defined precision",
		"commands/signal":                 "Sends a signal RPC",
		"commands/fanout":                 "Copies stdin and sends it to multiple pipelines, collating their output",
		"commands/summary":                "Defines a summary help text for a command",
		"commands/config":                 "Query or define Murex runtime settings",
		"commands/runtime":                "Returns runtime information on the internal state of Murex",
		"commands/test":                   "Murex's test framework - define tests, run tests and debug shell scripts",
		"commands/trypipeerr":             "Checks state of each function in a pipeline and exits block on error",
		"commands/tryerr":                 "Handles errors inside a block of code",
		"commands/match":                  "Match an exact value in an array",
		"commands/jsplit":                 "Splits stdin into a JSON array based on a regex parameter",
		"commands/switch":                 "Blocks of cascading conditionals",
		"commands/autocomplete":           "Set definitions for tab-completion in the command line",
		"commands/tabulate":               "Table transformation tools",
		"commands/true":                   "Returns a `true` value",
		"commands/try":                    "Handles non-zero exits inside a block of code",
		"mkarray/date":                    "Create arrays of dates",
		"mkarray/character":               "Making character arrays (a to z)",
		"mkarray/decimal":                 "Create arrays of decimal integers",
		"mkarray/non-decimal":             "Create arrays of integers from non-decimal number bases",
		"mkarray/special":                 "Create arrays from ranges of dictionary terms (eg weekdays, months, seasons, etc)",
		"optional/select":                 "Inlining SQL into shell pipelines",
		"optional/bz2":                    "Decompress a bz2 file",
		"optional/base64":                 "Encode or decode a base64 string",
		"optional/gz":                     "Compress or decompress a gzip file",
		"optional/qr":                     "Creates a QR code from stdin",
		"optional/sleep":                  "Suspends the shell for a number of seconds",
		"parser/expr-inlined":             "Inline expressions",
		"parser/c-style-fun":              "Inlined commands for expressions and statements",
		"parser/range":                    "Outputs a ranged subset of data from stdin",
		"parser/item-index":               "Outputs an element from an array, map or table",
		"parser/element":                  "Outputs an element from a nested structure",
		"parser/namedpipe":                "Reads from a Murex named pipe",
		"parser/stdin":                    "Read the stdin belonging to the parent code block",
		"parser/file-append":              "Writes stdin to disk - appending contents if file already exists",
		"parser/file-truncate":            "Writes stdin to disk - overwriting contents if file already exists",
		"parser/double-quote":             "Initiates or terminates a string (variables expanded)",
		"parser/scalar":                   "Expand values as a scalar",
		"parser/brace-quote":              "Initiates or terminates a string (variables expanded)",
		"parser/create-array":             "Quickly generate arrays",
		"parser/create-object":            "Quickly generate objects (dictionaries / maps)",
		"parser/logical-and":              "Continues next operation if previous operation passes",
		"parser/single-quote":             "Initiates or terminates a string (variables not expanded)",
		"parser/brace-quote-func":         "Write a string to the stdout without new line (deprecated)",
		"parser/multiply-by":              "Multiplies a variable by the right hand value (expression)",
		"parser/multiplication":           "Multiplies one numeric value with another (expression)",
		"parser/add-with":                 "Adds the right hand value to a variable (expression)",
		"parser/addition":                 "Adds two numeric values together (expression)",
		"parser/subtract-by":              "Subtracts a variable by the right hand value (expression)",
		"parser/pipe-arrow":               "Pipes stdout from the left hand command to stdin of the right hand command",
		"parser/subtraction":              "Subtracts one numeric value from another (expression)",
		"parser/divide-by":                "Divides a variable by the right hand value (expression)",
		"parser/division":                 "Divides one numeric value from another (expression)",
		"parser/assign-or-merge":          "Merges the right hand value to a variable on the left hand side (expression)",
		"parser/pipe-generic":             "Pipes a reformatted stdout stream from the left hand command to stdin of the right hand command",
		"parser/elvis":                    "Returns the right operand if the left operand is falsy (expression)",
		"parser/null-coalescing":          "Returns the right operand if the left operand is empty / undefined (expression)",
		"parser/array":                    "Expand values as an array",
		"parser/lambda":                   "Iterate through structured data",
		"parser/curly-brace":              "Initiates or terminates a code block",
		"parser/pipe-posix":               "Pipes stdout from the left hand command to stdin of the right hand command",
		"parser/logical-or":               "Continues next operation only if previous operation fails",
		"parser/tilde":                    "Home directory path variable",
		"events/oncommandcompletion":      "Trigger an event upon a command's completion",
		"events/onfilesystemchange":       "Add a filesystem watch",
		"events/onkeypress":               "Custom definable key bindings and macros",
		"events/onpreview":                "Full screen previews for files and command documentation",
		"events/onprompt":                 "Events triggered by changes in state of the interactive shell",
		"events/onsecondselapsed":         "Events triggered by time intervals",
		"events/onsignalreceived":         "Trap OS signals",
		"types/generic":                   "generic (primitive)",
		"types/bool":                      "Boolean (primitive)",
		"types/commonlog":                 "Apache httpd \"common\" log format",
		"types/csv":                       "CSV files (and other character delimited tables)",
		"types/float":                     "Floating point number (primitive)",
		"types/hcl":                       "HashiCorp Configuration Language (HCL)",
		"types/int":                       "Whole number (primitive)",
		"types/json":                      "JavaScript Object Notation (JSON)",
		"types/jsonc":                     "Concatenated JSON",
		"types/jsonl":                     "JSON Lines",
		"types/num":                       "Floating point number (primitive)",
		"types/path":                      "Structured object for working with file and directory paths",
		"types/paths":                     "Structured array for working with `$PATH` style data",
		"types/str":                       "string (primitive)",
		"types/toml":                      "Tom's Obvious, Minimal Language (TOML)",
		"types/xml":                       "Extensible Markup Language (XML) (experimental)",
		"types/yaml":                      "YAML Ain't Markup Language (YAML)",
		"types/mxjson":                    "Murex-flavoured JSON (deprecated)",
		"variables/numeric":               "Variables who's name is a positive integer, eg `0`, `1`, `2`, `3` and above",
		"variables/meta-values":           "State information for iteration blocks",
		"variables/argv":                  "Array of the command name and parameters within a given scope",
		"variables/columns":               "Character width of terminal",
		"variables/event_return":          "Return values for events",
		"variables/home":                  "Return the home directory for the current session user",
		"variables/hostname":              "Hostname of the current machine",
		"variables/lines":                 "Character height of terminal",
		"variables/logname":               "Username for the current session (historic)",
		"variables/murex_argv":            "Array of the command name and parameters passed to the current shell",
		"variables/murex_config_dir":      "Defines the path to Murex's config",
		"variables/murex_exe":             "Absolute path to running shell",
		"variables/murex_history":         "Defines the path to the `.murex_history` log",
		"variables/murex_modules":         "Defines the path to the modules directory",
		"variables/murex_preload":         "Defines the path to the `.murex_preload` script",
		"variables/murex_profile":         "Defines the path to the `.murex_profile` script",
		"variables/oldpwd":                "Return the home directory for the current session user",
		"variables/params":                "Array of the parameters within a given scope",
		"variables/pwdhist":               "History of each change to the sessions working directory",
		"variables/pwd":                   "Current working directory",
		"variables/random":                "Return a random 32-bit integer (historical)",
		"variables/self":                  "Meta information about the running scope.",
		"variables/shell":                 "Path of current shell",
		"variables/tmpdir":                "Return the temporary directory",
		"variables/user":                  "Username for the current session",
		"apis/Marshal":                    "Converts structured memory into a structured file format (eg for stdio)",
		"apis/ReadArray":                  "Read from a data type one array element at a time",
		"apis/ReadArrayWithType":          "Read from a data type one array element at a time and return the elements contents and data type",
		"apis/ReadIndex":                  "Data type handler for the index, `[`, builtin",
		"apis/ReadMap":                    "Treat data type as a key/value structure and read its contents",
		"apis/ReadNotIndex":               "Data type handler for the bang-prefixed index, `![`, builtin",
		"apis/Unmarshal":                  "Converts a structured file format into structured memory",
		"apis/WriteArray":                 "Write a data type, one array element at a time",
		"apis/lang.ArrayTemplate":         "Unmarshals a data type into a Go struct and returns the results as an array",
		"apis/lang.ArrayWithTypeTemplate": "Unmarshals a data type into a Go struct and returns the results as an array with data type included",
		"apis/lang.IndexTemplateObject":   "Returns element(s) from a data structure",
		"apis/lang.IndexTemplateTable":    "Returns element(s) from a table",
		"apis/lang.MarshalData":           "Converts structured memory into a Murex data-type (eg for stdio)",
		"apis/lang.UnmarshalData":         "Converts a Murex data-type into structured memory",
		"user-guide/ansi":                 "Infixed constants that return ANSI escape sequences",
		"user-guide/bang-prefix":          "Bang prefixing to reverse default actions",
		"user-guide/code-block":           "Overview of how code blocks are parsed",
		"user-guide/fileref":              "How to track what code was loaded and from where",
		"user-guide/hint-text":            "A status bar for your shell",
		"user-guide/integrations":         "Default integrations shipped with Murex",
		"user-guide/interactive-shell":    "What's different about Murex's interactive shell?",
		"user-guide/job-control":          "How to manage jobs with Murex",
		"user-guide/modules":              "Modules and packages: An Introduction",
		"user-guide/namedpipes":           "A detailed breakdown of named pipes in Murex",
		"user-guide/operators-and-tokens": "All supported operators and tokens",
		"user-guide/pipeline":             "Overview of what a \"pipeline\" is",
		"user-guide/profile":              "A breakdown of the different files loaded on start up",
		"user-guide/reserved-vars":        "Special variables reserved by Murex",
		"user-guide/rosetta-stone":        "A tabulated list of Bashism's and their equivalent Murex syntax",
		"user-guide/schedulers":           "Overview of the different schedulers (or 'run modes') in Murex",
		"user-guide/strict-types":         "Expressions can auto-convert types or strictly honour data types",
		"user-guide/terminal-keys":        "A list of all the terminal hotkeys and their uses",
		"user-guide/scoping":              "How scoping works within Murex",
		"user-guide/murex-arrays":         "Examples using arrays within Murex",
		"integrations/chatgpt":            "How to enable ChatGPT hints",
		"integrations/cheatsh":            "Cheatsheets provided by cheat.sh",
		"integrations/kitty":              "Get more out of Kitty terminal emulator",
		"integrations/make":               "`make` integrations",
		"integrations/man-pages":          "Linux/UNIX `man` page integrations",
		"integrations/spellcheck":         "How to enable inline spellchecking",
		"integrations/terminology":        "Get more out of Terminology terminal emulator",
		"integrations/direnv":             "Directory specific environmental variables",
		"integrations/yarn":               "Working with `yarn` and `package.json`",
		"integrations/iterm2":             "Get more out of iTerm2 terminal emulator",
		"changelog/v2.0":                  "This release comes with spellchecking, inlined images, smarter syntax completion and more",
		"changelog/v2.1":                  "This release comes with support for inlining SQL and some major bug fixes plus a breaking change for `config`. Please read for details.",
		"changelog/v2.10":                 "This release brings a few minor improvements and bug fixes rather than big new headline features.",
		"changelog/v2.11":                 "This release mainly focuses on refinements in performance and usability, rather than introducing new features",
		"changelog/v2.2":                  "This is mainly a bug fix release but it does include one breaking change for `config`. Please read for details.",
		"changelog/v2.3":                  "This release includes significant changes to the interactive terminal",
		"changelog/v2.4":                  "This release introduces a strict mode for variables, new builtin, performance improvements, and better error messages; plus a potential breaking change",
		"changelog/v2.5":                  "This release introduces a number of new builtins, fixes some regression bugs and supercharges the `select` optional builtin (which I plan to include into the core builtins for non-Windows users in the next release).",
		"changelog/v2.6":                  "This update has introduced a potential breaking change: variables now need to be defined before usage otherwise the commandline will fail. Read notes to learn how to disable this feature where needed. Also included in this release is the `select` command as part of the standard build.",
		"changelog/v2.7":                  "This update has introduced another potential breaking change for your safety: zero length arrays now fail by default. Also errors inside subshells will cause the parent command to fail if ran inside a `try` or `trypipe` block.",
		"changelog/v2.8":                  "This release comes with a number of experimental but stable features that might eventually become standard practice. The features are there to use if you with but adjacent from the older code so there is zero risk in updating to this version.",
		"changelog/v2.9":                  "This release focuses on testing and REPL usability improvements but also includes updates several new run modes to make error handling easier in larger scripts.",
		"changelog/v3.0":                  "This is a major release that brings a significant number of changes and improvements, including a complete overhaul of the parser. Backwards compatibility is a high priority however these new features bring greater readability and consistency to shell scripting. So while the older syntax remains for compatibility, it is worth migrating over to the newer syntax for all new code being written",
		"changelog/v3.1":                  "This release includes mostly bug fixes and new experimental features which are opt into. To enable all experimental features, set the environmental variable `MUREX_EXPERIMENTAL` to any value. Or you can enable specific features individually via `config`",
		"changelog/v4.0":                  "This release sees significant improvements for use with non-latin characters in both the interactive prompt and shell scripting. It introduces new syntax to make working with structured data even easier than before. As well as new data types and smoother user experience.",
		"changelog/v4.1":                  "The previous releases have brought significant advancements to Murex's syntax but at the cost of longer gaps between releases. So the 4.1.x versions will be shorter releases but focusing on bug fixes. The 4.1.x release notes will be appended to [murex.rocks changelog](https://murex.rocks/changelog/v4.1.html) and available on [Github releases](https://github.com/lmorg/murex/releases) too",
		"changelog/v4.2":                  "Murex usage has raised considerably in recent weeks. This release addresses a number of feature requests and bugs raised on Github.",
		"changelog/v4.3":                  "This brings improved support on Windows plus one breaking change from the previous release (v4.2)",
		"changelog/v4.4":                  "v4.4 features two new builtins, improvements in testing, and automatic generation of autocompletion suggestions backed by man page parsing. Plus there has been a lot of focus on improving _readline_ responsiveness",
		"changelog/v5.0":                  "v5.0 is a massive release. It brings along changes to syntax, new operators as well as new builtins, reserved variables and a new event",
		"changelog/v5.1":                  "This release brings new operators and a builtin, all for managing null types. There is also a substantial revamp to readline's responsiveness.",
		"changelog/v5.2":                  "The v5.2 release introduces significant new features and improvements for those using Murex as their interactive shell. Many of these features are unique to Murex.",
		"changelog/v5.3":                  "Caching has been vastly improved in this release due to a new sqlite3-backed persistent `cache.db`. There have also been some improvements to `[f1]` help pages",
		"changelog/v6.0":                  "Despite this being a new major version release, it is a vary minor update. Aside from a handful of bugfixes, the most significant change is notice of deprecation for `=`, `let`, and `?`.",
		"changelog/v6.1":                  "This release sees a massive jump in event-driven capabilities as well as several new features and bug fixes.",
		"changelog/v6.2":                  "Bug fix release",
		"changelog/v6.3":                  "This is a massive release ahead of the v7.0. This brings notifications of  new deprecations, new builtins, new flags, improved CI/CD flow, and changes to the website. Unfortunately it also carries 3 breaking changes.",
		"changelog/v6.4":                  "This change brings a number of ergonomic improvements to job control, `datetime` and working with structures.",
		"changelog/v7.0":                  "Introducing experimental support for XML, new integrations, and several other quality-of-life improvements. Four deprecated builtins have been removed too, which is this release sees an increment of its major version number",
		"changelog/v7.1":                  "This release focuses mainly on bugfixes and quality-of-life with the exception of three **experimental** new major additions:\n* `foreach` now supports running processes in parallel\n* `fanout` is a new builtin that allows sending stdout to the stdin of many processes\n* `md` is a new datatype added. Currently only supports rendering markdown tables but more features will follow in future releases",
		"changelog/v7.2":                  "This release brings several improvements for scripting environments in Javascript/Typescript and Python support. Core features include the new `--copy` flag for aliases to inherit shell configuration, and bugfixes to address autocomplete panics, expression error handling, and 3rd party integration issues.",
		"deprecated/equ":                  "Evaluate a mathematical function (removed 7.0)",
		"deprecated/die":                  "Terminate murex with an exit number of 1 (removed 7.0)",
		"deprecated/let":                  "Evaluate a mathematical function and assign to variable (removed 7.0)",
		"deprecated/tread":                "`read` a line of input from the user and store as a user defined *typed* variable (removed 7.0)",
		"deprecated/pipe-err":             "Pipes stderr from the left hand command to stdin of the right hand command (removed 8.0)",
	}

	Synonym = map[string]string{

		"key-code":              "key-code",
		"addheading":            "addheading",
		"prefix":                "prefix",
		"list.prefix":           "prefix",
		"suffix":                "suffix",
		"list.suffix":           "suffix",
		"alias":                 "alias",
		"!alias":                "alias",
		"alter":                 "alter",
		"~>":                    "alter",
		"append":                "append",
		"list.append":           "append",
		"mjoin":                 "mjoin",
		"list.join":             "mjoin",
		"prepend":               "prepend",
		"list.prepend":          "prepend",
		"mtac":                  "mtac",
		"list.reverse":          "mtac",
		"msort":                 "msort",
		"list.sort":             "msort",
		"bg":                    "bg",
		"cpuarch":               "cpuarch",
		"sys.cpu.arch":          "cpuarch",
		"cpucount":              "cpucount",
		"sys.cpu.count":         "cpucount",
		"catch":                 "catch",
		"!catch":                "catch",
		"cd":                    "cd",
		"list.case":             "list.case",
		"bexists":               "bexists",
		"history":               "history",
		"count":                 "count",
		"len":                   "count",
		"2darray":               "2darray",
		"ja":                    "ja",
		"map":                   "map",
		"pipe":                  "pipe",
		"!pipe":                 "pipe",
		"ta":                    "ta",
		"a":                     "a",
		"mkarray":               "a",
		"tmp":                   "tmp",
		"datetime":              "datetime",
		"str.datetime":          "datetime",
		"debug":                 "debug",
		"export":                "export",
		"!export":               "export",
		"unset":                 "export",
		"var.env":               "export",
		"!var.env":              "export",
		"args":                  "args",
		"global":                "global",
		"!global":               "global",
		"openagent":             "openagent",
		"!openagent":            "openagent",
		"method":                "method",
		"cast":                  "cast",
		"set":                   "set",
		"!set":                  "set",
		"unsafe":                "unsafe",
		"type":                  "type",
		"fid-list":              "fid-list",
		"jobs":                  "fid-list",
		"getfile":               "getfile",
		"err":                   "err",
		"esccli":                "esccli",
		"eschtml":               "eschtml",
		"!eschtml":              "eschtml",
		"escurl":                "escurl",
		"!escurl":               "escurl",
		"exec":                  "exec",
		"command":               "exec",
		"exec.file":             "exec",
		"fexec":                 "fexec",
		"builtin":               "fexec",
		"exec.builtin":          "fexec",
		"exec.function":         "fexec",
		"exec.private":          "fexec",
		"exitnum":               "exitnum",
		"return":                "return",
		"exit":                  "exit",
		"break":                 "break",
		"expr":                  "expr",
		"false":                 "false",
		"f":                     "f",
		"rx":                    "rx",
		"!rx":                   "rx",
		"formap":                "formap",
		"foreach":               "foreach",
		"for":                   "for",
		"fg":                    "fg",
		"runmode":               "runmode",
		"rand":                  "rand",
		"get-type":              "get-type",
		"pt":                    "pt",
		"g":                     "g",
		"!g":                    "g",
		"get":                   "get",
		"post":                  "post",
		"if":                    "if",
		"!if":                   "if",
		"source":                "source",
		".":                     "source",
		"is-null":               "is-null",
		"fid-killall":           "fid-killall",
		"fid-kill":              "fid-kill",
		"left":                  "left",
		"list.left":             "left",
		"struct-keys":           "struct-keys",
		"which":                 "which",
		"lockfile":              "lockfile",
		"and":                   "and",
		"!and":                  "and",
		"or":                    "or",
		"!or":                   "or",
		"while":                 "while",
		"!while":                "while",
		"man-summary":           "man-summary",
		"help.man.summary":      "man-summary",
		"event":                 "event",
		"!event":                "event",
		"murex-package":         "murex-package",
		"version":               "version",
		"murex-docs":            "murex-docs",
		"help":                  "murex-docs",
		"continue":              "continue",
		"!":                     "not-func",
		"not":                   "not-func",
		"null":                  "devnull",
		"open":                  "open",
		"os":                    "os",
		"sys.os":                "os",
		"out":                   "out",
		"echo":                  "out",
		"tout":                  "tout",
		"man-get-flags":         "man-get-flags",
		"murex-parser":          "murex-parser",
		"trypipe":               "trypipe",
		"pretty":                "pretty",
		"private":               "private",
		"!private":              "private",
		"time":                  "time",
		"function":              "function",
		"!function":             "function",
		"escape":                "escape",
		"!escape":               "escape",
		"murex-update-exe-list": "murex-update-exe-list",
		"read":                  "read",
		"format":                "format",
		"regexp":                "regexp",
		"!regexp":               "regexp",
		"list.regex":            "regexp",
		"!list.regex":           "regexp",
		"open-image":            "open-image",
		"right":                 "right",
		"list.right":            "right",
		"round":                 "round",
		"num.round":             "round",
		"signal":                "signal",
		"fanout":                "fanout",
		"summary":               "summary",
		"!summary":              "summary",
		"config":                "config",
		"!config":               "config",
		"runtime":               "runtime",
		"builtins":              "runtime",
		"shell.runtime":         "runtime",
		"test":                  "test",
		"!test":                 "test",
		"trypipeerr":            "trypipeerr",
		"tryerr":                "tryerr",
		"match":                 "match",
		"!match":                "match",
		"list.str":              "match",
		"!list.str":             "match",
		"jsplit":                "jsplit",
		"str.split":             "jsplit",
		"switch":                "switch",
		"autocomplete":          "autocomplete",
		"tabulate":              "tabulate",
		"true":                  "true",
		"try":                   "try",

		"select":       "optional/select",
		"table.select": "optional/select",
		"!bz2":         "optional/bz2",
		"base64":       "optional/base64",
		"!base64":      "optional/base64",
		"gz":           "optional/gz",
		"!gz":          "optional/gz",
		"qr":           "optional/qr",
		"sleep":        "optional/sleep",

		"expr-inlined":       "parser/expr-inlined",
		"c-style-fun":        "parser/c-style-fun",
		"@[":                 "parser/range",
		"[":                  "parser/item-index",
		"![":                 "parser/item-index",
		"item-index":         "parser/item-index",
		"index":              "parser/item-index",
		"[[":                 "parser/element",
		"element":            "parser/element",
		"(murex named pipe)": "parser/namedpipe",
		"<>":                 "parser/namedpipe",
		"read-named-pipe":    "parser/namedpipe",
		"<stdin>":            "parser/stdin",
		">>":                 "parser/file-append",
		"fappend":            "parser/file-append",
		">":                  "parser/file-truncate",
		"|>":                 "parser/file-truncate",
		"fwrite":             "parser/file-truncate",
		"double-quote":       "parser/double-quote",
		"scalar":             "parser/scalar",
		"brace-quote":        "parser/brace-quote",
		"create-array":       "parser/create-array",
		"create-object":      "parser/create-object",
		"logical-and":        "parser/logical-and",
		"single-quote":       "parser/single-quote",
		"(":                  "parser/brace-quote-func",
		"multiply-by":        "parser/multiply-by",
		"multiplication":     "parser/multiplication",
		"add-with":           "parser/add-with",
		"addition":           "parser/addition",
		"subtract-by":        "parser/subtract-by",
		"pipe-arrow":         "parser/pipe-arrow",
		"subtraction":        "parser/subtraction",
		"divide-by":          "parser/divide-by",
		"division":           "parser/division",
		"assign-or-merge":    "parser/assign-or-merge",
		"pipe-generic":       "parser/pipe-generic",
		"elvis":              "parser/elvis",
		"null-coalescing":    "parser/null-coalescing",
		"array":              "parser/array",
		"lambda":             "parser/lambda",
		"curly-brace":        "parser/curly-brace",
		"pipe-posix":         "parser/pipe-posix",
		"logical-or":         "parser/logical-or",
		"tilde":              "parser/tilde",

		"commands/key-code":               "commands/key-code",
		"commands/addheading":             "commands/addheading",
		"commands/prefix":                 "commands/prefix",
		"commands/list.prefix":            "commands/prefix",
		"commands/suffix":                 "commands/suffix",
		"commands/list.suffix":            "commands/suffix",
		"commands/alias":                  "commands/alias",
		"commands/!alias":                 "commands/alias",
		"commands/alter":                  "commands/alter",
		"commands/~>":                     "commands/alter",
		"commands/append":                 "commands/append",
		"commands/list.append":            "commands/append",
		"commands/mjoin":                  "commands/mjoin",
		"commands/list.join":              "commands/mjoin",
		"commands/prepend":                "commands/prepend",
		"commands/list.prepend":           "commands/prepend",
		"commands/mtac":                   "commands/mtac",
		"commands/list.reverse":           "commands/mtac",
		"commands/msort":                  "commands/msort",
		"commands/list.sort":              "commands/msort",
		"commands/bg":                     "commands/bg",
		"commands/cpuarch":                "commands/cpuarch",
		"commands/sys.cpu.arch":           "commands/cpuarch",
		"commands/cpucount":               "commands/cpucount",
		"commands/sys.cpu.count":          "commands/cpucount",
		"commands/catch":                  "commands/catch",
		"commands/!catch":                 "commands/catch",
		"commands/cd":                     "commands/cd",
		"commands/list.case":              "commands/list.case",
		"commands/bexists":                "commands/bexists",
		"commands/history":                "commands/history",
		"commands/count":                  "commands/count",
		"commands/len":                    "commands/count",
		"commands/2darray":                "commands/2darray",
		"commands/ja":                     "commands/ja",
		"commands/map":                    "commands/map",
		"commands/pipe":                   "commands/pipe",
		"commands/!pipe":                  "commands/pipe",
		"commands/ta":                     "commands/ta",
		"commands/a":                      "commands/a",
		"commands/mkarray":                "commands/a",
		"commands/tmp":                    "commands/tmp",
		"commands/datetime":               "commands/datetime",
		"commands/str.datetime":           "commands/datetime",
		"commands/debug":                  "commands/debug",
		"commands/export":                 "commands/export",
		"commands/!export":                "commands/export",
		"commands/unset":                  "commands/export",
		"commands/var.env":                "commands/export",
		"commands/!var.env":               "commands/export",
		"commands/args":                   "commands/args",
		"commands/global":                 "commands/global",
		"commands/!global":                "commands/global",
		"commands/openagent":              "commands/openagent",
		"commands/!openagent":             "commands/openagent",
		"commands/method":                 "commands/method",
		"commands/cast":                   "commands/cast",
		"commands/set":                    "commands/set",
		"commands/!set":                   "commands/set",
		"commands/unsafe":                 "commands/unsafe",
		"commands/type":                   "commands/type",
		"commands/fid-list":               "commands/fid-list",
		"commands/jobs":                   "commands/fid-list",
		"commands/getfile":                "commands/getfile",
		"commands/err":                    "commands/err",
		"commands/esccli":                 "commands/esccli",
		"commands/eschtml":                "commands/eschtml",
		"commands/!eschtml":               "commands/eschtml",
		"commands/escurl":                 "commands/escurl",
		"commands/!escurl":                "commands/escurl",
		"commands/exec":                   "commands/exec",
		"commands/command":                "commands/exec",
		"commands/exec.file":              "commands/exec",
		"commands/fexec":                  "commands/fexec",
		"commands/builtin":                "commands/fexec",
		"commands/exec.builtin":           "commands/fexec",
		"commands/exec.function":          "commands/fexec",
		"commands/exec.private":           "commands/fexec",
		"commands/exitnum":                "commands/exitnum",
		"commands/return":                 "commands/return",
		"commands/exit":                   "commands/exit",
		"commands/break":                  "commands/break",
		"commands/expr":                   "commands/expr",
		"commands/false":                  "commands/false",
		"commands/f":                      "commands/f",
		"commands/rx":                     "commands/rx",
		"commands/!rx":                    "commands/rx",
		"commands/formap":                 "commands/formap",
		"commands/foreach":                "commands/foreach",
		"commands/for":                    "commands/for",
		"commands/fg":                     "commands/fg",
		"commands/runmode":                "commands/runmode",
		"commands/rand":                   "commands/rand",
		"commands/get-type":               "commands/get-type",
		"commands/pt":                     "commands/pt",
		"commands/g":                      "commands/g",
		"commands/!g":                     "commands/g",
		"commands/get":                    "commands/get",
		"commands/post":                   "commands/post",
		"commands/if":                     "commands/if",
		"commands/!if":                    "commands/if",
		"commands/source":                 "commands/source",
		"commands/.":                      "commands/source",
		"commands/is-null":                "commands/is-null",
		"commands/fid-killall":            "commands/fid-killall",
		"commands/fid-kill":               "commands/fid-kill",
		"commands/left":                   "commands/left",
		"commands/list.left":              "commands/left",
		"commands/struct-keys":            "commands/struct-keys",
		"commands/which":                  "commands/which",
		"commands/lockfile":               "commands/lockfile",
		"commands/and":                    "commands/and",
		"commands/!and":                   "commands/and",
		"commands/or":                     "commands/or",
		"commands/!or":                    "commands/or",
		"commands/while":                  "commands/while",
		"commands/!while":                 "commands/while",
		"commands/man-summary":            "commands/man-summary",
		"commands/help.man.summary":       "commands/man-summary",
		"commands/event":                  "commands/event",
		"commands/!event":                 "commands/event",
		"commands/murex-package":          "commands/murex-package",
		"commands/version":                "commands/version",
		"commands/murex-docs":             "commands/murex-docs",
		"commands/help":                   "commands/murex-docs",
		"commands/continue":               "commands/continue",
		"commands/!":                      "commands/not-func",
		"commands/not":                    "commands/not-func",
		"commands/null":                   "commands/devnull",
		"commands/open":                   "commands/open",
		"commands/os":                     "commands/os",
		"commands/sys.os":                 "commands/os",
		"commands/out":                    "commands/out",
		"commands/echo":                   "commands/out",
		"commands/tout":                   "commands/tout",
		"commands/man-get-flags":          "commands/man-get-flags",
		"commands/murex-parser":           "commands/murex-parser",
		"commands/trypipe":                "commands/trypipe",
		"commands/pretty":                 "commands/pretty",
		"commands/private":                "commands/private",
		"commands/!private":               "commands/private",
		"commands/time":                   "commands/time",
		"commands/function":               "commands/function",
		"commands/!function":              "commands/function",
		"commands/escape":                 "commands/escape",
		"commands/!escape":                "commands/escape",
		"commands/murex-update-exe-list":  "commands/murex-update-exe-list",
		"commands/read":                   "commands/read",
		"commands/format":                 "commands/format",
		"commands/regexp":                 "commands/regexp",
		"commands/!regexp":                "commands/regexp",
		"commands/list.regex":             "commands/regexp",
		"commands/!list.regex":            "commands/regexp",
		"commands/open-image":             "commands/open-image",
		"commands/right":                  "commands/right",
		"commands/list.right":             "commands/right",
		"commands/round":                  "commands/round",
		"commands/num.round":              "commands/round",
		"commands/signal":                 "commands/signal",
		"commands/fanout":                 "commands/fanout",
		"commands/summary":                "commands/summary",
		"commands/!summary":               "commands/summary",
		"commands/config":                 "commands/config",
		"commands/!config":                "commands/config",
		"commands/runtime":                "commands/runtime",
		"commands/builtins":               "commands/runtime",
		"commands/shell.runtime":          "commands/runtime",
		"commands/test":                   "commands/test",
		"commands/!test":                  "commands/test",
		"commands/trypipeerr":             "commands/trypipeerr",
		"commands/tryerr":                 "commands/tryerr",
		"commands/match":                  "commands/match",
		"commands/!match":                 "commands/match",
		"commands/list.str":               "commands/match",
		"commands/!list.str":              "commands/match",
		"commands/jsplit":                 "commands/jsplit",
		"commands/str.split":              "commands/jsplit",
		"commands/switch":                 "commands/switch",
		"commands/autocomplete":           "commands/autocomplete",
		"commands/tabulate":               "commands/tabulate",
		"commands/true":                   "commands/true",
		"commands/try":                    "commands/try",
		"mkarray/date":                    "mkarray/date",
		"mkarray/character":               "mkarray/character",
		"mkarray/decimal":                 "mkarray/decimal",
		"mkarray/non-decimal":             "mkarray/non-decimal",
		"mkarray/special":                 "mkarray/special",
		"optional/select":                 "optional/select",
		"optional/table.select":           "optional/select",
		"optional/!bz2":                   "optional/bz2",
		"optional/base64":                 "optional/base64",
		"optional/!base64":                "optional/base64",
		"optional/gz":                     "optional/gz",
		"optional/!gz":                    "optional/gz",
		"optional/qr":                     "optional/qr",
		"optional/sleep":                  "optional/sleep",
		"parser/expr-inlined":             "parser/expr-inlined",
		"parser/c-style-fun":              "parser/c-style-fun",
		"parser/@[":                       "parser/range",
		"parser/[":                        "parser/item-index",
		"parser/![":                       "parser/item-index",
		"parser/item-index":               "parser/item-index",
		"parser/index":                    "parser/item-index",
		"parser/[[":                       "parser/element",
		"parser/element":                  "parser/element",
		"parser/(murex named pipe)":       "parser/namedpipe",
		"parser/<>":                       "parser/namedpipe",
		"parser/read-named-pipe":          "parser/namedpipe",
		"parser/<stdin>":                  "parser/stdin",
		"parser/>>":                       "parser/file-append",
		"parser/fappend":                  "parser/file-append",
		"parser/>":                        "parser/file-truncate",
		"parser/|>":                       "parser/file-truncate",
		"parser/fwrite":                   "parser/file-truncate",
		"parser/double-quote":             "parser/double-quote",
		"parser/scalar":                   "parser/scalar",
		"parser/brace-quote":              "parser/brace-quote",
		"parser/create-array":             "parser/create-array",
		"parser/create-object":            "parser/create-object",
		"parser/logical-and":              "parser/logical-and",
		"parser/single-quote":             "parser/single-quote",
		"parser/(":                        "parser/brace-quote-func",
		"parser/multiply-by":              "parser/multiply-by",
		"parser/multiplication":           "parser/multiplication",
		"parser/add-with":                 "parser/add-with",
		"parser/addition":                 "parser/addition",
		"parser/subtract-by":              "parser/subtract-by",
		"parser/pipe-arrow":               "parser/pipe-arrow",
		"parser/subtraction":              "parser/subtraction",
		"parser/divide-by":                "parser/divide-by",
		"parser/division":                 "parser/division",
		"parser/assign-or-merge":          "parser/assign-or-merge",
		"parser/pipe-generic":             "parser/pipe-generic",
		"parser/elvis":                    "parser/elvis",
		"parser/null-coalescing":          "parser/null-coalescing",
		"parser/array":                    "parser/array",
		"parser/lambda":                   "parser/lambda",
		"parser/curly-brace":              "parser/curly-brace",
		"parser/pipe-posix":               "parser/pipe-posix",
		"parser/logical-or":               "parser/logical-or",
		"parser/tilde":                    "parser/tilde",
		"events/oncommandcompletion":      "events/oncommandcompletion",
		"events/onCommandCompletion":      "events/oncommandcompletion",
		"events/onfilesystemchange":       "events/onfilesystemchange",
		"events/onFileSystemChange":       "events/onfilesystemchange",
		"events/onkeypress":               "events/onkeypress",
		"events/onKeyPress":               "events/onkeypress",
		"events/onpreview":                "events/onpreview",
		"events/onPreview":                "events/onpreview",
		"events/onprompt":                 "events/onprompt",
		"events/onPrompt":                 "events/onprompt",
		"events/onsecondselapsed":         "events/onsecondselapsed",
		"events/onSecondsElapsed":         "events/onsecondselapsed",
		"events/onsignalreceived":         "events/onsignalreceived",
		"events/onSignalReceived":         "events/onsignalreceived",
		"types/generic":                   "types/generic",
		"types/*":                         "types/generic",
		"types/bool":                      "types/bool",
		"types/commonlog":                 "types/commonlog",
		"types/csv":                       "types/csv",
		"types/float":                     "types/float",
		"types/hcl":                       "types/hcl",
		"types/int":                       "types/int",
		"types/json":                      "types/json",
		"types/jsonc":                     "types/jsonc",
		"types/jsonl":                     "types/jsonl",
		"types/num":                       "types/num",
		"types/path":                      "types/path",
		"types/paths":                     "types/paths",
		"types/str":                       "types/str",
		"types/string":                    "types/str",
		"types/toml":                      "types/toml",
		"types/xml":                       "types/xml",
		"types/yaml":                      "types/yaml",
		"types/mxjson":                    "types/mxjson",
		"variables/numeric":               "variables/numeric",
		"variables/meta-values":           "variables/meta-values",
		"variables/$.":                    "variables/meta-values",
		"variables/argv":                  "variables/argv",
		"variables/ARGV":                  "variables/argv",
		"variables/ARGS":                  "variables/argv",
		"variables/columns":               "variables/columns",
		"variables/COLUMNS":               "variables/columns",
		"variables/event_return":          "variables/event_return",
		"variables/EVENT_RETURN":          "variables/event_return",
		"variables/home":                  "variables/home",
		"variables/HOME":                  "variables/home",
		"variables/hostname":              "variables/hostname",
		"variables/HOSTNAME":              "variables/hostname",
		"variables/lines":                 "variables/lines",
		"variables/LINES":                 "variables/lines",
		"variables/logname":               "variables/logname",
		"variables/LOGNAME":               "variables/logname",
		"variables/murex_argv":            "variables/murex_argv",
		"variables/MUREX_ARGV":            "variables/murex_argv",
		"variables/MUREX_ARGS":            "variables/murex_argv",
		"variables/murex_config_dir":      "variables/murex_config_dir",
		"variables/MUREX_CONFIG_DIR":      "variables/murex_config_dir",
		"variables/murex_exe":             "variables/murex_exe",
		"variables/MUREX_EXE":             "variables/murex_exe",
		"variables/murex_history":         "variables/murex_history",
		"variables/MUREX_HISTORY":         "variables/murex_history",
		"variables/murex_modules":         "variables/murex_modules",
		"variables/MUREX_MODULES":         "variables/murex_modules",
		"variables/murex_preload":         "variables/murex_preload",
		"variables/MUREX_PRELOAD":         "variables/murex_preload",
		"variables/murex_profile":         "variables/murex_profile",
		"variables/MUREX_PROFILE":         "variables/murex_profile",
		"variables/oldpwd":                "variables/oldpwd",
		"variables/OLDPWD":                "variables/oldpwd",
		"variables/params":                "variables/params",
		"variables/PARAMS":                "variables/params",
		"variables/pwdhist":               "variables/pwdhist",
		"variables/PWDHIST":               "variables/pwdhist",
		"variables/pwd":                   "variables/pwd",
		"variables/PWD":                   "variables/pwd",
		"variables/random":                "variables/random",
		"variables/RANDOM":                "variables/random",
		"variables/self":                  "variables/self",
		"variables/SELF":                  "variables/self",
		"variables/shell":                 "variables/shell",
		"variables/SHELL":                 "variables/shell",
		"variables/tmpdir":                "variables/tmpdir",
		"variables/TMPDIR":                "variables/tmpdir",
		"variables/user":                  "variables/user",
		"variables/USER":                  "variables/user",
		"apis/Marshal":                    "apis/Marshal",
		"apis/ReadArray":                  "apis/ReadArray",
		"apis/ReadArrayWithType":          "apis/ReadArrayWithType",
		"apis/ReadIndex":                  "apis/ReadIndex",
		"apis/ReadMap":                    "apis/ReadMap",
		"apis/ReadNotIndex":               "apis/ReadNotIndex",
		"apis/Unmarshal":                  "apis/Unmarshal",
		"apis/WriteArray":                 "apis/WriteArray",
		"apis/lang.ArrayTemplate":         "apis/lang.ArrayTemplate",
		"apis/lang.ArrayWithTypeTemplate": "apis/lang.ArrayWithTypeTemplate",
		"apis/lang.IndexTemplateObject":   "apis/lang.IndexTemplateObject",
		"apis/lang.IndexTemplateTable":    "apis/lang.IndexTemplateTable",
		"apis/lang.MarshalData":           "apis/lang.MarshalData",
		"apis/lang.UnmarshalData":         "apis/lang.UnmarshalData",
		"user-guide/ansi":                 "user-guide/ansi",
		"user-guide/bang-prefix":          "user-guide/bang-prefix",
		"user-guide/bang":                 "user-guide/bang-prefix",
		"user-guide/code-block":           "user-guide/code-block",
		"user-guide/fileref":              "user-guide/fileref",
		"user-guide/FileRef":              "user-guide/fileref",
		"user-guide/hint-text":            "user-guide/hint-text",
		"user-guide/integrations":         "user-guide/integrations",
		"user-guide/interactive-shell":    "user-guide/interactive-shell",
		"user-guide/repl":                 "user-guide/interactive-shell",
		"user-guide/readline":             "user-guide/interactive-shell",
		"user-guide/job-control":          "user-guide/job-control",
		"user-guide/module":               "user-guide/modules",
		"user-guide/modules":              "user-guide/modules",
		"user-guide/package":              "user-guide/modules",
		"user-guide/packages":             "user-guide/modules",
		"user-guide/namedpipes":           "user-guide/namedpipes",
		"user-guide/operators-and-tokens": "user-guide/operators-and-tokens",
		"user-guide/pipeline":             "user-guide/pipeline",
		"user-guide/profile":              "user-guide/profile",
		"user-guide/.murex_profile":       "user-guide/profile",
		"user-guide/.murex_preload":       "user-guide/profile",
		"user-guide/.murex_history":       "user-guide/profile",
		"user-guide/reserved-vars":        "user-guide/reserved-vars",
		"user-guide/reserved":             "user-guide/reserved-vars",
		"user-guide/reserved-variables":   "user-guide/reserved-vars",
		"user-guide/special-vars":         "user-guide/reserved-vars",
		"user-guide/special-variables":    "user-guide/reserved-vars",
		"user-guide/rosetta-stone":        "user-guide/rosetta-stone",
		"user-guide/schedulers":           "user-guide/schedulers",
		"user-guide/strict-types":         "user-guide/strict-types",
		"user-guide/hotkeys":              "user-guide/terminal-keys",
		"user-guide/scoping":              "user-guide/scoping",
		"user-guide/murex-arrays":         "user-guide/murex-arrays",
		"integrations/chatgpt":            "integrations/chatgpt",
		"integrations/ChatGPT":            "integrations/chatgpt",
		"integrations/cheatsh":            "integrations/cheatsh",
		"integrations/cheat.sh":           "integrations/cheatsh",
		"integrations/kitty":              "integrations/kitty",
		"integrations/make":               "integrations/make",
		"integrations/Makefile":           "integrations/make",
		"integrations/man-pages":          "integrations/man-pages",
		"integrations/spellcheck":         "integrations/spellcheck",
		"integrations/terminology":        "integrations/terminology",
		"integrations/direnv":             "integrations/direnv",
		"integrations/yarn":               "integrations/yarn",
		"integrations/package.json":       "integrations/yarn",
		"integrations/iterm2":             "integrations/iterm2",
		"changelog/v2.0":                  "changelog/v2.0",
		"changelog/v2.1":                  "changelog/v2.1",
		"changelog/v2.10":                 "changelog/v2.10",
		"changelog/v2.11":                 "changelog/v2.11",
		"changelog/v2.2":                  "changelog/v2.2",
		"changelog/v2.3":                  "changelog/v2.3",
		"changelog/v2.4":                  "changelog/v2.4",
		"changelog/v2.5":                  "changelog/v2.5",
		"changelog/v2.6":                  "changelog/v2.6",
		"changelog/v2.7":                  "changelog/v2.7",
		"changelog/v2.8":                  "changelog/v2.8",
		"changelog/v2.9":                  "changelog/v2.9",
		"changelog/v3.0":                  "changelog/v3.0",
		"changelog/v3.1":                  "changelog/v3.1",
		"changelog/v4.0":                  "changelog/v4.0",
		"changelog/v4.1":                  "changelog/v4.1",
		"changelog/v4.2":                  "changelog/v4.2",
		"changelog/v4.3":                  "changelog/v4.3",
		"changelog/v4.4":                  "changelog/v4.4",
		"changelog/v5.0":                  "changelog/v5.0",
		"changelog/v5.1":                  "changelog/v5.1",
		"changelog/v5.2":                  "changelog/v5.2",
		"changelog/v5.3":                  "changelog/v5.3",
		"changelog/v6.0":                  "changelog/v6.0",
		"changelog/v6.1":                  "changelog/v6.1",
		"changelog/v6.2":                  "changelog/v6.2",
		"changelog/v6.3":                  "changelog/v6.3",
		"changelog/v6.4":                  "changelog/v6.4",
		"changelog/v7.0":                  "changelog/v7.0",
		"changelog/v7.1":                  "changelog/v7.1",
		"changelog/v7.2":                  "changelog/v7.2",
	}
}
