## Release notes for kOps 1.26 series

# Significant changes

* The default networking provider for new clusters is now Cilium.

* Control-plane instance groups in new clusters are now created with names starting
with "control-plane-". The names of groups for existing clusters are unchanged.

* The channels CLI that kOps use to manage addons is now bundled with the kOps binary. These commands are useful for addon diagnostics and troubleshooting. For example, to list installed addons, run `kops toolbox addons get addons`.

* Since kOps 1.24, by default during rolling updates, kOps will time out after
spending 15 minutes on an InstanceGroup (instead of hanging indefinitely on
eviction errors), proceeding to the next InstanceGroup after timing out.
As of kOps 1.26, rolling updates will not proceed if a cluster validation
error is encountered while updating an InstanceGroup.

## AWS

* Clusters can be created without DNS or Gossip, by using the `--dns=none` flag.

* Bastions are now fronted by a Network Load Balancer.

* Instance group images can now be dynamically fetched through an AWS SSM Parameter.

* The AWS Load Balancer, when enabled, will run on worker nodes if IRSA is enabled as of Kubernetes version 1.24.

* As of Kubernetes version 1.26 and with IRSA enabled, control plane nodes will now run with a max hop limit of 1 for the metadata service. This will prevent Pods without host networking from accessing the instance metadata service.

* IPv6 is now beta. New IPv6 clusters now default to using private topology.

* CapacityRebalance can be enabled/disabled on ASGs through a new `capacityRebalance` field in InstanceGroup specs.

* New clusters can more easily be configured to use Cilium in ENI mode by setting `--networking=cilium-eni`.

* Node Termination Handler now defaults to Queue-Processor mode. It also now enables Scheduled Event Draining by default.

* Node Termination Handler, when in Queue-Processor mode, no longer drains on rebalance recommendations unless configured to do so.

* When an S3 bucket for Service Account Issuer Discovery (IRSA) is public, kOps no longer sets object-level ACLs on the files placed therein.

## GCP

* Clusters can be created without DNS or Gossip, by using the `--dns=none` flag (experimental).

* The default instance type is now `e2-medium` for control-plane and worker nodes, and `e2-micro` for bastions.

## Hetzner

* Clusters can be created without DNS or Gossip, by using the `--dns=none` flag.

## OpenStack

* When creating new clusters kOps now sets the cluster name flag for the [external OpenStack cloud controller (OCCM)](https://github.com/kubernetes/kops/pull/15139) and the [Cinder CSI plugin](https://github.com/kubernetes/kops/pull/15095).

# Other changes of note

* containerd config is now written to `/etc/containerd/config.toml`.

* Cilium can be configured to add unreachable route for pod IP on deletion.

# Breaking changes

## Other breaking changes

* Support for Kubernetes version 1.20 has been removed.

* Support for CloudFormation has been removed.

* The experimental support for using Vault as a state store has been removed.

* Support for automated reboots with Flatcar has been removed. Use [FLUO](https://github.com/flatcar/flatcar-linux-update-operator/) instead, to gracefully reboot nodes.

* The "external" networking option is not supported for Kubernetes 1.26 or later. For "bring your own"
CNIs, use the "cni" networking option instead.

* If the cluster autoscaler is configured to use the priority expander, kOps will automatically create its ConfigMap. If you still want to manage the ConfigMap manually, set `spec.clusterAutoscaler.createPriorityExpanderConfig: false`. See [the documentation](https://kops.sigs.k8s.io/addons/#priority-expander-configuration) for more details.

# Deprecations

* The "kops get [CLUSTER]" command is deprecated. It is replaced by "kops get all [CLUSTER]".

* Support for Kubernetes version 1.21 is deprecated and will be removed in kOps 1.27.

* Support for Kubernetes version 1.22 is deprecated and will be removed in kOps 1.28.

* Support for Ubuntu 18.04 is deprecated and will be removed in kOps 1.28.

* Support for AWS Classic Load Balancer for API is deprecated and should not be used for newly created clusters.

* All legacy addons are deprecated in favor of managed addons, including the [metrics server addon](https://github.com/kubernetes/kops/tree/master/addons/metrics-server) and the [autoscaler addon](https://github.com/kubernetes/kops/tree/master/addons/cluster-autoscaler).

# Help Wanted

* kOps needs maintainers for Canal, Flannel, and Kube-Router to keep versions up to date and move the integration from experimental to stable.
If no volunteers step up by the time kOps 1.27 is released, support will be phased out.
