/*
Grafana Cloud k6

HTTP API for interacting with Grafana Cloud k6.

API version: 1.7.1
Contact: info@grafana.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package k6

import (
	"encoding/json"
	"fmt"
)

// checks if the UpdateAllowedLoadZonesListApiModel type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &UpdateAllowedLoadZonesListApiModel{}

// UpdateAllowedLoadZonesListApiModel struct for UpdateAllowedLoadZonesListApiModel
type UpdateAllowedLoadZonesListApiModel struct {
	// List of the load zones that the project will be allowed to use.
	Value                []AllowedLoadZoneToUpdateApiModel `json:"value"`
	AdditionalProperties map[string]interface{}
}

type _UpdateAllowedLoadZonesListApiModel UpdateAllowedLoadZonesListApiModel

// NewUpdateAllowedLoadZonesListApiModel instantiates a new UpdateAllowedLoadZonesListApiModel object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewUpdateAllowedLoadZonesListApiModel(value []AllowedLoadZoneToUpdateApiModel) *UpdateAllowedLoadZonesListApiModel {
	this := UpdateAllowedLoadZonesListApiModel{}
	this.Value = value
	return &this
}

// NewUpdateAllowedLoadZonesListApiModelWithDefaults instantiates a new UpdateAllowedLoadZonesListApiModel object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewUpdateAllowedLoadZonesListApiModelWithDefaults() *UpdateAllowedLoadZonesListApiModel {
	this := UpdateAllowedLoadZonesListApiModel{}
	return &this
}

// GetValue returns the Value field value
func (o *UpdateAllowedLoadZonesListApiModel) GetValue() []AllowedLoadZoneToUpdateApiModel {
	if o == nil {
		var ret []AllowedLoadZoneToUpdateApiModel
		return ret
	}

	return o.Value
}

// GetValueOk returns a tuple with the Value field value
// and a boolean to check if the value has been set.
func (o *UpdateAllowedLoadZonesListApiModel) GetValueOk() ([]AllowedLoadZoneToUpdateApiModel, bool) {
	if o == nil {
		return nil, false
	}
	return o.Value, true
}

// SetValue sets field value
func (o *UpdateAllowedLoadZonesListApiModel) SetValue(v []AllowedLoadZoneToUpdateApiModel) {
	o.Value = v
}

func (o UpdateAllowedLoadZonesListApiModel) MarshalJSON() ([]byte, error) {
	toSerialize, err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o UpdateAllowedLoadZonesListApiModel) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["value"] = o.Value

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *UpdateAllowedLoadZonesListApiModel) UnmarshalJSON(data []byte) (err error) {
	// This validates that all required properties are included in the JSON object
	// by unmarshalling the object into a generic map with string keys and checking
	// that every required field exists as a key in the generic map.
	requiredProperties := []string{
		"value",
	}

	allProperties := make(map[string]interface{})

	err = json.Unmarshal(data, &allProperties)

	if err != nil {
		return err
	}

	for _, requiredProperty := range requiredProperties {
		if _, exists := allProperties[requiredProperty]; !exists {
			return fmt.Errorf("no value given for required property %v", requiredProperty)
		}
	}

	varUpdateAllowedLoadZonesListApiModel := _UpdateAllowedLoadZonesListApiModel{}

	err = json.Unmarshal(data, &varUpdateAllowedLoadZonesListApiModel)

	if err != nil {
		return err
	}

	*o = UpdateAllowedLoadZonesListApiModel(varUpdateAllowedLoadZonesListApiModel)

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(data, &additionalProperties); err == nil {
		delete(additionalProperties, "value")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableUpdateAllowedLoadZonesListApiModel struct {
	value *UpdateAllowedLoadZonesListApiModel
	isSet bool
}

func (v NullableUpdateAllowedLoadZonesListApiModel) Get() *UpdateAllowedLoadZonesListApiModel {
	return v.value
}

func (v *NullableUpdateAllowedLoadZonesListApiModel) Set(val *UpdateAllowedLoadZonesListApiModel) {
	v.value = val
	v.isSet = true
}

func (v NullableUpdateAllowedLoadZonesListApiModel) IsSet() bool {
	return v.isSet
}

func (v *NullableUpdateAllowedLoadZonesListApiModel) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableUpdateAllowedLoadZonesListApiModel(val *UpdateAllowedLoadZonesListApiModel) *NullableUpdateAllowedLoadZonesListApiModel {
	return &NullableUpdateAllowedLoadZonesListApiModel{value: val, isSet: true}
}

func (v NullableUpdateAllowedLoadZonesListApiModel) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableUpdateAllowedLoadZonesListApiModel) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
