/*
Grafana Cloud k6

HTTP API for interacting with Grafana Cloud k6.

API version: 1.7.1
Contact: info@grafana.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package k6

import (
	"encoding/json"
	"fmt"
)

// checks if the TestRunDistributionApiModel type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &TestRunDistributionApiModel{}

// TestRunDistributionApiModel struct for TestRunDistributionApiModel
type TestRunDistributionApiModel struct {
	// Distribution of nodes across the load generators for the test run.
	Distribution         map[string]LoadZoneDistributionApiModel `json:"distribution"`
	AdditionalProperties map[string]interface{}
}

type _TestRunDistributionApiModel TestRunDistributionApiModel

// NewTestRunDistributionApiModel instantiates a new TestRunDistributionApiModel object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewTestRunDistributionApiModel(distribution map[string]LoadZoneDistributionApiModel) *TestRunDistributionApiModel {
	this := TestRunDistributionApiModel{}
	this.Distribution = distribution
	return &this
}

// NewTestRunDistributionApiModelWithDefaults instantiates a new TestRunDistributionApiModel object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewTestRunDistributionApiModelWithDefaults() *TestRunDistributionApiModel {
	this := TestRunDistributionApiModel{}
	return &this
}

// GetDistribution returns the Distribution field value
func (o *TestRunDistributionApiModel) GetDistribution() map[string]LoadZoneDistributionApiModel {
	if o == nil {
		var ret map[string]LoadZoneDistributionApiModel
		return ret
	}

	return o.Distribution
}

// GetDistributionOk returns a tuple with the Distribution field value
// and a boolean to check if the value has been set.
func (o *TestRunDistributionApiModel) GetDistributionOk() (map[string]LoadZoneDistributionApiModel, bool) {
	if o == nil {
		return map[string]LoadZoneDistributionApiModel{}, false
	}
	return o.Distribution, true
}

// SetDistribution sets field value
func (o *TestRunDistributionApiModel) SetDistribution(v map[string]LoadZoneDistributionApiModel) {
	o.Distribution = v
}

func (o TestRunDistributionApiModel) MarshalJSON() ([]byte, error) {
	toSerialize, err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o TestRunDistributionApiModel) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["distribution"] = o.Distribution

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *TestRunDistributionApiModel) UnmarshalJSON(data []byte) (err error) {
	// This validates that all required properties are included in the JSON object
	// by unmarshalling the object into a generic map with string keys and checking
	// that every required field exists as a key in the generic map.
	requiredProperties := []string{
		"distribution",
	}

	allProperties := make(map[string]interface{})

	err = json.Unmarshal(data, &allProperties)

	if err != nil {
		return err
	}

	for _, requiredProperty := range requiredProperties {
		if _, exists := allProperties[requiredProperty]; !exists {
			return fmt.Errorf("no value given for required property %v", requiredProperty)
		}
	}

	varTestRunDistributionApiModel := _TestRunDistributionApiModel{}

	err = json.Unmarshal(data, &varTestRunDistributionApiModel)

	if err != nil {
		return err
	}

	*o = TestRunDistributionApiModel(varTestRunDistributionApiModel)

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(data, &additionalProperties); err == nil {
		delete(additionalProperties, "distribution")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableTestRunDistributionApiModel struct {
	value *TestRunDistributionApiModel
	isSet bool
}

func (v NullableTestRunDistributionApiModel) Get() *TestRunDistributionApiModel {
	return v.value
}

func (v *NullableTestRunDistributionApiModel) Set(val *TestRunDistributionApiModel) {
	v.value = val
	v.isSet = true
}

func (v NullableTestRunDistributionApiModel) IsSet() bool {
	return v.isSet
}

func (v *NullableTestRunDistributionApiModel) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableTestRunDistributionApiModel(val *TestRunDistributionApiModel) *NullableTestRunDistributionApiModel {
	return &NullableTestRunDistributionApiModel{value: val, isSet: true}
}

func (v NullableTestRunDistributionApiModel) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableTestRunDistributionApiModel) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
