/*
Grafana Cloud k6

HTTP API for interacting with Grafana Cloud k6.

API version: 1.7.1
Contact: info@grafana.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package k6

import (
	"encoding/json"
)

// checks if the PatchLoadTestApiModel type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &PatchLoadTestApiModel{}

// PatchLoadTestApiModel struct for PatchLoadTestApiModel
type PatchLoadTestApiModel struct {
	// Unique name of the test within the project.
	Name *string `json:"name,omitempty"`
	// ID of a baseline test run used for results comparison.
	BaselineTestRunId    NullableInt32 `json:"baseline_test_run_id,omitempty"`
	AdditionalProperties map[string]interface{}
}

type _PatchLoadTestApiModel PatchLoadTestApiModel

// NewPatchLoadTestApiModel instantiates a new PatchLoadTestApiModel object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewPatchLoadTestApiModel() *PatchLoadTestApiModel {
	this := PatchLoadTestApiModel{}
	return &this
}

// NewPatchLoadTestApiModelWithDefaults instantiates a new PatchLoadTestApiModel object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewPatchLoadTestApiModelWithDefaults() *PatchLoadTestApiModel {
	this := PatchLoadTestApiModel{}
	return &this
}

// GetName returns the Name field value if set, zero value otherwise.
func (o *PatchLoadTestApiModel) GetName() string {
	if o == nil || IsNil(o.Name) {
		var ret string
		return ret
	}
	return *o.Name
}

// GetNameOk returns a tuple with the Name field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PatchLoadTestApiModel) GetNameOk() (*string, bool) {
	if o == nil || IsNil(o.Name) {
		return nil, false
	}
	return o.Name, true
}

// HasName returns a boolean if a field has been set.
func (o *PatchLoadTestApiModel) HasName() bool {
	if o != nil && !IsNil(o.Name) {
		return true
	}

	return false
}

// SetName gets a reference to the given string and assigns it to the Name field.
func (o *PatchLoadTestApiModel) SetName(v string) {
	o.Name = &v
}

// GetBaselineTestRunId returns the BaselineTestRunId field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *PatchLoadTestApiModel) GetBaselineTestRunId() int32 {
	if o == nil || IsNil(o.BaselineTestRunId.Get()) {
		var ret int32
		return ret
	}
	return *o.BaselineTestRunId.Get()
}

// GetBaselineTestRunIdOk returns a tuple with the BaselineTestRunId field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *PatchLoadTestApiModel) GetBaselineTestRunIdOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}
	return o.BaselineTestRunId.Get(), o.BaselineTestRunId.IsSet()
}

// HasBaselineTestRunId returns a boolean if a field has been set.
func (o *PatchLoadTestApiModel) HasBaselineTestRunId() bool {
	if o != nil && o.BaselineTestRunId.IsSet() {
		return true
	}

	return false
}

// SetBaselineTestRunId gets a reference to the given NullableInt32 and assigns it to the BaselineTestRunId field.
func (o *PatchLoadTestApiModel) SetBaselineTestRunId(v int32) {
	o.BaselineTestRunId.Set(&v)
}

// SetBaselineTestRunIdNil sets the value for BaselineTestRunId to be an explicit nil
func (o *PatchLoadTestApiModel) SetBaselineTestRunIdNil() {
	o.BaselineTestRunId.Set(nil)
}

// UnsetBaselineTestRunId ensures that no value is present for BaselineTestRunId, not even an explicit nil
func (o *PatchLoadTestApiModel) UnsetBaselineTestRunId() {
	o.BaselineTestRunId.Unset()
}

func (o PatchLoadTestApiModel) MarshalJSON() ([]byte, error) {
	toSerialize, err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o PatchLoadTestApiModel) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if !IsNil(o.Name) {
		toSerialize["name"] = o.Name
	}
	if o.BaselineTestRunId.IsSet() {
		toSerialize["baseline_test_run_id"] = o.BaselineTestRunId.Get()
	}

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *PatchLoadTestApiModel) UnmarshalJSON(data []byte) (err error) {
	varPatchLoadTestApiModel := _PatchLoadTestApiModel{}

	err = json.Unmarshal(data, &varPatchLoadTestApiModel)

	if err != nil {
		return err
	}

	*o = PatchLoadTestApiModel(varPatchLoadTestApiModel)

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(data, &additionalProperties); err == nil {
		delete(additionalProperties, "name")
		delete(additionalProperties, "baseline_test_run_id")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullablePatchLoadTestApiModel struct {
	value *PatchLoadTestApiModel
	isSet bool
}

func (v NullablePatchLoadTestApiModel) Get() *PatchLoadTestApiModel {
	return v.value
}

func (v *NullablePatchLoadTestApiModel) Set(val *PatchLoadTestApiModel) {
	v.value = val
	v.isSet = true
}

func (v NullablePatchLoadTestApiModel) IsSet() bool {
	return v.isSet
}

func (v *NullablePatchLoadTestApiModel) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullablePatchLoadTestApiModel(val *PatchLoadTestApiModel) *NullablePatchLoadTestApiModel {
	return &NullablePatchLoadTestApiModel{value: val, isSet: true}
}

func (v NullablePatchLoadTestApiModel) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullablePatchLoadTestApiModel) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
