/*
Grafana Cloud k6

HTTP API for interacting with Grafana Cloud k6.

API version: 1.7.1
Contact: info@grafana.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package k6

import (
	"encoding/json"
	"fmt"
)

// checks if the LoadZonesListApiModel type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &LoadZonesListApiModel{}

// LoadZonesListApiModel struct for LoadZonesListApiModel
type LoadZonesListApiModel struct {
	// List of the resulting values.
	Value                []LoadZoneApiModel `json:"value"`
	AdditionalProperties map[string]interface{}
}

type _LoadZonesListApiModel LoadZonesListApiModel

// NewLoadZonesListApiModel instantiates a new LoadZonesListApiModel object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewLoadZonesListApiModel(value []LoadZoneApiModel) *LoadZonesListApiModel {
	this := LoadZonesListApiModel{}
	this.Value = value
	return &this
}

// NewLoadZonesListApiModelWithDefaults instantiates a new LoadZonesListApiModel object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewLoadZonesListApiModelWithDefaults() *LoadZonesListApiModel {
	this := LoadZonesListApiModel{}
	return &this
}

// GetValue returns the Value field value
func (o *LoadZonesListApiModel) GetValue() []LoadZoneApiModel {
	if o == nil {
		var ret []LoadZoneApiModel
		return ret
	}

	return o.Value
}

// GetValueOk returns a tuple with the Value field value
// and a boolean to check if the value has been set.
func (o *LoadZonesListApiModel) GetValueOk() ([]LoadZoneApiModel, bool) {
	if o == nil {
		return nil, false
	}
	return o.Value, true
}

// SetValue sets field value
func (o *LoadZonesListApiModel) SetValue(v []LoadZoneApiModel) {
	o.Value = v
}

func (o LoadZonesListApiModel) MarshalJSON() ([]byte, error) {
	toSerialize, err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o LoadZonesListApiModel) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["value"] = o.Value

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *LoadZonesListApiModel) UnmarshalJSON(data []byte) (err error) {
	// This validates that all required properties are included in the JSON object
	// by unmarshalling the object into a generic map with string keys and checking
	// that every required field exists as a key in the generic map.
	requiredProperties := []string{
		"value",
	}

	allProperties := make(map[string]interface{})

	err = json.Unmarshal(data, &allProperties)

	if err != nil {
		return err
	}

	for _, requiredProperty := range requiredProperties {
		if _, exists := allProperties[requiredProperty]; !exists {
			return fmt.Errorf("no value given for required property %v", requiredProperty)
		}
	}

	varLoadZonesListApiModel := _LoadZonesListApiModel{}

	err = json.Unmarshal(data, &varLoadZonesListApiModel)

	if err != nil {
		return err
	}

	*o = LoadZonesListApiModel(varLoadZonesListApiModel)

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(data, &additionalProperties); err == nil {
		delete(additionalProperties, "value")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableLoadZonesListApiModel struct {
	value *LoadZonesListApiModel
	isSet bool
}

func (v NullableLoadZonesListApiModel) Get() *LoadZonesListApiModel {
	return v.value
}

func (v *NullableLoadZonesListApiModel) Set(val *LoadZonesListApiModel) {
	v.value = val
	v.isSet = true
}

func (v NullableLoadZonesListApiModel) IsSet() bool {
	return v.isSet
}

func (v *NullableLoadZonesListApiModel) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableLoadZonesListApiModel(val *LoadZonesListApiModel) *NullableLoadZonesListApiModel {
	return &NullableLoadZonesListApiModel{value: val, isSet: true}
}

func (v NullableLoadZonesListApiModel) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableLoadZonesListApiModel) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
