/*
Grafana Cloud k6

HTTP API for interacting with Grafana Cloud k6.

API version: 1.7.1
Contact: info@grafana.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package k6

import (
	"encoding/json"
	"fmt"
)

// checks if the AllowedProjectsListApiModel type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &AllowedProjectsListApiModel{}

// AllowedProjectsListApiModel struct for AllowedProjectsListApiModel
type AllowedProjectsListApiModel struct {
	// List of the resulting values.
	Value                []AllowedProjectApiModel `json:"value"`
	AdditionalProperties map[string]interface{}
}

type _AllowedProjectsListApiModel AllowedProjectsListApiModel

// NewAllowedProjectsListApiModel instantiates a new AllowedProjectsListApiModel object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewAllowedProjectsListApiModel(value []AllowedProjectApiModel) *AllowedProjectsListApiModel {
	this := AllowedProjectsListApiModel{}
	this.Value = value
	return &this
}

// NewAllowedProjectsListApiModelWithDefaults instantiates a new AllowedProjectsListApiModel object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewAllowedProjectsListApiModelWithDefaults() *AllowedProjectsListApiModel {
	this := AllowedProjectsListApiModel{}
	return &this
}

// GetValue returns the Value field value
func (o *AllowedProjectsListApiModel) GetValue() []AllowedProjectApiModel {
	if o == nil {
		var ret []AllowedProjectApiModel
		return ret
	}

	return o.Value
}

// GetValueOk returns a tuple with the Value field value
// and a boolean to check if the value has been set.
func (o *AllowedProjectsListApiModel) GetValueOk() ([]AllowedProjectApiModel, bool) {
	if o == nil {
		return nil, false
	}
	return o.Value, true
}

// SetValue sets field value
func (o *AllowedProjectsListApiModel) SetValue(v []AllowedProjectApiModel) {
	o.Value = v
}

func (o AllowedProjectsListApiModel) MarshalJSON() ([]byte, error) {
	toSerialize, err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o AllowedProjectsListApiModel) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["value"] = o.Value

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *AllowedProjectsListApiModel) UnmarshalJSON(data []byte) (err error) {
	// This validates that all required properties are included in the JSON object
	// by unmarshalling the object into a generic map with string keys and checking
	// that every required field exists as a key in the generic map.
	requiredProperties := []string{
		"value",
	}

	allProperties := make(map[string]interface{})

	err = json.Unmarshal(data, &allProperties)

	if err != nil {
		return err
	}

	for _, requiredProperty := range requiredProperties {
		if _, exists := allProperties[requiredProperty]; !exists {
			return fmt.Errorf("no value given for required property %v", requiredProperty)
		}
	}

	varAllowedProjectsListApiModel := _AllowedProjectsListApiModel{}

	err = json.Unmarshal(data, &varAllowedProjectsListApiModel)

	if err != nil {
		return err
	}

	*o = AllowedProjectsListApiModel(varAllowedProjectsListApiModel)

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(data, &additionalProperties); err == nil {
		delete(additionalProperties, "value")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableAllowedProjectsListApiModel struct {
	value *AllowedProjectsListApiModel
	isSet bool
}

func (v NullableAllowedProjectsListApiModel) Get() *AllowedProjectsListApiModel {
	return v.value
}

func (v *NullableAllowedProjectsListApiModel) Set(val *AllowedProjectsListApiModel) {
	v.value = val
	v.isSet = true
}

func (v NullableAllowedProjectsListApiModel) IsSet() bool {
	return v.isSet
}

func (v *NullableAllowedProjectsListApiModel) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableAllowedProjectsListApiModel(val *AllowedProjectsListApiModel) *NullableAllowedProjectsListApiModel {
	return &NullableAllowedProjectsListApiModel{value: val, isSet: true}
}

func (v NullableAllowedProjectsListApiModel) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableAllowedProjectsListApiModel) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
