/*
Grafana Cloud k6

HTTP API for interacting with Grafana Cloud k6.

API version: 1.7.1
Contact: info@grafana.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package k6

import (
	"encoding/json"
	"fmt"
)

// checks if the AllowedLoadZonesListApiModel type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &AllowedLoadZonesListApiModel{}

// AllowedLoadZonesListApiModel struct for AllowedLoadZonesListApiModel
type AllowedLoadZonesListApiModel struct {
	// List of the resulting values.
	Value                []AllowedLoadZoneApiModel `json:"value"`
	AdditionalProperties map[string]interface{}
}

type _AllowedLoadZonesListApiModel AllowedLoadZonesListApiModel

// NewAllowedLoadZonesListApiModel instantiates a new AllowedLoadZonesListApiModel object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewAllowedLoadZonesListApiModel(value []AllowedLoadZoneApiModel) *AllowedLoadZonesListApiModel {
	this := AllowedLoadZonesListApiModel{}
	this.Value = value
	return &this
}

// NewAllowedLoadZonesListApiModelWithDefaults instantiates a new AllowedLoadZonesListApiModel object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewAllowedLoadZonesListApiModelWithDefaults() *AllowedLoadZonesListApiModel {
	this := AllowedLoadZonesListApiModel{}
	return &this
}

// GetValue returns the Value field value
func (o *AllowedLoadZonesListApiModel) GetValue() []AllowedLoadZoneApiModel {
	if o == nil {
		var ret []AllowedLoadZoneApiModel
		return ret
	}

	return o.Value
}

// GetValueOk returns a tuple with the Value field value
// and a boolean to check if the value has been set.
func (o *AllowedLoadZonesListApiModel) GetValueOk() ([]AllowedLoadZoneApiModel, bool) {
	if o == nil {
		return nil, false
	}
	return o.Value, true
}

// SetValue sets field value
func (o *AllowedLoadZonesListApiModel) SetValue(v []AllowedLoadZoneApiModel) {
	o.Value = v
}

func (o AllowedLoadZonesListApiModel) MarshalJSON() ([]byte, error) {
	toSerialize, err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o AllowedLoadZonesListApiModel) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["value"] = o.Value

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *AllowedLoadZonesListApiModel) UnmarshalJSON(data []byte) (err error) {
	// This validates that all required properties are included in the JSON object
	// by unmarshalling the object into a generic map with string keys and checking
	// that every required field exists as a key in the generic map.
	requiredProperties := []string{
		"value",
	}

	allProperties := make(map[string]interface{})

	err = json.Unmarshal(data, &allProperties)

	if err != nil {
		return err
	}

	for _, requiredProperty := range requiredProperties {
		if _, exists := allProperties[requiredProperty]; !exists {
			return fmt.Errorf("no value given for required property %v", requiredProperty)
		}
	}

	varAllowedLoadZonesListApiModel := _AllowedLoadZonesListApiModel{}

	err = json.Unmarshal(data, &varAllowedLoadZonesListApiModel)

	if err != nil {
		return err
	}

	*o = AllowedLoadZonesListApiModel(varAllowedLoadZonesListApiModel)

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(data, &additionalProperties); err == nil {
		delete(additionalProperties, "value")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableAllowedLoadZonesListApiModel struct {
	value *AllowedLoadZonesListApiModel
	isSet bool
}

func (v NullableAllowedLoadZonesListApiModel) Get() *AllowedLoadZonesListApiModel {
	return v.value
}

func (v *NullableAllowedLoadZonesListApiModel) Set(val *AllowedLoadZonesListApiModel) {
	v.value = val
	v.isSet = true
}

func (v NullableAllowedLoadZonesListApiModel) IsSet() bool {
	return v.isSet
}

func (v *NullableAllowedLoadZonesListApiModel) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableAllowedLoadZonesListApiModel(val *AllowedLoadZonesListApiModel) *NullableAllowedLoadZonesListApiModel {
	return &NullableAllowedLoadZonesListApiModel{value: val, isSet: true}
}

func (v NullableAllowedLoadZonesListApiModel) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableAllowedLoadZonesListApiModel) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
