package cmd

import (
	"github.com/carapace-sh/carapace"
	"github.com/spf13/cobra"
)

var rootCmd = &cobra.Command{
	Use:   "git-archive-file",
	Short: "Export the current HEAD of the git repository to an archive",
	Long:  "https://github.com/tj/git-extras/blob/master/Commands.md#git-archive-file",
	Run:   func(cmd *cobra.Command, args []string) {},
}

func Execute() error {
	return rootCmd.Execute()
}
func init() {
	carapace.Gen(rootCmd).Standalone()

	rootCmd.Flags().Bool("help", false, "Display help message")
}
