/* ###
 * IP: GHIDRA
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package ghidra.app.plugin.core.debug.gui;

import docking.DefaultActionContext;
import ghidra.trace.model.Trace;

public class DebuggerSnapActionContext extends DefaultActionContext {
	private final Trace trace;
	private final long snap;

	public DebuggerSnapActionContext(Trace trace, long snap) {
		this.trace = trace;
		this.snap = snap;
	}

	public Trace getTrace() {
		return trace;
	}

	public long getSnap() {
		return snap;
	}
}
