/*
 * Decompiled with CFR 0.152.
 */
package com.singlestore.jdbc.codec;

import com.singlestore.jdbc.Configuration;
import com.singlestore.jdbc.codec.Codec;
import com.singlestore.jdbc.codec.RowDecoder;
import com.singlestore.jdbc.codec.list.BooleanCodec;
import com.singlestore.jdbc.codec.list.ByteCodec;
import com.singlestore.jdbc.codec.list.DoubleCodec;
import com.singlestore.jdbc.codec.list.FloatCodec;
import com.singlestore.jdbc.codec.list.IntCodec;
import com.singlestore.jdbc.codec.list.LongCodec;
import com.singlestore.jdbc.codec.list.ShortCodec;
import com.singlestore.jdbc.message.server.ColumnDefinitionPacket;
import java.sql.SQLException;
import java.util.Calendar;

public class TextRowDecoder
extends RowDecoder {
    public TextRowDecoder(int columnCount, ColumnDefinitionPacket[] columns, Configuration conf) {
        super(columnCount, columns, conf);
    }

    @Override
    public <T> T decode(Codec<T> codec, Calendar cal) throws SQLException {
        return codec.decodeText(this.readBuf, this.length, this.columns[this.index], cal);
    }

    @Override
    public byte decodeByte() throws SQLException {
        return ByteCodec.INSTANCE.decodeTextByte(this.readBuf, this.length, this.columns[this.index]);
    }

    @Override
    public boolean decodeBoolean() throws SQLException {
        return BooleanCodec.INSTANCE.decodeTextBoolean(this.readBuf, this.length, this.columns[this.index]);
    }

    @Override
    public short decodeShort() throws SQLException {
        return ShortCodec.INSTANCE.decodeTextShort(this.readBuf, this.length, this.columns[this.index]);
    }

    @Override
    public int decodeInt() throws SQLException {
        return IntCodec.INSTANCE.decodeTextInt(this.readBuf, this.length, this.columns[this.index]);
    }

    @Override
    public long decodeLong() throws SQLException {
        return LongCodec.INSTANCE.decodeTextLong(this.readBuf, this.length, this.columns[this.index]);
    }

    @Override
    public float decodeFloat() throws SQLException {
        return FloatCodec.INSTANCE.decodeTextFloat(this.readBuf, this.length, this.columns[this.index]);
    }

    @Override
    public double decodeDouble() throws SQLException {
        return DoubleCodec.INSTANCE.decodeTextDouble(this.readBuf, this.length, this.columns[this.index]);
    }

    @Override
    public boolean wasNull() {
        return this.length == -1;
    }

    @Override
    public void setPosition(int newIndex) {
        short type;
        if (this.index >= newIndex) {
            this.index = 0;
            this.readBuf.pos(0);
        } else {
            ++this.index;
        }
        while (this.index < newIndex) {
            type = this.readBuf.readUnsignedByte();
            switch (type) {
                case 252: {
                    this.readBuf.skip(this.readBuf.readUnsignedShort());
                    break;
                }
                case 253: {
                    this.readBuf.skip(this.readBuf.readUnsignedMedium());
                    break;
                }
                case 254: {
                    this.readBuf.skip((int)(4L + this.readBuf.readUnsignedInt()));
                    break;
                }
                case 251: {
                    break;
                }
                default: {
                    this.readBuf.skip(type);
                }
            }
            ++this.index;
        }
        type = this.readBuf.readUnsignedByte();
        switch (type) {
            case 251: {
                this.length = -1;
                break;
            }
            case 252: {
                this.length = this.readBuf.readUnsignedShort();
                break;
            }
            case 253: {
                this.length = this.readBuf.readUnsignedMedium();
                break;
            }
            case 254: {
                this.length = (int)this.readBuf.readUnsignedInt();
                this.readBuf.skip(4);
                break;
            }
            default: {
                this.length = type;
            }
        }
    }
}

