/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.sqlengine.dsiext.dataengine;

public class Identifier {
    private String m_catalog;
    private String m_schema;
    private String m_name;

    public Identifier() {
    }

    public Identifier(String string, String string2, String string3) {
        this.m_catalog = string;
        this.m_schema = string2;
        this.m_name = string3;
    }

    public Identifier(Identifier identifier) {
        this.m_catalog = identifier.getCatalog();
        this.m_schema = identifier.getSchema();
        this.m_name = identifier.getName();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof Identifier)) {
            return false;
        }
        Identifier identifier = (Identifier)object;
        return Identifier.strEquals(this.getCatalog(), identifier.getCatalog()) && Identifier.strEquals(this.getSchema(), identifier.getSchema()) && Identifier.strEquals(this.getName(), identifier.getName());
    }

    public String getCatalog() {
        return this.m_catalog;
    }

    public String getName() {
        return this.m_name;
    }

    public String getSchema() {
        return this.m_schema;
    }

    public int hashCode() {
        return Identifier.getHash(this.getCatalog()) + 37 * (Identifier.getHash(this.getSchema()) + 37 * Identifier.getHash(this.getName()));
    }

    public void setCatalog(String string) {
        this.m_catalog = string;
    }

    public void setName(String string) {
        this.m_name = string;
    }

    public void setSchema(String string) {
        this.m_schema = string;
    }

    public String toString() {
        String string;
        String string2 = string = null == this.m_name ? "<null>" : Identifier.sqlQuoted(this.m_name);
        if (null != this.m_schema) {
            string = Identifier.sqlQuoted(this.m_schema) + "." + string;
        }
        if (null != this.m_catalog) {
            string = Identifier.sqlQuoted(this.m_catalog) + "." + string;
        }
        return string;
    }

    public void assign(Identifier identifier) {
        this.m_catalog = identifier.m_catalog;
        this.m_schema = identifier.m_schema;
        this.m_name = identifier.m_name;
    }

    private static int getHash(String string) {
        return null == string ? 0 : string.hashCode();
    }

    private static String sqlQuoted(String string) {
        return "\"" + string.replace("\"", "\"\"") + "\"";
    }

    private static boolean strEquals(String string, String string2) {
        return string == string2 || string != null && string.equals(string2);
    }
}

