/*
 * Decompiled with CFR 0.152.
 */
package proguard.util;

import proguard.util.Processable;

public class SimpleProcessable
implements Processable {
    private static final boolean CHECK_OVERRIDE = System.getProperty("proguard.processinginfo.check_overriding") != null;
    public int processingFlags;
    public Object processingInfo;

    public SimpleProcessable() {
    }

    public SimpleProcessable(int processingFlags, Object processingInfo) {
        this.processingFlags = processingFlags;
        this.processingInfo = processingInfo;
    }

    @Override
    public int getProcessingFlags() {
        return this.processingFlags;
    }

    @Override
    public void setProcessingFlags(int processingFlags) {
        this.processingFlags = processingFlags;
    }

    public void addProcessingFlags(int ... flags) {
        for (int flag : flags) {
            this.processingFlags |= flag;
        }
    }

    public void removeProcessingFlags(int ... flags) {
        for (int flag : flags) {
            this.processingFlags &= ~flag;
        }
    }

    public boolean hasProcessingFlags(int ... flags) {
        int allFlags = 0;
        for (int flag : flags) {
            allFlags |= flag;
        }
        return (~this.processingFlags & allFlags) == 0;
    }

    @Override
    public Object getProcessingInfo() {
        return this.processingInfo;
    }

    @Override
    public void setProcessingInfo(Object processingInfo) {
        if (CHECK_OVERRIDE && this.processingInfo != null && processingInfo != null && !this.processingInfo.getClass().getName().equals(processingInfo.getClass().getName())) {
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            StackTraceElement stackTraceElement = stackTrace.length > 2 ? stackTrace[2] : null;
            System.out.printf("Overriding processingInfo. Old:%s, New:%s. Stacktrace entry before last is:\n\t%s%n", this.processingInfo.getClass().getName(), processingInfo.getClass().getName(), stackTraceElement);
        }
        this.processingInfo = processingInfo;
    }
}

