/*
 * Decompiled with CFR 0.152.
 */
package proguard.util;

import java.util.List;
import proguard.util.AndMatcher;
import proguard.util.ConstantMatcher;
import proguard.util.ListUtil;
import proguard.util.NameParser;
import proguard.util.NotMatcher;
import proguard.util.OrMatcher;
import proguard.util.StringMatcher;
import proguard.util.StringParser;

public class ListParser
implements StringParser {
    private final StringParser stringParser;

    public ListParser(StringParser stringParser) {
        this.stringParser = stringParser;
    }

    @Override
    public StringMatcher parse(String regularExpression) {
        return this.parse(ListUtil.commaSeparatedList(regularExpression));
    }

    public StringMatcher parse(List regularExpressions) {
        StringMatcher[] stringMatchers;
        StringMatcher listMatcher = null;
        for (int index = regularExpressions.size() - 1; index >= 0; index -= stringMatchers.length) {
            String regularExpression = (String)regularExpressions.get(index);
            boolean isNegated = this.isNegated(regularExpression);
            int lastNegatedIndex = this.lastNegatedIndex(regularExpressions, index, isNegated);
            stringMatchers = this.parseEntries(regularExpressions, lastNegatedIndex, index);
            StringMatcher stringMatcher = new OrMatcher(stringMatchers);
            if (isNegated) {
                stringMatcher = new NotMatcher(stringMatcher);
            }
            listMatcher = listMatcher == null ? stringMatcher : (isNegated ? new AndMatcher(stringMatcher, listMatcher) : new OrMatcher(stringMatcher, listMatcher));
        }
        return listMatcher != null ? listMatcher : new ConstantMatcher(true);
    }

    private int lastNegatedIndex(List regularExpressions, int lastIndex, boolean isNegated) {
        for (int index = lastIndex; index > 0; --index) {
            String regularExpression = (String)regularExpressions.get(index - 1);
            if (this.isNegated(regularExpression) == isNegated) continue;
            return index;
        }
        return 0;
    }

    private StringMatcher[] parseEntries(List regularExpressions, int firstIndex, int lastIndex) {
        StringMatcher[] stringMatchers = new StringMatcher[lastIndex - firstIndex + 1];
        for (int index = firstIndex; index <= lastIndex; ++index) {
            String regularExpression = (String)regularExpressions.get(index);
            stringMatchers[index - firstIndex] = this.parseEntry(regularExpression);
        }
        return stringMatchers;
    }

    private StringMatcher parseEntry(String regularExpression) {
        if (this.isNegated(regularExpression)) {
            regularExpression = regularExpression.substring(1);
        }
        return this.stringParser.parse(regularExpression);
    }

    private boolean isNegated(String regularExpression) {
        return regularExpression.length() > 0 && regularExpression.charAt(0) == '!';
    }

    public static void main(String[] args) {
        try {
            System.out.println("Regular expression [" + args[0] + "]");
            ListParser parser = new ListParser(new NameParser());
            StringMatcher matcher = parser.parse(args[0]);
            for (int index = 1; index < args.length; ++index) {
                String string = args[index];
                System.out.print("String             [" + string + "]");
                System.out.println(" -> match = " + matcher.matches(args[index]));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

