/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.sun.tools.javac.parser.Tokens;

public final class ErrorProneComment {
    private final int pos;
    private final int endPos;
    private final int offset;
    private final Supplier<String> text;
    private final ErrorProneCommentStyle style;

    ErrorProneComment(int pos, int endPos, int offset, Supplier<String> text, ErrorProneCommentStyle style) {
        this.pos = pos;
        this.endPos = endPos;
        this.offset = offset;
        this.text = Suppliers.memoize(text);
        this.style = style;
    }

    public ErrorProneComment withOffset(int offset) {
        return new ErrorProneComment(this.pos, this.endPos, offset, this.text, this.style);
    }

    public int getPos() {
        return this.pos + this.offset;
    }

    public int getEndPos() {
        return this.endPos + this.offset;
    }

    public int getSourcePos(int index) {
        Preconditions.checkArgument((0 <= index && index < this.endPos - this.pos ? 1 : 0) != 0, (String)"Expected %s in the range [0, %s)", (int)index, (int)(this.endPos - this.pos));
        return this.pos + index + this.offset;
    }

    public ErrorProneCommentStyle getStyle() {
        return this.style;
    }

    public String getText() {
        return (String)this.text.get();
    }

    public boolean isDeprecated() {
        return false;
    }

    public String toString() {
        return String.format("Comment: '%s'", this.getText());
    }

    public static enum ErrorProneCommentStyle {
        LINE,
        BLOCK,
        JAVADOC_LINE,
        JAVADOC_BLOCK;


        static ErrorProneCommentStyle from(Tokens.Comment.CommentStyle style) {
            switch (style.name()) {
                case "LINE": {
                    return LINE;
                }
                case "BLOCK": {
                    return BLOCK;
                }
                case "JAVADOC_LINE": {
                    return JAVADOC_LINE;
                }
                case "JAVADOC": 
                case "JAVADOC_BLOCK": {
                    return JAVADOC_BLOCK;
                }
            }
            throw new AssertionError((Object)style);
        }
    }
}

