/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Types;
import javax.inject.Inject;
import javax.lang.model.element.Modifier;

@BugPattern(summary="method overrides method in supertype; expected @Override", severity=BugPattern.SeverityLevel.WARNING, tags={"Style"})
public class MissingOverride
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    private final boolean ignoreInterfaceOverrides;

    @Inject
    MissingOverride(ErrorProneFlags flags) {
        this.ignoreInterfaceOverrides = flags.getBoolean("MissingOverride:IgnoreInterfaceOverrides").orElse(false);
    }

    public Description matchMethod(MethodTree tree, VisitorState state) {
        Symbol.MethodSymbol sym = ASTHelpers.getSymbol((MethodTree)tree);
        if (sym.isStatic()) {
            return Description.NO_MATCH;
        }
        if (ASTHelpers.hasAnnotation((Symbol)sym, Override.class, (VisitorState)state)) {
            return Description.NO_MATCH;
        }
        if (this.ignoreInterfaceOverrides && sym.enclClass().isInterface()) {
            return Description.NO_MATCH;
        }
        return ASTHelpers.streamSuperMethods((Symbol.MethodSymbol)sym, (Types)state.getTypes()).findFirst().filter(unused -> ASTHelpers.getGeneratedBy((VisitorState)state).isEmpty()).filter(override -> !ASTHelpers.hasAnnotation((Symbol)override, Deprecated.class, (VisitorState)state)).map(override -> this.buildDescription(tree).addFix((Fix)SuggestedFix.prefixWith((Tree)tree, (String)"@Override ")).setMessage(String.format("%s %s method in %s; expected @Override", sym.getSimpleName(), override.enclClass().isInterface() || override.getModifiers().contains((Object)Modifier.ABSTRACT) ? "implements" : "overrides", override.enclClass().getSimpleName())).build()).orElse(Description.NO_MATCH);
    }
}

