/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.suppliers.Suppliers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.List;

@BugPattern(summary="Nesting Modules.combine() here is unnecessary.", severity=BugPattern.SeverityLevel.WARNING)
public final class GuiceNestedCombine
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> MODULES_COMBINE_METHOD = MethodMatchers.staticMethod().onClass("com.google.inject.util.Modules").named("combine");
    private static final Supplier<Type> MODULE = Suppliers.typeFromString((String)"com.google.inject.Module");

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!MODULES_COMBINE_METHOD.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        Type module = (Type)MODULE.get(state);
        if (module == null || tree.getArguments().isEmpty() || !tree.getArguments().stream().allMatch(a -> ASTHelpers.isSubtype((Type)ASTHelpers.getType((Tree)a), (Type)module, (VisitorState)state))) {
            return Description.NO_MATCH;
        }
        Tree parent = state.getPath().getParentPath().getLeaf();
        if (!(parent instanceof MethodInvocationTree)) {
            return Description.NO_MATCH;
        }
        if (!GuiceNestedCombine.isInVarargsPosition(tree, (MethodInvocationTree)parent, state)) {
            return Description.NO_MATCH;
        }
        SuggestedFix fix = SuggestedFix.builder().replace(ASTHelpers.getStartPosition((Tree)tree), ASTHelpers.getStartPosition((Tree)tree.getArguments().get(0)), "").replace(state.getEndPosition((Tree)Iterables.getLast(tree.getArguments())), state.getEndPosition((Tree)tree), "").build();
        return this.describeMatch(tree, (Fix)fix);
    }

    private static boolean isInVarargsPosition(ExpressionTree argTree, MethodInvocationTree methodInvocationTree, VisitorState state) {
        Symbol.MethodSymbol methodSymbol = ASTHelpers.getSymbol((MethodInvocationTree)methodInvocationTree);
        if (!methodSymbol.isVarArgs()) {
            return false;
        }
        int parameterCount = ((List)methodSymbol.getParameters()).size();
        java.util.List<? extends ExpressionTree> arguments = methodInvocationTree.getArguments();
        return (arguments.size() > parameterCount || !state.getTypes().isArray(ASTHelpers.getType((Tree)argTree))) && arguments.indexOf(argTree) >= parameterCount - 1;
    }
}

