/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.JUnitMatchers;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.util.Name;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.type.TypeMirror;

@BugPattern(summary="Ignoring exceptions and calling fail() is unnecessary, and makes test output less useful", severity=BugPattern.SeverityLevel.WARNING)
public class CatchFail
extends BugChecker
implements BugChecker.TryTreeMatcher {
    private static final Matcher<StatementTree> FAIL_METHOD = Matchers.expressionStatement((Matcher)Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.staticMethod().onClass("org.junit.Assert").named("fail"), MethodMatchers.staticMethod().onClass("junit.framework.Assert").named("fail"), MethodMatchers.staticMethod().onClass("junit.framework.TestCase").named("fail")}));
    private static final Supplier<Name> EXPECTED = VisitorState.memoize((Supplier & Serializable)state -> state.getName("expected"));
    private static final Supplier<Symbol> ORG_JUNIT_TEST = VisitorState.memoize((Supplier & Serializable)state -> state.getSymbolFromString("org.junit.Test"));

    public Description matchTry(TryTree tree, VisitorState state) {
        if (tree.getCatches().isEmpty()) {
            return Description.NO_MATCH;
        }
        ImmutableList catchBlocks = (ImmutableList)tree.getCatches().stream().filter(c -> c.getBlock().getStatements().size() == 1 && FAIL_METHOD.matches((Tree)((StatementTree)Iterables.getOnlyElement(c.getBlock().getStatements())), state)).filter(c -> !this.catchVariableIsUsed((CatchTree)c)).collect(ImmutableList.toImmutableList());
        if (catchBlocks.isEmpty()) {
            return Description.NO_MATCH;
        }
        Description.Builder description = this.buildDescription(tree);
        CatchFail.rethrowFix((ImmutableList<CatchTree>)catchBlocks, state).ifPresent(arg_0 -> ((Description.Builder)description).addFix(arg_0));
        this.deleteFix(tree, (ImmutableList<CatchTree>)catchBlocks, state).ifPresent(arg_0 -> ((Description.Builder)description).addFix(arg_0));
        return description.build();
    }

    private static String getMessageOrFormat(MethodInvocationTree tree, VisitorState state) {
        if (tree.getArguments().size() > 1) {
            return "String.format(" + String.valueOf(state.getSourceCode().subSequence(ASTHelpers.getStartPosition((Tree)tree.getArguments().get(0)), state.getEndPosition((Tree)Iterables.getLast(tree.getArguments())))) + ")";
        }
        return state.getSourceForNode((Tree)Iterables.getOnlyElement(tree.getArguments()));
    }

    private static Optional<Fix> rethrowFix(ImmutableList<CatchTree> catchBlocks, VisitorState state) {
        SuggestedFix.Builder fix = SuggestedFix.builder();
        catchBlocks.forEach(c -> {
            StatementTree statementTree = (StatementTree)Iterables.getOnlyElement(c.getBlock().getStatements());
            MethodInvocationTree methodInvocationTree = (MethodInvocationTree)((ExpressionStatementTree)statementTree).getExpression();
            if (!methodInvocationTree.getArguments().isEmpty()) {
                String message = CatchFail.getMessageOrFormat(methodInvocationTree, state);
                fix.replace((Tree)statementTree, String.format("throw new AssertionError(%s, %s);", message, c.getParameter().getName()));
            }
        });
        return fix.isEmpty() ? Optional.empty() : Optional.of(fix.build());
    }

    /*
     * Unable to fully structure code
     */
    Optional<Fix> deleteFix(TryTree tree, ImmutableList<CatchTree> catchBlocks, VisitorState state) {
        fix = SuggestedFix.builder();
        if (tree.getFinallyBlock() != null) ** GOTO lbl7
        if (catchBlocks.size() < tree.getCatches().size()) {
lbl7:
            // 2 sources

            catchBlocks.forEach((Consumer<CatchTree>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, delete(com.sun.source.tree.Tree ), (Lcom/sun/source/tree/CatchTree;)V)((SuggestedFix.Builder)fix));
        } else {
            tryStatements = tree.getBlock().getStatements();
            if (tryStatements.isEmpty()) {
                return Optional.of(fix.delete((Tree)tree).build());
            }
            source = state.getSourceCode().toString();
            fix.replace((Tree)tree, source.substring(ASTHelpers.getStartPosition((Tree)tryStatements.get(0)), state.getEndPosition((Tree)Iterables.getLast(tryStatements))));
        }
        enclosing = ASTHelpers.findEnclosingMethod((VisitorState)state);
        if (enclosing == null) {
            return Optional.empty();
        }
        if (CatchFail.isExpectedExceptionTest(ASTHelpers.getSymbol((MethodTree)enclosing), state)) {
            return Optional.empty();
        }
        thrownTypes = ASTHelpers.getSymbol((MethodTree)enclosing).getThrownTypes();
        types = state.getTypes();
        toThrow = (ImmutableList)catchBlocks.stream().map((Function<CatchTree, Type>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$deleteFix$3(com.sun.source.tree.CatchTree ), (Lcom/sun/source/tree/CatchTree;)Lcom/sun/tools/javac/code/Type;)()).flatMap((Function<Type, Stream>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$deleteFix$4(com.sun.tools.javac.code.Type ), (Lcom/sun/tools/javac/code/Type;)Ljava/util/stream/Stream;)()).filter((Predicate<Type>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$deleteFix$6(java.util.List com.sun.tools.javac.code.Types com.sun.tools.javac.code.Type ), (Lcom/sun/tools/javac/code/Type;)Z)((List)thrownTypes, (Types)types)).collect(ImmutableList.toImmutableList());
        if (!toThrow.isEmpty()) {
            if (!JUnitMatchers.TEST_CASE.matches((Tree)enclosing, state)) {
                return Optional.empty();
            }
            throwsString = toThrow.stream().map((Function<Type, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$deleteFix$7(com.google.errorprone.VisitorState com.google.errorprone.fixes.SuggestedFix$Builder com.sun.tools.javac.code.Type ), (Lcom/sun/tools/javac/code/Type;)Ljava/lang/String;)((VisitorState)state, (SuggestedFix.Builder)fix)).distinct().collect(Collectors.joining(", "));
            if (enclosing.getThrows().isEmpty()) {
                fix.prefixWith((Tree)enclosing.getBody(), "throws " + throwsString);
            } else {
                fix.postfixWith((Tree)Iterables.getLast(enclosing.getThrows()), ", " + throwsString);
            }
        }
        return Optional.of(fix.build());
    }

    private static boolean isExpectedExceptionTest(Symbol.MethodSymbol sym, VisitorState state) {
        Attribute.Compound attribute = sym.attribute((Symbol)ORG_JUNIT_TEST.get(state));
        if (attribute == null) {
            return false;
        }
        return attribute.member((Name)EXPECTED.get(state)) != null;
    }

    private boolean catchVariableIsUsed(CatchTree c) {
        final Symbol.VarSymbol sym = ASTHelpers.getSymbol((VariableTree)c.getParameter());
        final boolean[] found = new boolean[]{false};
        c.getBlock().accept(new TreeScanner<Void, Void>(this){
            final /* synthetic */ CatchFail this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Void visitIdentifier(IdentifierTree node, Void unused) {
                if (Objects.equals(sym, ASTHelpers.getSymbol((Tree)node))) {
                    found[0] = true;
                }
                return (Void)super.visitIdentifier(node, null);
            }
        }, null);
        return found[0];
    }

    private static /* synthetic */ String lambda$deleteFix$7(VisitorState state, SuggestedFix.Builder fix, Type t) {
        return SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)fix, (TypeMirror)t);
    }

    private static /* synthetic */ boolean lambda$deleteFix$6(List thrownTypes, Types types, Type t) {
        return thrownTypes.stream().noneMatch(x -> types.isAssignable(t, (Type)x));
    }

    private static /* synthetic */ Stream lambda$deleteFix$4(Type t) {
        return t instanceof Type.UnionClassType ? ImmutableList.copyOf(((Type.UnionClassType)t).getAlternativeTypes()).stream() : Stream.of(t);
    }

    private static /* synthetic */ Type lambda$deleteFix$3(CatchTree c) {
        return ASTHelpers.getType((Tree)c.getParameter());
    }
}

