/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner.target;

import com.google.caliper.runner.config.CaliperConfig;
import com.google.caliper.runner.config.DeviceConfig;
import com.google.caliper.runner.config.VmConfig;
import com.google.caliper.runner.config.VmType;
import com.google.caliper.runner.options.CaliperOptions;
import com.google.caliper.runner.options.ParsedOptions;
import com.google.caliper.runner.target.AndroidDeviceHelper;
import com.google.caliper.runner.target.Device;
import com.google.caliper.runner.target.NonAndroidDeviceHelper;
import com.google.caliper.runner.target.RuntimeShutdownHookRegistrar;
import com.google.caliper.runner.target.ShutdownHookRegistrar;
import com.google.caliper.runner.target.VirtualMachineException;
import com.google.caliper.runner.target.Vm;
import com.google.caliper.runner.target.VmProcess;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public final class LocalDevice
extends Device {
    private static final Joiner ARG_JOINER = Joiner.on((char)' ');
    private final CaliperConfig caliperConfig;
    private final boolean redirectErrorStream;
    private final Helper helper;
    private static final ImmutableList<String> EXECUTABLE_DIRS = ImmutableList.of((Object)"bin/", (Object)"");
    private static final ImmutableList<String> EXECUTABLE_EXTENSIONS = ImmutableList.of((Object)"", (Object)".exe");
    private volatile Optional<File> vmBaseDirectory = null;

    private static boolean isAndroidDevice() {
        return System.getProperty("java.vendor").toLowerCase().contains("android");
    }

    @Inject
    LocalDevice(DeviceConfig config, CaliperConfig caliperConfig, CaliperOptions caliperOptions, ShutdownHookRegistrar shutdownHookRegistrar) {
        this(config, caliperConfig, caliperOptions, shutdownHookRegistrar, false);
    }

    private LocalDevice(DeviceConfig config, CaliperConfig caliperConfig, CaliperOptions caliperOptions, ShutdownHookRegistrar shutdownHookRegistrar, boolean redirectErrorStream) {
        super(config, shutdownHookRegistrar);
        this.caliperConfig = caliperConfig;
        this.redirectErrorStream = redirectErrorStream;
        this.helper = LocalDevice.isAndroidDevice() ? new AndroidDeviceHelper(caliperOptions) : new NonAndroidDeviceHelper(caliperOptions);
    }

    protected void startUp() {
        this.helper.setUp();
    }

    protected void shutDown() {
    }

    @Override
    public VmType defaultVmType() {
        Optional<String> type = this.config().option("defaultVmType");
        return type.isPresent() ? VmType.of((String)type.get()) : this.helper.defaultVmType();
    }

    @Override
    public VmConfig defaultVmConfig() {
        VmConfig.Builder builder = VmConfig.builder().name("default").type(this.helper.defaultVmType());
        this.helper.configureDefaultVm(builder);
        return builder.addAllArgs(this.caliperConfig.getVmArgs()).build();
    }

    @Override
    public String vmExecutablePath(Vm vm) {
        File homeDir = this.vmHomeDir(vm);
        for (String extension : EXECUTABLE_EXTENSIONS) {
            for (String dir : EXECUTABLE_DIRS) {
                String string = vm.executable();
                File file = new File(homeDir, new StringBuilder(String.valueOf(dir).length() + String.valueOf(string).length() + String.valueOf(extension).length()).append(dir).append(string).append(extension).toString());
                if (!file.isFile()) continue;
                return file.getAbsolutePath();
            }
        }
        throw new VirtualMachineException(String.format("VM executable %s for VM %s not found under home dir %s", vm.executable(), vm, homeDir));
    }

    @Override
    public String workerClasspath(VmType type) {
        return this.helper.getWorkerClasspath(type);
    }

    @Override
    public Optional<String> workerNativeLibraryDir(VmType type) {
        return Optional.absent();
    }

    private File vmHomeDir(Vm vm) {
        if (!vm.home().isPresent()) {
            File homeDir = this.helper.getHomeDir(vm, this.vmBaseDirectory(vm));
            LocalDevice.checkConfiguration(homeDir.isDirectory(), "%s is not a directory", homeDir);
            return homeDir;
        }
        String homeDirPath = (String)vm.home().get();
        File potentialHomeDir = new File(homeDirPath);
        if (potentialHomeDir.isAbsolute()) {
            LocalDevice.checkConfiguration(potentialHomeDir.isDirectory(), "%s is not a directory", potentialHomeDir);
            return potentialHomeDir;
        }
        File homeDir = new File(this.vmBaseDirectory(vm), homeDirPath);
        LocalDevice.checkConfiguration(homeDir.isDirectory(), "%s is not a directory", potentialHomeDir);
        return homeDir;
    }

    private File vmBaseDirectory(Vm vm) {
        if (this.vmBaseDirectory == null) {
            this.vmBaseDirectory = this.getVmBaseDirectory();
        }
        if (!this.vmBaseDirectory.isPresent()) {
            String string = String.valueOf(vm.config());
            throw new VirtualMachineException(new StringBuilder(63 + String.valueOf(string).length()).append("must set either a home directory or a base directory: config = ").append(string).toString());
        }
        return (File)this.vmBaseDirectory.get();
    }

    private Optional<File> getVmBaseDirectory() {
        Optional baseDirectoryPath = this.config().option("vmBaseDirectory").or(Optional.fromNullable((Object)((String)this.caliperConfig.properties().get((Object)"vm.baseDirectory"))));
        if (!baseDirectoryPath.isPresent()) {
            return Optional.absent();
        }
        File result = new File((String)baseDirectoryPath.get());
        LocalDevice.checkConfiguration(result.isAbsolute(), "VM base directory cannot be a relative path");
        LocalDevice.checkConfiguration(result.isDirectory(), "VM base directory must be a directory");
        return Optional.of((Object)result);
    }

    private static void checkConfiguration(boolean check, String message) {
        if (!check) {
            throw new VirtualMachineException(message);
        }
    }

    private static void checkConfiguration(boolean check, String messageFormat, Object ... args) {
        if (!check) {
            throw new VirtualMachineException(String.format(messageFormat, args));
        }
    }

    @Override
    public VmProcess doStartVm(VmProcess.Spec spec, VmProcess.Logger logger) throws Exception {
        ProcessBuilder builder = new ProcessBuilder(new String[0]).redirectErrorStream(this.redirectErrorStream);
        this.helper.addToWorkerProcessEnvironment(builder.environment());
        ImmutableList<String> command = this.createCommand(spec);
        String string = ARG_JOINER.join(command);
        logger.log(new StringBuilder(10 + String.valueOf(string).length()).append("Command: ").append(string).append("\n").toString());
        builder.command((List<String>)command);
        return new LocalProcess(builder.start());
    }

    @VisibleForTesting
    ImmutableList<String> createCommand(VmProcess.Spec spec) {
        return new ImmutableList.Builder().add((Object)spec.target().vmExecutablePath()).addAll(spec.vmOptions()).add((Object)spec.mainClass()).addAll(spec.mainArgs()).build();
    }

    @VisibleForTesting
    public static Builder builder() {
        return new Builder();
    }

    @VisibleForTesting
    public static final class Builder {
        private DeviceConfig deviceConfig;
        private CaliperConfig caliperConfig;
        private CaliperOptions caliperOptions;
        private ShutdownHookRegistrar shutdownHookRegistrar;
        private boolean redirectErrorStream = false;

        public Builder deviceConfig(DeviceConfig deviceConfig) {
            this.deviceConfig = (DeviceConfig)Preconditions.checkNotNull((Object)deviceConfig);
            return this;
        }

        public Builder caliperConfig(CaliperConfig caliperConfig) {
            this.caliperConfig = (CaliperConfig)Preconditions.checkNotNull((Object)caliperConfig);
            return this;
        }

        public Builder caliperOptions(CaliperOptions caliperOptions) {
            this.caliperOptions = (CaliperOptions)Preconditions.checkNotNull((Object)caliperOptions);
            return this;
        }

        public Builder shutdownHookRegistrar(ShutdownHookRegistrar shutdownHookRegistrar) {
            this.shutdownHookRegistrar = (ShutdownHookRegistrar)Preconditions.checkNotNull((Object)shutdownHookRegistrar);
            return this;
        }

        public Builder redirectErrorStream(boolean redirectErrorStream) {
            this.redirectErrorStream = redirectErrorStream;
            return this;
        }

        public LocalDevice build() {
            if (this.caliperConfig == null) {
                this.caliperConfig = new CaliperConfig((ImmutableMap<String, String>)ImmutableMap.of((Object)"device.local.type", (Object)"local"));
            }
            if (this.deviceConfig == null) {
                this.deviceConfig = this.caliperConfig.getDeviceConfig("local");
            }
            if (this.caliperOptions == null) {
                this.caliperOptions = ParsedOptions.from(new String[0], false);
            }
            if (this.shutdownHookRegistrar == null) {
                this.shutdownHookRegistrar = new RuntimeShutdownHookRegistrar();
            }
            return new LocalDevice(this.deviceConfig, this.caliperConfig, this.caliperOptions, this.shutdownHookRegistrar, this.redirectErrorStream);
        }
    }

    private static final class LocalProcess
    extends VmProcess {
        private final Process process;

        LocalProcess(Process process) {
            this.process = process;
        }

        @Override
        public InputStream stdout() {
            return this.process.getInputStream();
        }

        @Override
        public InputStream stderr() {
            return this.process.getErrorStream();
        }

        @Override
        public int doAwaitExit() throws InterruptedException {
            return this.process.waitFor();
        }

        @Override
        public void doKill() {
            this.process.destroy();
        }
    }

    static interface Helper {
        public void setUp();

        public VmType defaultVmType();

        public void configureDefaultVm(VmConfig.Builder var1);

        public File getHomeDir(Vm var1, File var2);

        public String getWorkerClasspath(VmType var1);

        public void addToWorkerProcessEnvironment(Map<String, String> var1);
    }
}

