/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner.options;

import com.google.caliper.runner.options.CaliperDirectory;
import com.google.caliper.runner.options.CaliperOptions;
import com.google.caliper.runner.options.ParsedOptions;
import com.google.caliper.util.InvalidCommandException;
import dagger.Module;
import dagger.Provides;
import java.io.File;
import javax.inject.Singleton;

@Module
public final class OptionsModule {
    private static final String[] EMPTY_ARGS = new String[0];
    private final String[] args;
    private boolean requireBenchmarkClassName;

    public static OptionsModule withBenchmarkClass(String[] args) {
        return new OptionsModule(args, true);
    }

    public static OptionsModule withoutBenchmarkClass(String[] args) {
        return new OptionsModule(args, false);
    }

    public static OptionsModule defaultOptionsModule() {
        return new OptionsModule(EMPTY_ARGS, false);
    }

    public OptionsModule(String[] args, boolean requireBenchmarkClassName) {
        this.args = (String[])args.clone();
        this.requireBenchmarkClassName = requireBenchmarkClassName;
    }

    @Provides
    @Singleton
    CaliperOptions provideOptions() throws InvalidCommandException {
        return ParsedOptions.from(this.args, this.requireBenchmarkClassName);
    }

    @Provides
    @CaliperDirectory
    static File provideCaliperDirectory(CaliperOptions options) {
        return options.caliperDirectory();
    }
}

