/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner.experiment;

import com.google.caliper.runner.experiment.BenchmarkParameters;
import com.google.caliper.runner.experiment.Experiment;
import com.google.caliper.runner.instrument.Instrument;
import com.google.caliper.runner.target.Target;
import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;

public final class ExperimentSelector {
    private final ImmutableSet<Instrument.InstrumentedMethod> instrumentedMethods;
    private final ImmutableSet<Target> targets;
    private final ImmutableSetMultimap<String, String> userParameters;

    @Inject
    ExperimentSelector(ImmutableSet<Instrument.InstrumentedMethod> instrumentedMethods, ImmutableSet<Target> targets, @BenchmarkParameters ImmutableSetMultimap<String, String> userParameters) {
        this.instrumentedMethods = instrumentedMethods;
        this.targets = targets;
        this.userParameters = userParameters;
    }

    public ImmutableSet<Instrument> instruments() {
        return FluentIterable.from(this.instrumentedMethods).transform((Function)new Function<Instrument.InstrumentedMethod, Instrument>(this){

            public Instrument apply(Instrument.InstrumentedMethod input) {
                return input.instrument();
            }
        }).toSet();
    }

    public ImmutableSet<Target> targets() {
        return this.targets;
    }

    public ImmutableSetMultimap<String, String> userParameters() {
        return this.userParameters;
    }

    public ImmutableSet<Experiment> selectExperiments() {
        ImmutableSet.Builder experiments = ImmutableSet.builder();
        int id = 1;
        for (Instrument.InstrumentedMethod instrumentedMethod : this.instrumentedMethods) {
            for (Target target : this.targets) {
                for (List<String> userParamsChoice : ExperimentSelector.cartesian(this.userParameters)) {
                    ImmutableMap theseUserParams = ExperimentSelector.zip(this.userParameters.keySet(), userParamsChoice);
                    experiments.add((Object)Experiment.create(id++, instrumentedMethod, theseUserParams, target));
                }
            }
        }
        return experiments.build();
    }

    protected static <T> Set<List<T>> cartesian(SetMultimap<String, T> multimap) {
        ImmutableMap paramsAsMap = (ImmutableMap)multimap.asMap();
        return Sets.cartesianProduct((List)paramsAsMap.values().asList());
    }

    protected static <K, V> ImmutableMap<K, V> zip(Set<K> keys, Collection<V> values) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        Iterator<K> keyIterator = keys.iterator();
        Iterator<V> valueIterator = values.iterator();
        while (keyIterator.hasNext() && valueIterator.hasNext()) {
            builder.put(keyIterator.next(), valueIterator.next());
        }
        if (keyIterator.hasNext() || valueIterator.hasNext()) {
            throw new AssertionError();
        }
        return builder.build();
    }
}

