
[//000000001]: # (page\_util\_peg \- Parser generator tools)
[//000000002]: # (Generated from file 'page\_util\_peg\.man' by tcllib/doctools with format 'markdown')
[//000000003]: # (Copyright &copy; 2007 Andreas Kupries <andreas\_kupries@users\.sourceforge\.net>)
[//000000004]: # (page\_util\_peg\(n\) 1\.0 tcllib "Parser generator tools")

<hr> [ <a href="../../../../toc.md">Main Table Of Contents</a> &#124; <a
href="../../../toc.md">Table Of Contents</a> &#124; <a
href="../../../../index.md">Keyword Index</a> &#124; <a
href="../../../../toc0.md">Categories</a> &#124; <a
href="../../../../toc1.md">Modules</a> &#124; <a
href="../../../../toc2.md">Applications</a> ] <hr>

# NAME

page\_util\_peg \- page PEG transformation utilities

# <a name='toc'></a>Table Of Contents

  - [Table Of Contents](#toc)

  - [Synopsis](#synopsis)

  - [Description](#section1)

  - [API](#section2)

  - [Bugs, Ideas, Feedback](#section3)

  - [Keywords](#keywords)

  - [Category](#category)

  - [Copyright](#copyright)

# <a name='synopsis'></a>SYNOPSIS

package require page::util::peg ?0\.2?  
package require snit  

[__::page::util::peg::symbolNodeOf__ *tree* *node*](#1)  
[__::page::util::peg::symbolOf__ *tree* *node*](#2)  
[__::page::util::peg::updateUndefinedDueRemoval__ *tree*](#3)  
[__::page::util::peg::flatten__ *treequery* *tree*](#4)  
[__::page::util::peg::getWarnings__ *tree*](#5)  
[__::page::util::peg::printWarnings__ *msg*](#6)  
[__::page::util::peg::peOf__ *tree* *eroot*](#7)  
[__::page::util::peg::printTclExpr__ *pe*](#8)  

# <a name='description'></a>DESCRIPTION

This package provides a few common operations to PEG transformations\. They
assume a *Normalized PE Grammar Tree* as input, see the package
__page::util::norm::peg__, possibly augmented with attributes coming from
transformations not in conflict with the base definition\.

# <a name='section2'></a>API

  - <a name='1'></a>__::page::util::peg::symbolNodeOf__ *tree* *node*

    Given an arbitrary expression *node* in the AST *tree* it determines the
    node \(itself or an ancestor\) containing the name of the nonterminal symbol
    the node belongs to, and returns its id\. The result is either the root of
    the tree \(for the start expression\), or a definition node\.

  - <a name='2'></a>__::page::util::peg::symbolOf__ *tree* *node*

    As __::page::util::peg::symbolNodeOf__, but returns the symbol name
    instead of the node\.

  - <a name='3'></a>__::page::util::peg::updateUndefinedDueRemoval__ *tree*

    The removal of nodes in the AST *tree* can cause symbols to lose one or
    more users\.

        A used by B and C,
        B is reachable,
        C is not,

        so A now loses the node in the expression for C calling it,
        or rather, not calling it anymore.

    This command updates the cross\-references and which nonterminals are now
    undefined\.

  - <a name='4'></a>__::page::util::peg::flatten__ *treequery* *tree*

    This commands flattens nested sequence and choice operators in the AST
    *tree*, re\-using the __[treeql](\.\./treeql/treeql\.md)__ object
    *treequery* to run the query determining which nodes to cut\.

  - <a name='5'></a>__::page::util::peg::getWarnings__ *tree*

    This command looks at the attributes of the AST *tree* for problems with
    the grammar and issues warnings\. They do not prevent us from writing the
    grammar, but still represent problems with it the user should be made aware
    of\.

    The result of the command is a dictionary mapping nonterminal names to their
    associated warnings\.

  - <a name='6'></a>__::page::util::peg::printWarnings__ *msg*

    The argument of the command is a dictionary mapping nonterminal names to
    their associated warnings, as generated by, for example, the command
    __::page::util::peg::getWarnings__\.

    The warnings contained therein are formatted and then printed via the log
    command __page\_info__\. This means that this command can be used only
    from within a plugin managed by the package __page::pluginmgr__\.

  - <a name='7'></a>__::page::util::peg::peOf__ *tree* *eroot*

    This command converts the parsing expression starting at the node *eroot*
    in the AST *tree* into a nested list\. The exact syntax of this list
    specified by the package __[grammar::peg](\.\./grammar\_peg/peg\.md)__\.

  - <a name='8'></a>__::page::util::peg::printTclExpr__ *pe*

    This command converts the parsing expression contained in the nested list
    *pe* into a Tcl string which can be placed into a Tcl script\. See the
    package __[grammar::peg](\.\./grammar\_peg/peg\.md)__ for the exact
    syntax of *pe*\.

# <a name='section3'></a>Bugs, Ideas, Feedback

This document, and the package it describes, will undoubtedly contain bugs and
other problems\. Please report such in the category *page* of the [Tcllib
Trackers](http://core\.tcl\.tk/tcllib/reportlist)\. Please also report any ideas
for enhancements you may have for either package and/or documentation\.

When proposing code changes, please provide *unified diffs*, i\.e the output of
__diff \-u__\.

Note further that *attachments* are strongly preferred over inlined patches\.
Attachments can be made by going to the __Edit__ form of the ticket
immediately after its creation, and then using the left\-most button in the
secondary navigation bar\.

# <a name='keywords'></a>KEYWORDS

[PEG](\.\./\.\./\.\./\.\./index\.md\#peg), [page](\.\./\.\./\.\./\.\./index\.md\#page),
[parser generator](\.\./\.\./\.\./\.\./index\.md\#parser\_generator), [parsing
expression grammar](\.\./\.\./\.\./\.\./index\.md\#parsing\_expression\_grammar), [text
processing](\.\./\.\./\.\./\.\./index\.md\#text\_processing),
[transformation](\.\./\.\./\.\./\.\./index\.md\#transformation)

# <a name='category'></a>CATEGORY

Page Parser Generator

# <a name='copyright'></a>COPYRIGHT

Copyright &copy; 2007 Andreas Kupries <andreas\_kupries@users\.sourceforge\.net>
