/* riscv64-linux.elf-so_entry.h
   created from riscv64-linux.elf-so_entry.bin, 4214 (0x1076) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) Markus Franz Xaver Johannes Oberhumer
   Copyright (C) Laszlo Molnar
   Copyright (C) John F. Reiser
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <markus@oberhumer.com>               <ezerotven+github@gmail.com>

   John F. Reiser
   <jreiser@users.sourceforge.net>
 */

/* clang-format off */

#define STUB_RISCV64_LINUX_ELF_SO_ENTRY_SIZE    4214
#define STUB_RISCV64_LINUX_ELF_SO_ENTRY_ADLER32 0x8037d77b
#define STUB_RISCV64_LINUX_ELF_SO_ENTRY_CRC32   0xed5f1470

unsigned char stub_riscv64_linux_elf_so_entry[4214] = {
/* 0x0000 */ 127, 69, 76, 70,  2,  1,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0010 */   1,  0,243,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0020 */   0,  0,  0,  0,  0,  0,  0,  0, 56,  7,  0,  0,  0,  0,  0,  0,
/* 0x0030 */   5,  0,  0,  0, 64,  0,  0,  0,  0,  0, 64,  0,  7,  0,  6,  0,
/* 0x0040 */ 239,  2,  0,  0,  1, 17, 42,224, 46,228, 50,232,  6,236, 65, 17,
/* 0x0050 */  34,224, 38,228, 57,113,102,240, 22,244,  3,229,  7,  0, 42,252,
/* 0x0060 */ 138,140, 51,  5,161, 64, 19,113,  5,255,  1, 70,239,  5, 64,  1,
/* 0x0070 */  47,112,114,111, 99, 47,115,101,108,102, 47, 97,117,120,118,  0,
/* 0x0080 */   1, 69,147,  8,128,  3,115,  0,  0,  0, 42,135, 19,  1,  1,192,
/* 0x0090 */ 138,133, 19,  6,  0, 64,147,  8,240,  3,115,  0,  0,  0, 58,133,
/* 0x00a0 */  51,  7,161,  0,147,  8,144,  3,115,  0,  0,  0,136,101,144, 97,
/* 0x00b0 */ 193,  5,105, 22,  1,198,227,155,229,254,  5,101, 51,  5,160, 64,
/* 0x00c0 */  19,  1,  1, 64, 35,188,172,  0,  3,198,135,  0,137, 70, 99,  3,
/* 0x00d0 */ 214,  0,  2,144, 19,135,199,  0,  3,229,  7,  0, 10,149, 35,180,
/* 0x00e0 */ 172,  0,  3,229, 71,  0, 58,149, 35,176,172,  0,138,135,239,  2,
/* 0x00f0 */  32,  5, 27,213,245,  1,173,157,145,193,130,128,131, 69, 23,  0,
/* 0x0100 */ 162,  5,  3, 69, 39,  0,197,141,131, 68, 55,  0, 66,  5,201,141,
/* 0x0110 */ 226,  4,197,141, 17,  7, 27,213,245,  1,134,  5,131, 68,  7,  0,
/* 0x0120 */ 133, 37,130,128, 51,134,215,  0, 62,148,131, 68,  6,  0, 35,128,
/* 0x0130 */ 151,  0,133,  7,131, 68, 22,  0,  5,  6,227,154,135,254,130,128,
/* 0x0140 */ 183,  5,  0,128,253, 86, 41,160,  5,  7, 35,128,151,  0,133,  7,
/* 0x0150 */ 131, 68,  7,  0,130,146,109,249,  5, 68,130,146,  6,  4, 73,140,
/* 0x0160 */ 130,146,101,221,117, 52, 99, 74,  4,  0, 34,  4,  5,  7, 37,156,
/* 0x0170 */ 131, 68,  7,  0,147, 70,244,255,157,202,  5, 70,  1, 68,130,146,
/* 0x0180 */   6,  4, 73,140,130,146,  6,  4, 73,140,  1,232, 13, 70,  5, 68,
/* 0x0190 */ 130,146,  6,  4, 73,140,130,146,101,221, 50,148,125,118, 27,  6,
/* 0x01a0 */   6, 48, 51,182,198,  0, 50,148,231,128, 34,  3, 85,183, 17,160,
/* 0x01b0 */   2,144,  3,182, 12,  0,227, 29,230,254,  3,182,140,  0,227, 25,
/* 0x01c0 */ 246,254,193, 69,111,  5,128,  0,117,112,120,  0,147,  8,112, 17,
/* 0x01d0 */ 115,  0,  0,  0, 35,184,172,  0,131,182,140,  1, 54,224,  3,230,
/* 0x01e0 */ 140,  3,138,133,  3,229, 12,  1,147,  8,  0,  4,115,  0,  0,  0,
/* 0x01f0 */ 170,149,  9,142,117,250,102,129,129, 71,  3,103,  1,  1,137, 70,
/* 0x0200 */  29, 70,131,101,129,  3,  1, 69,147,  8,224, 13,115,  0,  0,  0,
/* 0x0210 */  99, 83,  5,  0,  2,144, 42,248, 42,135,  3,101,  1,  1,147,  8,
/* 0x0220 */ 144,  3,115,  0,  0,  0,162,114,130,124, 19,133,194,254,140,  8,
/* 0x0230 */  69, 97,103,  0,  7,  1,  0,  0,231,135,  2,  0,  0,  0,  0,  0,
/* 0x0240 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0250 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  3,  0,
/* 0x0260 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0270 */  11,  0,  0,  0,  0,  0,  1,  0,  0,  1,  0,  0,  0,  0,  0,  0,
/* 0x0280 */   0,  0,  0,  0,  0,  0,  0,  0, 19,  0,  0,  0,  0,  0,  1,  0,
/* 0x0290 */ 188,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x02a0 */  26,  0,  0,  0,  0,  0,  1,  0, 16,  1,  0,  0,  0,  0,  0,  0,
/* 0x02b0 */   0,  0,  0,  0,  0,  0,  0,  0, 34,  0,  0,  0,  0,  0,  1,  0,
/* 0x02c0 */   8,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x02d0 */  42,  0,  0,  0,  0,  0,  1,  0, 26,  1,  0,  0,  0,  0,  0,  0,
/* 0x02e0 */   0,  0,  0,  0,  0,  0,  0,  0, 67,  0,  0,  0,  0,  0,  1,  0,
/* 0x02f0 */  58,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0300 */  54,  0,  0,  0,  0,  0,  1,  0,110,  1,  0,  0,  0,  0,  0,  0,
/* 0x0310 */   0,  0,  0,  0,  0,  0,  0,  0, 64,  0,  0,  0,  0,  0,  1,  0,
/* 0x0320 */  90,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0330 */  75,  0,  0,  0,  0,  0,  1,  0, 80,  1,  0,  0,  0,  0,  0,  0,
/* 0x0340 */   0,  0,  0,  0,  0,  0,  0,  0, 87,  0,  0,  0,  0,  0,  1,  0,
/* 0x0350 */ 114,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0360 */  95,  0,  0,  0,  0,  0,  1,  0,112,  1,  0,  0,  0,  0,  0,  0,
/* 0x0370 */   0,  0,  0,  0,  0,  0,  0,  0,106,  0,  0,  0,  0,  0,  1,  0,
/* 0x0380 */ 168,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0390 */ 111,  0,  0,  0,  0,  0,  1,  0, 64,  0,  0,  0,  0,  0,  0,  0,
/* 0x03a0 */   0,  0,  0,  0,  0,  0,  0,  0,117,  0,  0,  0,  0,  0,  1,  0,
/* 0x03b0 */ 124,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x03c0 */ 123,  0,  0,  0,  0,  0,  1,  0,108,  0,  0,  0,  0,  0,  0,  0,
/* 0x03d0 */   0,  0,  0,  0,  0,  0,  0,  0,129,  0,  0,  0,  0,  0,  1,  0,
/* 0x03e0 */ 148,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x03f0 */ 135,  0,  0,  0,  0,  0,  1,  0,238,  0,  0,  0,  0,  0,  0,  0,
/* 0x0400 */   0,  0,  0,  0,  0,  0,  0,  0,141,  0,  0,  0,  0,  0,  1,  0,
/* 0x0410 */ 140,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0420 */ 147,  0,  0,  0,  0,  0,  1,  0,214,  1,  0,  0,  0,  0,  0,  0,
/* 0x0430 */   0,  0,  0,  0,  0,  0,  0,  0,153,  0,  0,  0, 16,  0,  1,  0,
/* 0x0440 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0450 */   0,102,111,108,100, 95,105,110,102,111,  0,120,105,110, 95,110,
/* 0x0460 */  50, 98,  0,114,101,102,105,108,108,  0,116,111,112, 95,110, 50,
/* 0x0470 */  98,  0,108,105,116, 95,110, 50, 98,  0,111,102,102,109,111,114,
/* 0x0480 */ 101, 95,110, 50, 98,  0,108, 95,110, 50, 98, 95, 69, 79, 70,  0,
/* 0x0490 */ 103,111,116,108,101,110, 95,110, 50, 98,  0,108,101,110,109,111,
/* 0x04a0 */ 114,101, 95,110, 50, 98,  0,101,111,102, 95,110, 50, 98,  0,110,
/* 0x04b0 */  50, 98, 95, 69, 79, 70, 98, 97,100,  0, 76, 51, 54, 48,  0, 46,
/* 0x04c0 */  76, 48,  2, 49,  0, 46, 76, 49,  2, 49,  0, 46, 76, 48,  2, 50,
/* 0x04d0 */   0, 46, 76, 48,  2, 51,  0, 46, 76, 48,  2, 52,  0, 46, 76, 48,
/* 0x04e0 */   2, 53,  0, 46, 76, 48,  2, 54,  0, 95,115,116, 97,114,116,  0,
/* 0x04f0 */   0,  0,  0,  0,  0,  0,  0,  0, 17,  0,  0,  0,  1,  0,  0,  0,
/* 0x0500 */   0,  0,  0,  0,  0,  0,  0,  0, 44,  0,  0,  0,  0,  0,  0,  0,
/* 0x0510 */  17,  0,  0,  0, 14,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0520 */ 116,  0,  0,  0,  0,  0,  0,  0, 44,  0,  0,  0, 15,  0,  0,  0,
/* 0x0530 */   0,  0,  0,  0,  0,  0,  0,  0,118,  0,  0,  0,  0,  0,  0,  0,
/* 0x0540 */  16,  0,  0,  0, 16,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0550 */ 142,  0,  0,  0,  0,  0,  0,  0, 16,  0,  0,  0, 17,  0,  0,  0,
/* 0x0560 */   0,  0,  0,  0,  0,  0,  0,  0,174,  0,  0,  0,  0,  0,  0,  0,
/* 0x0570 */  17,  0,  0,  0,  2,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0580 */ 184,  0,  0,  0,  0,  0,  0,  0, 44,  0,  0,  0,  3,  0,  0,  0,
/* 0x0590 */   0,  0,  0,  0,  0,  0,  0,  0,250,  0,  0,  0,  0,  0,  0,  0,
/* 0x05a0 */  16,  0,  0,  0, 18,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x05b0 */   6,  1,  0,  0,  0,  0,  0,  0, 45,  0,  0,  0,  4,  0,  0,  0,
/* 0x05c0 */   0,  0,  0,  0,  0,  0,  0,  0, 22,  1,  0,  0,  0,  0,  0,  0,
/* 0x05d0 */  44,  0,  0,  0,  5,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x05e0 */  34,  1,  0,  0,  0,  0,  0,  0, 44,  0,  0,  0,  6,  0,  0,  0,
/* 0x05f0 */   0,  0,  0,  0,  0,  0,  0,  0, 38,  1,  0,  0,  0,  0,  0,  0,
/* 0x0600 */  16,  0,  0,  0,  7,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0610 */  56,  1,  0,  0,  0,  0,  0,  0, 44,  0,  0,  0,  8,  0,  0,  0,
/* 0x0620 */   0,  0,  0,  0,  0,  0,  0,  0, 74,  1,  0,  0,  0,  0,  0,  0,
/* 0x0630 */  44,  0,  0,  0,  9,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0640 */  88,  1,  0,  0,  0,  0,  0,  0, 44,  0,  0,  0, 10,  0,  0,  0,
/* 0x0650 */   0,  0,  0,  0,  0,  0,  0,  0,108,  1,  0,  0,  0,  0,  0,  0,
/* 0x0660 */  45,  0,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0670 */ 110,  1,  0,  0,  0,  0,  0,  0, 45,  0,  0,  0, 11,  0,  0,  0,
/* 0x0680 */   0,  0,  0,  0,  0,  0,  0,  0,118,  1,  0,  0,  0,  0,  0,  0,
/* 0x0690 */  16,  0,  0,  0, 12,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x06a0 */ 126,  1,  0,  0,  0,  0,  0,  0, 16,  0,  0,  0, 12,  0,  0,  0,
/* 0x06b0 */   0,  0,  0,  0,  0,  0,  0,  0,132,  1,  0,  0,  0,  0,  0,  0,
/* 0x06c0 */  17,  0,  0,  0, 19,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x06d0 */ 180,  1,  0,  0,  0,  0,  0,  0, 44,  0,  0,  0, 13,  0,  0,  0,
/* 0x06e0 */   0,  0,  0,  0,  0,  0,  0,  0,208,  1,  0,  0,  0,  0,  0,  0,
/* 0x06f0 */  16,  0,  0,  0, 20,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0700 */   0, 46,115,121,109,116, 97, 98,  0, 46,115,116,114,116, 97, 98,
/* 0x0710 */   0, 46,115,104,115,116,114,116, 97, 98,  0, 46,114,101,108, 97,
/* 0x0720 */  69, 76, 70, 77, 65, 73, 78, 88,  0, 69, 76, 70, 77, 65, 73, 78,
/* 0x0730 */  90,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0740 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0750 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0760 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0770 */   0,  0,  0,  0,  0,  0,  0,  0, 32,  0,  0,  0,  1,  0,  0,  0,
/* 0x0780 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0790 */  64,  0,  0,  0,  0,  0,  0,  0,246,  1,  0,  0,  0,  0,  0,  0,
/* 0x07a0 */   0,  0,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0,
/* 0x07b0 */   0,  0,  0,  0,  0,  0,  0,  0, 27,  0,  0,  0,  4,  0,  0,  0,
/* 0x07c0 */  64,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x07d0 */ 240,  4,  0,  0,  0,  0,  0,  0, 16,  2,  0,  0,  0,  0,  0,  0,
/* 0x07e0 */   4,  0,  0,  0,  1,  0,  0,  0,  8,  0,  0,  0,  0,  0,  0,  0,
/* 0x07f0 */  24,  0,  0,  0,  0,  0,  0,  0, 41,  0,  0,  0,  1,  0,  0,  0,
/* 0x0800 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0810 */  56,  2,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0,
/* 0x0820 */   0,  0,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0,
/* 0x0830 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  2,  0,  0,  0,
/* 0x0840 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0850 */  64,  2,  0,  0,  0,  0,  0,  0, 16,  2,  0,  0,  0,  0,  0,  0,
/* 0x0860 */   5,  0,  0,  0, 21,  0,  0,  0,  8,  0,  0,  0,  0,  0,  0,  0,
/* 0x0870 */  24,  0,  0,  0,  0,  0,  0,  0,  9,  0,  0,  0,  3,  0,  0,  0,
/* 0x0880 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0890 */  80,  4,  0,  0,  0,  0,  0,  0,160,  0,  0,  0,  0,  0,  0,  0,
/* 0x08a0 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x08b0 */   0,  0,  0,  0,  0,  0,  0,  0, 17,  0,  0,  0,  3,  0,  0,  0,
/* 0x08c0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x08d0 */   0,  7,  0,  0,  0,  0,  0,  0, 50,  0,  0,  0,  0,  0,  0,  0,
/* 0x08e0 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x08f0 */   0,  0,  0,  0,  0,  0,  0,  0,102,105,108,101, 32,102,111,114,
/* 0x0900 */ 109, 97,116, 32,101,108,102, 54, 52, 45,108,105,116,116,108,101,
/* 0x0910 */ 114,105,115, 99,118, 10, 10, 83,101, 99,116,105,111,110,115, 58,
/* 0x0920 */  10, 73,100,120, 32, 78, 97,109,101, 32, 32, 32, 32, 32, 32, 32,
/* 0x0930 */  32, 32, 32, 83,105,122,101, 32, 32, 32, 32, 32, 32, 86, 77, 65,
/* 0x0940 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x0950 */  77, 65, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x0960 */  32, 70,105,108,101, 32,111,102,102, 32, 32, 65,108,103,110, 32,
/* 0x0970 */  32, 70,108, 97,103,115, 10, 32, 32, 48, 32, 69, 76, 70, 77, 65,
/* 0x0980 */  73, 78, 88, 32, 32, 32, 32, 32, 32, 48, 49,102, 54, 32, 32, 48,
/* 0x0990 */  32, 32, 48, 32, 32, 48, 52, 48, 32, 32, 50, 42, 42, 50, 32, 32,
/* 0x09a0 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 49, 32, 69, 76, 70,
/* 0x09b0 */  77, 65, 73, 78, 90, 32, 32, 32, 32, 32, 32, 48, 52, 32, 32, 48,
/* 0x09c0 */  32, 32, 48, 32, 32, 48, 50, 51, 56, 32, 32, 50, 42, 42, 50, 32,
/* 0x09d0 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 83, 89, 77, 66, 79, 76,
/* 0x09e0 */  32, 84, 65, 66, 76, 69, 58, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x09f0 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32, 32, 32,
/* 0x0a00 */  32, 69, 76, 70, 77, 65, 73, 78, 90, 32, 48, 32,102,111,108,100,
/* 0x0a10 */  95,105,110,102,111, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x0a20 */  48, 48, 48, 49, 48, 48, 32,108, 32, 32, 32, 32, 32, 32, 32, 69,
/* 0x0a30 */  76, 70, 77, 65, 73, 78, 88, 32, 48, 32,120,105,110, 95,110, 50,
/* 0x0a40 */  98, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x0a50 */  98, 99, 32,108, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65,
/* 0x0a60 */  73, 78, 88, 32, 48, 32,114,101,102,105,108,108, 10, 48, 48, 48,
/* 0x0a70 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 49, 48, 32,108, 32,
/* 0x0a80 */  32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88, 32, 48,
/* 0x0a90 */  32,116,111,112, 95,110, 50, 98, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x0aa0 */  48, 48, 48, 48, 48, 48, 49, 48, 56, 32,108, 32, 32, 32, 32, 32,
/* 0x0ab0 */  32, 32, 69, 76, 70, 77, 65, 73, 78, 88, 32, 48, 32,108,105,116,
/* 0x0ac0 */  95,110, 50, 98, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x0ad0 */  48, 48, 49, 49, 97, 32,108, 32, 32, 32, 32, 32, 32, 32, 69, 76,
/* 0x0ae0 */  70, 77, 65, 73, 78, 88, 32, 48, 32,111,102,102,109,111,114,101,
/* 0x0af0 */  95,110, 50, 98, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x0b00 */  48, 48, 49, 51, 97, 32,108, 32, 32, 32, 32, 32, 32, 32, 69, 76,
/* 0x0b10 */  70, 77, 65, 73, 78, 88, 32, 48, 32,108,101,110, 95,110, 50, 98,
/* 0x0b20 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 54,
/* 0x0b30 */ 101, 32,108, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73,
/* 0x0b40 */  78, 88, 32, 48, 32,108, 95,110, 50, 98, 95, 69, 79, 70, 10, 48,
/* 0x0b50 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 53, 97, 32,
/* 0x0b60 */ 108, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88,
/* 0x0b70 */  32, 48, 32,103,111,116,108,101,110, 95,110, 50, 98, 10, 48, 48,
/* 0x0b80 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 53, 48, 32,108,
/* 0x0b90 */  32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88, 32,
/* 0x0ba0 */  48, 32,108,101,110,109,111,114,101, 95,110, 50, 98, 10, 48, 48,
/* 0x0bb0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 55, 50, 32,108,
/* 0x0bc0 */  32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88, 32,
/* 0x0bd0 */  48, 32,101,111,102, 95,110, 50, 98, 10, 48, 48, 48, 48, 48, 48,
/* 0x0be0 */  48, 48, 48, 48, 48, 48, 48, 49, 55, 48, 32,108, 32, 32, 32, 32,
/* 0x0bf0 */  32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88, 32, 48, 32,110, 50,
/* 0x0c00 */  98, 95, 69, 79, 70, 98, 97,100, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x0c10 */  48, 48, 48, 48, 48, 48, 49, 97, 56, 32,108, 32, 32, 32, 32, 32,
/* 0x0c20 */  32, 32, 69, 76, 70, 77, 65, 73, 78, 88, 32, 48, 32, 76, 51, 54,
/* 0x0c30 */  48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x0c40 */  48, 48, 32,103, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65,
/* 0x0c50 */  73, 78, 88, 32, 48, 32, 95,115,116, 97,114,116, 10, 10, 82, 69,
/* 0x0c60 */  76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,
/* 0x0c70 */  32, 70, 79, 82, 32, 91, 69, 76, 70, 77, 65, 73, 78, 88, 93, 58,
/* 0x0c80 */  10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x0c90 */  32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x0ca0 */  32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x0cb0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 82, 95, 82, 73, 83,
/* 0x0cc0 */  67, 86, 95, 74, 65, 76, 32, 32, 32, 32, 32, 32, 32,102,111,108,
/* 0x0cd0 */ 100, 95,105,110,102,111, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x0ce0 */  48, 48, 48, 48, 48, 50, 99, 32, 82, 95, 82, 73, 83, 67, 86, 95,
/* 0x0cf0 */  74, 65, 76, 32, 32, 32, 32, 32, 32, 32, 46, 76, 48, 94, 66, 49,
/* 0x0d00 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 55,
/* 0x0d10 */  52, 32, 82, 95, 82, 73, 83, 67, 86, 95, 82, 86, 67, 95, 66, 82,
/* 0x0d20 */  65, 78, 67, 72, 32, 32, 46, 76, 49, 94, 66, 49, 10, 48, 48, 48,
/* 0x0d30 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 55, 54, 32, 82, 95,
/* 0x0d40 */  82, 73, 83, 67, 86, 95, 66, 82, 65, 78, 67, 72, 32, 32, 32, 32,
/* 0x0d50 */  46, 76, 48, 94, 66, 50, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x0d60 */  48, 48, 48, 48, 48, 56,101, 32, 82, 95, 82, 73, 83, 67, 86, 95,
/* 0x0d70 */  66, 82, 65, 78, 67, 72, 32, 32, 32, 32, 46, 76, 48, 94, 66, 51,
/* 0x0d80 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 97,
/* 0x0d90 */ 101, 32, 82, 95, 82, 73, 83, 67, 86, 95, 74, 65, 76, 32, 32, 32,
/* 0x0da0 */  32, 32, 32, 32,120,105,110, 95,110, 50, 98, 10, 48, 48, 48, 48,
/* 0x0db0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 98, 56, 32, 82, 95, 82,
/* 0x0dc0 */  73, 83, 67, 86, 95, 82, 86, 67, 95, 66, 82, 65, 78, 67, 72, 32,
/* 0x0dd0 */  32,114,101,102,105,108,108, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x0de0 */  48, 48, 48, 48, 48, 48,102, 97, 32, 82, 95, 82, 73, 83, 67, 86,
/* 0x0df0 */  95, 66, 82, 65, 78, 67, 72, 32, 32, 32, 32, 46, 76, 48, 94, 66,
/* 0x0e00 */  52, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49,
/* 0x0e10 */  48, 54, 32, 82, 95, 82, 73, 83, 67, 86, 95, 82, 86, 67, 95, 74,
/* 0x0e20 */  85, 77, 80, 32, 32,116,111,112, 95,110, 50, 98, 10, 48, 48, 48,
/* 0x0e30 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 49, 54, 32, 82, 95,
/* 0x0e40 */  82, 73, 83, 67, 86, 95, 82, 86, 67, 95, 66, 82, 65, 78, 67, 72,
/* 0x0e50 */  32, 32,108,105,116, 95,110, 50, 98, 10, 48, 48, 48, 48, 48, 48,
/* 0x0e60 */  48, 48, 48, 48, 48, 48, 48, 49, 50, 50, 32, 82, 95, 82, 73, 83,
/* 0x0e70 */  67, 86, 95, 82, 86, 67, 95, 66, 82, 65, 78, 67, 72, 32, 32,111,
/* 0x0e80 */ 102,102,109,111,114,101, 95,110, 50, 98, 10, 48, 48, 48, 48, 48,
/* 0x0e90 */  48, 48, 48, 48, 48, 48, 48, 48, 49, 50, 54, 32, 82, 95, 82, 73,
/* 0x0ea0 */  83, 67, 86, 95, 66, 82, 65, 78, 67, 72, 32, 32, 32, 32,108,101,
/* 0x0eb0 */ 110, 95,110, 50, 98, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x0ec0 */  48, 48, 48, 49, 51, 56, 32, 82, 95, 82, 73, 83, 67, 86, 95, 82,
/* 0x0ed0 */  86, 67, 95, 66, 82, 65, 78, 67, 72, 32, 32,108, 95,110, 50, 98,
/* 0x0ee0 */  95, 69, 79, 70, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x0ef0 */  48, 48, 49, 52, 97, 32, 82, 95, 82, 73, 83, 67, 86, 95, 82, 86,
/* 0x0f00 */  67, 95, 66, 82, 65, 78, 67, 72, 32, 32,103,111,116,108,101,110,
/* 0x0f10 */  95,110, 50, 98, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x0f20 */  48, 48, 49, 53, 56, 32, 82, 95, 82, 73, 83, 67, 86, 95, 82, 86,
/* 0x0f30 */  67, 95, 66, 82, 65, 78, 67, 72, 32, 32,108,101,110,109,111,114,
/* 0x0f40 */ 101, 95,110, 50, 98, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x0f50 */  48, 48, 48, 49, 54, 99, 32, 82, 95, 82, 73, 83, 67, 86, 95, 82,
/* 0x0f60 */  86, 67, 95, 74, 85, 77, 80, 32, 32,116,111,112, 95,110, 50, 98,
/* 0x0f70 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 54,
/* 0x0f80 */ 101, 32, 82, 95, 82, 73, 83, 67, 86, 95, 82, 86, 67, 95, 74, 85,
/* 0x0f90 */  77, 80, 32, 32,101,111,102, 95,110, 50, 98, 10, 48, 48, 48, 48,
/* 0x0fa0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 55, 54, 32, 82, 95, 82,
/* 0x0fb0 */  73, 83, 67, 86, 95, 66, 82, 65, 78, 67, 72, 32, 32, 32, 32,110,
/* 0x0fc0 */  50, 98, 95, 69, 79, 70, 98, 97,100, 10, 48, 48, 48, 48, 48, 48,
/* 0x0fd0 */  48, 48, 48, 48, 48, 48, 48, 49, 55,101, 32, 82, 95, 82, 73, 83,
/* 0x0fe0 */  67, 86, 95, 66, 82, 65, 78, 67, 72, 32, 32, 32, 32,110, 50, 98,
/* 0x0ff0 */  95, 69, 79, 70, 98, 97,100, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1000 */  48, 48, 48, 48, 48, 49, 56, 52, 32, 82, 95, 82, 73, 83, 67, 86,
/* 0x1010 */  95, 74, 65, 76, 32, 32, 32, 32, 32, 32, 32, 46, 76, 48, 94, 66,
/* 0x1020 */  53, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49,
/* 0x1030 */  98, 52, 32, 82, 95, 82, 73, 83, 67, 86, 95, 82, 86, 67, 95, 66,
/* 0x1040 */  82, 65, 78, 67, 72, 32, 32, 76, 51, 54, 48, 10, 48, 48, 48, 48,
/* 0x1050 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 49,100, 48, 32, 82, 95, 82,
/* 0x1060 */  73, 83, 67, 86, 95, 66, 82, 65, 78, 67, 72, 32, 32, 32, 32, 46,
/* 0x1070 */  76, 48, 94, 66, 54, 10
};
