/*
The MIT License (MIT)

Copyright (c) 2016-2020 Containous SAS; 2020-2026 Traefik Labs

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1alpha1

// IngressRouteSpecApplyConfiguration represents a declarative configuration of the IngressRouteSpec type for use
// with apply.
type IngressRouteSpecApplyConfiguration struct {
	Routes      []RouteApplyConfiguration           `json:"routes,omitempty"`
	EntryPoints []string                            `json:"entryPoints,omitempty"`
	TLS         *TLSApplyConfiguration              `json:"tls,omitempty"`
	ParentRefs  []IngressRouteRefApplyConfiguration `json:"parentRefs,omitempty"`
}

// IngressRouteSpecApplyConfiguration constructs a declarative configuration of the IngressRouteSpec type for use with
// apply.
func IngressRouteSpec() *IngressRouteSpecApplyConfiguration {
	return &IngressRouteSpecApplyConfiguration{}
}

// WithRoutes adds the given value to the Routes field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Routes field.
func (b *IngressRouteSpecApplyConfiguration) WithRoutes(values ...*RouteApplyConfiguration) *IngressRouteSpecApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithRoutes")
		}
		b.Routes = append(b.Routes, *values[i])
	}
	return b
}

// WithEntryPoints adds the given value to the EntryPoints field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the EntryPoints field.
func (b *IngressRouteSpecApplyConfiguration) WithEntryPoints(values ...string) *IngressRouteSpecApplyConfiguration {
	for i := range values {
		b.EntryPoints = append(b.EntryPoints, values[i])
	}
	return b
}

// WithTLS sets the TLS field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the TLS field is set to the value of the last call.
func (b *IngressRouteSpecApplyConfiguration) WithTLS(value *TLSApplyConfiguration) *IngressRouteSpecApplyConfiguration {
	b.TLS = value
	return b
}

// WithParentRefs adds the given value to the ParentRefs field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the ParentRefs field.
func (b *IngressRouteSpecApplyConfiguration) WithParentRefs(values ...*IngressRouteRefApplyConfiguration) *IngressRouteSpecApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithParentRefs")
		}
		b.ParentRefs = append(b.ParentRefs, *values[i])
	}
	return b
}
