%module strumpack;

%insert(fbegin)
%{
! STRUMPACK -- STRUctured Matrices PACKage, Copyright (c) 2014, The
! Regents of the University of California, through Lawrence Berkeley
! National Laboratory (subject to receipt of any required approvals
! from the U.S. Dept. of Energy).  All rights reserved.
!
! If you have questions about your rights to use or distribute this
! software, please contact Berkeley Lab's Technology Transfer
! Department at TTD@lbl.gov.
!
! NOTICE. This software is owned by the U.S. Department of Energy. As
! such, the U.S. Government has been granted for itself and others
! acting on its behalf a paid-up, nonexclusive, irrevocable,
! worldwide license in the Software to reproduce, prepare derivative
! works, and perform publicly and display publicly.  Beginning five
! (5) years after the date permission to assert copyright is obtained
! from the U.S. Department of Energy, and subject to any subsequent
! five (5) year renewals, the U.S. Government is granted for itself
! and others acting on its behalf a paid-up, nonexclusive,
! irrevocable, worldwide license in the Software to reproduce,
! prepare derivative works, distribute copies to the public, perform
! publicly and display publicly, and to permit others to do so.
!
! Developers: Pieter Ghysels, Francois-Henry Rouet, Xiaoye S. Li.
!             (Lawrence Berkeley National Lab, Computational Research
!             Division).
%}


// Translate all enums and other compile-time constants into fortran parameters
%fortranconst;
// Provide interfaces to functions and `struct`s rather than wrapping them
%fortranbindc;

// Allow this struct to be passed natively between C and Fortran
%fortran_struct(STRUMPACK_SparseSolver)

// The STRUMPACK_Krylov_solver accessor is the same fortran identifier as the
// enum STRUMPACK_KRYLOV_SOLVER (since fortran is case insensitive)
%rename("get_%s") STRUMPACK_Krylov_solver;

%rename("STRUMPACK_init") STRUMPACK_init_f;

%inline %{
#include "../StrumpackSparseSolver.h"
#include <stdio.h>

#ifdef __cplusplus
extern "C" {
#endif
void STRUMPACK_init_f(STRUMPACK_SparseSolver* S, int comm,
                      STRUMPACK_PRECISION precision,
                      STRUMPACK_INTERFACE interface,
                      int argc, char* argv[], int verbose) {
#if defined(STRUMPACK_USE_MPI)
  STRUMPACK_init(S, MPI_Comm_f2c(comm),
                 precision, interface,
                 argc, argv, verbose);
#else
  printf("ERROR: MPI not available.\n");
#endif
}
#ifdef __cplusplus
}
#endif
%}

// Process and create wrappers for the following header file
%include "../StrumpackSparseSolver.h"
