#include <reflex/matcher.h>

#if defined(OS_WIN)
#pragma warning(disable:4101 4102)
#elif defined(__GNUC__)
#pragma GCC diagnostic ignored "-Wunused-variable"
#pragma GCC diagnostic ignored "-Wunused-label"
#elif defined(__clang__)
#pragma clang diagnostic ignored "-Wunused-variable"
#pragma clang diagnostic ignored "-Wunused-label"
#endif

void reflex_code_FSM(reflex::Matcher& m)
{
  int c = 0;
  m.FSM_INIT(c);

S0:
  m.FSM_FIND();
  c = m.FSM_CHAR();
  if (c == 'e') goto S2;
  return m.FSM_HALT(c);

S2:
  c = m.FSM_CHAR();
  if (c == 'l') goto S4;
  return m.FSM_HALT(c);

S4:
  c = m.FSM_CHAR();
  if (c == 'i') goto S7;
  if (c == 'e') goto S9;
  return m.FSM_HALT(c);

S7:
  c = m.FSM_CHAR();
  if (c == 't') goto S11;
  return m.FSM_HALT(c);

S9:
  c = m.FSM_CHAR();
  if (c == 'i') goto S13;
  return m.FSM_HALT(c);

S11:
  c = m.FSM_CHAR();
  if (m.FSM_META_EWE(c)) {
    if (m.FSM_META_BWB()) {
      m.FSM_TAKE(1, c);
    }
  }
  return m.FSM_HALT(c);

S13:
  c = m.FSM_CHAR();
  if (c == 'f') goto S17;
  return m.FSM_HALT(c);

S15:
  if (m.FSM_META_BWB()) {
    m.FSM_TAKE(1);
  }
  return m.FSM_HALT();

S17:
  c = m.FSM_CHAR();
  if (c == 'e') goto S21;
  return m.FSM_HALT(c);

S19:
  m.FSM_TAKE(1);
  return m.FSM_HALT();

S21:
  c = m.FSM_CHAR();
  if (c == 'n') goto S23;
  return m.FSM_HALT(c);

S23:
  c = m.FSM_CHAR();
  if (c == 'd') goto S11;
  return m.FSM_HALT(c);
}

// reflex::Pattern FSM C++ code or opcode constructor also takes a search pattern prediction table:
extern const char reflex_pred_FSM[] = {
  "0202656c"
  "7f64bf42bf7f7f7f7f7f7f7f7f7f7f7f41ef65cf7f7f7f7f7f7f7f7f7f7f7f7f"
  "7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f"
  "7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f"
  "7f45f77f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f"
  "7f7f7ffe7f7f7f7f7f637f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f"
  "7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f"
  "7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f"
  "7f7f7f7f6abf7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f"
  "7f7f7f7f7f7f7f64cf7f7f7f6d"
};

