var searchData=
[
  ['ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_0',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['reasons_20it_20s_20normally_20not_20required_20to_20use_20the_20c_20smtptls_20or_20c_20esmtptls_20protocols_20in_20the_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20rl_20argument_20anchor_20smtpclient_5fprotocols_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20takes_20a_20url_20argument_20the_20protocol_20scheme_20component_20is_20handled_20as_20in_20the_20following_20table_20b_20smtpcclient_20protocol_20handling_20b_20protocol_20default_20port_20description_20c_20smtp_2025_20standard_20smtp_20port_20without_20encryption_20esmpt_20and_20c_20starttls_20detection_20is_20supported_20automatically_20c_20smtps_20465_20note_20that_20port_20465_20is_20currently_20assigned_20to_20source_20specific_20multicast_20audio_20video_20a_20href_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20a_20its_20use_20as_20a_20port_20for_20secure_20smtp_20listeners_20where_20security_20is_20enforced_20at_20the_20transport_20layer_20because_20the_20server_20immediately_20negotiates_20a_20tls_20ssl_20connection_20before_20the_20application_20protocol_20communication_20starts_20is_20but_20is_20included_20in_20this_20module_20because_20many_20smtp_20servers_20still_20operate_20this_20way_20c_20smtptls_2025_20a_20c_20starttls_20command_20is_20executed_20unconditionally_20after_20the_20connection_20to_20ensure_20a_20secure_20connection_20even_20if_20the_20server_20does_20not_20declare_20support_20for_20this_20command_20in_20the_20login_20response_20it_20s_20normally_20not_20necessary_20to_20use_20this_20protocol_20as_20c_20starttls_20is_20used_20automatically_20when_20logging_20in_20to_20esmtp_20servers_20that_20declare_20support_20for_20this_20command_20in_20the_20response_20to_20the_20c_20ehlo_20command_20c_20esmtp_20587_20like_20c_20smtp_20just_20using_20port_20587_20c_20esmtps_20465_20like_20c_20smtps_20c_20esmtptls_20587_20like_20c_20smtptls_20just_20using_20port_20587_20par_20example_3a_20code_20py_20requires_20smtpclient_20requires_20mime_20message_20msg_20the_20sender_20sender_20email_20com_20my_20subject_20msg_20setbody_20body_20msg_20addto_20my_20best_20friend_20you_20friend_20com_20msg_20attach_20filename_20mime_3a_3amimetypetext_20data_20code_20log_20sub_20string_20str_20printf_20y_3a_20s_20n_20now_5fus_20str_20smtpclient_3a_3asmtpclient_20smtp_20esmtptls_3a_20user_20password_3asmtp_20example_20com_20log_20log_20smtp_20sendmessage_20msg_20endcode_20section_20smtpclient_5freferences_20smtpclient_20references_20based_20on_3a_20http_3a_20james_20apache_20org_20server_20rfclist_20smtp_20rfc0821_20txt_20http_3a_20tools_20ietf_20org_20html_20rfc821_3a_20initial_20smtp_20protocol_20spec_20http_3a_20tools_20ietf_20org_20html_20rfc1521_3a_20quoted_20printable_20base_2064_20transfer_20encodings_20http_3a_20tools_20ietf_20org_20html_20rfc2045_3a_20mime_20headers_20content_20types_20etc_20http_3a_20tools_20ietf_20org_20html_20rfc2047_3a_20q_20and_20b_20encoded_20words_20implemented_20by_20the_20mime_20module_20http_3a_20tools_20ietf_20org_20html_20rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_1',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['ref_20connectionproviderintro_20connectionprovider_20module_20the_20following_20supporting_20classes_20are_20provided_20by_20the_20mailmessage_20module_3a_20mailmessage_3a_3amessage_3a_20wraps_20a_20message_20to_20be_20sent_20via_20an_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20object_20mailmessage_3a_3aattachment_3a_20used_20to_20attach_20files_20to_20a_20mailmessage_3a_3amessage_20object_20note_20that_20the_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20class_20automatically_20detects_20if_20the_20smtp_20server_20supports_20esmtp_20and_20a_20c_20ehlo_20command_20is_20executed_20automatically_20instead_20of_20c_20helo_20if_20so_20additionally_20the_20class_20also_20automatically_20detects_20if_20the_20server_20supports_20the_20c_20starttls_20command_20by_20parsing_20the_20response_20to_20the_20c_20ehlo_20command_20when_20talking_20to_20esmtp_20servers_20if_20the_20a_20tls_20flag_20is_20not_20set_20on_20the_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20object_20and_20the_20server_20supports_20c_20starttls_20and_20a_20transport_20layer_20tls_20ssl_20connection_20was_20not_20already_20established_20then_20the_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20object_20will_20automatically_20execute_20a_20c_20starttls_20command_20after_20connecting_20so_20that_20the_20rest_20of_20the_20smtp_20session_20is_20performed_20securely_20this_20also_20allows_20transparent_20logins_20and_20communication_20with_20esmtp_20servers_20that_20require_20secure_20connections_20for_20the_20above_20reasons_20it_20s_20normally_20not_20required_20to_20use_20the_20c_20smtptls_20or_20c_20esmtptls_20protocols_20in_20the_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20rl_20argument_20anchor_20smtpclient_5fprotocols_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20takes_20a_20url_20argument_20the_20protocol_20scheme_20component_20is_20handled_20as_20in_20the_20following_20table_20b_20smtpcclient_20protocol_20handling_20b_20protocol_20default_20port_20description_20c_20smtp_2025_20standard_20smtp_20port_20without_20encryption_20esmpt_20and_20c_20starttls_20detection_20is_20supported_20automatically_20c_20smtps_20465_20note_20that_20port_20465_20is_20currently_20assigned_20to_20source_20specific_20multicast_20audio_20video_20a_20href_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20a_20its_20use_20as_20a_20port_20for_20secure_20smtp_20listeners_20where_20security_20is_20enforced_20at_20the_20transport_20layer_20because_20the_20server_20immediately_20negotiates_20a_20tls_20ssl_20connection_20before_20the_20application_20protocol_20communication_20starts_20is_20but_20is_20included_20in_20this_20module_20because_20many_20smtp_20servers_20still_20operate_20this_20way_20c_20smtptls_2025_20a_20c_20starttls_20command_20is_20executed_20unconditionally_20after_20the_20connection_20to_20ensure_20a_20secure_20connection_20even_20if_20the_20server_20does_20not_20declare_20support_20for_20this_20command_20in_20the_20login_20response_20it_20s_20normally_20not_20necessary_20to_20use_20this_20protocol_20as_20c_20starttls_20is_20used_20automatically_20when_20logging_20in_20to_20esmtp_20servers_20that_20declare_20support_20for_20this_20command_20in_20the_20response_20to_20the_20c_20ehlo_20command_20c_20esmtp_20587_20like_20c_20smtp_20just_20using_20port_20587_20c_20esmtps_20465_20like_20c_20smtps_20c_20esmtptls_20587_20like_20c_20smtptls_20just_20using_20port_20587_20par_20example_3a_20code_20py_20requires_20smtpclient_20requires_20mime_20message_20msg_20the_20sender_20sender_20email_20com_20my_20subject_20msg_20setbody_20body_20msg_20addto_20my_20best_20friend_20you_20friend_20com_20msg_20attach_20filename_20mime_3a_3amimetypetext_20data_20code_20log_20sub_20string_20str_20printf_20y_3a_20s_20n_20now_5fus_20str_20smtpclient_3a_3asmtpclient_20smtp_20esmtptls_3a_20user_20password_3asmtp_20example_20com_20log_20log_20smtp_20sendmessage_20msg_20endcode_20section_20smtpclient_5freferences_20smtpclient_20references_20based_20on_3a_20http_3a_20james_20apache_20org_20server_20rfclist_20smtp_20rfc0821_20txt_20http_3a_20tools_20ietf_20org_20html_20rfc821_3a_20initial_20smtp_20protocol_20spec_20http_3a_20tools_20ietf_20org_20html_20rfc1521_3a_20quoted_20printable_20base_2064_20transfer_20encodings_20http_3a_20tools_20ietf_20org_20html_20rfc2045_3a_20mime_20headers_20content_20types_20etc_20http_3a_20tools_20ietf_20org_20html_20rfc2047_3a_20q_20and_20b_20encoded_20words_20implemented_20by_20the_20mime_20module_20http_3a_20tools_20ietf_20org_20html_20rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_2',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_3',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['ref_20smtpclient_3a_3asmtpclient_20smtpclient_20_3a_20manages_20a_20connection_20to_20an_20smtp_20server_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20_3a_20provides_20a_20connection_20object_20to_20an_20smtp_20server_20based_20on_20the_20ref_20connectionproviderintro_20connectionprovider_20module_20the_20following_20supporting_20classes_20are_20provided_20by_20the_20mailmessage_20module_3a_20mailmessage_3a_3amessage_3a_20wraps_20a_20message_20to_20be_20sent_20via_20an_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20object_20mailmessage_3a_3aattachment_3a_20used_20to_20attach_20files_20to_20a_20mailmessage_3a_3amessage_20object_20note_20that_20the_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20class_20automatically_20detects_20if_20the_20smtp_20server_20supports_20esmtp_20and_20a_20c_20ehlo_20command_20is_20executed_20automatically_20instead_20of_20c_20helo_20if_20so_20additionally_20the_20class_20also_20automatically_20detects_20if_20the_20server_20supports_20the_20c_20starttls_20command_20by_20parsing_20the_20response_20to_20the_20c_20ehlo_20command_20when_20talking_20to_20esmtp_20servers_20if_20the_20a_20tls_20flag_20is_20not_20set_20on_20the_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20object_20and_20the_20server_20supports_20c_20starttls_20and_20a_20transport_20layer_20tls_20ssl_20connection_20was_20not_20already_20established_20then_20the_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20object_20will_20automatically_20execute_20a_20c_20starttls_20command_20after_20connecting_20so_20that_20the_20rest_20of_20the_20smtp_20session_20is_20performed_20securely_20this_20also_20allows_20transparent_20logins_20and_20communication_20with_20esmtp_20servers_20that_20require_20secure_20connections_20for_20the_20above_20reasons_20it_20s_20normally_20not_20required_20to_20use_20the_20c_20smtptls_20or_20c_20esmtptls_20protocols_20in_20the_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20rl_20argument_20anchor_20smtpclient_5fprotocols_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20takes_20a_20url_20argument_20the_20protocol_20scheme_20component_20is_20handled_20as_20in_20the_20following_20table_20b_20smtpcclient_20protocol_20handling_20b_20protocol_20default_20port_20description_20c_20smtp_2025_20standard_20smtp_20port_20without_20encryption_20esmpt_20and_20c_20starttls_20detection_20is_20supported_20automatically_20c_20smtps_20465_20note_20that_20port_20465_20is_20currently_20assigned_20to_20source_20specific_20multicast_20audio_20video_20a_20href_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20a_20its_20use_20as_20a_20port_20for_20secure_20smtp_20listeners_20where_20security_20is_20enforced_20at_20the_20transport_20layer_20because_20the_20server_20immediately_20negotiates_20a_20tls_20ssl_20connection_20before_20the_20application_20protocol_20communication_20starts_20is_20but_20is_20included_20in_20this_20module_20because_20many_20smtp_20servers_20still_20operate_20this_20way_20c_20smtptls_2025_20a_20c_20starttls_20command_20is_20executed_20unconditionally_20after_20the_20connection_20to_20ensure_20a_20secure_20connection_20even_20if_20the_20server_20does_20not_20declare_20support_20for_20this_20command_20in_20the_20login_20response_20it_20s_20normally_20not_20necessary_20to_20use_20this_20protocol_20as_20c_20starttls_20is_20used_20automatically_20when_20logging_20in_20to_20esmtp_20servers_20that_20declare_20support_20for_20this_20command_20in_20the_20response_20to_20the_20c_20ehlo_20command_20c_20esmtp_20587_20like_20c_20smtp_20just_20using_20port_20587_20c_20esmtps_20465_20like_20c_20smtps_20c_20esmtptls_20587_20like_20c_20smtptls_20just_20using_20port_20587_20par_20example_3a_20code_20py_20requires_20smtpclient_20requires_20mime_20message_20msg_20the_20sender_20sender_20email_20com_20my_20subject_20msg_20setbody_20body_20msg_20addto_20my_20best_20friend_20you_20friend_20com_20msg_20attach_20filename_20mime_3a_3amimetypetext_20data_20code_20log_20sub_20string_20str_20printf_20y_3a_20s_20n_20now_5fus_20str_20smtpclient_3a_3asmtpclient_20smtp_20esmtptls_3a_20user_20password_3asmtp_20example_20com_20log_20log_20smtp_20sendmessage_20msg_20endcode_20section_20smtpclient_5freferences_20smtpclient_20references_20based_20on_3a_20http_3a_20james_20apache_20org_20server_20rfclist_20smtp_20rfc0821_20txt_20http_3a_20tools_20ietf_20org_20html_20rfc821_3a_20initial_20smtp_20protocol_20spec_20http_3a_20tools_20ietf_20org_20html_20rfc1521_3a_20quoted_20printable_20base_2064_20transfer_20encodings_20http_3a_20tools_20ietf_20org_20html_20rfc2045_3a_20mime_20headers_20content_20types_20etc_20http_3a_20tools_20ietf_20org_20html_20rfc2047_3a_20q_20and_20b_20encoded_20words_20implemented_20by_20the_20mime_20module_20http_3a_20tools_20ietf_20org_20html_20rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_4',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['ref_20smtpclient_3a_3asmtpclient_20smtpclient_20class_20automatically_20detects_20if_20the_20smtp_20server_20supports_20esmtp_20and_20a_20c_20ehlo_20command_20is_20executed_20automatically_20instead_20of_20c_20helo_20if_20so_20additionally_20the_20class_20also_20automatically_20detects_20if_20the_20server_20supports_20the_20c_20starttls_20command_20by_20parsing_20the_20response_20to_20the_20c_20ehlo_20command_20when_20talking_20to_20esmtp_20servers_20if_20the_20a_20tls_20flag_20is_20not_20set_20on_20the_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20object_20and_20the_20server_20supports_20c_20starttls_20and_20a_20transport_20layer_20tls_20ssl_20connection_20was_20not_20already_20established_20then_20the_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20object_20will_20automatically_20execute_20a_20c_20starttls_20command_20after_20connecting_20so_20that_20the_20rest_20of_20the_20smtp_20session_20is_20performed_20securely_20this_20also_20allows_20transparent_20logins_20and_20communication_20with_20esmtp_20servers_20that_20require_20secure_20connections_20for_20the_20above_20reasons_20it_20s_20normally_20not_20required_20to_20use_20the_20c_20smtptls_20or_20c_20esmtptls_20protocols_20in_20the_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20rl_20argument_20anchor_20smtpclient_5fprotocols_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20takes_20a_20url_20argument_20the_20protocol_20scheme_20component_20is_20handled_20as_20in_20the_20following_20table_20b_20smtpcclient_20protocol_20handling_20b_20protocol_20default_20port_20description_20c_20smtp_2025_20standard_20smtp_20port_20without_20encryption_20esmpt_20and_20c_20starttls_20detection_20is_20supported_20automatically_20c_20smtps_20465_20note_20that_20port_20465_20is_20currently_20assigned_20to_20source_20specific_20multicast_20audio_20video_20a_20href_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20a_20its_20use_20as_20a_20port_20for_20secure_20smtp_20listeners_20where_20security_20is_20enforced_20at_20the_20transport_20layer_20because_20the_20server_20immediately_20negotiates_20a_20tls_20ssl_20connection_20before_20the_20application_20protocol_20communication_20starts_20is_20but_20is_20included_20in_20this_20module_20because_20many_20smtp_20servers_20still_20operate_20this_20way_20c_20smtptls_2025_20a_20c_20starttls_20command_20is_20executed_20unconditionally_20after_20the_20connection_20to_20ensure_20a_20secure_20connection_20even_20if_20the_20server_20does_20not_20declare_20support_20for_20this_20command_20in_20the_20login_20response_20it_20s_20normally_20not_20necessary_20to_20use_20this_20protocol_20as_20c_20starttls_20is_20used_20automatically_20when_20logging_20in_20to_20esmtp_20servers_20that_20declare_20support_20for_20this_20command_20in_20the_20response_20to_20the_20c_20ehlo_20command_20c_20esmtp_20587_20like_20c_20smtp_20just_20using_20port_20587_20c_20esmtps_20465_20like_20c_20smtps_20c_20esmtptls_20587_20like_20c_20smtptls_20just_20using_20port_20587_20par_20example_3a_20code_20py_20requires_20smtpclient_20requires_20mime_20message_20msg_20the_20sender_20sender_20email_20com_20my_20subject_20msg_20setbody_20body_20msg_20addto_20my_20best_20friend_20you_20friend_20com_20msg_20attach_20filename_20mime_3a_3amimetypetext_20data_20code_20log_20sub_20string_20str_20printf_20y_3a_20s_20n_20now_5fus_20str_20smtpclient_3a_3asmtpclient_20smtp_20esmtptls_3a_20user_20password_3asmtp_20example_20com_20log_20log_20smtp_20sendmessage_20msg_20endcode_20section_20smtpclient_5freferences_20smtpclient_20references_20based_20on_3a_20http_3a_20james_20apache_20org_20server_20rfclist_20smtp_20rfc0821_20txt_20http_3a_20tools_20ietf_20org_20html_20rfc821_3a_20initial_20smtp_20protocol_20spec_20http_3a_20tools_20ietf_20org_20html_20rfc1521_3a_20quoted_20printable_20base_2064_20transfer_20encodings_20http_3a_20tools_20ietf_20org_20html_20rfc2045_3a_20mime_20headers_20content_20types_20etc_20http_3a_20tools_20ietf_20org_20html_20rfc2047_3a_20q_20and_20b_20encoded_20words_20implemented_20by_20the_20mime_20module_20http_3a_20tools_20ietf_20org_20html_20rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_5',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['ref_20smtpclient_3a_3asmtpclient_20smtpclient_20object_20and_20the_20server_20supports_20c_20starttls_20and_20a_20transport_20layer_20tls_20ssl_20connection_20was_20not_20already_20established_20then_20the_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20object_20will_20automatically_20execute_20a_20c_20starttls_20command_20after_20connecting_20so_20that_20the_20rest_20of_20the_20smtp_20session_20is_20performed_20securely_20this_20also_20allows_20transparent_20logins_20and_20communication_20with_20esmtp_20servers_20that_20require_20secure_20connections_20for_20the_20above_20reasons_20it_20s_20normally_20not_20required_20to_20use_20the_20c_20smtptls_20or_20c_20esmtptls_20protocols_20in_20the_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20rl_20argument_20anchor_20smtpclient_5fprotocols_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20takes_20a_20url_20argument_20the_20protocol_20scheme_20component_20is_20handled_20as_20in_20the_20following_20table_20b_20smtpcclient_20protocol_20handling_20b_20protocol_20default_20port_20description_20c_20smtp_2025_20standard_20smtp_20port_20without_20encryption_20esmpt_20and_20c_20starttls_20detection_20is_20supported_20automatically_20c_20smtps_20465_20note_20that_20port_20465_20is_20currently_20assigned_20to_20source_20specific_20multicast_20audio_20video_20a_20href_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20a_20its_20use_20as_20a_20port_20for_20secure_20smtp_20listeners_20where_20security_20is_20enforced_20at_20the_20transport_20layer_20because_20the_20server_20immediately_20negotiates_20a_20tls_20ssl_20connection_20before_20the_20application_20protocol_20communication_20starts_20is_20but_20is_20included_20in_20this_20module_20because_20many_20smtp_20servers_20still_20operate_20this_20way_20c_20smtptls_2025_20a_20c_20starttls_20command_20is_20executed_20unconditionally_20after_20the_20connection_20to_20ensure_20a_20secure_20connection_20even_20if_20the_20server_20does_20not_20declare_20support_20for_20this_20command_20in_20the_20login_20response_20it_20s_20normally_20not_20necessary_20to_20use_20this_20protocol_20as_20c_20starttls_20is_20used_20automatically_20when_20logging_20in_20to_20esmtp_20servers_20that_20declare_20support_20for_20this_20command_20in_20the_20response_20to_20the_20c_20ehlo_20command_20c_20esmtp_20587_20like_20c_20smtp_20just_20using_20port_20587_20c_20esmtps_20465_20like_20c_20smtps_20c_20esmtptls_20587_20like_20c_20smtptls_20just_20using_20port_20587_20par_20example_3a_20code_20py_20requires_20smtpclient_20requires_20mime_20message_20msg_20the_20sender_20sender_20email_20com_20my_20subject_20msg_20setbody_20body_20msg_20addto_20my_20best_20friend_20you_20friend_20com_20msg_20attach_20filename_20mime_3a_3amimetypetext_20data_20code_20log_20sub_20string_20str_20printf_20y_3a_20s_20n_20now_5fus_20str_20smtpclient_3a_3asmtpclient_20smtp_20esmtptls_3a_20user_20password_3asmtp_20example_20com_20log_20log_20smtp_20sendmessage_20msg_20endcode_20section_20smtpclient_5freferences_20smtpclient_20references_20based_20on_3a_20http_3a_20james_20apache_20org_20server_20rfclist_20smtp_20rfc0821_20txt_20http_3a_20tools_20ietf_20org_20html_20rfc821_3a_20initial_20smtp_20protocol_20spec_20http_3a_20tools_20ietf_20org_20html_20rfc1521_3a_20quoted_20printable_20base_2064_20transfer_20encodings_20http_3a_20tools_20ietf_20org_20html_20rfc2045_3a_20mime_20headers_20content_20types_20etc_20http_3a_20tools_20ietf_20org_20html_20rfc2047_3a_20q_20and_20b_20encoded_20words_20implemented_20by_20the_20mime_20module_20http_3a_20tools_20ietf_20org_20html_20rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_6',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['ref_20smtpclient_3a_3asmtpclient_20smtpclient_20object_20mailmessage_3a_3aattachment_3a_20used_20to_20attach_20files_20to_20a_20mailmessage_3a_3amessage_20object_20note_20that_20the_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20class_20automatically_20detects_20if_20the_20smtp_20server_20supports_20esmtp_20and_20a_20c_20ehlo_20command_20is_20executed_20automatically_20instead_20of_20c_20helo_20if_20so_20additionally_20the_20class_20also_20automatically_20detects_20if_20the_20server_20supports_20the_20c_20starttls_20command_20by_20parsing_20the_20response_20to_20the_20c_20ehlo_20command_20when_20talking_20to_20esmtp_20servers_20if_20the_20a_20tls_20flag_20is_20not_20set_20on_20the_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20object_20and_20the_20server_20supports_20c_20starttls_20and_20a_20transport_20layer_20tls_20ssl_20connection_20was_20not_20already_20established_20then_20the_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20object_20will_20automatically_20execute_20a_20c_20starttls_20command_20after_20connecting_20so_20that_20the_20rest_20of_20the_20smtp_20session_20is_20performed_20securely_20this_20also_20allows_20transparent_20logins_20and_20communication_20with_20esmtp_20servers_20that_20require_20secure_20connections_20for_20the_20above_20reasons_20it_20s_20normally_20not_20required_20to_20use_20the_20c_20smtptls_20or_20c_20esmtptls_20protocols_20in_20the_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20rl_20argument_20anchor_20smtpclient_5fprotocols_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20takes_20a_20url_20argument_20the_20protocol_20scheme_20component_20is_20handled_20as_20in_20the_20following_20table_20b_20smtpcclient_20protocol_20handling_20b_20protocol_20default_20port_20description_20c_20smtp_2025_20standard_20smtp_20port_20without_20encryption_20esmpt_20and_20c_20starttls_20detection_20is_20supported_20automatically_20c_20smtps_20465_20note_20that_20port_20465_20is_20currently_20assigned_20to_20source_20specific_20multicast_20audio_20video_20a_20href_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20a_20its_20use_20as_20a_20port_20for_20secure_20smtp_20listeners_20where_20security_20is_20enforced_20at_20the_20transport_20layer_20because_20the_20server_20immediately_20negotiates_20a_20tls_20ssl_20connection_20before_20the_20application_20protocol_20communication_20starts_20is_20but_20is_20included_20in_20this_20module_20because_20many_20smtp_20servers_20still_20operate_20this_20way_20c_20smtptls_2025_20a_20c_20starttls_20command_20is_20executed_20unconditionally_20after_20the_20connection_20to_20ensure_20a_20secure_20connection_20even_20if_20the_20server_20does_20not_20declare_20support_20for_20this_20command_20in_20the_20login_20response_20it_20s_20normally_20not_20necessary_20to_20use_20this_20protocol_20as_20c_20starttls_20is_20used_20automatically_20when_20logging_20in_20to_20esmtp_20servers_20that_20declare_20support_20for_20this_20command_20in_20the_20response_20to_20the_20c_20ehlo_20command_20c_20esmtp_20587_20like_20c_20smtp_20just_20using_20port_20587_20c_20esmtps_20465_20like_20c_20smtps_20c_20esmtptls_20587_20like_20c_20smtptls_20just_20using_20port_20587_20par_20example_3a_20code_20py_20requires_20smtpclient_20requires_20mime_20message_20msg_20the_20sender_20sender_20email_20com_20my_20subject_20msg_20setbody_20body_20msg_20addto_20my_20best_20friend_20you_20friend_20com_20msg_20attach_20filename_20mime_3a_3amimetypetext_20data_20code_20log_20sub_20string_20str_20printf_20y_3a_20s_20n_20now_5fus_20str_20smtpclient_3a_3asmtpclient_20smtp_20esmtptls_3a_20user_20password_3asmtp_20example_20com_20log_20log_20smtp_20sendmessage_20msg_20endcode_20section_20smtpclient_5freferences_20smtpclient_20references_20based_20on_3a_20http_3a_20james_20apache_20org_20server_20rfclist_20smtp_20rfc0821_20txt_20http_3a_20tools_20ietf_20org_20html_20rfc821_3a_20initial_20smtp_20protocol_20spec_20http_3a_20tools_20ietf_20org_20html_20rfc1521_3a_20quoted_20printable_20base_2064_20transfer_20encodings_20http_3a_20tools_20ietf_20org_20html_20rfc2045_3a_20mime_20headers_20content_20types_20etc_20http_3a_20tools_20ietf_20org_20html_20rfc2047_3a_20q_20and_20b_20encoded_20words_20implemented_20by_20the_20mime_20module_20http_3a_20tools_20ietf_20org_20html_20rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_7',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['ref_20smtpclient_3a_3asmtpclient_20smtpclient_20object_20will_20automatically_20execute_20a_20c_20starttls_20command_20after_20connecting_20so_20that_20the_20rest_20of_20the_20smtp_20session_20is_20performed_20securely_20this_20also_20allows_20transparent_20logins_20and_20communication_20with_20esmtp_20servers_20that_20require_20secure_20connections_20for_20the_20above_20reasons_20it_20s_20normally_20not_20required_20to_20use_20the_20c_20smtptls_20or_20c_20esmtptls_20protocols_20in_20the_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20rl_20argument_20anchor_20smtpclient_5fprotocols_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20takes_20a_20url_20argument_20the_20protocol_20scheme_20component_20is_20handled_20as_20in_20the_20following_20table_20b_20smtpcclient_20protocol_20handling_20b_20protocol_20default_20port_20description_20c_20smtp_2025_20standard_20smtp_20port_20without_20encryption_20esmpt_20and_20c_20starttls_20detection_20is_20supported_20automatically_20c_20smtps_20465_20note_20that_20port_20465_20is_20currently_20assigned_20to_20source_20specific_20multicast_20audio_20video_20a_20href_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20a_20its_20use_20as_20a_20port_20for_20secure_20smtp_20listeners_20where_20security_20is_20enforced_20at_20the_20transport_20layer_20because_20the_20server_20immediately_20negotiates_20a_20tls_20ssl_20connection_20before_20the_20application_20protocol_20communication_20starts_20is_20but_20is_20included_20in_20this_20module_20because_20many_20smtp_20servers_20still_20operate_20this_20way_20c_20smtptls_2025_20a_20c_20starttls_20command_20is_20executed_20unconditionally_20after_20the_20connection_20to_20ensure_20a_20secure_20connection_20even_20if_20the_20server_20does_20not_20declare_20support_20for_20this_20command_20in_20the_20login_20response_20it_20s_20normally_20not_20necessary_20to_20use_20this_20protocol_20as_20c_20starttls_20is_20used_20automatically_20when_20logging_20in_20to_20esmtp_20servers_20that_20declare_20support_20for_20this_20command_20in_20the_20response_20to_20the_20c_20ehlo_20command_20c_20esmtp_20587_20like_20c_20smtp_20just_20using_20port_20587_20c_20esmtps_20465_20like_20c_20smtps_20c_20esmtptls_20587_20like_20c_20smtptls_20just_20using_20port_20587_20par_20example_3a_20code_20py_20requires_20smtpclient_20requires_20mime_20message_20msg_20the_20sender_20sender_20email_20com_20my_20subject_20msg_20setbody_20body_20msg_20addto_20my_20best_20friend_20you_20friend_20com_20msg_20attach_20filename_20mime_3a_3amimetypetext_20data_20code_20log_20sub_20string_20str_20printf_20y_3a_20s_20n_20now_5fus_20str_20smtpclient_3a_3asmtpclient_20smtp_20esmtptls_3a_20user_20password_3asmtp_20example_20com_20log_20log_20smtp_20sendmessage_20msg_20endcode_20section_20smtpclient_5freferences_20smtpclient_20references_20based_20on_3a_20http_3a_20james_20apache_20org_20server_20rfclist_20smtp_20rfc0821_20txt_20http_3a_20tools_20ietf_20org_20html_20rfc821_3a_20initial_20smtp_20protocol_20spec_20http_3a_20tools_20ietf_20org_20html_20rfc1521_3a_20quoted_20printable_20base_2064_20transfer_20encodings_20http_3a_20tools_20ietf_20org_20html_20rfc2045_3a_20mime_20headers_20content_20types_20etc_20http_3a_20tools_20ietf_20org_20html_20rfc2047_3a_20q_20and_20b_20encoded_20words_20implemented_20by_20the_20mime_20module_20http_3a_20tools_20ietf_20org_20html_20rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_8',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20rl_20argument_20anchor_20smtpclient_5fprotocols_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20takes_20a_20url_20argument_20the_20protocol_20scheme_20component_20is_20handled_20as_20in_20the_20following_20table_20b_20smtpcclient_20protocol_20handling_20b_20protocol_20default_20port_20description_20c_20smtp_2025_20standard_20smtp_20port_20without_20encryption_20esmpt_20and_20c_20starttls_20detection_20is_20supported_20automatically_20c_20smtps_20465_20note_20that_20port_20465_20is_20currently_20assigned_20to_20source_20specific_20multicast_20audio_20video_20a_20href_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20a_20its_20use_20as_20a_20port_20for_20secure_20smtp_20listeners_20where_20security_20is_20enforced_20at_20the_20transport_20layer_20because_20the_20server_20immediately_20negotiates_20a_20tls_20ssl_20connection_20before_20the_20application_20protocol_20communication_20starts_20is_20but_20is_20included_20in_20this_20module_20because_20many_20smtp_20servers_20still_20operate_20this_20way_20c_20smtptls_2025_20a_20c_20starttls_20command_20is_20executed_20unconditionally_20after_20the_20connection_20to_20ensure_20a_20secure_20connection_20even_20if_20the_20server_20does_20not_20declare_20support_20for_20this_20command_20in_20the_20login_20response_20it_20s_20normally_20not_20necessary_20to_20use_20this_20protocol_20as_20c_20starttls_20is_20used_20automatically_20when_20logging_20in_20to_20esmtp_20servers_20that_20declare_20support_20for_20this_20command_20in_20the_20response_20to_20the_20c_20ehlo_20command_20c_20esmtp_20587_20like_20c_20smtp_20just_20using_20port_20587_20c_20esmtps_20465_20like_20c_20smtps_20c_20esmtptls_20587_20like_20c_20smtptls_20just_20using_20port_20587_20par_20example_3a_20code_20py_20requires_20smtpclient_20requires_20mime_20message_20msg_20the_20sender_20sender_20email_20com_20my_20subject_20msg_20setbody_20body_20msg_20addto_20my_20best_20friend_20you_20friend_20com_20msg_20attach_20filename_20mime_3a_3amimetypetext_20data_20code_20log_20sub_20string_20str_20printf_20y_3a_20s_20n_20now_5fus_20str_20smtpclient_3a_3asmtpclient_20smtp_20esmtptls_3a_20user_20password_3asmtp_20example_20com_20log_20log_20smtp_20sendmessage_20msg_20endcode_20section_20smtpclient_5freferences_20smtpclient_20references_20based_20on_3a_20http_3a_20james_20apache_20org_20server_20rfclist_20smtp_20rfc0821_20txt_20http_3a_20tools_20ietf_20org_20html_20rfc821_3a_20initial_20smtp_20protocol_20spec_20http_3a_20tools_20ietf_20org_20html_20rfc1521_3a_20quoted_20printable_20base_2064_20transfer_20encodings_20http_3a_20tools_20ietf_20org_20html_20rfc2045_3a_20mime_20headers_20content_20types_20etc_20http_3a_20tools_20ietf_20org_20html_20rfc2047_3a_20q_20and_20b_20encoded_20words_20implemented_20by_20the_20mime_20module_20http_3a_20tools_20ietf_20org_20html_20rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_9',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20takes_20a_20url_20argument_20the_20protocol_20scheme_20component_20is_20handled_20as_20in_20the_20following_20table_20b_20smtpcclient_20protocol_20handling_20b_20protocol_20default_20port_20description_20c_20smtp_2025_20standard_20smtp_20port_20without_20encryption_20esmpt_20and_20c_20starttls_20detection_20is_20supported_20automatically_20c_20smtps_20465_20note_20that_20port_20465_20is_20currently_20assigned_20to_20source_20specific_20multicast_20audio_20video_20a_20href_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20a_20its_20use_20as_20a_20port_20for_20secure_20smtp_20listeners_20where_20security_20is_20enforced_20at_20the_20transport_20layer_20because_20the_20server_20immediately_20negotiates_20a_20tls_20ssl_20connection_20before_20the_20application_20protocol_20communication_20starts_20is_20but_20is_20included_20in_20this_20module_20because_20many_20smtp_20servers_20still_20operate_20this_20way_20c_20smtptls_2025_20a_20c_20starttls_20command_20is_20executed_20unconditionally_20after_20the_20connection_20to_20ensure_20a_20secure_20connection_20even_20if_20the_20server_20does_20not_20declare_20support_20for_20this_20command_20in_20the_20login_20response_20it_20s_20normally_20not_20necessary_20to_20use_20this_20protocol_20as_20c_20starttls_20is_20used_20automatically_20when_20logging_20in_20to_20esmtp_20servers_20that_20declare_20support_20for_20this_20command_20in_20the_20response_20to_20the_20c_20ehlo_20command_20c_20esmtp_20587_20like_20c_20smtp_20just_20using_20port_20587_20c_20esmtps_20465_20like_20c_20smtps_20c_20esmtptls_20587_20like_20c_20smtptls_20just_20using_20port_20587_20par_20example_3a_20code_20py_20requires_20smtpclient_20requires_20mime_20message_20msg_20the_20sender_20sender_20email_20com_20my_20subject_20msg_20setbody_20body_20msg_20addto_20my_20best_20friend_20you_20friend_20com_20msg_20attach_20filename_20mime_3a_3amimetypetext_20data_20code_20log_20sub_20string_20str_20printf_20y_3a_20s_20n_20now_5fus_20str_20smtpclient_3a_3asmtpclient_20smtp_20esmtptls_3a_20user_20password_3asmtp_20example_20com_20log_20log_20smtp_20sendmessage_20msg_20endcode_20section_20smtpclient_5freferences_20smtpclient_20references_20based_20on_3a_20http_3a_20james_20apache_20org_20server_20rfclist_20smtp_20rfc0821_20txt_20http_3a_20tools_20ietf_20org_20html_20rfc821_3a_20initial_20smtp_20protocol_20spec_20http_3a_20tools_20ietf_20org_20html_20rfc1521_3a_20quoted_20printable_20base_2064_20transfer_20encodings_20http_3a_20tools_20ietf_20org_20html_20rfc2045_3a_20mime_20headers_20content_20types_20etc_20http_3a_20tools_20ietf_20org_20html_20rfc2047_3a_20q_20and_20b_20encoded_20words_20implemented_20by_20the_20mime_20module_20http_3a_20tools_20ietf_20org_20html_20rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_10',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20_3a_20provides_20a_20connection_20object_20to_20an_20smtp_20server_20based_20on_20the_20ref_20connectionproviderintro_20connectionprovider_20module_20the_20following_20supporting_20classes_20are_20provided_20by_20the_20mailmessage_20module_3a_20mailmessage_3a_3amessage_3a_20wraps_20a_20message_20to_20be_20sent_20via_20an_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20object_20mailmessage_3a_3aattachment_3a_20used_20to_20attach_20files_20to_20a_20mailmessage_3a_3amessage_20object_20note_20that_20the_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20class_20automatically_20detects_20if_20the_20smtp_20server_20supports_20esmtp_20and_20a_20c_20ehlo_20command_20is_20executed_20automatically_20instead_20of_20c_20helo_20if_20so_20additionally_20the_20class_20also_20automatically_20detects_20if_20the_20server_20supports_20the_20c_20starttls_20command_20by_20parsing_20the_20response_20to_20the_20c_20ehlo_20command_20when_20talking_20to_20esmtp_20servers_20if_20the_20a_20tls_20flag_20is_20not_20set_20on_20the_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20object_20and_20the_20server_20supports_20c_20starttls_20and_20a_20transport_20layer_20tls_20ssl_20connection_20was_20not_20already_20established_20then_20the_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20object_20will_20automatically_20execute_20a_20c_20starttls_20command_20after_20connecting_20so_20that_20the_20rest_20of_20the_20smtp_20session_20is_20performed_20securely_20this_20also_20allows_20transparent_20logins_20and_20communication_20with_20esmtp_20servers_20that_20require_20secure_20connections_20for_20the_20above_20reasons_20it_20s_20normally_20not_20required_20to_20use_20the_20c_20smtptls_20or_20c_20esmtptls_20protocols_20in_20the_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20rl_20argument_20anchor_20smtpclient_5fprotocols_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20takes_20a_20url_20argument_20the_20protocol_20scheme_20component_20is_20handled_20as_20in_20the_20following_20table_20b_20smtpcclient_20protocol_20handling_20b_20protocol_20default_20port_20description_20c_20smtp_2025_20standard_20smtp_20port_20without_20encryption_20esmpt_20and_20c_20starttls_20detection_20is_20supported_20automatically_20c_20smtps_20465_20note_20that_20port_20465_20is_20currently_20assigned_20to_20source_20specific_20multicast_20audio_20video_20a_20href_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20a_20its_20use_20as_20a_20port_20for_20secure_20smtp_20listeners_20where_20security_20is_20enforced_20at_20the_20transport_20layer_20because_20the_20server_20immediately_20negotiates_20a_20tls_20ssl_20connection_20before_20the_20application_20protocol_20communication_20starts_20is_20but_20is_20included_20in_20this_20module_20because_20many_20smtp_20servers_20still_20operate_20this_20way_20c_20smtptls_2025_20a_20c_20starttls_20command_20is_20executed_20unconditionally_20after_20the_20connection_20to_20ensure_20a_20secure_20connection_20even_20if_20the_20server_20does_20not_20declare_20support_20for_20this_20command_20in_20the_20login_20response_20it_20s_20normally_20not_20necessary_20to_20use_20this_20protocol_20as_20c_20starttls_20is_20used_20automatically_20when_20logging_20in_20to_20esmtp_20servers_20that_20declare_20support_20for_20this_20command_20in_20the_20response_20to_20the_20c_20ehlo_20command_20c_20esmtp_20587_20like_20c_20smtp_20just_20using_20port_20587_20c_20esmtps_20465_20like_20c_20smtps_20c_20esmtptls_20587_20like_20c_20smtptls_20just_20using_20port_20587_20par_20example_3a_20code_20py_20requires_20smtpclient_20requires_20mime_20message_20msg_20the_20sender_20sender_20email_20com_20my_20subject_20msg_20setbody_20body_20msg_20addto_20my_20best_20friend_20you_20friend_20com_20msg_20attach_20filename_20mime_3a_3amimetypetext_20data_20code_20log_20sub_20string_20str_20printf_20y_3a_20s_20n_20now_5fus_20str_20smtpclient_3a_3asmtpclient_20smtp_20esmtptls_3a_20user_20password_3asmtp_20example_20com_20log_20log_20smtp_20sendmessage_20msg_20endcode_20section_20smtpclient_5freferences_20smtpclient_20references_20based_20on_3a_20http_3a_20james_20apache_20org_20server_20rfclist_20smtp_20rfc0821_20txt_20http_3a_20tools_20ietf_20org_20html_20rfc821_3a_20initial_20smtp_20protocol_20spec_20http_3a_20tools_20ietf_20org_20html_20rfc1521_3a_20quoted_20printable_20base_2064_20transfer_20encodings_20http_3a_20tools_20ietf_20org_20html_20rfc2045_3a_20mime_20headers_20content_20types_20etc_20http_3a_20tools_20ietf_20org_20html_20rfc2047_3a_20q_20and_20b_20encoded_20words_20implemented_20by_20the_20mime_20module_20http_3a_20tools_20ietf_20org_20html_20rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_11',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_12',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['references_13',['References',['../../../../lang/html/lvalue_references.html',1,'index']]],
  ['references_20based_20on_3a_20http_3a_20james_20apache_20org_20server_20rfclist_20smtp_20rfc0821_20txt_20http_3a_20tools_20ietf_20org_20html_20rfc821_3a_20initial_20smtp_20protocol_20spec_20http_3a_20tools_20ietf_20org_20html_20rfc1521_3a_20quoted_20printable_20base_2064_20transfer_20encodings_20http_3a_20tools_20ietf_20org_20html_20rfc2045_3a_20mime_20headers_20content_20types_20etc_20http_3a_20tools_20ietf_20org_20html_20rfc2047_3a_20q_20and_20b_20encoded_20words_20implemented_20by_20the_20mime_20module_20http_3a_20tools_20ietf_20org_20html_20rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_14',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['regular_20expressions_15',['Regular Expressions',['../../../../lang/html/qore_regex.html',1,'index']]],
  ['release_20notes_16',['Release Notes',['../../../../lang/html/release_notes.html',1,'index']]],
  ['release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_17',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_18',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_19',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_20',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['require_20secure_20connections_20for_20the_20above_20reasons_20it_20s_20normally_20not_20required_20to_20use_20the_20c_20smtptls_20or_20c_20esmtptls_20protocols_20in_20the_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20rl_20argument_20anchor_20smtpclient_5fprotocols_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20takes_20a_20url_20argument_20the_20protocol_20scheme_20component_20is_20handled_20as_20in_20the_20following_20table_20b_20smtpcclient_20protocol_20handling_20b_20protocol_20default_20port_20description_20c_20smtp_2025_20standard_20smtp_20port_20without_20encryption_20esmpt_20and_20c_20starttls_20detection_20is_20supported_20automatically_20c_20smtps_20465_20note_20that_20port_20465_20is_20currently_20assigned_20to_20source_20specific_20multicast_20audio_20video_20a_20href_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20a_20its_20use_20as_20a_20port_20for_20secure_20smtp_20listeners_20where_20security_20is_20enforced_20at_20the_20transport_20layer_20because_20the_20server_20immediately_20negotiates_20a_20tls_20ssl_20connection_20before_20the_20application_20protocol_20communication_20starts_20is_20but_20is_20included_20in_20this_20module_20because_20many_20smtp_20servers_20still_20operate_20this_20way_20c_20smtptls_2025_20a_20c_20starttls_20command_20is_20executed_20unconditionally_20after_20the_20connection_20to_20ensure_20a_20secure_20connection_20even_20if_20the_20server_20does_20not_20declare_20support_20for_20this_20command_20in_20the_20login_20response_20it_20s_20normally_20not_20necessary_20to_20use_20this_20protocol_20as_20c_20starttls_20is_20used_20automatically_20when_20logging_20in_20to_20esmtp_20servers_20that_20declare_20support_20for_20this_20command_20in_20the_20response_20to_20the_20c_20ehlo_20command_20c_20esmtp_20587_20like_20c_20smtp_20just_20using_20port_20587_20c_20esmtps_20465_20like_20c_20smtps_20c_20esmtptls_20587_20like_20c_20smtptls_20just_20using_20port_20587_20par_20example_3a_20code_20py_20requires_20smtpclient_20requires_20mime_20message_20msg_20the_20sender_20sender_20email_20com_20my_20subject_20msg_20setbody_20body_20msg_20addto_20my_20best_20friend_20you_20friend_20com_20msg_20attach_20filename_20mime_3a_3amimetypetext_20data_20code_20log_20sub_20string_20str_20printf_20y_3a_20s_20n_20now_5fus_20str_20smtpclient_3a_3asmtpclient_20smtp_20esmtptls_3a_20user_20password_3asmtp_20example_20com_20log_20log_20smtp_20sendmessage_20msg_20endcode_20section_20smtpclient_5freferences_20smtpclient_20references_20based_20on_3a_20http_3a_20james_20apache_20org_20server_20rfclist_20smtp_20rfc0821_20txt_20http_3a_20tools_20ietf_20org_20html_20rfc821_3a_20initial_20smtp_20protocol_20spec_20http_3a_20tools_20ietf_20org_20html_20rfc1521_3a_20quoted_20printable_20base_2064_20transfer_20encodings_20http_3a_20tools_20ietf_20org_20html_20rfc2045_3a_20mime_20headers_20content_20types_20etc_20http_3a_20tools_20ietf_20org_20html_20rfc2047_3a_20q_20and_20b_20encoded_20words_20implemented_20by_20the_20mime_20module_20http_3a_20tools_20ietf_20org_20html_20rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_21',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['required_20to_20use_20the_20c_20smtptls_20or_20c_20esmtptls_20protocols_20in_20the_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20rl_20argument_20anchor_20smtpclient_5fprotocols_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20takes_20a_20url_20argument_20the_20protocol_20scheme_20component_20is_20handled_20as_20in_20the_20following_20table_20b_20smtpcclient_20protocol_20handling_20b_20protocol_20default_20port_20description_20c_20smtp_2025_20standard_20smtp_20port_20without_20encryption_20esmpt_20and_20c_20starttls_20detection_20is_20supported_20automatically_20c_20smtps_20465_20note_20that_20port_20465_20is_20currently_20assigned_20to_20source_20specific_20multicast_20audio_20video_20a_20href_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20a_20its_20use_20as_20a_20port_20for_20secure_20smtp_20listeners_20where_20security_20is_20enforced_20at_20the_20transport_20layer_20because_20the_20server_20immediately_20negotiates_20a_20tls_20ssl_20connection_20before_20the_20application_20protocol_20communication_20starts_20is_20but_20is_20included_20in_20this_20module_20because_20many_20smtp_20servers_20still_20operate_20this_20way_20c_20smtptls_2025_20a_20c_20starttls_20command_20is_20executed_20unconditionally_20after_20the_20connection_20to_20ensure_20a_20secure_20connection_20even_20if_20the_20server_20does_20not_20declare_20support_20for_20this_20command_20in_20the_20login_20response_20it_20s_20normally_20not_20necessary_20to_20use_20this_20protocol_20as_20c_20starttls_20is_20used_20automatically_20when_20logging_20in_20to_20esmtp_20servers_20that_20declare_20support_20for_20this_20command_20in_20the_20response_20to_20the_20c_20ehlo_20command_20c_20esmtp_20587_20like_20c_20smtp_20just_20using_20port_20587_20c_20esmtps_20465_20like_20c_20smtps_20c_20esmtptls_20587_20like_20c_20smtptls_20just_20using_20port_20587_20par_20example_3a_20code_20py_20requires_20smtpclient_20requires_20mime_20message_20msg_20the_20sender_20sender_20email_20com_20my_20subject_20msg_20setbody_20body_20msg_20addto_20my_20best_20friend_20you_20friend_20com_20msg_20attach_20filename_20mime_3a_3amimetypetext_20data_20code_20log_20sub_20string_20str_20printf_20y_3a_20s_20n_20now_5fus_20str_20smtpclient_3a_3asmtpclient_20smtp_20esmtptls_3a_20user_20password_3asmtp_20example_20com_20log_20log_20smtp_20sendmessage_20msg_20endcode_20section_20smtpclient_5freferences_20smtpclient_20references_20based_20on_3a_20http_3a_20james_20apache_20org_20server_20rfclist_20smtp_20rfc0821_20txt_20http_3a_20tools_20ietf_20org_20html_20rfc821_3a_20initial_20smtp_20protocol_20spec_20http_3a_20tools_20ietf_20org_20html_20rfc1521_3a_20quoted_20printable_20base_2064_20transfer_20encodings_20http_3a_20tools_20ietf_20org_20html_20rfc2045_3a_20mime_20headers_20content_20types_20etc_20http_3a_20tools_20ietf_20org_20html_20rfc2047_3a_20q_20and_20b_20encoded_20words_20implemented_20by_20the_20mime_20module_20http_3a_20tools_20ietf_20org_20html_20rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_22',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['requires_20mime_20message_20msg_20the_20sender_20sender_20email_20com_20my_20subject_20msg_20setbody_20body_20msg_20addto_20my_20best_20friend_20you_20friend_20com_20msg_20attach_20filename_20mime_3a_3amimetypetext_20data_20code_20log_20sub_20string_20str_20printf_20y_3a_20s_20n_20now_5fus_20str_20smtpclient_3a_3asmtpclient_20smtp_20esmtptls_3a_20user_20password_3asmtp_20example_20com_20log_20log_20smtp_20sendmessage_20msg_20endcode_20section_20smtpclient_5freferences_20smtpclient_20references_20based_20on_3a_20http_3a_20james_20apache_20org_20server_20rfclist_20smtp_20rfc0821_20txt_20http_3a_20tools_20ietf_20org_20html_20rfc821_3a_20initial_20smtp_20protocol_20spec_20http_3a_20tools_20ietf_20org_20html_20rfc1521_3a_20quoted_20printable_20base_2064_20transfer_20encodings_20http_3a_20tools_20ietf_20org_20html_20rfc2045_3a_20mime_20headers_20content_20types_20etc_20http_3a_20tools_20ietf_20org_20html_20rfc2047_3a_20q_20and_20b_20encoded_20words_20implemented_20by_20the_20mime_20module_20http_3a_20tools_20ietf_20org_20html_20rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_23',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['requires_20smtpclient_20in_20your_20code_20see_20examples_20email_20q_20for_20an_20example_20program_20using_20this_20module_20all_20the_20symbols_20in_20the_20module_20are_20defined_20in_20the_20smtpclient_20namespace_20classes_20provided_3a_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20_3a_20manages_20a_20connection_20to_20an_20smtp_20server_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20_3a_20provides_20a_20connection_20object_20to_20an_20smtp_20server_20based_20on_20the_20ref_20connectionproviderintro_20connectionprovider_20module_20the_20following_20supporting_20classes_20are_20provided_20by_20the_20mailmessage_20module_3a_20mailmessage_3a_3amessage_3a_20wraps_20a_20message_20to_20be_20sent_20via_20an_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20object_20mailmessage_3a_3aattachment_3a_20used_20to_20attach_20files_20to_20a_20mailmessage_3a_3amessage_20object_20note_20that_20the_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20class_20automatically_20detects_20if_20the_20smtp_20server_20supports_20esmtp_20and_20a_20c_20ehlo_20command_20is_20executed_20automatically_20instead_20of_20c_20helo_20if_20so_20additionally_20the_20class_20also_20automatically_20detects_20if_20the_20server_20supports_20the_20c_20starttls_20command_20by_20parsing_20the_20response_20to_20the_20c_20ehlo_20command_20when_20talking_20to_20esmtp_20servers_20if_20the_20a_20tls_20flag_20is_20not_20set_20on_20the_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20object_20and_20the_20server_20supports_20c_20starttls_20and_20a_20transport_20layer_20tls_20ssl_20connection_20was_20not_20already_20established_20then_20the_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20object_20will_20automatically_20execute_20a_20c_20starttls_20command_20after_20connecting_20so_20that_20the_20rest_20of_20the_20smtp_20session_20is_20performed_20securely_20this_20also_20allows_20transparent_20logins_20and_20communication_20with_20esmtp_20servers_20that_20require_20secure_20connections_20for_20the_20above_20reasons_20it_20s_20normally_20not_20required_20to_20use_20the_20c_20smtptls_20or_20c_20esmtptls_20protocols_20in_20the_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20rl_20argument_20anchor_20smtpclient_5fprotocols_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20takes_20a_20url_20argument_20the_20protocol_20scheme_20component_20is_20handled_20as_20in_20the_20following_20table_20b_20smtpcclient_20protocol_20handling_20b_20protocol_20default_20port_20description_20c_20smtp_2025_20standard_20smtp_20port_20without_20encryption_20esmpt_20and_20c_20starttls_20detection_20is_20supported_20automatically_20c_20smtps_20465_20note_20that_20port_20465_20is_20currently_20assigned_20to_20source_20specific_20multicast_20audio_20video_20a_20href_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20a_20its_20use_20as_20a_20port_20for_20secure_20smtp_20listeners_20where_20security_20is_20enforced_20at_20the_20transport_20layer_20because_20the_20server_20immediately_20negotiates_20a_20tls_20ssl_20connection_20before_20the_20application_20protocol_20communication_20starts_20is_20but_20is_20included_20in_20this_20module_20because_20many_20smtp_20servers_20still_20operate_20this_20way_20c_20smtptls_2025_20a_20c_20starttls_20command_20is_20executed_20unconditionally_20after_20the_20connection_20to_20ensure_20a_20secure_20connection_20even_20if_20the_20server_20does_20not_20declare_20support_20for_20this_20command_20in_20the_20login_20response_20it_20s_20normally_20not_20necessary_20to_20use_20this_20protocol_20as_20c_20starttls_20is_20used_20automatically_20when_20logging_20in_20to_20esmtp_20servers_20that_20declare_20support_20for_20this_20command_20in_20the_20response_20to_20the_20c_20ehlo_20command_20c_20esmtp_20587_20like_20c_20smtp_20just_20using_20port_20587_20c_20esmtps_20465_20like_20c_20smtps_20c_20esmtptls_20587_20like_20c_20smtptls_20just_20using_20port_20587_20par_20example_3a_20code_20py_20requires_20smtpclient_20requires_20mime_20message_20msg_20the_20sender_20sender_20email_20com_20my_20subject_20msg_20setbody_20body_20msg_20addto_20my_20best_20friend_20you_20friend_20com_20msg_20attach_20filename_20mime_3a_3amimetypetext_20data_20code_20log_20sub_20string_20str_20printf_20y_3a_20s_20n_20now_5fus_20str_20smtpclient_3a_3asmtpclient_20smtp_20esmtptls_3a_20user_20password_3asmtp_20example_20com_20log_20log_20smtp_20sendmessage_20msg_20endcode_20section_20smtpclient_5freferences_20smtpclient_20references_20based_20on_3a_20http_3a_20james_20apache_20org_20server_20rfclist_20smtp_20rfc0821_20txt_20http_3a_20tools_20ietf_20org_20html_20rfc821_3a_20initial_20smtp_20protocol_20spec_20http_3a_20tools_20ietf_20org_20html_20rfc1521_3a_20quoted_20printable_20base_2064_20transfer_20encodings_20http_3a_20tools_20ietf_20org_20html_20rfc2045_3a_20mime_20headers_20content_20types_20etc_20http_3a_20tools_20ietf_20org_20html_20rfc2047_3a_20q_20and_20b_20encoded_20words_20implemented_20by_20the_20mime_20module_20http_3a_20tools_20ietf_20org_20html_20rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_24',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['requires_20smtpclient_20requires_20mime_20message_20msg_20the_20sender_20sender_20email_20com_20my_20subject_20msg_20setbody_20body_20msg_20addto_20my_20best_20friend_20you_20friend_20com_20msg_20attach_20filename_20mime_3a_3amimetypetext_20data_20code_20log_20sub_20string_20str_20printf_20y_3a_20s_20n_20now_5fus_20str_20smtpclient_3a_3asmtpclient_20smtp_20esmtptls_3a_20user_20password_3asmtp_20example_20com_20log_20log_20smtp_20sendmessage_20msg_20endcode_20section_20smtpclient_5freferences_20smtpclient_20references_20based_20on_3a_20http_3a_20james_20apache_20org_20server_20rfclist_20smtp_20rfc0821_20txt_20http_3a_20tools_20ietf_20org_20html_20rfc821_3a_20initial_20smtp_20protocol_20spec_20http_3a_20tools_20ietf_20org_20html_20rfc1521_3a_20quoted_20printable_20base_2064_20transfer_20encodings_20http_3a_20tools_20ietf_20org_20html_20rfc2045_3a_20mime_20headers_20content_20types_20etc_20http_3a_20tools_20ietf_20org_20html_20rfc2047_3a_20q_20and_20b_20encoded_20words_20implemented_20by_20the_20mime_20module_20http_3a_20tools_20ietf_20org_20html_20rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_25',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['response_20it_20s_20normally_20not_20necessary_20to_20use_20this_20protocol_20as_20c_20starttls_20is_20used_20automatically_20when_20logging_20in_20to_20esmtp_20servers_20that_20declare_20support_20for_20this_20command_20in_20the_20response_20to_20the_20c_20ehlo_20command_20c_20esmtp_20587_20like_20c_20smtp_20just_20using_20port_20587_20c_20esmtps_20465_20like_20c_20smtps_20c_20esmtptls_20587_20like_20c_20smtptls_20just_20using_20port_20587_20par_20example_3a_20code_20py_20requires_20smtpclient_20requires_20mime_20message_20msg_20the_20sender_20sender_20email_20com_20my_20subject_20msg_20setbody_20body_20msg_20addto_20my_20best_20friend_20you_20friend_20com_20msg_20attach_20filename_20mime_3a_3amimetypetext_20data_20code_20log_20sub_20string_20str_20printf_20y_3a_20s_20n_20now_5fus_20str_20smtpclient_3a_3asmtpclient_20smtp_20esmtptls_3a_20user_20password_3asmtp_20example_20com_20log_20log_20smtp_20sendmessage_20msg_20endcode_20section_20smtpclient_5freferences_20smtpclient_20references_20based_20on_3a_20http_3a_20james_20apache_20org_20server_20rfclist_20smtp_20rfc0821_20txt_20http_3a_20tools_20ietf_20org_20html_20rfc821_3a_20initial_20smtp_20protocol_20spec_20http_3a_20tools_20ietf_20org_20html_20rfc1521_3a_20quoted_20printable_20base_2064_20transfer_20encodings_20http_3a_20tools_20ietf_20org_20html_20rfc2045_3a_20mime_20headers_20content_20types_20etc_20http_3a_20tools_20ietf_20org_20html_20rfc2047_3a_20q_20and_20b_20encoded_20words_20implemented_20by_20the_20mime_20module_20http_3a_20tools_20ietf_20org_20html_20rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_26',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['response_20to_20the_20c_20ehlo_20command_20c_20esmtp_20587_20like_20c_20smtp_20just_20using_20port_20587_20c_20esmtps_20465_20like_20c_20smtps_20c_20esmtptls_20587_20like_20c_20smtptls_20just_20using_20port_20587_20par_20example_3a_20code_20py_20requires_20smtpclient_20requires_20mime_20message_20msg_20the_20sender_20sender_20email_20com_20my_20subject_20msg_20setbody_20body_20msg_20addto_20my_20best_20friend_20you_20friend_20com_20msg_20attach_20filename_20mime_3a_3amimetypetext_20data_20code_20log_20sub_20string_20str_20printf_20y_3a_20s_20n_20now_5fus_20str_20smtpclient_3a_3asmtpclient_20smtp_20esmtptls_3a_20user_20password_3asmtp_20example_20com_20log_20log_20smtp_20sendmessage_20msg_20endcode_20section_20smtpclient_5freferences_20smtpclient_20references_20based_20on_3a_20http_3a_20james_20apache_20org_20server_20rfclist_20smtp_20rfc0821_20txt_20http_3a_20tools_20ietf_20org_20html_20rfc821_3a_20initial_20smtp_20protocol_20spec_20http_3a_20tools_20ietf_20org_20html_20rfc1521_3a_20quoted_20printable_20base_2064_20transfer_20encodings_20http_3a_20tools_20ietf_20org_20html_20rfc2045_3a_20mime_20headers_20content_20types_20etc_20http_3a_20tools_20ietf_20org_20html_20rfc2047_3a_20q_20and_20b_20encoded_20words_20implemented_20by_20the_20mime_20module_20http_3a_20tools_20ietf_20org_20html_20rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_27',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['response_20to_20the_20c_20ehlo_20command_20when_20talking_20to_20esmtp_20servers_20if_20the_20a_20tls_20flag_20is_20not_20set_20on_20the_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20object_20and_20the_20server_20supports_20c_20starttls_20and_20a_20transport_20layer_20tls_20ssl_20connection_20was_20not_20already_20established_20then_20the_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20object_20will_20automatically_20execute_20a_20c_20starttls_20command_20after_20connecting_20so_20that_20the_20rest_20of_20the_20smtp_20session_20is_20performed_20securely_20this_20also_20allows_20transparent_20logins_20and_20communication_20with_20esmtp_20servers_20that_20require_20secure_20connections_20for_20the_20above_20reasons_20it_20s_20normally_20not_20required_20to_20use_20the_20c_20smtptls_20or_20c_20esmtptls_20protocols_20in_20the_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20rl_20argument_20anchor_20smtpclient_5fprotocols_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20takes_20a_20url_20argument_20the_20protocol_20scheme_20component_20is_20handled_20as_20in_20the_20following_20table_20b_20smtpcclient_20protocol_20handling_20b_20protocol_20default_20port_20description_20c_20smtp_2025_20standard_20smtp_20port_20without_20encryption_20esmpt_20and_20c_20starttls_20detection_20is_20supported_20automatically_20c_20smtps_20465_20note_20that_20port_20465_20is_20currently_20assigned_20to_20source_20specific_20multicast_20audio_20video_20a_20href_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20a_20its_20use_20as_20a_20port_20for_20secure_20smtp_20listeners_20where_20security_20is_20enforced_20at_20the_20transport_20layer_20because_20the_20server_20immediately_20negotiates_20a_20tls_20ssl_20connection_20before_20the_20application_20protocol_20communication_20starts_20is_20but_20is_20included_20in_20this_20module_20because_20many_20smtp_20servers_20still_20operate_20this_20way_20c_20smtptls_2025_20a_20c_20starttls_20command_20is_20executed_20unconditionally_20after_20the_20connection_20to_20ensure_20a_20secure_20connection_20even_20if_20the_20server_20does_20not_20declare_20support_20for_20this_20command_20in_20the_20login_20response_20it_20s_20normally_20not_20necessary_20to_20use_20this_20protocol_20as_20c_20starttls_20is_20used_20automatically_20when_20logging_20in_20to_20esmtp_20servers_20that_20declare_20support_20for_20this_20command_20in_20the_20response_20to_20the_20c_20ehlo_20command_20c_20esmtp_20587_20like_20c_20smtp_20just_20using_20port_20587_20c_20esmtps_20465_20like_20c_20smtps_20c_20esmtptls_20587_20like_20c_20smtptls_20just_20using_20port_20587_20par_20example_3a_20code_20py_20requires_20smtpclient_20requires_20mime_20message_20msg_20the_20sender_20sender_20email_20com_20my_20subject_20msg_20setbody_20body_20msg_20addto_20my_20best_20friend_20you_20friend_20com_20msg_20attach_20filename_20mime_3a_3amimetypetext_20data_20code_20log_20sub_20string_20str_20printf_20y_3a_20s_20n_20now_5fus_20str_20smtpclient_3a_3asmtpclient_20smtp_20esmtptls_3a_20user_20password_3asmtp_20example_20com_20log_20log_20smtp_20sendmessage_20msg_20endcode_20section_20smtpclient_5freferences_20smtpclient_20references_20based_20on_3a_20http_3a_20james_20apache_20org_20server_20rfclist_20smtp_20rfc0821_20txt_20http_3a_20tools_20ietf_20org_20html_20rfc821_3a_20initial_20smtp_20protocol_20spec_20http_3a_20tools_20ietf_20org_20html_20rfc1521_3a_20quoted_20printable_20base_2064_20transfer_20encodings_20http_3a_20tools_20ietf_20org_20html_20rfc2045_3a_20mime_20headers_20content_20types_20etc_20http_3a_20tools_20ietf_20org_20html_20rfc2047_3a_20q_20and_20b_20encoded_20words_20implemented_20by_20the_20mime_20module_20http_3a_20tools_20ietf_20org_20html_20rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_28',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['rest_20of_20the_20smtp_20session_20is_20performed_20securely_20this_20also_20allows_20transparent_20logins_20and_20communication_20with_20esmtp_20servers_20that_20require_20secure_20connections_20for_20the_20above_20reasons_20it_20s_20normally_20not_20required_20to_20use_20the_20c_20smtptls_20or_20c_20esmtptls_20protocols_20in_20the_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20rl_20argument_20anchor_20smtpclient_5fprotocols_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20takes_20a_20url_20argument_20the_20protocol_20scheme_20component_20is_20handled_20as_20in_20the_20following_20table_20b_20smtpcclient_20protocol_20handling_20b_20protocol_20default_20port_20description_20c_20smtp_2025_20standard_20smtp_20port_20without_20encryption_20esmpt_20and_20c_20starttls_20detection_20is_20supported_20automatically_20c_20smtps_20465_20note_20that_20port_20465_20is_20currently_20assigned_20to_20source_20specific_20multicast_20audio_20video_20a_20href_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20a_20its_20use_20as_20a_20port_20for_20secure_20smtp_20listeners_20where_20security_20is_20enforced_20at_20the_20transport_20layer_20because_20the_20server_20immediately_20negotiates_20a_20tls_20ssl_20connection_20before_20the_20application_20protocol_20communication_20starts_20is_20but_20is_20included_20in_20this_20module_20because_20many_20smtp_20servers_20still_20operate_20this_20way_20c_20smtptls_2025_20a_20c_20starttls_20command_20is_20executed_20unconditionally_20after_20the_20connection_20to_20ensure_20a_20secure_20connection_20even_20if_20the_20server_20does_20not_20declare_20support_20for_20this_20command_20in_20the_20login_20response_20it_20s_20normally_20not_20necessary_20to_20use_20this_20protocol_20as_20c_20starttls_20is_20used_20automatically_20when_20logging_20in_20to_20esmtp_20servers_20that_20declare_20support_20for_20this_20command_20in_20the_20response_20to_20the_20c_20ehlo_20command_20c_20esmtp_20587_20like_20c_20smtp_20just_20using_20port_20587_20c_20esmtps_20465_20like_20c_20smtps_20c_20esmtptls_20587_20like_20c_20smtptls_20just_20using_20port_20587_20par_20example_3a_20code_20py_20requires_20smtpclient_20requires_20mime_20message_20msg_20the_20sender_20sender_20email_20com_20my_20subject_20msg_20setbody_20body_20msg_20addto_20my_20best_20friend_20you_20friend_20com_20msg_20attach_20filename_20mime_3a_3amimetypetext_20data_20code_20log_20sub_20string_20str_20printf_20y_3a_20s_20n_20now_5fus_20str_20smtpclient_3a_3asmtpclient_20smtp_20esmtptls_3a_20user_20password_3asmtp_20example_20com_20log_20log_20smtp_20sendmessage_20msg_20endcode_20section_20smtpclient_5freferences_20smtpclient_20references_20based_20on_3a_20http_3a_20james_20apache_20org_20server_20rfclist_20smtp_20rfc0821_20txt_20http_3a_20tools_20ietf_20org_20html_20rfc821_3a_20initial_20smtp_20protocol_20spec_20http_3a_20tools_20ietf_20org_20html_20rfc1521_3a_20quoted_20printable_20base_2064_20transfer_20encodings_20http_3a_20tools_20ietf_20org_20html_20rfc2045_3a_20mime_20headers_20content_20types_20etc_20http_3a_20tools_20ietf_20org_20html_20rfc2047_3a_20q_20and_20b_20encoded_20words_20implemented_20by_20the_20mime_20module_20http_3a_20tools_20ietf_20org_20html_20rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_29',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['restrictions_30',['Data Type Declarations and Restrictions',['../../../../lang/html/data_type_declarations.html',1,'index']]],
  ['reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_31',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['rfc0821_20txt_20http_3a_20tools_20ietf_20org_20html_20rfc821_3a_20initial_20smtp_20protocol_20spec_20http_3a_20tools_20ietf_20org_20html_20rfc1521_3a_20quoted_20printable_20base_2064_20transfer_20encodings_20http_3a_20tools_20ietf_20org_20html_20rfc2045_3a_20mime_20headers_20content_20types_20etc_20http_3a_20tools_20ietf_20org_20html_20rfc2047_3a_20q_20and_20b_20encoded_20words_20implemented_20by_20the_20mime_20module_20http_3a_20tools_20ietf_20org_20html_20rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_32',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['rfc1521_3a_20quoted_20printable_20base_2064_20transfer_20encodings_20http_3a_20tools_20ietf_20org_20html_20rfc2045_3a_20mime_20headers_20content_20types_20etc_20http_3a_20tools_20ietf_20org_20html_20rfc2047_3a_20q_20and_20b_20encoded_20words_20implemented_20by_20the_20mime_20module_20http_3a_20tools_20ietf_20org_20html_20rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_33',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['rfc2045_3a_20mime_20headers_20content_20types_20etc_20http_3a_20tools_20ietf_20org_20html_20rfc2047_3a_20q_20and_20b_20encoded_20words_20implemented_20by_20the_20mime_20module_20http_3a_20tools_20ietf_20org_20html_20rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_34',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['rfc2047_3a_20q_20and_20b_20encoded_20words_20implemented_20by_20the_20mime_20module_20http_3a_20tools_20ietf_20org_20html_20rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_35',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_36',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['rfc821_3a_20initial_20smtp_20protocol_20spec_20http_3a_20tools_20ietf_20org_20html_20rfc1521_3a_20quoted_20printable_20base_2064_20transfer_20encodings_20http_3a_20tools_20ietf_20org_20html_20rfc2045_3a_20mime_20headers_20content_20types_20etc_20http_3a_20tools_20ietf_20org_20html_20rfc2047_3a_20q_20and_20b_20encoded_20words_20implemented_20by_20the_20mime_20module_20http_3a_20tools_20ietf_20org_20html_20rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_37',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['rfclist_20smtp_20rfc0821_20txt_20http_3a_20tools_20ietf_20org_20html_20rfc821_3a_20initial_20smtp_20protocol_20spec_20http_3a_20tools_20ietf_20org_20html_20rfc1521_3a_20quoted_20printable_20base_2064_20transfer_20encodings_20http_3a_20tools_20ietf_20org_20html_20rfc2045_3a_20mime_20headers_20content_20types_20etc_20http_3a_20tools_20ietf_20org_20html_20rfc2047_3a_20q_20and_20b_20encoded_20words_20implemented_20by_20the_20mime_20module_20http_3a_20tools_20ietf_20org_20html_20rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_38',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_39',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['rl_20argument_20anchor_20smtpclient_5fprotocols_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20takes_20a_20url_20argument_20the_20protocol_20scheme_20component_20is_20handled_20as_20in_20the_20following_20table_20b_20smtpcclient_20protocol_20handling_20b_20protocol_20default_20port_20description_20c_20smtp_2025_20standard_20smtp_20port_20without_20encryption_20esmpt_20and_20c_20starttls_20detection_20is_20supported_20automatically_20c_20smtps_20465_20note_20that_20port_20465_20is_20currently_20assigned_20to_20source_20specific_20multicast_20audio_20video_20a_20href_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20a_20its_20use_20as_20a_20port_20for_20secure_20smtp_20listeners_20where_20security_20is_20enforced_20at_20the_20transport_20layer_20because_20the_20server_20immediately_20negotiates_20a_20tls_20ssl_20connection_20before_20the_20application_20protocol_20communication_20starts_20is_20but_20is_20included_20in_20this_20module_20because_20many_20smtp_20servers_20still_20operate_20this_20way_20c_20smtptls_2025_20a_20c_20starttls_20command_20is_20executed_20unconditionally_20after_20the_20connection_20to_20ensure_20a_20secure_20connection_20even_20if_20the_20server_20does_20not_20declare_20support_20for_20this_20command_20in_20the_20login_20response_20it_20s_20normally_20not_20necessary_20to_20use_20this_20protocol_20as_20c_20starttls_20is_20used_20automatically_20when_20logging_20in_20to_20esmtp_20servers_20that_20declare_20support_20for_20this_20command_20in_20the_20response_20to_20the_20c_20ehlo_20command_20c_20esmtp_20587_20like_20c_20smtp_20just_20using_20port_20587_20c_20esmtps_20465_20like_20c_20smtps_20c_20esmtptls_20587_20like_20c_20smtptls_20just_20using_20port_20587_20par_20example_3a_20code_20py_20requires_20smtpclient_20requires_20mime_20message_20msg_20the_20sender_20sender_20email_20com_20my_20subject_20msg_20setbody_20body_20msg_20addto_20my_20best_20friend_20you_20friend_20com_20msg_20attach_20filename_20mime_3a_3amimetypetext_20data_20code_20log_20sub_20string_20str_20printf_20y_3a_20s_20n_20now_5fus_20str_20smtpclient_3a_3asmtpclient_20smtp_20esmtptls_3a_20user_20password_3asmtp_20example_20com_20log_20log_20smtp_20sendmessage_20msg_20endcode_20section_20smtpclient_5freferences_20smtpclient_20references_20based_20on_3a_20http_3a_20james_20apache_20org_20server_20rfclist_20smtp_20rfc0821_20txt_20http_3a_20tools_20ietf_20org_20html_20rfc821_3a_20initial_20smtp_20protocol_20spec_20http_3a_20tools_20ietf_20org_20html_20rfc1521_3a_20quoted_20printable_20base_2064_20transfer_20encodings_20http_3a_20tools_20ietf_20org_20html_20rfc2045_3a_20mime_20headers_20content_20types_20etc_20http_3a_20tools_20ietf_20org_20html_20rfc2047_3a_20q_20and_20b_20encoded_20words_20implemented_20by_20the_20mime_20module_20http_3a_20tools_20ietf_20org_20html_20rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_40',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_41',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]]
];
