#!/usr/bin/env python3
# -*- coding: utf-8 -*-
#
# pmdarima documentation build configuration file, created by
# sphinx-quickstart on Sun Sep  3 15:16:29 2017.
#
# This file is execfile()d with the current directory set to its
# containing dir.
#
# Note that not all possible configuration values are present in this
# autogenerated file.
#
# All configuration values have a default; values that are commented out
# serve to show the default.

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
#
# Import first to avoid backend ValueError:
# ValueError: Sphinx-Gallery relies on the matplotlib 'agg' backend to
# render figures and write them to files. You are currently using the MacOSX
# backend. Sphinx-Gallery will terminate the build now, because changing
# backends is not well supported by matplotlib. We advise you to move
# sphinx_gallery imports before any matplotlib-dependent import. Moving
# sphinx_gallery imports at the top of your conf.py file should fix this issue
import sphinx_gallery
import matplotlib
matplotlib.use('agg')  # RISK: could be overridden via environment variables...

import os
import sys
import pmdarima  # noqa
import datetime
import warnings
from six import u

sys.path.insert(0, os.path.abspath('..' + os.path.sep))
sys.path.insert(0, os.path.abspath('sphinxext'))

from github_link import make_linkcode_resolve


# -- General configuration ------------------------------------------------

# If your documentation needs a minimal Sphinx version, state it here.
#
# needs_sphinx = '1.0'

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = [
    'sphinx.ext.autodoc',
    'sphinx.ext.autosummary',
    'sphinx.ext.coverage',
    'sphinx.ext.doctest',
    'sphinx.ext.linkcode',
    'sphinx.ext.mathjax',
    'sphinx.ext.viewcode',
    'sphinx.ext.githubpages',
    'numpydoc',
    'sphinx_gallery.gen_gallery'
]

# this is needed for some reason...
# see https://github.com/numpy/numpydoc/issues/69
numpydoc_class_members_toctree = False
autodoc_default_flags = ['members', 'inherited-members']

# generate autosummary even if no references
autosummary_generate = True

# Add any paths that contain templates here, relative to this directory.
templates_path = ['_templates']

# The suffix(es) of source filenames.
# You can specify multiple suffix as a list of string:
#
# source_suffix = ['.rst', '.md']
source_suffix = '.rst'

# The master toctree document.
master_doc = 'index'

# General information about the project.
project = 'pmdarima'
year = datetime.datetime.now().year
copyright = '2017-{0}, Taylor G Smith'.format(year)
author = 'Taylor G Smith'

# The version info for the project you're documenting, acts as replacement for
# |version| and |release|, also used in various other places throughout the
# built documents.
#
# Set when calling `make documentation PMDARIMA_VERSION=...`
pmdarima_version = os.environ['PMDARIMA_VERSION']
if not pmdarima_version.strip():
    warnings.warn("!!! VERSION NOT SET VIA CLI!!! ")
    pmdarima_version = '0.0.0'
release = version = pmdarima_version

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#
# This is also used if you do content translation via gettext catalogs.
# Usually you set "language" from the command line for these cases.
language = 'en'

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This patterns also effect to html_static_path and html_extra_path
exclude_patterns = ['_build', 'Thumbs.db', '.DS_Store']

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = 'sphinx'

# If true, `todo` and `todoList` produce output, else they produce nothing.
todo_include_todos = False


# -- Options for HTML output ----------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
#
html_theme = 'sphinx_rtd_theme'

# Theme options are theme-specific and customize the look and feel of a theme
# further.  For a list of options available for each theme, see the
# documentation.
#
# html_theme_options = {}

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ['_static']

# Custom sidebar templates, must be a dictionary that maps document names
# to template names.
#
# This is required for the alabaster theme
# refs: http://alabaster.readthedocs.io/en/latest/installation.html#sidebars
html_sidebars = {
    '**': [
        'about.html',
        'navigation.html',
        'relations.html',  # needs 'show_related': True theme option to display
        'searchbox.html',
        'donate.html',
    ]
}

# Name of the favicon image
html_favicon = 'img/favicon.ico'

# TODO: someday
# html_logo = ?

# -- Options for HTMLHelp output ------------------------------------------

# Output file base name for HTML help builder.
htmlhelp_basename = 'pmdarimadoc'


# -- Options for LaTeX output ---------------------------------------------

latex_elements = {
    # The paper size ('letterpaper' or 'a4paper').
    #
    # 'papersize': 'letterpaper',

    # The font size ('10pt', '11pt' or '12pt').
    #
    # 'pointsize': '10pt',

    # Additional stuff for the LaTeX preamble.
    #
    # 'preamble': '',

    # Latex figure (float) alignment
    #
    # 'figure_align': 'htbp',
}

# Grouping the document tree into LaTeX files. List of tuples
# (source start file, target name, title,
#  author, documentclass [howto, manual, or own class]).
latex_documents = [
    (master_doc, 'pmdarima.tex', 'pmdarima Documentation',
     'Taylor G Smith', 'manual'),
]


# -- Options for manual page output ---------------------------------------

# One entry per manual page. List of tuples
# (source start file, name, description, authors, manual section).
man_pages = [
    (master_doc, 'pmdarima', u('pmdarima Documentation'),
     [author], 1)
]


# -- Options for Texinfo output -------------------------------------------

# Grouping the document tree into Texinfo files. List of tuples
# (source start file, target name, title, author,
#  dir menu entry, description, category)
texinfo_documents = [
    (master_doc, 'pmdarima', 'pmdarima Documentation',
     author, 'pmdarima', 'One line description of project.',
     'Miscellaneous'),
]

sphinx_gallery_conf = {
    'doc_module': 'pmdarima',
    'backreferences_dir': os.path.join('modules', 'generated'),
    'reference_url': {'pmdarima': None}
}


def setup(app):
    def adds(pth):
        print("Adding stylesheet: %s" % pth)
        app.add_css_file(pth)

    adds('css/fields.css')  # for parameters, etc.
    adds('css/gitcontrib.css')  # for git contributors


# -- Extension configuration -------------------------------------------------

# The following is used by sphinx.ext.linkcode to provide links to github
linkcode_resolve = make_linkcode_resolve(
    'pmdarima', u('https://github.com/alkaline-ml/'
                  'pmdarima/blob/{revision}/'
                  '{package}/{path}#L{lineno}'))
