# Roadmap

Last updated: August 2023

## Contributor Experience

Panel is dedicated to enhancing the development experience, making it simpler, more robust, and more efficient. The following sections outline the key initiatives in our roadmap to improve the developer experience for Panel (which other tools in the HoloViz ecosystem will also benefit from).

### Hatch Integration and Pip-Only Workflows

We plan to switch the current project build and testing infrastructure to [Hatch](https://hatch.pypa.io/latest/), enabling more streamlined processes and easier developer setup. This change will simplify the build process and allow users to develop Panel using either pip OR conda based installs, providing an easier onramp for non-conda users.

### Updated Contributor Guides

In addition to providing more flexibility around build and developer environment setup we aim to update the contributor guide to make it straightforward even for inexperienced developers to set up an environment that allows them to start contributing.

### Improve Documentation Build Tooling

We will improve our current documentation build tooling, allowing developers to perform partial builds more easily. This change aims to reduce the build time and make the process of contributing to or updating the documentation more approachable.

### Easy Extension Creation

To encourage and facilitate the development of extensions, we are working on a cookiecutter template specifically designed for building Bokeh/Panel extension packages. This will allow developers to quickly scaffold a new extension, following best practices, without having to set up everything manually.

### Dynamic Compilation of Models

In a bid to increase efficiency and provide more flexibility, Panel will integrate with Anywidget without having to pull in ipywidgets_bokeh. This will enable dynamic compilation of models, enhancing responsiveness, leverage the growing ecosystem built on this modern tooling and providing a more seamless connection between the frontend and backend components.

### Community

As part of the general effort to improve our developer experience we aim to better engage with the community to encourage contributors to help improve the ecosystem. This will include items such as guided sprints with core developers, producing video material aimed at educating users about contributions, diligent tagging of issues that are suitable for first time contributors and checklists to get people started. Additionally the core team will organize hackathons, community calls and live streams.

## Chat and LLM Interfaces

Enhancing the interaction with Large Language Models (LLMs) through a polished and efficient interface is a primary focus in our roadmap. The following sections detail our initiatives to take the Chat and LLM interfaces to the next level.

### Fully Polished and Full-Featured Chat Interface for Interacting with LLMs

Building upon the existing functionality, we aim to introduce a fully polished and full-featured Chat interface that enables seamless interaction with LLMs. This will empower users to engage with the models in a more intuitive manner, improving accessibility and widening the application of LLMs within various domains. By enabling the visualization of complex data structures, images, and other multimedia elements, the interaction with LLMs will become more engaging and informative. This feature will make the Chat interface a versatile tool for exploring and presenting information generated by LLMs.

### Improved Performance and Responsiveness
To ensure that the interaction with LLMs remains smooth and responsive, we will focus on the efficient streaming of tokens between the interface and the models. This includes optimizing the way tokens are transmitted, processed, and rendered, which will reduce latency and improve the overall user experience.

## Documentation

Ensuring that users can quickly understand and effectively use Panel is a critical part of our mission. Over the past year we started an effort to better align our project documentation with the [Diátaxis](https://diataxis.fr/) frameworks. This initial effort was only the start and to this end, the upcoming enhancements are designed to provide better support and guidance, focusing on improved documentation, advanced tutorials, cheat sheets, and best practices.

### Improved Component Gallery and API Documentation

Our ongoing documentation overhaul aims to enhance both the component gallery and the API documentation. Users will benefit from a more detailed, organized, and visually appealing component gallery that showcases the full range of Panel's capabilities. The API documentation will also be revised to offer clear, concise, and comprehensive details about the available functionalities. This effort is intended to make it easier for both new and experienced developers to find the information they need.

### Guided Learning for Advanced Users

An advanced tutorial will be developed to cater to users looking to explore more complex use cases and functionalities of Panel. This step-by-step guide will delve into intricate topics, providing in-depth explanations, examples, and insights. This tutorial will serve as an invaluable resource for those wanting to take their skills to the next level.

### Quick Reference Guide

Recognizing the need for a quick and handy reference, we will introduce a Panel cheat sheet. This concise guide will contain essential information, tips, and code snippets that users can refer to while working on their projects. The cheat sheet will be designed to be a practical tool that helps users quickly recall key concepts and commands.

### Guiding Principles for Effective Development

Panel's best practices will be documented to guide users in adopting efficient, maintainable, and robust coding practices. This resource will highlight recommended approaches, common pitfalls to avoid, and general guidance to help users write cleaner and more effective code with Panel. By adhering to these best practices, users will be able to maximize their productivity and the quality of their work.

## Design Work

A consistent and appealing design plays a vital role in the usability and success of any library. As Panel continues to evolve, so does our commitment to enhance its design capabilities. The following roadmap focuses on our design-related endeavors, aiming to improve both aesthetic and functional aspects of Bokeh and Panel.

### Build on CSS Variable Support in Bokeh and Panel

Building on CSS variable support will enable users to define their themes and styles more effortlessly. By utilizing this capability within Bokeh and Panel, developers can create more visually appealing applications and visualizations with greater ease. This enhancement will foster creativity and empower users to tailor their projects to align with specific branding or aesthetic requirements.

### Evaluation and Enhancement of Design Quality

The introduction of the "Design" system in Panel 1.0 marked a significant step towards providing users with tools to create tailored and consistent visual experiences. However, we recognize that design needs and preferences can vary widely.

Our roadmap includes a comprehensive evaluation of the current "Design" system to determine whether it meets the diverse needs of our user community. This assessment will include examining its sufficiency in allowing users to achieve the specific look and feel they desire in their applications and visualizations.

Should we find that additional flexibility and options are needed, we will explore ways to allow users to easily wrap other components. This approach would enable the integration of various design elements, further personalizing the appearance and enhancing the overall design quality.

Through this careful evaluation and potential enhancement, we aim to ensure that Panel continues to offer a versatile and user-friendly design system that can adapt to the unique requirements and creative visions of our users
