import { VDomModel } from '@jupyterlab/ui-components';
import { IObservableDisposable } from '@lumino/disposable';
import { ISignal } from '@lumino/signaling';
import { IFilter, IFilters, IReplaceOptionsSupport, ISearchProvider } from './tokens';
/**
 * Search in a document model.
 */
export declare class SearchDocumentModel extends VDomModel implements IObservableDisposable {
    protected searchProvider: ISearchProvider;
    /**
     * Search document model
     * @param searchProvider Provider for the current document
     * @param searchDebounceTime Debounce search time
     */
    constructor(searchProvider: ISearchProvider, searchDebounceTime: number);
    /**
     * Whether the search is case sensitive or not.
     */
    get caseSensitive(): boolean;
    set caseSensitive(v: boolean);
    /**
     * Current highlighted match index.
     */
    get currentIndex(): number | null;
    /**
     * A signal emitted when the object is disposed.
     */
    get disposed(): ISignal<this, void>;
    /**
     * Filter values.
     */
    get filters(): IFilters;
    /**
     * Filter definitions for the current provider.
     */
    get filtersDefinition(): {
        [n: string]: IFilter;
    };
    /**
     * Filter definitions changed.
     */
    get filtersDefinitionChanged(): ISignal<ISearchProvider, void> | null;
    /**
     * The initial query string.
     */
    get initialQuery(): string;
    set initialQuery(v: string);
    /**
     * Initial query as suggested by provider.
     *
     * A common choice is the text currently selected by the user.
     */
    get suggestedInitialQuery(): string;
    /**
     * Whether the document is read-only or not.
     */
    get isReadOnly(): boolean;
    /**
     * Replace options support.
     */
    get replaceOptionsSupport(): IReplaceOptionsSupport | undefined;
    /**
     * Parsing regular expression error message.
     */
    get parsingError(): string;
    /**
     * Whether to preserve case when replacing.
     */
    get preserveCase(): boolean;
    set preserveCase(v: boolean);
    /**
     * Replacement expression
     */
    get replaceText(): string;
    set replaceText(v: string);
    /**
     * Search expression
     */
    get searchExpression(): string;
    set searchExpression(v: string);
    /**
     * Total number of matches.
     */
    get totalMatches(): number | null;
    /**
     * Whether to use regular expression or not.
     */
    get useRegex(): boolean;
    set useRegex(v: boolean);
    /**
     * Whether to match whole words or not.
     */
    get wholeWords(): boolean;
    set wholeWords(v: boolean);
    /**
     * Dispose the model.
     */
    dispose(): void;
    /**
     * End the query.
     */
    endQuery(): Promise<void>;
    /**
     * Highlight the next match.
     */
    highlightNext(): Promise<void>;
    /**
     * Highlight the previous match
     */
    highlightPrevious(): Promise<void>;
    /**
     * Refresh search
     */
    refresh(): void;
    /**
     * Replace all matches.
     */
    replaceAllMatches(): Promise<void>;
    /**
     * Replace the current match.
     */
    replaceCurrentMatch(): Promise<void>;
    /**
     * Set the value of a given filter.
     *
     * @param name Filter name
     * @param v Filter value
     */
    setFilter(name: string, v: boolean): Promise<void>;
    private _updateSearch;
    private _onProviderStateChanged;
    private _caseSensitive;
    private _disposed;
    private _parsingError;
    private _preserveCase;
    private _initialQuery;
    private _filters;
    private _replaceText;
    private _searchActive;
    private _searchDebouncer;
    private _searchExpression;
    private _useRegex;
    private _wholeWords;
}
