import { type DateObject } from './types';
/** Available options for re-ordering date input element */
export type DateElementFormat = 'DMY' | 'MDY' | 'YMD';
/** Type describing format of DateElement prop */
type DateElementProp = {
    type: string;
    range: [number, number];
    value: number | undefined;
};
/** Given date & time information with optional yearRange & format, returns props for DateElement
 *
 * @param date - Object containing date with optional time information
 * @param time - Determines whether to include time or not
 * @param [yearRange=[1900, new Date().getFullYear() + 2]] - Controls the list of years to be displayed
 * @param [format='YMD'] - Controls the order in which day, month and year input element will be displayed
 * @returns Array of props for DateElement
 */
export default function getDateElementProps(date: DateObject, time: boolean, yearRange?: [number, number], format?: DateElementFormat): DateElementProp[];
export {};
