"use strict";
/* --------------------------------------------------------------------------------------------
 * Copyright (c) 2018-2022 TypeFox GmbH (http://www.typefox.io). All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for license information.
 * ------------------------------------------------------------------------------------------ */
Object.defineProperty(exports, "__esModule", { value: true });
exports.createStreamConnection = exports.createProcessStreamConnection = exports.createSocketConnection = exports.createProcessSocketConnection = exports.createWebSocketConnection = exports.createServerProcess = void 0;
const tslib_1 = require("tslib");
const cp = tslib_1.__importStar(require("child_process"));
const node_1 = require("vscode-jsonrpc/node");
const connection_1 = require("./connection");
const socket_1 = require("../socket");
function createServerProcess(serverName, command, args, options) {
    const serverProcess = cp.spawn(command, args || [], options || {});
    serverProcess.on('error', error => console.error(`Launching ${serverName} Server failed: ${error}`));
    if (serverProcess.stderr !== null) {
        serverProcess.stderr.on('data', data => console.error(`${serverName} Server: ${data}`));
    }
    return createProcessStreamConnection(serverProcess);
}
exports.createServerProcess = createServerProcess;
function createWebSocketConnection(socket) {
    const reader = new socket_1.WebSocketMessageReader(socket);
    const writer = new socket_1.WebSocketMessageWriter(socket);
    return (0, connection_1.createConnection)(reader, writer, () => socket.dispose(), { socket });
}
exports.createWebSocketConnection = createWebSocketConnection;
function createProcessSocketConnection(process, outSocket, inSocket = outSocket) {
    return createSocketConnection(outSocket, inSocket, () => process.kill());
}
exports.createProcessSocketConnection = createProcessSocketConnection;
function createSocketConnection(outSocket, inSocket, onDispose) {
    const reader = new node_1.SocketMessageReader(outSocket);
    const writer = new node_1.SocketMessageWriter(inSocket);
    return (0, connection_1.createConnection)(reader, writer, onDispose);
}
exports.createSocketConnection = createSocketConnection;
function createProcessStreamConnection(process) {
    if (process.stdout !== null && process.stdin !== null) {
        return createStreamConnection(process.stdout, process.stdin, () => process.kill());
    }
    else {
        return undefined;
    }
}
exports.createProcessStreamConnection = createProcessStreamConnection;
function createStreamConnection(outStream, inStream, onDispose) {
    const reader = new node_1.StreamMessageReader(outStream);
    const writer = new node_1.StreamMessageWriter(inStream);
    return (0, connection_1.createConnection)(reader, writer, onDispose);
}
exports.createStreamConnection = createStreamConnection;
//# sourceMappingURL=launch.js.map