<!-- Hello! Thanks for submitting a PR. To help make things go a bit smoother
     we would appreciate that you go through this template. -->

### Description

<!-- Good things to put here include: reasoning for the change (please link
     any relevant issues!), any noteworthy (or hacky) choices to be aware of,
     or what the problem resolved here looked like ... we won't mind a ranty
     story :) -->

### Checklist - did you ...

<!-- If any of the following items aren't relevant for your contribution,
     please still tick them so we know you've gone through the checklist.

     - Please familiarize yourself with Black's stability policy, linked
       below. Code style changes are only allowed under the `--preview` flag
       until maintainers move them to stable in the next calendar year.
     - All user-facing changes should get a changelog entry. If this isn't
       user-facing, signal to us that this should get the magical label to
       silence the check.
     - Tests are required for all bugfixes and new features.
     - Documentation changes are necessary for most formatting changes and
       other enhancements. -->

- [ ] Implement any code style changes under the `--preview` style, following the stability policy?
- [ ] Add an entry in `CHANGES.md` if necessary?
- [ ] Add / update tests if necessary?
- [ ] Add new / update outdated documentation?

<!-- Just as a reminder, everyone in all psf/black spaces, including PRs, must
     follow the PSF Code of Conduct (link below).

     Finally, thanks once again for your time and effort. If you have any
     feedback regarding your experience contributing here, please let us know!

     Helpful links:

     - PSF COC: https://www.python.org/psf/conduct/
     - Contributing docs: https://black.readthedocs.io/en/latest/contributing/index.html
     - Chat on Python Discord: https://discord.gg/RtVdv86PrH
     - Stability policy: https://black.readthedocs.io/en/latest/the_black_code_style/index.html -->
