/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.eggs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.PlainDiagram;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.HColorSet;
import net.sourceforge.plantuml.klimt.color.HColorSimple;
import net.sourceforge.plantuml.klimt.color.HColors;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.font.UFont;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.geom.XPoint2D;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.UDrawable;
import net.sourceforge.plantuml.klimt.shape.UPolygon;
import net.sourceforge.plantuml.klimt.shape.URectangle;
import net.sourceforge.plantuml.klimt.sprite.SpriteContainerEmpty;
import net.sourceforge.plantuml.preproc.PreprocessingArtifact;
import net.sourceforge.plantuml.skin.Pragma;

public class PSystemColors
extends PlainDiagram
implements UDrawable {
    private final double rectangleHeight = 28.0;
    private final double rectangleWidth = 175.0;
    private final HColorSet colors = HColorSet.instance();
    private final String paletteCentralColor;
    private final double size = 60.0;

    public PSystemColors(UmlSource source, String option, PreprocessingArtifact preprocessing) {
        super(source, preprocessing);
        this.paletteCentralColor = option == null ? null : option.replaceAll("\\#", "");
    }

    @Override
    protected UDrawable getRootDrawable(FileFormatOption fileFormatOption) {
        return this;
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("(Colors)");
    }

    @Override
    public void drawU(UGraphic ug) {
        if (this.paletteCentralColor != null && this.colors.getColorOrWhite(this.paletteCentralColor) instanceof HColorSimple) {
            this.drawPalette(ug);
        } else {
            this.drawFull(ug);
        }
    }

    private void drawPalette(UGraphic ug) {
        double x = (this.centerHexa(2, 0).getX() + this.centerHexa(3, 0).getX()) / 2.0;
        double y = this.centerHexa(0, 2).getY() + this.corner(1).getY();
        ug = ug.apply(new UTranslate(x, y));
        UPolygon hexa = this.getHexa();
        List<String> friends = this.getColorsCloseTo(this.paletteCentralColor);
        int idx = 0;
        this.drawOneHexa(ug, friends.get(idx++), 0, 0, hexa);
        this.drawOneHexa(ug, friends.get(idx++), 1, 0, hexa);
        this.drawOneHexa(ug, friends.get(idx++), 0, 1, hexa);
        this.drawOneHexa(ug, friends.get(idx++), -1, 1, hexa);
        this.drawOneHexa(ug, friends.get(idx++), -1, 0, hexa);
        this.drawOneHexa(ug, friends.get(idx++), -1, -1, hexa);
        this.drawOneHexa(ug, friends.get(idx++), 0, -1, hexa);
        this.drawOneHexa(ug, friends.get(idx++), 2, 0, hexa);
        this.drawOneHexa(ug, friends.get(idx++), 1, 1, hexa);
        this.drawOneHexa(ug, friends.get(idx++), 1, 2, hexa);
        this.drawOneHexa(ug, friends.get(idx++), 0, 2, hexa);
        this.drawOneHexa(ug, friends.get(idx++), -1, 2, hexa);
        this.drawOneHexa(ug, friends.get(idx++), -2, 1, hexa);
        this.drawOneHexa(ug, friends.get(idx++), -2, 0, hexa);
        this.drawOneHexa(ug, friends.get(idx++), -2, -1, hexa);
        this.drawOneHexa(ug, friends.get(idx++), -1, -2, hexa);
        this.drawOneHexa(ug, friends.get(idx++), 0, -2, hexa);
        this.drawOneHexa(ug, friends.get(idx++), 1, -2, hexa);
        this.drawOneHexa(ug, friends.get(idx++), 1, -1, hexa);
    }

    private XPoint2D centerHexa(int i, int j) {
        double width = this.getWidth();
        double x = width * (double)i + (j % 2 == 0 ? 0.0 : width / 2.0);
        double y = 60.0 * (double)j * 1.5;
        return new XPoint2D(x, y);
    }

    private double getWidth() {
        return Math.sqrt(3.0) / 2.0 * 2.0 * 60.0;
    }

    private void drawOneHexa(UGraphic ug, String colorName, int i, int j, UPolygon hexa) {
        HColor color = this.colors.getColorOrWhite(colorName);
        ug = this.applyColor(ug, color);
        ug = ug.apply(UTranslate.point(this.centerHexa(i, j)));
        ug.draw(hexa);
        UFont font = UFont.sansSerif(14).bold();
        TextBlock tt = this.getTextName(font, colorName, color);
        XDimension2D dimText = tt.calculateDimension(ug.getStringBounder());
        if (dimText.getWidth() > this.getWidth()) {
            tt = this.getTextName(font, this.findShortest(ug.getStringBounder(), font, colorName), color);
            dimText = tt.calculateDimension(ug.getStringBounder());
        }
        tt.drawU(ug.apply(new UTranslate(-dimText.getWidth() / 2.0, -dimText.getHeight() / 2.0)));
    }

    private String findShortest(StringBounder stringBounder, UFont font, String colorName) {
        String result = null;
        double min = Double.MAX_VALUE;
        for (int i = 1; i < colorName.length() - 1; ++i) {
            String candidat;
            TextBlock tt;
            double width;
            if (Character.isLowerCase(colorName.charAt(i)) || !((width = (tt = this.getTextName(font, candidat = colorName.substring(0, i) + "\\n" + colorName.substring(i), (HColorSimple)HColors.BLACK)).calculateDimension(stringBounder).getWidth()) < min)) continue;
            result = candidat;
            min = width;
        }
        return result;
    }

    private UGraphic applyColor(UGraphic ug, HColor color) {
        return ug.apply(color).apply(color.bg());
    }

    private XPoint2D corner(int i) {
        double angle_deg = 60 * i + 30;
        double angle_rad = Math.PI / 180 * angle_deg;
        return new XPoint2D(60.0 * Math.cos(angle_rad), 60.0 * Math.sin(angle_rad));
    }

    private UPolygon getHexa() {
        UPolygon result = new UPolygon();
        for (int i = 0; i < 6; ++i) {
            result.addPoint(this.corner(i));
        }
        return result;
    }

    private List<String> getColorsCloseTo(String other) {
        ArrayList<String> result = new ArrayList<String>(this.colors.names());
        Iterator it = result.iterator();
        while (it.hasNext()) {
            String similar;
            String candidat = (String)it.next();
            if (candidat.equals(similar = candidat.replaceAll("Gray", "Grey")) || !result.contains(similar)) continue;
            it.remove();
        }
        if (!this.containsCaseInsensitive(result, other)) {
            result.add(other);
        }
        Collections.sort(result, this.closeComparator(this.paletteCentralColor));
        return result;
    }

    private boolean containsCaseInsensitive(Collection<String> source, String target) {
        for (String s : source) {
            if (!s.equalsIgnoreCase(target)) continue;
            return true;
        }
        return false;
    }

    private Comparator<String> closeComparator(String center) {
        final HColorSimple centerColor = (HColorSimple)this.colors.getColorOrWhite(center);
        return new Comparator<String>(){

            @Override
            public int compare(String col1, String col2) {
                int dist1 = centerColor.distanceTo((HColorSimple)PSystemColors.this.colors.getColorOrWhite(col1));
                int dist2 = centerColor.distanceTo((HColorSimple)PSystemColors.this.colors.getColorOrWhite(col2));
                return (int)Math.signum(dist1 - dist2);
            }
        };
    }

    private void drawFull(UGraphic ug) {
        UFont font = UFont.sansSerif(14).bold();
        ug = ug.apply(HColors.BLACK);
        int i = 0;
        int j = 0;
        for (String name : this.colors.names()) {
            UGraphic tmp = this.getPositioned(ug, i, j);
            HColor color = this.colors.getColorOrWhite(name);
            this.applyColor(tmp, color).draw(URectangle.build(175.0, 28.0));
            TextBlock tt = this.getTextName(font, name, color);
            XDimension2D dimText = tt.calculateDimension(ug.getStringBounder());
            double dy = (28.0 - dimText.getHeight()) / 2.0;
            double dx = (175.0 - dimText.getWidth()) / 2.0;
            tt.drawU(tmp.apply(new UTranslate(dx, dy)));
            if (j++ != 20) continue;
            j = 0;
            ++i;
        }
    }

    private TextBlock getTextName(UFont font, String name, HColor color) {
        HColor opposite = color.opposite();
        FontConfiguration fc = FontConfiguration.create(font, opposite, HColors.BLUE, UStroke.simple());
        TextBlock tt = Display.getWithNewlines(Pragma.createEmpty(), name).create(fc, HorizontalAlignment.CENTER, new SpriteContainerEmpty());
        return tt;
    }

    private UGraphic getPositioned(UGraphic ug, int i, int j) {
        return ug.apply(new UTranslate(175.0 * (double)i, 28.0 * (double)j));
    }
}

