/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.eggs;

import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import net.sourceforge.plantuml.eggs.EggUtils;

public class SentenceDecoder {
    private final String secret;

    public SentenceDecoder(String sentence1, byte[] crypted) throws UnsupportedEncodingException {
        byte[] key = EggUtils.fromSecretSentence(sentence1).toByteArray();
        byte[] sen2 = EggUtils.xor(crypted, key);
        this.secret = new String(sen2, StandardCharsets.UTF_8);
    }

    public boolean isOk() {
        for (char c : this.secret.toCharArray()) {
            if (c > '\u0100') {
                return false;
            }
            if (!Character.isDefined(c)) {
                return false;
            }
            if (!Character.isISOControl(c)) continue;
            return false;
        }
        return true;
    }

    public String getSecret() {
        return this.secret;
    }
}

