import socket
import ssl

if not hasattr(ssl, "CERT_REQUIRED"):
    print("SKIP")
    raise SystemExit

# This certificate was obtained from micropython.org using openssl:
# $ openssl s_client -showcerts -connect micropython.org:443 </dev/null 2>/dev/null
# The certificate is from Let's Encrypt:
# 1 s:C=US, O=Let's Encrypt, CN=R12
#   i:C=US, O=Internet Security Research Group, CN=ISRG Root X1
#   a:PKEY: RSA, 2048 (bit); sigalg: sha256WithRSAEncryption
#   v:NotBefore: Mar 13 00:00:00 2024 GMT; NotAfter: Mar 12 23:59:59 2027 GMT
# Copy PEM content to a file (mpycert.pem) and convert to DER e.g.
# $ openssl x509 -in mpycert.pem -out mpycert.der -outform DER
# Then convert to hex format using: for i in range(0,len(data),40):print(data[i:i+40].hex())

ca_cert_chain = bytes.fromhex(
    "30820506308202eea003020102021100c212324b70a9b49171dc40f7e285263c300d06092a864886"
    "f70d01010b0500304f310b300906035504061302555331293027060355040a1320496e7465726e65"
    "742053656375726974792052657365617263682047726f7570311530130603550403130c49535247"
    "20526f6f74205831301e170d3234303331333030303030305a170d3237303331323233353935395a"
    "3033310b300906035504061302555331163014060355040a130d4c6574277320456e637279707431"
    "0c300a0603550403130352313230820122300d06092a864886f70d01010105000382010f00308201"
    "0a0282010100da982874adbe94fe3be01ee2e54b75ab2c127feda703327e3697ece8318fa5138d0b"
    "992e1ecd01513d4ce5286e095531aaa5225d72f42d07c24d403cdf0123b97837f51a653234e68671"
    "9d04ef84085bbd021a99eba601009a73906d8fa207a0d097d3da456181353d14f9c4c05f6adc0b96"
    "1ab09fe32aeabd2ad698c79b71ab3b740f3cdbb260be5a4b4e18e9db2a735c8961659efeed3ca6cb"
    "4e6fe49ef90046b3ff194d2a63b38e66c6188570c750656f3b74e548830f08585d2d239d5ea3fee8"
    "db00a1d2f4e3194df2ee7af6279ee5cd9c2da2f27f9c17adef133739d1b4c82c41d686c0e9ec21f8"
    "591b7fb93a7c9f5c019d6204c228bd0aad3cca10ec1b0203010001a381f83081f5300e0603551d0f"
    "0101ff040403020186301d0603551d250416301406082b0601050507030206082b06010505070301"
    "30120603551d130101ff040830060101ff020100301d0603551d0e0416041400b529f22d8e6f31e8"
    "9b4cad783efadce90cd1d2301f0603551d2304183016801479b459e67bb6e5e40173800888c81a58"
    "f6e99b6e303206082b0601050507010104263024302206082b060105050730028616687474703a2f"
    "2f78312e692e6c656e63722e6f72672f30130603551d20040c300a3008060667810c010201302706"
    "03551d1f0420301e301ca01aa0188616687474703a2f2f78312e632e6c656e63722e6f72672f300d"
    "06092a864886f70d01010b050003820201008f75d009cf6a7648653292deb544c88576f415848c02"
    "bf76ebb3f1e2f96e84a85691e1924bf7e1ea0078488f7592e3e4467b1b602b20afa0ce14e5450d6a"
    "e05286a4f3da1414a9a95ff16d46f952501740e9e41e7de61558fea98bfceff59e63e066e2c3773b"
    "1f01872694ed4010dcb799ecdd57d35c7141ee30200004dc954b5028879992feaa8094b6060814f8"
    "1c837e7440c5085a0c4f5cd1849dc4fddb59deee796e234d95f292d498296a5ceb02c142f0f8f54e"
    "64207ba8e331c4c06809478bd8b978a0ca4e4abe69242a4b377b51036b3a3f528bb3d4d2ad584e93"
    "eecb5f6f0d314948bac43f9f12c9203d11840785b4f8f23823ac710040e77f8d4634826a4ecfe00e"
    "635fba699a47091022fe4b48b7917554cb931ee416eb53cf7bde364dbff6b1ebe64ae9333c8d69a2"
    "98bea87fa3ab5fb654e84d96a9acf3b05acb1b7a3693249bce5852809f350a5e2dbf749b6226179c"
    "9131290bf37fcdc3628b68c777f47f0bfbc659f503664ba6509bd0efa5fc02b4604d034b614fc520"
    "078b48b031f5b69cd1c9ad7718dcb2c70fbee04608dee04bdeb9b8b6c716be36693f86684b748113"
    "8950c56a7a02acc548a50e7d5d61e4cdd166a075c7055ee889b5631923bb50b490ecc275373e75a6"
    "1b83252800214ec0d33acb9ceac08ff75fae51164610af0206eec0b657d40dac8cd8d7a0f3876ec3"
    "e2cbe94ed4a17cfd763b"
)


def main(use_stream=True):
    s = socket.socket()
    ai = socket.getaddrinfo("micropython.org", 443)
    addr = ai[0][-1]
    s.connect(addr)
    s = ssl.wrap_socket(
        s, cert_reqs=ssl.CERT_REQUIRED, cadata=ca_cert_chain, server_hostname="micropython.org"
    )
    s.write(b"GET / HTTP/1.0\r\n\r\n")
    print(s.read(17))
    s.close()


main()
