/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModalityUtilsKt;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.resolve.AnnotationChecker;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.Compatibility;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.ModifierCheckerHelpersKt;
import org.jetbrains.kotlin.resolve.TargetAllowedPredicate;
import org.jetbrains.kotlin.resolve.calls.checkers.CoroutineCallCheckerKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rJ8\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\t2\b\u0010\u0014\u001a\u0004\u0018\u00010\u000b2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\f\u001a\u00020\rH\u0002J6\u0010\u0018\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001a0\u001fH\u0002J&\u0010 \u001a\u00020!2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\"\u001a\u00020\u001a2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0002J*\u0010#\u001a\u00020!2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\"\u001a\u00020\u001a2\b\u0010\u0014\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J.\u0010$\u001a\u00020!2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\"\u001a\u00020\u001a2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0002J\u0012\u0010%\u001a\u00020!2\b\u0010&\u001a\u0004\u0018\u00010\u000bH\u0002R\u0013\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/resolve/ModifierCheckerCore;", "", "<init>", "()V", "check", "", "listOwner", "Lorg/jetbrains/kotlin/psi/KtModifierListOwner;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "MODIFIER_KEYWORD_SET", "Lcom/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "checkModifierList", "list", "Lorg/jetbrains/kotlin/psi/KtModifierList;", "parentDescriptor", "actualTargets", "", "Lorg/jetbrains/kotlin/descriptors/annotations/KotlinTarget;", "checkCompatibility", "firstNode", "Lcom/intellij/lang/ASTNode;", "secondNode", "owner", "Lcom/intellij/psi/PsiElement;", "incorrectNodes", "", "checkTarget", "", "node", "checkParent", "checkLanguageLevelSupport", "isFinalExpectClass", "d", "frontend"})
@SourceDebugExtension(value={"SMAP\nModifiersChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModifiersChecker.kt\norg/jetbrains/kotlin/resolve/ModifierCheckerCore\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,253:1\n1807#2,3:254\n1807#2,3:257\n1807#2,3:260\n1807#2,3:263\n1807#2,3:266\n*S KotlinDebug\n*F\n+ 1 ModifiersChecker.kt\norg/jetbrains/kotlin/resolve/ModifierCheckerCore\n*L\n121#1:254,3\n128#1:257,3\n136#1:260,3\n170#1:263,3\n190#1:266,3\n*E\n"})
public final class ModifierCheckerCore {
    @NotNull
    public static final ModifierCheckerCore INSTANCE = new ModifierCheckerCore();
    @NotNull
    private static final TokenSet MODIFIER_KEYWORD_SET;

    private ModifierCheckerCore() {
    }

    public final void check(@NotNull KtModifierListOwner listOwner, @NotNull BindingTrace trace, @Nullable DeclarationDescriptor descriptor, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkNotNullParameter(listOwner, "listOwner");
        Intrinsics.checkNotNullParameter(trace, "trace");
        Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
        if (listOwner instanceof KtDeclarationWithBody) {
            for (KtParameter parameter : ((KtDeclarationWithBody)listOwner).getValueParameters()) {
                if (parameter.hasValOrVar()) continue;
                Intrinsics.checkNotNull(parameter);
                this.check(parameter, trace, (DeclarationDescriptor)trace.get(BindingContext.VALUE_PARAMETER, parameter), languageVersionSettings);
            }
        }
        KtElement ktElement = listOwner;
        ClassDescriptor classDescriptor = descriptor instanceof ClassDescriptor ? (ClassDescriptor)descriptor : null;
        BindingContext bindingContext = trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue(bindingContext, "getBindingContext(...)");
        List<KotlinTarget> actualTargets = AnnotationChecker.Companion.getDeclarationSiteActualTargetList(ktElement, classDescriptor, bindingContext);
        KtModifierList ktModifierList = listOwner.getModifierList();
        if (ktModifierList == null) {
            return;
        }
        KtModifierList list = ktModifierList;
        DeclarationDescriptor declarationDescriptor = descriptor;
        this.checkModifierList(list, trace, declarationDescriptor != null ? declarationDescriptor.getContainingDeclaration() : null, actualTargets, languageVersionSettings);
    }

    private final void checkModifierList(KtModifierList list, BindingTrace trace, DeclarationDescriptor parentDescriptor, List<? extends KotlinTarget> actualTargets, LanguageVersionSettings languageVersionSettings) {
        if (list.getStub() != null) {
            return;
        }
        HashSet incorrectNodes = new HashSet();
        ASTNode[] aSTNodeArray = list.getNode().getChildren(MODIFIER_KEYWORD_SET);
        Intrinsics.checkNotNullExpressionValue(aSTNodeArray, "getChildren(...)");
        ASTNode[] children = aSTNodeArray;
        int n2 = children.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            ASTNode first;
            ASTNode second = children[i2];
            int n3 = children.length;
            for (int i3 = 0; i3 < n3 && !Intrinsics.areEqual(first = children[i3], second); ++i3) {
                Intrinsics.checkNotNull(first);
                Intrinsics.checkNotNull(second);
                PsiElement psiElement = list.getOwner();
                Intrinsics.checkNotNullExpressionValue(psiElement, "getOwner(...)");
                this.checkCompatibility(trace, first, second, psiElement, incorrectNodes);
            }
            if (incorrectNodes.contains(second)) continue;
            Intrinsics.checkNotNull(second);
            if (!this.checkTarget(trace, second, actualTargets)) {
                ((Collection)incorrectNodes).add(second);
                continue;
            }
            if (!this.checkParent(trace, second, parentDescriptor, languageVersionSettings)) {
                ((Collection)incorrectNodes).add(second);
                continue;
            }
            if (this.checkLanguageLevelSupport(trace, second, languageVersionSettings, actualTargets)) continue;
            ((Collection)incorrectNodes).add(second);
        }
    }

    private final void checkCompatibility(BindingTrace trace, ASTNode firstNode, ASTNode secondNode, PsiElement owner, Set<ASTNode> incorrectNodes) {
        IElementType iElementType = firstNode.getElementType();
        Intrinsics.checkNotNull(iElementType, "null cannot be cast to non-null type org.jetbrains.kotlin.lexer.KtModifierKeywordToken");
        KtModifierKeywordToken firstModifier = (KtModifierKeywordToken)iElementType;
        IElementType iElementType2 = secondNode.getElementType();
        Intrinsics.checkNotNull(iElementType2, "null cannot be cast to non-null type org.jetbrains.kotlin.lexer.KtModifierKeywordToken");
        KtModifierKeywordToken secondModifier = (KtModifierKeywordToken)iElementType2;
        Compatibility compatibility = ModifierCheckerHelpersKt.compatibility(firstModifier, secondModifier);
        switch (WhenMappings.$EnumSwitchMapping$0[compatibility.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                if (!incorrectNodes.add(secondNode)) break;
                trace.report(Errors.REPEATED_MODIFIER.on(secondNode.getPsi(), firstModifier));
                break;
            }
            case 3: {
                trace.report(Errors.REDUNDANT_MODIFIER.on(secondNode.getPsi(), secondModifier, firstModifier));
                break;
            }
            case 4: {
                trace.report(Errors.REDUNDANT_MODIFIER.on(firstNode.getPsi(), firstModifier, secondModifier));
                break;
            }
            case 5: {
                trace.report(Errors.DEPRECATED_MODIFIER_PAIR.on(firstNode.getPsi(), firstModifier, secondModifier));
                trace.report(Errors.DEPRECATED_MODIFIER_PAIR.on(secondNode.getPsi(), secondModifier, firstModifier));
                break;
            }
            case 6: 
            case 7: {
                if (compatibility == Compatibility.COMPATIBLE_FOR_CLASSES_ONLY && owner instanceof KtClassOrObject) {
                    return;
                }
                if (incorrectNodes.add(firstNode)) {
                    trace.report(Errors.INCOMPATIBLE_MODIFIERS.on(firstNode.getPsi(), firstModifier, secondModifier));
                }
                if (!incorrectNodes.add(secondNode)) break;
                trace.report(Errors.INCOMPATIBLE_MODIFIERS.on(secondNode.getPsi(), secondModifier, firstModifier));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private final boolean checkTarget(BindingTrace trace, ASTNode node, List<? extends KotlinTarget> actualTargets) {
        KotlinTarget it;
        boolean bl;
        boolean $i$f$any;
        Iterable $this$any$iv;
        Set<KotlinTarget> redundantTargets;
        KtModifierKeywordToken modifier;
        block19: {
            Set<KotlinTarget> set;
            Set<KotlinTarget> deprecatedTargets;
            boolean bl2;
            block18: {
                IElementType iElementType = node.getElementType();
                Intrinsics.checkNotNull(iElementType, "null cannot be cast to non-null type org.jetbrains.kotlin.lexer.KtModifierKeywordToken");
                modifier = (KtModifierKeywordToken)iElementType;
                EnumSet<KotlinTarget> enumSet = ModifierCheckerHelpersKt.getPossibleTargetMap().get(modifier);
                Set possibleTargets = enumSet != null ? (Set)enumSet : SetsKt.emptySet();
                Iterable $this$any$iv2 = actualTargets;
                boolean $i$f$any2 = false;
                if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv2) {
                        KotlinTarget it2 = (KotlinTarget)((Object)element$iv);
                        boolean bl3 = false;
                        if (!possibleTargets.contains((Object)it2)) continue;
                        bl2 = true;
                        break block18;
                    }
                    bl2 = false;
                }
            }
            if (!bl2) {
                PsiElement psiElement = node.getPsi();
                Object object = CollectionsKt.firstOrNull(actualTargets);
                if (object == null || (object = object.getDescription()) == null) {
                    object = "this";
                }
                trace.report(Errors.WRONG_MODIFIER_TARGET.on(psiElement, modifier, (String)object));
                return false;
            }
            Set<KotlinTarget> set2 = ModifierCheckerHelpersKt.getDeprecatedTargetMap().get(modifier);
            if (set2 == null) {
                set2 = deprecatedTargets = SetsKt.emptySet();
            }
            if ((set = ModifierCheckerHelpersKt.getRedundantTargetMap().get(modifier)) == null) {
                set = SetsKt.emptySet();
            }
            redundantTargets = set;
            $this$any$iv = actualTargets;
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (KotlinTarget)((Object)element$iv);
                    boolean bl4 = false;
                    if (!deprecatedTargets.contains((Object)it)) continue;
                    bl = true;
                    break block19;
                }
                bl = false;
            }
        }
        if (bl) {
            PsiElement psiElement = node.getPsi();
            Object object = CollectionsKt.firstOrNull(actualTargets);
            if (object == null || (object = object.getDescription()) == null) {
                object = "this";
            }
            trace.report(Errors.DEPRECATED_MODIFIER_FOR_TARGET.on(psiElement, modifier, (String)object));
        } else {
            boolean bl5;
            block20: {
                $this$any$iv = actualTargets;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl5 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (KotlinTarget)((Object)element$iv);
                        boolean bl6 = false;
                        if (!redundantTargets.contains((Object)it)) continue;
                        bl5 = true;
                        break block20;
                    }
                    bl5 = false;
                }
            }
            if (bl5) {
                PsiElement psiElement = node.getPsi();
                Object object = CollectionsKt.firstOrNull(actualTargets);
                if (object == null || (object = object.getDescription()) == null) {
                    object = "this";
                }
                trace.report(Errors.REDUNDANT_MODIFIER_FOR_TARGET.on(psiElement, modifier, (String)object));
            }
        }
        return true;
    }

    private final boolean checkParent(BindingTrace trace, ASTNode node, DeclarationDescriptor parentDescriptor, LanguageVersionSettings languageVersionSettings) {
        boolean bl;
        List<KotlinTarget> actualParents;
        KtModifierKeywordToken modifier;
        block16: {
            List<KotlinTarget> list;
            IElementType iElementType = node.getElementType();
            Intrinsics.checkNotNull(iElementType, "null cannot be cast to non-null type org.jetbrains.kotlin.lexer.KtModifierKeywordToken");
            modifier = (KtModifierKeywordToken)iElementType;
            DeclarationDescriptor declarationDescriptor = parentDescriptor;
            if (declarationDescriptor instanceof ClassDescriptor) {
                ClassKind classKind = ((ClassDescriptor)parentDescriptor).getKind();
                Intrinsics.checkNotNullExpressionValue((Object)classKind, "getKind(...)");
                list = KotlinTarget.Companion.classActualTargets(classKind, ((ClassDescriptor)parentDescriptor).isInner(), ((ClassDescriptor)parentDescriptor).isCompanionObject(), DescriptorUtils.isLocal(parentDescriptor));
            } else {
                list = declarationDescriptor instanceof PropertySetterDescriptor ? KotlinTarget.Companion.getPROPERTY_SETTER_LIST() : (declarationDescriptor instanceof PropertyGetterDescriptor ? KotlinTarget.Companion.getPROPERTY_GETTER_LIST() : (declarationDescriptor instanceof FunctionDescriptor ? KotlinTarget.Companion.getFUNCTION_LIST() : KotlinTarget.Companion.getFILE_LIST()));
            }
            actualParents = list;
            Set<KotlinTarget> deprecatedParents = ModifierCheckerHelpersKt.getDeprecatedParentTargetMap().get(modifier);
            if (deprecatedParents != null) {
                boolean bl2;
                block15: {
                    Iterable $this$any$iv = actualParents;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            KotlinTarget it = (KotlinTarget)((Object)element$iv);
                            boolean bl3 = false;
                            if (!deprecatedParents.contains((Object)it)) continue;
                            bl2 = true;
                            break block15;
                        }
                        bl2 = false;
                    }
                }
                if (bl2) {
                    PsiElement psiElement = node.getPsi();
                    Object object = CollectionsKt.firstOrNull(actualParents);
                    if (object == null || (object = object.getDescription()) == null) {
                        object = "this scope";
                    }
                    trace.report(Errors.DEPRECATED_MODIFIER_CONTAINING_DECLARATION.on(psiElement, modifier, (String)object));
                    return true;
                }
            }
            if (Intrinsics.areEqual(modifier, KtTokens.PROTECTED_KEYWORD) && this.isFinalExpectClass(parentDescriptor)) {
                trace.report(Errors.WRONG_MODIFIER_CONTAINING_DECLARATION.on(node.getPsi(), modifier, "final expect class"));
            }
            TargetAllowedPredicate targetAllowedPredicate = ModifierCheckerHelpersKt.getPossibleParentTargetPredicateMap().get(modifier);
            if (targetAllowedPredicate == null) {
                return true;
            }
            TargetAllowedPredicate possibleParentPredicate = targetAllowedPredicate;
            Iterable $this$any$iv = actualParents;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KotlinTarget it = (KotlinTarget)((Object)element$iv);
                    boolean bl4 = false;
                    if (!possibleParentPredicate.isAllowed(it, languageVersionSettings)) continue;
                    bl = true;
                    break block16;
                }
                bl = false;
            }
        }
        if (bl) {
            return true;
        }
        PsiElement psiElement = node.getPsi();
        Object object = CollectionsKt.firstOrNull(actualParents);
        if (object == null || (object = object.getDescription()) == null) {
            object = "this scope";
        }
        trace.report(Errors.WRONG_MODIFIER_CONTAINING_DECLARATION.on(psiElement, modifier, (String)object));
        return false;
    }

    private final boolean checkLanguageLevelSupport(BindingTrace trace, ASTNode node, LanguageVersionSettings languageVersionSettings, List<? extends KotlinTarget> actualTargets) {
        IElementType iElementType = node.getElementType();
        Intrinsics.checkNotNull(iElementType, "null cannot be cast to non-null type org.jetbrains.kotlin.lexer.KtModifierKeywordToken");
        KtModifierKeywordToken modifier = (KtModifierKeywordToken)iElementType;
        List<LanguageFeature> list = ModifierCheckerHelpersKt.getFeatureDependencies().get(modifier);
        if (list == null) {
            return true;
        }
        List<LanguageFeature> dependencies = list;
        block4: for (LanguageFeature dependency : dependencies) {
            Set<KotlinTarget> restrictedTargets = ModifierCheckerHelpersKt.getFeatureDependenciesTargets().get((Object)dependency);
            if (restrictedTargets != null && CollectionsKt.intersect((Iterable)actualTargets, (Iterable)restrictedTargets).isEmpty()) continue;
            if (dependency == LanguageFeature.Coroutines) {
                DiagnosticSink diagnosticSink = trace;
                PsiElement psiElement = node.getPsi();
                Intrinsics.checkNotNullExpressionValue(psiElement, "getPsi(...)");
                CoroutineCallCheckerKt.checkCoroutinesFeature(languageVersionSettings, diagnosticSink, psiElement);
                continue;
            }
            if (dependency == LanguageFeature.InlineClasses && languageVersionSettings.supportsFeature(LanguageFeature.JvmInlineValueClasses)) {
                trace.report(Errors.INLINE_CLASS_DEPRECATED.on(node.getPsi()));
                continue;
            }
            LanguageFeature.State featureSupport = languageVersionSettings.getFeatureSupport(dependency);
            if (dependency == LanguageFeature.MultiPlatformProjects && featureSupport == LanguageFeature.State.DISABLED) {
                trace.report(Errors.NOT_A_MULTIPLATFORM_COMPILATION.on(node.getPsi()));
                continue;
            }
            Pair<LanguageFeature, LanguageVersionSettings> diagnosticData = TuplesKt.to(dependency, languageVersionSettings);
            switch (WhenMappings.$EnumSwitchMapping$1[featureSupport.ordinal()]) {
                case 1: {
                    trace.report(Errors.UNSUPPORTED_FEATURE.on(node.getPsi(), diagnosticData));
                    return false;
                }
                case 2: {
                    continue block4;
                }
            }
            throw new NoWhenBranchMatchedException();
        }
        return true;
    }

    private final boolean isFinalExpectClass(DeclarationDescriptor d2) {
        return d2 instanceof ClassDescriptor && ModalityUtilsKt.isFinalOrEnum((ClassDescriptor)d2) && ((ClassDescriptor)d2).isExpect();
    }

    static {
        TokenSet[] tokenSetArray = new TokenSet[2];
        tokenSetArray[0] = KtTokens.SOFT_KEYWORDS;
        IElementType[] iElementTypeArray = new IElementType[]{KtTokens.IN_KEYWORD, KtTokens.FUN_KEYWORD};
        tokenSetArray[1] = TokenSet.create(iElementTypeArray);
        TokenSet tokenSet = TokenSet.orSet(tokenSetArray);
        Intrinsics.checkNotNullExpressionValue(tokenSet, "orSet(...)");
        MODIFIER_KEYWORD_SET = tokenSet;
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[Compatibility.values().length];
            try {
                nArray[Compatibility.COMPATIBLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Compatibility.REPEATED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Compatibility.REDUNDANT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Compatibility.REVERSE_REDUNDANT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Compatibility.DEPRECATED.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Compatibility.COMPATIBLE_FOR_CLASSES_ONLY.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Compatibility.INCOMPATIBLE.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[LanguageFeature.State.values().length];
            try {
                nArray[LanguageFeature.State.DISABLED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LanguageFeature.State.ENABLED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

