/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.fixStack;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.InsnSequence;
import org.jetbrains.kotlin.codegen.inline.InlineCodegenUtilsKt;
import org.jetbrains.kotlin.codegen.optimization.fixStack.FixStackAnalyzer;
import org.jetbrains.kotlin.codegen.optimization.fixStack.FixStackContext;
import org.jetbrains.kotlin.codegen.optimization.fixStack.FixStackValue;
import org.jetbrains.kotlin.codegen.optimization.fixStack.LocalVariablesManager;
import org.jetbrains.kotlin.codegen.optimization.fixStack.SavedStackDescriptor;
import org.jetbrains.kotlin.codegen.optimization.fixStack.StackTransformationUtilsKt;
import org.jetbrains.kotlin.codegen.optimization.transformer.MethodTransformer;
import org.jetbrains.kotlin.codegen.pseudoInsns.PseudoInsn;
import org.jetbrains.kotlin.codegen.pseudoInsns.PseudoInsnsKt;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.JumpInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LabelNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\r\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\tH\u0002J4\u0010\u0010\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\f2\u0012\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J4\u0010\u0017\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J<\u0010\u0018\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J4\u0010\u001d\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00140\u00132\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J<\u0010\u001e\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J<\u0010 \u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackMethodTransformer;", "Lorg/jetbrains/kotlin/codegen/optimization/transformer/MethodTransformer;", "<init>", "()V", "transform", "", "internalClassName", "", "methodNode", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "analyzeAndTransformBreakContinueGotos", "context", "Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackContext;", "analyzeAndTransformSaveRestoreStack", "removeAlwaysFalseIfeqMarkers", "removeAlwaysTrueIfeqMarkers", "transformBreakContinueGotos", "fixStackContext", "actions", "", "Lkotlin/Function0;", "analyzer", "Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackAnalyzer;", "transformSaveRestoreStackMarkers", "transformSaveStackMarker", "marker", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "localVariablesManager", "Lorg/jetbrains/kotlin/codegen/optimization/fixStack/LocalVariablesManager;", "transformRestoreStackMarker", "transformAfterInlineCallMarker", "inlineMarker", "transformBeforeInlineCallMarker", "backend"})
@SourceDebugExtension(value={"SMAP\nFixStackMethodTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FixStackMethodTransformer.kt\norg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackMethodTransformer\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,228:1\n1342#2,2:229\n1342#2,2:241\n1342#2,2:243\n1915#3,2:231\n1915#3,2:233\n1915#3,2:235\n1915#3,2:237\n1915#3,2:239\n*S KotlinDebug\n*F\n+ 1 FixStackMethodTransformer.kt\norg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackMethodTransformer\n*L\n37#1:229,2\n127#1:241,2\n139#1:243,2\n63#1:231,2\n74#1:233,2\n78#1:235,2\n85#1:237,2\n97#1:239,2\n*E\n"})
public final class FixStackMethodTransformer
extends MethodTransformer {
    @Override
    public void transform(@NotNull String internalClassName, @NotNull MethodNode methodNode) {
        Intrinsics.checkNotNullParameter(internalClassName, "internalClassName");
        Intrinsics.checkNotNullParameter(methodNode, "methodNode");
        FixStackContext context2 = new FixStackContext(methodNode);
        if (!context2.hasAnyMarkers()) {
            return;
        }
        if (!context2.getConsistentInlineMarkers()) {
            InsnList insnList = methodNode.instructions;
            Intrinsics.checkNotNullExpressionValue(insnList, "instructions");
            Sequence $this$forEach$iv = new InsnSequence(insnList);
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv = iterator2.next();
                AbstractInsnNode insnNode = (AbstractInsnNode)element$iv;
                boolean bl = false;
                if (!InlineCodegenUtilsKt.isInlineMarker(insnNode)) continue;
                methodNode.instructions.remove(insnNode);
            }
        }
        if (context2.isAnalysisRequired()) {
            this.analyzeAndTransformBreakContinueGotos(context2, internalClassName, methodNode);
            this.removeAlwaysFalseIfeqMarkers(context2, methodNode);
            this.analyzeAndTransformSaveRestoreStack(context2, internalClassName, methodNode);
        }
        this.removeAlwaysTrueIfeqMarkers(context2, methodNode);
        this.removeAlwaysFalseIfeqMarkers(context2, methodNode);
    }

    private final void analyzeAndTransformBreakContinueGotos(FixStackContext context2, String internalClassName, MethodNode methodNode) {
        FixStackAnalyzer analyzer2 = new FixStackAnalyzer(internalClassName, methodNode, context2, true);
        analyzer2.analyze();
        methodNode.maxStack += analyzer2.getMaxExtraStackSize();
        ArrayList actions = new ArrayList();
        this.transformBreakContinueGotos(methodNode, context2, actions, analyzer2);
        Iterable $this$forEach$iv = actions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function0 it = (Function0)element$iv;
            boolean bl = false;
            it.invoke();
        }
    }

    private final void analyzeAndTransformSaveRestoreStack(FixStackContext context2, String internalClassName, MethodNode methodNode) {
        FixStackAnalyzer analyzer2 = new FixStackAnalyzer(internalClassName, methodNode, context2, false);
        analyzer2.analyze();
        ArrayList actions = new ArrayList();
        this.transformSaveRestoreStackMarkers(methodNode, context2, actions, analyzer2);
        Iterable $this$forEach$iv = actions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function0 it = (Function0)element$iv;
            boolean bl = false;
            it.invoke();
        }
    }

    private final void removeAlwaysFalseIfeqMarkers(FixStackContext context2, MethodNode methodNode) {
        Iterable $this$forEach$iv = context2.getFakeAlwaysFalseIfeqMarkers();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AbstractInsnNode marker = (AbstractInsnNode)element$iv;
            boolean bl = false;
            StackTransformationUtilsKt.removeAlwaysFalseIfeq(methodNode, marker);
        }
        context2.getFakeAlwaysFalseIfeqMarkers().clear();
    }

    private final void removeAlwaysTrueIfeqMarkers(FixStackContext context2, MethodNode methodNode) {
        Iterable $this$forEach$iv = context2.getFakeAlwaysTrueIfeqMarkers();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AbstractInsnNode marker = (AbstractInsnNode)element$iv;
            boolean bl = false;
            StackTransformationUtilsKt.replaceAlwaysTrueIfeqWithGoto(methodNode, marker);
        }
        context2.getFakeAlwaysTrueIfeqMarkers().clear();
    }

    private final void transformBreakContinueGotos(MethodNode methodNode, FixStackContext fixStackContext, List<Function0<Unit>> actions, FixStackAnalyzer analyzer2) {
        Iterable $this$forEach$iv = fixStackContext.getBreakContinueGotoNodes();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean bl;
            JumpInsnNode gotoNode = (JumpInsnNode)element$iv;
            boolean bl2 = false;
            int gotoIndex = methodNode.instructions.indexOf(gotoNode);
            int labelIndex = methodNode.instructions.indexOf(gotoNode.label);
            int actualStackSize = analyzer2.getActualStackSize(gotoNode);
            LabelNode labelNode = gotoNode.label;
            Intrinsics.checkNotNullExpressionValue(labelNode, "label");
            int expectedStackSize = analyzer2.getExpectedStackSize(labelNode);
            if (actualStackSize >= 0 && expectedStackSize >= 0) {
                List<FixStackValue> actualStackContent;
                boolean bl3;
                boolean bl4 = bl3 = expectedStackSize <= actualStackSize;
                if (_Assertions.ENABLED && !bl3) {
                    boolean bl5 = false;
                    String string = "Label at " + labelIndex + ", jump at " + gotoIndex + ": stack underflow: " + expectedStackSize + " > " + actualStackSize;
                    throw new AssertionError((Object)string);
                }
                if (analyzer2.getActualStack(gotoNode) == null) {
                    throw new AssertionError((Object)("Jump at " + gotoIndex + " should be alive"));
                }
                bl = actions.add(() -> FixStackMethodTransformer.transformBreakContinueGotos$lambda$0$1(methodNode, gotoNode, expectedStackSize, actualStackContent));
                continue;
            }
            if (actualStackSize >= 0 && expectedStackSize < 0) {
                throw new AssertionError((Object)("Live jump " + gotoIndex + " to dead label " + labelIndex));
            }
            AbstractInsnNode marker = gotoNode.getPrevious();
            bl = actions.add(() -> FixStackMethodTransformer.transformBreakContinueGotos$lambda$0$2(methodNode, marker));
        }
    }

    private final void transformSaveRestoreStackMarkers(MethodNode methodNode, FixStackContext context2, List<Function0<Unit>> actions, FixStackAnalyzer analyzer2) {
        PseudoInsn pseudoInsn;
        AbstractInsnNode marker;
        Object element$iv;
        LocalVariablesManager localVariablesManager = new LocalVariablesManager(context2, methodNode);
        InsnList insnList = methodNode.instructions;
        Intrinsics.checkNotNullExpressionValue(insnList, "instructions");
        Sequence $this$forEach$iv = new InsnSequence(insnList);
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            element$iv = iterator2.next();
            marker = (AbstractInsnNode)element$iv;
            boolean bl = false;
            pseudoInsn = PseudoInsnsKt.parsePseudoInsnOrNull(marker);
            if (pseudoInsn == PseudoInsn.SAVE_STACK_BEFORE_TRY) {
                this.transformSaveStackMarker(methodNode, actions, analyzer2, marker, localVariablesManager);
                continue;
            }
            if (InlineCodegenUtilsKt.isBeforeInlineMarker(marker)) {
                this.transformBeforeInlineCallMarker(methodNode, actions, analyzer2, marker, localVariablesManager);
                continue;
            }
            if (!InlineCodegenUtilsKt.isAfterInlineMarker(marker)) continue;
            this.transformAfterInlineCallMarker(methodNode, actions, analyzer2, marker, localVariablesManager);
        }
        InsnList insnList2 = methodNode.instructions;
        Intrinsics.checkNotNullExpressionValue(insnList2, "instructions");
        $this$forEach$iv = new InsnSequence(insnList2);
        $i$f$forEach = false;
        iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            element$iv = iterator2.next();
            marker = (AbstractInsnNode)element$iv;
            boolean bl = false;
            pseudoInsn = PseudoInsnsKt.parsePseudoInsnOrNull(marker);
            if (pseudoInsn != PseudoInsn.RESTORE_STACK_IN_TRY_CATCH) continue;
            this.transformRestoreStackMarker(methodNode, actions, marker, localVariablesManager);
        }
    }

    private final void transformSaveStackMarker(MethodNode methodNode, List<Function0<Unit>> actions, FixStackAnalyzer analyzer2, AbstractInsnNode marker, LocalVariablesManager localVariablesManager) {
        boolean bl;
        List<FixStackValue> savedStackValues = analyzer2.getStackToSpill(marker);
        if (savedStackValues != null) {
            SavedStackDescriptor savedStackDescriptor = localVariablesManager.allocateVariablesForSaveStackMarker(marker, savedStackValues);
            bl = actions.add(() -> FixStackMethodTransformer.transformSaveStackMarker$lambda$0(methodNode, marker, savedStackDescriptor));
        } else {
            localVariablesManager.allocateVariablesForSaveStackMarker(marker, CollectionsKt.emptyList());
            bl = actions.add(() -> FixStackMethodTransformer.transformSaveStackMarker$lambda$1(methodNode, marker));
        }
    }

    private final void transformRestoreStackMarker(MethodNode methodNode, List<Function0<Unit>> actions, AbstractInsnNode marker, LocalVariablesManager localVariablesManager) {
        SavedStackDescriptor savedStackDescriptor = localVariablesManager.getSavedStackDescriptor(marker);
        actions.add(() -> FixStackMethodTransformer.transformRestoreStackMarker$lambda$0(methodNode, marker, savedStackDescriptor));
        localVariablesManager.markRestoreStackMarkerEmitted(marker);
    }

    private final void transformAfterInlineCallMarker(MethodNode methodNode, List<Function0<Unit>> actions, FixStackAnalyzer analyzer2, AbstractInsnNode inlineMarker, LocalVariablesManager localVariablesManager) {
        block5: {
            boolean bl;
            block4: {
                SavedStackDescriptor savedStackDescriptor = localVariablesManager.getBeforeInlineDescriptor(inlineMarker);
                List<FixStackValue> stackContentAfterInline = analyzer2.getActualStack(inlineMarker);
                if (stackContentAfterInline == null || !savedStackDescriptor.isNotEmpty()) break block4;
                switch (stackContentAfterInline.size()) {
                    case 1: {
                        FixStackValue returnValue = CollectionsKt.last(stackContentAfterInline);
                        int returnValueLocalVarIndex = localVariablesManager.createReturnValueVariable(returnValue);
                        bl = actions.add(() -> FixStackMethodTransformer.transformAfterInlineCallMarker$lambda$0(methodNode, inlineMarker, savedStackDescriptor, returnValue, returnValueLocalVarIndex));
                        break block5;
                    }
                    case 0: {
                        bl = actions.add(() -> FixStackMethodTransformer.transformAfterInlineCallMarker$lambda$1(methodNode, inlineMarker, savedStackDescriptor));
                        break block5;
                    }
                    default: {
                        throw new AssertionError((Object)"Inline method should not leave more than 1 value on stack");
                    }
                }
            }
            bl = actions.add(() -> FixStackMethodTransformer.transformAfterInlineCallMarker$lambda$2(methodNode, inlineMarker));
        }
        localVariablesManager.markAfterInlineMarkerEmitted(inlineMarker);
    }

    private final void transformBeforeInlineCallMarker(MethodNode methodNode, List<Function0<Unit>> actions, FixStackAnalyzer analyzer2, AbstractInsnNode inlineMarker, LocalVariablesManager localVariablesManager) {
        boolean bl;
        List<FixStackValue> savedStackValues = analyzer2.getStackToSpill(inlineMarker);
        if (savedStackValues != null) {
            SavedStackDescriptor savedStackDescriptor = localVariablesManager.allocateVariablesForBeforeInlineMarker(inlineMarker, savedStackValues);
            bl = actions.add(() -> FixStackMethodTransformer.transformBeforeInlineCallMarker$lambda$0(methodNode, inlineMarker, savedStackDescriptor));
        } else {
            localVariablesManager.allocateVariablesForBeforeInlineMarker(inlineMarker, CollectionsKt.emptyList());
            bl = actions.add(() -> FixStackMethodTransformer.transformBeforeInlineCallMarker$lambda$1(methodNode, inlineMarker));
        }
    }

    private static final Unit transformBreakContinueGotos$lambda$0$1(MethodNode $methodNode, JumpInsnNode $gotoNode, int $expectedStackSize, List $actualStackContent) {
        AbstractInsnNode abstractInsnNode = $gotoNode.getPrevious();
        Intrinsics.checkNotNullExpressionValue(abstractInsnNode, "getPrevious(...)");
        StackTransformationUtilsKt.replaceMarkerWithPops($methodNode, abstractInsnNode, $expectedStackSize, $actualStackContent);
        return Unit.INSTANCE;
    }

    private static final Unit transformBreakContinueGotos$lambda$0$2(MethodNode $methodNode, AbstractInsnNode $marker) {
        $methodNode.instructions.remove($marker);
        return Unit.INSTANCE;
    }

    private static final Unit transformSaveStackMarker$lambda$0(MethodNode $methodNode, AbstractInsnNode $marker, SavedStackDescriptor $savedStackDescriptor) {
        StackTransformationUtilsKt.saveStack($methodNode, $marker, $savedStackDescriptor);
        return Unit.INSTANCE;
    }

    private static final Unit transformSaveStackMarker$lambda$1(MethodNode $methodNode, AbstractInsnNode $marker) {
        $methodNode.instructions.remove($marker);
        return Unit.INSTANCE;
    }

    private static final Unit transformRestoreStackMarker$lambda$0(MethodNode $methodNode, AbstractInsnNode $marker, SavedStackDescriptor $savedStackDescriptor) {
        StackTransformationUtilsKt.restoreStack($methodNode, $marker, $savedStackDescriptor);
        return Unit.INSTANCE;
    }

    private static final Unit transformAfterInlineCallMarker$lambda$0(MethodNode $methodNode, AbstractInsnNode $inlineMarker, SavedStackDescriptor $savedStackDescriptor, FixStackValue $returnValue, int $returnValueLocalVarIndex) {
        StackTransformationUtilsKt.restoreStackWithReturnValue($methodNode, $inlineMarker, $savedStackDescriptor, $returnValue, $returnValueLocalVarIndex);
        return Unit.INSTANCE;
    }

    private static final Unit transformAfterInlineCallMarker$lambda$1(MethodNode $methodNode, AbstractInsnNode $inlineMarker, SavedStackDescriptor $savedStackDescriptor) {
        StackTransformationUtilsKt.restoreStack($methodNode, $inlineMarker, $savedStackDescriptor);
        return Unit.INSTANCE;
    }

    private static final Unit transformAfterInlineCallMarker$lambda$2(MethodNode $methodNode, AbstractInsnNode $inlineMarker) {
        $methodNode.instructions.remove($inlineMarker);
        return Unit.INSTANCE;
    }

    private static final Unit transformBeforeInlineCallMarker$lambda$0(MethodNode $methodNode, AbstractInsnNode $inlineMarker, SavedStackDescriptor $savedStackDescriptor) {
        StackTransformationUtilsKt.saveStack($methodNode, $inlineMarker, $savedStackDescriptor);
        return Unit.INSTANCE;
    }

    private static final Unit transformBeforeInlineCallMarker$lambda$1(MethodNode $methodNode, AbstractInsnNode $inlineMarker) {
        $methodNode.instructions.remove($inlineMarker);
        return Unit.INSTANCE;
    }
}

