/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.commons;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.download.Downloader;
import org.jreleaser.model.spi.download.ArtifactDownloader;
import org.jreleaser.model.spi.download.DownloadException;
import org.jreleaser.util.FileType;
import org.jreleaser.util.FileUtils;

public abstract class AbstractArtifactDownloader<A extends org.jreleaser.model.api.download.Downloader, D extends Downloader<A>>
implements ArtifactDownloader<A, D> {
    protected final JReleaserContext context;

    protected AbstractArtifactDownloader(JReleaserContext context) {
        this.context = context;
    }

    protected void unpack(Downloader.Unpack unpack, Path outputPath) throws DownloadException {
        Optional fileType = FileType.getFileType((Path)outputPath);
        if (unpack.isEnabled() && fileType.isPresent() && ((FileType)fileType.get()).archive()) {
            try {
                this.context.getLogger().info(RB.$((String)"downloader.unpack", (Object[])new Object[0]), new Object[]{outputPath.getFileName().toString()});
                if (this.context.isDryrun()) {
                    return;
                }
                FileUtils.unpackArchive((Path)outputPath, (Path)outputPath.getParent(), (boolean)unpack.isSkipRootEntry(), (boolean)false);
            }
            catch (IOException e) {
                throw new DownloadException(RB.$((String)"ERROR_download_url_unpack", (Object[])new Object[]{this.context.relativizeToBasedir(outputPath)}), (Throwable)e);
            }
        }
    }
}

