/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.zulip;

import feign.RequestInterceptor;
import feign.auth.BasicAuthRequestInterceptor;
import java.util.Objects;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.sdk.commons.ClientUtils;
import org.jreleaser.sdk.commons.RestAPIException;
import org.jreleaser.sdk.zulip.ZulipException;
import org.jreleaser.sdk.zulip.api.Message;
import org.jreleaser.sdk.zulip.api.ZulipAPI;
import org.jreleaser.util.StringUtils;

public class ZulipSdk {
    private final JReleaserContext context;
    private final ZulipAPI api;
    private final boolean dryrun;

    private ZulipSdk(JReleaserContext context, String apiHost, String account, String apiKey, int connectTimeout, int readTimeout, boolean dryrun) {
        Objects.requireNonNull(context, "'context' must not be null");
        StringUtils.requireNonBlank((String)apiHost, (String)"'apiHost' must not be blank");
        StringUtils.requireNonBlank((String)account, (String)"'account' must not be blank");
        StringUtils.requireNonBlank((String)apiKey, (String)"'apiKey' must not be blank");
        this.context = context;
        this.dryrun = dryrun;
        this.api = (ZulipAPI)ClientUtils.builder((JReleaserContext)context, (int)connectTimeout, (int)readTimeout).requestInterceptor((RequestInterceptor)new BasicAuthRequestInterceptor(account, apiKey)).target(ZulipAPI.class, apiHost);
        this.context.getLogger().debug(RB.$((String)"workflow.dryrun", (Object[])new Object[0]), new Object[]{dryrun});
    }

    public void message(String channel, String subject, String message) throws ZulipException {
        Message payload = Message.of(channel, subject, message);
        this.context.getLogger().debug("zulip.message: " + payload);
        this.wrap(() -> this.api.message(payload));
    }

    private void wrap(Runnable runnable) throws ZulipException {
        try {
            if (!this.dryrun) {
                runnable.run();
            }
        }
        catch (RestAPIException e) {
            this.context.getLogger().trace((Throwable)e);
            throw new ZulipException(RB.$((String)"sdk.operation.failed", (Object[])new Object[]{"Zulip"}), e);
        }
    }

    public static Builder builder(JReleaserContext context) {
        return new Builder(context);
    }

    public static class Builder {
        private final JReleaserContext context;
        private boolean dryrun;
        private String account;
        private String apiKey;
        private String apiHost;
        private int connectTimeout = 20;
        private int readTimeout = 60;

        private Builder(JReleaserContext context) {
            this.context = Objects.requireNonNull(context, "'context' must not be null");
        }

        public Builder dryrun(boolean dryrun) {
            this.dryrun = dryrun;
            return this;
        }

        public Builder account(String account) {
            this.account = StringUtils.requireNonBlank((String)account, (String)"'account' must not be blank").trim();
            return this;
        }

        public Builder apiKey(String apiKey) {
            this.apiKey = StringUtils.requireNonBlank((String)apiKey, (String)"'apiKey' must not be blank").trim();
            return this;
        }

        public Builder apiHost(String apiHost) {
            this.apiHost = StringUtils.requireNonBlank((String)apiHost, (String)"'apiHost' must not be blank").trim();
            return this;
        }

        public Builder connectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder readTimeout(int readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        private void validate() {
            StringUtils.requireNonBlank((String)this.apiHost, (String)"'apiHost' must not be blank");
            StringUtils.requireNonBlank((String)this.account, (String)"'account' must not be blank");
            StringUtils.requireNonBlank((String)this.apiKey, (String)"'apiKey' must not be blank");
        }

        public ZulipSdk build() {
            this.validate();
            return new ZulipSdk(this.context, this.apiHost, this.account, this.apiKey, this.connectTimeout, this.readTimeout, this.dryrun);
        }
    }
}

