/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.twitter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.spi.announce.AnnounceException;
import org.jreleaser.model.spi.announce.Announcer;
import org.jreleaser.mustache.MustacheUtils;
import org.jreleaser.mustache.TemplateContext;
import org.jreleaser.mustache.Templates;
import org.jreleaser.sdk.twitter.TwitterException;
import org.jreleaser.sdk.twitter.UpdateStatusTwitterCommand;
import org.jreleaser.util.StringUtils;

public class TwitterAnnouncer
implements Announcer<org.jreleaser.model.api.announce.TwitterAnnouncer> {
    private final JReleaserContext context;
    private final org.jreleaser.model.internal.announce.TwitterAnnouncer twitter;

    public TwitterAnnouncer(JReleaserContext context) {
        this.context = context;
        this.twitter = context.getModel().getAnnounce().getTwitter();
    }

    public org.jreleaser.model.api.announce.TwitterAnnouncer getAnnouncer() {
        return this.twitter.asImmutable();
    }

    public String getName() {
        return "twitter";
    }

    public boolean isEnabled() {
        return this.twitter.isEnabled();
    }

    public void announce() throws AnnounceException {
        ArrayList<String> statuses = new ArrayList<String>();
        if (StringUtils.isNotBlank((String)this.twitter.getStatusTemplate())) {
            TemplateContext props = new TemplateContext();
            this.context.getModel().getRelease().getReleaser().fillProps(props, this.context.getModel());
            Arrays.stream(this.twitter.getResolvedStatusTemplate(this.context, props).split(System.lineSeparator())).filter(StringUtils::isNotBlank).map(String::trim).forEach(statuses::add);
        }
        if (statuses.isEmpty() && !this.twitter.getStatuses().isEmpty()) {
            this.twitter.getStatuses().stream().filter(StringUtils::isNotBlank).map(String::trim).forEach(statuses::add);
        }
        if (statuses.isEmpty()) {
            statuses.add(this.twitter.getStatus());
        }
        for (int i = 0; i < statuses.size(); ++i) {
            String status = this.getResolvedMessage(this.context, (String)statuses.get(i));
            this.context.getLogger().info(RB.$((String)"twitter.tweet", (Object[])new Object[0]), new Object[]{status});
            this.context.getLogger().debug(RB.$((String)"twitter.tweet.size", (Object[])new Object[0]), new Object[]{status.length()});
            statuses.set(i, status);
        }
        try {
            ((UpdateStatusTwitterCommand.Builder)((UpdateStatusTwitterCommand.Builder)((UpdateStatusTwitterCommand.Builder)((UpdateStatusTwitterCommand.Builder)((UpdateStatusTwitterCommand.Builder)((UpdateStatusTwitterCommand.Builder)((UpdateStatusTwitterCommand.Builder)UpdateStatusTwitterCommand.builder(this.context.getLogger()).connectTimeout(this.twitter.getConnectTimeout())).readTimeout(this.twitter.getReadTimeout())).consumerKey(this.context.isDryrun() ? "**UNDEFINED**" : this.twitter.getConsumerKey())).consumerToken(this.context.isDryrun() ? "**UNDEFINED**" : this.twitter.getConsumerSecret())).accessToken(this.context.isDryrun() ? "**UNDEFINED**" : this.twitter.getAccessToken())).accessTokenSecret(this.context.isDryrun() ? "**UNDEFINED**" : this.twitter.getAccessTokenSecret())).statuses(statuses).dryrun(this.context.isDryrun())).build().execute();
        }
        catch (TwitterException e) {
            throw new AnnounceException((Throwable)e);
        }
    }

    private String getResolvedMessage(JReleaserContext context, String message) {
        TemplateContext props = context.fullProps();
        MustacheUtils.applyTemplates((TemplateContext)props, (Map)context.getModel().getAnnounce().getTwitter().resolvedExtraProperties());
        props.set("tagName", (Object)context.getModel().getRelease().getReleaser().getEffectiveTagName(context.getModel()));
        props.set("previousTagName", (Object)context.getModel().getRelease().getReleaser().getResolvedPreviousTagName(context.getModel()));
        return Templates.resolveTemplate((String)message, (TemplateContext)props);
    }
}

