package ipldgit

// Code generated by go-ipld-prime gengo.  DO NOT EDIT.

import (
	ipld "github.com/ipld/go-ipld-prime"
	"github.com/ipld/go-ipld-prime/node/mixins"
	"github.com/ipld/go-ipld-prime/schema"
)

func (n Blob) Bytes() []byte {
	return n.x
}
func (_Blob__Prototype) FromBytes(v []byte) (Blob, error) {
	n := _Blob{v}
	return &n, nil
}

type _Blob__Maybe struct {
	m schema.Maybe
	v _Blob
}
type MaybeBlob = *_Blob__Maybe

func (m MaybeBlob) IsNull() bool {
	return m.m == schema.Maybe_Null
}
func (m MaybeBlob) IsAbsent() bool {
	return m.m == schema.Maybe_Absent
}
func (m MaybeBlob) Exists() bool {
	return m.m == schema.Maybe_Value
}
func (m MaybeBlob) AsNode() ipld.Node {
	switch m.m {
	case schema.Maybe_Absent:
		return ipld.Absent
	case schema.Maybe_Null:
		return ipld.Null
	case schema.Maybe_Value:
		return &m.v
	default:
		panic("unreachable")
	}
}
func (m MaybeBlob) Must() Blob {
	if !m.Exists() {
		panic("unbox of a maybe rejected")
	}
	return &m.v
}

var _ ipld.Node = (Blob)(&_Blob{})
var _ schema.TypedNode = (Blob)(&_Blob{})

func (Blob) Kind() ipld.Kind {
	return ipld.Kind_Bytes
}
func (Blob) LookupByString(string) (ipld.Node, error) {
	return mixins.Bytes{TypeName: "ipldgit.Blob"}.LookupByString("")
}
func (Blob) LookupByNode(ipld.Node) (ipld.Node, error) {
	return mixins.Bytes{TypeName: "ipldgit.Blob"}.LookupByNode(nil)
}
func (Blob) LookupByIndex(idx int64) (ipld.Node, error) {
	return mixins.Bytes{TypeName: "ipldgit.Blob"}.LookupByIndex(0)
}
func (Blob) LookupBySegment(seg ipld.PathSegment) (ipld.Node, error) {
	return mixins.Bytes{TypeName: "ipldgit.Blob"}.LookupBySegment(seg)
}
func (Blob) MapIterator() ipld.MapIterator {
	return nil
}
func (Blob) ListIterator() ipld.ListIterator {
	return nil
}
func (Blob) Length() int64 {
	return -1
}
func (Blob) IsAbsent() bool {
	return false
}
func (Blob) IsNull() bool {
	return false
}
func (Blob) AsBool() (bool, error) {
	return mixins.Bytes{TypeName: "ipldgit.Blob"}.AsBool()
}
func (Blob) AsInt() (int64, error) {
	return mixins.Bytes{TypeName: "ipldgit.Blob"}.AsInt()
}
func (Blob) AsFloat() (float64, error) {
	return mixins.Bytes{TypeName: "ipldgit.Blob"}.AsFloat()
}
func (Blob) AsString() (string, error) {
	return mixins.Bytes{TypeName: "ipldgit.Blob"}.AsString()
}
func (n Blob) AsBytes() ([]byte, error) {
	return n.x, nil
}
func (Blob) AsLink() (ipld.Link, error) {
	return mixins.Bytes{TypeName: "ipldgit.Blob"}.AsLink()
}
func (Blob) Prototype() ipld.NodePrototype {
	return _Blob__Prototype{}
}

type _Blob__Prototype struct{}

func (_Blob__Prototype) NewBuilder() ipld.NodeBuilder {
	var nb _Blob__Builder
	nb.Reset()
	return &nb
}

type _Blob__Builder struct {
	_Blob__Assembler
}

func (nb *_Blob__Builder) Build() ipld.Node {
	if *nb.m != schema.Maybe_Value {
		panic("invalid state: cannot call Build on an assembler that's not finished")
	}
	return nb.w
}
func (nb *_Blob__Builder) Reset() {
	var w _Blob
	var m schema.Maybe
	*nb = _Blob__Builder{_Blob__Assembler{w: &w, m: &m}}
}

type _Blob__Assembler struct {
	w *_Blob
	m *schema.Maybe
}

func (na *_Blob__Assembler) reset() {}
func (_Blob__Assembler) BeginMap(sizeHint int64) (ipld.MapAssembler, error) {
	return mixins.BytesAssembler{TypeName: "ipldgit.Blob"}.BeginMap(0)
}
func (_Blob__Assembler) BeginList(sizeHint int64) (ipld.ListAssembler, error) {
	return mixins.BytesAssembler{TypeName: "ipldgit.Blob"}.BeginList(0)
}
func (na *_Blob__Assembler) AssignNull() error {
	switch *na.m {
	case allowNull:
		*na.m = schema.Maybe_Null
		return nil
	case schema.Maybe_Absent:
		return mixins.BytesAssembler{TypeName: "ipldgit.Blob"}.AssignNull()
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	}
	panic("unreachable")
}
func (_Blob__Assembler) AssignBool(bool) error {
	return mixins.BytesAssembler{TypeName: "ipldgit.Blob"}.AssignBool(false)
}
func (_Blob__Assembler) AssignInt(int64) error {
	return mixins.BytesAssembler{TypeName: "ipldgit.Blob"}.AssignInt(0)
}
func (_Blob__Assembler) AssignFloat(float64) error {
	return mixins.BytesAssembler{TypeName: "ipldgit.Blob"}.AssignFloat(0)
}
func (_Blob__Assembler) AssignString(string) error {
	return mixins.BytesAssembler{TypeName: "ipldgit.Blob"}.AssignString("")
}
func (na *_Blob__Assembler) AssignBytes(v []byte) error {
	switch *na.m {
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	}
	na.w.x = v
	*na.m = schema.Maybe_Value
	return nil
}
func (_Blob__Assembler) AssignLink(ipld.Link) error {
	return mixins.BytesAssembler{TypeName: "ipldgit.Blob"}.AssignLink(nil)
}
func (na *_Blob__Assembler) AssignNode(v ipld.Node) error {
	if v.IsNull() {
		return na.AssignNull()
	}
	if v2, ok := v.(*_Blob); ok {
		switch *na.m {
		case schema.Maybe_Value, schema.Maybe_Null:
			panic("invalid state: cannot assign into assembler that's already finished")
		}
		*na.w = *v2
		*na.m = schema.Maybe_Value
		return nil
	}
	if v2, err := v.AsBytes(); err != nil {
		return err
	} else {
		return na.AssignBytes(v2)
	}
}
func (_Blob__Assembler) Prototype() ipld.NodePrototype {
	return _Blob__Prototype{}
}
func (Blob) Type() schema.Type {
	return nil /*TODO:typelit*/
}
func (n Blob) Representation() ipld.Node {
	return (*_Blob__Repr)(n)
}

type _Blob__Repr = _Blob

var _ ipld.Node = &_Blob__Repr{}

type _Blob__ReprPrototype = _Blob__Prototype
type _Blob__ReprAssembler = _Blob__Assembler

func (n _Commit) FieldTree() Tree_Link {
	return &n.tree
}
func (n _Commit) FieldParents() Commit_Link_List {
	return &n.parents
}
func (n _Commit) FieldMessage() String {
	return &n.message
}
func (n _Commit) FieldAuthor() MaybePersonInfo {
	return &n.author
}
func (n _Commit) FieldCommitter() MaybePersonInfo {
	return &n.committer
}
func (n _Commit) FieldEncoding() MaybeString {
	return &n.encoding
}
func (n _Commit) FieldSignature() MaybeGpgSig {
	return &n.signature
}
func (n _Commit) FieldMergetag() Tag_List {
	return &n.mergetag
}
func (n _Commit) FieldOther() String_List {
	return &n.other
}

type _Commit__Maybe struct {
	m schema.Maybe
	v Commit
}
type MaybeCommit = *_Commit__Maybe

func (m MaybeCommit) IsNull() bool {
	return m.m == schema.Maybe_Null
}
func (m MaybeCommit) IsAbsent() bool {
	return m.m == schema.Maybe_Absent
}
func (m MaybeCommit) Exists() bool {
	return m.m == schema.Maybe_Value
}
func (m MaybeCommit) AsNode() ipld.Node {
	switch m.m {
	case schema.Maybe_Absent:
		return ipld.Absent
	case schema.Maybe_Null:
		return ipld.Null
	case schema.Maybe_Value:
		return m.v
	default:
		panic("unreachable")
	}
}
func (m MaybeCommit) Must() Commit {
	if !m.Exists() {
		panic("unbox of a maybe rejected")
	}
	return m.v
}

var (
	fieldName__Commit_Tree      = _String{"tree"}
	fieldName__Commit_Parents   = _String{"parents"}
	fieldName__Commit_Message   = _String{"message"}
	fieldName__Commit_Author    = _String{"author"}
	fieldName__Commit_Committer = _String{"committer"}
	fieldName__Commit_Encoding  = _String{"encoding"}
	fieldName__Commit_Signature = _String{"signature"}
	fieldName__Commit_Mergetag  = _String{"mergetag"}
	fieldName__Commit_Other     = _String{"other"}
)
var _ ipld.Node = (Commit)(&_Commit{})
var _ schema.TypedNode = (Commit)(&_Commit{})

func (Commit) Kind() ipld.Kind {
	return ipld.Kind_Map
}
func (n Commit) LookupByString(key string) (ipld.Node, error) {
	switch key {
	case "tree":
		return &n.tree, nil
	case "parents":
		return &n.parents, nil
	case "message":
		return &n.message, nil
	case "author":
		if n.author.m == schema.Maybe_Absent {
			return ipld.Absent, nil
		}
		return n.author.v, nil
	case "committer":
		if n.committer.m == schema.Maybe_Absent {
			return ipld.Absent, nil
		}
		return n.committer.v, nil
	case "encoding":
		if n.encoding.m == schema.Maybe_Absent {
			return ipld.Absent, nil
		}
		return &n.encoding.v, nil
	case "signature":
		if n.signature.m == schema.Maybe_Absent {
			return ipld.Absent, nil
		}
		return &n.signature.v, nil
	case "mergetag":
		return &n.mergetag, nil
	case "other":
		return &n.other, nil
	default:
		return nil, schema.ErrNoSuchField{Type: nil /*TODO*/, Field: ipld.PathSegmentOfString(key)}
	}
}
func (n Commit) LookupByNode(key ipld.Node) (ipld.Node, error) {
	ks, err := key.AsString()
	if err != nil {
		return nil, err
	}
	return n.LookupByString(ks)
}
func (Commit) LookupByIndex(idx int64) (ipld.Node, error) {
	return mixins.Map{TypeName: "ipldgit.Commit"}.LookupByIndex(0)
}
func (n Commit) LookupBySegment(seg ipld.PathSegment) (ipld.Node, error) {
	return n.LookupByString(seg.String())
}
func (n Commit) MapIterator() ipld.MapIterator {
	return &_Commit__MapItr{n, 0}
}

type _Commit__MapItr struct {
	n   Commit
	idx int
}

func (itr *_Commit__MapItr) Next() (k ipld.Node, v ipld.Node, _ error) {
	if itr.idx >= 9 {
		return nil, nil, ipld.ErrIteratorOverread{}
	}
	switch itr.idx {
	case 0:
		k = &fieldName__Commit_Tree
		v = &itr.n.tree
	case 1:
		k = &fieldName__Commit_Parents
		v = &itr.n.parents
	case 2:
		k = &fieldName__Commit_Message
		v = &itr.n.message
	case 3:
		k = &fieldName__Commit_Author
		if itr.n.author.m == schema.Maybe_Absent {
			v = ipld.Absent
			break
		}
		v = itr.n.author.v
	case 4:
		k = &fieldName__Commit_Committer
		if itr.n.committer.m == schema.Maybe_Absent {
			v = ipld.Absent
			break
		}
		v = itr.n.committer.v
	case 5:
		k = &fieldName__Commit_Encoding
		if itr.n.encoding.m == schema.Maybe_Absent {
			v = ipld.Absent
			break
		}
		v = &itr.n.encoding.v
	case 6:
		k = &fieldName__Commit_Signature
		if itr.n.signature.m == schema.Maybe_Absent {
			v = ipld.Absent
			break
		}
		v = &itr.n.signature.v
	case 7:
		k = &fieldName__Commit_Mergetag
		v = &itr.n.mergetag
	case 8:
		k = &fieldName__Commit_Other
		v = &itr.n.other
	default:
		panic("unreachable")
	}
	itr.idx++
	return
}
func (itr *_Commit__MapItr) Done() bool {
	return itr.idx >= 9
}

func (Commit) ListIterator() ipld.ListIterator {
	return nil
}
func (Commit) Length() int64 {
	return 9
}
func (Commit) IsAbsent() bool {
	return false
}
func (Commit) IsNull() bool {
	return false
}
func (Commit) AsBool() (bool, error) {
	return mixins.Map{TypeName: "ipldgit.Commit"}.AsBool()
}
func (Commit) AsInt() (int64, error) {
	return mixins.Map{TypeName: "ipldgit.Commit"}.AsInt()
}
func (Commit) AsFloat() (float64, error) {
	return mixins.Map{TypeName: "ipldgit.Commit"}.AsFloat()
}
func (Commit) AsString() (string, error) {
	return mixins.Map{TypeName: "ipldgit.Commit"}.AsString()
}
func (Commit) AsBytes() ([]byte, error) {
	return mixins.Map{TypeName: "ipldgit.Commit"}.AsBytes()
}
func (Commit) AsLink() (ipld.Link, error) {
	return mixins.Map{TypeName: "ipldgit.Commit"}.AsLink()
}
func (Commit) Prototype() ipld.NodePrototype {
	return _Commit__Prototype{}
}

type _Commit__Prototype struct{}

func (_Commit__Prototype) NewBuilder() ipld.NodeBuilder {
	var nb _Commit__Builder
	nb.Reset()
	return &nb
}

type _Commit__Builder struct {
	_Commit__Assembler
}

func (nb *_Commit__Builder) Build() ipld.Node {
	if *nb.m != schema.Maybe_Value {
		panic("invalid state: cannot call Build on an assembler that's not finished")
	}
	return nb.w
}
func (nb *_Commit__Builder) Reset() {
	var w _Commit
	var m schema.Maybe
	*nb = _Commit__Builder{_Commit__Assembler{w: &w, m: &m}}
}

type _Commit__Assembler struct {
	w     *_Commit
	m     *schema.Maybe
	state maState
	s     int
	f     int

	cm           schema.Maybe
	ca_tree      _Tree_Link__Assembler
	ca_parents   _Commit_Link_List__Assembler
	ca_message   _String__Assembler
	ca_author    _PersonInfo__Assembler
	ca_committer _PersonInfo__Assembler
	ca_encoding  _String__Assembler
	ca_signature _GpgSig__Assembler
	ca_mergetag  _Tag_List__Assembler
	ca_other     _String_List__Assembler
}

func (na *_Commit__Assembler) reset() {
	na.state = maState_initial
	na.s = 0
	na.ca_tree.reset()
	na.ca_parents.reset()
	na.ca_message.reset()
	na.ca_author.reset()
	na.ca_committer.reset()
	na.ca_encoding.reset()
	na.ca_signature.reset()
	na.ca_mergetag.reset()
	na.ca_other.reset()
}

var (
	fieldBit__Commit_Tree        = 1 << 0
	fieldBit__Commit_Parents     = 1 << 1
	fieldBit__Commit_Message     = 1 << 2
	fieldBit__Commit_Author      = 1 << 3
	fieldBit__Commit_Committer   = 1 << 4
	fieldBit__Commit_Encoding    = 1 << 5
	fieldBit__Commit_Signature   = 1 << 6
	fieldBit__Commit_Mergetag    = 1 << 7
	fieldBit__Commit_Other       = 1 << 8
	fieldBits__Commit_sufficient = 0 + 1<<0 + 1<<1 + 1<<2 + 1<<7 + 1<<8
)

func (na *_Commit__Assembler) BeginMap(int64) (ipld.MapAssembler, error) {
	switch *na.m {
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: it makes no sense to 'begin' twice on the same assembler!")
	}
	*na.m = midvalue
	if na.w == nil {
		na.w = &_Commit{}
	}
	return na, nil
}
func (_Commit__Assembler) BeginList(sizeHint int64) (ipld.ListAssembler, error) {
	return mixins.MapAssembler{TypeName: "ipldgit.Commit"}.BeginList(0)
}
func (na *_Commit__Assembler) AssignNull() error {
	switch *na.m {
	case allowNull:
		*na.m = schema.Maybe_Null
		return nil
	case schema.Maybe_Absent:
		return mixins.MapAssembler{TypeName: "ipldgit.Commit"}.AssignNull()
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
	}
	panic("unreachable")
}
func (_Commit__Assembler) AssignBool(bool) error {
	return mixins.MapAssembler{TypeName: "ipldgit.Commit"}.AssignBool(false)
}
func (_Commit__Assembler) AssignInt(int64) error {
	return mixins.MapAssembler{TypeName: "ipldgit.Commit"}.AssignInt(0)
}
func (_Commit__Assembler) AssignFloat(float64) error {
	return mixins.MapAssembler{TypeName: "ipldgit.Commit"}.AssignFloat(0)
}
func (_Commit__Assembler) AssignString(string) error {
	return mixins.MapAssembler{TypeName: "ipldgit.Commit"}.AssignString("")
}
func (_Commit__Assembler) AssignBytes([]byte) error {
	return mixins.MapAssembler{TypeName: "ipldgit.Commit"}.AssignBytes(nil)
}
func (_Commit__Assembler) AssignLink(ipld.Link) error {
	return mixins.MapAssembler{TypeName: "ipldgit.Commit"}.AssignLink(nil)
}
func (na *_Commit__Assembler) AssignNode(v ipld.Node) error {
	if v.IsNull() {
		return na.AssignNull()
	}
	if v2, ok := v.(*_Commit); ok {
		switch *na.m {
		case schema.Maybe_Value, schema.Maybe_Null:
			panic("invalid state: cannot assign into assembler that's already finished")
		case midvalue:
			panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
		}
		if na.w == nil {
			na.w = v2
			*na.m = schema.Maybe_Value
			return nil
		}
		*na.w = *v2
		*na.m = schema.Maybe_Value
		return nil
	}
	if v.Kind() != ipld.Kind_Map {
		return ipld.ErrWrongKind{TypeName: "ipldgit.Commit", MethodName: "AssignNode", AppropriateKind: ipld.KindSet_JustMap, ActualKind: v.Kind()}
	}
	itr := v.MapIterator()
	for !itr.Done() {
		k, v, err := itr.Next()
		if err != nil {
			return err
		}
		if err := na.AssembleKey().AssignNode(k); err != nil {
			return err
		}
		if err := na.AssembleValue().AssignNode(v); err != nil {
			return err
		}
	}
	return na.Finish()
}
func (_Commit__Assembler) Prototype() ipld.NodePrototype {
	return _Commit__Prototype{}
}
func (ma *_Commit__Assembler) valueFinishTidy() bool {
	switch ma.f {
	case 0:
		switch ma.cm {
		case schema.Maybe_Value:
			ma.ca_tree.w = nil
			ma.cm = schema.Maybe_Absent
			ma.state = maState_initial
			return true
		default:
			return false
		}
	case 1:
		switch ma.cm {
		case schema.Maybe_Value:
			ma.ca_parents.w = nil
			ma.cm = schema.Maybe_Absent
			ma.state = maState_initial
			return true
		default:
			return false
		}
	case 2:
		switch ma.cm {
		case schema.Maybe_Value:
			ma.ca_message.w = nil
			ma.cm = schema.Maybe_Absent
			ma.state = maState_initial
			return true
		default:
			return false
		}
	case 3:
		switch ma.w.author.m {
		case schema.Maybe_Value:
			ma.w.author.v = ma.ca_author.w
			ma.state = maState_initial
			return true
		default:
			return false
		}
	case 4:
		switch ma.w.committer.m {
		case schema.Maybe_Value:
			ma.w.committer.v = ma.ca_committer.w
			ma.state = maState_initial
			return true
		default:
			return false
		}
	case 5:
		switch ma.w.encoding.m {
		case schema.Maybe_Value:
			ma.state = maState_initial
			return true
		default:
			return false
		}
	case 6:
		switch ma.w.signature.m {
		case schema.Maybe_Value:
			ma.state = maState_initial
			return true
		default:
			return false
		}
	case 7:
		switch ma.cm {
		case schema.Maybe_Value:
			ma.ca_mergetag.w = nil
			ma.cm = schema.Maybe_Absent
			ma.state = maState_initial
			return true
		default:
			return false
		}
	case 8:
		switch ma.cm {
		case schema.Maybe_Value:
			ma.ca_other.w = nil
			ma.cm = schema.Maybe_Absent
			ma.state = maState_initial
			return true
		default:
			return false
		}
	default:
		panic("unreachable")
	}
}
func (ma *_Commit__Assembler) AssembleEntry(k string) (ipld.NodeAssembler, error) {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: AssembleEntry cannot be called when in the middle of assembling another key")
	case maState_expectValue:
		panic("invalid state: AssembleEntry cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: AssembleEntry cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: AssembleEntry cannot be called on an assembler that's already finished")
	}
	switch k {
	case "tree":
		if ma.s&fieldBit__Commit_Tree != 0 {
			return nil, ipld.ErrRepeatedMapKey{Key: &fieldName__Commit_Tree}
		}
		ma.s += fieldBit__Commit_Tree
		ma.state = maState_midValue
		ma.f = 0
		ma.ca_tree.w = &ma.w.tree
		ma.ca_tree.m = &ma.cm
		return &ma.ca_tree, nil
	case "parents":
		if ma.s&fieldBit__Commit_Parents != 0 {
			return nil, ipld.ErrRepeatedMapKey{Key: &fieldName__Commit_Parents}
		}
		ma.s += fieldBit__Commit_Parents
		ma.state = maState_midValue
		ma.f = 1
		ma.ca_parents.w = &ma.w.parents
		ma.ca_parents.m = &ma.cm
		return &ma.ca_parents, nil
	case "message":
		if ma.s&fieldBit__Commit_Message != 0 {
			return nil, ipld.ErrRepeatedMapKey{Key: &fieldName__Commit_Message}
		}
		ma.s += fieldBit__Commit_Message
		ma.state = maState_midValue
		ma.f = 2
		ma.ca_message.w = &ma.w.message
		ma.ca_message.m = &ma.cm
		return &ma.ca_message, nil
	case "author":
		if ma.s&fieldBit__Commit_Author != 0 {
			return nil, ipld.ErrRepeatedMapKey{Key: &fieldName__Commit_Author}
		}
		ma.s += fieldBit__Commit_Author
		ma.state = maState_midValue
		ma.f = 3
		ma.ca_author.w = ma.w.author.v
		ma.ca_author.m = &ma.w.author.m
		return &ma.ca_author, nil
	case "committer":
		if ma.s&fieldBit__Commit_Committer != 0 {
			return nil, ipld.ErrRepeatedMapKey{Key: &fieldName__Commit_Committer}
		}
		ma.s += fieldBit__Commit_Committer
		ma.state = maState_midValue
		ma.f = 4
		ma.ca_committer.w = ma.w.committer.v
		ma.ca_committer.m = &ma.w.committer.m
		return &ma.ca_committer, nil
	case "encoding":
		if ma.s&fieldBit__Commit_Encoding != 0 {
			return nil, ipld.ErrRepeatedMapKey{Key: &fieldName__Commit_Encoding}
		}
		ma.s += fieldBit__Commit_Encoding
		ma.state = maState_midValue
		ma.f = 5
		ma.ca_encoding.w = &ma.w.encoding.v
		ma.ca_encoding.m = &ma.w.encoding.m
		return &ma.ca_encoding, nil
	case "signature":
		if ma.s&fieldBit__Commit_Signature != 0 {
			return nil, ipld.ErrRepeatedMapKey{Key: &fieldName__Commit_Signature}
		}
		ma.s += fieldBit__Commit_Signature
		ma.state = maState_midValue
		ma.f = 6
		ma.ca_signature.w = &ma.w.signature.v
		ma.ca_signature.m = &ma.w.signature.m
		return &ma.ca_signature, nil
	case "mergetag":
		if ma.s&fieldBit__Commit_Mergetag != 0 {
			return nil, ipld.ErrRepeatedMapKey{Key: &fieldName__Commit_Mergetag}
		}
		ma.s += fieldBit__Commit_Mergetag
		ma.state = maState_midValue
		ma.f = 7
		ma.ca_mergetag.w = &ma.w.mergetag
		ma.ca_mergetag.m = &ma.cm
		return &ma.ca_mergetag, nil
	case "other":
		if ma.s&fieldBit__Commit_Other != 0 {
			return nil, ipld.ErrRepeatedMapKey{Key: &fieldName__Commit_Other}
		}
		ma.s += fieldBit__Commit_Other
		ma.state = maState_midValue
		ma.f = 8
		ma.ca_other.w = &ma.w.other
		ma.ca_other.m = &ma.cm
		return &ma.ca_other, nil
	}
	return nil, ipld.ErrInvalidKey{TypeName: "ipldgit.Commit", Key: &_String{k}}
}
func (ma *_Commit__Assembler) AssembleKey() ipld.NodeAssembler {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: AssembleKey cannot be called when in the middle of assembling another key")
	case maState_expectValue:
		panic("invalid state: AssembleKey cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: AssembleKey cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: AssembleKey cannot be called on an assembler that's already finished")
	}
	ma.state = maState_midKey
	return (*_Commit__KeyAssembler)(ma)
}
func (ma *_Commit__Assembler) AssembleValue() ipld.NodeAssembler {
	switch ma.state {
	case maState_initial:
		panic("invalid state: AssembleValue cannot be called when no key is primed")
	case maState_midKey:
		panic("invalid state: AssembleValue cannot be called when in the middle of assembling a key")
	case maState_expectValue:
		// carry on
	case maState_midValue:
		panic("invalid state: AssembleValue cannot be called when in the middle of assembling another value")
	case maState_finished:
		panic("invalid state: AssembleValue cannot be called on an assembler that's already finished")
	}
	ma.state = maState_midValue
	switch ma.f {
	case 0:
		ma.ca_tree.w = &ma.w.tree
		ma.ca_tree.m = &ma.cm
		return &ma.ca_tree
	case 1:
		ma.ca_parents.w = &ma.w.parents
		ma.ca_parents.m = &ma.cm
		return &ma.ca_parents
	case 2:
		ma.ca_message.w = &ma.w.message
		ma.ca_message.m = &ma.cm
		return &ma.ca_message
	case 3:
		ma.ca_author.w = ma.w.author.v
		ma.ca_author.m = &ma.w.author.m
		return &ma.ca_author
	case 4:
		ma.ca_committer.w = ma.w.committer.v
		ma.ca_committer.m = &ma.w.committer.m
		return &ma.ca_committer
	case 5:
		ma.ca_encoding.w = &ma.w.encoding.v
		ma.ca_encoding.m = &ma.w.encoding.m
		return &ma.ca_encoding
	case 6:
		ma.ca_signature.w = &ma.w.signature.v
		ma.ca_signature.m = &ma.w.signature.m
		return &ma.ca_signature
	case 7:
		ma.ca_mergetag.w = &ma.w.mergetag
		ma.ca_mergetag.m = &ma.cm
		return &ma.ca_mergetag
	case 8:
		ma.ca_other.w = &ma.w.other
		ma.ca_other.m = &ma.cm
		return &ma.ca_other
	default:
		panic("unreachable")
	}
}
func (ma *_Commit__Assembler) Finish() error {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: Finish cannot be called when in the middle of assembling a key")
	case maState_expectValue:
		panic("invalid state: Finish cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: Finish cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: Finish cannot be called on an assembler that's already finished")
	}
	if ma.s&fieldBits__Commit_sufficient != fieldBits__Commit_sufficient {
		err := ipld.ErrMissingRequiredField{Missing: make([]string, 0)}
		if ma.s&fieldBit__Commit_Tree == 0 {
			err.Missing = append(err.Missing, "tree")
		}
		if ma.s&fieldBit__Commit_Parents == 0 {
			err.Missing = append(err.Missing, "parents")
		}
		if ma.s&fieldBit__Commit_Message == 0 {
			err.Missing = append(err.Missing, "message")
		}
		if ma.s&fieldBit__Commit_Mergetag == 0 {
			err.Missing = append(err.Missing, "mergetag")
		}
		if ma.s&fieldBit__Commit_Other == 0 {
			err.Missing = append(err.Missing, "other")
		}
		return err
	}
	ma.state = maState_finished
	*ma.m = schema.Maybe_Value
	return nil
}
func (ma *_Commit__Assembler) KeyPrototype() ipld.NodePrototype {
	return _String__Prototype{}
}
func (ma *_Commit__Assembler) ValuePrototype(k string) ipld.NodePrototype {
	panic("todo structbuilder mapassembler valueprototype")
}

type _Commit__KeyAssembler _Commit__Assembler

func (_Commit__KeyAssembler) BeginMap(sizeHint int64) (ipld.MapAssembler, error) {
	return mixins.StringAssembler{TypeName: "ipldgit.Commit.KeyAssembler"}.BeginMap(0)
}
func (_Commit__KeyAssembler) BeginList(sizeHint int64) (ipld.ListAssembler, error) {
	return mixins.StringAssembler{TypeName: "ipldgit.Commit.KeyAssembler"}.BeginList(0)
}
func (na *_Commit__KeyAssembler) AssignNull() error {
	return mixins.StringAssembler{TypeName: "ipldgit.Commit.KeyAssembler"}.AssignNull()
}
func (_Commit__KeyAssembler) AssignBool(bool) error {
	return mixins.StringAssembler{TypeName: "ipldgit.Commit.KeyAssembler"}.AssignBool(false)
}
func (_Commit__KeyAssembler) AssignInt(int64) error {
	return mixins.StringAssembler{TypeName: "ipldgit.Commit.KeyAssembler"}.AssignInt(0)
}
func (_Commit__KeyAssembler) AssignFloat(float64) error {
	return mixins.StringAssembler{TypeName: "ipldgit.Commit.KeyAssembler"}.AssignFloat(0)
}
func (ka *_Commit__KeyAssembler) AssignString(k string) error {
	if ka.state != maState_midKey {
		panic("misuse: KeyAssembler held beyond its valid lifetime")
	}
	switch k {
	case "tree":
		if ka.s&fieldBit__Commit_Tree != 0 {
			return ipld.ErrRepeatedMapKey{Key: &fieldName__Commit_Tree}
		}
		ka.s += fieldBit__Commit_Tree
		ka.state = maState_expectValue
		ka.f = 0
		return nil
	case "parents":
		if ka.s&fieldBit__Commit_Parents != 0 {
			return ipld.ErrRepeatedMapKey{Key: &fieldName__Commit_Parents}
		}
		ka.s += fieldBit__Commit_Parents
		ka.state = maState_expectValue
		ka.f = 1
		return nil
	case "message":
		if ka.s&fieldBit__Commit_Message != 0 {
			return ipld.ErrRepeatedMapKey{Key: &fieldName__Commit_Message}
		}
		ka.s += fieldBit__Commit_Message
		ka.state = maState_expectValue
		ka.f = 2
		return nil
	case "author":
		if ka.s&fieldBit__Commit_Author != 0 {
			return ipld.ErrRepeatedMapKey{Key: &fieldName__Commit_Author}
		}
		ka.s += fieldBit__Commit_Author
		ka.state = maState_expectValue
		ka.f = 3
		return nil
	case "committer":
		if ka.s&fieldBit__Commit_Committer != 0 {
			return ipld.ErrRepeatedMapKey{Key: &fieldName__Commit_Committer}
		}
		ka.s += fieldBit__Commit_Committer
		ka.state = maState_expectValue
		ka.f = 4
		return nil
	case "encoding":
		if ka.s&fieldBit__Commit_Encoding != 0 {
			return ipld.ErrRepeatedMapKey{Key: &fieldName__Commit_Encoding}
		}
		ka.s += fieldBit__Commit_Encoding
		ka.state = maState_expectValue
		ka.f = 5
		return nil
	case "signature":
		if ka.s&fieldBit__Commit_Signature != 0 {
			return ipld.ErrRepeatedMapKey{Key: &fieldName__Commit_Signature}
		}
		ka.s += fieldBit__Commit_Signature
		ka.state = maState_expectValue
		ka.f = 6
		return nil
	case "mergetag":
		if ka.s&fieldBit__Commit_Mergetag != 0 {
			return ipld.ErrRepeatedMapKey{Key: &fieldName__Commit_Mergetag}
		}
		ka.s += fieldBit__Commit_Mergetag
		ka.state = maState_expectValue
		ka.f = 7
		return nil
	case "other":
		if ka.s&fieldBit__Commit_Other != 0 {
			return ipld.ErrRepeatedMapKey{Key: &fieldName__Commit_Other}
		}
		ka.s += fieldBit__Commit_Other
		ka.state = maState_expectValue
		ka.f = 8
		return nil
	default:
		return ipld.ErrInvalidKey{TypeName: "ipldgit.Commit", Key: &_String{k}}
	}
}
func (_Commit__KeyAssembler) AssignBytes([]byte) error {
	return mixins.StringAssembler{TypeName: "ipldgit.Commit.KeyAssembler"}.AssignBytes(nil)
}
func (_Commit__KeyAssembler) AssignLink(ipld.Link) error {
	return mixins.StringAssembler{TypeName: "ipldgit.Commit.KeyAssembler"}.AssignLink(nil)
}
func (ka *_Commit__KeyAssembler) AssignNode(v ipld.Node) error {
	if v2, err := v.AsString(); err != nil {
		return err
	} else {
		return ka.AssignString(v2)
	}
}
func (_Commit__KeyAssembler) Prototype() ipld.NodePrototype {
	return _String__Prototype{}
}
func (Commit) Type() schema.Type {
	return nil /*TODO:typelit*/
}
func (n Commit) Representation() ipld.Node {
	return (*_Commit__Repr)(n)
}

type _Commit__Repr _Commit

var (
	fieldName__Commit_Tree_serial      = _String{"tree"}
	fieldName__Commit_Parents_serial   = _String{"parents"}
	fieldName__Commit_Message_serial   = _String{"message"}
	fieldName__Commit_Author_serial    = _String{"author"}
	fieldName__Commit_Committer_serial = _String{"committer"}
	fieldName__Commit_Encoding_serial  = _String{"encoding"}
	fieldName__Commit_Signature_serial = _String{"signature"}
	fieldName__Commit_Mergetag_serial  = _String{"mergetag"}
	fieldName__Commit_Other_serial     = _String{"other"}
)
var _ ipld.Node = &_Commit__Repr{}

func (_Commit__Repr) Kind() ipld.Kind {
	return ipld.Kind_Map
}
func (n *_Commit__Repr) LookupByString(key string) (ipld.Node, error) {
	switch key {
	case "tree":
		return n.tree.Representation(), nil
	case "parents":
		return n.parents.Representation(), nil
	case "message":
		return n.message.Representation(), nil
	case "author":
		if n.author.m == schema.Maybe_Absent {
			return ipld.Absent, ipld.ErrNotExists{Segment: ipld.PathSegmentOfString(key)}
		}
		return n.author.v.Representation(), nil
	case "committer":
		if n.committer.m == schema.Maybe_Absent {
			return ipld.Absent, ipld.ErrNotExists{Segment: ipld.PathSegmentOfString(key)}
		}
		return n.committer.v.Representation(), nil
	case "encoding":
		if n.encoding.m == schema.Maybe_Absent {
			return ipld.Absent, ipld.ErrNotExists{Segment: ipld.PathSegmentOfString(key)}
		}
		return n.encoding.v.Representation(), nil
	case "signature":
		if n.signature.m == schema.Maybe_Absent {
			return ipld.Absent, ipld.ErrNotExists{Segment: ipld.PathSegmentOfString(key)}
		}
		return n.signature.v.Representation(), nil
	case "mergetag":
		return n.mergetag.Representation(), nil
	case "other":
		return n.other.Representation(), nil
	default:
		return nil, schema.ErrNoSuchField{Type: nil /*TODO*/, Field: ipld.PathSegmentOfString(key)}
	}
}
func (n *_Commit__Repr) LookupByNode(key ipld.Node) (ipld.Node, error) {
	ks, err := key.AsString()
	if err != nil {
		return nil, err
	}
	return n.LookupByString(ks)
}
func (_Commit__Repr) LookupByIndex(idx int64) (ipld.Node, error) {
	return mixins.Map{TypeName: "ipldgit.Commit.Repr"}.LookupByIndex(0)
}
func (n _Commit__Repr) LookupBySegment(seg ipld.PathSegment) (ipld.Node, error) {
	return n.LookupByString(seg.String())
}
func (n *_Commit__Repr) MapIterator() ipld.MapIterator {
	return &_Commit__ReprMapItr{n, 0}
}

type _Commit__ReprMapItr struct {
	n   *_Commit__Repr
	idx int
}

func (itr *_Commit__ReprMapItr) Next() (k ipld.Node, v ipld.Node, _ error) {
advance:
	if itr.idx >= 9 {
		return nil, nil, ipld.ErrIteratorOverread{}
	}
	switch itr.idx {
	case 0:
		k = &fieldName__Commit_Tree_serial
		v = itr.n.tree.Representation()
	case 1:
		k = &fieldName__Commit_Parents_serial
		v = itr.n.parents.Representation()
	case 2:
		k = &fieldName__Commit_Message_serial
		v = itr.n.message.Representation()
	case 3:
		k = &fieldName__Commit_Author_serial
		if itr.n.author.m == schema.Maybe_Absent {
			itr.idx++
			goto advance
		}
		v = itr.n.author.v.Representation()
	case 4:
		k = &fieldName__Commit_Committer_serial
		if itr.n.committer.m == schema.Maybe_Absent {
			itr.idx++
			goto advance
		}
		v = itr.n.committer.v.Representation()
	case 5:
		k = &fieldName__Commit_Encoding_serial
		if itr.n.encoding.m == schema.Maybe_Absent {
			itr.idx++
			goto advance
		}
		v = itr.n.encoding.v.Representation()
	case 6:
		k = &fieldName__Commit_Signature_serial
		if itr.n.signature.m == schema.Maybe_Absent {
			itr.idx++
			goto advance
		}
		v = itr.n.signature.v.Representation()
	case 7:
		k = &fieldName__Commit_Mergetag_serial
		v = itr.n.mergetag.Representation()
	case 8:
		k = &fieldName__Commit_Other_serial
		v = itr.n.other.Representation()
	default:
		panic("unreachable")
	}
	itr.idx++
	return
}
func (itr *_Commit__ReprMapItr) Done() bool {
	return itr.idx >= 9
}
func (_Commit__Repr) ListIterator() ipld.ListIterator {
	return nil
}
func (rn *_Commit__Repr) Length() int64 {
	l := 9
	if rn.author.m == schema.Maybe_Absent {
		l--
	}
	if rn.committer.m == schema.Maybe_Absent {
		l--
	}
	if rn.encoding.m == schema.Maybe_Absent {
		l--
	}
	if rn.signature.m == schema.Maybe_Absent {
		l--
	}
	return int64(l)
}
func (_Commit__Repr) IsAbsent() bool {
	return false
}
func (_Commit__Repr) IsNull() bool {
	return false
}
func (_Commit__Repr) AsBool() (bool, error) {
	return mixins.Map{TypeName: "ipldgit.Commit.Repr"}.AsBool()
}
func (_Commit__Repr) AsInt() (int64, error) {
	return mixins.Map{TypeName: "ipldgit.Commit.Repr"}.AsInt()
}
func (_Commit__Repr) AsFloat() (float64, error) {
	return mixins.Map{TypeName: "ipldgit.Commit.Repr"}.AsFloat()
}
func (_Commit__Repr) AsString() (string, error) {
	return mixins.Map{TypeName: "ipldgit.Commit.Repr"}.AsString()
}
func (_Commit__Repr) AsBytes() ([]byte, error) {
	return mixins.Map{TypeName: "ipldgit.Commit.Repr"}.AsBytes()
}
func (_Commit__Repr) AsLink() (ipld.Link, error) {
	return mixins.Map{TypeName: "ipldgit.Commit.Repr"}.AsLink()
}
func (_Commit__Repr) Prototype() ipld.NodePrototype {
	return _Commit__ReprPrototype{}
}

type _Commit__ReprPrototype struct{}

func (_Commit__ReprPrototype) NewBuilder() ipld.NodeBuilder {
	var nb _Commit__ReprBuilder
	nb.Reset()
	return &nb
}

type _Commit__ReprBuilder struct {
	_Commit__ReprAssembler
}

func (nb *_Commit__ReprBuilder) Build() ipld.Node {
	if *nb.m != schema.Maybe_Value {
		panic("invalid state: cannot call Build on an assembler that's not finished")
	}
	return nb.w
}
func (nb *_Commit__ReprBuilder) Reset() {
	var w _Commit
	var m schema.Maybe
	*nb = _Commit__ReprBuilder{_Commit__ReprAssembler{w: &w, m: &m}}
}

type _Commit__ReprAssembler struct {
	w     *_Commit
	m     *schema.Maybe
	state maState
	s     int
	f     int

	cm           schema.Maybe
	ca_tree      _Tree_Link__ReprAssembler
	ca_parents   _Commit_Link_List__ReprAssembler
	ca_message   _String__ReprAssembler
	ca_author    _PersonInfo__ReprAssembler
	ca_committer _PersonInfo__ReprAssembler
	ca_encoding  _String__ReprAssembler
	ca_signature _GpgSig__ReprAssembler
	ca_mergetag  _Tag_List__ReprAssembler
	ca_other     _String_List__ReprAssembler
}

func (na *_Commit__ReprAssembler) reset() {
	na.state = maState_initial
	na.s = 0
	na.ca_tree.reset()
	na.ca_parents.reset()
	na.ca_message.reset()
	na.ca_author.reset()
	na.ca_committer.reset()
	na.ca_encoding.reset()
	na.ca_signature.reset()
	na.ca_mergetag.reset()
	na.ca_other.reset()
}
func (na *_Commit__ReprAssembler) BeginMap(int64) (ipld.MapAssembler, error) {
	switch *na.m {
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: it makes no sense to 'begin' twice on the same assembler!")
	}
	*na.m = midvalue
	if na.w == nil {
		na.w = &_Commit{}
	}
	return na, nil
}
func (_Commit__ReprAssembler) BeginList(sizeHint int64) (ipld.ListAssembler, error) {
	return mixins.MapAssembler{TypeName: "ipldgit.Commit.Repr"}.BeginList(0)
}
func (na *_Commit__ReprAssembler) AssignNull() error {
	switch *na.m {
	case allowNull:
		*na.m = schema.Maybe_Null
		return nil
	case schema.Maybe_Absent:
		return mixins.MapAssembler{TypeName: "ipldgit.Commit.Repr.Repr"}.AssignNull()
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
	}
	panic("unreachable")
}
func (_Commit__ReprAssembler) AssignBool(bool) error {
	return mixins.MapAssembler{TypeName: "ipldgit.Commit.Repr"}.AssignBool(false)
}
func (_Commit__ReprAssembler) AssignInt(int64) error {
	return mixins.MapAssembler{TypeName: "ipldgit.Commit.Repr"}.AssignInt(0)
}
func (_Commit__ReprAssembler) AssignFloat(float64) error {
	return mixins.MapAssembler{TypeName: "ipldgit.Commit.Repr"}.AssignFloat(0)
}
func (_Commit__ReprAssembler) AssignString(string) error {
	return mixins.MapAssembler{TypeName: "ipldgit.Commit.Repr"}.AssignString("")
}
func (_Commit__ReprAssembler) AssignBytes([]byte) error {
	return mixins.MapAssembler{TypeName: "ipldgit.Commit.Repr"}.AssignBytes(nil)
}
func (_Commit__ReprAssembler) AssignLink(ipld.Link) error {
	return mixins.MapAssembler{TypeName: "ipldgit.Commit.Repr"}.AssignLink(nil)
}
func (na *_Commit__ReprAssembler) AssignNode(v ipld.Node) error {
	if v.IsNull() {
		return na.AssignNull()
	}
	if v2, ok := v.(*_Commit); ok {
		switch *na.m {
		case schema.Maybe_Value, schema.Maybe_Null:
			panic("invalid state: cannot assign into assembler that's already finished")
		case midvalue:
			panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
		}
		if na.w == nil {
			na.w = v2
			*na.m = schema.Maybe_Value
			return nil
		}
		*na.w = *v2
		*na.m = schema.Maybe_Value
		return nil
	}
	if v.Kind() != ipld.Kind_Map {
		return ipld.ErrWrongKind{TypeName: "ipldgit.Commit.Repr", MethodName: "AssignNode", AppropriateKind: ipld.KindSet_JustMap, ActualKind: v.Kind()}
	}
	itr := v.MapIterator()
	for !itr.Done() {
		k, v, err := itr.Next()
		if err != nil {
			return err
		}
		if err := na.AssembleKey().AssignNode(k); err != nil {
			return err
		}
		if err := na.AssembleValue().AssignNode(v); err != nil {
			return err
		}
	}
	return na.Finish()
}
func (_Commit__ReprAssembler) Prototype() ipld.NodePrototype {
	return _Commit__ReprPrototype{}
}
func (ma *_Commit__ReprAssembler) valueFinishTidy() bool {
	switch ma.f {
	case 0:
		switch ma.cm {
		case schema.Maybe_Value:
			ma.cm = schema.Maybe_Absent
			ma.state = maState_initial
			return true
		default:
			return false
		}
	case 1:
		switch ma.cm {
		case schema.Maybe_Value:
			ma.cm = schema.Maybe_Absent
			ma.state = maState_initial
			return true
		default:
			return false
		}
	case 2:
		switch ma.cm {
		case schema.Maybe_Value:
			ma.cm = schema.Maybe_Absent
			ma.state = maState_initial
			return true
		default:
			return false
		}
	case 3:
		switch ma.w.author.m {
		case schema.Maybe_Value:
			ma.w.author.v = ma.ca_author.w
			ma.state = maState_initial
			return true
		default:
			return false
		}
	case 4:
		switch ma.w.committer.m {
		case schema.Maybe_Value:
			ma.w.committer.v = ma.ca_committer.w
			ma.state = maState_initial
			return true
		default:
			return false
		}
	case 5:
		switch ma.w.encoding.m {
		case schema.Maybe_Value:
			ma.state = maState_initial
			return true
		default:
			return false
		}
	case 6:
		switch ma.w.signature.m {
		case schema.Maybe_Value:
			ma.state = maState_initial
			return true
		default:
			return false
		}
	case 7:
		switch ma.cm {
		case schema.Maybe_Value:
			ma.cm = schema.Maybe_Absent
			ma.state = maState_initial
			return true
		default:
			return false
		}
	case 8:
		switch ma.cm {
		case schema.Maybe_Value:
			ma.cm = schema.Maybe_Absent
			ma.state = maState_initial
			return true
		default:
			return false
		}
	default:
		panic("unreachable")
	}
}
func (ma *_Commit__ReprAssembler) AssembleEntry(k string) (ipld.NodeAssembler, error) {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: AssembleEntry cannot be called when in the middle of assembling another key")
	case maState_expectValue:
		panic("invalid state: AssembleEntry cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: AssembleEntry cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: AssembleEntry cannot be called on an assembler that's already finished")
	}
	switch k {
	case "tree":
		if ma.s&fieldBit__Commit_Tree != 0 {
			return nil, ipld.ErrRepeatedMapKey{Key: &fieldName__Commit_Tree_serial}
		}
		ma.s += fieldBit__Commit_Tree
		ma.state = maState_midValue
		ma.f = 0
		ma.ca_tree.w = &ma.w.tree
		ma.ca_tree.m = &ma.cm
		return &ma.ca_tree, nil
	case "parents":
		if ma.s&fieldBit__Commit_Parents != 0 {
			return nil, ipld.ErrRepeatedMapKey{Key: &fieldName__Commit_Parents_serial}
		}
		ma.s += fieldBit__Commit_Parents
		ma.state = maState_midValue
		ma.f = 1
		ma.ca_parents.w = &ma.w.parents
		ma.ca_parents.m = &ma.cm
		return &ma.ca_parents, nil
	case "message":
		if ma.s&fieldBit__Commit_Message != 0 {
			return nil, ipld.ErrRepeatedMapKey{Key: &fieldName__Commit_Message_serial}
		}
		ma.s += fieldBit__Commit_Message
		ma.state = maState_midValue
		ma.f = 2
		ma.ca_message.w = &ma.w.message
		ma.ca_message.m = &ma.cm
		return &ma.ca_message, nil
	case "author":
		if ma.s&fieldBit__Commit_Author != 0 {
			return nil, ipld.ErrRepeatedMapKey{Key: &fieldName__Commit_Author_serial}
		}
		ma.s += fieldBit__Commit_Author
		ma.state = maState_midValue
		ma.f = 3
		ma.ca_author.w = ma.w.author.v
		ma.ca_author.m = &ma.w.author.m

		return &ma.ca_author, nil
	case "committer":
		if ma.s&fieldBit__Commit_Committer != 0 {
			return nil, ipld.ErrRepeatedMapKey{Key: &fieldName__Commit_Committer_serial}
		}
		ma.s += fieldBit__Commit_Committer
		ma.state = maState_midValue
		ma.f = 4
		ma.ca_committer.w = ma.w.committer.v
		ma.ca_committer.m = &ma.w.committer.m

		return &ma.ca_committer, nil
	case "encoding":
		if ma.s&fieldBit__Commit_Encoding != 0 {
			return nil, ipld.ErrRepeatedMapKey{Key: &fieldName__Commit_Encoding_serial}
		}
		ma.s += fieldBit__Commit_Encoding
		ma.state = maState_midValue
		ma.f = 5
		ma.ca_encoding.w = &ma.w.encoding.v
		ma.ca_encoding.m = &ma.w.encoding.m

		return &ma.ca_encoding, nil
	case "signature":
		if ma.s&fieldBit__Commit_Signature != 0 {
			return nil, ipld.ErrRepeatedMapKey{Key: &fieldName__Commit_Signature_serial}
		}
		ma.s += fieldBit__Commit_Signature
		ma.state = maState_midValue
		ma.f = 6
		ma.ca_signature.w = &ma.w.signature.v
		ma.ca_signature.m = &ma.w.signature.m

		return &ma.ca_signature, nil
	case "mergetag":
		if ma.s&fieldBit__Commit_Mergetag != 0 {
			return nil, ipld.ErrRepeatedMapKey{Key: &fieldName__Commit_Mergetag_serial}
		}
		ma.s += fieldBit__Commit_Mergetag
		ma.state = maState_midValue
		ma.f = 7
		ma.ca_mergetag.w = &ma.w.mergetag
		ma.ca_mergetag.m = &ma.cm
		return &ma.ca_mergetag, nil
	case "other":
		if ma.s&fieldBit__Commit_Other != 0 {
			return nil, ipld.ErrRepeatedMapKey{Key: &fieldName__Commit_Other_serial}
		}
		ma.s += fieldBit__Commit_Other
		ma.state = maState_midValue
		ma.f = 8
		ma.ca_other.w = &ma.w.other
		ma.ca_other.m = &ma.cm
		return &ma.ca_other, nil
	default:
	}
	return nil, ipld.ErrInvalidKey{TypeName: "ipldgit.Commit.Repr", Key: &_String{k}}
}
func (ma *_Commit__ReprAssembler) AssembleKey() ipld.NodeAssembler {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: AssembleKey cannot be called when in the middle of assembling another key")
	case maState_expectValue:
		panic("invalid state: AssembleKey cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: AssembleKey cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: AssembleKey cannot be called on an assembler that's already finished")
	}
	ma.state = maState_midKey
	return (*_Commit__ReprKeyAssembler)(ma)
}
func (ma *_Commit__ReprAssembler) AssembleValue() ipld.NodeAssembler {
	switch ma.state {
	case maState_initial:
		panic("invalid state: AssembleValue cannot be called when no key is primed")
	case maState_midKey:
		panic("invalid state: AssembleValue cannot be called when in the middle of assembling a key")
	case maState_expectValue:
		// carry on
	case maState_midValue:
		panic("invalid state: AssembleValue cannot be called when in the middle of assembling another value")
	case maState_finished:
		panic("invalid state: AssembleValue cannot be called on an assembler that's already finished")
	}
	ma.state = maState_midValue
	switch ma.f {
	case 0:
		ma.ca_tree.w = &ma.w.tree
		ma.ca_tree.m = &ma.cm
		return &ma.ca_tree
	case 1:
		ma.ca_parents.w = &ma.w.parents
		ma.ca_parents.m = &ma.cm
		return &ma.ca_parents
	case 2:
		ma.ca_message.w = &ma.w.message
		ma.ca_message.m = &ma.cm
		return &ma.ca_message
	case 3:
		ma.ca_author.w = ma.w.author.v
		ma.ca_author.m = &ma.w.author.m

		return &ma.ca_author
	case 4:
		ma.ca_committer.w = ma.w.committer.v
		ma.ca_committer.m = &ma.w.committer.m

		return &ma.ca_committer
	case 5:
		ma.ca_encoding.w = &ma.w.encoding.v
		ma.ca_encoding.m = &ma.w.encoding.m

		return &ma.ca_encoding
	case 6:
		ma.ca_signature.w = &ma.w.signature.v
		ma.ca_signature.m = &ma.w.signature.m

		return &ma.ca_signature
	case 7:
		ma.ca_mergetag.w = &ma.w.mergetag
		ma.ca_mergetag.m = &ma.cm
		return &ma.ca_mergetag
	case 8:
		ma.ca_other.w = &ma.w.other
		ma.ca_other.m = &ma.cm
		return &ma.ca_other
	default:
		panic("unreachable")
	}
}
func (ma *_Commit__ReprAssembler) Finish() error {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: Finish cannot be called when in the middle of assembling a key")
	case maState_expectValue:
		panic("invalid state: Finish cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: Finish cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: Finish cannot be called on an assembler that's already finished")
	}
	if ma.s&fieldBits__Commit_sufficient != fieldBits__Commit_sufficient {
		err := ipld.ErrMissingRequiredField{Missing: make([]string, 0)}
		if ma.s&fieldBit__Commit_Tree == 0 {
			err.Missing = append(err.Missing, "tree")
		}
		if ma.s&fieldBit__Commit_Parents == 0 {
			err.Missing = append(err.Missing, "parents")
		}
		if ma.s&fieldBit__Commit_Message == 0 {
			err.Missing = append(err.Missing, "message")
		}
		if ma.s&fieldBit__Commit_Mergetag == 0 {
			err.Missing = append(err.Missing, "mergetag")
		}
		if ma.s&fieldBit__Commit_Other == 0 {
			err.Missing = append(err.Missing, "other")
		}
		return err
	}
	ma.state = maState_finished
	*ma.m = schema.Maybe_Value
	return nil
}
func (ma *_Commit__ReprAssembler) KeyPrototype() ipld.NodePrototype {
	return _String__Prototype{}
}
func (ma *_Commit__ReprAssembler) ValuePrototype(k string) ipld.NodePrototype {
	panic("todo structbuilder mapassembler repr valueprototype")
}

type _Commit__ReprKeyAssembler _Commit__ReprAssembler

func (_Commit__ReprKeyAssembler) BeginMap(sizeHint int64) (ipld.MapAssembler, error) {
	return mixins.StringAssembler{TypeName: "ipldgit.Commit.Repr.KeyAssembler"}.BeginMap(0)
}
func (_Commit__ReprKeyAssembler) BeginList(sizeHint int64) (ipld.ListAssembler, error) {
	return mixins.StringAssembler{TypeName: "ipldgit.Commit.Repr.KeyAssembler"}.BeginList(0)
}
func (na *_Commit__ReprKeyAssembler) AssignNull() error {
	return mixins.StringAssembler{TypeName: "ipldgit.Commit.Repr.KeyAssembler"}.AssignNull()
}
func (_Commit__ReprKeyAssembler) AssignBool(bool) error {
	return mixins.StringAssembler{TypeName: "ipldgit.Commit.Repr.KeyAssembler"}.AssignBool(false)
}
func (_Commit__ReprKeyAssembler) AssignInt(int64) error {
	return mixins.StringAssembler{TypeName: "ipldgit.Commit.Repr.KeyAssembler"}.AssignInt(0)
}
func (_Commit__ReprKeyAssembler) AssignFloat(float64) error {
	return mixins.StringAssembler{TypeName: "ipldgit.Commit.Repr.KeyAssembler"}.AssignFloat(0)
}
func (ka *_Commit__ReprKeyAssembler) AssignString(k string) error {
	if ka.state != maState_midKey {
		panic("misuse: KeyAssembler held beyond its valid lifetime")
	}
	switch k {
	case "tree":
		if ka.s&fieldBit__Commit_Tree != 0 {
			return ipld.ErrRepeatedMapKey{Key: &fieldName__Commit_Tree_serial}
		}
		ka.s += fieldBit__Commit_Tree
		ka.state = maState_expectValue
		ka.f = 0
		return nil
	case "parents":
		if ka.s&fieldBit__Commit_Parents != 0 {
			return ipld.ErrRepeatedMapKey{Key: &fieldName__Commit_Parents_serial}
		}
		ka.s += fieldBit__Commit_Parents
		ka.state = maState_expectValue
		ka.f = 1
		return nil
	case "message":
		if ka.s&fieldBit__Commit_Message != 0 {
			return ipld.ErrRepeatedMapKey{Key: &fieldName__Commit_Message_serial}
		}
		ka.s += fieldBit__Commit_Message
		ka.state = maState_expectValue
		ka.f = 2
		return nil
	case "author":
		if ka.s&fieldBit__Commit_Author != 0 {
			return ipld.ErrRepeatedMapKey{Key: &fieldName__Commit_Author_serial}
		}
		ka.s += fieldBit__Commit_Author
		ka.state = maState_expectValue
		ka.f = 3
		return nil
	case "committer":
		if ka.s&fieldBit__Commit_Committer != 0 {
			return ipld.ErrRepeatedMapKey{Key: &fieldName__Commit_Committer_serial}
		}
		ka.s += fieldBit__Commit_Committer
		ka.state = maState_expectValue
		ka.f = 4
		return nil
	case "encoding":
		if ka.s&fieldBit__Commit_Encoding != 0 {
			return ipld.ErrRepeatedMapKey{Key: &fieldName__Commit_Encoding_serial}
		}
		ka.s += fieldBit__Commit_Encoding
		ka.state = maState_expectValue
		ka.f = 5
		return nil
	case "signature":
		if ka.s&fieldBit__Commit_Signature != 0 {
			return ipld.ErrRepeatedMapKey{Key: &fieldName__Commit_Signature_serial}
		}
		ka.s += fieldBit__Commit_Signature
		ka.state = maState_expectValue
		ka.f = 6
		return nil
	case "mergetag":
		if ka.s&fieldBit__Commit_Mergetag != 0 {
			return ipld.ErrRepeatedMapKey{Key: &fieldName__Commit_Mergetag_serial}
		}
		ka.s += fieldBit__Commit_Mergetag
		ka.state = maState_expectValue
		ka.f = 7
		return nil
	case "other":
		if ka.s&fieldBit__Commit_Other != 0 {
			return ipld.ErrRepeatedMapKey{Key: &fieldName__Commit_Other_serial}
		}
		ka.s += fieldBit__Commit_Other
		ka.state = maState_expectValue
		ka.f = 8
		return nil
	}
	return ipld.ErrInvalidKey{TypeName: "ipldgit.Commit.Repr", Key: &_String{k}}
}
func (_Commit__ReprKeyAssembler) AssignBytes([]byte) error {
	return mixins.StringAssembler{TypeName: "ipldgit.Commit.Repr.KeyAssembler"}.AssignBytes(nil)
}
func (_Commit__ReprKeyAssembler) AssignLink(ipld.Link) error {
	return mixins.StringAssembler{TypeName: "ipldgit.Commit.Repr.KeyAssembler"}.AssignLink(nil)
}
func (ka *_Commit__ReprKeyAssembler) AssignNode(v ipld.Node) error {
	if v2, err := v.AsString(); err != nil {
		return err
	} else {
		return ka.AssignString(v2)
	}
}
func (_Commit__ReprKeyAssembler) Prototype() ipld.NodePrototype {
	return _String__Prototype{}
}

func (n Commit_Link) Link() ipld.Link {
	return n.x
}
func (_Commit_Link__Prototype) FromLink(v ipld.Link) (Commit_Link, error) {
	n := _Commit_Link{v}
	return &n, nil
}

type _Commit_Link__Maybe struct {
	m schema.Maybe
	v _Commit_Link
}
type MaybeCommit_Link = *_Commit_Link__Maybe

func (m MaybeCommit_Link) IsNull() bool {
	return m.m == schema.Maybe_Null
}
func (m MaybeCommit_Link) IsAbsent() bool {
	return m.m == schema.Maybe_Absent
}
func (m MaybeCommit_Link) Exists() bool {
	return m.m == schema.Maybe_Value
}
func (m MaybeCommit_Link) AsNode() ipld.Node {
	switch m.m {
	case schema.Maybe_Absent:
		return ipld.Absent
	case schema.Maybe_Null:
		return ipld.Null
	case schema.Maybe_Value:
		return &m.v
	default:
		panic("unreachable")
	}
}
func (m MaybeCommit_Link) Must() Commit_Link {
	if !m.Exists() {
		panic("unbox of a maybe rejected")
	}
	return &m.v
}

var _ ipld.Node = (Commit_Link)(&_Commit_Link{})
var _ schema.TypedNode = (Commit_Link)(&_Commit_Link{})

func (Commit_Link) Kind() ipld.Kind {
	return ipld.Kind_Link
}
func (Commit_Link) LookupByString(string) (ipld.Node, error) {
	return mixins.Link{TypeName: "ipldgit.Commit_Link"}.LookupByString("")
}
func (Commit_Link) LookupByNode(ipld.Node) (ipld.Node, error) {
	return mixins.Link{TypeName: "ipldgit.Commit_Link"}.LookupByNode(nil)
}
func (Commit_Link) LookupByIndex(idx int64) (ipld.Node, error) {
	return mixins.Link{TypeName: "ipldgit.Commit_Link"}.LookupByIndex(0)
}
func (Commit_Link) LookupBySegment(seg ipld.PathSegment) (ipld.Node, error) {
	return mixins.Link{TypeName: "ipldgit.Commit_Link"}.LookupBySegment(seg)
}
func (Commit_Link) MapIterator() ipld.MapIterator {
	return nil
}
func (Commit_Link) ListIterator() ipld.ListIterator {
	return nil
}
func (Commit_Link) Length() int64 {
	return -1
}
func (Commit_Link) IsAbsent() bool {
	return false
}
func (Commit_Link) IsNull() bool {
	return false
}
func (Commit_Link) AsBool() (bool, error) {
	return mixins.Link{TypeName: "ipldgit.Commit_Link"}.AsBool()
}
func (Commit_Link) AsInt() (int64, error) {
	return mixins.Link{TypeName: "ipldgit.Commit_Link"}.AsInt()
}
func (Commit_Link) AsFloat() (float64, error) {
	return mixins.Link{TypeName: "ipldgit.Commit_Link"}.AsFloat()
}
func (Commit_Link) AsString() (string, error) {
	return mixins.Link{TypeName: "ipldgit.Commit_Link"}.AsString()
}
func (Commit_Link) AsBytes() ([]byte, error) {
	return mixins.Link{TypeName: "ipldgit.Commit_Link"}.AsBytes()
}
func (n Commit_Link) AsLink() (ipld.Link, error) {
	return n.x, nil
}
func (Commit_Link) Prototype() ipld.NodePrototype {
	return _Commit_Link__Prototype{}
}

type _Commit_Link__Prototype struct{}

func (_Commit_Link__Prototype) NewBuilder() ipld.NodeBuilder {
	var nb _Commit_Link__Builder
	nb.Reset()
	return &nb
}

type _Commit_Link__Builder struct {
	_Commit_Link__Assembler
}

func (nb *_Commit_Link__Builder) Build() ipld.Node {
	if *nb.m != schema.Maybe_Value {
		panic("invalid state: cannot call Build on an assembler that's not finished")
	}
	return nb.w
}
func (nb *_Commit_Link__Builder) Reset() {
	var w _Commit_Link
	var m schema.Maybe
	*nb = _Commit_Link__Builder{_Commit_Link__Assembler{w: &w, m: &m}}
}

type _Commit_Link__Assembler struct {
	w *_Commit_Link
	m *schema.Maybe
}

func (na *_Commit_Link__Assembler) reset() {}
func (_Commit_Link__Assembler) BeginMap(sizeHint int64) (ipld.MapAssembler, error) {
	return mixins.LinkAssembler{TypeName: "ipldgit.Commit_Link"}.BeginMap(0)
}
func (_Commit_Link__Assembler) BeginList(sizeHint int64) (ipld.ListAssembler, error) {
	return mixins.LinkAssembler{TypeName: "ipldgit.Commit_Link"}.BeginList(0)
}
func (na *_Commit_Link__Assembler) AssignNull() error {
	switch *na.m {
	case allowNull:
		*na.m = schema.Maybe_Null
		return nil
	case schema.Maybe_Absent:
		return mixins.LinkAssembler{TypeName: "ipldgit.Commit_Link"}.AssignNull()
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	}
	panic("unreachable")
}
func (_Commit_Link__Assembler) AssignBool(bool) error {
	return mixins.LinkAssembler{TypeName: "ipldgit.Commit_Link"}.AssignBool(false)
}
func (_Commit_Link__Assembler) AssignInt(int64) error {
	return mixins.LinkAssembler{TypeName: "ipldgit.Commit_Link"}.AssignInt(0)
}
func (_Commit_Link__Assembler) AssignFloat(float64) error {
	return mixins.LinkAssembler{TypeName: "ipldgit.Commit_Link"}.AssignFloat(0)
}
func (_Commit_Link__Assembler) AssignString(string) error {
	return mixins.LinkAssembler{TypeName: "ipldgit.Commit_Link"}.AssignString("")
}
func (_Commit_Link__Assembler) AssignBytes([]byte) error {
	return mixins.LinkAssembler{TypeName: "ipldgit.Commit_Link"}.AssignBytes(nil)
}
func (na *_Commit_Link__Assembler) AssignLink(v ipld.Link) error {
	switch *na.m {
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	}
	na.w.x = v
	*na.m = schema.Maybe_Value
	return nil
}
func (na *_Commit_Link__Assembler) AssignNode(v ipld.Node) error {
	if v.IsNull() {
		return na.AssignNull()
	}
	if v2, ok := v.(*_Commit_Link); ok {
		switch *na.m {
		case schema.Maybe_Value, schema.Maybe_Null:
			panic("invalid state: cannot assign into assembler that's already finished")
		}
		*na.w = *v2
		*na.m = schema.Maybe_Value
		return nil
	}
	if v2, err := v.AsLink(); err != nil {
		return err
	} else {
		return na.AssignLink(v2)
	}
}
func (_Commit_Link__Assembler) Prototype() ipld.NodePrototype {
	return _Commit_Link__Prototype{}
}
func (Commit_Link) Type() schema.Type {
	return nil /*TODO:typelit*/
}
func (Commit_Link) LinkTargetNodePrototype() ipld.NodePrototype {
	return Type.Commit__Repr
}
func (n Commit_Link) Representation() ipld.Node {
	return (*_Commit_Link__Repr)(n)
}

type _Commit_Link__Repr = _Commit_Link

var _ ipld.Node = &_Commit_Link__Repr{}

type _Commit_Link__ReprPrototype = _Commit_Link__Prototype
type _Commit_Link__ReprAssembler = _Commit_Link__Assembler

func (n *_Commit_Link_List) Lookup(idx int64) Commit_Link {
	if n.Length() <= idx {
		return nil
	}
	v := &n.x[idx]
	return v
}
func (n *_Commit_Link_List) LookupMaybe(idx int64) MaybeCommit_Link {
	if n.Length() <= idx {
		return nil
	}
	v := &n.x[idx]
	return &_Commit_Link__Maybe{
		m: schema.Maybe_Value,
		v: *v,
	}
}

var _Commit_Link_List__valueAbsent = _Commit_Link__Maybe{m: schema.Maybe_Absent}

func (n Commit_Link_List) Iterator() *Commit_Link_List__Itr {
	return &Commit_Link_List__Itr{n, 0}
}

type Commit_Link_List__Itr struct {
	n   Commit_Link_List
	idx int
}

func (itr *Commit_Link_List__Itr) Next() (idx int64, v Commit_Link) {
	if itr.idx >= len(itr.n.x) {
		return -1, nil
	}
	idx = int64(itr.idx)
	v = &itr.n.x[itr.idx]
	itr.idx++
	return
}
func (itr *Commit_Link_List__Itr) Done() bool {
	return itr.idx >= len(itr.n.x)
}

type _Commit_Link_List__Maybe struct {
	m schema.Maybe
	v _Commit_Link_List
}
type MaybeCommit_Link_List = *_Commit_Link_List__Maybe

func (m MaybeCommit_Link_List) IsNull() bool {
	return m.m == schema.Maybe_Null
}
func (m MaybeCommit_Link_List) IsAbsent() bool {
	return m.m == schema.Maybe_Absent
}
func (m MaybeCommit_Link_List) Exists() bool {
	return m.m == schema.Maybe_Value
}
func (m MaybeCommit_Link_List) AsNode() ipld.Node {
	switch m.m {
	case schema.Maybe_Absent:
		return ipld.Absent
	case schema.Maybe_Null:
		return ipld.Null
	case schema.Maybe_Value:
		return &m.v
	default:
		panic("unreachable")
	}
}
func (m MaybeCommit_Link_List) Must() Commit_Link_List {
	if !m.Exists() {
		panic("unbox of a maybe rejected")
	}
	return &m.v
}

var _ ipld.Node = (Commit_Link_List)(&_Commit_Link_List{})
var _ schema.TypedNode = (Commit_Link_List)(&_Commit_Link_List{})

func (Commit_Link_List) Kind() ipld.Kind {
	return ipld.Kind_List
}
func (Commit_Link_List) LookupByString(string) (ipld.Node, error) {
	return mixins.List{TypeName: "ipldgit.Commit_Link_List"}.LookupByString("")
}
func (n Commit_Link_List) LookupByNode(k ipld.Node) (ipld.Node, error) {
	idx, err := k.AsInt()
	if err != nil {
		return nil, err
	}
	return n.LookupByIndex(idx)
}
func (n Commit_Link_List) LookupByIndex(idx int64) (ipld.Node, error) {
	if n.Length() <= idx {
		return nil, ipld.ErrNotExists{Segment: ipld.PathSegmentOfInt(idx)}
	}
	v := &n.x[idx]
	return v, nil
}
func (n Commit_Link_List) LookupBySegment(seg ipld.PathSegment) (ipld.Node, error) {
	i, err := seg.Index()
	if err != nil {
		return nil, ipld.ErrInvalidSegmentForList{TypeName: "ipldgit.Commit_Link_List", TroubleSegment: seg, Reason: err}
	}
	return n.LookupByIndex(i)
}
func (Commit_Link_List) MapIterator() ipld.MapIterator {
	return nil
}
func (n Commit_Link_List) ListIterator() ipld.ListIterator {
	return &_Commit_Link_List__ListItr{n, 0}
}

type _Commit_Link_List__ListItr struct {
	n   Commit_Link_List
	idx int
}

func (itr *_Commit_Link_List__ListItr) Next() (idx int64, v ipld.Node, _ error) {
	if itr.idx >= len(itr.n.x) {
		return -1, nil, ipld.ErrIteratorOverread{}
	}
	idx = int64(itr.idx)
	x := &itr.n.x[itr.idx]
	v = x
	itr.idx++
	return
}
func (itr *_Commit_Link_List__ListItr) Done() bool {
	return itr.idx >= len(itr.n.x)
}

func (n Commit_Link_List) Length() int64 {
	return int64(len(n.x))
}
func (Commit_Link_List) IsAbsent() bool {
	return false
}
func (Commit_Link_List) IsNull() bool {
	return false
}
func (Commit_Link_List) AsBool() (bool, error) {
	return mixins.List{TypeName: "ipldgit.Commit_Link_List"}.AsBool()
}
func (Commit_Link_List) AsInt() (int64, error) {
	return mixins.List{TypeName: "ipldgit.Commit_Link_List"}.AsInt()
}
func (Commit_Link_List) AsFloat() (float64, error) {
	return mixins.List{TypeName: "ipldgit.Commit_Link_List"}.AsFloat()
}
func (Commit_Link_List) AsString() (string, error) {
	return mixins.List{TypeName: "ipldgit.Commit_Link_List"}.AsString()
}
func (Commit_Link_List) AsBytes() ([]byte, error) {
	return mixins.List{TypeName: "ipldgit.Commit_Link_List"}.AsBytes()
}
func (Commit_Link_List) AsLink() (ipld.Link, error) {
	return mixins.List{TypeName: "ipldgit.Commit_Link_List"}.AsLink()
}
func (Commit_Link_List) Prototype() ipld.NodePrototype {
	return _Commit_Link_List__Prototype{}
}

type _Commit_Link_List__Prototype struct{}

func (_Commit_Link_List__Prototype) NewBuilder() ipld.NodeBuilder {
	var nb _Commit_Link_List__Builder
	nb.Reset()
	return &nb
}

type _Commit_Link_List__Builder struct {
	_Commit_Link_List__Assembler
}

func (nb *_Commit_Link_List__Builder) Build() ipld.Node {
	if *nb.m != schema.Maybe_Value {
		panic("invalid state: cannot call Build on an assembler that's not finished")
	}
	return nb.w
}
func (nb *_Commit_Link_List__Builder) Reset() {
	var w _Commit_Link_List
	var m schema.Maybe
	*nb = _Commit_Link_List__Builder{_Commit_Link_List__Assembler{w: &w, m: &m}}
}

type _Commit_Link_List__Assembler struct {
	w     *_Commit_Link_List
	m     *schema.Maybe
	state laState

	cm schema.Maybe
	va _Commit_Link__Assembler
}

func (na *_Commit_Link_List__Assembler) reset() {
	na.state = laState_initial
	na.va.reset()
}
func (_Commit_Link_List__Assembler) BeginMap(sizeHint int64) (ipld.MapAssembler, error) {
	return mixins.ListAssembler{TypeName: "ipldgit.Commit_Link_List"}.BeginMap(0)
}
func (na *_Commit_Link_List__Assembler) BeginList(sizeHint int64) (ipld.ListAssembler, error) {
	switch *na.m {
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: it makes no sense to 'begin' twice on the same assembler!")
	}
	*na.m = midvalue
	if sizeHint < 0 {
		sizeHint = 0
	}
	if sizeHint > 0 {
		na.w.x = make([]_Commit_Link, 0, sizeHint)
	}
	return na, nil
}
func (na *_Commit_Link_List__Assembler) AssignNull() error {
	switch *na.m {
	case allowNull:
		*na.m = schema.Maybe_Null
		return nil
	case schema.Maybe_Absent:
		return mixins.ListAssembler{TypeName: "ipldgit.Commit_Link_List"}.AssignNull()
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
	}
	panic("unreachable")
}
func (_Commit_Link_List__Assembler) AssignBool(bool) error {
	return mixins.ListAssembler{TypeName: "ipldgit.Commit_Link_List"}.AssignBool(false)
}
func (_Commit_Link_List__Assembler) AssignInt(int64) error {
	return mixins.ListAssembler{TypeName: "ipldgit.Commit_Link_List"}.AssignInt(0)
}
func (_Commit_Link_List__Assembler) AssignFloat(float64) error {
	return mixins.ListAssembler{TypeName: "ipldgit.Commit_Link_List"}.AssignFloat(0)
}
func (_Commit_Link_List__Assembler) AssignString(string) error {
	return mixins.ListAssembler{TypeName: "ipldgit.Commit_Link_List"}.AssignString("")
}
func (_Commit_Link_List__Assembler) AssignBytes([]byte) error {
	return mixins.ListAssembler{TypeName: "ipldgit.Commit_Link_List"}.AssignBytes(nil)
}
func (_Commit_Link_List__Assembler) AssignLink(ipld.Link) error {
	return mixins.ListAssembler{TypeName: "ipldgit.Commit_Link_List"}.AssignLink(nil)
}
func (na *_Commit_Link_List__Assembler) AssignNode(v ipld.Node) error {
	if v.IsNull() {
		return na.AssignNull()
	}
	if v2, ok := v.(*_Commit_Link_List); ok {
		switch *na.m {
		case schema.Maybe_Value, schema.Maybe_Null:
			panic("invalid state: cannot assign into assembler that's already finished")
		case midvalue:
			panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
		}
		*na.w = *v2
		*na.m = schema.Maybe_Value
		return nil
	}
	if v.Kind() != ipld.Kind_List {
		return ipld.ErrWrongKind{TypeName: "ipldgit.Commit_Link_List", MethodName: "AssignNode", AppropriateKind: ipld.KindSet_JustList, ActualKind: v.Kind()}
	}
	itr := v.ListIterator()
	for !itr.Done() {
		_, v, err := itr.Next()
		if err != nil {
			return err
		}
		if err := na.AssembleValue().AssignNode(v); err != nil {
			return err
		}
	}
	return na.Finish()
}
func (_Commit_Link_List__Assembler) Prototype() ipld.NodePrototype {
	return _Commit_Link_List__Prototype{}
}
func (la *_Commit_Link_List__Assembler) valueFinishTidy() bool {
	switch la.cm {
	case schema.Maybe_Value:
		la.va.w = nil
		la.cm = schema.Maybe_Absent
		la.state = laState_initial
		la.va.reset()
		return true
	default:
		return false
	}
}
func (la *_Commit_Link_List__Assembler) AssembleValue() ipld.NodeAssembler {
	switch la.state {
	case laState_initial:
		// carry on
	case laState_midValue:
		if !la.valueFinishTidy() {
			panic("invalid state: AssembleValue cannot be called when still in the middle of assembling the previous value")
		} // if tidy success: carry on
	case laState_finished:
		panic("invalid state: AssembleValue cannot be called on an assembler that's already finished")
	}
	la.w.x = append(la.w.x, _Commit_Link{})
	la.state = laState_midValue
	row := &la.w.x[len(la.w.x)-1]
	la.va.w = row
	la.va.m = &la.cm
	return &la.va
}
func (la *_Commit_Link_List__Assembler) Finish() error {
	switch la.state {
	case laState_initial:
		// carry on
	case laState_midValue:
		if !la.valueFinishTidy() {
			panic("invalid state: Finish cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case laState_finished:
		panic("invalid state: Finish cannot be called on an assembler that's already finished")
	}
	la.state = laState_finished
	*la.m = schema.Maybe_Value
	return nil
}
func (la *_Commit_Link_List__Assembler) ValuePrototype(_ int64) ipld.NodePrototype {
	return _Commit_Link__Prototype{}
}
func (Commit_Link_List) Type() schema.Type {
	return nil /*TODO:typelit*/
}
func (n Commit_Link_List) Representation() ipld.Node {
	return (*_Commit_Link_List__Repr)(n)
}

type _Commit_Link_List__Repr _Commit_Link_List

var _ ipld.Node = &_Commit_Link_List__Repr{}

func (_Commit_Link_List__Repr) Kind() ipld.Kind {
	return ipld.Kind_List
}
func (_Commit_Link_List__Repr) LookupByString(string) (ipld.Node, error) {
	return mixins.List{TypeName: "ipldgit.Commit_Link_List.Repr"}.LookupByString("")
}
func (nr *_Commit_Link_List__Repr) LookupByNode(k ipld.Node) (ipld.Node, error) {
	v, err := (Commit_Link_List)(nr).LookupByNode(k)
	if err != nil || v == ipld.Null {
		return v, err
	}
	return v.(Commit_Link).Representation(), nil
}
func (nr *_Commit_Link_List__Repr) LookupByIndex(idx int64) (ipld.Node, error) {
	v, err := (Commit_Link_List)(nr).LookupByIndex(idx)
	if err != nil || v == ipld.Null {
		return v, err
	}
	return v.(Commit_Link).Representation(), nil
}
func (n _Commit_Link_List__Repr) LookupBySegment(seg ipld.PathSegment) (ipld.Node, error) {
	i, err := seg.Index()
	if err != nil {
		return nil, ipld.ErrInvalidSegmentForList{TypeName: "ipldgit.Commit_Link_List.Repr", TroubleSegment: seg, Reason: err}
	}
	return n.LookupByIndex(i)
}
func (_Commit_Link_List__Repr) MapIterator() ipld.MapIterator {
	return nil
}
func (nr *_Commit_Link_List__Repr) ListIterator() ipld.ListIterator {
	return &_Commit_Link_List__ReprListItr{(Commit_Link_List)(nr), 0}
}

type _Commit_Link_List__ReprListItr _Commit_Link_List__ListItr

func (itr *_Commit_Link_List__ReprListItr) Next() (idx int64, v ipld.Node, err error) {
	idx, v, err = (*_Commit_Link_List__ListItr)(itr).Next()
	if err != nil || v == ipld.Null {
		return
	}
	return idx, v.(Commit_Link).Representation(), nil
}
func (itr *_Commit_Link_List__ReprListItr) Done() bool {
	return (*_Commit_Link_List__ListItr)(itr).Done()
}

func (rn *_Commit_Link_List__Repr) Length() int64 {
	return int64(len(rn.x))
}
func (_Commit_Link_List__Repr) IsAbsent() bool {
	return false
}
func (_Commit_Link_List__Repr) IsNull() bool {
	return false
}
func (_Commit_Link_List__Repr) AsBool() (bool, error) {
	return mixins.List{TypeName: "ipldgit.Commit_Link_List.Repr"}.AsBool()
}
func (_Commit_Link_List__Repr) AsInt() (int64, error) {
	return mixins.List{TypeName: "ipldgit.Commit_Link_List.Repr"}.AsInt()
}
func (_Commit_Link_List__Repr) AsFloat() (float64, error) {
	return mixins.List{TypeName: "ipldgit.Commit_Link_List.Repr"}.AsFloat()
}
func (_Commit_Link_List__Repr) AsString() (string, error) {
	return mixins.List{TypeName: "ipldgit.Commit_Link_List.Repr"}.AsString()
}
func (_Commit_Link_List__Repr) AsBytes() ([]byte, error) {
	return mixins.List{TypeName: "ipldgit.Commit_Link_List.Repr"}.AsBytes()
}
func (_Commit_Link_List__Repr) AsLink() (ipld.Link, error) {
	return mixins.List{TypeName: "ipldgit.Commit_Link_List.Repr"}.AsLink()
}
func (_Commit_Link_List__Repr) Prototype() ipld.NodePrototype {
	return _Commit_Link_List__ReprPrototype{}
}

type _Commit_Link_List__ReprPrototype struct{}

func (_Commit_Link_List__ReprPrototype) NewBuilder() ipld.NodeBuilder {
	var nb _Commit_Link_List__ReprBuilder
	nb.Reset()
	return &nb
}

type _Commit_Link_List__ReprBuilder struct {
	_Commit_Link_List__ReprAssembler
}

func (nb *_Commit_Link_List__ReprBuilder) Build() ipld.Node {
	if *nb.m != schema.Maybe_Value {
		panic("invalid state: cannot call Build on an assembler that's not finished")
	}
	return nb.w
}
func (nb *_Commit_Link_List__ReprBuilder) Reset() {
	var w _Commit_Link_List
	var m schema.Maybe
	*nb = _Commit_Link_List__ReprBuilder{_Commit_Link_List__ReprAssembler{w: &w, m: &m}}
}

type _Commit_Link_List__ReprAssembler struct {
	w     *_Commit_Link_List
	m     *schema.Maybe
	state laState

	cm schema.Maybe
	va _Commit_Link__ReprAssembler
}

func (na *_Commit_Link_List__ReprAssembler) reset() {
	na.state = laState_initial
	na.va.reset()
}
func (_Commit_Link_List__ReprAssembler) BeginMap(sizeHint int64) (ipld.MapAssembler, error) {
	return mixins.ListAssembler{TypeName: "ipldgit.Commit_Link_List.Repr"}.BeginMap(0)
}
func (na *_Commit_Link_List__ReprAssembler) BeginList(sizeHint int64) (ipld.ListAssembler, error) {
	switch *na.m {
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: it makes no sense to 'begin' twice on the same assembler!")
	}
	*na.m = midvalue
	if sizeHint < 0 {
		sizeHint = 0
	}
	if sizeHint > 0 {
		na.w.x = make([]_Commit_Link, 0, sizeHint)
	}
	return na, nil
}
func (na *_Commit_Link_List__ReprAssembler) AssignNull() error {
	switch *na.m {
	case allowNull:
		*na.m = schema.Maybe_Null
		return nil
	case schema.Maybe_Absent:
		return mixins.ListAssembler{TypeName: "ipldgit.Commit_Link_List.Repr.Repr"}.AssignNull()
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
	}
	panic("unreachable")
}
func (_Commit_Link_List__ReprAssembler) AssignBool(bool) error {
	return mixins.ListAssembler{TypeName: "ipldgit.Commit_Link_List.Repr"}.AssignBool(false)
}
func (_Commit_Link_List__ReprAssembler) AssignInt(int64) error {
	return mixins.ListAssembler{TypeName: "ipldgit.Commit_Link_List.Repr"}.AssignInt(0)
}
func (_Commit_Link_List__ReprAssembler) AssignFloat(float64) error {
	return mixins.ListAssembler{TypeName: "ipldgit.Commit_Link_List.Repr"}.AssignFloat(0)
}
func (_Commit_Link_List__ReprAssembler) AssignString(string) error {
	return mixins.ListAssembler{TypeName: "ipldgit.Commit_Link_List.Repr"}.AssignString("")
}
func (_Commit_Link_List__ReprAssembler) AssignBytes([]byte) error {
	return mixins.ListAssembler{TypeName: "ipldgit.Commit_Link_List.Repr"}.AssignBytes(nil)
}
func (_Commit_Link_List__ReprAssembler) AssignLink(ipld.Link) error {
	return mixins.ListAssembler{TypeName: "ipldgit.Commit_Link_List.Repr"}.AssignLink(nil)
}
func (na *_Commit_Link_List__ReprAssembler) AssignNode(v ipld.Node) error {
	if v.IsNull() {
		return na.AssignNull()
	}
	if v2, ok := v.(*_Commit_Link_List); ok {
		switch *na.m {
		case schema.Maybe_Value, schema.Maybe_Null:
			panic("invalid state: cannot assign into assembler that's already finished")
		case midvalue:
			panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
		}
		*na.w = *v2
		*na.m = schema.Maybe_Value
		return nil
	}
	if v.Kind() != ipld.Kind_List {
		return ipld.ErrWrongKind{TypeName: "ipldgit.Commit_Link_List.Repr", MethodName: "AssignNode", AppropriateKind: ipld.KindSet_JustList, ActualKind: v.Kind()}
	}
	itr := v.ListIterator()
	for !itr.Done() {
		_, v, err := itr.Next()
		if err != nil {
			return err
		}
		if err := na.AssembleValue().AssignNode(v); err != nil {
			return err
		}
	}
	return na.Finish()
}
func (_Commit_Link_List__ReprAssembler) Prototype() ipld.NodePrototype {
	return _Commit_Link_List__ReprPrototype{}
}
func (la *_Commit_Link_List__ReprAssembler) valueFinishTidy() bool {
	switch la.cm {
	case schema.Maybe_Value:
		la.va.w = nil
		la.cm = schema.Maybe_Absent
		la.state = laState_initial
		la.va.reset()
		return true
	default:
		return false
	}
}
func (la *_Commit_Link_List__ReprAssembler) AssembleValue() ipld.NodeAssembler {
	switch la.state {
	case laState_initial:
		// carry on
	case laState_midValue:
		if !la.valueFinishTidy() {
			panic("invalid state: AssembleValue cannot be called when still in the middle of assembling the previous value")
		} // if tidy success: carry on
	case laState_finished:
		panic("invalid state: AssembleValue cannot be called on an assembler that's already finished")
	}
	la.w.x = append(la.w.x, _Commit_Link{})
	la.state = laState_midValue
	row := &la.w.x[len(la.w.x)-1]
	la.va.w = row
	la.va.m = &la.cm
	return &la.va
}
func (la *_Commit_Link_List__ReprAssembler) Finish() error {
	switch la.state {
	case laState_initial:
		// carry on
	case laState_midValue:
		if !la.valueFinishTidy() {
			panic("invalid state: Finish cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case laState_finished:
		panic("invalid state: Finish cannot be called on an assembler that's already finished")
	}
	la.state = laState_finished
	*la.m = schema.Maybe_Value
	return nil
}
func (la *_Commit_Link_List__ReprAssembler) ValuePrototype(_ int64) ipld.NodePrototype {
	return _Commit_Link__ReprPrototype{}
}

func (n GpgSig) String() string {
	return n.x
}
func (_GpgSig__Prototype) fromString(w *_GpgSig, v string) error {
	*w = _GpgSig{v}
	return nil
}
func (_GpgSig__Prototype) FromString(v string) (GpgSig, error) {
	n := _GpgSig{v}
	return &n, nil
}

type _GpgSig__Maybe struct {
	m schema.Maybe
	v _GpgSig
}
type MaybeGpgSig = *_GpgSig__Maybe

func (m MaybeGpgSig) IsNull() bool {
	return m.m == schema.Maybe_Null
}
func (m MaybeGpgSig) IsAbsent() bool {
	return m.m == schema.Maybe_Absent
}
func (m MaybeGpgSig) Exists() bool {
	return m.m == schema.Maybe_Value
}
func (m MaybeGpgSig) AsNode() ipld.Node {
	switch m.m {
	case schema.Maybe_Absent:
		return ipld.Absent
	case schema.Maybe_Null:
		return ipld.Null
	case schema.Maybe_Value:
		return &m.v
	default:
		panic("unreachable")
	}
}
func (m MaybeGpgSig) Must() GpgSig {
	if !m.Exists() {
		panic("unbox of a maybe rejected")
	}
	return &m.v
}

var _ ipld.Node = (GpgSig)(&_GpgSig{})
var _ schema.TypedNode = (GpgSig)(&_GpgSig{})

func (GpgSig) Kind() ipld.Kind {
	return ipld.Kind_String
}
func (GpgSig) LookupByString(string) (ipld.Node, error) {
	return mixins.String{TypeName: "ipldgit.GpgSig"}.LookupByString("")
}
func (GpgSig) LookupByNode(ipld.Node) (ipld.Node, error) {
	return mixins.String{TypeName: "ipldgit.GpgSig"}.LookupByNode(nil)
}
func (GpgSig) LookupByIndex(idx int64) (ipld.Node, error) {
	return mixins.String{TypeName: "ipldgit.GpgSig"}.LookupByIndex(0)
}
func (GpgSig) LookupBySegment(seg ipld.PathSegment) (ipld.Node, error) {
	return mixins.String{TypeName: "ipldgit.GpgSig"}.LookupBySegment(seg)
}
func (GpgSig) MapIterator() ipld.MapIterator {
	return nil
}
func (GpgSig) ListIterator() ipld.ListIterator {
	return nil
}
func (GpgSig) Length() int64 {
	return -1
}
func (GpgSig) IsAbsent() bool {
	return false
}
func (GpgSig) IsNull() bool {
	return false
}
func (GpgSig) AsBool() (bool, error) {
	return mixins.String{TypeName: "ipldgit.GpgSig"}.AsBool()
}
func (GpgSig) AsInt() (int64, error) {
	return mixins.String{TypeName: "ipldgit.GpgSig"}.AsInt()
}
func (GpgSig) AsFloat() (float64, error) {
	return mixins.String{TypeName: "ipldgit.GpgSig"}.AsFloat()
}
func (n GpgSig) AsString() (string, error) {
	return n.x, nil
}
func (GpgSig) AsBytes() ([]byte, error) {
	return mixins.String{TypeName: "ipldgit.GpgSig"}.AsBytes()
}
func (GpgSig) AsLink() (ipld.Link, error) {
	return mixins.String{TypeName: "ipldgit.GpgSig"}.AsLink()
}
func (GpgSig) Prototype() ipld.NodePrototype {
	return _GpgSig__Prototype{}
}

type _GpgSig__Prototype struct{}

func (_GpgSig__Prototype) NewBuilder() ipld.NodeBuilder {
	var nb _GpgSig__Builder
	nb.Reset()
	return &nb
}

type _GpgSig__Builder struct {
	_GpgSig__Assembler
}

func (nb *_GpgSig__Builder) Build() ipld.Node {
	if *nb.m != schema.Maybe_Value {
		panic("invalid state: cannot call Build on an assembler that's not finished")
	}
	return nb.w
}
func (nb *_GpgSig__Builder) Reset() {
	var w _GpgSig
	var m schema.Maybe
	*nb = _GpgSig__Builder{_GpgSig__Assembler{w: &w, m: &m}}
}

type _GpgSig__Assembler struct {
	w *_GpgSig
	m *schema.Maybe
}

func (na *_GpgSig__Assembler) reset() {}
func (_GpgSig__Assembler) BeginMap(sizeHint int64) (ipld.MapAssembler, error) {
	return mixins.StringAssembler{TypeName: "ipldgit.GpgSig"}.BeginMap(0)
}
func (_GpgSig__Assembler) BeginList(sizeHint int64) (ipld.ListAssembler, error) {
	return mixins.StringAssembler{TypeName: "ipldgit.GpgSig"}.BeginList(0)
}
func (na *_GpgSig__Assembler) AssignNull() error {
	switch *na.m {
	case allowNull:
		*na.m = schema.Maybe_Null
		return nil
	case schema.Maybe_Absent:
		return mixins.StringAssembler{TypeName: "ipldgit.GpgSig"}.AssignNull()
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	}
	panic("unreachable")
}
func (_GpgSig__Assembler) AssignBool(bool) error {
	return mixins.StringAssembler{TypeName: "ipldgit.GpgSig"}.AssignBool(false)
}
func (_GpgSig__Assembler) AssignInt(int64) error {
	return mixins.StringAssembler{TypeName: "ipldgit.GpgSig"}.AssignInt(0)
}
func (_GpgSig__Assembler) AssignFloat(float64) error {
	return mixins.StringAssembler{TypeName: "ipldgit.GpgSig"}.AssignFloat(0)
}
func (na *_GpgSig__Assembler) AssignString(v string) error {
	switch *na.m {
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	}
	na.w.x = v
	*na.m = schema.Maybe_Value
	return nil
}
func (_GpgSig__Assembler) AssignBytes([]byte) error {
	return mixins.StringAssembler{TypeName: "ipldgit.GpgSig"}.AssignBytes(nil)
}
func (_GpgSig__Assembler) AssignLink(ipld.Link) error {
	return mixins.StringAssembler{TypeName: "ipldgit.GpgSig"}.AssignLink(nil)
}
func (na *_GpgSig__Assembler) AssignNode(v ipld.Node) error {
	if v.IsNull() {
		return na.AssignNull()
	}
	if v2, ok := v.(*_GpgSig); ok {
		switch *na.m {
		case schema.Maybe_Value, schema.Maybe_Null:
			panic("invalid state: cannot assign into assembler that's already finished")
		}
		*na.w = *v2
		*na.m = schema.Maybe_Value
		return nil
	}
	if v2, err := v.AsString(); err != nil {
		return err
	} else {
		return na.AssignString(v2)
	}
}
func (_GpgSig__Assembler) Prototype() ipld.NodePrototype {
	return _GpgSig__Prototype{}
}
func (GpgSig) Type() schema.Type {
	return nil /*TODO:typelit*/
}
func (n GpgSig) Representation() ipld.Node {
	return (*_GpgSig__Repr)(n)
}

type _GpgSig__Repr = _GpgSig

var _ ipld.Node = &_GpgSig__Repr{}

type _GpgSig__ReprPrototype = _GpgSig__Prototype
type _GpgSig__ReprAssembler = _GpgSig__Assembler

func (n Link) Link() ipld.Link {
	return n.x
}
func (_Link__Prototype) FromLink(v ipld.Link) (Link, error) {
	n := _Link{v}
	return &n, nil
}

type _Link__Maybe struct {
	m schema.Maybe
	v _Link
}
type MaybeLink = *_Link__Maybe

func (m MaybeLink) IsNull() bool {
	return m.m == schema.Maybe_Null
}
func (m MaybeLink) IsAbsent() bool {
	return m.m == schema.Maybe_Absent
}
func (m MaybeLink) Exists() bool {
	return m.m == schema.Maybe_Value
}
func (m MaybeLink) AsNode() ipld.Node {
	switch m.m {
	case schema.Maybe_Absent:
		return ipld.Absent
	case schema.Maybe_Null:
		return ipld.Null
	case schema.Maybe_Value:
		return &m.v
	default:
		panic("unreachable")
	}
}
func (m MaybeLink) Must() Link {
	if !m.Exists() {
		panic("unbox of a maybe rejected")
	}
	return &m.v
}

var _ ipld.Node = (Link)(&_Link{})
var _ schema.TypedNode = (Link)(&_Link{})

func (Link) Kind() ipld.Kind {
	return ipld.Kind_Link
}
func (Link) LookupByString(string) (ipld.Node, error) {
	return mixins.Link{TypeName: "ipldgit.Link"}.LookupByString("")
}
func (Link) LookupByNode(ipld.Node) (ipld.Node, error) {
	return mixins.Link{TypeName: "ipldgit.Link"}.LookupByNode(nil)
}
func (Link) LookupByIndex(idx int64) (ipld.Node, error) {
	return mixins.Link{TypeName: "ipldgit.Link"}.LookupByIndex(0)
}
func (Link) LookupBySegment(seg ipld.PathSegment) (ipld.Node, error) {
	return mixins.Link{TypeName: "ipldgit.Link"}.LookupBySegment(seg)
}
func (Link) MapIterator() ipld.MapIterator {
	return nil
}
func (Link) ListIterator() ipld.ListIterator {
	return nil
}
func (Link) Length() int64 {
	return -1
}
func (Link) IsAbsent() bool {
	return false
}
func (Link) IsNull() bool {
	return false
}
func (Link) AsBool() (bool, error) {
	return mixins.Link{TypeName: "ipldgit.Link"}.AsBool()
}
func (Link) AsInt() (int64, error) {
	return mixins.Link{TypeName: "ipldgit.Link"}.AsInt()
}
func (Link) AsFloat() (float64, error) {
	return mixins.Link{TypeName: "ipldgit.Link"}.AsFloat()
}
func (Link) AsString() (string, error) {
	return mixins.Link{TypeName: "ipldgit.Link"}.AsString()
}
func (Link) AsBytes() ([]byte, error) {
	return mixins.Link{TypeName: "ipldgit.Link"}.AsBytes()
}
func (n Link) AsLink() (ipld.Link, error) {
	return n.x, nil
}
func (Link) Prototype() ipld.NodePrototype {
	return _Link__Prototype{}
}

type _Link__Prototype struct{}

func (_Link__Prototype) NewBuilder() ipld.NodeBuilder {
	var nb _Link__Builder
	nb.Reset()
	return &nb
}

type _Link__Builder struct {
	_Link__Assembler
}

func (nb *_Link__Builder) Build() ipld.Node {
	if *nb.m != schema.Maybe_Value {
		panic("invalid state: cannot call Build on an assembler that's not finished")
	}
	return nb.w
}
func (nb *_Link__Builder) Reset() {
	var w _Link
	var m schema.Maybe
	*nb = _Link__Builder{_Link__Assembler{w: &w, m: &m}}
}

type _Link__Assembler struct {
	w *_Link
	m *schema.Maybe
}

func (na *_Link__Assembler) reset() {}
func (_Link__Assembler) BeginMap(sizeHint int64) (ipld.MapAssembler, error) {
	return mixins.LinkAssembler{TypeName: "ipldgit.Link"}.BeginMap(0)
}
func (_Link__Assembler) BeginList(sizeHint int64) (ipld.ListAssembler, error) {
	return mixins.LinkAssembler{TypeName: "ipldgit.Link"}.BeginList(0)
}
func (na *_Link__Assembler) AssignNull() error {
	switch *na.m {
	case allowNull:
		*na.m = schema.Maybe_Null
		return nil
	case schema.Maybe_Absent:
		return mixins.LinkAssembler{TypeName: "ipldgit.Link"}.AssignNull()
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	}
	panic("unreachable")
}
func (_Link__Assembler) AssignBool(bool) error {
	return mixins.LinkAssembler{TypeName: "ipldgit.Link"}.AssignBool(false)
}
func (_Link__Assembler) AssignInt(int64) error {
	return mixins.LinkAssembler{TypeName: "ipldgit.Link"}.AssignInt(0)
}
func (_Link__Assembler) AssignFloat(float64) error {
	return mixins.LinkAssembler{TypeName: "ipldgit.Link"}.AssignFloat(0)
}
func (_Link__Assembler) AssignString(string) error {
	return mixins.LinkAssembler{TypeName: "ipldgit.Link"}.AssignString("")
}
func (_Link__Assembler) AssignBytes([]byte) error {
	return mixins.LinkAssembler{TypeName: "ipldgit.Link"}.AssignBytes(nil)
}
func (na *_Link__Assembler) AssignLink(v ipld.Link) error {
	switch *na.m {
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	}
	na.w.x = v
	*na.m = schema.Maybe_Value
	return nil
}
func (na *_Link__Assembler) AssignNode(v ipld.Node) error {
	if v.IsNull() {
		return na.AssignNull()
	}
	if v2, ok := v.(*_Link); ok {
		switch *na.m {
		case schema.Maybe_Value, schema.Maybe_Null:
			panic("invalid state: cannot assign into assembler that's already finished")
		}
		*na.w = *v2
		*na.m = schema.Maybe_Value
		return nil
	}
	if v2, err := v.AsLink(); err != nil {
		return err
	} else {
		return na.AssignLink(v2)
	}
}
func (_Link__Assembler) Prototype() ipld.NodePrototype {
	return _Link__Prototype{}
}
func (Link) Type() schema.Type {
	return nil /*TODO:typelit*/
}
func (n Link) Representation() ipld.Node {
	return (*_Link__Repr)(n)
}

type _Link__Repr = _Link

var _ ipld.Node = &_Link__Repr{}

type _Link__ReprPrototype = _Link__Prototype
type _Link__ReprAssembler = _Link__Assembler

func (n _PersonInfo) FieldDate() String {
	return &n.date
}
func (n _PersonInfo) FieldTimezone() String {
	return &n.timezone
}
func (n _PersonInfo) FieldEmail() String {
	return &n.email
}
func (n _PersonInfo) FieldName() String {
	return &n.name
}

type _PersonInfo__Maybe struct {
	m schema.Maybe
	v PersonInfo
}
type MaybePersonInfo = *_PersonInfo__Maybe

func (m MaybePersonInfo) IsNull() bool {
	return m.m == schema.Maybe_Null
}
func (m MaybePersonInfo) IsAbsent() bool {
	return m.m == schema.Maybe_Absent
}
func (m MaybePersonInfo) Exists() bool {
	return m.m == schema.Maybe_Value
}
func (m MaybePersonInfo) AsNode() ipld.Node {
	switch m.m {
	case schema.Maybe_Absent:
		return ipld.Absent
	case schema.Maybe_Null:
		return ipld.Null
	case schema.Maybe_Value:
		return m.v
	default:
		panic("unreachable")
	}
}
func (m MaybePersonInfo) Must() PersonInfo {
	if !m.Exists() {
		panic("unbox of a maybe rejected")
	}
	return m.v
}

var (
	fieldName__PersonInfo_Date     = _String{"date"}
	fieldName__PersonInfo_Timezone = _String{"timezone"}
	fieldName__PersonInfo_Email    = _String{"email"}
	fieldName__PersonInfo_Name     = _String{"name"}
)
var _ ipld.Node = (PersonInfo)(&_PersonInfo{})
var _ schema.TypedNode = (PersonInfo)(&_PersonInfo{})

func (PersonInfo) Kind() ipld.Kind {
	return ipld.Kind_Map
}
func (n PersonInfo) LookupByString(key string) (ipld.Node, error) {
	switch key {
	case "date":
		return &n.date, nil
	case "timezone":
		return &n.timezone, nil
	case "email":
		return &n.email, nil
	case "name":
		return &n.name, nil
	default:
		return nil, schema.ErrNoSuchField{Type: nil /*TODO*/, Field: ipld.PathSegmentOfString(key)}
	}
}
func (n PersonInfo) LookupByNode(key ipld.Node) (ipld.Node, error) {
	ks, err := key.AsString()
	if err != nil {
		return nil, err
	}
	return n.LookupByString(ks)
}
func (PersonInfo) LookupByIndex(idx int64) (ipld.Node, error) {
	return mixins.Map{TypeName: "ipldgit.PersonInfo"}.LookupByIndex(0)
}
func (n PersonInfo) LookupBySegment(seg ipld.PathSegment) (ipld.Node, error) {
	return n.LookupByString(seg.String())
}
func (n PersonInfo) MapIterator() ipld.MapIterator {
	return &_PersonInfo__MapItr{n, 0}
}

type _PersonInfo__MapItr struct {
	n   PersonInfo
	idx int
}

func (itr *_PersonInfo__MapItr) Next() (k ipld.Node, v ipld.Node, _ error) {
	if itr.idx >= 4 {
		return nil, nil, ipld.ErrIteratorOverread{}
	}
	switch itr.idx {
	case 0:
		k = &fieldName__PersonInfo_Date
		v = &itr.n.date
	case 1:
		k = &fieldName__PersonInfo_Timezone
		v = &itr.n.timezone
	case 2:
		k = &fieldName__PersonInfo_Email
		v = &itr.n.email
	case 3:
		k = &fieldName__PersonInfo_Name
		v = &itr.n.name
	default:
		panic("unreachable")
	}
	itr.idx++
	return
}
func (itr *_PersonInfo__MapItr) Done() bool {
	return itr.idx >= 4
}

func (PersonInfo) ListIterator() ipld.ListIterator {
	return nil
}
func (PersonInfo) Length() int64 {
	return 4
}
func (PersonInfo) IsAbsent() bool {
	return false
}
func (PersonInfo) IsNull() bool {
	return false
}
func (PersonInfo) AsBool() (bool, error) {
	return mixins.Map{TypeName: "ipldgit.PersonInfo"}.AsBool()
}
func (PersonInfo) AsInt() (int64, error) {
	return mixins.Map{TypeName: "ipldgit.PersonInfo"}.AsInt()
}
func (PersonInfo) AsFloat() (float64, error) {
	return mixins.Map{TypeName: "ipldgit.PersonInfo"}.AsFloat()
}
func (PersonInfo) AsString() (string, error) {
	return mixins.Map{TypeName: "ipldgit.PersonInfo"}.AsString()
}
func (PersonInfo) AsBytes() ([]byte, error) {
	return mixins.Map{TypeName: "ipldgit.PersonInfo"}.AsBytes()
}
func (PersonInfo) AsLink() (ipld.Link, error) {
	return mixins.Map{TypeName: "ipldgit.PersonInfo"}.AsLink()
}
func (PersonInfo) Prototype() ipld.NodePrototype {
	return _PersonInfo__Prototype{}
}

type _PersonInfo__Prototype struct{}

func (_PersonInfo__Prototype) NewBuilder() ipld.NodeBuilder {
	var nb _PersonInfo__Builder
	nb.Reset()
	return &nb
}

type _PersonInfo__Builder struct {
	_PersonInfo__Assembler
}

func (nb *_PersonInfo__Builder) Build() ipld.Node {
	if *nb.m != schema.Maybe_Value {
		panic("invalid state: cannot call Build on an assembler that's not finished")
	}
	return nb.w
}
func (nb *_PersonInfo__Builder) Reset() {
	var w _PersonInfo
	var m schema.Maybe
	*nb = _PersonInfo__Builder{_PersonInfo__Assembler{w: &w, m: &m}}
}

type _PersonInfo__Assembler struct {
	w     *_PersonInfo
	m     *schema.Maybe
	state maState
	s     int
	f     int

	cm          schema.Maybe
	ca_date     _String__Assembler
	ca_timezone _String__Assembler
	ca_email    _String__Assembler
	ca_name     _String__Assembler
}

func (na *_PersonInfo__Assembler) reset() {
	na.state = maState_initial
	na.s = 0
	na.ca_date.reset()
	na.ca_timezone.reset()
	na.ca_email.reset()
	na.ca_name.reset()
}

var (
	fieldBit__PersonInfo_Date        = 1 << 0
	fieldBit__PersonInfo_Timezone    = 1 << 1
	fieldBit__PersonInfo_Email       = 1 << 2
	fieldBit__PersonInfo_Name        = 1 << 3
	fieldBits__PersonInfo_sufficient = 0 + 1<<0 + 1<<1 + 1<<2 + 1<<3
)

func (na *_PersonInfo__Assembler) BeginMap(int64) (ipld.MapAssembler, error) {
	switch *na.m {
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: it makes no sense to 'begin' twice on the same assembler!")
	}
	*na.m = midvalue
	if na.w == nil {
		na.w = &_PersonInfo{}
	}
	return na, nil
}
func (_PersonInfo__Assembler) BeginList(sizeHint int64) (ipld.ListAssembler, error) {
	return mixins.MapAssembler{TypeName: "ipldgit.PersonInfo"}.BeginList(0)
}
func (na *_PersonInfo__Assembler) AssignNull() error {
	switch *na.m {
	case allowNull:
		*na.m = schema.Maybe_Null
		return nil
	case schema.Maybe_Absent:
		return mixins.MapAssembler{TypeName: "ipldgit.PersonInfo"}.AssignNull()
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
	}
	panic("unreachable")
}
func (_PersonInfo__Assembler) AssignBool(bool) error {
	return mixins.MapAssembler{TypeName: "ipldgit.PersonInfo"}.AssignBool(false)
}
func (_PersonInfo__Assembler) AssignInt(int64) error {
	return mixins.MapAssembler{TypeName: "ipldgit.PersonInfo"}.AssignInt(0)
}
func (_PersonInfo__Assembler) AssignFloat(float64) error {
	return mixins.MapAssembler{TypeName: "ipldgit.PersonInfo"}.AssignFloat(0)
}
func (_PersonInfo__Assembler) AssignString(string) error {
	return mixins.MapAssembler{TypeName: "ipldgit.PersonInfo"}.AssignString("")
}
func (_PersonInfo__Assembler) AssignBytes([]byte) error {
	return mixins.MapAssembler{TypeName: "ipldgit.PersonInfo"}.AssignBytes(nil)
}
func (_PersonInfo__Assembler) AssignLink(ipld.Link) error {
	return mixins.MapAssembler{TypeName: "ipldgit.PersonInfo"}.AssignLink(nil)
}
func (na *_PersonInfo__Assembler) AssignNode(v ipld.Node) error {
	if v.IsNull() {
		return na.AssignNull()
	}
	if v2, ok := v.(*_PersonInfo); ok {
		switch *na.m {
		case schema.Maybe_Value, schema.Maybe_Null:
			panic("invalid state: cannot assign into assembler that's already finished")
		case midvalue:
			panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
		}
		if na.w == nil {
			na.w = v2
			*na.m = schema.Maybe_Value
			return nil
		}
		*na.w = *v2
		*na.m = schema.Maybe_Value
		return nil
	}
	if v.Kind() != ipld.Kind_Map {
		return ipld.ErrWrongKind{TypeName: "ipldgit.PersonInfo", MethodName: "AssignNode", AppropriateKind: ipld.KindSet_JustMap, ActualKind: v.Kind()}
	}
	itr := v.MapIterator()
	for !itr.Done() {
		k, v, err := itr.Next()
		if err != nil {
			return err
		}
		if err := na.AssembleKey().AssignNode(k); err != nil {
			return err
		}
		if err := na.AssembleValue().AssignNode(v); err != nil {
			return err
		}
	}
	return na.Finish()
}
func (_PersonInfo__Assembler) Prototype() ipld.NodePrototype {
	return _PersonInfo__Prototype{}
}
func (ma *_PersonInfo__Assembler) valueFinishTidy() bool {
	switch ma.f {
	case 0:
		switch ma.cm {
		case schema.Maybe_Value:
			ma.ca_date.w = nil
			ma.cm = schema.Maybe_Absent
			ma.state = maState_initial
			return true
		default:
			return false
		}
	case 1:
		switch ma.cm {
		case schema.Maybe_Value:
			ma.ca_timezone.w = nil
			ma.cm = schema.Maybe_Absent
			ma.state = maState_initial
			return true
		default:
			return false
		}
	case 2:
		switch ma.cm {
		case schema.Maybe_Value:
			ma.ca_email.w = nil
			ma.cm = schema.Maybe_Absent
			ma.state = maState_initial
			return true
		default:
			return false
		}
	case 3:
		switch ma.cm {
		case schema.Maybe_Value:
			ma.ca_name.w = nil
			ma.cm = schema.Maybe_Absent
			ma.state = maState_initial
			return true
		default:
			return false
		}
	default:
		panic("unreachable")
	}
}
func (ma *_PersonInfo__Assembler) AssembleEntry(k string) (ipld.NodeAssembler, error) {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: AssembleEntry cannot be called when in the middle of assembling another key")
	case maState_expectValue:
		panic("invalid state: AssembleEntry cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: AssembleEntry cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: AssembleEntry cannot be called on an assembler that's already finished")
	}
	switch k {
	case "date":
		if ma.s&fieldBit__PersonInfo_Date != 0 {
			return nil, ipld.ErrRepeatedMapKey{Key: &fieldName__PersonInfo_Date}
		}
		ma.s += fieldBit__PersonInfo_Date
		ma.state = maState_midValue
		ma.f = 0
		ma.ca_date.w = &ma.w.date
		ma.ca_date.m = &ma.cm
		return &ma.ca_date, nil
	case "timezone":
		if ma.s&fieldBit__PersonInfo_Timezone != 0 {
			return nil, ipld.ErrRepeatedMapKey{Key: &fieldName__PersonInfo_Timezone}
		}
		ma.s += fieldBit__PersonInfo_Timezone
		ma.state = maState_midValue
		ma.f = 1
		ma.ca_timezone.w = &ma.w.timezone
		ma.ca_timezone.m = &ma.cm
		return &ma.ca_timezone, nil
	case "email":
		if ma.s&fieldBit__PersonInfo_Email != 0 {
			return nil, ipld.ErrRepeatedMapKey{Key: &fieldName__PersonInfo_Email}
		}
		ma.s += fieldBit__PersonInfo_Email
		ma.state = maState_midValue
		ma.f = 2
		ma.ca_email.w = &ma.w.email
		ma.ca_email.m = &ma.cm
		return &ma.ca_email, nil
	case "name":
		if ma.s&fieldBit__PersonInfo_Name != 0 {
			return nil, ipld.ErrRepeatedMapKey{Key: &fieldName__PersonInfo_Name}
		}
		ma.s += fieldBit__PersonInfo_Name
		ma.state = maState_midValue
		ma.f = 3
		ma.ca_name.w = &ma.w.name
		ma.ca_name.m = &ma.cm
		return &ma.ca_name, nil
	}
	return nil, ipld.ErrInvalidKey{TypeName: "ipldgit.PersonInfo", Key: &_String{k}}
}
func (ma *_PersonInfo__Assembler) AssembleKey() ipld.NodeAssembler {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: AssembleKey cannot be called when in the middle of assembling another key")
	case maState_expectValue:
		panic("invalid state: AssembleKey cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: AssembleKey cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: AssembleKey cannot be called on an assembler that's already finished")
	}
	ma.state = maState_midKey
	return (*_PersonInfo__KeyAssembler)(ma)
}
func (ma *_PersonInfo__Assembler) AssembleValue() ipld.NodeAssembler {
	switch ma.state {
	case maState_initial:
		panic("invalid state: AssembleValue cannot be called when no key is primed")
	case maState_midKey:
		panic("invalid state: AssembleValue cannot be called when in the middle of assembling a key")
	case maState_expectValue:
		// carry on
	case maState_midValue:
		panic("invalid state: AssembleValue cannot be called when in the middle of assembling another value")
	case maState_finished:
		panic("invalid state: AssembleValue cannot be called on an assembler that's already finished")
	}
	ma.state = maState_midValue
	switch ma.f {
	case 0:
		ma.ca_date.w = &ma.w.date
		ma.ca_date.m = &ma.cm
		return &ma.ca_date
	case 1:
		ma.ca_timezone.w = &ma.w.timezone
		ma.ca_timezone.m = &ma.cm
		return &ma.ca_timezone
	case 2:
		ma.ca_email.w = &ma.w.email
		ma.ca_email.m = &ma.cm
		return &ma.ca_email
	case 3:
		ma.ca_name.w = &ma.w.name
		ma.ca_name.m = &ma.cm
		return &ma.ca_name
	default:
		panic("unreachable")
	}
}
func (ma *_PersonInfo__Assembler) Finish() error {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: Finish cannot be called when in the middle of assembling a key")
	case maState_expectValue:
		panic("invalid state: Finish cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: Finish cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: Finish cannot be called on an assembler that's already finished")
	}
	if ma.s&fieldBits__PersonInfo_sufficient != fieldBits__PersonInfo_sufficient {
		err := ipld.ErrMissingRequiredField{Missing: make([]string, 0)}
		if ma.s&fieldBit__PersonInfo_Date == 0 {
			err.Missing = append(err.Missing, "date")
		}
		if ma.s&fieldBit__PersonInfo_Timezone == 0 {
			err.Missing = append(err.Missing, "timezone")
		}
		if ma.s&fieldBit__PersonInfo_Email == 0 {
			err.Missing = append(err.Missing, "email")
		}
		if ma.s&fieldBit__PersonInfo_Name == 0 {
			err.Missing = append(err.Missing, "name")
		}
		return err
	}
	ma.state = maState_finished
	*ma.m = schema.Maybe_Value
	return nil
}
func (ma *_PersonInfo__Assembler) KeyPrototype() ipld.NodePrototype {
	return _String__Prototype{}
}
func (ma *_PersonInfo__Assembler) ValuePrototype(k string) ipld.NodePrototype {
	panic("todo structbuilder mapassembler valueprototype")
}

type _PersonInfo__KeyAssembler _PersonInfo__Assembler

func (_PersonInfo__KeyAssembler) BeginMap(sizeHint int64) (ipld.MapAssembler, error) {
	return mixins.StringAssembler{TypeName: "ipldgit.PersonInfo.KeyAssembler"}.BeginMap(0)
}
func (_PersonInfo__KeyAssembler) BeginList(sizeHint int64) (ipld.ListAssembler, error) {
	return mixins.StringAssembler{TypeName: "ipldgit.PersonInfo.KeyAssembler"}.BeginList(0)
}
func (na *_PersonInfo__KeyAssembler) AssignNull() error {
	return mixins.StringAssembler{TypeName: "ipldgit.PersonInfo.KeyAssembler"}.AssignNull()
}
func (_PersonInfo__KeyAssembler) AssignBool(bool) error {
	return mixins.StringAssembler{TypeName: "ipldgit.PersonInfo.KeyAssembler"}.AssignBool(false)
}
func (_PersonInfo__KeyAssembler) AssignInt(int64) error {
	return mixins.StringAssembler{TypeName: "ipldgit.PersonInfo.KeyAssembler"}.AssignInt(0)
}
func (_PersonInfo__KeyAssembler) AssignFloat(float64) error {
	return mixins.StringAssembler{TypeName: "ipldgit.PersonInfo.KeyAssembler"}.AssignFloat(0)
}
func (ka *_PersonInfo__KeyAssembler) AssignString(k string) error {
	if ka.state != maState_midKey {
		panic("misuse: KeyAssembler held beyond its valid lifetime")
	}
	switch k {
	case "date":
		if ka.s&fieldBit__PersonInfo_Date != 0 {
			return ipld.ErrRepeatedMapKey{Key: &fieldName__PersonInfo_Date}
		}
		ka.s += fieldBit__PersonInfo_Date
		ka.state = maState_expectValue
		ka.f = 0
		return nil
	case "timezone":
		if ka.s&fieldBit__PersonInfo_Timezone != 0 {
			return ipld.ErrRepeatedMapKey{Key: &fieldName__PersonInfo_Timezone}
		}
		ka.s += fieldBit__PersonInfo_Timezone
		ka.state = maState_expectValue
		ka.f = 1
		return nil
	case "email":
		if ka.s&fieldBit__PersonInfo_Email != 0 {
			return ipld.ErrRepeatedMapKey{Key: &fieldName__PersonInfo_Email}
		}
		ka.s += fieldBit__PersonInfo_Email
		ka.state = maState_expectValue
		ka.f = 2
		return nil
	case "name":
		if ka.s&fieldBit__PersonInfo_Name != 0 {
			return ipld.ErrRepeatedMapKey{Key: &fieldName__PersonInfo_Name}
		}
		ka.s += fieldBit__PersonInfo_Name
		ka.state = maState_expectValue
		ka.f = 3
		return nil
	default:
		return ipld.ErrInvalidKey{TypeName: "ipldgit.PersonInfo", Key: &_String{k}}
	}
}
func (_PersonInfo__KeyAssembler) AssignBytes([]byte) error {
	return mixins.StringAssembler{TypeName: "ipldgit.PersonInfo.KeyAssembler"}.AssignBytes(nil)
}
func (_PersonInfo__KeyAssembler) AssignLink(ipld.Link) error {
	return mixins.StringAssembler{TypeName: "ipldgit.PersonInfo.KeyAssembler"}.AssignLink(nil)
}
func (ka *_PersonInfo__KeyAssembler) AssignNode(v ipld.Node) error {
	if v2, err := v.AsString(); err != nil {
		return err
	} else {
		return ka.AssignString(v2)
	}
}
func (_PersonInfo__KeyAssembler) Prototype() ipld.NodePrototype {
	return _String__Prototype{}
}
func (PersonInfo) Type() schema.Type {
	return nil /*TODO:typelit*/
}
func (n PersonInfo) Representation() ipld.Node {
	return (*_PersonInfo__Repr)(n)
}

type _PersonInfo__Repr _PersonInfo

var (
	fieldName__PersonInfo_Date_serial     = _String{"date"}
	fieldName__PersonInfo_Timezone_serial = _String{"timezone"}
	fieldName__PersonInfo_Email_serial    = _String{"email"}
	fieldName__PersonInfo_Name_serial     = _String{"name"}
)
var _ ipld.Node = &_PersonInfo__Repr{}

func (_PersonInfo__Repr) Kind() ipld.Kind {
	return ipld.Kind_Map
}
func (n *_PersonInfo__Repr) LookupByString(key string) (ipld.Node, error) {
	switch key {
	case "date":
		return n.date.Representation(), nil
	case "timezone":
		return n.timezone.Representation(), nil
	case "email":
		return n.email.Representation(), nil
	case "name":
		return n.name.Representation(), nil
	default:
		return nil, schema.ErrNoSuchField{Type: nil /*TODO*/, Field: ipld.PathSegmentOfString(key)}
	}
}
func (n *_PersonInfo__Repr) LookupByNode(key ipld.Node) (ipld.Node, error) {
	ks, err := key.AsString()
	if err != nil {
		return nil, err
	}
	return n.LookupByString(ks)
}
func (_PersonInfo__Repr) LookupByIndex(idx int64) (ipld.Node, error) {
	return mixins.Map{TypeName: "ipldgit.PersonInfo.Repr"}.LookupByIndex(0)
}
func (n _PersonInfo__Repr) LookupBySegment(seg ipld.PathSegment) (ipld.Node, error) {
	return n.LookupByString(seg.String())
}
func (n *_PersonInfo__Repr) MapIterator() ipld.MapIterator {
	return &_PersonInfo__ReprMapItr{n, 0}
}

type _PersonInfo__ReprMapItr struct {
	n   *_PersonInfo__Repr
	idx int
}

func (itr *_PersonInfo__ReprMapItr) Next() (k ipld.Node, v ipld.Node, _ error) {
	if itr.idx >= 4 {
		return nil, nil, ipld.ErrIteratorOverread{}
	}
	switch itr.idx {
	case 0:
		k = &fieldName__PersonInfo_Date_serial
		v = itr.n.date.Representation()
	case 1:
		k = &fieldName__PersonInfo_Timezone_serial
		v = itr.n.timezone.Representation()
	case 2:
		k = &fieldName__PersonInfo_Email_serial
		v = itr.n.email.Representation()
	case 3:
		k = &fieldName__PersonInfo_Name_serial
		v = itr.n.name.Representation()
	default:
		panic("unreachable")
	}
	itr.idx++
	return
}
func (itr *_PersonInfo__ReprMapItr) Done() bool {
	return itr.idx >= 4
}
func (_PersonInfo__Repr) ListIterator() ipld.ListIterator {
	return nil
}
func (rn *_PersonInfo__Repr) Length() int64 {
	l := 4
	return int64(l)
}
func (_PersonInfo__Repr) IsAbsent() bool {
	return false
}
func (_PersonInfo__Repr) IsNull() bool {
	return false
}
func (_PersonInfo__Repr) AsBool() (bool, error) {
	return mixins.Map{TypeName: "ipldgit.PersonInfo.Repr"}.AsBool()
}
func (_PersonInfo__Repr) AsInt() (int64, error) {
	return mixins.Map{TypeName: "ipldgit.PersonInfo.Repr"}.AsInt()
}
func (_PersonInfo__Repr) AsFloat() (float64, error) {
	return mixins.Map{TypeName: "ipldgit.PersonInfo.Repr"}.AsFloat()
}
func (_PersonInfo__Repr) AsString() (string, error) {
	return mixins.Map{TypeName: "ipldgit.PersonInfo.Repr"}.AsString()
}
func (_PersonInfo__Repr) AsBytes() ([]byte, error) {
	return mixins.Map{TypeName: "ipldgit.PersonInfo.Repr"}.AsBytes()
}
func (_PersonInfo__Repr) AsLink() (ipld.Link, error) {
	return mixins.Map{TypeName: "ipldgit.PersonInfo.Repr"}.AsLink()
}
func (_PersonInfo__Repr) Prototype() ipld.NodePrototype {
	return _PersonInfo__ReprPrototype{}
}

type _PersonInfo__ReprPrototype struct{}

func (_PersonInfo__ReprPrototype) NewBuilder() ipld.NodeBuilder {
	var nb _PersonInfo__ReprBuilder
	nb.Reset()
	return &nb
}

type _PersonInfo__ReprBuilder struct {
	_PersonInfo__ReprAssembler
}

func (nb *_PersonInfo__ReprBuilder) Build() ipld.Node {
	if *nb.m != schema.Maybe_Value {
		panic("invalid state: cannot call Build on an assembler that's not finished")
	}
	return nb.w
}
func (nb *_PersonInfo__ReprBuilder) Reset() {
	var w _PersonInfo
	var m schema.Maybe
	*nb = _PersonInfo__ReprBuilder{_PersonInfo__ReprAssembler{w: &w, m: &m}}
}

type _PersonInfo__ReprAssembler struct {
	w     *_PersonInfo
	m     *schema.Maybe
	state maState
	s     int
	f     int

	cm          schema.Maybe
	ca_date     _String__ReprAssembler
	ca_timezone _String__ReprAssembler
	ca_email    _String__ReprAssembler
	ca_name     _String__ReprAssembler
}

func (na *_PersonInfo__ReprAssembler) reset() {
	na.state = maState_initial
	na.s = 0
	na.ca_date.reset()
	na.ca_timezone.reset()
	na.ca_email.reset()
	na.ca_name.reset()
}
func (na *_PersonInfo__ReprAssembler) BeginMap(int64) (ipld.MapAssembler, error) {
	switch *na.m {
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: it makes no sense to 'begin' twice on the same assembler!")
	}
	*na.m = midvalue
	if na.w == nil {
		na.w = &_PersonInfo{}
	}
	return na, nil
}
func (_PersonInfo__ReprAssembler) BeginList(sizeHint int64) (ipld.ListAssembler, error) {
	return mixins.MapAssembler{TypeName: "ipldgit.PersonInfo.Repr"}.BeginList(0)
}
func (na *_PersonInfo__ReprAssembler) AssignNull() error {
	switch *na.m {
	case allowNull:
		*na.m = schema.Maybe_Null
		return nil
	case schema.Maybe_Absent:
		return mixins.MapAssembler{TypeName: "ipldgit.PersonInfo.Repr.Repr"}.AssignNull()
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
	}
	panic("unreachable")
}
func (_PersonInfo__ReprAssembler) AssignBool(bool) error {
	return mixins.MapAssembler{TypeName: "ipldgit.PersonInfo.Repr"}.AssignBool(false)
}
func (_PersonInfo__ReprAssembler) AssignInt(int64) error {
	return mixins.MapAssembler{TypeName: "ipldgit.PersonInfo.Repr"}.AssignInt(0)
}
func (_PersonInfo__ReprAssembler) AssignFloat(float64) error {
	return mixins.MapAssembler{TypeName: "ipldgit.PersonInfo.Repr"}.AssignFloat(0)
}
func (_PersonInfo__ReprAssembler) AssignString(string) error {
	return mixins.MapAssembler{TypeName: "ipldgit.PersonInfo.Repr"}.AssignString("")
}
func (_PersonInfo__ReprAssembler) AssignBytes([]byte) error {
	return mixins.MapAssembler{TypeName: "ipldgit.PersonInfo.Repr"}.AssignBytes(nil)
}
func (_PersonInfo__ReprAssembler) AssignLink(ipld.Link) error {
	return mixins.MapAssembler{TypeName: "ipldgit.PersonInfo.Repr"}.AssignLink(nil)
}
func (na *_PersonInfo__ReprAssembler) AssignNode(v ipld.Node) error {
	if v.IsNull() {
		return na.AssignNull()
	}
	if v2, ok := v.(*_PersonInfo); ok {
		switch *na.m {
		case schema.Maybe_Value, schema.Maybe_Null:
			panic("invalid state: cannot assign into assembler that's already finished")
		case midvalue:
			panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
		}
		if na.w == nil {
			na.w = v2
			*na.m = schema.Maybe_Value
			return nil
		}
		*na.w = *v2
		*na.m = schema.Maybe_Value
		return nil
	}
	if v.Kind() != ipld.Kind_Map {
		return ipld.ErrWrongKind{TypeName: "ipldgit.PersonInfo.Repr", MethodName: "AssignNode", AppropriateKind: ipld.KindSet_JustMap, ActualKind: v.Kind()}
	}
	itr := v.MapIterator()
	for !itr.Done() {
		k, v, err := itr.Next()
		if err != nil {
			return err
		}
		if err := na.AssembleKey().AssignNode(k); err != nil {
			return err
		}
		if err := na.AssembleValue().AssignNode(v); err != nil {
			return err
		}
	}
	return na.Finish()
}
func (_PersonInfo__ReprAssembler) Prototype() ipld.NodePrototype {
	return _PersonInfo__ReprPrototype{}
}
func (ma *_PersonInfo__ReprAssembler) valueFinishTidy() bool {
	switch ma.f {
	case 0:
		switch ma.cm {
		case schema.Maybe_Value:
			ma.cm = schema.Maybe_Absent
			ma.state = maState_initial
			return true
		default:
			return false
		}
	case 1:
		switch ma.cm {
		case schema.Maybe_Value:
			ma.cm = schema.Maybe_Absent
			ma.state = maState_initial
			return true
		default:
			return false
		}
	case 2:
		switch ma.cm {
		case schema.Maybe_Value:
			ma.cm = schema.Maybe_Absent
			ma.state = maState_initial
			return true
		default:
			return false
		}
	case 3:
		switch ma.cm {
		case schema.Maybe_Value:
			ma.cm = schema.Maybe_Absent
			ma.state = maState_initial
			return true
		default:
			return false
		}
	default:
		panic("unreachable")
	}
}
func (ma *_PersonInfo__ReprAssembler) AssembleEntry(k string) (ipld.NodeAssembler, error) {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: AssembleEntry cannot be called when in the middle of assembling another key")
	case maState_expectValue:
		panic("invalid state: AssembleEntry cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: AssembleEntry cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: AssembleEntry cannot be called on an assembler that's already finished")
	}
	switch k {
	case "date":
		if ma.s&fieldBit__PersonInfo_Date != 0 {
			return nil, ipld.ErrRepeatedMapKey{Key: &fieldName__PersonInfo_Date_serial}
		}
		ma.s += fieldBit__PersonInfo_Date
		ma.state = maState_midValue
		ma.f = 0
		ma.ca_date.w = &ma.w.date
		ma.ca_date.m = &ma.cm
		return &ma.ca_date, nil
	case "timezone":
		if ma.s&fieldBit__PersonInfo_Timezone != 0 {
			return nil, ipld.ErrRepeatedMapKey{Key: &fieldName__PersonInfo_Timezone_serial}
		}
		ma.s += fieldBit__PersonInfo_Timezone
		ma.state = maState_midValue
		ma.f = 1
		ma.ca_timezone.w = &ma.w.timezone
		ma.ca_timezone.m = &ma.cm
		return &ma.ca_timezone, nil
	case "email":
		if ma.s&fieldBit__PersonInfo_Email != 0 {
			return nil, ipld.ErrRepeatedMapKey{Key: &fieldName__PersonInfo_Email_serial}
		}
		ma.s += fieldBit__PersonInfo_Email
		ma.state = maState_midValue
		ma.f = 2
		ma.ca_email.w = &ma.w.email
		ma.ca_email.m = &ma.cm
		return &ma.ca_email, nil
	case "name":
		if ma.s&fieldBit__PersonInfo_Name != 0 {
			return nil, ipld.ErrRepeatedMapKey{Key: &fieldName__PersonInfo_Name_serial}
		}
		ma.s += fieldBit__PersonInfo_Name
		ma.state = maState_midValue
		ma.f = 3
		ma.ca_name.w = &ma.w.name
		ma.ca_name.m = &ma.cm
		return &ma.ca_name, nil
	default:
	}
	return nil, ipld.ErrInvalidKey{TypeName: "ipldgit.PersonInfo.Repr", Key: &_String{k}}
}
func (ma *_PersonInfo__ReprAssembler) AssembleKey() ipld.NodeAssembler {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: AssembleKey cannot be called when in the middle of assembling another key")
	case maState_expectValue:
		panic("invalid state: AssembleKey cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: AssembleKey cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: AssembleKey cannot be called on an assembler that's already finished")
	}
	ma.state = maState_midKey
	return (*_PersonInfo__ReprKeyAssembler)(ma)
}
func (ma *_PersonInfo__ReprAssembler) AssembleValue() ipld.NodeAssembler {
	switch ma.state {
	case maState_initial:
		panic("invalid state: AssembleValue cannot be called when no key is primed")
	case maState_midKey:
		panic("invalid state: AssembleValue cannot be called when in the middle of assembling a key")
	case maState_expectValue:
		// carry on
	case maState_midValue:
		panic("invalid state: AssembleValue cannot be called when in the middle of assembling another value")
	case maState_finished:
		panic("invalid state: AssembleValue cannot be called on an assembler that's already finished")
	}
	ma.state = maState_midValue
	switch ma.f {
	case 0:
		ma.ca_date.w = &ma.w.date
		ma.ca_date.m = &ma.cm
		return &ma.ca_date
	case 1:
		ma.ca_timezone.w = &ma.w.timezone
		ma.ca_timezone.m = &ma.cm
		return &ma.ca_timezone
	case 2:
		ma.ca_email.w = &ma.w.email
		ma.ca_email.m = &ma.cm
		return &ma.ca_email
	case 3:
		ma.ca_name.w = &ma.w.name
		ma.ca_name.m = &ma.cm
		return &ma.ca_name
	default:
		panic("unreachable")
	}
}
func (ma *_PersonInfo__ReprAssembler) Finish() error {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: Finish cannot be called when in the middle of assembling a key")
	case maState_expectValue:
		panic("invalid state: Finish cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: Finish cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: Finish cannot be called on an assembler that's already finished")
	}
	if ma.s&fieldBits__PersonInfo_sufficient != fieldBits__PersonInfo_sufficient {
		err := ipld.ErrMissingRequiredField{Missing: make([]string, 0)}
		if ma.s&fieldBit__PersonInfo_Date == 0 {
			err.Missing = append(err.Missing, "date")
		}
		if ma.s&fieldBit__PersonInfo_Timezone == 0 {
			err.Missing = append(err.Missing, "timezone")
		}
		if ma.s&fieldBit__PersonInfo_Email == 0 {
			err.Missing = append(err.Missing, "email")
		}
		if ma.s&fieldBit__PersonInfo_Name == 0 {
			err.Missing = append(err.Missing, "name")
		}
		return err
	}
	ma.state = maState_finished
	*ma.m = schema.Maybe_Value
	return nil
}
func (ma *_PersonInfo__ReprAssembler) KeyPrototype() ipld.NodePrototype {
	return _String__Prototype{}
}
func (ma *_PersonInfo__ReprAssembler) ValuePrototype(k string) ipld.NodePrototype {
	panic("todo structbuilder mapassembler repr valueprototype")
}

type _PersonInfo__ReprKeyAssembler _PersonInfo__ReprAssembler

func (_PersonInfo__ReprKeyAssembler) BeginMap(sizeHint int64) (ipld.MapAssembler, error) {
	return mixins.StringAssembler{TypeName: "ipldgit.PersonInfo.Repr.KeyAssembler"}.BeginMap(0)
}
func (_PersonInfo__ReprKeyAssembler) BeginList(sizeHint int64) (ipld.ListAssembler, error) {
	return mixins.StringAssembler{TypeName: "ipldgit.PersonInfo.Repr.KeyAssembler"}.BeginList(0)
}
func (na *_PersonInfo__ReprKeyAssembler) AssignNull() error {
	return mixins.StringAssembler{TypeName: "ipldgit.PersonInfo.Repr.KeyAssembler"}.AssignNull()
}
func (_PersonInfo__ReprKeyAssembler) AssignBool(bool) error {
	return mixins.StringAssembler{TypeName: "ipldgit.PersonInfo.Repr.KeyAssembler"}.AssignBool(false)
}
func (_PersonInfo__ReprKeyAssembler) AssignInt(int64) error {
	return mixins.StringAssembler{TypeName: "ipldgit.PersonInfo.Repr.KeyAssembler"}.AssignInt(0)
}
func (_PersonInfo__ReprKeyAssembler) AssignFloat(float64) error {
	return mixins.StringAssembler{TypeName: "ipldgit.PersonInfo.Repr.KeyAssembler"}.AssignFloat(0)
}
func (ka *_PersonInfo__ReprKeyAssembler) AssignString(k string) error {
	if ka.state != maState_midKey {
		panic("misuse: KeyAssembler held beyond its valid lifetime")
	}
	switch k {
	case "date":
		if ka.s&fieldBit__PersonInfo_Date != 0 {
			return ipld.ErrRepeatedMapKey{Key: &fieldName__PersonInfo_Date_serial}
		}
		ka.s += fieldBit__PersonInfo_Date
		ka.state = maState_expectValue
		ka.f = 0
		return nil
	case "timezone":
		if ka.s&fieldBit__PersonInfo_Timezone != 0 {
			return ipld.ErrRepeatedMapKey{Key: &fieldName__PersonInfo_Timezone_serial}
		}
		ka.s += fieldBit__PersonInfo_Timezone
		ka.state = maState_expectValue
		ka.f = 1
		return nil
	case "email":
		if ka.s&fieldBit__PersonInfo_Email != 0 {
			return ipld.ErrRepeatedMapKey{Key: &fieldName__PersonInfo_Email_serial}
		}
		ka.s += fieldBit__PersonInfo_Email
		ka.state = maState_expectValue
		ka.f = 2
		return nil
	case "name":
		if ka.s&fieldBit__PersonInfo_Name != 0 {
			return ipld.ErrRepeatedMapKey{Key: &fieldName__PersonInfo_Name_serial}
		}
		ka.s += fieldBit__PersonInfo_Name
		ka.state = maState_expectValue
		ka.f = 3
		return nil
	}
	return ipld.ErrInvalidKey{TypeName: "ipldgit.PersonInfo.Repr", Key: &_String{k}}
}
func (_PersonInfo__ReprKeyAssembler) AssignBytes([]byte) error {
	return mixins.StringAssembler{TypeName: "ipldgit.PersonInfo.Repr.KeyAssembler"}.AssignBytes(nil)
}
func (_PersonInfo__ReprKeyAssembler) AssignLink(ipld.Link) error {
	return mixins.StringAssembler{TypeName: "ipldgit.PersonInfo.Repr.KeyAssembler"}.AssignLink(nil)
}
func (ka *_PersonInfo__ReprKeyAssembler) AssignNode(v ipld.Node) error {
	if v2, err := v.AsString(); err != nil {
		return err
	} else {
		return ka.AssignString(v2)
	}
}
func (_PersonInfo__ReprKeyAssembler) Prototype() ipld.NodePrototype {
	return _String__Prototype{}
}

func (n String) String() string {
	return n.x
}
func (_String__Prototype) fromString(w *_String, v string) error {
	*w = _String{v}
	return nil
}
func (_String__Prototype) FromString(v string) (String, error) {
	n := _String{v}
	return &n, nil
}

type _String__Maybe struct {
	m schema.Maybe
	v _String
}
type MaybeString = *_String__Maybe

func (m MaybeString) IsNull() bool {
	return m.m == schema.Maybe_Null
}
func (m MaybeString) IsAbsent() bool {
	return m.m == schema.Maybe_Absent
}
func (m MaybeString) Exists() bool {
	return m.m == schema.Maybe_Value
}
func (m MaybeString) AsNode() ipld.Node {
	switch m.m {
	case schema.Maybe_Absent:
		return ipld.Absent
	case schema.Maybe_Null:
		return ipld.Null
	case schema.Maybe_Value:
		return &m.v
	default:
		panic("unreachable")
	}
}
func (m MaybeString) Must() String {
	if !m.Exists() {
		panic("unbox of a maybe rejected")
	}
	return &m.v
}

var _ ipld.Node = (String)(&_String{})
var _ schema.TypedNode = (String)(&_String{})

func (String) Kind() ipld.Kind {
	return ipld.Kind_String
}
func (String) LookupByString(string) (ipld.Node, error) {
	return mixins.String{TypeName: "ipldgit.String"}.LookupByString("")
}
func (String) LookupByNode(ipld.Node) (ipld.Node, error) {
	return mixins.String{TypeName: "ipldgit.String"}.LookupByNode(nil)
}
func (String) LookupByIndex(idx int64) (ipld.Node, error) {
	return mixins.String{TypeName: "ipldgit.String"}.LookupByIndex(0)
}
func (String) LookupBySegment(seg ipld.PathSegment) (ipld.Node, error) {
	return mixins.String{TypeName: "ipldgit.String"}.LookupBySegment(seg)
}
func (String) MapIterator() ipld.MapIterator {
	return nil
}
func (String) ListIterator() ipld.ListIterator {
	return nil
}
func (String) Length() int64 {
	return -1
}
func (String) IsAbsent() bool {
	return false
}
func (String) IsNull() bool {
	return false
}
func (String) AsBool() (bool, error) {
	return mixins.String{TypeName: "ipldgit.String"}.AsBool()
}
func (String) AsInt() (int64, error) {
	return mixins.String{TypeName: "ipldgit.String"}.AsInt()
}
func (String) AsFloat() (float64, error) {
	return mixins.String{TypeName: "ipldgit.String"}.AsFloat()
}
func (n String) AsString() (string, error) {
	return n.x, nil
}
func (String) AsBytes() ([]byte, error) {
	return mixins.String{TypeName: "ipldgit.String"}.AsBytes()
}
func (String) AsLink() (ipld.Link, error) {
	return mixins.String{TypeName: "ipldgit.String"}.AsLink()
}
func (String) Prototype() ipld.NodePrototype {
	return _String__Prototype{}
}

type _String__Prototype struct{}

func (_String__Prototype) NewBuilder() ipld.NodeBuilder {
	var nb _String__Builder
	nb.Reset()
	return &nb
}

type _String__Builder struct {
	_String__Assembler
}

func (nb *_String__Builder) Build() ipld.Node {
	if *nb.m != schema.Maybe_Value {
		panic("invalid state: cannot call Build on an assembler that's not finished")
	}
	return nb.w
}
func (nb *_String__Builder) Reset() {
	var w _String
	var m schema.Maybe
	*nb = _String__Builder{_String__Assembler{w: &w, m: &m}}
}

type _String__Assembler struct {
	w *_String
	m *schema.Maybe
}

func (na *_String__Assembler) reset() {}
func (_String__Assembler) BeginMap(sizeHint int64) (ipld.MapAssembler, error) {
	return mixins.StringAssembler{TypeName: "ipldgit.String"}.BeginMap(0)
}
func (_String__Assembler) BeginList(sizeHint int64) (ipld.ListAssembler, error) {
	return mixins.StringAssembler{TypeName: "ipldgit.String"}.BeginList(0)
}
func (na *_String__Assembler) AssignNull() error {
	switch *na.m {
	case allowNull:
		*na.m = schema.Maybe_Null
		return nil
	case schema.Maybe_Absent:
		return mixins.StringAssembler{TypeName: "ipldgit.String"}.AssignNull()
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	}
	panic("unreachable")
}
func (_String__Assembler) AssignBool(bool) error {
	return mixins.StringAssembler{TypeName: "ipldgit.String"}.AssignBool(false)
}
func (_String__Assembler) AssignInt(int64) error {
	return mixins.StringAssembler{TypeName: "ipldgit.String"}.AssignInt(0)
}
func (_String__Assembler) AssignFloat(float64) error {
	return mixins.StringAssembler{TypeName: "ipldgit.String"}.AssignFloat(0)
}
func (na *_String__Assembler) AssignString(v string) error {
	switch *na.m {
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	}
	na.w.x = v
	*na.m = schema.Maybe_Value
	return nil
}
func (_String__Assembler) AssignBytes([]byte) error {
	return mixins.StringAssembler{TypeName: "ipldgit.String"}.AssignBytes(nil)
}
func (_String__Assembler) AssignLink(ipld.Link) error {
	return mixins.StringAssembler{TypeName: "ipldgit.String"}.AssignLink(nil)
}
func (na *_String__Assembler) AssignNode(v ipld.Node) error {
	if v.IsNull() {
		return na.AssignNull()
	}
	if v2, ok := v.(*_String); ok {
		switch *na.m {
		case schema.Maybe_Value, schema.Maybe_Null:
			panic("invalid state: cannot assign into assembler that's already finished")
		}
		*na.w = *v2
		*na.m = schema.Maybe_Value
		return nil
	}
	if v2, err := v.AsString(); err != nil {
		return err
	} else {
		return na.AssignString(v2)
	}
}
func (_String__Assembler) Prototype() ipld.NodePrototype {
	return _String__Prototype{}
}
func (String) Type() schema.Type {
	return nil /*TODO:typelit*/
}
func (n String) Representation() ipld.Node {
	return (*_String__Repr)(n)
}

type _String__Repr = _String

var _ ipld.Node = &_String__Repr{}

type _String__ReprPrototype = _String__Prototype
type _String__ReprAssembler = _String__Assembler

func (n *_String_List) Lookup(idx int64) String {
	if n.Length() <= idx {
		return nil
	}
	v := &n.x[idx]
	return v
}
func (n *_String_List) LookupMaybe(idx int64) MaybeString {
	if n.Length() <= idx {
		return nil
	}
	v := &n.x[idx]
	return &_String__Maybe{
		m: schema.Maybe_Value,
		v: *v,
	}
}

var _String_List__valueAbsent = _String__Maybe{m: schema.Maybe_Absent}

func (n String_List) Iterator() *String_List__Itr {
	return &String_List__Itr{n, 0}
}

type String_List__Itr struct {
	n   String_List
	idx int
}

func (itr *String_List__Itr) Next() (idx int64, v String) {
	if itr.idx >= len(itr.n.x) {
		return -1, nil
	}
	idx = int64(itr.idx)
	v = &itr.n.x[itr.idx]
	itr.idx++
	return
}
func (itr *String_List__Itr) Done() bool {
	return itr.idx >= len(itr.n.x)
}

type _String_List__Maybe struct {
	m schema.Maybe
	v _String_List
}
type MaybeString_List = *_String_List__Maybe

func (m MaybeString_List) IsNull() bool {
	return m.m == schema.Maybe_Null
}
func (m MaybeString_List) IsAbsent() bool {
	return m.m == schema.Maybe_Absent
}
func (m MaybeString_List) Exists() bool {
	return m.m == schema.Maybe_Value
}
func (m MaybeString_List) AsNode() ipld.Node {
	switch m.m {
	case schema.Maybe_Absent:
		return ipld.Absent
	case schema.Maybe_Null:
		return ipld.Null
	case schema.Maybe_Value:
		return &m.v
	default:
		panic("unreachable")
	}
}
func (m MaybeString_List) Must() String_List {
	if !m.Exists() {
		panic("unbox of a maybe rejected")
	}
	return &m.v
}

var _ ipld.Node = (String_List)(&_String_List{})
var _ schema.TypedNode = (String_List)(&_String_List{})

func (String_List) Kind() ipld.Kind {
	return ipld.Kind_List
}
func (String_List) LookupByString(string) (ipld.Node, error) {
	return mixins.List{TypeName: "ipldgit.String_List"}.LookupByString("")
}
func (n String_List) LookupByNode(k ipld.Node) (ipld.Node, error) {
	idx, err := k.AsInt()
	if err != nil {
		return nil, err
	}
	return n.LookupByIndex(idx)
}
func (n String_List) LookupByIndex(idx int64) (ipld.Node, error) {
	if n.Length() <= idx {
		return nil, ipld.ErrNotExists{Segment: ipld.PathSegmentOfInt(idx)}
	}
	v := &n.x[idx]
	return v, nil
}
func (n String_List) LookupBySegment(seg ipld.PathSegment) (ipld.Node, error) {
	i, err := seg.Index()
	if err != nil {
		return nil, ipld.ErrInvalidSegmentForList{TypeName: "ipldgit.String_List", TroubleSegment: seg, Reason: err}
	}
	return n.LookupByIndex(i)
}
func (String_List) MapIterator() ipld.MapIterator {
	return nil
}
func (n String_List) ListIterator() ipld.ListIterator {
	return &_String_List__ListItr{n, 0}
}

type _String_List__ListItr struct {
	n   String_List
	idx int
}

func (itr *_String_List__ListItr) Next() (idx int64, v ipld.Node, _ error) {
	if itr.idx >= len(itr.n.x) {
		return -1, nil, ipld.ErrIteratorOverread{}
	}
	idx = int64(itr.idx)
	x := &itr.n.x[itr.idx]
	v = x
	itr.idx++
	return
}
func (itr *_String_List__ListItr) Done() bool {
	return itr.idx >= len(itr.n.x)
}

func (n String_List) Length() int64 {
	return int64(len(n.x))
}
func (String_List) IsAbsent() bool {
	return false
}
func (String_List) IsNull() bool {
	return false
}
func (String_List) AsBool() (bool, error) {
	return mixins.List{TypeName: "ipldgit.String_List"}.AsBool()
}
func (String_List) AsInt() (int64, error) {
	return mixins.List{TypeName: "ipldgit.String_List"}.AsInt()
}
func (String_List) AsFloat() (float64, error) {
	return mixins.List{TypeName: "ipldgit.String_List"}.AsFloat()
}
func (String_List) AsString() (string, error) {
	return mixins.List{TypeName: "ipldgit.String_List"}.AsString()
}
func (String_List) AsBytes() ([]byte, error) {
	return mixins.List{TypeName: "ipldgit.String_List"}.AsBytes()
}
func (String_List) AsLink() (ipld.Link, error) {
	return mixins.List{TypeName: "ipldgit.String_List"}.AsLink()
}
func (String_List) Prototype() ipld.NodePrototype {
	return _String_List__Prototype{}
}

type _String_List__Prototype struct{}

func (_String_List__Prototype) NewBuilder() ipld.NodeBuilder {
	var nb _String_List__Builder
	nb.Reset()
	return &nb
}

type _String_List__Builder struct {
	_String_List__Assembler
}

func (nb *_String_List__Builder) Build() ipld.Node {
	if *nb.m != schema.Maybe_Value {
		panic("invalid state: cannot call Build on an assembler that's not finished")
	}
	return nb.w
}
func (nb *_String_List__Builder) Reset() {
	var w _String_List
	var m schema.Maybe
	*nb = _String_List__Builder{_String_List__Assembler{w: &w, m: &m}}
}

type _String_List__Assembler struct {
	w     *_String_List
	m     *schema.Maybe
	state laState

	cm schema.Maybe
	va _String__Assembler
}

func (na *_String_List__Assembler) reset() {
	na.state = laState_initial
	na.va.reset()
}
func (_String_List__Assembler) BeginMap(sizeHint int64) (ipld.MapAssembler, error) {
	return mixins.ListAssembler{TypeName: "ipldgit.String_List"}.BeginMap(0)
}
func (na *_String_List__Assembler) BeginList(sizeHint int64) (ipld.ListAssembler, error) {
	switch *na.m {
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: it makes no sense to 'begin' twice on the same assembler!")
	}
	*na.m = midvalue
	if sizeHint < 0 {
		sizeHint = 0
	}
	if sizeHint > 0 {
		na.w.x = make([]_String, 0, sizeHint)
	}
	return na, nil
}
func (na *_String_List__Assembler) AssignNull() error {
	switch *na.m {
	case allowNull:
		*na.m = schema.Maybe_Null
		return nil
	case schema.Maybe_Absent:
		return mixins.ListAssembler{TypeName: "ipldgit.String_List"}.AssignNull()
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
	}
	panic("unreachable")
}
func (_String_List__Assembler) AssignBool(bool) error {
	return mixins.ListAssembler{TypeName: "ipldgit.String_List"}.AssignBool(false)
}
func (_String_List__Assembler) AssignInt(int64) error {
	return mixins.ListAssembler{TypeName: "ipldgit.String_List"}.AssignInt(0)
}
func (_String_List__Assembler) AssignFloat(float64) error {
	return mixins.ListAssembler{TypeName: "ipldgit.String_List"}.AssignFloat(0)
}
func (_String_List__Assembler) AssignString(string) error {
	return mixins.ListAssembler{TypeName: "ipldgit.String_List"}.AssignString("")
}
func (_String_List__Assembler) AssignBytes([]byte) error {
	return mixins.ListAssembler{TypeName: "ipldgit.String_List"}.AssignBytes(nil)
}
func (_String_List__Assembler) AssignLink(ipld.Link) error {
	return mixins.ListAssembler{TypeName: "ipldgit.String_List"}.AssignLink(nil)
}
func (na *_String_List__Assembler) AssignNode(v ipld.Node) error {
	if v.IsNull() {
		return na.AssignNull()
	}
	if v2, ok := v.(*_String_List); ok {
		switch *na.m {
		case schema.Maybe_Value, schema.Maybe_Null:
			panic("invalid state: cannot assign into assembler that's already finished")
		case midvalue:
			panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
		}
		*na.w = *v2
		*na.m = schema.Maybe_Value
		return nil
	}
	if v.Kind() != ipld.Kind_List {
		return ipld.ErrWrongKind{TypeName: "ipldgit.String_List", MethodName: "AssignNode", AppropriateKind: ipld.KindSet_JustList, ActualKind: v.Kind()}
	}
	itr := v.ListIterator()
	for !itr.Done() {
		_, v, err := itr.Next()
		if err != nil {
			return err
		}
		if err := na.AssembleValue().AssignNode(v); err != nil {
			return err
		}
	}
	return na.Finish()
}
func (_String_List__Assembler) Prototype() ipld.NodePrototype {
	return _String_List__Prototype{}
}
func (la *_String_List__Assembler) valueFinishTidy() bool {
	switch la.cm {
	case schema.Maybe_Value:
		la.va.w = nil
		la.cm = schema.Maybe_Absent
		la.state = laState_initial
		la.va.reset()
		return true
	default:
		return false
	}
}
func (la *_String_List__Assembler) AssembleValue() ipld.NodeAssembler {
	switch la.state {
	case laState_initial:
		// carry on
	case laState_midValue:
		if !la.valueFinishTidy() {
			panic("invalid state: AssembleValue cannot be called when still in the middle of assembling the previous value")
		} // if tidy success: carry on
	case laState_finished:
		panic("invalid state: AssembleValue cannot be called on an assembler that's already finished")
	}
	la.w.x = append(la.w.x, _String{})
	la.state = laState_midValue
	row := &la.w.x[len(la.w.x)-1]
	la.va.w = row
	la.va.m = &la.cm
	return &la.va
}
func (la *_String_List__Assembler) Finish() error {
	switch la.state {
	case laState_initial:
		// carry on
	case laState_midValue:
		if !la.valueFinishTidy() {
			panic("invalid state: Finish cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case laState_finished:
		panic("invalid state: Finish cannot be called on an assembler that's already finished")
	}
	la.state = laState_finished
	*la.m = schema.Maybe_Value
	return nil
}
func (la *_String_List__Assembler) ValuePrototype(_ int64) ipld.NodePrototype {
	return _String__Prototype{}
}
func (String_List) Type() schema.Type {
	return nil /*TODO:typelit*/
}
func (n String_List) Representation() ipld.Node {
	return (*_String_List__Repr)(n)
}

type _String_List__Repr _String_List

var _ ipld.Node = &_String_List__Repr{}

func (_String_List__Repr) Kind() ipld.Kind {
	return ipld.Kind_List
}
func (_String_List__Repr) LookupByString(string) (ipld.Node, error) {
	return mixins.List{TypeName: "ipldgit.String_List.Repr"}.LookupByString("")
}
func (nr *_String_List__Repr) LookupByNode(k ipld.Node) (ipld.Node, error) {
	v, err := (String_List)(nr).LookupByNode(k)
	if err != nil || v == ipld.Null {
		return v, err
	}
	return v.(String).Representation(), nil
}
func (nr *_String_List__Repr) LookupByIndex(idx int64) (ipld.Node, error) {
	v, err := (String_List)(nr).LookupByIndex(idx)
	if err != nil || v == ipld.Null {
		return v, err
	}
	return v.(String).Representation(), nil
}
func (n _String_List__Repr) LookupBySegment(seg ipld.PathSegment) (ipld.Node, error) {
	i, err := seg.Index()
	if err != nil {
		return nil, ipld.ErrInvalidSegmentForList{TypeName: "ipldgit.String_List.Repr", TroubleSegment: seg, Reason: err}
	}
	return n.LookupByIndex(i)
}
func (_String_List__Repr) MapIterator() ipld.MapIterator {
	return nil
}
func (nr *_String_List__Repr) ListIterator() ipld.ListIterator {
	return &_String_List__ReprListItr{(String_List)(nr), 0}
}

type _String_List__ReprListItr _String_List__ListItr

func (itr *_String_List__ReprListItr) Next() (idx int64, v ipld.Node, err error) {
	idx, v, err = (*_String_List__ListItr)(itr).Next()
	if err != nil || v == ipld.Null {
		return
	}
	return idx, v.(String).Representation(), nil
}
func (itr *_String_List__ReprListItr) Done() bool {
	return (*_String_List__ListItr)(itr).Done()
}

func (rn *_String_List__Repr) Length() int64 {
	return int64(len(rn.x))
}
func (_String_List__Repr) IsAbsent() bool {
	return false
}
func (_String_List__Repr) IsNull() bool {
	return false
}
func (_String_List__Repr) AsBool() (bool, error) {
	return mixins.List{TypeName: "ipldgit.String_List.Repr"}.AsBool()
}
func (_String_List__Repr) AsInt() (int64, error) {
	return mixins.List{TypeName: "ipldgit.String_List.Repr"}.AsInt()
}
func (_String_List__Repr) AsFloat() (float64, error) {
	return mixins.List{TypeName: "ipldgit.String_List.Repr"}.AsFloat()
}
func (_String_List__Repr) AsString() (string, error) {
	return mixins.List{TypeName: "ipldgit.String_List.Repr"}.AsString()
}
func (_String_List__Repr) AsBytes() ([]byte, error) {
	return mixins.List{TypeName: "ipldgit.String_List.Repr"}.AsBytes()
}
func (_String_List__Repr) AsLink() (ipld.Link, error) {
	return mixins.List{TypeName: "ipldgit.String_List.Repr"}.AsLink()
}
func (_String_List__Repr) Prototype() ipld.NodePrototype {
	return _String_List__ReprPrototype{}
}

type _String_List__ReprPrototype struct{}

func (_String_List__ReprPrototype) NewBuilder() ipld.NodeBuilder {
	var nb _String_List__ReprBuilder
	nb.Reset()
	return &nb
}

type _String_List__ReprBuilder struct {
	_String_List__ReprAssembler
}

func (nb *_String_List__ReprBuilder) Build() ipld.Node {
	if *nb.m != schema.Maybe_Value {
		panic("invalid state: cannot call Build on an assembler that's not finished")
	}
	return nb.w
}
func (nb *_String_List__ReprBuilder) Reset() {
	var w _String_List
	var m schema.Maybe
	*nb = _String_List__ReprBuilder{_String_List__ReprAssembler{w: &w, m: &m}}
}

type _String_List__ReprAssembler struct {
	w     *_String_List
	m     *schema.Maybe
	state laState

	cm schema.Maybe
	va _String__ReprAssembler
}

func (na *_String_List__ReprAssembler) reset() {
	na.state = laState_initial
	na.va.reset()
}
func (_String_List__ReprAssembler) BeginMap(sizeHint int64) (ipld.MapAssembler, error) {
	return mixins.ListAssembler{TypeName: "ipldgit.String_List.Repr"}.BeginMap(0)
}
func (na *_String_List__ReprAssembler) BeginList(sizeHint int64) (ipld.ListAssembler, error) {
	switch *na.m {
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: it makes no sense to 'begin' twice on the same assembler!")
	}
	*na.m = midvalue
	if sizeHint < 0 {
		sizeHint = 0
	}
	if sizeHint > 0 {
		na.w.x = make([]_String, 0, sizeHint)
	}
	return na, nil
}
func (na *_String_List__ReprAssembler) AssignNull() error {
	switch *na.m {
	case allowNull:
		*na.m = schema.Maybe_Null
		return nil
	case schema.Maybe_Absent:
		return mixins.ListAssembler{TypeName: "ipldgit.String_List.Repr.Repr"}.AssignNull()
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
	}
	panic("unreachable")
}
func (_String_List__ReprAssembler) AssignBool(bool) error {
	return mixins.ListAssembler{TypeName: "ipldgit.String_List.Repr"}.AssignBool(false)
}
func (_String_List__ReprAssembler) AssignInt(int64) error {
	return mixins.ListAssembler{TypeName: "ipldgit.String_List.Repr"}.AssignInt(0)
}
func (_String_List__ReprAssembler) AssignFloat(float64) error {
	return mixins.ListAssembler{TypeName: "ipldgit.String_List.Repr"}.AssignFloat(0)
}
func (_String_List__ReprAssembler) AssignString(string) error {
	return mixins.ListAssembler{TypeName: "ipldgit.String_List.Repr"}.AssignString("")
}
func (_String_List__ReprAssembler) AssignBytes([]byte) error {
	return mixins.ListAssembler{TypeName: "ipldgit.String_List.Repr"}.AssignBytes(nil)
}
func (_String_List__ReprAssembler) AssignLink(ipld.Link) error {
	return mixins.ListAssembler{TypeName: "ipldgit.String_List.Repr"}.AssignLink(nil)
}
func (na *_String_List__ReprAssembler) AssignNode(v ipld.Node) error {
	if v.IsNull() {
		return na.AssignNull()
	}
	if v2, ok := v.(*_String_List); ok {
		switch *na.m {
		case schema.Maybe_Value, schema.Maybe_Null:
			panic("invalid state: cannot assign into assembler that's already finished")
		case midvalue:
			panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
		}
		*na.w = *v2
		*na.m = schema.Maybe_Value
		return nil
	}
	if v.Kind() != ipld.Kind_List {
		return ipld.ErrWrongKind{TypeName: "ipldgit.String_List.Repr", MethodName: "AssignNode", AppropriateKind: ipld.KindSet_JustList, ActualKind: v.Kind()}
	}
	itr := v.ListIterator()
	for !itr.Done() {
		_, v, err := itr.Next()
		if err != nil {
			return err
		}
		if err := na.AssembleValue().AssignNode(v); err != nil {
			return err
		}
	}
	return na.Finish()
}
func (_String_List__ReprAssembler) Prototype() ipld.NodePrototype {
	return _String_List__ReprPrototype{}
}
func (la *_String_List__ReprAssembler) valueFinishTidy() bool {
	switch la.cm {
	case schema.Maybe_Value:
		la.va.w = nil
		la.cm = schema.Maybe_Absent
		la.state = laState_initial
		la.va.reset()
		return true
	default:
		return false
	}
}
func (la *_String_List__ReprAssembler) AssembleValue() ipld.NodeAssembler {
	switch la.state {
	case laState_initial:
		// carry on
	case laState_midValue:
		if !la.valueFinishTidy() {
			panic("invalid state: AssembleValue cannot be called when still in the middle of assembling the previous value")
		} // if tidy success: carry on
	case laState_finished:
		panic("invalid state: AssembleValue cannot be called on an assembler that's already finished")
	}
	la.w.x = append(la.w.x, _String{})
	la.state = laState_midValue
	row := &la.w.x[len(la.w.x)-1]
	la.va.w = row
	la.va.m = &la.cm
	return &la.va
}
func (la *_String_List__ReprAssembler) Finish() error {
	switch la.state {
	case laState_initial:
		// carry on
	case laState_midValue:
		if !la.valueFinishTidy() {
			panic("invalid state: Finish cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case laState_finished:
		panic("invalid state: Finish cannot be called on an assembler that's already finished")
	}
	la.state = laState_finished
	*la.m = schema.Maybe_Value
	return nil
}
func (la *_String_List__ReprAssembler) ValuePrototype(_ int64) ipld.NodePrototype {
	return _String__ReprPrototype{}
}

func (n _Tag) FieldObject() Link {
	return &n.object
}
func (n _Tag) FieldType() String {
	return &n.typ
}
func (n _Tag) FieldTag() String {
	return &n.tag
}
func (n _Tag) FieldTagger() PersonInfo {
	return &n.tagger
}
func (n _Tag) FieldMessage() String {
	return &n.message
}

type _Tag__Maybe struct {
	m schema.Maybe
	v Tag
}
type MaybeTag = *_Tag__Maybe

func (m MaybeTag) IsNull() bool {
	return m.m == schema.Maybe_Null
}
func (m MaybeTag) IsAbsent() bool {
	return m.m == schema.Maybe_Absent
}
func (m MaybeTag) Exists() bool {
	return m.m == schema.Maybe_Value
}
func (m MaybeTag) AsNode() ipld.Node {
	switch m.m {
	case schema.Maybe_Absent:
		return ipld.Absent
	case schema.Maybe_Null:
		return ipld.Null
	case schema.Maybe_Value:
		return m.v
	default:
		panic("unreachable")
	}
}
func (m MaybeTag) Must() Tag {
	if !m.Exists() {
		panic("unbox of a maybe rejected")
	}
	return m.v
}

var (
	fieldName__Tag_Object  = _String{"object"}
	fieldName__Tag_Type    = _String{"type"}
	fieldName__Tag_Tag     = _String{"tag"}
	fieldName__Tag_Tagger  = _String{"tagger"}
	fieldName__Tag_Message = _String{"message"}
)
var _ ipld.Node = (Tag)(&_Tag{})
var _ schema.TypedNode = (Tag)(&_Tag{})

func (Tag) Kind() ipld.Kind {
	return ipld.Kind_Map
}
func (n Tag) LookupByString(key string) (ipld.Node, error) {
	switch key {
	case "object":
		return &n.object, nil
	case "type":
		return &n.typ, nil
	case "tag":
		return &n.tag, nil
	case "tagger":
		return &n.tagger, nil
	case "message":
		return &n.message, nil
	default:
		return nil, schema.ErrNoSuchField{Type: nil /*TODO*/, Field: ipld.PathSegmentOfString(key)}
	}
}
func (n Tag) LookupByNode(key ipld.Node) (ipld.Node, error) {
	ks, err := key.AsString()
	if err != nil {
		return nil, err
	}
	return n.LookupByString(ks)
}
func (Tag) LookupByIndex(idx int64) (ipld.Node, error) {
	return mixins.Map{TypeName: "ipldgit.Tag"}.LookupByIndex(0)
}
func (n Tag) LookupBySegment(seg ipld.PathSegment) (ipld.Node, error) {
	return n.LookupByString(seg.String())
}
func (n Tag) MapIterator() ipld.MapIterator {
	return &_Tag__MapItr{n, 0}
}

type _Tag__MapItr struct {
	n   Tag
	idx int
}

func (itr *_Tag__MapItr) Next() (k ipld.Node, v ipld.Node, _ error) {
	if itr.idx >= 5 {
		return nil, nil, ipld.ErrIteratorOverread{}
	}
	switch itr.idx {
	case 0:
		k = &fieldName__Tag_Object
		v = &itr.n.object
	case 1:
		k = &fieldName__Tag_Type
		v = &itr.n.typ
	case 2:
		k = &fieldName__Tag_Tag
		v = &itr.n.tag
	case 3:
		k = &fieldName__Tag_Tagger
		v = &itr.n.tagger
	case 4:
		k = &fieldName__Tag_Message
		v = &itr.n.message
	default:
		panic("unreachable")
	}
	itr.idx++
	return
}
func (itr *_Tag__MapItr) Done() bool {
	return itr.idx >= 5
}

func (Tag) ListIterator() ipld.ListIterator {
	return nil
}
func (Tag) Length() int64 {
	return 5
}
func (Tag) IsAbsent() bool {
	return false
}
func (Tag) IsNull() bool {
	return false
}
func (Tag) AsBool() (bool, error) {
	return mixins.Map{TypeName: "ipldgit.Tag"}.AsBool()
}
func (Tag) AsInt() (int64, error) {
	return mixins.Map{TypeName: "ipldgit.Tag"}.AsInt()
}
func (Tag) AsFloat() (float64, error) {
	return mixins.Map{TypeName: "ipldgit.Tag"}.AsFloat()
}
func (Tag) AsString() (string, error) {
	return mixins.Map{TypeName: "ipldgit.Tag"}.AsString()
}
func (Tag) AsBytes() ([]byte, error) {
	return mixins.Map{TypeName: "ipldgit.Tag"}.AsBytes()
}
func (Tag) AsLink() (ipld.Link, error) {
	return mixins.Map{TypeName: "ipldgit.Tag"}.AsLink()
}
func (Tag) Prototype() ipld.NodePrototype {
	return _Tag__Prototype{}
}

type _Tag__Prototype struct{}

func (_Tag__Prototype) NewBuilder() ipld.NodeBuilder {
	var nb _Tag__Builder
	nb.Reset()
	return &nb
}

type _Tag__Builder struct {
	_Tag__Assembler
}

func (nb *_Tag__Builder) Build() ipld.Node {
	if *nb.m != schema.Maybe_Value {
		panic("invalid state: cannot call Build on an assembler that's not finished")
	}
	return nb.w
}
func (nb *_Tag__Builder) Reset() {
	var w _Tag
	var m schema.Maybe
	*nb = _Tag__Builder{_Tag__Assembler{w: &w, m: &m}}
}

type _Tag__Assembler struct {
	w     *_Tag
	m     *schema.Maybe
	state maState
	s     int
	f     int

	cm         schema.Maybe
	ca_object  _Link__Assembler
	ca_typ     _String__Assembler
	ca_tag     _String__Assembler
	ca_tagger  _PersonInfo__Assembler
	ca_message _String__Assembler
}

func (na *_Tag__Assembler) reset() {
	na.state = maState_initial
	na.s = 0
	na.ca_object.reset()
	na.ca_typ.reset()
	na.ca_tag.reset()
	na.ca_tagger.reset()
	na.ca_message.reset()
}

var (
	fieldBit__Tag_Object      = 1 << 0
	fieldBit__Tag_Type        = 1 << 1
	fieldBit__Tag_Tag         = 1 << 2
	fieldBit__Tag_Tagger      = 1 << 3
	fieldBit__Tag_Message     = 1 << 4
	fieldBits__Tag_sufficient = 0 + 1<<0 + 1<<1 + 1<<2 + 1<<3 + 1<<4
)

func (na *_Tag__Assembler) BeginMap(int64) (ipld.MapAssembler, error) {
	switch *na.m {
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: it makes no sense to 'begin' twice on the same assembler!")
	}
	*na.m = midvalue
	if na.w == nil {
		na.w = &_Tag{}
	}
	return na, nil
}
func (_Tag__Assembler) BeginList(sizeHint int64) (ipld.ListAssembler, error) {
	return mixins.MapAssembler{TypeName: "ipldgit.Tag"}.BeginList(0)
}
func (na *_Tag__Assembler) AssignNull() error {
	switch *na.m {
	case allowNull:
		*na.m = schema.Maybe_Null
		return nil
	case schema.Maybe_Absent:
		return mixins.MapAssembler{TypeName: "ipldgit.Tag"}.AssignNull()
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
	}
	panic("unreachable")
}
func (_Tag__Assembler) AssignBool(bool) error {
	return mixins.MapAssembler{TypeName: "ipldgit.Tag"}.AssignBool(false)
}
func (_Tag__Assembler) AssignInt(int64) error {
	return mixins.MapAssembler{TypeName: "ipldgit.Tag"}.AssignInt(0)
}
func (_Tag__Assembler) AssignFloat(float64) error {
	return mixins.MapAssembler{TypeName: "ipldgit.Tag"}.AssignFloat(0)
}
func (_Tag__Assembler) AssignString(string) error {
	return mixins.MapAssembler{TypeName: "ipldgit.Tag"}.AssignString("")
}
func (_Tag__Assembler) AssignBytes([]byte) error {
	return mixins.MapAssembler{TypeName: "ipldgit.Tag"}.AssignBytes(nil)
}
func (_Tag__Assembler) AssignLink(ipld.Link) error {
	return mixins.MapAssembler{TypeName: "ipldgit.Tag"}.AssignLink(nil)
}
func (na *_Tag__Assembler) AssignNode(v ipld.Node) error {
	if v.IsNull() {
		return na.AssignNull()
	}
	if v2, ok := v.(*_Tag); ok {
		switch *na.m {
		case schema.Maybe_Value, schema.Maybe_Null:
			panic("invalid state: cannot assign into assembler that's already finished")
		case midvalue:
			panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
		}
		if na.w == nil {
			na.w = v2
			*na.m = schema.Maybe_Value
			return nil
		}
		*na.w = *v2
		*na.m = schema.Maybe_Value
		return nil
	}
	if v.Kind() != ipld.Kind_Map {
		return ipld.ErrWrongKind{TypeName: "ipldgit.Tag", MethodName: "AssignNode", AppropriateKind: ipld.KindSet_JustMap, ActualKind: v.Kind()}
	}
	itr := v.MapIterator()
	for !itr.Done() {
		k, v, err := itr.Next()
		if err != nil {
			return err
		}
		if err := na.AssembleKey().AssignNode(k); err != nil {
			return err
		}
		if err := na.AssembleValue().AssignNode(v); err != nil {
			return err
		}
	}
	return na.Finish()
}
func (_Tag__Assembler) Prototype() ipld.NodePrototype {
	return _Tag__Prototype{}
}
func (ma *_Tag__Assembler) valueFinishTidy() bool {
	switch ma.f {
	case 0:
		switch ma.cm {
		case schema.Maybe_Value:
			ma.ca_object.w = nil
			ma.cm = schema.Maybe_Absent
			ma.state = maState_initial
			return true
		default:
			return false
		}
	case 1:
		switch ma.cm {
		case schema.Maybe_Value:
			ma.ca_typ.w = nil
			ma.cm = schema.Maybe_Absent
			ma.state = maState_initial
			return true
		default:
			return false
		}
	case 2:
		switch ma.cm {
		case schema.Maybe_Value:
			ma.ca_tag.w = nil
			ma.cm = schema.Maybe_Absent
			ma.state = maState_initial
			return true
		default:
			return false
		}
	case 3:
		switch ma.cm {
		case schema.Maybe_Value:
			ma.ca_tagger.w = nil
			ma.cm = schema.Maybe_Absent
			ma.state = maState_initial
			return true
		default:
			return false
		}
	case 4:
		switch ma.cm {
		case schema.Maybe_Value:
			ma.ca_message.w = nil
			ma.cm = schema.Maybe_Absent
			ma.state = maState_initial
			return true
		default:
			return false
		}
	default:
		panic("unreachable")
	}
}
func (ma *_Tag__Assembler) AssembleEntry(k string) (ipld.NodeAssembler, error) {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: AssembleEntry cannot be called when in the middle of assembling another key")
	case maState_expectValue:
		panic("invalid state: AssembleEntry cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: AssembleEntry cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: AssembleEntry cannot be called on an assembler that's already finished")
	}
	switch k {
	case "object":
		if ma.s&fieldBit__Tag_Object != 0 {
			return nil, ipld.ErrRepeatedMapKey{Key: &fieldName__Tag_Object}
		}
		ma.s += fieldBit__Tag_Object
		ma.state = maState_midValue
		ma.f = 0
		ma.ca_object.w = &ma.w.object
		ma.ca_object.m = &ma.cm
		return &ma.ca_object, nil
	case "type":
		if ma.s&fieldBit__Tag_Type != 0 {
			return nil, ipld.ErrRepeatedMapKey{Key: &fieldName__Tag_Type}
		}
		ma.s += fieldBit__Tag_Type
		ma.state = maState_midValue
		ma.f = 1
		ma.ca_typ.w = &ma.w.typ
		ma.ca_typ.m = &ma.cm
		return &ma.ca_typ, nil
	case "tag":
		if ma.s&fieldBit__Tag_Tag != 0 {
			return nil, ipld.ErrRepeatedMapKey{Key: &fieldName__Tag_Tag}
		}
		ma.s += fieldBit__Tag_Tag
		ma.state = maState_midValue
		ma.f = 2
		ma.ca_tag.w = &ma.w.tag
		ma.ca_tag.m = &ma.cm
		return &ma.ca_tag, nil
	case "tagger":
		if ma.s&fieldBit__Tag_Tagger != 0 {
			return nil, ipld.ErrRepeatedMapKey{Key: &fieldName__Tag_Tagger}
		}
		ma.s += fieldBit__Tag_Tagger
		ma.state = maState_midValue
		ma.f = 3
		ma.ca_tagger.w = &ma.w.tagger
		ma.ca_tagger.m = &ma.cm
		return &ma.ca_tagger, nil
	case "message":
		if ma.s&fieldBit__Tag_Message != 0 {
			return nil, ipld.ErrRepeatedMapKey{Key: &fieldName__Tag_Message}
		}
		ma.s += fieldBit__Tag_Message
		ma.state = maState_midValue
		ma.f = 4
		ma.ca_message.w = &ma.w.message
		ma.ca_message.m = &ma.cm
		return &ma.ca_message, nil
	}
	return nil, ipld.ErrInvalidKey{TypeName: "ipldgit.Tag", Key: &_String{k}}
}
func (ma *_Tag__Assembler) AssembleKey() ipld.NodeAssembler {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: AssembleKey cannot be called when in the middle of assembling another key")
	case maState_expectValue:
		panic("invalid state: AssembleKey cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: AssembleKey cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: AssembleKey cannot be called on an assembler that's already finished")
	}
	ma.state = maState_midKey
	return (*_Tag__KeyAssembler)(ma)
}
func (ma *_Tag__Assembler) AssembleValue() ipld.NodeAssembler {
	switch ma.state {
	case maState_initial:
		panic("invalid state: AssembleValue cannot be called when no key is primed")
	case maState_midKey:
		panic("invalid state: AssembleValue cannot be called when in the middle of assembling a key")
	case maState_expectValue:
		// carry on
	case maState_midValue:
		panic("invalid state: AssembleValue cannot be called when in the middle of assembling another value")
	case maState_finished:
		panic("invalid state: AssembleValue cannot be called on an assembler that's already finished")
	}
	ma.state = maState_midValue
	switch ma.f {
	case 0:
		ma.ca_object.w = &ma.w.object
		ma.ca_object.m = &ma.cm
		return &ma.ca_object
	case 1:
		ma.ca_typ.w = &ma.w.typ
		ma.ca_typ.m = &ma.cm
		return &ma.ca_typ
	case 2:
		ma.ca_tag.w = &ma.w.tag
		ma.ca_tag.m = &ma.cm
		return &ma.ca_tag
	case 3:
		ma.ca_tagger.w = &ma.w.tagger
		ma.ca_tagger.m = &ma.cm
		return &ma.ca_tagger
	case 4:
		ma.ca_message.w = &ma.w.message
		ma.ca_message.m = &ma.cm
		return &ma.ca_message
	default:
		panic("unreachable")
	}
}
func (ma *_Tag__Assembler) Finish() error {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: Finish cannot be called when in the middle of assembling a key")
	case maState_expectValue:
		panic("invalid state: Finish cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: Finish cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: Finish cannot be called on an assembler that's already finished")
	}
	if ma.s&fieldBits__Tag_sufficient != fieldBits__Tag_sufficient {
		err := ipld.ErrMissingRequiredField{Missing: make([]string, 0)}
		if ma.s&fieldBit__Tag_Object == 0 {
			err.Missing = append(err.Missing, "object")
		}
		if ma.s&fieldBit__Tag_Type == 0 {
			err.Missing = append(err.Missing, "type")
		}
		if ma.s&fieldBit__Tag_Tag == 0 {
			err.Missing = append(err.Missing, "tag")
		}
		if ma.s&fieldBit__Tag_Tagger == 0 {
			err.Missing = append(err.Missing, "tagger")
		}
		if ma.s&fieldBit__Tag_Message == 0 {
			err.Missing = append(err.Missing, "message")
		}
		return err
	}
	ma.state = maState_finished
	*ma.m = schema.Maybe_Value
	return nil
}
func (ma *_Tag__Assembler) KeyPrototype() ipld.NodePrototype {
	return _String__Prototype{}
}
func (ma *_Tag__Assembler) ValuePrototype(k string) ipld.NodePrototype {
	panic("todo structbuilder mapassembler valueprototype")
}

type _Tag__KeyAssembler _Tag__Assembler

func (_Tag__KeyAssembler) BeginMap(sizeHint int64) (ipld.MapAssembler, error) {
	return mixins.StringAssembler{TypeName: "ipldgit.Tag.KeyAssembler"}.BeginMap(0)
}
func (_Tag__KeyAssembler) BeginList(sizeHint int64) (ipld.ListAssembler, error) {
	return mixins.StringAssembler{TypeName: "ipldgit.Tag.KeyAssembler"}.BeginList(0)
}
func (na *_Tag__KeyAssembler) AssignNull() error {
	return mixins.StringAssembler{TypeName: "ipldgit.Tag.KeyAssembler"}.AssignNull()
}
func (_Tag__KeyAssembler) AssignBool(bool) error {
	return mixins.StringAssembler{TypeName: "ipldgit.Tag.KeyAssembler"}.AssignBool(false)
}
func (_Tag__KeyAssembler) AssignInt(int64) error {
	return mixins.StringAssembler{TypeName: "ipldgit.Tag.KeyAssembler"}.AssignInt(0)
}
func (_Tag__KeyAssembler) AssignFloat(float64) error {
	return mixins.StringAssembler{TypeName: "ipldgit.Tag.KeyAssembler"}.AssignFloat(0)
}
func (ka *_Tag__KeyAssembler) AssignString(k string) error {
	if ka.state != maState_midKey {
		panic("misuse: KeyAssembler held beyond its valid lifetime")
	}
	switch k {
	case "object":
		if ka.s&fieldBit__Tag_Object != 0 {
			return ipld.ErrRepeatedMapKey{Key: &fieldName__Tag_Object}
		}
		ka.s += fieldBit__Tag_Object
		ka.state = maState_expectValue
		ka.f = 0
		return nil
	case "type":
		if ka.s&fieldBit__Tag_Type != 0 {
			return ipld.ErrRepeatedMapKey{Key: &fieldName__Tag_Type}
		}
		ka.s += fieldBit__Tag_Type
		ka.state = maState_expectValue
		ka.f = 1
		return nil
	case "tag":
		if ka.s&fieldBit__Tag_Tag != 0 {
			return ipld.ErrRepeatedMapKey{Key: &fieldName__Tag_Tag}
		}
		ka.s += fieldBit__Tag_Tag
		ka.state = maState_expectValue
		ka.f = 2
		return nil
	case "tagger":
		if ka.s&fieldBit__Tag_Tagger != 0 {
			return ipld.ErrRepeatedMapKey{Key: &fieldName__Tag_Tagger}
		}
		ka.s += fieldBit__Tag_Tagger
		ka.state = maState_expectValue
		ka.f = 3
		return nil
	case "message":
		if ka.s&fieldBit__Tag_Message != 0 {
			return ipld.ErrRepeatedMapKey{Key: &fieldName__Tag_Message}
		}
		ka.s += fieldBit__Tag_Message
		ka.state = maState_expectValue
		ka.f = 4
		return nil
	default:
		return ipld.ErrInvalidKey{TypeName: "ipldgit.Tag", Key: &_String{k}}
	}
}
func (_Tag__KeyAssembler) AssignBytes([]byte) error {
	return mixins.StringAssembler{TypeName: "ipldgit.Tag.KeyAssembler"}.AssignBytes(nil)
}
func (_Tag__KeyAssembler) AssignLink(ipld.Link) error {
	return mixins.StringAssembler{TypeName: "ipldgit.Tag.KeyAssembler"}.AssignLink(nil)
}
func (ka *_Tag__KeyAssembler) AssignNode(v ipld.Node) error {
	if v2, err := v.AsString(); err != nil {
		return err
	} else {
		return ka.AssignString(v2)
	}
}
func (_Tag__KeyAssembler) Prototype() ipld.NodePrototype {
	return _String__Prototype{}
}
func (Tag) Type() schema.Type {
	return nil /*TODO:typelit*/
}
func (n Tag) Representation() ipld.Node {
	return (*_Tag__Repr)(n)
}

type _Tag__Repr _Tag

var (
	fieldName__Tag_Object_serial  = _String{"object"}
	fieldName__Tag_Type_serial    = _String{"type"}
	fieldName__Tag_Tag_serial     = _String{"tag"}
	fieldName__Tag_Tagger_serial  = _String{"tagger"}
	fieldName__Tag_Message_serial = _String{"message"}
)
var _ ipld.Node = &_Tag__Repr{}

func (_Tag__Repr) Kind() ipld.Kind {
	return ipld.Kind_Map
}
func (n *_Tag__Repr) LookupByString(key string) (ipld.Node, error) {
	switch key {
	case "object":
		return n.object.Representation(), nil
	case "type":
		return n.typ.Representation(), nil
	case "tag":
		return n.tag.Representation(), nil
	case "tagger":
		return n.tagger.Representation(), nil
	case "message":
		return n.message.Representation(), nil
	default:
		return nil, schema.ErrNoSuchField{Type: nil /*TODO*/, Field: ipld.PathSegmentOfString(key)}
	}
}
func (n *_Tag__Repr) LookupByNode(key ipld.Node) (ipld.Node, error) {
	ks, err := key.AsString()
	if err != nil {
		return nil, err
	}
	return n.LookupByString(ks)
}
func (_Tag__Repr) LookupByIndex(idx int64) (ipld.Node, error) {
	return mixins.Map{TypeName: "ipldgit.Tag.Repr"}.LookupByIndex(0)
}
func (n _Tag__Repr) LookupBySegment(seg ipld.PathSegment) (ipld.Node, error) {
	return n.LookupByString(seg.String())
}
func (n *_Tag__Repr) MapIterator() ipld.MapIterator {
	return &_Tag__ReprMapItr{n, 0}
}

type _Tag__ReprMapItr struct {
	n   *_Tag__Repr
	idx int
}

func (itr *_Tag__ReprMapItr) Next() (k ipld.Node, v ipld.Node, _ error) {
	if itr.idx >= 5 {
		return nil, nil, ipld.ErrIteratorOverread{}
	}
	switch itr.idx {
	case 0:
		k = &fieldName__Tag_Object_serial
		v = itr.n.object.Representation()
	case 1:
		k = &fieldName__Tag_Type_serial
		v = itr.n.typ.Representation()
	case 2:
		k = &fieldName__Tag_Tag_serial
		v = itr.n.tag.Representation()
	case 3:
		k = &fieldName__Tag_Tagger_serial
		v = itr.n.tagger.Representation()
	case 4:
		k = &fieldName__Tag_Message_serial
		v = itr.n.message.Representation()
	default:
		panic("unreachable")
	}
	itr.idx++
	return
}
func (itr *_Tag__ReprMapItr) Done() bool {
	return itr.idx >= 5
}
func (_Tag__Repr) ListIterator() ipld.ListIterator {
	return nil
}
func (rn *_Tag__Repr) Length() int64 {
	l := 5
	return int64(l)
}
func (_Tag__Repr) IsAbsent() bool {
	return false
}
func (_Tag__Repr) IsNull() bool {
	return false
}
func (_Tag__Repr) AsBool() (bool, error) {
	return mixins.Map{TypeName: "ipldgit.Tag.Repr"}.AsBool()
}
func (_Tag__Repr) AsInt() (int64, error) {
	return mixins.Map{TypeName: "ipldgit.Tag.Repr"}.AsInt()
}
func (_Tag__Repr) AsFloat() (float64, error) {
	return mixins.Map{TypeName: "ipldgit.Tag.Repr"}.AsFloat()
}
func (_Tag__Repr) AsString() (string, error) {
	return mixins.Map{TypeName: "ipldgit.Tag.Repr"}.AsString()
}
func (_Tag__Repr) AsBytes() ([]byte, error) {
	return mixins.Map{TypeName: "ipldgit.Tag.Repr"}.AsBytes()
}
func (_Tag__Repr) AsLink() (ipld.Link, error) {
	return mixins.Map{TypeName: "ipldgit.Tag.Repr"}.AsLink()
}
func (_Tag__Repr) Prototype() ipld.NodePrototype {
	return _Tag__ReprPrototype{}
}

type _Tag__ReprPrototype struct{}

func (_Tag__ReprPrototype) NewBuilder() ipld.NodeBuilder {
	var nb _Tag__ReprBuilder
	nb.Reset()
	return &nb
}

type _Tag__ReprBuilder struct {
	_Tag__ReprAssembler
}

func (nb *_Tag__ReprBuilder) Build() ipld.Node {
	if *nb.m != schema.Maybe_Value {
		panic("invalid state: cannot call Build on an assembler that's not finished")
	}
	return nb.w
}
func (nb *_Tag__ReprBuilder) Reset() {
	var w _Tag
	var m schema.Maybe
	*nb = _Tag__ReprBuilder{_Tag__ReprAssembler{w: &w, m: &m}}
}

type _Tag__ReprAssembler struct {
	w     *_Tag
	m     *schema.Maybe
	state maState
	s     int
	f     int

	cm         schema.Maybe
	ca_object  _Link__ReprAssembler
	ca_typ     _String__ReprAssembler
	ca_tag     _String__ReprAssembler
	ca_tagger  _PersonInfo__ReprAssembler
	ca_message _String__ReprAssembler
}

func (na *_Tag__ReprAssembler) reset() {
	na.state = maState_initial
	na.s = 0
	na.ca_object.reset()
	na.ca_typ.reset()
	na.ca_tag.reset()
	na.ca_tagger.reset()
	na.ca_message.reset()
}
func (na *_Tag__ReprAssembler) BeginMap(int64) (ipld.MapAssembler, error) {
	switch *na.m {
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: it makes no sense to 'begin' twice on the same assembler!")
	}
	*na.m = midvalue
	if na.w == nil {
		na.w = &_Tag{}
	}
	return na, nil
}
func (_Tag__ReprAssembler) BeginList(sizeHint int64) (ipld.ListAssembler, error) {
	return mixins.MapAssembler{TypeName: "ipldgit.Tag.Repr"}.BeginList(0)
}
func (na *_Tag__ReprAssembler) AssignNull() error {
	switch *na.m {
	case allowNull:
		*na.m = schema.Maybe_Null
		return nil
	case schema.Maybe_Absent:
		return mixins.MapAssembler{TypeName: "ipldgit.Tag.Repr.Repr"}.AssignNull()
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
	}
	panic("unreachable")
}
func (_Tag__ReprAssembler) AssignBool(bool) error {
	return mixins.MapAssembler{TypeName: "ipldgit.Tag.Repr"}.AssignBool(false)
}
func (_Tag__ReprAssembler) AssignInt(int64) error {
	return mixins.MapAssembler{TypeName: "ipldgit.Tag.Repr"}.AssignInt(0)
}
func (_Tag__ReprAssembler) AssignFloat(float64) error {
	return mixins.MapAssembler{TypeName: "ipldgit.Tag.Repr"}.AssignFloat(0)
}
func (_Tag__ReprAssembler) AssignString(string) error {
	return mixins.MapAssembler{TypeName: "ipldgit.Tag.Repr"}.AssignString("")
}
func (_Tag__ReprAssembler) AssignBytes([]byte) error {
	return mixins.MapAssembler{TypeName: "ipldgit.Tag.Repr"}.AssignBytes(nil)
}
func (_Tag__ReprAssembler) AssignLink(ipld.Link) error {
	return mixins.MapAssembler{TypeName: "ipldgit.Tag.Repr"}.AssignLink(nil)
}
func (na *_Tag__ReprAssembler) AssignNode(v ipld.Node) error {
	if v.IsNull() {
		return na.AssignNull()
	}
	if v2, ok := v.(*_Tag); ok {
		switch *na.m {
		case schema.Maybe_Value, schema.Maybe_Null:
			panic("invalid state: cannot assign into assembler that's already finished")
		case midvalue:
			panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
		}
		if na.w == nil {
			na.w = v2
			*na.m = schema.Maybe_Value
			return nil
		}
		*na.w = *v2
		*na.m = schema.Maybe_Value
		return nil
	}
	if v.Kind() != ipld.Kind_Map {
		return ipld.ErrWrongKind{TypeName: "ipldgit.Tag.Repr", MethodName: "AssignNode", AppropriateKind: ipld.KindSet_JustMap, ActualKind: v.Kind()}
	}
	itr := v.MapIterator()
	for !itr.Done() {
		k, v, err := itr.Next()
		if err != nil {
			return err
		}
		if err := na.AssembleKey().AssignNode(k); err != nil {
			return err
		}
		if err := na.AssembleValue().AssignNode(v); err != nil {
			return err
		}
	}
	return na.Finish()
}
func (_Tag__ReprAssembler) Prototype() ipld.NodePrototype {
	return _Tag__ReprPrototype{}
}
func (ma *_Tag__ReprAssembler) valueFinishTidy() bool {
	switch ma.f {
	case 0:
		switch ma.cm {
		case schema.Maybe_Value:
			ma.cm = schema.Maybe_Absent
			ma.state = maState_initial
			return true
		default:
			return false
		}
	case 1:
		switch ma.cm {
		case schema.Maybe_Value:
			ma.cm = schema.Maybe_Absent
			ma.state = maState_initial
			return true
		default:
			return false
		}
	case 2:
		switch ma.cm {
		case schema.Maybe_Value:
			ma.cm = schema.Maybe_Absent
			ma.state = maState_initial
			return true
		default:
			return false
		}
	case 3:
		switch ma.cm {
		case schema.Maybe_Value:
			ma.cm = schema.Maybe_Absent
			ma.state = maState_initial
			return true
		default:
			return false
		}
	case 4:
		switch ma.cm {
		case schema.Maybe_Value:
			ma.cm = schema.Maybe_Absent
			ma.state = maState_initial
			return true
		default:
			return false
		}
	default:
		panic("unreachable")
	}
}
func (ma *_Tag__ReprAssembler) AssembleEntry(k string) (ipld.NodeAssembler, error) {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: AssembleEntry cannot be called when in the middle of assembling another key")
	case maState_expectValue:
		panic("invalid state: AssembleEntry cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: AssembleEntry cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: AssembleEntry cannot be called on an assembler that's already finished")
	}
	switch k {
	case "object":
		if ma.s&fieldBit__Tag_Object != 0 {
			return nil, ipld.ErrRepeatedMapKey{Key: &fieldName__Tag_Object_serial}
		}
		ma.s += fieldBit__Tag_Object
		ma.state = maState_midValue
		ma.f = 0
		ma.ca_object.w = &ma.w.object
		ma.ca_object.m = &ma.cm
		return &ma.ca_object, nil
	case "type":
		if ma.s&fieldBit__Tag_Type != 0 {
			return nil, ipld.ErrRepeatedMapKey{Key: &fieldName__Tag_Type_serial}
		}
		ma.s += fieldBit__Tag_Type
		ma.state = maState_midValue
		ma.f = 1
		ma.ca_typ.w = &ma.w.typ
		ma.ca_typ.m = &ma.cm
		return &ma.ca_typ, nil
	case "tag":
		if ma.s&fieldBit__Tag_Tag != 0 {
			return nil, ipld.ErrRepeatedMapKey{Key: &fieldName__Tag_Tag_serial}
		}
		ma.s += fieldBit__Tag_Tag
		ma.state = maState_midValue
		ma.f = 2
		ma.ca_tag.w = &ma.w.tag
		ma.ca_tag.m = &ma.cm
		return &ma.ca_tag, nil
	case "tagger":
		if ma.s&fieldBit__Tag_Tagger != 0 {
			return nil, ipld.ErrRepeatedMapKey{Key: &fieldName__Tag_Tagger_serial}
		}
		ma.s += fieldBit__Tag_Tagger
		ma.state = maState_midValue
		ma.f = 3
		ma.ca_tagger.w = &ma.w.tagger
		ma.ca_tagger.m = &ma.cm
		return &ma.ca_tagger, nil
	case "message":
		if ma.s&fieldBit__Tag_Message != 0 {
			return nil, ipld.ErrRepeatedMapKey{Key: &fieldName__Tag_Message_serial}
		}
		ma.s += fieldBit__Tag_Message
		ma.state = maState_midValue
		ma.f = 4
		ma.ca_message.w = &ma.w.message
		ma.ca_message.m = &ma.cm
		return &ma.ca_message, nil
	default:
	}
	return nil, ipld.ErrInvalidKey{TypeName: "ipldgit.Tag.Repr", Key: &_String{k}}
}
func (ma *_Tag__ReprAssembler) AssembleKey() ipld.NodeAssembler {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: AssembleKey cannot be called when in the middle of assembling another key")
	case maState_expectValue:
		panic("invalid state: AssembleKey cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: AssembleKey cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: AssembleKey cannot be called on an assembler that's already finished")
	}
	ma.state = maState_midKey
	return (*_Tag__ReprKeyAssembler)(ma)
}
func (ma *_Tag__ReprAssembler) AssembleValue() ipld.NodeAssembler {
	switch ma.state {
	case maState_initial:
		panic("invalid state: AssembleValue cannot be called when no key is primed")
	case maState_midKey:
		panic("invalid state: AssembleValue cannot be called when in the middle of assembling a key")
	case maState_expectValue:
		// carry on
	case maState_midValue:
		panic("invalid state: AssembleValue cannot be called when in the middle of assembling another value")
	case maState_finished:
		panic("invalid state: AssembleValue cannot be called on an assembler that's already finished")
	}
	ma.state = maState_midValue
	switch ma.f {
	case 0:
		ma.ca_object.w = &ma.w.object
		ma.ca_object.m = &ma.cm
		return &ma.ca_object
	case 1:
		ma.ca_typ.w = &ma.w.typ
		ma.ca_typ.m = &ma.cm
		return &ma.ca_typ
	case 2:
		ma.ca_tag.w = &ma.w.tag
		ma.ca_tag.m = &ma.cm
		return &ma.ca_tag
	case 3:
		ma.ca_tagger.w = &ma.w.tagger
		ma.ca_tagger.m = &ma.cm
		return &ma.ca_tagger
	case 4:
		ma.ca_message.w = &ma.w.message
		ma.ca_message.m = &ma.cm
		return &ma.ca_message
	default:
		panic("unreachable")
	}
}
func (ma *_Tag__ReprAssembler) Finish() error {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: Finish cannot be called when in the middle of assembling a key")
	case maState_expectValue:
		panic("invalid state: Finish cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: Finish cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: Finish cannot be called on an assembler that's already finished")
	}
	if ma.s&fieldBits__Tag_sufficient != fieldBits__Tag_sufficient {
		err := ipld.ErrMissingRequiredField{Missing: make([]string, 0)}
		if ma.s&fieldBit__Tag_Object == 0 {
			err.Missing = append(err.Missing, "object")
		}
		if ma.s&fieldBit__Tag_Type == 0 {
			err.Missing = append(err.Missing, "type")
		}
		if ma.s&fieldBit__Tag_Tag == 0 {
			err.Missing = append(err.Missing, "tag")
		}
		if ma.s&fieldBit__Tag_Tagger == 0 {
			err.Missing = append(err.Missing, "tagger")
		}
		if ma.s&fieldBit__Tag_Message == 0 {
			err.Missing = append(err.Missing, "message")
		}
		return err
	}
	ma.state = maState_finished
	*ma.m = schema.Maybe_Value
	return nil
}
func (ma *_Tag__ReprAssembler) KeyPrototype() ipld.NodePrototype {
	return _String__Prototype{}
}
func (ma *_Tag__ReprAssembler) ValuePrototype(k string) ipld.NodePrototype {
	panic("todo structbuilder mapassembler repr valueprototype")
}

type _Tag__ReprKeyAssembler _Tag__ReprAssembler

func (_Tag__ReprKeyAssembler) BeginMap(sizeHint int64) (ipld.MapAssembler, error) {
	return mixins.StringAssembler{TypeName: "ipldgit.Tag.Repr.KeyAssembler"}.BeginMap(0)
}
func (_Tag__ReprKeyAssembler) BeginList(sizeHint int64) (ipld.ListAssembler, error) {
	return mixins.StringAssembler{TypeName: "ipldgit.Tag.Repr.KeyAssembler"}.BeginList(0)
}
func (na *_Tag__ReprKeyAssembler) AssignNull() error {
	return mixins.StringAssembler{TypeName: "ipldgit.Tag.Repr.KeyAssembler"}.AssignNull()
}
func (_Tag__ReprKeyAssembler) AssignBool(bool) error {
	return mixins.StringAssembler{TypeName: "ipldgit.Tag.Repr.KeyAssembler"}.AssignBool(false)
}
func (_Tag__ReprKeyAssembler) AssignInt(int64) error {
	return mixins.StringAssembler{TypeName: "ipldgit.Tag.Repr.KeyAssembler"}.AssignInt(0)
}
func (_Tag__ReprKeyAssembler) AssignFloat(float64) error {
	return mixins.StringAssembler{TypeName: "ipldgit.Tag.Repr.KeyAssembler"}.AssignFloat(0)
}
func (ka *_Tag__ReprKeyAssembler) AssignString(k string) error {
	if ka.state != maState_midKey {
		panic("misuse: KeyAssembler held beyond its valid lifetime")
	}
	switch k {
	case "object":
		if ka.s&fieldBit__Tag_Object != 0 {
			return ipld.ErrRepeatedMapKey{Key: &fieldName__Tag_Object_serial}
		}
		ka.s += fieldBit__Tag_Object
		ka.state = maState_expectValue
		ka.f = 0
		return nil
	case "type":
		if ka.s&fieldBit__Tag_Type != 0 {
			return ipld.ErrRepeatedMapKey{Key: &fieldName__Tag_Type_serial}
		}
		ka.s += fieldBit__Tag_Type
		ka.state = maState_expectValue
		ka.f = 1
		return nil
	case "tag":
		if ka.s&fieldBit__Tag_Tag != 0 {
			return ipld.ErrRepeatedMapKey{Key: &fieldName__Tag_Tag_serial}
		}
		ka.s += fieldBit__Tag_Tag
		ka.state = maState_expectValue
		ka.f = 2
		return nil
	case "tagger":
		if ka.s&fieldBit__Tag_Tagger != 0 {
			return ipld.ErrRepeatedMapKey{Key: &fieldName__Tag_Tagger_serial}
		}
		ka.s += fieldBit__Tag_Tagger
		ka.state = maState_expectValue
		ka.f = 3
		return nil
	case "message":
		if ka.s&fieldBit__Tag_Message != 0 {
			return ipld.ErrRepeatedMapKey{Key: &fieldName__Tag_Message_serial}
		}
		ka.s += fieldBit__Tag_Message
		ka.state = maState_expectValue
		ka.f = 4
		return nil
	}
	return ipld.ErrInvalidKey{TypeName: "ipldgit.Tag.Repr", Key: &_String{k}}
}
func (_Tag__ReprKeyAssembler) AssignBytes([]byte) error {
	return mixins.StringAssembler{TypeName: "ipldgit.Tag.Repr.KeyAssembler"}.AssignBytes(nil)
}
func (_Tag__ReprKeyAssembler) AssignLink(ipld.Link) error {
	return mixins.StringAssembler{TypeName: "ipldgit.Tag.Repr.KeyAssembler"}.AssignLink(nil)
}
func (ka *_Tag__ReprKeyAssembler) AssignNode(v ipld.Node) error {
	if v2, err := v.AsString(); err != nil {
		return err
	} else {
		return ka.AssignString(v2)
	}
}
func (_Tag__ReprKeyAssembler) Prototype() ipld.NodePrototype {
	return _String__Prototype{}
}

func (n *_Tag_List) Lookup(idx int64) Tag {
	if n.Length() <= idx {
		return nil
	}
	v := &n.x[idx]
	return v
}
func (n *_Tag_List) LookupMaybe(idx int64) MaybeTag {
	if n.Length() <= idx {
		return nil
	}
	v := &n.x[idx]
	return &_Tag__Maybe{
		m: schema.Maybe_Value,
		v: v,
	}
}

var _Tag_List__valueAbsent = _Tag__Maybe{m: schema.Maybe_Absent}

func (n Tag_List) Iterator() *Tag_List__Itr {
	return &Tag_List__Itr{n, 0}
}

type Tag_List__Itr struct {
	n   Tag_List
	idx int
}

func (itr *Tag_List__Itr) Next() (idx int64, v Tag) {
	if itr.idx >= len(itr.n.x) {
		return -1, nil
	}
	idx = int64(itr.idx)
	v = &itr.n.x[itr.idx]
	itr.idx++
	return
}
func (itr *Tag_List__Itr) Done() bool {
	return itr.idx >= len(itr.n.x)
}

type _Tag_List__Maybe struct {
	m schema.Maybe
	v _Tag_List
}
type MaybeTag_List = *_Tag_List__Maybe

func (m MaybeTag_List) IsNull() bool {
	return m.m == schema.Maybe_Null
}
func (m MaybeTag_List) IsAbsent() bool {
	return m.m == schema.Maybe_Absent
}
func (m MaybeTag_List) Exists() bool {
	return m.m == schema.Maybe_Value
}
func (m MaybeTag_List) AsNode() ipld.Node {
	switch m.m {
	case schema.Maybe_Absent:
		return ipld.Absent
	case schema.Maybe_Null:
		return ipld.Null
	case schema.Maybe_Value:
		return &m.v
	default:
		panic("unreachable")
	}
}
func (m MaybeTag_List) Must() Tag_List {
	if !m.Exists() {
		panic("unbox of a maybe rejected")
	}
	return &m.v
}

var _ ipld.Node = (Tag_List)(&_Tag_List{})
var _ schema.TypedNode = (Tag_List)(&_Tag_List{})

func (Tag_List) Kind() ipld.Kind {
	return ipld.Kind_List
}
func (Tag_List) LookupByString(string) (ipld.Node, error) {
	return mixins.List{TypeName: "ipldgit.Tag_List"}.LookupByString("")
}
func (n Tag_List) LookupByNode(k ipld.Node) (ipld.Node, error) {
	idx, err := k.AsInt()
	if err != nil {
		return nil, err
	}
	return n.LookupByIndex(idx)
}
func (n Tag_List) LookupByIndex(idx int64) (ipld.Node, error) {
	if n.Length() <= idx {
		return nil, ipld.ErrNotExists{Segment: ipld.PathSegmentOfInt(idx)}
	}
	v := &n.x[idx]
	return v, nil
}
func (n Tag_List) LookupBySegment(seg ipld.PathSegment) (ipld.Node, error) {
	i, err := seg.Index()
	if err != nil {
		return nil, ipld.ErrInvalidSegmentForList{TypeName: "ipldgit.Tag_List", TroubleSegment: seg, Reason: err}
	}
	return n.LookupByIndex(i)
}
func (Tag_List) MapIterator() ipld.MapIterator {
	return nil
}
func (n Tag_List) ListIterator() ipld.ListIterator {
	return &_Tag_List__ListItr{n, 0}
}

type _Tag_List__ListItr struct {
	n   Tag_List
	idx int
}

func (itr *_Tag_List__ListItr) Next() (idx int64, v ipld.Node, _ error) {
	if itr.idx >= len(itr.n.x) {
		return -1, nil, ipld.ErrIteratorOverread{}
	}
	idx = int64(itr.idx)
	x := &itr.n.x[itr.idx]
	v = x
	itr.idx++
	return
}
func (itr *_Tag_List__ListItr) Done() bool {
	return itr.idx >= len(itr.n.x)
}

func (n Tag_List) Length() int64 {
	return int64(len(n.x))
}
func (Tag_List) IsAbsent() bool {
	return false
}
func (Tag_List) IsNull() bool {
	return false
}
func (Tag_List) AsBool() (bool, error) {
	return mixins.List{TypeName: "ipldgit.Tag_List"}.AsBool()
}
func (Tag_List) AsInt() (int64, error) {
	return mixins.List{TypeName: "ipldgit.Tag_List"}.AsInt()
}
func (Tag_List) AsFloat() (float64, error) {
	return mixins.List{TypeName: "ipldgit.Tag_List"}.AsFloat()
}
func (Tag_List) AsString() (string, error) {
	return mixins.List{TypeName: "ipldgit.Tag_List"}.AsString()
}
func (Tag_List) AsBytes() ([]byte, error) {
	return mixins.List{TypeName: "ipldgit.Tag_List"}.AsBytes()
}
func (Tag_List) AsLink() (ipld.Link, error) {
	return mixins.List{TypeName: "ipldgit.Tag_List"}.AsLink()
}
func (Tag_List) Prototype() ipld.NodePrototype {
	return _Tag_List__Prototype{}
}

type _Tag_List__Prototype struct{}

func (_Tag_List__Prototype) NewBuilder() ipld.NodeBuilder {
	var nb _Tag_List__Builder
	nb.Reset()
	return &nb
}

type _Tag_List__Builder struct {
	_Tag_List__Assembler
}

func (nb *_Tag_List__Builder) Build() ipld.Node {
	if *nb.m != schema.Maybe_Value {
		panic("invalid state: cannot call Build on an assembler that's not finished")
	}
	return nb.w
}
func (nb *_Tag_List__Builder) Reset() {
	var w _Tag_List
	var m schema.Maybe
	*nb = _Tag_List__Builder{_Tag_List__Assembler{w: &w, m: &m}}
}

type _Tag_List__Assembler struct {
	w     *_Tag_List
	m     *schema.Maybe
	state laState

	cm schema.Maybe
	va _Tag__Assembler
}

func (na *_Tag_List__Assembler) reset() {
	na.state = laState_initial
	na.va.reset()
}
func (_Tag_List__Assembler) BeginMap(sizeHint int64) (ipld.MapAssembler, error) {
	return mixins.ListAssembler{TypeName: "ipldgit.Tag_List"}.BeginMap(0)
}
func (na *_Tag_List__Assembler) BeginList(sizeHint int64) (ipld.ListAssembler, error) {
	switch *na.m {
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: it makes no sense to 'begin' twice on the same assembler!")
	}
	*na.m = midvalue
	if sizeHint < 0 {
		sizeHint = 0
	}
	if sizeHint > 0 {
		na.w.x = make([]_Tag, 0, sizeHint)
	}
	return na, nil
}
func (na *_Tag_List__Assembler) AssignNull() error {
	switch *na.m {
	case allowNull:
		*na.m = schema.Maybe_Null
		return nil
	case schema.Maybe_Absent:
		return mixins.ListAssembler{TypeName: "ipldgit.Tag_List"}.AssignNull()
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
	}
	panic("unreachable")
}
func (_Tag_List__Assembler) AssignBool(bool) error {
	return mixins.ListAssembler{TypeName: "ipldgit.Tag_List"}.AssignBool(false)
}
func (_Tag_List__Assembler) AssignInt(int64) error {
	return mixins.ListAssembler{TypeName: "ipldgit.Tag_List"}.AssignInt(0)
}
func (_Tag_List__Assembler) AssignFloat(float64) error {
	return mixins.ListAssembler{TypeName: "ipldgit.Tag_List"}.AssignFloat(0)
}
func (_Tag_List__Assembler) AssignString(string) error {
	return mixins.ListAssembler{TypeName: "ipldgit.Tag_List"}.AssignString("")
}
func (_Tag_List__Assembler) AssignBytes([]byte) error {
	return mixins.ListAssembler{TypeName: "ipldgit.Tag_List"}.AssignBytes(nil)
}
func (_Tag_List__Assembler) AssignLink(ipld.Link) error {
	return mixins.ListAssembler{TypeName: "ipldgit.Tag_List"}.AssignLink(nil)
}
func (na *_Tag_List__Assembler) AssignNode(v ipld.Node) error {
	if v.IsNull() {
		return na.AssignNull()
	}
	if v2, ok := v.(*_Tag_List); ok {
		switch *na.m {
		case schema.Maybe_Value, schema.Maybe_Null:
			panic("invalid state: cannot assign into assembler that's already finished")
		case midvalue:
			panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
		}
		*na.w = *v2
		*na.m = schema.Maybe_Value
		return nil
	}
	if v.Kind() != ipld.Kind_List {
		return ipld.ErrWrongKind{TypeName: "ipldgit.Tag_List", MethodName: "AssignNode", AppropriateKind: ipld.KindSet_JustList, ActualKind: v.Kind()}
	}
	itr := v.ListIterator()
	for !itr.Done() {
		_, v, err := itr.Next()
		if err != nil {
			return err
		}
		if err := na.AssembleValue().AssignNode(v); err != nil {
			return err
		}
	}
	return na.Finish()
}
func (_Tag_List__Assembler) Prototype() ipld.NodePrototype {
	return _Tag_List__Prototype{}
}
func (la *_Tag_List__Assembler) valueFinishTidy() bool {
	switch la.cm {
	case schema.Maybe_Value:
		la.va.w = nil
		la.cm = schema.Maybe_Absent
		la.state = laState_initial
		la.va.reset()
		return true
	default:
		return false
	}
}
func (la *_Tag_List__Assembler) AssembleValue() ipld.NodeAssembler {
	switch la.state {
	case laState_initial:
		// carry on
	case laState_midValue:
		if !la.valueFinishTidy() {
			panic("invalid state: AssembleValue cannot be called when still in the middle of assembling the previous value")
		} // if tidy success: carry on
	case laState_finished:
		panic("invalid state: AssembleValue cannot be called on an assembler that's already finished")
	}
	la.w.x = append(la.w.x, _Tag{})
	la.state = laState_midValue
	row := &la.w.x[len(la.w.x)-1]
	la.va.w = row
	la.va.m = &la.cm
	return &la.va
}
func (la *_Tag_List__Assembler) Finish() error {
	switch la.state {
	case laState_initial:
		// carry on
	case laState_midValue:
		if !la.valueFinishTidy() {
			panic("invalid state: Finish cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case laState_finished:
		panic("invalid state: Finish cannot be called on an assembler that's already finished")
	}
	la.state = laState_finished
	*la.m = schema.Maybe_Value
	return nil
}
func (la *_Tag_List__Assembler) ValuePrototype(_ int64) ipld.NodePrototype {
	return _Tag__Prototype{}
}
func (Tag_List) Type() schema.Type {
	return nil /*TODO:typelit*/
}
func (n Tag_List) Representation() ipld.Node {
	return (*_Tag_List__Repr)(n)
}

type _Tag_List__Repr _Tag_List

var _ ipld.Node = &_Tag_List__Repr{}

func (_Tag_List__Repr) Kind() ipld.Kind {
	return ipld.Kind_List
}
func (_Tag_List__Repr) LookupByString(string) (ipld.Node, error) {
	return mixins.List{TypeName: "ipldgit.Tag_List.Repr"}.LookupByString("")
}
func (nr *_Tag_List__Repr) LookupByNode(k ipld.Node) (ipld.Node, error) {
	v, err := (Tag_List)(nr).LookupByNode(k)
	if err != nil || v == ipld.Null {
		return v, err
	}
	return v.(Tag).Representation(), nil
}
func (nr *_Tag_List__Repr) LookupByIndex(idx int64) (ipld.Node, error) {
	v, err := (Tag_List)(nr).LookupByIndex(idx)
	if err != nil || v == ipld.Null {
		return v, err
	}
	return v.(Tag).Representation(), nil
}
func (n _Tag_List__Repr) LookupBySegment(seg ipld.PathSegment) (ipld.Node, error) {
	i, err := seg.Index()
	if err != nil {
		return nil, ipld.ErrInvalidSegmentForList{TypeName: "ipldgit.Tag_List.Repr", TroubleSegment: seg, Reason: err}
	}
	return n.LookupByIndex(i)
}
func (_Tag_List__Repr) MapIterator() ipld.MapIterator {
	return nil
}
func (nr *_Tag_List__Repr) ListIterator() ipld.ListIterator {
	return &_Tag_List__ReprListItr{(Tag_List)(nr), 0}
}

type _Tag_List__ReprListItr _Tag_List__ListItr

func (itr *_Tag_List__ReprListItr) Next() (idx int64, v ipld.Node, err error) {
	idx, v, err = (*_Tag_List__ListItr)(itr).Next()
	if err != nil || v == ipld.Null {
		return
	}
	return idx, v.(Tag).Representation(), nil
}
func (itr *_Tag_List__ReprListItr) Done() bool {
	return (*_Tag_List__ListItr)(itr).Done()
}

func (rn *_Tag_List__Repr) Length() int64 {
	return int64(len(rn.x))
}
func (_Tag_List__Repr) IsAbsent() bool {
	return false
}
func (_Tag_List__Repr) IsNull() bool {
	return false
}
func (_Tag_List__Repr) AsBool() (bool, error) {
	return mixins.List{TypeName: "ipldgit.Tag_List.Repr"}.AsBool()
}
func (_Tag_List__Repr) AsInt() (int64, error) {
	return mixins.List{TypeName: "ipldgit.Tag_List.Repr"}.AsInt()
}
func (_Tag_List__Repr) AsFloat() (float64, error) {
	return mixins.List{TypeName: "ipldgit.Tag_List.Repr"}.AsFloat()
}
func (_Tag_List__Repr) AsString() (string, error) {
	return mixins.List{TypeName: "ipldgit.Tag_List.Repr"}.AsString()
}
func (_Tag_List__Repr) AsBytes() ([]byte, error) {
	return mixins.List{TypeName: "ipldgit.Tag_List.Repr"}.AsBytes()
}
func (_Tag_List__Repr) AsLink() (ipld.Link, error) {
	return mixins.List{TypeName: "ipldgit.Tag_List.Repr"}.AsLink()
}
func (_Tag_List__Repr) Prototype() ipld.NodePrototype {
	return _Tag_List__ReprPrototype{}
}

type _Tag_List__ReprPrototype struct{}

func (_Tag_List__ReprPrototype) NewBuilder() ipld.NodeBuilder {
	var nb _Tag_List__ReprBuilder
	nb.Reset()
	return &nb
}

type _Tag_List__ReprBuilder struct {
	_Tag_List__ReprAssembler
}

func (nb *_Tag_List__ReprBuilder) Build() ipld.Node {
	if *nb.m != schema.Maybe_Value {
		panic("invalid state: cannot call Build on an assembler that's not finished")
	}
	return nb.w
}
func (nb *_Tag_List__ReprBuilder) Reset() {
	var w _Tag_List
	var m schema.Maybe
	*nb = _Tag_List__ReprBuilder{_Tag_List__ReprAssembler{w: &w, m: &m}}
}

type _Tag_List__ReprAssembler struct {
	w     *_Tag_List
	m     *schema.Maybe
	state laState

	cm schema.Maybe
	va _Tag__ReprAssembler
}

func (na *_Tag_List__ReprAssembler) reset() {
	na.state = laState_initial
	na.va.reset()
}
func (_Tag_List__ReprAssembler) BeginMap(sizeHint int64) (ipld.MapAssembler, error) {
	return mixins.ListAssembler{TypeName: "ipldgit.Tag_List.Repr"}.BeginMap(0)
}
func (na *_Tag_List__ReprAssembler) BeginList(sizeHint int64) (ipld.ListAssembler, error) {
	switch *na.m {
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: it makes no sense to 'begin' twice on the same assembler!")
	}
	*na.m = midvalue
	if sizeHint < 0 {
		sizeHint = 0
	}
	if sizeHint > 0 {
		na.w.x = make([]_Tag, 0, sizeHint)
	}
	return na, nil
}
func (na *_Tag_List__ReprAssembler) AssignNull() error {
	switch *na.m {
	case allowNull:
		*na.m = schema.Maybe_Null
		return nil
	case schema.Maybe_Absent:
		return mixins.ListAssembler{TypeName: "ipldgit.Tag_List.Repr.Repr"}.AssignNull()
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
	}
	panic("unreachable")
}
func (_Tag_List__ReprAssembler) AssignBool(bool) error {
	return mixins.ListAssembler{TypeName: "ipldgit.Tag_List.Repr"}.AssignBool(false)
}
func (_Tag_List__ReprAssembler) AssignInt(int64) error {
	return mixins.ListAssembler{TypeName: "ipldgit.Tag_List.Repr"}.AssignInt(0)
}
func (_Tag_List__ReprAssembler) AssignFloat(float64) error {
	return mixins.ListAssembler{TypeName: "ipldgit.Tag_List.Repr"}.AssignFloat(0)
}
func (_Tag_List__ReprAssembler) AssignString(string) error {
	return mixins.ListAssembler{TypeName: "ipldgit.Tag_List.Repr"}.AssignString("")
}
func (_Tag_List__ReprAssembler) AssignBytes([]byte) error {
	return mixins.ListAssembler{TypeName: "ipldgit.Tag_List.Repr"}.AssignBytes(nil)
}
func (_Tag_List__ReprAssembler) AssignLink(ipld.Link) error {
	return mixins.ListAssembler{TypeName: "ipldgit.Tag_List.Repr"}.AssignLink(nil)
}
func (na *_Tag_List__ReprAssembler) AssignNode(v ipld.Node) error {
	if v.IsNull() {
		return na.AssignNull()
	}
	if v2, ok := v.(*_Tag_List); ok {
		switch *na.m {
		case schema.Maybe_Value, schema.Maybe_Null:
			panic("invalid state: cannot assign into assembler that's already finished")
		case midvalue:
			panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
		}
		*na.w = *v2
		*na.m = schema.Maybe_Value
		return nil
	}
	if v.Kind() != ipld.Kind_List {
		return ipld.ErrWrongKind{TypeName: "ipldgit.Tag_List.Repr", MethodName: "AssignNode", AppropriateKind: ipld.KindSet_JustList, ActualKind: v.Kind()}
	}
	itr := v.ListIterator()
	for !itr.Done() {
		_, v, err := itr.Next()
		if err != nil {
			return err
		}
		if err := na.AssembleValue().AssignNode(v); err != nil {
			return err
		}
	}
	return na.Finish()
}
func (_Tag_List__ReprAssembler) Prototype() ipld.NodePrototype {
	return _Tag_List__ReprPrototype{}
}
func (la *_Tag_List__ReprAssembler) valueFinishTidy() bool {
	switch la.cm {
	case schema.Maybe_Value:
		la.va.w = nil
		la.cm = schema.Maybe_Absent
		la.state = laState_initial
		la.va.reset()
		return true
	default:
		return false
	}
}
func (la *_Tag_List__ReprAssembler) AssembleValue() ipld.NodeAssembler {
	switch la.state {
	case laState_initial:
		// carry on
	case laState_midValue:
		if !la.valueFinishTidy() {
			panic("invalid state: AssembleValue cannot be called when still in the middle of assembling the previous value")
		} // if tidy success: carry on
	case laState_finished:
		panic("invalid state: AssembleValue cannot be called on an assembler that's already finished")
	}
	la.w.x = append(la.w.x, _Tag{})
	la.state = laState_midValue
	row := &la.w.x[len(la.w.x)-1]
	la.va.w = row
	la.va.m = &la.cm
	return &la.va
}
func (la *_Tag_List__ReprAssembler) Finish() error {
	switch la.state {
	case laState_initial:
		// carry on
	case laState_midValue:
		if !la.valueFinishTidy() {
			panic("invalid state: Finish cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case laState_finished:
		panic("invalid state: Finish cannot be called on an assembler that's already finished")
	}
	la.state = laState_finished
	*la.m = schema.Maybe_Value
	return nil
}
func (la *_Tag_List__ReprAssembler) ValuePrototype(_ int64) ipld.NodePrototype {
	return _Tag__ReprPrototype{}
}

func (n *_Tree) Lookup(k String) TreeEntry {
	v, exists := n.m[*k]
	if !exists {
		return nil
	}
	return v
}
func (n *_Tree) LookupMaybe(k String) MaybeTreeEntry {
	v, exists := n.m[*k]
	if !exists {
		return &_Tree__valueAbsent
	}
	return &_TreeEntry__Maybe{
		m: schema.Maybe_Value,
		v: v,
	}
}

var _Tree__valueAbsent = _TreeEntry__Maybe{m: schema.Maybe_Absent}

func (n Tree) Iterator() *Tree__Itr {
	return &Tree__Itr{n, 0}
}

type Tree__Itr struct {
	n   Tree
	idx int
}

func (itr *Tree__Itr) Next() (k String, v TreeEntry) {
	if itr.idx >= len(itr.n.t) {
		return nil, nil
	}
	x := &itr.n.t[itr.idx]
	k = &x.k
	v = &x.v
	itr.idx++
	return
}
func (itr *Tree__Itr) Done() bool {
	return itr.idx >= len(itr.n.t)
}

type _Tree__Maybe struct {
	m schema.Maybe
	v _Tree
}
type MaybeTree = *_Tree__Maybe

func (m MaybeTree) IsNull() bool {
	return m.m == schema.Maybe_Null
}
func (m MaybeTree) IsAbsent() bool {
	return m.m == schema.Maybe_Absent
}
func (m MaybeTree) Exists() bool {
	return m.m == schema.Maybe_Value
}
func (m MaybeTree) AsNode() ipld.Node {
	switch m.m {
	case schema.Maybe_Absent:
		return ipld.Absent
	case schema.Maybe_Null:
		return ipld.Null
	case schema.Maybe_Value:
		return &m.v
	default:
		panic("unreachable")
	}
}
func (m MaybeTree) Must() Tree {
	if !m.Exists() {
		panic("unbox of a maybe rejected")
	}
	return &m.v
}

var _ ipld.Node = (Tree)(&_Tree{})
var _ schema.TypedNode = (Tree)(&_Tree{})

func (Tree) Kind() ipld.Kind {
	return ipld.Kind_Map
}
func (n Tree) LookupByString(k string) (ipld.Node, error) {
	var k2 _String
	if err := (_String__Prototype{}).fromString(&k2, k); err != nil {
		return nil, err // TODO wrap in some kind of ErrInvalidKey
	}
	v, exists := n.m[k2]
	if !exists {
		return nil, ipld.ErrNotExists{Segment: ipld.PathSegmentOfString(k)}
	}
	return v, nil
}
func (n Tree) LookupByNode(k ipld.Node) (ipld.Node, error) {
	k2, ok := k.(String)
	if !ok {
		panic("todo invalid key type error")
		// 'ipld.ErrInvalidKey{TypeName:"ipldgit.Tree", Key:&_String{k}}' doesn't quite cut it: need room to explain the type, and it's not guaranteed k can be turned into a string at all
	}
	v, exists := n.m[*k2]
	if !exists {
		return nil, ipld.ErrNotExists{Segment: ipld.PathSegmentOfString(k2.String())}
	}
	return v, nil
}
func (Tree) LookupByIndex(idx int64) (ipld.Node, error) {
	return mixins.Map{TypeName: "ipldgit.Tree"}.LookupByIndex(0)
}
func (n Tree) LookupBySegment(seg ipld.PathSegment) (ipld.Node, error) {
	return n.LookupByString(seg.String())
}
func (n Tree) MapIterator() ipld.MapIterator {
	return &_Tree__MapItr{n, 0}
}

type _Tree__MapItr struct {
	n   Tree
	idx int
}

func (itr *_Tree__MapItr) Next() (k ipld.Node, v ipld.Node, _ error) {
	if itr.idx >= len(itr.n.t) {
		return nil, nil, ipld.ErrIteratorOverread{}
	}
	x := &itr.n.t[itr.idx]
	k = &x.k
	v = &x.v
	itr.idx++
	return
}
func (itr *_Tree__MapItr) Done() bool {
	return itr.idx >= len(itr.n.t)
}

func (Tree) ListIterator() ipld.ListIterator {
	return nil
}
func (n Tree) Length() int64 {
	return int64(len(n.t))
}
func (Tree) IsAbsent() bool {
	return false
}
func (Tree) IsNull() bool {
	return false
}
func (Tree) AsBool() (bool, error) {
	return mixins.Map{TypeName: "ipldgit.Tree"}.AsBool()
}
func (Tree) AsInt() (int64, error) {
	return mixins.Map{TypeName: "ipldgit.Tree"}.AsInt()
}
func (Tree) AsFloat() (float64, error) {
	return mixins.Map{TypeName: "ipldgit.Tree"}.AsFloat()
}
func (Tree) AsString() (string, error) {
	return mixins.Map{TypeName: "ipldgit.Tree"}.AsString()
}
func (Tree) AsBytes() ([]byte, error) {
	return mixins.Map{TypeName: "ipldgit.Tree"}.AsBytes()
}
func (Tree) AsLink() (ipld.Link, error) {
	return mixins.Map{TypeName: "ipldgit.Tree"}.AsLink()
}
func (Tree) Prototype() ipld.NodePrototype {
	return _Tree__Prototype{}
}

type _Tree__Prototype struct{}

func (_Tree__Prototype) NewBuilder() ipld.NodeBuilder {
	var nb _Tree__Builder
	nb.Reset()
	return &nb
}

type _Tree__Builder struct {
	_Tree__Assembler
}

func (nb *_Tree__Builder) Build() ipld.Node {
	if *nb.m != schema.Maybe_Value {
		panic("invalid state: cannot call Build on an assembler that's not finished")
	}
	return nb.w
}
func (nb *_Tree__Builder) Reset() {
	var w _Tree
	var m schema.Maybe
	*nb = _Tree__Builder{_Tree__Assembler{w: &w, m: &m}}
}

type _Tree__Assembler struct {
	w     *_Tree
	m     *schema.Maybe
	state maState

	cm schema.Maybe
	ka _String__Assembler
	va _TreeEntry__Assembler
}

func (na *_Tree__Assembler) reset() {
	na.state = maState_initial
	na.ka.reset()
	na.va.reset()
}
func (na *_Tree__Assembler) BeginMap(sizeHint int64) (ipld.MapAssembler, error) {
	switch *na.m {
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: it makes no sense to 'begin' twice on the same assembler!")
	}
	*na.m = midvalue
	if sizeHint < 0 {
		sizeHint = 0
	}
	na.w.m = make(map[_String]*_TreeEntry, sizeHint)
	na.w.t = make([]_Tree__entry, 0, sizeHint)
	return na, nil
}
func (_Tree__Assembler) BeginList(sizeHint int64) (ipld.ListAssembler, error) {
	return mixins.MapAssembler{TypeName: "ipldgit.Tree"}.BeginList(0)
}
func (na *_Tree__Assembler) AssignNull() error {
	switch *na.m {
	case allowNull:
		*na.m = schema.Maybe_Null
		return nil
	case schema.Maybe_Absent:
		return mixins.MapAssembler{TypeName: "ipldgit.Tree"}.AssignNull()
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
	}
	panic("unreachable")
}
func (_Tree__Assembler) AssignBool(bool) error {
	return mixins.MapAssembler{TypeName: "ipldgit.Tree"}.AssignBool(false)
}
func (_Tree__Assembler) AssignInt(int64) error {
	return mixins.MapAssembler{TypeName: "ipldgit.Tree"}.AssignInt(0)
}
func (_Tree__Assembler) AssignFloat(float64) error {
	return mixins.MapAssembler{TypeName: "ipldgit.Tree"}.AssignFloat(0)
}
func (_Tree__Assembler) AssignString(string) error {
	return mixins.MapAssembler{TypeName: "ipldgit.Tree"}.AssignString("")
}
func (_Tree__Assembler) AssignBytes([]byte) error {
	return mixins.MapAssembler{TypeName: "ipldgit.Tree"}.AssignBytes(nil)
}
func (_Tree__Assembler) AssignLink(ipld.Link) error {
	return mixins.MapAssembler{TypeName: "ipldgit.Tree"}.AssignLink(nil)
}
func (na *_Tree__Assembler) AssignNode(v ipld.Node) error {
	if v.IsNull() {
		return na.AssignNull()
	}
	if v2, ok := v.(*_Tree); ok {
		switch *na.m {
		case schema.Maybe_Value, schema.Maybe_Null:
			panic("invalid state: cannot assign into assembler that's already finished")
		case midvalue:
			panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
		}
		*na.w = *v2
		*na.m = schema.Maybe_Value
		return nil
	}
	if v.Kind() != ipld.Kind_Map {
		return ipld.ErrWrongKind{TypeName: "ipldgit.Tree", MethodName: "AssignNode", AppropriateKind: ipld.KindSet_JustMap, ActualKind: v.Kind()}
	}
	itr := v.MapIterator()
	for !itr.Done() {
		k, v, err := itr.Next()
		if err != nil {
			return err
		}
		if err := na.AssembleKey().AssignNode(k); err != nil {
			return err
		}
		if err := na.AssembleValue().AssignNode(v); err != nil {
			return err
		}
	}
	return na.Finish()
}
func (_Tree__Assembler) Prototype() ipld.NodePrototype {
	return _Tree__Prototype{}
}
func (ma *_Tree__Assembler) keyFinishTidy() bool {
	switch ma.cm {
	case schema.Maybe_Value:
		ma.ka.w = nil
		tz := &ma.w.t[len(ma.w.t)-1]
		ma.cm = schema.Maybe_Absent
		ma.state = maState_expectValue
		ma.w.m[tz.k] = &tz.v
		ma.va.w = &tz.v
		ma.va.m = &ma.cm
		ma.ka.reset()
		return true
	default:
		return false
	}
}
func (ma *_Tree__Assembler) valueFinishTidy() bool {
	switch ma.cm {
	case schema.Maybe_Value:
		ma.va.w = nil
		ma.cm = schema.Maybe_Absent
		ma.state = maState_initial
		ma.va.reset()
		return true
	default:
		return false
	}
}
func (ma *_Tree__Assembler) AssembleEntry(k string) (ipld.NodeAssembler, error) {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: AssembleEntry cannot be called when in the middle of assembling another key")
	case maState_expectValue:
		panic("invalid state: AssembleEntry cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: AssembleEntry cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: AssembleEntry cannot be called on an assembler that's already finished")
	}

	var k2 _String
	if err := (_String__Prototype{}).fromString(&k2, k); err != nil {
		return nil, err // TODO wrap in some kind of ErrInvalidKey
	}
	if _, exists := ma.w.m[k2]; exists {
		return nil, ipld.ErrRepeatedMapKey{Key: &k2}
	}
	ma.w.t = append(ma.w.t, _Tree__entry{k: k2})
	tz := &ma.w.t[len(ma.w.t)-1]
	ma.state = maState_midValue

	ma.w.m[k2] = &tz.v
	ma.va.w = &tz.v
	ma.va.m = &ma.cm
	return &ma.va, nil
}
func (ma *_Tree__Assembler) AssembleKey() ipld.NodeAssembler {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: AssembleKey cannot be called when in the middle of assembling another key")
	case maState_expectValue:
		panic("invalid state: AssembleKey cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: AssembleKey cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: AssembleKey cannot be called on an assembler that's already finished")
	}
	ma.w.t = append(ma.w.t, _Tree__entry{})
	ma.state = maState_midKey
	ma.ka.m = &ma.cm
	ma.ka.w = &ma.w.t[len(ma.w.t)-1].k
	return &ma.ka
}
func (ma *_Tree__Assembler) AssembleValue() ipld.NodeAssembler {
	switch ma.state {
	case maState_initial:
		panic("invalid state: AssembleValue cannot be called when no key is primed")
	case maState_midKey:
		if !ma.keyFinishTidy() {
			panic("invalid state: AssembleValue cannot be called when in the middle of assembling a key")
		} // if tidy success: carry on
	case maState_expectValue:
		// carry on
	case maState_midValue:
		panic("invalid state: AssembleValue cannot be called when in the middle of assembling another value")
	case maState_finished:
		panic("invalid state: AssembleValue cannot be called on an assembler that's already finished")
	}
	ma.state = maState_midValue
	return &ma.va
}
func (ma *_Tree__Assembler) Finish() error {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: Finish cannot be called when in the middle of assembling a key")
	case maState_expectValue:
		panic("invalid state: Finish cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: Finish cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: Finish cannot be called on an assembler that's already finished")
	}
	ma.state = maState_finished
	*ma.m = schema.Maybe_Value
	return nil
}
func (ma *_Tree__Assembler) KeyPrototype() ipld.NodePrototype {
	return _String__Prototype{}
}
func (ma *_Tree__Assembler) ValuePrototype(_ string) ipld.NodePrototype {
	return _TreeEntry__Prototype{}
}
func (Tree) Type() schema.Type {
	return nil /*TODO:typelit*/
}
func (n Tree) Representation() ipld.Node {
	return (*_Tree__Repr)(n)
}

type _Tree__Repr _Tree

var _ ipld.Node = &_Tree__Repr{}

func (_Tree__Repr) Kind() ipld.Kind {
	return ipld.Kind_Map
}
func (nr *_Tree__Repr) LookupByString(k string) (ipld.Node, error) {
	v, err := (Tree)(nr).LookupByString(k)
	if err != nil || v == ipld.Null {
		return v, err
	}
	return v.(TreeEntry).Representation(), nil
}
func (nr *_Tree__Repr) LookupByNode(k ipld.Node) (ipld.Node, error) {
	v, err := (Tree)(nr).LookupByNode(k)
	if err != nil || v == ipld.Null {
		return v, err
	}
	return v.(TreeEntry).Representation(), nil
}
func (_Tree__Repr) LookupByIndex(idx int64) (ipld.Node, error) {
	return mixins.Map{TypeName: "ipldgit.Tree.Repr"}.LookupByIndex(0)
}
func (n _Tree__Repr) LookupBySegment(seg ipld.PathSegment) (ipld.Node, error) {
	return n.LookupByString(seg.String())
}
func (nr *_Tree__Repr) MapIterator() ipld.MapIterator {
	return &_Tree__ReprMapItr{(Tree)(nr), 0}
}

type _Tree__ReprMapItr _Tree__MapItr

func (itr *_Tree__ReprMapItr) Next() (k ipld.Node, v ipld.Node, err error) {
	k, v, err = (*_Tree__MapItr)(itr).Next()
	if err != nil || v == ipld.Null {
		return
	}
	return k, v.(TreeEntry).Representation(), nil
}
func (itr *_Tree__ReprMapItr) Done() bool {
	return (*_Tree__MapItr)(itr).Done()
}

func (_Tree__Repr) ListIterator() ipld.ListIterator {
	return nil
}
func (rn *_Tree__Repr) Length() int64 {
	return int64(len(rn.t))
}
func (_Tree__Repr) IsAbsent() bool {
	return false
}
func (_Tree__Repr) IsNull() bool {
	return false
}
func (_Tree__Repr) AsBool() (bool, error) {
	return mixins.Map{TypeName: "ipldgit.Tree.Repr"}.AsBool()
}
func (_Tree__Repr) AsInt() (int64, error) {
	return mixins.Map{TypeName: "ipldgit.Tree.Repr"}.AsInt()
}
func (_Tree__Repr) AsFloat() (float64, error) {
	return mixins.Map{TypeName: "ipldgit.Tree.Repr"}.AsFloat()
}
func (_Tree__Repr) AsString() (string, error) {
	return mixins.Map{TypeName: "ipldgit.Tree.Repr"}.AsString()
}
func (_Tree__Repr) AsBytes() ([]byte, error) {
	return mixins.Map{TypeName: "ipldgit.Tree.Repr"}.AsBytes()
}
func (_Tree__Repr) AsLink() (ipld.Link, error) {
	return mixins.Map{TypeName: "ipldgit.Tree.Repr"}.AsLink()
}
func (_Tree__Repr) Prototype() ipld.NodePrototype {
	return _Tree__ReprPrototype{}
}

type _Tree__ReprPrototype struct{}

func (_Tree__ReprPrototype) NewBuilder() ipld.NodeBuilder {
	var nb _Tree__ReprBuilder
	nb.Reset()
	return &nb
}

type _Tree__ReprBuilder struct {
	_Tree__ReprAssembler
}

func (nb *_Tree__ReprBuilder) Build() ipld.Node {
	if *nb.m != schema.Maybe_Value {
		panic("invalid state: cannot call Build on an assembler that's not finished")
	}
	return nb.w
}
func (nb *_Tree__ReprBuilder) Reset() {
	var w _Tree
	var m schema.Maybe
	*nb = _Tree__ReprBuilder{_Tree__ReprAssembler{w: &w, m: &m}}
}

type _Tree__ReprAssembler struct {
	w     *_Tree
	m     *schema.Maybe
	state maState

	cm schema.Maybe
	ka _String__ReprAssembler
	va _TreeEntry__ReprAssembler
}

func (na *_Tree__ReprAssembler) reset() {
	na.state = maState_initial
	na.ka.reset()
	na.va.reset()
}
func (na *_Tree__ReprAssembler) BeginMap(sizeHint int64) (ipld.MapAssembler, error) {
	switch *na.m {
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: it makes no sense to 'begin' twice on the same assembler!")
	}
	*na.m = midvalue
	if sizeHint < 0 {
		sizeHint = 0
	}
	na.w.m = make(map[_String]*_TreeEntry, sizeHint)
	na.w.t = make([]_Tree__entry, 0, sizeHint)
	return na, nil
}
func (_Tree__ReprAssembler) BeginList(sizeHint int64) (ipld.ListAssembler, error) {
	return mixins.MapAssembler{TypeName: "ipldgit.Tree.Repr"}.BeginList(0)
}
func (na *_Tree__ReprAssembler) AssignNull() error {
	switch *na.m {
	case allowNull:
		*na.m = schema.Maybe_Null
		return nil
	case schema.Maybe_Absent:
		return mixins.MapAssembler{TypeName: "ipldgit.Tree.Repr.Repr"}.AssignNull()
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
	}
	panic("unreachable")
}
func (_Tree__ReprAssembler) AssignBool(bool) error {
	return mixins.MapAssembler{TypeName: "ipldgit.Tree.Repr"}.AssignBool(false)
}
func (_Tree__ReprAssembler) AssignInt(int64) error {
	return mixins.MapAssembler{TypeName: "ipldgit.Tree.Repr"}.AssignInt(0)
}
func (_Tree__ReprAssembler) AssignFloat(float64) error {
	return mixins.MapAssembler{TypeName: "ipldgit.Tree.Repr"}.AssignFloat(0)
}
func (_Tree__ReprAssembler) AssignString(string) error {
	return mixins.MapAssembler{TypeName: "ipldgit.Tree.Repr"}.AssignString("")
}
func (_Tree__ReprAssembler) AssignBytes([]byte) error {
	return mixins.MapAssembler{TypeName: "ipldgit.Tree.Repr"}.AssignBytes(nil)
}
func (_Tree__ReprAssembler) AssignLink(ipld.Link) error {
	return mixins.MapAssembler{TypeName: "ipldgit.Tree.Repr"}.AssignLink(nil)
}
func (na *_Tree__ReprAssembler) AssignNode(v ipld.Node) error {
	if v.IsNull() {
		return na.AssignNull()
	}
	if v2, ok := v.(*_Tree); ok {
		switch *na.m {
		case schema.Maybe_Value, schema.Maybe_Null:
			panic("invalid state: cannot assign into assembler that's already finished")
		case midvalue:
			panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
		}
		*na.w = *v2
		*na.m = schema.Maybe_Value
		return nil
	}
	if v.Kind() != ipld.Kind_Map {
		return ipld.ErrWrongKind{TypeName: "ipldgit.Tree.Repr", MethodName: "AssignNode", AppropriateKind: ipld.KindSet_JustMap, ActualKind: v.Kind()}
	}
	itr := v.MapIterator()
	for !itr.Done() {
		k, v, err := itr.Next()
		if err != nil {
			return err
		}
		if err := na.AssembleKey().AssignNode(k); err != nil {
			return err
		}
		if err := na.AssembleValue().AssignNode(v); err != nil {
			return err
		}
	}
	return na.Finish()
}
func (_Tree__ReprAssembler) Prototype() ipld.NodePrototype {
	return _Tree__ReprPrototype{}
}
func (ma *_Tree__ReprAssembler) keyFinishTidy() bool {
	switch ma.cm {
	case schema.Maybe_Value:
		ma.ka.w = nil
		tz := &ma.w.t[len(ma.w.t)-1]
		ma.cm = schema.Maybe_Absent
		ma.state = maState_expectValue
		ma.w.m[tz.k] = &tz.v
		ma.va.w = &tz.v
		ma.va.m = &ma.cm
		ma.ka.reset()
		return true
	default:
		return false
	}
}
func (ma *_Tree__ReprAssembler) valueFinishTidy() bool {
	switch ma.cm {
	case schema.Maybe_Value:
		ma.va.w = nil
		ma.cm = schema.Maybe_Absent
		ma.state = maState_initial
		ma.va.reset()
		return true
	default:
		return false
	}
}
func (ma *_Tree__ReprAssembler) AssembleEntry(k string) (ipld.NodeAssembler, error) {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: AssembleEntry cannot be called when in the middle of assembling another key")
	case maState_expectValue:
		panic("invalid state: AssembleEntry cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: AssembleEntry cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: AssembleEntry cannot be called on an assembler that's already finished")
	}

	var k2 _String
	if err := (_String__ReprPrototype{}).fromString(&k2, k); err != nil {
		return nil, err // TODO wrap in some kind of ErrInvalidKey
	}
	if _, exists := ma.w.m[k2]; exists {
		return nil, ipld.ErrRepeatedMapKey{Key: &k2}
	}
	ma.w.t = append(ma.w.t, _Tree__entry{k: k2})
	tz := &ma.w.t[len(ma.w.t)-1]
	ma.state = maState_midValue

	ma.w.m[k2] = &tz.v
	ma.va.w = &tz.v
	ma.va.m = &ma.cm
	return &ma.va, nil
}
func (ma *_Tree__ReprAssembler) AssembleKey() ipld.NodeAssembler {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: AssembleKey cannot be called when in the middle of assembling another key")
	case maState_expectValue:
		panic("invalid state: AssembleKey cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: AssembleKey cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: AssembleKey cannot be called on an assembler that's already finished")
	}
	ma.w.t = append(ma.w.t, _Tree__entry{})
	ma.state = maState_midKey
	ma.ka.m = &ma.cm
	ma.ka.w = &ma.w.t[len(ma.w.t)-1].k
	return &ma.ka
}
func (ma *_Tree__ReprAssembler) AssembleValue() ipld.NodeAssembler {
	switch ma.state {
	case maState_initial:
		panic("invalid state: AssembleValue cannot be called when no key is primed")
	case maState_midKey:
		if !ma.keyFinishTidy() {
			panic("invalid state: AssembleValue cannot be called when in the middle of assembling a key")
		} // if tidy success: carry on
	case maState_expectValue:
		// carry on
	case maState_midValue:
		panic("invalid state: AssembleValue cannot be called when in the middle of assembling another value")
	case maState_finished:
		panic("invalid state: AssembleValue cannot be called on an assembler that's already finished")
	}
	ma.state = maState_midValue
	return &ma.va
}
func (ma *_Tree__ReprAssembler) Finish() error {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: Finish cannot be called when in the middle of assembling a key")
	case maState_expectValue:
		panic("invalid state: Finish cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: Finish cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: Finish cannot be called on an assembler that's already finished")
	}
	ma.state = maState_finished
	*ma.m = schema.Maybe_Value
	return nil
}
func (ma *_Tree__ReprAssembler) KeyPrototype() ipld.NodePrototype {
	return _String__ReprPrototype{}
}
func (ma *_Tree__ReprAssembler) ValuePrototype(_ string) ipld.NodePrototype {
	return _TreeEntry__ReprPrototype{}
}

func (n _TreeEntry) FieldMode() String {
	return &n.mode
}
func (n _TreeEntry) FieldHash() Link {
	return &n.hash
}

type _TreeEntry__Maybe struct {
	m schema.Maybe
	v TreeEntry
}
type MaybeTreeEntry = *_TreeEntry__Maybe

func (m MaybeTreeEntry) IsNull() bool {
	return m.m == schema.Maybe_Null
}
func (m MaybeTreeEntry) IsAbsent() bool {
	return m.m == schema.Maybe_Absent
}
func (m MaybeTreeEntry) Exists() bool {
	return m.m == schema.Maybe_Value
}
func (m MaybeTreeEntry) AsNode() ipld.Node {
	switch m.m {
	case schema.Maybe_Absent:
		return ipld.Absent
	case schema.Maybe_Null:
		return ipld.Null
	case schema.Maybe_Value:
		return m.v
	default:
		panic("unreachable")
	}
}
func (m MaybeTreeEntry) Must() TreeEntry {
	if !m.Exists() {
		panic("unbox of a maybe rejected")
	}
	return m.v
}

var (
	fieldName__TreeEntry_Mode = _String{"mode"}
	fieldName__TreeEntry_Hash = _String{"hash"}
)
var _ ipld.Node = (TreeEntry)(&_TreeEntry{})
var _ schema.TypedNode = (TreeEntry)(&_TreeEntry{})

func (TreeEntry) Kind() ipld.Kind {
	return ipld.Kind_Map
}
func (n TreeEntry) LookupByString(key string) (ipld.Node, error) {
	switch key {
	case "mode":
		return &n.mode, nil
	case "hash":
		return &n.hash, nil
	default:
		return nil, schema.ErrNoSuchField{Type: nil /*TODO*/, Field: ipld.PathSegmentOfString(key)}
	}
}
func (n TreeEntry) LookupByNode(key ipld.Node) (ipld.Node, error) {
	ks, err := key.AsString()
	if err != nil {
		return nil, err
	}
	return n.LookupByString(ks)
}
func (TreeEntry) LookupByIndex(idx int64) (ipld.Node, error) {
	return mixins.Map{TypeName: "ipldgit.TreeEntry"}.LookupByIndex(0)
}
func (n TreeEntry) LookupBySegment(seg ipld.PathSegment) (ipld.Node, error) {
	return n.LookupByString(seg.String())
}
func (n TreeEntry) MapIterator() ipld.MapIterator {
	return &_TreeEntry__MapItr{n, 0}
}

type _TreeEntry__MapItr struct {
	n   TreeEntry
	idx int
}

func (itr *_TreeEntry__MapItr) Next() (k ipld.Node, v ipld.Node, _ error) {
	if itr.idx >= 2 {
		return nil, nil, ipld.ErrIteratorOverread{}
	}
	switch itr.idx {
	case 0:
		k = &fieldName__TreeEntry_Mode
		v = &itr.n.mode
	case 1:
		k = &fieldName__TreeEntry_Hash
		v = &itr.n.hash
	default:
		panic("unreachable")
	}
	itr.idx++
	return
}
func (itr *_TreeEntry__MapItr) Done() bool {
	return itr.idx >= 2
}

func (TreeEntry) ListIterator() ipld.ListIterator {
	return nil
}
func (TreeEntry) Length() int64 {
	return 2
}
func (TreeEntry) IsAbsent() bool {
	return false
}
func (TreeEntry) IsNull() bool {
	return false
}
func (TreeEntry) AsBool() (bool, error) {
	return mixins.Map{TypeName: "ipldgit.TreeEntry"}.AsBool()
}
func (TreeEntry) AsInt() (int64, error) {
	return mixins.Map{TypeName: "ipldgit.TreeEntry"}.AsInt()
}
func (TreeEntry) AsFloat() (float64, error) {
	return mixins.Map{TypeName: "ipldgit.TreeEntry"}.AsFloat()
}
func (TreeEntry) AsString() (string, error) {
	return mixins.Map{TypeName: "ipldgit.TreeEntry"}.AsString()
}
func (TreeEntry) AsBytes() ([]byte, error) {
	return mixins.Map{TypeName: "ipldgit.TreeEntry"}.AsBytes()
}
func (TreeEntry) AsLink() (ipld.Link, error) {
	return mixins.Map{TypeName: "ipldgit.TreeEntry"}.AsLink()
}
func (TreeEntry) Prototype() ipld.NodePrototype {
	return _TreeEntry__Prototype{}
}

type _TreeEntry__Prototype struct{}

func (_TreeEntry__Prototype) NewBuilder() ipld.NodeBuilder {
	var nb _TreeEntry__Builder
	nb.Reset()
	return &nb
}

type _TreeEntry__Builder struct {
	_TreeEntry__Assembler
}

func (nb *_TreeEntry__Builder) Build() ipld.Node {
	if *nb.m != schema.Maybe_Value {
		panic("invalid state: cannot call Build on an assembler that's not finished")
	}
	return nb.w
}
func (nb *_TreeEntry__Builder) Reset() {
	var w _TreeEntry
	var m schema.Maybe
	*nb = _TreeEntry__Builder{_TreeEntry__Assembler{w: &w, m: &m}}
}

type _TreeEntry__Assembler struct {
	w     *_TreeEntry
	m     *schema.Maybe
	state maState
	s     int
	f     int

	cm      schema.Maybe
	ca_mode _String__Assembler
	ca_hash _Link__Assembler
}

func (na *_TreeEntry__Assembler) reset() {
	na.state = maState_initial
	na.s = 0
	na.ca_mode.reset()
	na.ca_hash.reset()
}

var (
	fieldBit__TreeEntry_Mode        = 1 << 0
	fieldBit__TreeEntry_Hash        = 1 << 1
	fieldBits__TreeEntry_sufficient = 0 + 1<<0 + 1<<1
)

func (na *_TreeEntry__Assembler) BeginMap(int64) (ipld.MapAssembler, error) {
	switch *na.m {
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: it makes no sense to 'begin' twice on the same assembler!")
	}
	*na.m = midvalue
	if na.w == nil {
		na.w = &_TreeEntry{}
	}
	return na, nil
}
func (_TreeEntry__Assembler) BeginList(sizeHint int64) (ipld.ListAssembler, error) {
	return mixins.MapAssembler{TypeName: "ipldgit.TreeEntry"}.BeginList(0)
}
func (na *_TreeEntry__Assembler) AssignNull() error {
	switch *na.m {
	case allowNull:
		*na.m = schema.Maybe_Null
		return nil
	case schema.Maybe_Absent:
		return mixins.MapAssembler{TypeName: "ipldgit.TreeEntry"}.AssignNull()
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
	}
	panic("unreachable")
}
func (_TreeEntry__Assembler) AssignBool(bool) error {
	return mixins.MapAssembler{TypeName: "ipldgit.TreeEntry"}.AssignBool(false)
}
func (_TreeEntry__Assembler) AssignInt(int64) error {
	return mixins.MapAssembler{TypeName: "ipldgit.TreeEntry"}.AssignInt(0)
}
func (_TreeEntry__Assembler) AssignFloat(float64) error {
	return mixins.MapAssembler{TypeName: "ipldgit.TreeEntry"}.AssignFloat(0)
}
func (_TreeEntry__Assembler) AssignString(string) error {
	return mixins.MapAssembler{TypeName: "ipldgit.TreeEntry"}.AssignString("")
}
func (_TreeEntry__Assembler) AssignBytes([]byte) error {
	return mixins.MapAssembler{TypeName: "ipldgit.TreeEntry"}.AssignBytes(nil)
}
func (_TreeEntry__Assembler) AssignLink(ipld.Link) error {
	return mixins.MapAssembler{TypeName: "ipldgit.TreeEntry"}.AssignLink(nil)
}
func (na *_TreeEntry__Assembler) AssignNode(v ipld.Node) error {
	if v.IsNull() {
		return na.AssignNull()
	}
	if v2, ok := v.(*_TreeEntry); ok {
		switch *na.m {
		case schema.Maybe_Value, schema.Maybe_Null:
			panic("invalid state: cannot assign into assembler that's already finished")
		case midvalue:
			panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
		}
		if na.w == nil {
			na.w = v2
			*na.m = schema.Maybe_Value
			return nil
		}
		*na.w = *v2
		*na.m = schema.Maybe_Value
		return nil
	}
	if v.Kind() != ipld.Kind_Map {
		return ipld.ErrWrongKind{TypeName: "ipldgit.TreeEntry", MethodName: "AssignNode", AppropriateKind: ipld.KindSet_JustMap, ActualKind: v.Kind()}
	}
	itr := v.MapIterator()
	for !itr.Done() {
		k, v, err := itr.Next()
		if err != nil {
			return err
		}
		if err := na.AssembleKey().AssignNode(k); err != nil {
			return err
		}
		if err := na.AssembleValue().AssignNode(v); err != nil {
			return err
		}
	}
	return na.Finish()
}
func (_TreeEntry__Assembler) Prototype() ipld.NodePrototype {
	return _TreeEntry__Prototype{}
}
func (ma *_TreeEntry__Assembler) valueFinishTidy() bool {
	switch ma.f {
	case 0:
		switch ma.cm {
		case schema.Maybe_Value:
			ma.ca_mode.w = nil
			ma.cm = schema.Maybe_Absent
			ma.state = maState_initial
			return true
		default:
			return false
		}
	case 1:
		switch ma.cm {
		case schema.Maybe_Value:
			ma.ca_hash.w = nil
			ma.cm = schema.Maybe_Absent
			ma.state = maState_initial
			return true
		default:
			return false
		}
	default:
		panic("unreachable")
	}
}
func (ma *_TreeEntry__Assembler) AssembleEntry(k string) (ipld.NodeAssembler, error) {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: AssembleEntry cannot be called when in the middle of assembling another key")
	case maState_expectValue:
		panic("invalid state: AssembleEntry cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: AssembleEntry cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: AssembleEntry cannot be called on an assembler that's already finished")
	}
	switch k {
	case "mode":
		if ma.s&fieldBit__TreeEntry_Mode != 0 {
			return nil, ipld.ErrRepeatedMapKey{Key: &fieldName__TreeEntry_Mode}
		}
		ma.s += fieldBit__TreeEntry_Mode
		ma.state = maState_midValue
		ma.f = 0
		ma.ca_mode.w = &ma.w.mode
		ma.ca_mode.m = &ma.cm
		return &ma.ca_mode, nil
	case "hash":
		if ma.s&fieldBit__TreeEntry_Hash != 0 {
			return nil, ipld.ErrRepeatedMapKey{Key: &fieldName__TreeEntry_Hash}
		}
		ma.s += fieldBit__TreeEntry_Hash
		ma.state = maState_midValue
		ma.f = 1
		ma.ca_hash.w = &ma.w.hash
		ma.ca_hash.m = &ma.cm
		return &ma.ca_hash, nil
	}
	return nil, ipld.ErrInvalidKey{TypeName: "ipldgit.TreeEntry", Key: &_String{k}}
}
func (ma *_TreeEntry__Assembler) AssembleKey() ipld.NodeAssembler {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: AssembleKey cannot be called when in the middle of assembling another key")
	case maState_expectValue:
		panic("invalid state: AssembleKey cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: AssembleKey cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: AssembleKey cannot be called on an assembler that's already finished")
	}
	ma.state = maState_midKey
	return (*_TreeEntry__KeyAssembler)(ma)
}
func (ma *_TreeEntry__Assembler) AssembleValue() ipld.NodeAssembler {
	switch ma.state {
	case maState_initial:
		panic("invalid state: AssembleValue cannot be called when no key is primed")
	case maState_midKey:
		panic("invalid state: AssembleValue cannot be called when in the middle of assembling a key")
	case maState_expectValue:
		// carry on
	case maState_midValue:
		panic("invalid state: AssembleValue cannot be called when in the middle of assembling another value")
	case maState_finished:
		panic("invalid state: AssembleValue cannot be called on an assembler that's already finished")
	}
	ma.state = maState_midValue
	switch ma.f {
	case 0:
		ma.ca_mode.w = &ma.w.mode
		ma.ca_mode.m = &ma.cm
		return &ma.ca_mode
	case 1:
		ma.ca_hash.w = &ma.w.hash
		ma.ca_hash.m = &ma.cm
		return &ma.ca_hash
	default:
		panic("unreachable")
	}
}
func (ma *_TreeEntry__Assembler) Finish() error {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: Finish cannot be called when in the middle of assembling a key")
	case maState_expectValue:
		panic("invalid state: Finish cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: Finish cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: Finish cannot be called on an assembler that's already finished")
	}
	if ma.s&fieldBits__TreeEntry_sufficient != fieldBits__TreeEntry_sufficient {
		err := ipld.ErrMissingRequiredField{Missing: make([]string, 0)}
		if ma.s&fieldBit__TreeEntry_Mode == 0 {
			err.Missing = append(err.Missing, "mode")
		}
		if ma.s&fieldBit__TreeEntry_Hash == 0 {
			err.Missing = append(err.Missing, "hash")
		}
		return err
	}
	ma.state = maState_finished
	*ma.m = schema.Maybe_Value
	return nil
}
func (ma *_TreeEntry__Assembler) KeyPrototype() ipld.NodePrototype {
	return _String__Prototype{}
}
func (ma *_TreeEntry__Assembler) ValuePrototype(k string) ipld.NodePrototype {
	panic("todo structbuilder mapassembler valueprototype")
}

type _TreeEntry__KeyAssembler _TreeEntry__Assembler

func (_TreeEntry__KeyAssembler) BeginMap(sizeHint int64) (ipld.MapAssembler, error) {
	return mixins.StringAssembler{TypeName: "ipldgit.TreeEntry.KeyAssembler"}.BeginMap(0)
}
func (_TreeEntry__KeyAssembler) BeginList(sizeHint int64) (ipld.ListAssembler, error) {
	return mixins.StringAssembler{TypeName: "ipldgit.TreeEntry.KeyAssembler"}.BeginList(0)
}
func (na *_TreeEntry__KeyAssembler) AssignNull() error {
	return mixins.StringAssembler{TypeName: "ipldgit.TreeEntry.KeyAssembler"}.AssignNull()
}
func (_TreeEntry__KeyAssembler) AssignBool(bool) error {
	return mixins.StringAssembler{TypeName: "ipldgit.TreeEntry.KeyAssembler"}.AssignBool(false)
}
func (_TreeEntry__KeyAssembler) AssignInt(int64) error {
	return mixins.StringAssembler{TypeName: "ipldgit.TreeEntry.KeyAssembler"}.AssignInt(0)
}
func (_TreeEntry__KeyAssembler) AssignFloat(float64) error {
	return mixins.StringAssembler{TypeName: "ipldgit.TreeEntry.KeyAssembler"}.AssignFloat(0)
}
func (ka *_TreeEntry__KeyAssembler) AssignString(k string) error {
	if ka.state != maState_midKey {
		panic("misuse: KeyAssembler held beyond its valid lifetime")
	}
	switch k {
	case "mode":
		if ka.s&fieldBit__TreeEntry_Mode != 0 {
			return ipld.ErrRepeatedMapKey{Key: &fieldName__TreeEntry_Mode}
		}
		ka.s += fieldBit__TreeEntry_Mode
		ka.state = maState_expectValue
		ka.f = 0
		return nil
	case "hash":
		if ka.s&fieldBit__TreeEntry_Hash != 0 {
			return ipld.ErrRepeatedMapKey{Key: &fieldName__TreeEntry_Hash}
		}
		ka.s += fieldBit__TreeEntry_Hash
		ka.state = maState_expectValue
		ka.f = 1
		return nil
	default:
		return ipld.ErrInvalidKey{TypeName: "ipldgit.TreeEntry", Key: &_String{k}}
	}
}
func (_TreeEntry__KeyAssembler) AssignBytes([]byte) error {
	return mixins.StringAssembler{TypeName: "ipldgit.TreeEntry.KeyAssembler"}.AssignBytes(nil)
}
func (_TreeEntry__KeyAssembler) AssignLink(ipld.Link) error {
	return mixins.StringAssembler{TypeName: "ipldgit.TreeEntry.KeyAssembler"}.AssignLink(nil)
}
func (ka *_TreeEntry__KeyAssembler) AssignNode(v ipld.Node) error {
	if v2, err := v.AsString(); err != nil {
		return err
	} else {
		return ka.AssignString(v2)
	}
}
func (_TreeEntry__KeyAssembler) Prototype() ipld.NodePrototype {
	return _String__Prototype{}
}
func (TreeEntry) Type() schema.Type {
	return nil /*TODO:typelit*/
}
func (n TreeEntry) Representation() ipld.Node {
	return (*_TreeEntry__Repr)(n)
}

type _TreeEntry__Repr _TreeEntry

var (
	fieldName__TreeEntry_Mode_serial = _String{"mode"}
	fieldName__TreeEntry_Hash_serial = _String{"hash"}
)
var _ ipld.Node = &_TreeEntry__Repr{}

func (_TreeEntry__Repr) Kind() ipld.Kind {
	return ipld.Kind_Map
}
func (n *_TreeEntry__Repr) LookupByString(key string) (ipld.Node, error) {
	switch key {
	case "mode":
		return n.mode.Representation(), nil
	case "hash":
		return n.hash.Representation(), nil
	default:
		return nil, schema.ErrNoSuchField{Type: nil /*TODO*/, Field: ipld.PathSegmentOfString(key)}
	}
}
func (n *_TreeEntry__Repr) LookupByNode(key ipld.Node) (ipld.Node, error) {
	ks, err := key.AsString()
	if err != nil {
		return nil, err
	}
	return n.LookupByString(ks)
}
func (_TreeEntry__Repr) LookupByIndex(idx int64) (ipld.Node, error) {
	return mixins.Map{TypeName: "ipldgit.TreeEntry.Repr"}.LookupByIndex(0)
}
func (n _TreeEntry__Repr) LookupBySegment(seg ipld.PathSegment) (ipld.Node, error) {
	return n.LookupByString(seg.String())
}
func (n *_TreeEntry__Repr) MapIterator() ipld.MapIterator {
	return &_TreeEntry__ReprMapItr{n, 0}
}

type _TreeEntry__ReprMapItr struct {
	n   *_TreeEntry__Repr
	idx int
}

func (itr *_TreeEntry__ReprMapItr) Next() (k ipld.Node, v ipld.Node, _ error) {
	if itr.idx >= 2 {
		return nil, nil, ipld.ErrIteratorOverread{}
	}
	switch itr.idx {
	case 0:
		k = &fieldName__TreeEntry_Mode_serial
		v = itr.n.mode.Representation()
	case 1:
		k = &fieldName__TreeEntry_Hash_serial
		v = itr.n.hash.Representation()
	default:
		panic("unreachable")
	}
	itr.idx++
	return
}
func (itr *_TreeEntry__ReprMapItr) Done() bool {
	return itr.idx >= 2
}
func (_TreeEntry__Repr) ListIterator() ipld.ListIterator {
	return nil
}
func (rn *_TreeEntry__Repr) Length() int64 {
	l := 2
	return int64(l)
}
func (_TreeEntry__Repr) IsAbsent() bool {
	return false
}
func (_TreeEntry__Repr) IsNull() bool {
	return false
}
func (_TreeEntry__Repr) AsBool() (bool, error) {
	return mixins.Map{TypeName: "ipldgit.TreeEntry.Repr"}.AsBool()
}
func (_TreeEntry__Repr) AsInt() (int64, error) {
	return mixins.Map{TypeName: "ipldgit.TreeEntry.Repr"}.AsInt()
}
func (_TreeEntry__Repr) AsFloat() (float64, error) {
	return mixins.Map{TypeName: "ipldgit.TreeEntry.Repr"}.AsFloat()
}
func (_TreeEntry__Repr) AsString() (string, error) {
	return mixins.Map{TypeName: "ipldgit.TreeEntry.Repr"}.AsString()
}
func (_TreeEntry__Repr) AsBytes() ([]byte, error) {
	return mixins.Map{TypeName: "ipldgit.TreeEntry.Repr"}.AsBytes()
}
func (_TreeEntry__Repr) AsLink() (ipld.Link, error) {
	return mixins.Map{TypeName: "ipldgit.TreeEntry.Repr"}.AsLink()
}
func (_TreeEntry__Repr) Prototype() ipld.NodePrototype {
	return _TreeEntry__ReprPrototype{}
}

type _TreeEntry__ReprPrototype struct{}

func (_TreeEntry__ReprPrototype) NewBuilder() ipld.NodeBuilder {
	var nb _TreeEntry__ReprBuilder
	nb.Reset()
	return &nb
}

type _TreeEntry__ReprBuilder struct {
	_TreeEntry__ReprAssembler
}

func (nb *_TreeEntry__ReprBuilder) Build() ipld.Node {
	if *nb.m != schema.Maybe_Value {
		panic("invalid state: cannot call Build on an assembler that's not finished")
	}
	return nb.w
}
func (nb *_TreeEntry__ReprBuilder) Reset() {
	var w _TreeEntry
	var m schema.Maybe
	*nb = _TreeEntry__ReprBuilder{_TreeEntry__ReprAssembler{w: &w, m: &m}}
}

type _TreeEntry__ReprAssembler struct {
	w     *_TreeEntry
	m     *schema.Maybe
	state maState
	s     int
	f     int

	cm      schema.Maybe
	ca_mode _String__ReprAssembler
	ca_hash _Link__ReprAssembler
}

func (na *_TreeEntry__ReprAssembler) reset() {
	na.state = maState_initial
	na.s = 0
	na.ca_mode.reset()
	na.ca_hash.reset()
}
func (na *_TreeEntry__ReprAssembler) BeginMap(int64) (ipld.MapAssembler, error) {
	switch *na.m {
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: it makes no sense to 'begin' twice on the same assembler!")
	}
	*na.m = midvalue
	if na.w == nil {
		na.w = &_TreeEntry{}
	}
	return na, nil
}
func (_TreeEntry__ReprAssembler) BeginList(sizeHint int64) (ipld.ListAssembler, error) {
	return mixins.MapAssembler{TypeName: "ipldgit.TreeEntry.Repr"}.BeginList(0)
}
func (na *_TreeEntry__ReprAssembler) AssignNull() error {
	switch *na.m {
	case allowNull:
		*na.m = schema.Maybe_Null
		return nil
	case schema.Maybe_Absent:
		return mixins.MapAssembler{TypeName: "ipldgit.TreeEntry.Repr.Repr"}.AssignNull()
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
	}
	panic("unreachable")
}
func (_TreeEntry__ReprAssembler) AssignBool(bool) error {
	return mixins.MapAssembler{TypeName: "ipldgit.TreeEntry.Repr"}.AssignBool(false)
}
func (_TreeEntry__ReprAssembler) AssignInt(int64) error {
	return mixins.MapAssembler{TypeName: "ipldgit.TreeEntry.Repr"}.AssignInt(0)
}
func (_TreeEntry__ReprAssembler) AssignFloat(float64) error {
	return mixins.MapAssembler{TypeName: "ipldgit.TreeEntry.Repr"}.AssignFloat(0)
}
func (_TreeEntry__ReprAssembler) AssignString(string) error {
	return mixins.MapAssembler{TypeName: "ipldgit.TreeEntry.Repr"}.AssignString("")
}
func (_TreeEntry__ReprAssembler) AssignBytes([]byte) error {
	return mixins.MapAssembler{TypeName: "ipldgit.TreeEntry.Repr"}.AssignBytes(nil)
}
func (_TreeEntry__ReprAssembler) AssignLink(ipld.Link) error {
	return mixins.MapAssembler{TypeName: "ipldgit.TreeEntry.Repr"}.AssignLink(nil)
}
func (na *_TreeEntry__ReprAssembler) AssignNode(v ipld.Node) error {
	if v.IsNull() {
		return na.AssignNull()
	}
	if v2, ok := v.(*_TreeEntry); ok {
		switch *na.m {
		case schema.Maybe_Value, schema.Maybe_Null:
			panic("invalid state: cannot assign into assembler that's already finished")
		case midvalue:
			panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
		}
		if na.w == nil {
			na.w = v2
			*na.m = schema.Maybe_Value
			return nil
		}
		*na.w = *v2
		*na.m = schema.Maybe_Value
		return nil
	}
	if v.Kind() != ipld.Kind_Map {
		return ipld.ErrWrongKind{TypeName: "ipldgit.TreeEntry.Repr", MethodName: "AssignNode", AppropriateKind: ipld.KindSet_JustMap, ActualKind: v.Kind()}
	}
	itr := v.MapIterator()
	for !itr.Done() {
		k, v, err := itr.Next()
		if err != nil {
			return err
		}
		if err := na.AssembleKey().AssignNode(k); err != nil {
			return err
		}
		if err := na.AssembleValue().AssignNode(v); err != nil {
			return err
		}
	}
	return na.Finish()
}
func (_TreeEntry__ReprAssembler) Prototype() ipld.NodePrototype {
	return _TreeEntry__ReprPrototype{}
}
func (ma *_TreeEntry__ReprAssembler) valueFinishTidy() bool {
	switch ma.f {
	case 0:
		switch ma.cm {
		case schema.Maybe_Value:
			ma.cm = schema.Maybe_Absent
			ma.state = maState_initial
			return true
		default:
			return false
		}
	case 1:
		switch ma.cm {
		case schema.Maybe_Value:
			ma.cm = schema.Maybe_Absent
			ma.state = maState_initial
			return true
		default:
			return false
		}
	default:
		panic("unreachable")
	}
}
func (ma *_TreeEntry__ReprAssembler) AssembleEntry(k string) (ipld.NodeAssembler, error) {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: AssembleEntry cannot be called when in the middle of assembling another key")
	case maState_expectValue:
		panic("invalid state: AssembleEntry cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: AssembleEntry cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: AssembleEntry cannot be called on an assembler that's already finished")
	}
	switch k {
	case "mode":
		if ma.s&fieldBit__TreeEntry_Mode != 0 {
			return nil, ipld.ErrRepeatedMapKey{Key: &fieldName__TreeEntry_Mode_serial}
		}
		ma.s += fieldBit__TreeEntry_Mode
		ma.state = maState_midValue
		ma.f = 0
		ma.ca_mode.w = &ma.w.mode
		ma.ca_mode.m = &ma.cm
		return &ma.ca_mode, nil
	case "hash":
		if ma.s&fieldBit__TreeEntry_Hash != 0 {
			return nil, ipld.ErrRepeatedMapKey{Key: &fieldName__TreeEntry_Hash_serial}
		}
		ma.s += fieldBit__TreeEntry_Hash
		ma.state = maState_midValue
		ma.f = 1
		ma.ca_hash.w = &ma.w.hash
		ma.ca_hash.m = &ma.cm
		return &ma.ca_hash, nil
	default:
	}
	return nil, ipld.ErrInvalidKey{TypeName: "ipldgit.TreeEntry.Repr", Key: &_String{k}}
}
func (ma *_TreeEntry__ReprAssembler) AssembleKey() ipld.NodeAssembler {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: AssembleKey cannot be called when in the middle of assembling another key")
	case maState_expectValue:
		panic("invalid state: AssembleKey cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: AssembleKey cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: AssembleKey cannot be called on an assembler that's already finished")
	}
	ma.state = maState_midKey
	return (*_TreeEntry__ReprKeyAssembler)(ma)
}
func (ma *_TreeEntry__ReprAssembler) AssembleValue() ipld.NodeAssembler {
	switch ma.state {
	case maState_initial:
		panic("invalid state: AssembleValue cannot be called when no key is primed")
	case maState_midKey:
		panic("invalid state: AssembleValue cannot be called when in the middle of assembling a key")
	case maState_expectValue:
		// carry on
	case maState_midValue:
		panic("invalid state: AssembleValue cannot be called when in the middle of assembling another value")
	case maState_finished:
		panic("invalid state: AssembleValue cannot be called on an assembler that's already finished")
	}
	ma.state = maState_midValue
	switch ma.f {
	case 0:
		ma.ca_mode.w = &ma.w.mode
		ma.ca_mode.m = &ma.cm
		return &ma.ca_mode
	case 1:
		ma.ca_hash.w = &ma.w.hash
		ma.ca_hash.m = &ma.cm
		return &ma.ca_hash
	default:
		panic("unreachable")
	}
}
func (ma *_TreeEntry__ReprAssembler) Finish() error {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: Finish cannot be called when in the middle of assembling a key")
	case maState_expectValue:
		panic("invalid state: Finish cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: Finish cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: Finish cannot be called on an assembler that's already finished")
	}
	if ma.s&fieldBits__TreeEntry_sufficient != fieldBits__TreeEntry_sufficient {
		err := ipld.ErrMissingRequiredField{Missing: make([]string, 0)}
		if ma.s&fieldBit__TreeEntry_Mode == 0 {
			err.Missing = append(err.Missing, "mode")
		}
		if ma.s&fieldBit__TreeEntry_Hash == 0 {
			err.Missing = append(err.Missing, "hash")
		}
		return err
	}
	ma.state = maState_finished
	*ma.m = schema.Maybe_Value
	return nil
}
func (ma *_TreeEntry__ReprAssembler) KeyPrototype() ipld.NodePrototype {
	return _String__Prototype{}
}
func (ma *_TreeEntry__ReprAssembler) ValuePrototype(k string) ipld.NodePrototype {
	panic("todo structbuilder mapassembler repr valueprototype")
}

type _TreeEntry__ReprKeyAssembler _TreeEntry__ReprAssembler

func (_TreeEntry__ReprKeyAssembler) BeginMap(sizeHint int64) (ipld.MapAssembler, error) {
	return mixins.StringAssembler{TypeName: "ipldgit.TreeEntry.Repr.KeyAssembler"}.BeginMap(0)
}
func (_TreeEntry__ReprKeyAssembler) BeginList(sizeHint int64) (ipld.ListAssembler, error) {
	return mixins.StringAssembler{TypeName: "ipldgit.TreeEntry.Repr.KeyAssembler"}.BeginList(0)
}
func (na *_TreeEntry__ReprKeyAssembler) AssignNull() error {
	return mixins.StringAssembler{TypeName: "ipldgit.TreeEntry.Repr.KeyAssembler"}.AssignNull()
}
func (_TreeEntry__ReprKeyAssembler) AssignBool(bool) error {
	return mixins.StringAssembler{TypeName: "ipldgit.TreeEntry.Repr.KeyAssembler"}.AssignBool(false)
}
func (_TreeEntry__ReprKeyAssembler) AssignInt(int64) error {
	return mixins.StringAssembler{TypeName: "ipldgit.TreeEntry.Repr.KeyAssembler"}.AssignInt(0)
}
func (_TreeEntry__ReprKeyAssembler) AssignFloat(float64) error {
	return mixins.StringAssembler{TypeName: "ipldgit.TreeEntry.Repr.KeyAssembler"}.AssignFloat(0)
}
func (ka *_TreeEntry__ReprKeyAssembler) AssignString(k string) error {
	if ka.state != maState_midKey {
		panic("misuse: KeyAssembler held beyond its valid lifetime")
	}
	switch k {
	case "mode":
		if ka.s&fieldBit__TreeEntry_Mode != 0 {
			return ipld.ErrRepeatedMapKey{Key: &fieldName__TreeEntry_Mode_serial}
		}
		ka.s += fieldBit__TreeEntry_Mode
		ka.state = maState_expectValue
		ka.f = 0
		return nil
	case "hash":
		if ka.s&fieldBit__TreeEntry_Hash != 0 {
			return ipld.ErrRepeatedMapKey{Key: &fieldName__TreeEntry_Hash_serial}
		}
		ka.s += fieldBit__TreeEntry_Hash
		ka.state = maState_expectValue
		ka.f = 1
		return nil
	}
	return ipld.ErrInvalidKey{TypeName: "ipldgit.TreeEntry.Repr", Key: &_String{k}}
}
func (_TreeEntry__ReprKeyAssembler) AssignBytes([]byte) error {
	return mixins.StringAssembler{TypeName: "ipldgit.TreeEntry.Repr.KeyAssembler"}.AssignBytes(nil)
}
func (_TreeEntry__ReprKeyAssembler) AssignLink(ipld.Link) error {
	return mixins.StringAssembler{TypeName: "ipldgit.TreeEntry.Repr.KeyAssembler"}.AssignLink(nil)
}
func (ka *_TreeEntry__ReprKeyAssembler) AssignNode(v ipld.Node) error {
	if v2, err := v.AsString(); err != nil {
		return err
	} else {
		return ka.AssignString(v2)
	}
}
func (_TreeEntry__ReprKeyAssembler) Prototype() ipld.NodePrototype {
	return _String__Prototype{}
}

func (n Tree_Link) Link() ipld.Link {
	return n.x
}
func (_Tree_Link__Prototype) FromLink(v ipld.Link) (Tree_Link, error) {
	n := _Tree_Link{v}
	return &n, nil
}

type _Tree_Link__Maybe struct {
	m schema.Maybe
	v _Tree_Link
}
type MaybeTree_Link = *_Tree_Link__Maybe

func (m MaybeTree_Link) IsNull() bool {
	return m.m == schema.Maybe_Null
}
func (m MaybeTree_Link) IsAbsent() bool {
	return m.m == schema.Maybe_Absent
}
func (m MaybeTree_Link) Exists() bool {
	return m.m == schema.Maybe_Value
}
func (m MaybeTree_Link) AsNode() ipld.Node {
	switch m.m {
	case schema.Maybe_Absent:
		return ipld.Absent
	case schema.Maybe_Null:
		return ipld.Null
	case schema.Maybe_Value:
		return &m.v
	default:
		panic("unreachable")
	}
}
func (m MaybeTree_Link) Must() Tree_Link {
	if !m.Exists() {
		panic("unbox of a maybe rejected")
	}
	return &m.v
}

var _ ipld.Node = (Tree_Link)(&_Tree_Link{})
var _ schema.TypedNode = (Tree_Link)(&_Tree_Link{})

func (Tree_Link) Kind() ipld.Kind {
	return ipld.Kind_Link
}
func (Tree_Link) LookupByString(string) (ipld.Node, error) {
	return mixins.Link{TypeName: "ipldgit.Tree_Link"}.LookupByString("")
}
func (Tree_Link) LookupByNode(ipld.Node) (ipld.Node, error) {
	return mixins.Link{TypeName: "ipldgit.Tree_Link"}.LookupByNode(nil)
}
func (Tree_Link) LookupByIndex(idx int64) (ipld.Node, error) {
	return mixins.Link{TypeName: "ipldgit.Tree_Link"}.LookupByIndex(0)
}
func (Tree_Link) LookupBySegment(seg ipld.PathSegment) (ipld.Node, error) {
	return mixins.Link{TypeName: "ipldgit.Tree_Link"}.LookupBySegment(seg)
}
func (Tree_Link) MapIterator() ipld.MapIterator {
	return nil
}
func (Tree_Link) ListIterator() ipld.ListIterator {
	return nil
}
func (Tree_Link) Length() int64 {
	return -1
}
func (Tree_Link) IsAbsent() bool {
	return false
}
func (Tree_Link) IsNull() bool {
	return false
}
func (Tree_Link) AsBool() (bool, error) {
	return mixins.Link{TypeName: "ipldgit.Tree_Link"}.AsBool()
}
func (Tree_Link) AsInt() (int64, error) {
	return mixins.Link{TypeName: "ipldgit.Tree_Link"}.AsInt()
}
func (Tree_Link) AsFloat() (float64, error) {
	return mixins.Link{TypeName: "ipldgit.Tree_Link"}.AsFloat()
}
func (Tree_Link) AsString() (string, error) {
	return mixins.Link{TypeName: "ipldgit.Tree_Link"}.AsString()
}
func (Tree_Link) AsBytes() ([]byte, error) {
	return mixins.Link{TypeName: "ipldgit.Tree_Link"}.AsBytes()
}
func (n Tree_Link) AsLink() (ipld.Link, error) {
	return n.x, nil
}
func (Tree_Link) Prototype() ipld.NodePrototype {
	return _Tree_Link__Prototype{}
}

type _Tree_Link__Prototype struct{}

func (_Tree_Link__Prototype) NewBuilder() ipld.NodeBuilder {
	var nb _Tree_Link__Builder
	nb.Reset()
	return &nb
}

type _Tree_Link__Builder struct {
	_Tree_Link__Assembler
}

func (nb *_Tree_Link__Builder) Build() ipld.Node {
	if *nb.m != schema.Maybe_Value {
		panic("invalid state: cannot call Build on an assembler that's not finished")
	}
	return nb.w
}
func (nb *_Tree_Link__Builder) Reset() {
	var w _Tree_Link
	var m schema.Maybe
	*nb = _Tree_Link__Builder{_Tree_Link__Assembler{w: &w, m: &m}}
}

type _Tree_Link__Assembler struct {
	w *_Tree_Link
	m *schema.Maybe
}

func (na *_Tree_Link__Assembler) reset() {}
func (_Tree_Link__Assembler) BeginMap(sizeHint int64) (ipld.MapAssembler, error) {
	return mixins.LinkAssembler{TypeName: "ipldgit.Tree_Link"}.BeginMap(0)
}
func (_Tree_Link__Assembler) BeginList(sizeHint int64) (ipld.ListAssembler, error) {
	return mixins.LinkAssembler{TypeName: "ipldgit.Tree_Link"}.BeginList(0)
}
func (na *_Tree_Link__Assembler) AssignNull() error {
	switch *na.m {
	case allowNull:
		*na.m = schema.Maybe_Null
		return nil
	case schema.Maybe_Absent:
		return mixins.LinkAssembler{TypeName: "ipldgit.Tree_Link"}.AssignNull()
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	}
	panic("unreachable")
}
func (_Tree_Link__Assembler) AssignBool(bool) error {
	return mixins.LinkAssembler{TypeName: "ipldgit.Tree_Link"}.AssignBool(false)
}
func (_Tree_Link__Assembler) AssignInt(int64) error {
	return mixins.LinkAssembler{TypeName: "ipldgit.Tree_Link"}.AssignInt(0)
}
func (_Tree_Link__Assembler) AssignFloat(float64) error {
	return mixins.LinkAssembler{TypeName: "ipldgit.Tree_Link"}.AssignFloat(0)
}
func (_Tree_Link__Assembler) AssignString(string) error {
	return mixins.LinkAssembler{TypeName: "ipldgit.Tree_Link"}.AssignString("")
}
func (_Tree_Link__Assembler) AssignBytes([]byte) error {
	return mixins.LinkAssembler{TypeName: "ipldgit.Tree_Link"}.AssignBytes(nil)
}
func (na *_Tree_Link__Assembler) AssignLink(v ipld.Link) error {
	switch *na.m {
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	}
	na.w.x = v
	*na.m = schema.Maybe_Value
	return nil
}
func (na *_Tree_Link__Assembler) AssignNode(v ipld.Node) error {
	if v.IsNull() {
		return na.AssignNull()
	}
	if v2, ok := v.(*_Tree_Link); ok {
		switch *na.m {
		case schema.Maybe_Value, schema.Maybe_Null:
			panic("invalid state: cannot assign into assembler that's already finished")
		}
		*na.w = *v2
		*na.m = schema.Maybe_Value
		return nil
	}
	if v2, err := v.AsLink(); err != nil {
		return err
	} else {
		return na.AssignLink(v2)
	}
}
func (_Tree_Link__Assembler) Prototype() ipld.NodePrototype {
	return _Tree_Link__Prototype{}
}
func (Tree_Link) Type() schema.Type {
	return nil /*TODO:typelit*/
}
func (Tree_Link) LinkTargetNodePrototype() ipld.NodePrototype {
	return Type.Tree__Repr
}
func (n Tree_Link) Representation() ipld.Node {
	return (*_Tree_Link__Repr)(n)
}

type _Tree_Link__Repr = _Tree_Link

var _ ipld.Node = &_Tree_Link__Repr{}

type _Tree_Link__ReprPrototype = _Tree_Link__Prototype
type _Tree_Link__ReprAssembler = _Tree_Link__Assembler
