/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classpath.types;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.classpath.types.InstrumentationTypeRegistry;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.StreamHasher;
import org.gradle.internal.lazy.Lazy;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;

@ServiceScope(value={Scope.Global.class, Scope.UserHome.class})
public class GradleCoreInstrumentationTypeRegistry
implements InstrumentationTypeRegistry {
    private static final String INSTRUMENTED_SUPER_TYPES_FILE = "/instrumented-super-types.properties";
    private static final String UPGRADED_PROPERTIES_FILE = "/upgraded-properties.json";
    private final StreamHasher streamHasher;
    private final Lazy<Map<String, Set<String>>> instrumentedSuperTypes;
    private final Lazy<Optional<HashCode>> instrumentedHashCode;
    private final Lazy<Optional<HashCode>> upgradedPropertiesHashCode;

    public GradleCoreInstrumentationTypeRegistry(StreamHasher streamHasher) {
        this.streamHasher = streamHasher;
        this.instrumentedSuperTypes = Lazy.locking().of(this::loadInstrumentedSuperTypes);
        this.instrumentedHashCode = Lazy.locking().of(this::loadInstrumentedSuperTypesHash);
        this.upgradedPropertiesHashCode = Lazy.locking().of(this::loadUpgradedPropertiesHash);
    }

    @Override
    public Set<String> getSuperTypes(String type) {
        return ((Map)this.instrumentedSuperTypes.get()).getOrDefault(type, Collections.emptySet());
    }

    @Override
    public boolean isEmpty() {
        return ((Map)this.instrumentedSuperTypes.get()).isEmpty();
    }

    public Optional<HashCode> getInstrumentedTypesHash() {
        return (Optional)this.instrumentedHashCode.get();
    }

    public Optional<HashCode> getUpgradedPropertiesHash() {
        return (Optional)this.upgradedPropertiesHashCode.get();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, Set<String>> loadInstrumentedSuperTypes() {
        try (InputStream stream = GradleCoreInstrumentationTypeRegistry.class.getResourceAsStream(INSTRUMENTED_SUPER_TYPES_FILE);){
            if (stream == null) {
                Map<String, Set<String>> map = Collections.emptyMap();
                return map;
            }
            Properties properties = new Properties();
            properties.load(stream);
            ImmutableMap.Builder builder = ImmutableMap.builder();
            properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> builder.put((Object)((String)k), (Object)ImmutableSet.copyOf((Object[])v.toString().split(",")))));
            ImmutableMap immutableMap = builder.build();
            return immutableMap;
        }
        catch (IOException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    private Optional<HashCode> loadInstrumentedSuperTypesHash() {
        return this.loadHashCodeFromResource(INSTRUMENTED_SUPER_TYPES_FILE);
    }

    private Optional<HashCode> loadUpgradedPropertiesHash() {
        return this.loadHashCodeFromResource(UPGRADED_PROPERTIES_FILE);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Optional<HashCode> loadHashCodeFromResource(String resourceFile) {
        try (InputStream stream = GradleCoreInstrumentationTypeRegistry.class.getResourceAsStream(resourceFile);){
            if (stream == null) {
                Optional<HashCode> optional2 = Optional.empty();
                return optional2;
            }
            Optional<HashCode> optional = Optional.of(this.streamHasher.hash(stream));
            return optional;
        }
        catch (IOException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }
}

