"""Generated client library for storage version v2."""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.py import base_api
from googlecloudsdk.generated_clients.apis.storage.v2 import storage_v2_messages as messages


class StorageV2(base_api.BaseApiClient):
  """Generated client library for service storage version v2."""

  MESSAGES_MODULE = messages
  BASE_URL = 'https://storage.googleapis.com/'
  MTLS_BASE_URL = 'https://storage.mtls.googleapis.com/'

  _PACKAGE = 'storage'
  _SCOPES = ['https://www.googleapis.com/auth/cloud-platform', 'https://www.googleapis.com/auth/cloud-platform.read-only', 'https://www.googleapis.com/auth/devstorage.full_control', 'https://www.googleapis.com/auth/devstorage.read_only', 'https://www.googleapis.com/auth/devstorage.read_write']
  _VERSION = 'v2'
  _CLIENT_ID = 'CLIENT_ID'
  _CLIENT_SECRET = 'CLIENT_SECRET'
  _USER_AGENT = 'google-cloud-sdk'
  _CLIENT_CLASS_NAME = 'StorageV2'
  _URL_VERSION = 'v2'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None, response_encoding=None):
    """Create a new storage handle."""
    url = url or self.BASE_URL
    super(StorageV2, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers,
        response_encoding=response_encoding)
    self.folders_locations = self.FoldersLocationsService(self)
    self.folders = self.FoldersService(self)
    self.organizations_locations = self.OrganizationsLocationsService(self)
    self.organizations = self.OrganizationsService(self)
    self.projects_buckets_folders = self.ProjectsBucketsFoldersService(self)
    self.projects_buckets = self.ProjectsBucketsService(self)
    self.projects_locations = self.ProjectsLocationsService(self)
    self.projects = self.ProjectsService(self)

  class FoldersLocationsService(base_api.BaseApiService):
    """Service class for the folders_locations resource."""

    _NAME = 'folders_locations'

    def __init__(self, client):
      super(StorageV2.FoldersLocationsService, self).__init__(client)
      self._upload_configs = {
          }

    def GetManagementHub(self, request, global_params=None):
      r"""Gets the `ManagementHub` resource associated with your folder. **IAM Permissions**: Requires `storage.managementHubs.get` [IAM](https://cloud.google.com/iam/docs/overview#permissions) permission on the folder.

      Args:
        request: (StorageFoldersLocationsGetManagementHubRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ManagementHub) The response message.
      """
      config = self.GetMethodConfig('GetManagementHub')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetManagementHub.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/folders/{foldersId}/locations/{locationsId}/managementHub',
        http_method='GET',
        method_id='storage.folders.locations.getManagementHub',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v2/{+name}',
        request_field='',
        request_type_name='StorageFoldersLocationsGetManagementHubRequest',
        response_type_name='ManagementHub',
        supports_download=False,
    )

    def UpdateManagementHub(self, request, global_params=None):
      r"""Updates the `ManagementHub` resource associated with your folder. **IAM Permissions**: Requires `storage.managementHubs.update` [IAM](https://cloud.google.com/iam/docs/overview#permissions) permission on the folder.

      Args:
        request: (StorageFoldersLocationsUpdateManagementHubRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ManagementHub) The response message.
      """
      config = self.GetMethodConfig('UpdateManagementHub')
      return self._RunMethod(
          config, request, global_params=global_params)

    UpdateManagementHub.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/folders/{foldersId}/locations/{locationsId}/managementHub',
        http_method='PATCH',
        method_id='storage.folders.locations.updateManagementHub',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['requestId', 'updateMask'],
        relative_path='v2/{+name}',
        request_field='managementHub',
        request_type_name='StorageFoldersLocationsUpdateManagementHubRequest',
        response_type_name='ManagementHub',
        supports_download=False,
    )

  class FoldersService(base_api.BaseApiService):
    """Service class for the folders resource."""

    _NAME = 'folders'

    def __init__(self, client):
      super(StorageV2.FoldersService, self).__init__(client)
      self._upload_configs = {
          }

  class OrganizationsLocationsService(base_api.BaseApiService):
    """Service class for the organizations_locations resource."""

    _NAME = 'organizations_locations'

    def __init__(self, client):
      super(StorageV2.OrganizationsLocationsService, self).__init__(client)
      self._upload_configs = {
          }

    def GetManagementHub(self, request, global_params=None):
      r"""Gets the `ManagementHub` resource associated with your organization. **IAM Permissions**: Requires `storage.managementHubs.get` [IAM](https://cloud.google.com/iam/docs/overview#permissions) permission on the folder.

      Args:
        request: (StorageOrganizationsLocationsGetManagementHubRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ManagementHub) The response message.
      """
      config = self.GetMethodConfig('GetManagementHub')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetManagementHub.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/organizations/{organizationsId}/locations/{locationsId}/managementHub',
        http_method='GET',
        method_id='storage.organizations.locations.getManagementHub',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v2/{+name}',
        request_field='',
        request_type_name='StorageOrganizationsLocationsGetManagementHubRequest',
        response_type_name='ManagementHub',
        supports_download=False,
    )

    def UpdateManagementHub(self, request, global_params=None):
      r"""Updates the `ManagementHub` resource associated with your organization. **IAM Permissions** Requires `storage.managementHubs.update` [IAM](https://cloud.google.com/iam/docs/overview#permissions) permission on the organization.

      Args:
        request: (StorageOrganizationsLocationsUpdateManagementHubRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ManagementHub) The response message.
      """
      config = self.GetMethodConfig('UpdateManagementHub')
      return self._RunMethod(
          config, request, global_params=global_params)

    UpdateManagementHub.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/organizations/{organizationsId}/locations/{locationsId}/managementHub',
        http_method='PATCH',
        method_id='storage.organizations.locations.updateManagementHub',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['requestId', 'updateMask'],
        relative_path='v2/{+name}',
        request_field='managementHub',
        request_type_name='StorageOrganizationsLocationsUpdateManagementHubRequest',
        response_type_name='ManagementHub',
        supports_download=False,
    )

  class OrganizationsService(base_api.BaseApiService):
    """Service class for the organizations resource."""

    _NAME = 'organizations'

    def __init__(self, client):
      super(StorageV2.OrganizationsService, self).__init__(client)
      self._upload_configs = {
          }

  class ProjectsBucketsFoldersService(base_api.BaseApiService):
    """Service class for the projects_buckets_folders resource."""

    _NAME = 'projects_buckets_folders'

    def __init__(self, client):
      super(StorageV2.ProjectsBucketsFoldersService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new folder. This operation is only applicable to a hierarchical namespace enabled bucket.

      Args:
        request: (StorageProjectsBucketsFoldersCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Folder) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/buckets/{bucketsId}/folders',
        http_method='POST',
        method_id='storage.projects.buckets.folders.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['folderId', 'recursive', 'requestId'],
        relative_path='v2/{+parent}/folders',
        request_field='folder',
        request_type_name='StorageProjectsBucketsFoldersCreateRequest',
        response_type_name='Folder',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a folder and all of its contents, including sub-folders, managed folders, and objects. This operation is only applicable to a hierarchical namespace enabled bucket.

      Args:
        request: (StorageProjectsBucketsFoldersDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/buckets/{bucketsId}/folders/{foldersId}:delete',
        http_method='DELETE',
        method_id='storage.projects.buckets.folders.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['ifMetagenerationMatch', 'ifMetagenerationNotMatch', 'requestId'],
        relative_path='v2/{+name}:delete',
        request_field='',
        request_type_name='StorageProjectsBucketsFoldersDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns metadata for the specified folder. This operation is only applicable to a hierarchical namespace enabled bucket.

      Args:
        request: (StorageProjectsBucketsFoldersGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Folder) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/buckets/{bucketsId}/folders/{foldersId}',
        http_method='GET',
        method_id='storage.projects.buckets.folders.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['ifMetagenerationMatch', 'ifMetagenerationNotMatch', 'requestId'],
        relative_path='v2/{+name}',
        request_field='',
        request_type_name='StorageProjectsBucketsFoldersGetRequest',
        response_type_name='Folder',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a list of folders. This operation is only applicable to a hierarchical namespace enabled bucket.

      Args:
        request: (StorageProjectsBucketsFoldersListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListFoldersResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/buckets/{bucketsId}/folders',
        http_method='GET',
        method_id='storage.projects.buckets.folders.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['delimiter', 'lexicographicEnd', 'lexicographicStart', 'pageSize', 'pageToken', 'prefix', 'requestId'],
        relative_path='v2/{+parent}/folders',
        request_field='',
        request_type_name='StorageProjectsBucketsFoldersListRequest',
        response_type_name='ListFoldersResponse',
        supports_download=False,
    )

    def Rename(self, request, global_params=None):
      r"""Renames a source folder to a destination folder. This operation is only applicable to a hierarchical namespace enabled bucket. During a rename, the source and destination folders are locked until the long running operation completes.

      Args:
        request: (StorageProjectsBucketsFoldersRenameRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Rename')
      return self._RunMethod(
          config, request, global_params=global_params)

    Rename.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/buckets/{bucketsId}/folders/{foldersId}:rename',
        http_method='POST',
        method_id='storage.projects.buckets.folders.rename',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v2/{+name}:rename',
        request_field='renameFolderRequest',
        request_type_name='StorageProjectsBucketsFoldersRenameRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class ProjectsBucketsService(base_api.BaseApiService):
    """Service class for the projects_buckets resource."""

    _NAME = 'projects_buckets'

    def __init__(self, client):
      super(StorageV2.ProjectsBucketsService, self).__init__(client)
      self._upload_configs = {
          }

    def GetStorageLayout(self, request, global_params=None):
      r"""Returns the storage layout configuration for a given bucket.

      Args:
        request: (StorageProjectsBucketsGetStorageLayoutRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (StorageLayout) The response message.
      """
      config = self.GetMethodConfig('GetStorageLayout')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetStorageLayout.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/buckets/{bucketsId}/storageLayout',
        http_method='GET',
        method_id='storage.projects.buckets.getStorageLayout',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['prefix', 'requestId'],
        relative_path='v2/{+name}',
        request_field='',
        request_type_name='StorageProjectsBucketsGetStorageLayoutRequest',
        response_type_name='StorageLayout',
        supports_download=False,
    )

  class ProjectsLocationsService(base_api.BaseApiService):
    """Service class for the projects_locations resource."""

    _NAME = 'projects_locations'

    def __init__(self, client):
      super(StorageV2.ProjectsLocationsService, self).__init__(client)
      self._upload_configs = {
          }

    def GetManagementHub(self, request, global_params=None):
      r"""Gets the `ManagementHub` resource associated with your project. **IAM Permissions**: Requires `storage.managementHubs.get` [IAM](https://cloud.google.com/iam/docs/overview#permissions) permission on the project.

      Args:
        request: (StorageProjectsLocationsGetManagementHubRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ManagementHub) The response message.
      """
      config = self.GetMethodConfig('GetManagementHub')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetManagementHub.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/locations/{locationsId}/managementHub',
        http_method='GET',
        method_id='storage.projects.locations.getManagementHub',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v2/{+name}',
        request_field='',
        request_type_name='StorageProjectsLocationsGetManagementHubRequest',
        response_type_name='ManagementHub',
        supports_download=False,
    )

    def UpdateManagementHub(self, request, global_params=None):
      r"""Updates the `ManagementHub` resource associated with your project. **IAM Permissions**: Requires `storage.managementHubs.update` [IAM](https://cloud.google.com/iam/docs/overview#permissions) permission on the project.

      Args:
        request: (StorageProjectsLocationsUpdateManagementHubRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ManagementHub) The response message.
      """
      config = self.GetMethodConfig('UpdateManagementHub')
      return self._RunMethod(
          config, request, global_params=global_params)

    UpdateManagementHub.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/locations/{locationsId}/managementHub',
        http_method='PATCH',
        method_id='storage.projects.locations.updateManagementHub',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['requestId', 'updateMask'],
        relative_path='v2/{+name}',
        request_field='managementHub',
        request_type_name='StorageProjectsLocationsUpdateManagementHubRequest',
        response_type_name='ManagementHub',
        supports_download=False,
    )

  class ProjectsService(base_api.BaseApiService):
    """Service class for the projects resource."""

    _NAME = 'projects'

    def __init__(self, client):
      super(StorageV2.ProjectsService, self).__init__(client)
      self._upload_configs = {
          }
