"""Generated message classes for config version v1.

Creates and manages Google Cloud Platform resources and infrastructure.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'config'


class ApplyResults(_messages.Message):
  r"""Outputs and artifacts from applying a deployment.

  Messages:
    OutputsValue: Map of output name to output info.

  Fields:
    artifacts: Location of artifacts (e.g. logs) in Google Cloud Storage.
      Format: `gs://{bucket}/{object}`
    content: Location of a blueprint copy and other manifests in Google Cloud
      Storage. Format: `gs://{bucket}/{object}`
    outputs: Map of output name to output info.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class OutputsValue(_messages.Message):
    r"""Map of output name to output info.

    Messages:
      AdditionalProperty: An additional property for a OutputsValue object.

    Fields:
      additionalProperties: Additional properties of type OutputsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a OutputsValue object.

      Fields:
        key: Name of the additional property.
        value: A TerraformOutput attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('TerraformOutput', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  artifacts = _messages.StringField(1)
  content = _messages.StringField(2)
  outputs = _messages.MessageField('OutputsValue', 3)


class AuditConfig(_messages.Message):
  r"""Specifies the audit configuration for a service. The configuration
  determines which permission types are logged, and what identities, if any,
  are exempted from logging. An AuditConfig must have one or more
  AuditLogConfigs. If there are AuditConfigs for both `allServices` and a
  specific service, the union of the two AuditConfigs is used for that
  service: the log_types specified in each AuditConfig are enabled, and the
  exempted_members in each AuditLogConfig are exempted. Example Policy with
  multiple AuditConfigs: { "audit_configs": [ { "service": "allServices",
  "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [
  "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type":
  "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com",
  "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type":
  "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For
  sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ
  logging. It also exempts `jose@example.com` from DATA_READ logging, and
  `aliya@example.com` from DATA_WRITE logging.

  Fields:
    auditLogConfigs: The configuration for logging of each type of permission.
    service: Specifies a service that will be enabled for audit logging. For
      example, `storage.googleapis.com`, `cloudsql.googleapis.com`.
      `allServices` is a special value that covers all services.
  """

  auditLogConfigs = _messages.MessageField('AuditLogConfig', 1, repeated=True)
  service = _messages.StringField(2)


class AuditLogConfig(_messages.Message):
  r"""Provides the configuration for logging a type of permissions. Example: {
  "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [
  "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables
  'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from
  DATA_READ logging.

  Enums:
    LogTypeValueValuesEnum: The log type that this config enables.

  Fields:
    exemptedMembers: Specifies the identities that do not cause logging for
      this type of permission. Follows the same format of Binding.members.
    logType: The log type that this config enables.
  """

  class LogTypeValueValuesEnum(_messages.Enum):
    r"""The log type that this config enables.

    Values:
      LOG_TYPE_UNSPECIFIED: Default case. Should never be this.
      ADMIN_READ: Admin reads. Example: CloudIAM getIamPolicy
      DATA_WRITE: Data writes. Example: CloudSQL Users create
      DATA_READ: Data reads. Example: CloudSQL Users list
    """
    LOG_TYPE_UNSPECIFIED = 0
    ADMIN_READ = 1
    DATA_WRITE = 2
    DATA_READ = 3

  exemptedMembers = _messages.StringField(1, repeated=True)
  logType = _messages.EnumField('LogTypeValueValuesEnum', 2)


class Binding(_messages.Message):
  r"""Associates `members`, or principals, with a `role`.

  Fields:
    condition: The condition that is associated with this binding. If the
      condition evaluates to `true`, then this binding applies to the current
      request. If the condition evaluates to `false`, then this binding does
      not apply to the current request. However, a different role binding
      might grant the same role to one or more of the principals in this
      binding. To learn which resources support conditions in their IAM
      policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    members: Specifies the principals requesting access for a Google Cloud
      resource. `members` can have the following values: * `allUsers`: A
      special identifier that represents anyone who is on the internet; with
      or without a Google account. * `allAuthenticatedUsers`: A special
      identifier that represents anyone who is authenticated with a Google
      account or a service account. Does not include identities that come from
      external identity providers (IdPs) through identity federation. *
      `user:{emailid}`: An email address that represents a specific Google
      account. For example, `alice@example.com` . *
      `serviceAccount:{emailid}`: An email address that represents a Google
      service account. For example, `my-other-
      app@appspot.gserviceaccount.com`. *
      `serviceAccount:{projectid}.svc.id.goog[{namespace}/{kubernetes-sa}]`:
      An identifier for a [Kubernetes service
      account](https://cloud.google.com/kubernetes-engine/docs/how-
      to/kubernetes-service-accounts). For example, `my-
      project.svc.id.goog[my-namespace/my-kubernetes-sa]`. *
      `group:{emailid}`: An email address that represents a Google group. For
      example, `admins@example.com`. * `domain:{domain}`: The G Suite domain
      (primary) that represents all the users of that domain. For example,
      `google.com` or `example.com`. * `principal://iam.googleapis.com/locatio
      ns/global/workforcePools/{pool_id}/subject/{subject_attribute_value}`: A
      single identity in a workforce identity pool. * `principalSet://iam.goog
      leapis.com/locations/global/workforcePools/{pool_id}/group/{group_id}`:
      All workforce identities in a group. * `principalSet://iam.googleapis.co
      m/locations/global/workforcePools/{pool_id}/attribute.{attribute_name}/{
      attribute_value}`: All workforce identities with a specific attribute
      value. * `principalSet://iam.googleapis.com/locations/global/workforcePo
      ols/{pool_id}/*`: All identities in a workforce identity pool. * `princi
      pal://iam.googleapis.com/projects/{project_number}/locations/global/work
      loadIdentityPools/{pool_id}/subject/{subject_attribute_value}`: A single
      identity in a workload identity pool. * `principalSet://iam.googleapis.c
      om/projects/{project_number}/locations/global/workloadIdentityPools/{poo
      l_id}/group/{group_id}`: A workload identity pool group. * `principalSet
      ://iam.googleapis.com/projects/{project_number}/locations/global/workloa
      dIdentityPools/{pool_id}/attribute.{attribute_name}/{attribute_value}`:
      All identities in a workload identity pool with a certain attribute. * `
      principalSet://iam.googleapis.com/projects/{project_number}/locations/gl
      obal/workloadIdentityPools/{pool_id}/*`: All identities in a workload
      identity pool. * `deleted:user:{emailid}?uid={uniqueid}`: An email
      address (plus unique identifier) representing a user that has been
      recently deleted. For example,
      `alice@example.com?uid=123456789012345678901`. If the user is recovered,
      this value reverts to `user:{emailid}` and the recovered user retains
      the role in the binding. *
      `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address
      (plus unique identifier) representing a service account that has been
      recently deleted. For example, `my-other-
      app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the
      service account is undeleted, this value reverts to
      `serviceAccount:{emailid}` and the undeleted service account retains the
      role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An
      email address (plus unique identifier) representing a Google group that
      has been recently deleted. For example,
      `admins@example.com?uid=123456789012345678901`. If the group is
      recovered, this value reverts to `group:{emailid}` and the recovered
      group retains the role in the binding. * `deleted:principal://iam.google
      apis.com/locations/global/workforcePools/{pool_id}/subject/{subject_attr
      ibute_value}`: Deleted single identity in a workforce identity pool. For
      example, `deleted:principal://iam.googleapis.com/locations/global/workfo
      rcePools/my-pool-id/subject/my-subject-attribute-value`.
    role: Role that is assigned to the list of `members`, or principals. For
      example, `roles/viewer`, `roles/editor`, or `roles/owner`. For an
      overview of the IAM roles and permissions, see the [IAM
      documentation](https://cloud.google.com/iam/docs/roles-overview). For a
      list of the available pre-defined roles, see
      [here](https://cloud.google.com/iam/docs/understanding-roles).
  """

  condition = _messages.MessageField('Expr', 1)
  members = _messages.StringField(2, repeated=True)
  role = _messages.StringField(3)


class CancelOperationRequest(_messages.Message):
  r"""The request message for Operations.CancelOperation."""


class ConfigProjectsLocationsDeploymentsCreateRequest(_messages.Message):
  r"""A ConfigProjectsLocationsDeploymentsCreateRequest object.

  Fields:
    deployment: A Deployment resource to be passed as the request body.
    deploymentId: Required. The Deployment ID.
    parent: Required. The parent in whose context the Deployment is created.
      The parent value is in the format:
      'projects/{project_id}/locations/{location}'.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  deployment = _messages.MessageField('Deployment', 1)
  deploymentId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ConfigProjectsLocationsDeploymentsDeleteRequest(_messages.Message):
  r"""A ConfigProjectsLocationsDeploymentsDeleteRequest object.

  Enums:
    DeletePolicyValueValuesEnum: Optional. Policy on how resources actuated by
      the deployment should be deleted. If unspecified, the default behavior
      is to delete the underlying resources.

  Fields:
    deletePolicy: Optional. Policy on how resources actuated by the deployment
      should be deleted. If unspecified, the default behavior is to delete the
      underlying resources.
    force: Optional. If set to true, any revisions for this deployment will
      also be deleted. (Otherwise, the request will only work if the
      deployment has no revisions.)
    name: Required. The name of the Deployment in the format:
      'projects/{project_id}/locations/{location}/deployments/{deployment}'.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes after the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  class DeletePolicyValueValuesEnum(_messages.Enum):
    r"""Optional. Policy on how resources actuated by the deployment should be
    deleted. If unspecified, the default behavior is to delete the underlying
    resources.

    Values:
      DELETE_POLICY_UNSPECIFIED: Unspecified policy, resources will be
        deleted.
      DELETE: Deletes resources actuated by the deployment.
      ABANDON: Abandons resources and only deletes the deployment and its
        metadata.
    """
    DELETE_POLICY_UNSPECIFIED = 0
    DELETE = 1
    ABANDON = 2

  deletePolicy = _messages.EnumField('DeletePolicyValueValuesEnum', 1)
  force = _messages.BooleanField(2)
  name = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ConfigProjectsLocationsDeploymentsDeleteStateRequest(_messages.Message):
  r"""A ConfigProjectsLocationsDeploymentsDeleteStateRequest object.

  Fields:
    deleteStatefileRequest: A DeleteStatefileRequest resource to be passed as
      the request body.
    name: Required. The name of the deployment in the format:
      'projects/{project_id}/locations/{location}/deployments/{deployment}'.
  """

  deleteStatefileRequest = _messages.MessageField('DeleteStatefileRequest', 1)
  name = _messages.StringField(2, required=True)


class ConfigProjectsLocationsDeploymentsExportLockRequest(_messages.Message):
  r"""A ConfigProjectsLocationsDeploymentsExportLockRequest object.

  Fields:
    name: Required. The name of the deployment in the format:
      'projects/{project_id}/locations/{location}/deployments/{deployment}'.
  """

  name = _messages.StringField(1, required=True)


class ConfigProjectsLocationsDeploymentsExportStateRequest(_messages.Message):
  r"""A ConfigProjectsLocationsDeploymentsExportStateRequest object.

  Fields:
    exportDeploymentStatefileRequest: A ExportDeploymentStatefileRequest
      resource to be passed as the request body.
    parent: Required. The parent in whose context the statefile is listed. The
      parent value is in the format:
      'projects/{project_id}/locations/{location}/deployments/{deployment}'.
  """

  exportDeploymentStatefileRequest = _messages.MessageField('ExportDeploymentStatefileRequest', 1)
  parent = _messages.StringField(2, required=True)


class ConfigProjectsLocationsDeploymentsGetIamPolicyRequest(_messages.Message):
  r"""A ConfigProjectsLocationsDeploymentsGetIamPolicyRequest object.

  Fields:
    options_requestedPolicyVersion: Optional. The maximum policy version that
      will be used to format the policy. Valid values are 0, 1, and 3.
      Requests specifying an invalid value will be rejected. Requests for
      policies with any conditional role bindings must specify version 3.
      Policies with no conditional role bindings may specify any valid value
      or leave the field unset. The policy in the response might use the
      policy version that you specified, or it might use a lower policy
      version. For example, if you specify version 3, but the policy has no
      conditional role bindings, the response uses version 1. To learn which
      resources support conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class ConfigProjectsLocationsDeploymentsGetRequest(_messages.Message):
  r"""A ConfigProjectsLocationsDeploymentsGetRequest object.

  Fields:
    name: Required. The name of the deployment. Format:
      'projects/{project_id}/locations/{location}/deployments/{deployment}'.
  """

  name = _messages.StringField(1, required=True)


class ConfigProjectsLocationsDeploymentsImportStateRequest(_messages.Message):
  r"""A ConfigProjectsLocationsDeploymentsImportStateRequest object.

  Fields:
    importStatefileRequest: A ImportStatefileRequest resource to be passed as
      the request body.
    parent: Required. The parent in whose context the statefile is listed. The
      parent value is in the format:
      'projects/{project_id}/locations/{location}/deployments/{deployment}'.
  """

  importStatefileRequest = _messages.MessageField('ImportStatefileRequest', 1)
  parent = _messages.StringField(2, required=True)


class ConfigProjectsLocationsDeploymentsListRequest(_messages.Message):
  r"""A ConfigProjectsLocationsDeploymentsListRequest object.

  Fields:
    filter: Lists the Deployments that match the filter expression. A filter
      expression filters the resources listed in the response. The expression
      must be of the form '{field} {operator} {value}' where operators: '<',
      '>', '<=', '>=', '!=', '=', ':' are supported (colon ':' represents a
      HAS operator which is roughly synonymous with equality). {field} can
      refer to a proto or JSON field, or a synthetic field. Field names can be
      camelCase or snake_case. Examples: - Filter by name: name =
      "projects/foo/locations/us-central1/deployments/bar - Filter by labels:
      - Resources that have a key called 'foo' labels.foo:* - Resources that
      have a key called 'foo' whose value is 'bar' labels.foo = bar - Filter
      by state: - Deployments in CREATING state. state=CREATING
    orderBy: Field to use to sort the list.
    pageSize: When requesting a page of resources, 'page_size' specifies
      number of resources to return. If unspecified, at most 500 will be
      returned. The maximum value is 1000.
    pageToken: Token returned by previous call to 'ListDeployments' which
      specifies the position in the list from where to continue listing the
      resources.
    parent: Required. The parent in whose context the Deployments are listed.
      The parent value is in the format:
      'projects/{project_id}/locations/{location}'.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class ConfigProjectsLocationsDeploymentsLockRequest(_messages.Message):
  r"""A ConfigProjectsLocationsDeploymentsLockRequest object.

  Fields:
    lockDeploymentRequest: A LockDeploymentRequest resource to be passed as
      the request body.
    name: Required. The name of the deployment in the format:
      'projects/{project_id}/locations/{location}/deployments/{deployment}'.
  """

  lockDeploymentRequest = _messages.MessageField('LockDeploymentRequest', 1)
  name = _messages.StringField(2, required=True)


class ConfigProjectsLocationsDeploymentsPatchRequest(_messages.Message):
  r"""A ConfigProjectsLocationsDeploymentsPatchRequest object.

  Fields:
    deployment: A Deployment resource to be passed as the request body.
    name: Resource name of the deployment. Format:
      `projects/{project}/locations/{location}/deployments/{deployment}`
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    updateMask: Optional. Field mask used to specify the fields to be
      overwritten in the Deployment resource by the update. The fields
      specified in the update_mask are relative to the resource, not the full
      request. A field will be overwritten if it is in the mask. If the user
      does not provide a mask then all fields will be overwritten.
  """

  deployment = _messages.MessageField('Deployment', 1)
  name = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  updateMask = _messages.StringField(4)


class ConfigProjectsLocationsDeploymentsRevisionsExportStateRequest(_messages.Message):
  r"""A ConfigProjectsLocationsDeploymentsRevisionsExportStateRequest object.

  Fields:
    exportRevisionStatefileRequest: A ExportRevisionStatefileRequest resource
      to be passed as the request body.
    parent: Required. The parent in whose context the statefile is listed. The
      parent value is in the format: 'projects/{project_id}/locations/{locatio
      n}/deployments/{deployment}/revisions/{revision}'.
  """

  exportRevisionStatefileRequest = _messages.MessageField('ExportRevisionStatefileRequest', 1)
  parent = _messages.StringField(2, required=True)


class ConfigProjectsLocationsDeploymentsRevisionsGetRequest(_messages.Message):
  r"""A ConfigProjectsLocationsDeploymentsRevisionsGetRequest object.

  Fields:
    name: Required. The name of the Revision in the format: 'projects/{project
      _id}/locations/{location}/deployments/{deployment}/revisions/{revision}'
      .
  """

  name = _messages.StringField(1, required=True)


class ConfigProjectsLocationsDeploymentsRevisionsListRequest(_messages.Message):
  r"""A ConfigProjectsLocationsDeploymentsRevisionsListRequest object.

  Fields:
    filter: Lists the Revisions that match the filter expression. A filter
      expression filters the resources listed in the response. The expression
      must be of the form '{field} {operator} {value}' where operators: '<',
      '>', '<=', '>=', '!=', '=', ':' are supported (colon ':' represents a
      HAS operator which is roughly synonymous with equality). {field} can
      refer to a proto or JSON field, or a synthetic field. Field names can be
      camelCase or snake_case. Examples: - Filter by name: name =
      "projects/foo/locations/us-central1/deployments/dep/revisions/bar -
      Filter by labels: - Resources that have a key called 'foo' labels.foo:*
      - Resources that have a key called 'foo' whose value is 'bar' labels.foo
      = bar - Filter by state: - Revisions in CREATING state. state=CREATING
    orderBy: Field to use to sort the list.
    pageSize: When requesting a page of resources, `page_size` specifies
      number of resources to return. If unspecified, at most 500 will be
      returned. The maximum value is 1000.
    pageToken: Token returned by previous call to 'ListRevisions' which
      specifies the position in the list from where to continue listing the
      resources.
    parent: Required. The parent in whose context the Revisions are listed.
      The parent value is in the format:
      'projects/{project_id}/locations/{location}/deployments/{deployment}'.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class ConfigProjectsLocationsDeploymentsRevisionsResourcesGetRequest(_messages.Message):
  r"""A ConfigProjectsLocationsDeploymentsRevisionsResourcesGetRequest object.

  Fields:
    name: Required. The name of the Resource in the format: 'projects/{project
      _id}/locations/{location}/deployments/{deployment}/revisions/{revision}/
      resource/{resource}'.
  """

  name = _messages.StringField(1, required=True)


class ConfigProjectsLocationsDeploymentsRevisionsResourcesListRequest(_messages.Message):
  r"""A ConfigProjectsLocationsDeploymentsRevisionsResourcesListRequest
  object.

  Fields:
    filter: Lists the Resources that match the filter expression. A filter
      expression filters the resources listed in the response. The expression
      must be of the form '{field} {operator} {value}' where operators: '<',
      '>', '<=', '>=', '!=', '=', ':' are supported (colon ':' represents a
      HAS operator which is roughly synonymous with equality). {field} can
      refer to a proto or JSON field, or a synthetic field. Field names can be
      camelCase or snake_case. Examples: - Filter by name: name =
      "projects/foo/locations/us-
      central1/deployments/dep/revisions/bar/resources/baz
    orderBy: Field to use to sort the list.
    pageSize: When requesting a page of resources, 'page_size' specifies
      number of resources to return. If unspecified, at most 500 will be
      returned. The maximum value is 1000.
    pageToken: Token returned by previous call to 'ListResources' which
      specifies the position in the list from where to continue listing the
      resources.
    parent: Required. The parent in whose context the Resources are listed.
      The parent value is in the format: 'projects/{project_id}/locations/{loc
      ation}/deployments/{deployment}/revisions/{revision}'.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class ConfigProjectsLocationsDeploymentsSetIamPolicyRequest(_messages.Message):
  r"""A ConfigProjectsLocationsDeploymentsSetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class ConfigProjectsLocationsDeploymentsTestIamPermissionsRequest(_messages.Message):
  r"""A ConfigProjectsLocationsDeploymentsTestIamPermissionsRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class ConfigProjectsLocationsDeploymentsUnlockRequest(_messages.Message):
  r"""A ConfigProjectsLocationsDeploymentsUnlockRequest object.

  Fields:
    name: Required. The name of the deployment in the format:
      'projects/{project_id}/locations/{location}/deployments/{deployment}'.
    unlockDeploymentRequest: A UnlockDeploymentRequest resource to be passed
      as the request body.
  """

  name = _messages.StringField(1, required=True)
  unlockDeploymentRequest = _messages.MessageField('UnlockDeploymentRequest', 2)


class ConfigProjectsLocationsGetRequest(_messages.Message):
  r"""A ConfigProjectsLocationsGetRequest object.

  Fields:
    name: Resource name for the location.
  """

  name = _messages.StringField(1, required=True)


class ConfigProjectsLocationsListRequest(_messages.Message):
  r"""A ConfigProjectsLocationsListRequest object.

  Fields:
    filter: A filter to narrow down results to a preferred subset. The
      filtering language accepts strings like `"displayName=tokyo"`, and is
      documented in more detail in [AIP-160](https://google.aip.dev/160).
    name: The resource that owns the locations collection, if applicable.
    pageSize: The maximum number of results to return. If not set, the service
      selects a default.
    pageToken: A page token received from the `next_page_token` field in the
      response. Send that page token to receive the subsequent page.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class ConfigProjectsLocationsOperationsCancelRequest(_messages.Message):
  r"""A ConfigProjectsLocationsOperationsCancelRequest object.

  Fields:
    cancelOperationRequest: A CancelOperationRequest resource to be passed as
      the request body.
    name: The name of the operation resource to be cancelled.
  """

  cancelOperationRequest = _messages.MessageField('CancelOperationRequest', 1)
  name = _messages.StringField(2, required=True)


class ConfigProjectsLocationsOperationsDeleteRequest(_messages.Message):
  r"""A ConfigProjectsLocationsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class ConfigProjectsLocationsOperationsGetRequest(_messages.Message):
  r"""A ConfigProjectsLocationsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class ConfigProjectsLocationsOperationsListRequest(_messages.Message):
  r"""A ConfigProjectsLocationsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class ConfigProjectsLocationsPreviewsCreateRequest(_messages.Message):
  r"""A ConfigProjectsLocationsPreviewsCreateRequest object.

  Fields:
    parent: Required. The parent in whose context the Preview is created. The
      parent value is in the format:
      'projects/{project_id}/locations/{location}'.
    preview: A Preview resource to be passed as the request body.
    previewId: Optional. The preview ID.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  parent = _messages.StringField(1, required=True)
  preview = _messages.MessageField('Preview', 2)
  previewId = _messages.StringField(3)
  requestId = _messages.StringField(4)


class ConfigProjectsLocationsPreviewsDeleteRequest(_messages.Message):
  r"""A ConfigProjectsLocationsPreviewsDeleteRequest object.

  Fields:
    name: Required. The name of the Preview in the format:
      'projects/{project_id}/locations/{location}/previews/{preview}'.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes after the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)


class ConfigProjectsLocationsPreviewsExportRequest(_messages.Message):
  r"""A ConfigProjectsLocationsPreviewsExportRequest object.

  Fields:
    exportPreviewResultRequest: A ExportPreviewResultRequest resource to be
      passed as the request body.
    parent: Required. The preview whose results should be exported. The
      preview value is in the format:
      'projects/{project_id}/locations/{location}/previews/{preview}'.
  """

  exportPreviewResultRequest = _messages.MessageField('ExportPreviewResultRequest', 1)
  parent = _messages.StringField(2, required=True)


class ConfigProjectsLocationsPreviewsGetRequest(_messages.Message):
  r"""A ConfigProjectsLocationsPreviewsGetRequest object.

  Fields:
    name: Required. The name of the preview. Format:
      'projects/{project_id}/locations/{location}/previews/{preview}'.
  """

  name = _messages.StringField(1, required=True)


class ConfigProjectsLocationsPreviewsListRequest(_messages.Message):
  r"""A ConfigProjectsLocationsPreviewsListRequest object.

  Fields:
    filter: Optional. Lists the Deployments that match the filter expression.
      A filter expression filters the resources listed in the response. The
      expression must be of the form '{field} {operator} {value}' where
      operators: '<', '>', '<=', '>=', '!=', '=', ':' are supported (colon ':'
      represents a HAS operator which is roughly synonymous with equality).
      {field} can refer to a proto or JSON field, or a synthetic field. Field
      names can be camelCase or snake_case. Examples: - Filter by name: name =
      "projects/foo/locations/us-central1/deployments/bar - Filter by labels:
      - Resources that have a key called 'foo' labels.foo:* - Resources that
      have a key called 'foo' whose value is 'bar' labels.foo = bar - Filter
      by state: - Deployments in CREATING state. state=CREATING
    orderBy: Optional. Field to use to sort the list.
    pageSize: Optional. When requesting a page of resources, 'page_size'
      specifies number of resources to return. If unspecified, at most 500
      will be returned. The maximum value is 1000.
    pageToken: Optional. Token returned by previous call to 'ListDeployments'
      which specifies the position in the list from where to continue listing
      the resources.
    parent: Required. The parent in whose context the Previews are listed. The
      parent value is in the format:
      'projects/{project_id}/locations/{location}'.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class ConfigProjectsLocationsTerraformVersionsGetRequest(_messages.Message):
  r"""A ConfigProjectsLocationsTerraformVersionsGetRequest object.

  Fields:
    name: Required. The name of the TerraformVersion. Format: 'projects/{proje
      ct_id}/locations/{location}/terraformVersions/{terraform_version}'
  """

  name = _messages.StringField(1, required=True)


class ConfigProjectsLocationsTerraformVersionsListRequest(_messages.Message):
  r"""A ConfigProjectsLocationsTerraformVersionsListRequest object.

  Fields:
    filter: Optional. Lists the TerraformVersions that match the filter
      expression. A filter expression filters the resources listed in the
      response. The expression must be of the form '{field} {operator}
      {value}' where operators: '<', '>', '<=', '>=', '!=', '=', ':' are
      supported (colon ':' represents a HAS operator which is roughly
      synonymous with equality). {field} can refer to a proto or JSON field,
      or a synthetic field. Field names can be camelCase or snake_case.
    orderBy: Optional. Field to use to sort the list.
    pageSize: Optional. When requesting a page of resources, 'page_size'
      specifies number of resources to return. If unspecified, at most 500
      will be returned. The maximum value is 1000.
    pageToken: Optional. Token returned by previous call to
      'ListTerraformVersions' which specifies the position in the list from
      where to continue listing the resources.
    parent: Required. The parent in whose context the TerraformVersions are
      listed. The parent value is in the format:
      'projects/{project_id}/locations/{location}'.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class DeleteStatefileRequest(_messages.Message):
  r"""A request to delete a state file passed to a 'DeleteStatefile' call.

  Fields:
    lockId: Required. Lock ID of the lock file to verify that the user who is
      deleting the state file previously locked the Deployment.
  """

  lockId = _messages.IntegerField(1)


class Deployment(_messages.Message):
  r"""A Deployment is a group of resources and configs managed and provisioned
  by Infra Manager.

  Enums:
    ErrorCodeValueValuesEnum: Output only. Error code describing errors that
      may have occurred.
    LockStateValueValuesEnum: Output only. Current lock state of the
      deployment.
    QuotaValidationValueValuesEnum: Optional. Input to control quota checks
      for resources in terraform configuration files. There are limited
      resources on which quota validation applies.
    StateValueValuesEnum: Output only. Current state of the deployment.

  Messages:
    AnnotationsValue: Optional. Arbitrary key-value metadata storage e.g. to
      help client tools identify deployments during automation. See
      https://google.aip.dev/148#annotations for details on format and size
      limitations.
    LabelsValue: User-defined metadata for the deployment.

  Fields:
    annotations: Optional. Arbitrary key-value metadata storage e.g. to help
      client tools identify deployments during automation. See
      https://google.aip.dev/148#annotations for details on format and size
      limitations.
    artifactsGcsBucket: Optional. User-defined location of Cloud Build logs
      and artifacts in Google Cloud Storage. Format: `gs://{bucket}/{folder}`
      A default bucket will be bootstrapped if the field is not set or empty.
      Default bucket format: `gs://--blueprint-config` Constraints: - The
      bucket needs to be in the same project as the deployment - The path
      cannot be within the path of `gcs_source` - The field cannot be updated,
      including changing its presence
    createTime: Output only. Time when the deployment was created.
    deleteBuild: Output only. Cloud Build instance UUID associated with
      deleting this deployment.
    deleteLogs: Output only. Location of Cloud Build logs in Google Cloud
      Storage, populated when deleting this deployment. Format:
      `gs://{bucket}/{object}`.
    deleteResults: Output only. Location of artifacts from a DeleteDeployment
      operation.
    errorCode: Output only. Error code describing errors that may have
      occurred.
    errorLogs: Output only. Location of Terraform error logs in Google Cloud
      Storage. Format: `gs://{bucket}/{object}`.
    importExistingResources: By default, Infra Manager will return a failure
      when Terraform encounters a 409 code (resource conflict error) during
      actuation. If this flag is set to true, Infra Manager will instead
      attempt to automatically import the resource into the Terraform state
      (for supported resource types) and continue actuation. Not all resource
      types are supported, refer to documentation.
    labels: User-defined metadata for the deployment.
    latestRevision: Output only. Revision name that was most recently applied.
      Format:
      `projects/{project}/locations/{location}/deployments/{deployment}/
      revisions/{revision}`
    lockState: Output only. Current lock state of the deployment.
    name: Resource name of the deployment. Format:
      `projects/{project}/locations/{location}/deployments/{deployment}`
    quotaValidation: Optional. Input to control quota checks for resources in
      terraform configuration files. There are limited resources on which
      quota validation applies.
    serviceAccount: Required. User-specified Service Account (SA) credentials
      to be used when actuating resources. Format:
      `projects/{projectID}/serviceAccounts/{serviceAccount}`
    state: Output only. Current state of the deployment.
    stateDetail: Output only. Additional information regarding the current
      state.
    terraformBlueprint: A blueprint described using Terraform's HashiCorp
      Configuration Language as a root module.
    tfErrors: Output only. Errors encountered when deleting this deployment.
      Errors are truncated to 10 entries, see `delete_results` and
      `error_logs` for full details.
    tfVersion: Output only. The current Terraform version set on the
      deployment. It is in the format of "Major.Minor.Patch", for example,
      "1.3.10".
    tfVersionConstraint: Optional. The user-specified Terraform version
      constraint. Example: "=1.3.10".
    updateTime: Output only. Time when the deployment was last modified.
    workerPool: Optional. The user-specified Cloud Build worker pool resource
      in which the Cloud Build job will execute. Format:
      `projects/{project}/locations/{location}/workerPools/{workerPoolId}`. If
      this field is unspecified, the default Cloud Build worker pool will be
      used.
  """

  class ErrorCodeValueValuesEnum(_messages.Enum):
    r"""Output only. Error code describing errors that may have occurred.

    Values:
      ERROR_CODE_UNSPECIFIED: No error code was specified.
      REVISION_FAILED: The revision failed. See Revision for more details.
      CLOUD_BUILD_PERMISSION_DENIED: Cloud Build failed due to a permission
        issue.
      DELETE_BUILD_API_FAILED: Cloud Build job associated with a deployment
        deletion could not be started.
      DELETE_BUILD_RUN_FAILED: Cloud Build job associated with a deployment
        deletion was started but failed.
      BUCKET_CREATION_PERMISSION_DENIED: Cloud Storage bucket creation failed
        due to a permission issue.
      BUCKET_CREATION_FAILED: Cloud Storage bucket creation failed due to an
        issue unrelated to permissions.
    """
    ERROR_CODE_UNSPECIFIED = 0
    REVISION_FAILED = 1
    CLOUD_BUILD_PERMISSION_DENIED = 2
    DELETE_BUILD_API_FAILED = 3
    DELETE_BUILD_RUN_FAILED = 4
    BUCKET_CREATION_PERMISSION_DENIED = 5
    BUCKET_CREATION_FAILED = 6

  class LockStateValueValuesEnum(_messages.Enum):
    r"""Output only. Current lock state of the deployment.

    Values:
      LOCK_STATE_UNSPECIFIED: The default value. This value is used if the
        lock state is omitted.
      LOCKED: The deployment is locked.
      UNLOCKED: The deployment is unlocked.
      LOCKING: The deployment is being locked.
      UNLOCKING: The deployment is being unlocked.
      LOCK_FAILED: The deployment has failed to lock.
      UNLOCK_FAILED: The deployment has failed to unlock.
    """
    LOCK_STATE_UNSPECIFIED = 0
    LOCKED = 1
    UNLOCKED = 2
    LOCKING = 3
    UNLOCKING = 4
    LOCK_FAILED = 5
    UNLOCK_FAILED = 6

  class QuotaValidationValueValuesEnum(_messages.Enum):
    r"""Optional. Input to control quota checks for resources in terraform
    configuration files. There are limited resources on which quota validation
    applies.

    Values:
      QUOTA_VALIDATION_UNSPECIFIED: The default value. QuotaValidation on
        terraform configuration files will be disabled in this case.
      ENABLED: Enable computing quotas for resources in terraform
        configuration files to get visibility on resources with insufficient
        quotas.
      ENFORCED: Enforce quota checks so deployment fails if there isn't
        sufficient quotas available to deploy resources in terraform
        configuration files.
    """
    QUOTA_VALIDATION_UNSPECIFIED = 0
    ENABLED = 1
    ENFORCED = 2

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. Current state of the deployment.

    Values:
      STATE_UNSPECIFIED: The default value. This value is used if the state is
        omitted.
      CREATING: The deployment is being created.
      ACTIVE: The deployment is healthy.
      UPDATING: The deployment is being updated.
      DELETING: The deployment is being deleted.
      FAILED: The deployment has encountered an unexpected error.
      SUSPENDED: The deployment is no longer being actively reconciled. This
        may be the result of recovering the project after deletion.
      DELETED: The deployment has been deleted.
    """
    STATE_UNSPECIFIED = 0
    CREATING = 1
    ACTIVE = 2
    UPDATING = 3
    DELETING = 4
    FAILED = 5
    SUSPENDED = 6
    DELETED = 7

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AnnotationsValue(_messages.Message):
    r"""Optional. Arbitrary key-value metadata storage e.g. to help client
    tools identify deployments during automation. See
    https://google.aip.dev/148#annotations for details on format and size
    limitations.

    Messages:
      AdditionalProperty: An additional property for a AnnotationsValue
        object.

    Fields:
      additionalProperties: Additional properties of type AnnotationsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AnnotationsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""User-defined metadata for the deployment.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  annotations = _messages.MessageField('AnnotationsValue', 1)
  artifactsGcsBucket = _messages.StringField(2)
  createTime = _messages.StringField(3)
  deleteBuild = _messages.StringField(4)
  deleteLogs = _messages.StringField(5)
  deleteResults = _messages.MessageField('ApplyResults', 6)
  errorCode = _messages.EnumField('ErrorCodeValueValuesEnum', 7)
  errorLogs = _messages.StringField(8)
  importExistingResources = _messages.BooleanField(9)
  labels = _messages.MessageField('LabelsValue', 10)
  latestRevision = _messages.StringField(11)
  lockState = _messages.EnumField('LockStateValueValuesEnum', 12)
  name = _messages.StringField(13)
  quotaValidation = _messages.EnumField('QuotaValidationValueValuesEnum', 14)
  serviceAccount = _messages.StringField(15)
  state = _messages.EnumField('StateValueValuesEnum', 16)
  stateDetail = _messages.StringField(17)
  terraformBlueprint = _messages.MessageField('TerraformBlueprint', 18)
  tfErrors = _messages.MessageField('TerraformError', 19, repeated=True)
  tfVersion = _messages.StringField(20)
  tfVersionConstraint = _messages.StringField(21)
  updateTime = _messages.StringField(22)
  workerPool = _messages.StringField(23)


class DeploymentOperationMetadata(_messages.Message):
  r"""Ephemeral metadata content describing the state of a deployment
  operation.

  Enums:
    StepValueValuesEnum: The current step the deployment operation is running.

  Fields:
    applyResults: Outputs and artifacts from applying a deployment.
    build: Output only. Cloud Build instance UUID associated with this
      operation.
    logs: Output only. Location of Deployment operations logs in
      `gs://{bucket}/{object}` format.
    step: The current step the deployment operation is running.
  """

  class StepValueValuesEnum(_messages.Enum):
    r"""The current step the deployment operation is running.

    Values:
      DEPLOYMENT_STEP_UNSPECIFIED: Unspecified deployment step
      PREPARING_STORAGE_BUCKET: Infra Manager is creating a Google Cloud
        Storage bucket to store artifacts and metadata about the deployment
        and revision
      DOWNLOADING_BLUEPRINT: Downloading the blueprint onto the Google Cloud
        Storage bucket
      RUNNING_TF_INIT: Initializing Terraform using `terraform init`
      RUNNING_TF_PLAN: Running `terraform plan`
      RUNNING_TF_APPLY: Actuating resources using Terraform using `terraform
        apply`
      RUNNING_TF_DESTROY: Destroying resources using Terraform using
        `terraform destroy`
      RUNNING_TF_VALIDATE: Validating the uploaded TF state file when
        unlocking a deployment
      UNLOCKING_DEPLOYMENT: Unlocking a deployment
      SUCCEEDED: Operation was successful
      FAILED: Operation failed
      VALIDATING_REPOSITORY: Validating the provided repository.
      RUNNING_QUOTA_VALIDATION: Running quota validation
    """
    DEPLOYMENT_STEP_UNSPECIFIED = 0
    PREPARING_STORAGE_BUCKET = 1
    DOWNLOADING_BLUEPRINT = 2
    RUNNING_TF_INIT = 3
    RUNNING_TF_PLAN = 4
    RUNNING_TF_APPLY = 5
    RUNNING_TF_DESTROY = 6
    RUNNING_TF_VALIDATE = 7
    UNLOCKING_DEPLOYMENT = 8
    SUCCEEDED = 9
    FAILED = 10
    VALIDATING_REPOSITORY = 11
    RUNNING_QUOTA_VALIDATION = 12

  applyResults = _messages.MessageField('ApplyResults', 1)
  build = _messages.StringField(2)
  logs = _messages.StringField(3)
  step = _messages.EnumField('StepValueValuesEnum', 4)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance: service Foo { rpc
  Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
  """



class ExportDeploymentStatefileRequest(_messages.Message):
  r"""A request to export a state file passed to a 'ExportDeploymentStatefile'
  call.

  Fields:
    draft: Optional. If this flag is set to true, the exported deployment
      state file will be the draft state. This will enable the draft file to
      be validated before copying it over to the working state on unlock.
  """

  draft = _messages.BooleanField(1)


class ExportPreviewResultRequest(_messages.Message):
  r"""A request to export preview results."""


class ExportPreviewResultResponse(_messages.Message):
  r"""A response to `ExportPreviewResult` call. Contains preview results.

  Fields:
    result: Output only. Signed URLs for accessing the plan files.
  """

  result = _messages.MessageField('PreviewResult', 1)


class ExportRevisionStatefileRequest(_messages.Message):
  r"""A request to export a state file passed to a 'ExportRevisionStatefile'
  call.
  """



class Expr(_messages.Message):
  r"""Represents a textual expression in the Common Expression Language (CEL)
  syntax. CEL is a C-like expression language. The syntax and semantics of CEL
  are documented at https://github.com/google/cel-spec. Example (Comparison):
  title: "Summary size limit" description: "Determines if a summary is less
  than 100 chars" expression: "document.summary.size() < 100" Example
  (Equality): title: "Requestor is owner" description: "Determines if
  requestor is the document owner" expression: "document.owner ==
  request.auth.claims.email" Example (Logic): title: "Public documents"
  description: "Determine whether the document should be publicly visible"
  expression: "document.type != 'private' && document.type != 'internal'"
  Example (Data Manipulation): title: "Notification string" description:
  "Create a notification string with a timestamp." expression: "'New message
  received at ' + string(document.create_time)" The exact variables and
  functions that may be referenced within an expression are determined by the
  service that evaluates it. See the service documentation for additional
  information.

  Fields:
    description: Optional. Description of the expression. This is a longer
      text which describes the expression, e.g. when hovered over it in a UI.
    expression: Textual representation of an expression in Common Expression
      Language syntax.
    location: Optional. String indicating the location of the expression for
      error reporting, e.g. a file name and a position in the file.
    title: Optional. Title for the expression, i.e. a short string describing
      its purpose. This can be used e.g. in UIs which allow to enter the
      expression.
  """

  description = _messages.StringField(1)
  expression = _messages.StringField(2)
  location = _messages.StringField(3)
  title = _messages.StringField(4)


class GitSource(_messages.Message):
  r"""A set of files in a Git repository.

  Fields:
    directory: Optional. Subdirectory inside the repository. Example:
      'staging/my-package'
    ref: Optional. Git reference (e.g. branch or tag).
    repo: Optional. Repository URL. Example:
      'https://github.com/kubernetes/examples.git'
  """

  directory = _messages.StringField(1)
  ref = _messages.StringField(2)
  repo = _messages.StringField(3)


class ImportStatefileRequest(_messages.Message):
  r"""A request to import a state file passed to a 'ImportStatefile' call.

  Fields:
    lockId: Required. Lock ID of the lock file to verify that the user who is
      importing the state file previously locked the Deployment.
  """

  lockId = _messages.IntegerField(1)


class ListDeploymentsResponse(_messages.Message):
  r"""A ListDeploymentsResponse object.

  Fields:
    deployments: List of Deployments.
    nextPageToken: Token to be supplied to the next ListDeployments request
      via `page_token` to obtain the next set of results.
    unreachable: Locations that could not be reached.
  """

  deployments = _messages.MessageField('Deployment', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListLocationsResponse(_messages.Message):
  r"""The response message for Locations.ListLocations.

  Fields:
    locations: A list of locations that matches the specified filter in the
      request.
    nextPageToken: The standard List next-page token.
  """

  locations = _messages.MessageField('Location', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListOperationsResponse(_messages.Message):
  r"""The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('Operation', 2, repeated=True)


class ListPreviewsResponse(_messages.Message):
  r"""A response to a `ListPreviews` call. Contains a list of Previews.

  Fields:
    nextPageToken: Token to be supplied to the next ListPreviews request via
      `page_token` to obtain the next set of results.
    previews: List of Previewss.
    unreachable: Locations that could not be reached.
  """

  nextPageToken = _messages.StringField(1)
  previews = _messages.MessageField('Preview', 2, repeated=True)
  unreachable = _messages.StringField(3, repeated=True)


class ListResourcesResponse(_messages.Message):
  r"""A response to a 'ListResources' call. Contains a list of Resources.

  Fields:
    nextPageToken: A token to request the next page of resources from the
      'ListResources' method. The value of an empty string means that there
      are no more resources to return.
    resources: List of Resourcess.
    unreachable: Locations that could not be reached.
  """

  nextPageToken = _messages.StringField(1)
  resources = _messages.MessageField('Resource', 2, repeated=True)
  unreachable = _messages.StringField(3, repeated=True)


class ListRevisionsResponse(_messages.Message):
  r"""A response to a 'ListRevisions' call. Contains a list of Revisions.

  Fields:
    nextPageToken: A token to request the next page of resources from the
      'ListRevisions' method. The value of an empty string means that there
      are no more resources to return.
    revisions: List of Revisions.
    unreachable: Locations that could not be reached.
  """

  nextPageToken = _messages.StringField(1)
  revisions = _messages.MessageField('Revision', 2, repeated=True)
  unreachable = _messages.StringField(3, repeated=True)


class ListTerraformVersionsResponse(_messages.Message):
  r"""The response message for the `ListTerraformVersions` method.

  Fields:
    nextPageToken: Token to be supplied to the next ListTerraformVersions
      request via `page_token` to obtain the next set of results.
    terraformVersions: List of TerraformVersions.
    unreachable: Unreachable resources, if any.
  """

  nextPageToken = _messages.StringField(1)
  terraformVersions = _messages.MessageField('TerraformVersion', 2, repeated=True)
  unreachable = _messages.StringField(3, repeated=True)


class Location(_messages.Message):
  r"""A resource that represents a Google Cloud location.

  Messages:
    LabelsValue: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    MetadataValue: Service-specific metadata. For example the available
      capacity at the given location.

  Fields:
    displayName: The friendly name for this location, typically a nearby city
      name. For example, "Tokyo".
    labels: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    locationId: The canonical id for this location. For example: `"us-east1"`.
    metadata: Service-specific metadata. For example the available capacity at
      the given location.
    name: Resource name for the location, which may vary between
      implementations. For example: `"projects/example-project/locations/us-
      east1"`
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Cross-service attributes for the location. For example
    {"cloud.googleapis.com/region": "us-east1"}

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata. For example the available capacity at the
    given location.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  displayName = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  locationId = _messages.StringField(3)
  metadata = _messages.MessageField('MetadataValue', 4)
  name = _messages.StringField(5)


class LockDeploymentRequest(_messages.Message):
  r"""A request to lock a deployment passed to a 'LockDeployment' call."""


class LockInfo(_messages.Message):
  r"""Details about the lock which locked the deployment.

  Fields:
    createTime: Time that the lock was taken.
    info: Extra information to store with the lock, provided by the caller.
    lockId: Unique ID for the lock to be overridden with generation ID in the
      backend.
    operation: Terraform operation, provided by the caller.
    version: Terraform version
    who: user@hostname when available
  """

  createTime = _messages.StringField(1)
  info = _messages.StringField(2)
  lockId = _messages.IntegerField(3)
  operation = _messages.StringField(4)
  version = _messages.StringField(5)
  who = _messages.StringField(6)


class Operation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal, successful response of the operation. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal, successful response of the operation. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation. It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata. Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal, successful response of the operation. If the original
    method returns no data on success, such as `Delete`, the response is
    `google.protobuf.Empty`. If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource. For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name. For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class OperationMetadata(_messages.Message):
  r"""Represents the metadata of the long-running operation.

  Fields:
    apiVersion: Output only. API version used to start the operation.
    createTime: Output only. Time when the operation was created.
    deploymentMetadata: Output only. Metadata about the deployment operation
      state.
    endTime: Output only. Time when the operation finished running.
    previewMetadata: Output only. Metadata about the preview operation state.
    requestedCancellation: Output only. Identifies whether the user has
      requested cancellation of the operation. Operations that have
      successfully been cancelled have Operation.error value with a
      google.rpc.Status.code of 1, corresponding to `Code.CANCELLED`.
    statusMessage: Output only. Human-readable status of the operation, if
      any.
    target: Output only. Server-defined resource path for the target of the
      operation.
    verb: Output only. Name of the verb executed by the operation.
  """

  apiVersion = _messages.StringField(1)
  createTime = _messages.StringField(2)
  deploymentMetadata = _messages.MessageField('DeploymentOperationMetadata', 3)
  endTime = _messages.StringField(4)
  previewMetadata = _messages.MessageField('PreviewOperationMetadata', 5)
  requestedCancellation = _messages.BooleanField(6)
  statusMessage = _messages.StringField(7)
  target = _messages.StringField(8)
  verb = _messages.StringField(9)


class Policy(_messages.Message):
  r"""An Identity and Access Management (IAM) policy, which specifies access
  controls for Google Cloud resources. A `Policy` is a collection of
  `bindings`. A `binding` binds one or more `members`, or principals, to a
  single `role`. Principals can be user accounts, service accounts, Google
  groups, and domains (such as G Suite). A `role` is a named list of
  permissions; each `role` can be an IAM predefined role or a user-created
  custom role. For some types of Google Cloud resources, a `binding` can also
  specify a `condition`, which is a logical expression that allows access to a
  resource only if the expression evaluates to `true`. A condition can add
  constraints based on attributes of the request, the resource, or both. To
  learn which resources support conditions in their IAM policies, see the [IAM
  documentation](https://cloud.google.com/iam/help/conditions/resource-
  policies). **JSON example:** ``` { "bindings": [ { "role":
  "roles/resourcemanager.organizationAdmin", "members": [
  "user:mike@example.com", "group:admins@example.com", "domain:google.com",
  "serviceAccount:my-project-id@appspot.gserviceaccount.com" ] }, { "role":
  "roles/resourcemanager.organizationViewer", "members": [
  "user:eve@example.com" ], "condition": { "title": "expirable access",
  "description": "Does not grant access after Sep 2020", "expression":
  "request.time < timestamp('2020-10-01T00:00:00.000Z')", } } ], "etag":
  "BwWWja0YfJA=", "version": 3 } ``` **YAML example:** ``` bindings: -
  members: - user:mike@example.com - group:admins@example.com -
  domain:google.com - serviceAccount:my-project-id@appspot.gserviceaccount.com
  role: roles/resourcemanager.organizationAdmin - members: -
  user:eve@example.com role: roles/resourcemanager.organizationViewer
  condition: title: expirable access description: Does not grant access after
  Sep 2020 expression: request.time < timestamp('2020-10-01T00:00:00.000Z')
  etag: BwWWja0YfJA= version: 3 ``` For a description of IAM and its features,
  see the [IAM documentation](https://cloud.google.com/iam/docs/).

  Fields:
    auditConfigs: Specifies cloud audit logging configuration for this policy.
    bindings: Associates a list of `members`, or principals, with a `role`.
      Optionally, may specify a `condition` that determines how and when the
      `bindings` are applied. Each of the `bindings` must contain at least one
      principal. The `bindings` in a `Policy` can refer to up to 1,500
      principals; up to 250 of these principals can be Google groups. Each
      occurrence of a principal counts towards these limits. For example, if
      the `bindings` grant 50 different roles to `user:alice@example.com`, and
      not to any other principal, then you can add another 1,450 principals to
      the `bindings` in the `Policy`.
    etag: `etag` is used for optimistic concurrency control as a way to help
      prevent simultaneous updates of a policy from overwriting each other. It
      is strongly suggested that systems make use of the `etag` in the read-
      modify-write cycle to perform policy updates in order to avoid race
      conditions: An `etag` is returned in the response to `getIamPolicy`, and
      systems are expected to put that etag in the request to `setIamPolicy`
      to ensure that their change will be applied to the same version of the
      policy. **Important:** If you use IAM Conditions, you must include the
      `etag` field whenever you call `setIamPolicy`. If you omit this field,
      then IAM allows you to overwrite a version `3` policy with a version `1`
      policy, and all of the conditions in the version `3` policy are lost.
    version: Specifies the format of the policy. Valid values are `0`, `1`,
      and `3`. Requests that specify an invalid value are rejected. Any
      operation that affects conditional role bindings must specify version
      `3`. This requirement applies to the following operations: * Getting a
      policy that includes a conditional role binding * Adding a conditional
      role binding to a policy * Changing a conditional role binding in a
      policy * Removing any role binding, with or without a condition, from a
      policy that includes conditions **Important:** If you use IAM
      Conditions, you must include the `etag` field whenever you call
      `setIamPolicy`. If you omit this field, then IAM allows you to overwrite
      a version `3` policy with a version `1` policy, and all of the
      conditions in the version `3` policy are lost. If a policy does not
      include any conditions, operations on that policy may specify any valid
      version or leave the field unset. To learn which resources support
      conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
  """

  auditConfigs = _messages.MessageField('AuditConfig', 1, repeated=True)
  bindings = _messages.MessageField('Binding', 2, repeated=True)
  etag = _messages.BytesField(3)
  version = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class Preview(_messages.Message):
  r"""A preview represents a set of actions Infra Manager would perform to
  move the resources towards the desired state as specified in the
  configuration.

  Enums:
    ErrorCodeValueValuesEnum: Output only. Code describing any errors that may
      have occurred.
    PreviewModeValueValuesEnum: Optional. Current mode of preview.
    StateValueValuesEnum: Output only. Current state of the preview.

  Messages:
    AnnotationsValue: Optional. Arbitrary key-value metadata storage e.g. to
      help client tools identifiy preview during automation. See
      https://google.aip.dev/148#annotations for details on format and size
      limitations.
    LabelsValue: Optional. User-defined labels for the preview.

  Fields:
    annotations: Optional. Arbitrary key-value metadata storage e.g. to help
      client tools identifiy preview during automation. See
      https://google.aip.dev/148#annotations for details on format and size
      limitations.
    artifactsGcsBucket: Optional. User-defined location of Cloud Build logs,
      artifacts, and in Google Cloud Storage. Format: `gs://{bucket}/{folder}`
      A default bucket will be bootstrapped if the field is not set or empty
      Default Bucket Format: `gs://--blueprint-config` Constraints: - The
      bucket needs to be in the same project as the deployment - The path
      cannot be within the path of `gcs_source` If omitted and deployment
      resource ref provided has artifacts_gcs_bucket defined, that artifact
      bucket is used.
    build: Output only. Cloud Build instance UUID associated with this
      preview.
    createTime: Output only. Time the preview was created.
    deployment: Optional. Optional deployment reference. If specified, the
      preview will be performed using the provided deployment's current state
      and use any relevant fields from the deployment unless explicitly
      specified in the preview create request.
    errorCode: Output only. Code describing any errors that may have occurred.
    errorLogs: Output only. Link to tf-error.ndjson file, which contains the
      full list of the errors encountered during a Terraform preview. Format:
      `gs://{bucket}/{object}`.
    errorStatus: Output only. Additional information regarding the current
      state.
    labels: Optional. User-defined labels for the preview.
    logs: Output only. Location of preview logs in `gs://{bucket}/{object}`
      format.
    name: Identifier. Resource name of the preview. Resource name can be user
      provided or server generated ID if unspecified. Format:
      `projects/{project}/locations/{location}/previews/{preview}`
    previewArtifacts: Output only. Artifacts from preview.
    previewMode: Optional. Current mode of preview.
    serviceAccount: Required. User-specified Service Account (SA) credentials
      to be used when previewing resources. Format:
      `projects/{projectID}/serviceAccounts/{serviceAccount}`
    state: Output only. Current state of the preview.
    terraformBlueprint: The terraform blueprint to preview.
    tfErrors: Output only. Summary of errors encountered during Terraform
      preview. It has a size limit of 10, i.e. only top 10 errors will be
      summarized here.
    tfVersion: Output only. The current Terraform version set on the preview.
      It is in the format of "Major.Minor.Patch", for example, "1.3.10".
    tfVersionConstraint: Optional. The user-specified Terraform version
      constraint. Example: "=1.3.10".
    workerPool: Optional. The user-specified Worker Pool resource in which the
      Cloud Build job will execute. Format
      projects/{project}/locations/{location}/workerPools/{workerPoolId} If
      this field is unspecified, the default Cloud Build worker pool will be
      used. If omitted and deployment resource ref provided has worker_pool
      defined, that worker pool is used.
  """

  class ErrorCodeValueValuesEnum(_messages.Enum):
    r"""Output only. Code describing any errors that may have occurred.

    Values:
      ERROR_CODE_UNSPECIFIED: No error code was specified.
      CLOUD_BUILD_PERMISSION_DENIED: Cloud Build failed due to a permissions
        issue.
      BUCKET_CREATION_PERMISSION_DENIED: Cloud Storage bucket failed to create
        due to a permissions issue.
      BUCKET_CREATION_FAILED: Cloud Storage bucket failed for a non-
        permissions-related issue.
      DEPLOYMENT_LOCK_ACQUIRE_FAILED: Acquiring lock on provided deployment
        reference failed.
      PREVIEW_BUILD_API_FAILED: Preview encountered an error when trying to
        access Cloud Build API.
      PREVIEW_BUILD_RUN_FAILED: Preview created a build but build failed and
        logs were generated.
    """
    ERROR_CODE_UNSPECIFIED = 0
    CLOUD_BUILD_PERMISSION_DENIED = 1
    BUCKET_CREATION_PERMISSION_DENIED = 2
    BUCKET_CREATION_FAILED = 3
    DEPLOYMENT_LOCK_ACQUIRE_FAILED = 4
    PREVIEW_BUILD_API_FAILED = 5
    PREVIEW_BUILD_RUN_FAILED = 6

  class PreviewModeValueValuesEnum(_messages.Enum):
    r"""Optional. Current mode of preview.

    Values:
      PREVIEW_MODE_UNSPECIFIED: Unspecified policy, default mode will be used.
      DEFAULT: DEFAULT mode generates an execution plan for reconciling
        current resource state into expected resource state.
      DELETE: DELETE mode generates as execution plan for destroying current
        resources.
    """
    PREVIEW_MODE_UNSPECIFIED = 0
    DEFAULT = 1
    DELETE = 2

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. Current state of the preview.

    Values:
      STATE_UNSPECIFIED: The default value. This value is used if the state is
        unknown.
      CREATING: The preview is being created.
      SUCCEEDED: The preview has succeeded.
      APPLYING: The preview is being applied.
      STALE: The preview is stale. A preview can become stale if a revision
        has been applied after this preview was created.
      DELETING: The preview is being deleted.
      FAILED: The preview has encountered an unexpected error.
      DELETED: The preview has been deleted.
    """
    STATE_UNSPECIFIED = 0
    CREATING = 1
    SUCCEEDED = 2
    APPLYING = 3
    STALE = 4
    DELETING = 5
    FAILED = 6
    DELETED = 7

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AnnotationsValue(_messages.Message):
    r"""Optional. Arbitrary key-value metadata storage e.g. to help client
    tools identifiy preview during automation. See
    https://google.aip.dev/148#annotations for details on format and size
    limitations.

    Messages:
      AdditionalProperty: An additional property for a AnnotationsValue
        object.

    Fields:
      additionalProperties: Additional properties of type AnnotationsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AnnotationsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. User-defined labels for the preview.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  annotations = _messages.MessageField('AnnotationsValue', 1)
  artifactsGcsBucket = _messages.StringField(2)
  build = _messages.StringField(3)
  createTime = _messages.StringField(4)
  deployment = _messages.StringField(5)
  errorCode = _messages.EnumField('ErrorCodeValueValuesEnum', 6)
  errorLogs = _messages.StringField(7)
  errorStatus = _messages.MessageField('Status', 8)
  labels = _messages.MessageField('LabelsValue', 9)
  logs = _messages.StringField(10)
  name = _messages.StringField(11)
  previewArtifacts = _messages.MessageField('PreviewArtifacts', 12)
  previewMode = _messages.EnumField('PreviewModeValueValuesEnum', 13)
  serviceAccount = _messages.StringField(14)
  state = _messages.EnumField('StateValueValuesEnum', 15)
  terraformBlueprint = _messages.MessageField('TerraformBlueprint', 16)
  tfErrors = _messages.MessageField('TerraformError', 17, repeated=True)
  tfVersion = _messages.StringField(18)
  tfVersionConstraint = _messages.StringField(19)
  workerPool = _messages.StringField(20)


class PreviewArtifacts(_messages.Message):
  r"""Artifacts created by preview.

  Fields:
    artifacts: Output only. Location of artifacts in Google Cloud Storage.
      Format: `gs://{bucket}/{object}`
    content: Output only. Location of a blueprint copy and other content in
      Google Cloud Storage. Format: `gs://{bucket}/{object}`
  """

  artifacts = _messages.StringField(1)
  content = _messages.StringField(2)


class PreviewOperationMetadata(_messages.Message):
  r"""Ephemeral metadata content describing the state of a preview operation.

  Enums:
    StepValueValuesEnum: The current step the preview operation is running.

  Fields:
    build: Output only. Cloud Build instance UUID associated with this
      preview.
    logs: Output only. Location of preview logs in `gs://{bucket}/{object}`
      format.
    previewArtifacts: Artifacts from preview.
    step: The current step the preview operation is running.
  """

  class StepValueValuesEnum(_messages.Enum):
    r"""The current step the preview operation is running.

    Values:
      PREVIEW_STEP_UNSPECIFIED: Unspecified preview step.
      PREPARING_STORAGE_BUCKET: Infra Manager is creating a Google Cloud
        Storage bucket to store artifacts and metadata about the preview.
      DOWNLOADING_BLUEPRINT: Downloading the blueprint onto the Google Cloud
        Storage bucket.
      RUNNING_TF_INIT: Initializing Terraform using `terraform init`.
      RUNNING_TF_PLAN: Running `terraform plan`.
      FETCHING_DEPLOYMENT: Fetching a deployment.
      LOCKING_DEPLOYMENT: Locking a deployment.
      UNLOCKING_DEPLOYMENT: Unlocking a deployment.
      SUCCEEDED: Operation was successful.
      FAILED: Operation failed.
      VALIDATING_REPOSITORY: Validating the provided repository.
    """
    PREVIEW_STEP_UNSPECIFIED = 0
    PREPARING_STORAGE_BUCKET = 1
    DOWNLOADING_BLUEPRINT = 2
    RUNNING_TF_INIT = 3
    RUNNING_TF_PLAN = 4
    FETCHING_DEPLOYMENT = 5
    LOCKING_DEPLOYMENT = 6
    UNLOCKING_DEPLOYMENT = 7
    SUCCEEDED = 8
    FAILED = 9
    VALIDATING_REPOSITORY = 10

  build = _messages.StringField(1)
  logs = _messages.StringField(2)
  previewArtifacts = _messages.MessageField('PreviewArtifacts', 3)
  step = _messages.EnumField('StepValueValuesEnum', 4)


class PreviewResult(_messages.Message):
  r"""Contains a signed Cloud Storage URLs.

  Fields:
    binarySignedUri: Output only. Plan binary signed URL
    jsonSignedUri: Output only. Plan JSON signed URL
  """

  binarySignedUri = _messages.StringField(1)
  jsonSignedUri = _messages.StringField(2)


class Resource(_messages.Message):
  r"""Resource represents a Google Cloud Platform resource actuated by IM.
  Resources are child resources of Revisions.

  Enums:
    IntentValueValuesEnum: Output only. Intent of the resource.
    StateValueValuesEnum: Output only. Current state of the resource.

  Messages:
    CaiAssetsValue: Output only. Map of Cloud Asset Inventory (CAI) type to
      CAI info (e.g. CAI ID). CAI type format follows
      https://cloud.google.com/asset-inventory/docs/supported-asset-types

  Fields:
    caiAssets: Output only. Map of Cloud Asset Inventory (CAI) type to CAI
      info (e.g. CAI ID). CAI type format follows
      https://cloud.google.com/asset-inventory/docs/supported-asset-types
    intent: Output only. Intent of the resource.
    name: Output only. Resource name. Format: `projects/{project}/locations/{l
      ocation}/deployments/{deployment}/revisions/{revision}/resources/{resour
      ce}`
    state: Output only. Current state of the resource.
    terraformInfo: Output only. Terraform-specific info if this resource was
      created using Terraform.
  """

  class IntentValueValuesEnum(_messages.Enum):
    r"""Output only. Intent of the resource.

    Values:
      INTENT_UNSPECIFIED: The default value. This value is used if the intent
        is omitted.
      CREATE: Infra Manager will create this Resource.
      UPDATE: Infra Manager will update this Resource.
      DELETE: Infra Manager will delete this Resource.
      RECREATE: Infra Manager will destroy and recreate this Resource.
      UNCHANGED: Infra Manager will leave this Resource untouched.
    """
    INTENT_UNSPECIFIED = 0
    CREATE = 1
    UPDATE = 2
    DELETE = 3
    RECREATE = 4
    UNCHANGED = 5

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. Current state of the resource.

    Values:
      STATE_UNSPECIFIED: The default value. This value is used if the state is
        omitted.
      PLANNED: Resource has been planned for reconcile.
      IN_PROGRESS: Resource is actively reconciling into the intended state.
      RECONCILED: Resource has reconciled to intended state.
      FAILED: Resource failed to reconcile.
    """
    STATE_UNSPECIFIED = 0
    PLANNED = 1
    IN_PROGRESS = 2
    RECONCILED = 3
    FAILED = 4

  @encoding.MapUnrecognizedFields('additionalProperties')
  class CaiAssetsValue(_messages.Message):
    r"""Output only. Map of Cloud Asset Inventory (CAI) type to CAI info (e.g.
    CAI ID). CAI type format follows https://cloud.google.com/asset-
    inventory/docs/supported-asset-types

    Messages:
      AdditionalProperty: An additional property for a CaiAssetsValue object.

    Fields:
      additionalProperties: Additional properties of type CaiAssetsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a CaiAssetsValue object.

      Fields:
        key: Name of the additional property.
        value: A ResourceCAIInfo attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('ResourceCAIInfo', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  caiAssets = _messages.MessageField('CaiAssetsValue', 1)
  intent = _messages.EnumField('IntentValueValuesEnum', 2)
  name = _messages.StringField(3)
  state = _messages.EnumField('StateValueValuesEnum', 4)
  terraformInfo = _messages.MessageField('ResourceTerraformInfo', 5)


class ResourceCAIInfo(_messages.Message):
  r"""CAI info of a Resource.

  Fields:
    fullResourceName: CAI resource name in the format following
      https://cloud.google.com/apis/design/resource_names#full_resource_name
  """

  fullResourceName = _messages.StringField(1)


class ResourceTerraformInfo(_messages.Message):
  r"""Terraform info of a Resource.

  Fields:
    address: TF resource address that uniquely identifies this resource within
      this deployment.
    id: ID attribute of the TF resource
    type: TF resource type
  """

  address = _messages.StringField(1)
  id = _messages.StringField(2)
  type = _messages.StringField(3)


class Revision(_messages.Message):
  r"""A child resource of a Deployment generated by a 'CreateDeployment' or
  'UpdateDeployment' call. Each Revision contains metadata pertaining to a
  snapshot of a particular Deployment.

  Enums:
    ActionValueValuesEnum: Output only. The action which created this revision
    ErrorCodeValueValuesEnum: Output only. Code describing any errors that may
      have occurred.
    QuotaValidationValueValuesEnum: Optional. Input to control quota checks
      for resources in terraform configuration files. There are limited
      resources on which quota validation applies.
    StateValueValuesEnum: Output only. Current state of the revision.

  Fields:
    action: Output only. The action which created this revision
    applyResults: Output only. Outputs and artifacts from applying a
      deployment.
    build: Output only. Cloud Build instance UUID associated with this
      revision.
    createTime: Output only. Time when the revision was created.
    errorCode: Output only. Code describing any errors that may have occurred.
    errorLogs: Output only. Location of Terraform error logs in Google Cloud
      Storage. Format: `gs://{bucket}/{object}`.
    importExistingResources: Output only. By default, Infra Manager will
      return a failure when Terraform encounters a 409 code (resource conflict
      error) during actuation. If this flag is set to true, Infra Manager will
      instead attempt to automatically import the resource into the Terraform
      state (for supported resource types) and continue actuation. Not all
      resource types are supported, refer to documentation.
    logs: Output only. Location of Revision operation logs in
      `gs://{bucket}/{object}` format.
    name: Revision name. Format:
      `projects/{project}/locations/{location}/deployments/{deployment}/
      revisions/{revision}`
    quotaValidation: Optional. Input to control quota checks for resources in
      terraform configuration files. There are limited resources on which
      quota validation applies.
    quotaValidationResults: Output only. Cloud Storage path containing quota
      validation results. This field is set when a user sets
      Deployment.quota_validation field to ENABLED or ENFORCED. Format:
      `gs://{bucket}/{object}`.
    serviceAccount: Output only. User-specified Service Account (SA) to be
      used as credential to manage resources. Format:
      `projects/{projectID}/serviceAccounts/{serviceAccount}`
    state: Output only. Current state of the revision.
    stateDetail: Output only. Additional info regarding the current state.
    terraformBlueprint: Output only. A blueprint described using Terraform's
      HashiCorp Configuration Language as a root module.
    tfErrors: Output only. Errors encountered when creating or updating this
      deployment. Errors are truncated to 10 entries, see `delete_results` and
      `error_logs` for full details.
    tfVersion: Output only. The version of Terraform used to create the
      Revision. It is in the format of "Major.Minor.Patch", for example,
      "1.3.10".
    tfVersionConstraint: Output only. The user-specified Terraform version
      constraint. Example: "=1.3.10".
    updateTime: Output only. Time when the revision was last modified.
    workerPool: Output only. The user-specified Cloud Build worker pool
      resource in which the Cloud Build job will execute. Format:
      `projects/{project}/locations/{location}/workerPools/{workerPoolId}`. If
      this field is unspecified, the default Cloud Build worker pool will be
      used.
  """

  class ActionValueValuesEnum(_messages.Enum):
    r"""Output only. The action which created this revision

    Values:
      ACTION_UNSPECIFIED: The default value. This value is used if the action
        is omitted.
      CREATE: The revision was generated by creating a deployment.
      UPDATE: The revision was generated by updating a deployment.
      DELETE: The revision was deleted.
    """
    ACTION_UNSPECIFIED = 0
    CREATE = 1
    UPDATE = 2
    DELETE = 3

  class ErrorCodeValueValuesEnum(_messages.Enum):
    r"""Output only. Code describing any errors that may have occurred.

    Values:
      ERROR_CODE_UNSPECIFIED: No error code was specified.
      CLOUD_BUILD_PERMISSION_DENIED: Cloud Build failed due to a permission
        issue.
      APPLY_BUILD_API_FAILED: Cloud Build job associated with creating or
        updating a deployment could not be started.
      APPLY_BUILD_RUN_FAILED: Cloud Build job associated with creating or
        updating a deployment was started but failed.
      QUOTA_VALIDATION_FAILED: quota validation failed for one or more
        resources in terraform configuration files.
    """
    ERROR_CODE_UNSPECIFIED = 0
    CLOUD_BUILD_PERMISSION_DENIED = 1
    APPLY_BUILD_API_FAILED = 2
    APPLY_BUILD_RUN_FAILED = 3
    QUOTA_VALIDATION_FAILED = 4

  class QuotaValidationValueValuesEnum(_messages.Enum):
    r"""Optional. Input to control quota checks for resources in terraform
    configuration files. There are limited resources on which quota validation
    applies.

    Values:
      QUOTA_VALIDATION_UNSPECIFIED: The default value. QuotaValidation on
        terraform configuration files will be disabled in this case.
      ENABLED: Enable computing quotas for resources in terraform
        configuration files to get visibility on resources with insufficient
        quotas.
      ENFORCED: Enforce quota checks so deployment fails if there isn't
        sufficient quotas available to deploy resources in terraform
        configuration files.
    """
    QUOTA_VALIDATION_UNSPECIFIED = 0
    ENABLED = 1
    ENFORCED = 2

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. Current state of the revision.

    Values:
      STATE_UNSPECIFIED: The default value. This value is used if the state is
        omitted.
      APPLYING: The revision is being applied.
      APPLIED: The revision was applied successfully.
      FAILED: The revision could not be applied successfully.
    """
    STATE_UNSPECIFIED = 0
    APPLYING = 1
    APPLIED = 2
    FAILED = 3

  action = _messages.EnumField('ActionValueValuesEnum', 1)
  applyResults = _messages.MessageField('ApplyResults', 2)
  build = _messages.StringField(3)
  createTime = _messages.StringField(4)
  errorCode = _messages.EnumField('ErrorCodeValueValuesEnum', 5)
  errorLogs = _messages.StringField(6)
  importExistingResources = _messages.BooleanField(7)
  logs = _messages.StringField(8)
  name = _messages.StringField(9)
  quotaValidation = _messages.EnumField('QuotaValidationValueValuesEnum', 10)
  quotaValidationResults = _messages.StringField(11)
  serviceAccount = _messages.StringField(12)
  state = _messages.EnumField('StateValueValuesEnum', 13)
  stateDetail = _messages.StringField(14)
  terraformBlueprint = _messages.MessageField('TerraformBlueprint', 15)
  tfErrors = _messages.MessageField('TerraformError', 16, repeated=True)
  tfVersion = _messages.StringField(17)
  tfVersionConstraint = _messages.StringField(18)
  updateTime = _messages.StringField(19)
  workerPool = _messages.StringField(20)


class SetIamPolicyRequest(_messages.Message):
  r"""Request message for `SetIamPolicy` method.

  Fields:
    policy: REQUIRED: The complete policy to be applied to the `resource`. The
      size of the policy is limited to a few 10s of KB. An empty policy is a
      valid policy but certain Google Cloud services (such as Projects) might
      reject them.
    updateMask: OPTIONAL: A FieldMask specifying which fields of the policy to
      modify. Only the fields in the mask will be modified. If no mask is
      provided, the following default mask is used: `paths: "bindings, etag"`
  """

  policy = _messages.MessageField('Policy', 1)
  updateMask = _messages.StringField(2)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class Statefile(_messages.Message):
  r"""Contains info about a Terraform state file

  Fields:
    signedUri: Output only. Cloud Storage signed URI used for downloading or
      uploading the state file.
  """

  signedUri = _messages.StringField(1)


class Status(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details. You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details. There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class TerraformBlueprint(_messages.Message):
  r"""TerraformBlueprint describes the source of a Terraform root module which
  describes the resources and configs to be deployed.

  Messages:
    InputValuesValue: Input variable values for the Terraform blueprint.

  Fields:
    gcsSource: URI of an object in Google Cloud Storage. Format:
      `gs://{bucket}/{object}` URI may also specify an object version for
      zipped objects. Format: `gs://{bucket}/{object}#{version}`
    gitSource: URI of a public Git repo.
    inputValues: Input variable values for the Terraform blueprint.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class InputValuesValue(_messages.Message):
    r"""Input variable values for the Terraform blueprint.

    Messages:
      AdditionalProperty: An additional property for a InputValuesValue
        object.

    Fields:
      additionalProperties: Additional properties of type InputValuesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a InputValuesValue object.

      Fields:
        key: Name of the additional property.
        value: A TerraformVariable attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('TerraformVariable', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  gcsSource = _messages.StringField(1)
  gitSource = _messages.MessageField('GitSource', 2)
  inputValues = _messages.MessageField('InputValuesValue', 3)


class TerraformError(_messages.Message):
  r"""Errors encountered during actuation using Terraform

  Fields:
    error: Original error response from underlying Google API, if available.
    errorDescription: A human-readable error description.
    httpResponseCode: HTTP response code returned from Google Cloud Platform
      APIs when Terraform fails to provision the resource. If unset or 0, no
      HTTP response code was returned by Terraform.
    resourceAddress: Address of the resource associated with the error, e.g.
      `google_compute_network.vpc_network`.
  """

  error = _messages.MessageField('Status', 1)
  errorDescription = _messages.StringField(2)
  httpResponseCode = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  resourceAddress = _messages.StringField(4)


class TerraformOutput(_messages.Message):
  r"""Describes a Terraform output.

  Fields:
    sensitive: Identifies whether Terraform has set this output as a potential
      sensitive value.
    value: Value of output.
  """

  sensitive = _messages.BooleanField(1)
  value = _messages.MessageField('extra_types.JsonValue', 2)


class TerraformVariable(_messages.Message):
  r"""A Terraform input variable.

  Fields:
    inputValue: Input variable value.
  """

  inputValue = _messages.MessageField('extra_types.JsonValue', 1)


class TerraformVersion(_messages.Message):
  r"""A TerraformVersion represents the support state the corresponding
  Terraform version.

  Enums:
    StateValueValuesEnum: Output only. The state of the version, ACTIVE,
      DEPRECATED or OBSOLETE.

  Fields:
    deprecateTime: Output only. When the version is deprecated.
    name: Identifier. The version name is in the format: 'projects/{project_id
      }/locations/{location}/terraformVersions/{terraform_version}'.
    obsoleteTime: Output only. When the version is obsolete.
    state: Output only. The state of the version, ACTIVE, DEPRECATED or
      OBSOLETE.
    supportTime: Output only. When the version is supported.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The state of the version, ACTIVE, DEPRECATED or OBSOLETE.

    Values:
      STATE_UNSPECIFIED: The default value. This value is used if the state is
        omitted.
      ACTIVE: The version is actively supported.
      DEPRECATED: The version is deprecated.
      OBSOLETE: The version is obsolete.
    """
    STATE_UNSPECIFIED = 0
    ACTIVE = 1
    DEPRECATED = 2
    OBSOLETE = 3

  deprecateTime = _messages.StringField(1)
  name = _messages.StringField(2)
  obsoleteTime = _messages.StringField(3)
  state = _messages.EnumField('StateValueValuesEnum', 4)
  supportTime = _messages.StringField(5)


class TestIamPermissionsRequest(_messages.Message):
  r"""Request message for `TestIamPermissions` method.

  Fields:
    permissions: The set of permissions to check for the `resource`.
      Permissions with wildcards (such as `*` or `storage.*`) are not allowed.
      For more information see [IAM
      Overview](https://cloud.google.com/iam/docs/overview#permissions).
  """

  permissions = _messages.StringField(1, repeated=True)


class TestIamPermissionsResponse(_messages.Message):
  r"""Response message for `TestIamPermissions` method.

  Fields:
    permissions: A subset of `TestPermissionsRequest.permissions` that the
      caller is allowed.
  """

  permissions = _messages.StringField(1, repeated=True)


class UnlockDeploymentRequest(_messages.Message):
  r"""A request to unlock a state file passed to a 'UnlockDeployment' call.

  Fields:
    lockId: Required. Lock ID of the lock file to be unlocked.
  """

  lockId = _messages.IntegerField(1)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
encoding.AddCustomJsonFieldMapping(
    ConfigProjectsLocationsDeploymentsGetIamPolicyRequest, 'options_requestedPolicyVersion', 'options.requestedPolicyVersion')
