package tfmigrate

import (
	"context"

	"github.com/minamijoyo/tfmigrate/tfexec"
)

// StateImportAction implements the StateAction interface.
// StateImportAction imports an existing resource to state.
// Note that the Terraform has terraform import command, not terraform state import command.
// According to the help of import command, this is because a future version
// Terraform will not only import state, but also generate configuration.
// We intentionally use term "StateImportAction" to clarify it imports state only.
type StateImportAction struct {
	// address is an address to import resource to.
	address string
	// id is a resource identifier to be imported.
	id string
}

var _ StateAction = (*StateImportAction)(nil)

// NewStateImportAction returns a new StateImportAction instance.
func NewStateImportAction(address string, id string) *StateImportAction {
	return &StateImportAction{
		address: address,
		id:      id,
	}
}

// StateUpdate updates a given state and returns a new state.
// It imports an existing resource to state.
func (a *StateImportAction) StateUpdate(ctx context.Context, tf tfexec.TerraformCLI, state *tfexec.State) (*tfexec.State, error) {
	// Disable unnecessary state backup here,
	// because we never restore state from the backup generated by each state action.
	return tf.Import(ctx, state, a.address, a.id, "-input=false", "-no-color", "-backup=/dev/null")
}
